/* -*- mode: C; c-basic-offset: 4; indent-tabs-mode: nil; -*- */
/* vim:set et sts=4: */
/* ibus - The Input Bus
 * Copyright (C) 2013 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright (C) 2013 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef __IBUS_COMPOSETABLE_H_
#define __IBUS_COMPOSETABLE_H_

/* The table is generated by ibus/src/gencomposetable
 *
 * if ibus_compose_seqs_a[N - 1] is an outputed compose character,
 * ibus_compose_seqs_a[N * 2 - 1] is also an outputed compose character.
 * and ibus_compose_seqs_a[0] to ibus_compose_seqs_a[0 + N - 3] are the
 * sequences and call ibus_engine_simple_add_table:
 * ibus_engine_simple_add_table(engine, ibus_compose_seqs_a,
 *                              N - 2, G_N_ELEMENTS(ibus_compose_seqs_a) / N)
 * The compose sequences are allowed within G_MAXUINT16 */

typedef struct _IBusComposeTable IBusComposeTable;
struct _IBusComposeTable
{
    const guint16 *data;
    gint max_seq_len;
    gint n_seqs;
};

typedef struct _IBusComposeTableLocaleList IBusComposeTableLocaleList;
struct _IBusComposeTableLocaleList
{
    const gchar *locale;
    const IBusComposeTable *table;
};

static const guint16 ibus_compose_seqs_am_et[] = {
  /* Not sure if am_ET compose file is useful. It uses ASCII key
   * at first but not compose keys.
   * Comment out am_compose_seqs until get the request. */
  0
};

static const IBusComposeTable ibus_compose_table_am_et = {
    ibus_compose_seqs_am_et,
    0,
    0
};

static const guint16 ibus_compose_seqs_el_gr[] = {
  IBUS_KEY_dead_grave, IBUS_KEY_space, 0, 0, 0,
    0, 0x1FEF, /* U1fef */
  IBUS_KEY_dead_grave, IBUS_KEY_underscore, 0, 0, 0,
    0, 0x0060, /* grave */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_grave, 0, 0, 0,
    0, 0x1FEF, /* U1fef */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_diaeresis, IBUS_KEY_space, 0, 0,
    0, 0x1FED, /* U1fed */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_space, 0, 0,
    0, 0x1FDD, /* U1fdd */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0B, /* U1f0b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1B, /* U1f1b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2B, /* U1f2b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3B, /* U1f3b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4B, /* U1f4b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_UPSILON, 0, 0,
    0, 0x1F5B, /* U1f5b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6B, /* U1f6b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F03, /* U1f03 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F13, /* U1f13 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F23, /* U1f23 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F33, /* U1f33 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F43, /* U1f43 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F53, /* U1f53 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F63, /* U1f63 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_space, 0, 0,
    0, 0x1FCD, /* U1fcd */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0A, /* U1f0a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1A, /* U1f1a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2A, /* U1f2a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3A, /* U1f3a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4A, /* U1f4a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6A, /* U1f6a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F02, /* U1f02 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F12, /* U1f12 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F22, /* U1f22 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F32, /* U1f32 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F42, /* U1f42 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F52, /* U1f52 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F62, /* U1f62 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_psili, IBUS_KEY_space, 0, 0,
    0, 0x1FCD, /* U1fcd */
  IBUS_KEY_dead_grave, IBUS_KEY_dead_dasia, IBUS_KEY_space, 0, 0,
    0, 0x1FDD, /* U1fdd */
  IBUS_KEY_dead_acute, IBUS_KEY_space, 0, 0, 0,
    0, 0x0384, /* U0384 */
  IBUS_KEY_dead_acute, IBUS_KEY_period, 0, 0, 0,
    0, 0x00B7, /* periodcentered */
  IBUS_KEY_dead_acute, IBUS_KEY_less, 0, 0, 0,
    0, 0x00AB, /* guillemotleft */
  IBUS_KEY_dead_acute, IBUS_KEY_greater, 0, 0, 0,
    0, 0x00BB, /* guillemotright */
  IBUS_KEY_dead_acute, IBUS_KEY_underscore, 0, 0, 0,
    0, 0x00B4, /* acute */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_acute, 0, 0, 0,
    0, 0x0384, /* U0384 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_space, 0, 0,
    0, 0x1FDE, /* U1fde */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0D, /* U1f0d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1D, /* U1f1d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2D, /* U1f2d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3D, /* U1f3d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4D, /* U1f4d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_UPSILON, 0, 0,
    0, 0x1F5D, /* U1f5d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6D, /* U1f6d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F05, /* U1f05 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F15, /* U1f15 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F25, /* U1f25 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F35, /* U1f35 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F45, /* U1f45 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F55, /* U1f55 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F65, /* U1f65 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_space, 0, 0,
    0, 0x1FCE, /* U1fce */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0C, /* U1f0c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1C, /* U1f1c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2C, /* U1f2c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3C, /* U1f3c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4C, /* U1f4c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6C, /* U1f6c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F04, /* U1f04 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F14, /* U1f14 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F24, /* U1f24 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F34, /* U1f34 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F44, /* U1f44 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F54, /* U1f54 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F64, /* U1f64 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_psili, IBUS_KEY_space, 0, 0,
    0, 0x1FCE, /* U1fce */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_dasia, IBUS_KEY_space, 0, 0,
    0, 0x1FDE, /* U1fde */
  IBUS_KEY_dead_tilde, IBUS_KEY_space, 0, 0, 0,
    0, 0x1FC0, /* U1fc0 */
  IBUS_KEY_dead_tilde, IBUS_KEY_underscore, 0, 0, 0,
    0, 0x007E, /* asciitilde */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_tilde, 0, 0, 0,
    0, 0x1FC0, /* U1fc0 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_diaeresis, IBUS_KEY_space, 0, 0,
    0, 0x1FC1, /* U1fc1 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_space, 0, 0,
    0, 0x1FDF, /* U1fdf */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0F, /* U1f0f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2F, /* U1f2f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3F, /* U1f3f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_UPSILON, 0, 0,
    0, 0x1F5F, /* U1f5f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6F, /* U1f6f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F07, /* U1f07 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F27, /* U1f27 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F37, /* U1f37 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F57, /* U1f57 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F67, /* U1f67 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_space, 0, 0,
    0, 0x1FCF, /* U1fcf */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0E, /* U1f0e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2E, /* U1f2e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3E, /* U1f3e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6E, /* U1f6e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F06, /* U1f06 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F26, /* U1f26 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F36, /* U1f36 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F56, /* U1f56 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F66, /* U1f66 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_psili, IBUS_KEY_space, 0, 0,
    0, 0x1FCF, /* U1fcf */
  IBUS_KEY_dead_tilde, IBUS_KEY_dead_dasia, IBUS_KEY_space, 0, 0,
    0, 0x1FDF, /* U1fdf */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_space, 0, 0, 0,
    0, 0x00A8, /* diaeresis */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_period, 0, 0, 0,
    0, 0x00B7, /* periodcentered */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_less, 0, 0, 0,
    0, 0x00AB, /* guillemotleft */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_greater, 0, 0, 0,
    0, 0x00BB, /* guillemotright */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_dead_grave, IBUS_KEY_space, 0, 0,
    0, 0x1FED, /* U1fed */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_dead_tilde, IBUS_KEY_space, 0, 0,
    0, 0x1FC1, /* U1fc1 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_space, 0, 0, 0,
    0, 0x1FFE, /* U1ffe */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0, 0, 0,
    0, 0x1F09, /* U1f09 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_EPSILON, 0, 0, 0,
    0, 0x1F19, /* U1f19 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0, 0, 0,
    0, 0x1F29, /* U1f29 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_IOTA, 0, 0, 0,
    0, 0x1F39, /* U1f39 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMICRON, 0, 0, 0,
    0, 0x1F49, /* U1f49 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_RHO, 0, 0, 0,
    0, 0x1FEC, /* U1fec */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_UPSILON, 0, 0, 0,
    0, 0x1F59, /* U1f59 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0, 0, 0,
    0, 0x1F69, /* U1f69 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0, 0, 0,
    0, 0x1F01, /* U1f01 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_epsilon, 0, 0, 0,
    0, 0x1F11, /* U1f11 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0, 0, 0,
    0, 0x1F21, /* U1f21 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_iota, 0, 0, 0,
    0, 0x1F31, /* U1f31 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omicron, 0, 0, 0,
    0, 0x1F41, /* U1f41 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_rho, 0, 0, 0,
    0, 0x1FE5, /* U1fe5 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_upsilon, 0, 0, 0,
    0, 0x1F51, /* U1f51 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0, 0, 0,
    0, 0x1F61, /* U1f61 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_space, 0, 0,
    0, 0x1FDD, /* U1fdd */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0B, /* U1f0b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1B, /* U1f1b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2B, /* U1f2b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3B, /* U1f3b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4B, /* U1f4b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_UPSILON, 0, 0,
    0, 0x1F5B, /* U1f5b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6B, /* U1f6b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F03, /* U1f03 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F13, /* U1f13 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F23, /* U1f23 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F33, /* U1f33 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F43, /* U1f43 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F53, /* U1f53 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F63, /* U1f63 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_space, 0, 0,
    0, 0x1FDE, /* U1fde */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0D, /* U1f0d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1D, /* U1f1d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2D, /* U1f2d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3D, /* U1f3d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4D, /* U1f4d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_UPSILON, 0, 0,
    0, 0x1F5D, /* U1f5d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6D, /* U1f6d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F05, /* U1f05 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F15, /* U1f15 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F25, /* U1f25 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F35, /* U1f35 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F45, /* U1f45 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F55, /* U1f55 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F65, /* U1f65 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_space, 0, 0,
    0, 0x1FDF, /* U1fdf */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0F, /* U1f0f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2F, /* U1f2f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3F, /* U1f3f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_UPSILON, 0, 0,
    0, 0x1F5F, /* U1f5f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6F, /* U1f6f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F07, /* U1f07 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F27, /* U1f27 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F37, /* U1f37 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F57, /* U1f57 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F67, /* U1f67 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_ogonek, 0, 0, 0,
    0, 0x1FFE, /* U1ffe */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F89, /* U1f89 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F99, /* U1f99 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1FA9, /* U1fa9 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F81, /* U1f81 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F91, /* U1f91 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1FA1, /* U1fa1 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_eta, 0,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_eta, 0,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_eta, 0,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_dead_ogonek, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_dead_iota, IBUS_KEY_underscore, 0, 0, 0,
    0, 0x1FBE, /* U1fbe */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F89, /* U1f89 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F99, /* U1f99 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1FA9, /* U1fa9 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F81, /* U1f81 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F91, /* U1f91 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1FA1, /* U1fa1 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_eta, 0,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_eta, 0,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_eta, 0,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_ogonek, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F88, /* U1f88 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F98, /* U1f98 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1FA8, /* U1fa8 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F80, /* U1f80 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F90, /* U1f90 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1FA0, /* U1fa0 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_eta, 0,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_eta, 0,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_eta, 0,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_dead_horn, IBUS_KEY_space, 0, 0, 0,
    0, 0x1FBF, /* U1fbf */
  IBUS_KEY_dead_horn, IBUS_KEY_underscore, 0, 0, 0,
    0, 0x1FBD, /* U1fbd */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_ALPHA, 0, 0, 0,
    0, 0x1F08, /* U1f08 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_EPSILON, 0, 0, 0,
    0, 0x1F18, /* U1f18 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_ETA, 0, 0, 0,
    0, 0x1F28, /* U1f28 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_IOTA, 0, 0, 0,
    0, 0x1F38, /* U1f38 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMICRON, 0, 0, 0,
    0, 0x1F48, /* U1f48 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_OMEGA, 0, 0, 0,
    0, 0x1F68, /* U1f68 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_alpha, 0, 0, 0,
    0, 0x1F00, /* U1f00 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_epsilon, 0, 0, 0,
    0, 0x1F10, /* U1f10 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_eta, 0, 0, 0,
    0, 0x1F20, /* U1f20 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_iota, 0, 0, 0,
    0, 0x1F30, /* U1f30 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_omicron, 0, 0, 0,
    0, 0x1F40, /* U1f40 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_rho, 0, 0, 0,
    0, 0x1FE4, /* U1fe4 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_upsilon, 0, 0, 0,
    0, 0x1F50, /* U1f50 */
  IBUS_KEY_dead_horn, IBUS_KEY_Greek_omega, 0, 0, 0,
    0, 0x1F60, /* U1f60 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_space, 0, 0,
    0, 0x1FCD, /* U1fcd */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0A, /* U1f0a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1A, /* U1f1a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2A, /* U1f2a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3A, /* U1f3a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4A, /* U1f4a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6A, /* U1f6a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F02, /* U1f02 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F12, /* U1f12 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F22, /* U1f22 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F32, /* U1f32 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F42, /* U1f42 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F52, /* U1f52 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F62, /* U1f62 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_grave, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_space, 0, 0,
    0, 0x1FCE, /* U1fce */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0C, /* U1f0c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F1C, /* U1f1c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2C, /* U1f2c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3C, /* U1f3c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F4C, /* U1f4c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6C, /* U1f6c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F04, /* U1f04 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F14, /* U1f14 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F24, /* U1f24 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F34, /* U1f34 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F44, /* U1f44 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F54, /* U1f54 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F64, /* U1f64 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_acute, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_space, 0, 0,
    0, 0x1FCF, /* U1fcf */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F0E, /* U1f0e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F2E, /* U1f2e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F3E, /* U1f3e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F6E, /* U1f6e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F06, /* U1f06 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F26, /* U1f26 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F36, /* U1f36 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F56, /* U1f56 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F66, /* U1f66 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_tilde, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F88, /* U1f88 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F98, /* U1f98 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1FA8, /* U1fa8 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F80, /* U1f80 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F90, /* U1f90 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1FA0, /* U1fa0 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_eta, 0,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_eta, 0,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_eta, 0,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_iota, IBUS_KEY_dead_tilde, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_dead_horn, IBUS_KEY_dead_horn, 0, 0, 0,
    0, 0x1FBF, /* U1fbf */
  IBUS_KEY_dead_psili, IBUS_KEY_space, 0, 0, 0,
    0, 0x1FBF, /* U1fbf */
  IBUS_KEY_dead_psili, IBUS_KEY_underscore, 0, 0, 0,
    0, 0x1FBD, /* U1fbd */
  IBUS_KEY_dead_psili, IBUS_KEY_dead_grave, IBUS_KEY_space, 0, 0,
    0, 0x1FCD, /* U1fcd */
  IBUS_KEY_dead_psili, IBUS_KEY_dead_acute, IBUS_KEY_space, 0, 0,
    0, 0x1FCE, /* U1fce */
  IBUS_KEY_dead_psili, IBUS_KEY_dead_tilde, IBUS_KEY_space, 0, 0,
    0, 0x1FCF, /* U1fcf */
  IBUS_KEY_dead_psili, IBUS_KEY_dead_horn, 0, 0, 0,
    0, 0x1FBF, /* U1fbf */
  IBUS_KEY_dead_dasia, IBUS_KEY_space, 0, 0, 0,
    0, 0x1FFE, /* U1ffe */
  IBUS_KEY_dead_dasia, IBUS_KEY_dead_grave, IBUS_KEY_space, 0, 0,
    0, 0x1FDD, /* U1fdd */
  IBUS_KEY_dead_dasia, IBUS_KEY_dead_acute, IBUS_KEY_space, 0, 0,
    0, 0x1FDE, /* U1fde */
  IBUS_KEY_dead_dasia, IBUS_KEY_dead_tilde, IBUS_KEY_space, 0, 0,
    0, 0x1FDF, /* U1fdf */
  IBUS_KEY_dead_dasia, IBUS_KEY_dead_ogonek, 0, 0, 0,
    0, 0x1FFE, /* U1ffe */
  IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_S, 0, 0,
    0, 0x00A7, /* section */
  IBUS_KEY_Multi_key, IBUS_KEY_exclam, IBUS_KEY_s, 0, 0,
    0, 0x00A7, /* section */
  IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_grave, IBUS_KEY_Greek_iota, 0,
    0, 0x1FD2, /* U1fd2 */
  IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_grave, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1FE2, /* U1fe2 */
  IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_asciitilde, IBUS_KEY_Greek_iota, 0,
    0, 0x1FD7, /* U1fd7 */
  IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_asciitilde, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1FE7, /* U1fe7 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_space, 0,
    0, 0x2018, /* leftsinglequotemark */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0D, /* U1f0d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1D, /* U1f1d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2D, /* U1f2d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3D, /* U1f3d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4D, /* U1f4d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_UPSILON, 0,
    0, 0x1F5D, /* U1f5d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6D, /* U1f6d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F05, /* U1f05 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F15, /* U1f15 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_eta, 0,
    0, 0x1F25, /* U1f25 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_iota, 0,
    0, 0x1F35, /* U1f35 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F45, /* U1f45 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F55, /* U1f55 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_omega, 0,
    0, 0x1F65, /* U1f65 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_space, 0,
    0, 0x2019, /* rightsinglequotemark */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0C, /* U1f0c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1C, /* U1f1c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2C, /* U1f2c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3C, /* U1f3c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4C, /* U1f4c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6C, /* U1f6c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F04, /* U1f04 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F14, /* U1f14 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_eta, 0,
    0, 0x1F24, /* U1f24 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_iota, 0,
    0, 0x1F34, /* U1f34 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F44, /* U1f44 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F54, /* U1f54 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_omega, 0,
    0, 0x1F64, /* U1f64 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ETA,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_alpha,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_eta,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_omega,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ETA,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_alpha,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_eta,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_omega,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_alpha, 0,
    0, 0x1FB4, /* U1fb4 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_eta, 0,
    0, 0x1FC4, /* U1fc4 */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_omega, 0,
    0, 0x1FF4, /* U1ff4 */
  IBUS_KEY_Multi_key, IBUS_KEY_minus, IBUS_KEY_minus, 0, 0,
    0, 0x00AD, /* hyphen */
  IBUS_KEY_Multi_key, IBUS_KEY_minus, IBUS_KEY_D, 0, 0,
    0, 0x00D0, /* ETH */
  IBUS_KEY_Multi_key, IBUS_KEY_minus, IBUS_KEY_a, 0, 0,
    0, 0x00E3, /* atilde */
  IBUS_KEY_Multi_key, IBUS_KEY_minus, IBUS_KEY_d, 0, 0,
    0, 0x00F0, /* eth */
  IBUS_KEY_Multi_key, IBUS_KEY_minus, IBUS_KEY_o, 0, 0,
    0, 0x00F5, /* otilde */
  IBUS_KEY_Multi_key, IBUS_KEY_slash, IBUS_KEY_slash, 0, 0,
    0, 0x0374, /* U0374 */
  IBUS_KEY_Multi_key, IBUS_KEY_slash, IBUS_KEY_C, 0, 0,
    0, 0x00A2, /* cent */
  IBUS_KEY_Multi_key, IBUS_KEY_colon, IBUS_KEY_colon, 0, 0,
    0, 0x0387, /* U0387 */
  IBUS_KEY_Multi_key, IBUS_KEY_semicolon, IBUS_KEY_semicolon, 0, 0,
    0, 0x037E, /* U037e */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_space, 0,
    0, 0x2018, /* leftsinglequotemark */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0D, /* U1f0d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1D, /* U1f1d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2D, /* U1f2d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3D, /* U1f3d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4D, /* U1f4d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_UPSILON, 0,
    0, 0x1F5D, /* U1f5d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6D, /* U1f6d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F05, /* U1f05 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F15, /* U1f15 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta, 0,
    0, 0x1F25, /* U1f25 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_iota, 0,
    0, 0x1F35, /* U1f35 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F45, /* U1f45 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F55, /* U1f55 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega, 0,
    0, 0x1F65, /* U1f65 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0B, /* U1f0b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1B, /* U1f1b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2B, /* U1f2b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3B, /* U1f3b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4B, /* U1f4b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_UPSILON, 0,
    0, 0x1F5B, /* U1f5b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6B, /* U1f6b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F03, /* U1f03 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F13, /* U1f13 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_eta, 0,
    0, 0x1F23, /* U1f23 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_iota, 0,
    0, 0x1F33, /* U1f33 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F43, /* U1f43 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F53, /* U1f53 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_omega, 0,
    0, 0x1F63, /* U1f63 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ETA,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_ETA,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_alpha,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_eta,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_omega,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ETA,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F89, /* U1f89 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F99, /* U1f99 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FA9, /* U1fa9 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F81, /* U1f81 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_eta, 0,
    0, 0x1F91, /* U1f91 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA1, /* U1fa1 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0F, /* U1f0f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2F, /* U1f2f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3F, /* U1f3f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_UPSILON, 0,
    0, 0x1F5F, /* U1f5f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6F, /* U1f6f */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F07, /* U1f07 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta, 0,
    0, 0x1F27, /* U1f27 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_iota, 0,
    0, 0x1F37, /* U1f37 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F57, /* U1f57 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega, 0,
    0, 0x1F67, /* U1f67 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F09, /* U1f09 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F19, /* U1f19 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F29, /* U1f29 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F39, /* U1f39 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F49, /* U1f49 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_RHO, 0, 0,
    0, 0x1FEC, /* U1fec */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_UPSILON, 0, 0,
    0, 0x1F59, /* U1f59 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F69, /* U1f69 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F01, /* U1f01 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F11, /* U1f11 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F21, /* U1f21 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F31, /* U1f31 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F41, /* U1f41 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_rho, 0, 0,
    0, 0x1FE5, /* U1fe5 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F51, /* U1f51 */
  IBUS_KEY_Multi_key, IBUS_KEY_less, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F61, /* U1f61 */
  IBUS_KEY_Multi_key, IBUS_KEY_equal, IBUS_KEY_L, 0, 0,
    0, 0x00A3, /* sterling */
  IBUS_KEY_Multi_key, IBUS_KEY_equal, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x20AC, /* EuroSign */
  IBUS_KEY_Multi_key, IBUS_KEY_equal, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x20AC, /* EuroSign */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_space, 0,
    0, 0x2019, /* rightsinglequotemark */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0C, /* U1f0c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1C, /* U1f1c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2C, /* U1f2c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3C, /* U1f3c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4C, /* U1f4c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6C, /* U1f6c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F04, /* U1f04 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F14, /* U1f14 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta, 0,
    0, 0x1F24, /* U1f24 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_iota, 0,
    0, 0x1F34, /* U1f34 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F44, /* U1f44 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F54, /* U1f54 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega, 0,
    0, 0x1F64, /* U1f64 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0A, /* U1f0a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1A, /* U1f1a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2A, /* U1f2a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3A, /* U1f3a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4A, /* U1f4a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6A, /* U1f6a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F02, /* U1f02 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F12, /* U1f12 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_eta, 0,
    0, 0x1F22, /* U1f22 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_iota, 0,
    0, 0x1F32, /* U1f32 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F42, /* U1f42 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F52, /* U1f52 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_omega, 0,
    0, 0x1F62, /* U1f62 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ETA,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_ETA,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_alpha,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_eta,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_omega,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ETA,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F88, /* U1f88 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F98, /* U1f98 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FA8, /* U1fa8 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F80, /* U1f80 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_eta, 0,
    0, 0x1F90, /* U1f90 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA0, /* U1fa0 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0E, /* U1f0e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2E, /* U1f2e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3E, /* U1f3e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6E, /* U1f6e */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F06, /* U1f06 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta, 0,
    0, 0x1F26, /* U1f26 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_iota, 0,
    0, 0x1F36, /* U1f36 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F56, /* U1f56 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega, 0,
    0, 0x1F66, /* U1f66 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1F08, /* U1f08 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_EPSILON, 0, 0,
    0, 0x1F18, /* U1f18 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1F28, /* U1f28 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_IOTA, 0, 0,
    0, 0x1F38, /* U1f38 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_OMICRON, 0, 0,
    0, 0x1F48, /* U1f48 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1F68, /* U1f68 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1F00, /* U1f00 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_epsilon, 0, 0,
    0, 0x1F10, /* U1f10 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1F20, /* U1f20 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_iota, 0, 0,
    0, 0x1F30, /* U1f30 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_omicron, 0, 0,
    0, 0x1F40, /* U1f40 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_rho, 0, 0,
    0, 0x1FE4, /* U1fe4 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_upsilon, 0, 0,
    0, 0x1F50, /* U1f50 */
  IBUS_KEY_Multi_key, IBUS_KEY_greater, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1F60, /* U1f60 */
  IBUS_KEY_Multi_key, IBUS_KEY_question, IBUS_KEY_exclam, 0, 0,
    0, 0x203D, /* U203D # INTERROBANG */
  IBUS_KEY_Multi_key, IBUS_KEY_A, IBUS_KEY_O, 0, 0,
    0, 0x00C5, /* Aring */
  IBUS_KEY_Multi_key, IBUS_KEY_B, IBUS_KEY_V, 0, 0,
    0, 0x00A6, /* brokenbar */
  IBUS_KEY_Multi_key, IBUS_KEY_C, IBUS_KEY_slash, 0, 0,
    0, 0x00A2, /* cent */
  IBUS_KEY_Multi_key, IBUS_KEY_C, IBUS_KEY_cedilla, 0, 0,
    0, 0x00C7, /* Ccedilla */
  IBUS_KEY_Multi_key, IBUS_KEY_D, IBUS_KEY_minus, 0, 0,
    0, 0x00D0, /* ETH */
  IBUS_KEY_Multi_key, IBUS_KEY_V, IBUS_KEY_B, 0, 0,
    0, 0x00A6, /* brokenbar */
  IBUS_KEY_Multi_key, IBUS_KEY_backslash, IBUS_KEY_backslash, 0, 0,
    0, 0x0375, /* U0375 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_exclam, 0, 0,
    0, 0x00A6, /* brokenbar */
  IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_0, 0, 0,
    0, 0x00B0, /* degree */
  IBUS_KEY_Multi_key, IBUS_KEY_asciicircum, IBUS_KEY_asciicircum, 0, 0,
    0, 0x02D8, /* breve */
  IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_A, 0, 0,
    0, 0x00AA, /* ordfeminine */
  IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_O, 0, 0,
    0, 0x00BA, /* masculine */
  IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_a, 0, 0,
    0, 0x00AA, /* ordfeminine */
  IBUS_KEY_Multi_key, IBUS_KEY_underscore, IBUS_KEY_o, 0, 0,
    0, 0x00BA, /* masculine */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0B, /* U1f0b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1B, /* U1f1b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2B, /* U1f2b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3B, /* U1f3b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4B, /* U1f4b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_UPSILON, 0,
    0, 0x1F5B, /* U1f5b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6B, /* U1f6b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F03, /* U1f03 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F13, /* U1f13 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_eta, 0,
    0, 0x1F23, /* U1f23 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_iota, 0,
    0, 0x1F33, /* U1f33 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F43, /* U1f43 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F53, /* U1f53 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_omega, 0,
    0, 0x1F63, /* U1f63 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0A, /* U1f0a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_EPSILON, 0,
    0, 0x1F1A, /* U1f1a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2A, /* U1f2a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3A, /* U1f3a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_OMICRON, 0,
    0, 0x1F4A, /* U1f4a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6A, /* U1f6a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F02, /* U1f02 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_epsilon, 0,
    0, 0x1F12, /* U1f12 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_eta, 0,
    0, 0x1F22, /* U1f22 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_iota, 0,
    0, 0x1F32, /* U1f32 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_omicron, 0,
    0, 0x1F42, /* U1f42 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F52, /* U1f52 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_omega, 0,
    0, 0x1F62, /* U1f62 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ETA,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_alpha,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_eta,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_omega,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ETA,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_alpha,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_eta,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_omega,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_alpha, 0,
    0, 0x1FB2, /* U1fb2 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_eta, 0,
    0, 0x1FC2, /* U1fc2 */
  IBUS_KEY_Multi_key, IBUS_KEY_grave, IBUS_KEY_bar, IBUS_KEY_Greek_omega, 0,
    0, 0x1FF2, /* U1ff2 */
  IBUS_KEY_Multi_key, IBUS_KEY_a, IBUS_KEY_minus, 0, 0,
    0, 0x00E3, /* atilde */
  IBUS_KEY_Multi_key, IBUS_KEY_a, IBUS_KEY_o, 0, 0,
    0, 0x00E5, /* aring */
  IBUS_KEY_Multi_key, IBUS_KEY_b, IBUS_KEY_v, 0, 0,
    0, 0x00A6, /* brokenbar */
  IBUS_KEY_Multi_key, IBUS_KEY_c, IBUS_KEY_O, 0, 0,
    0, 0x00A9, /* copyright */
  IBUS_KEY_Multi_key, IBUS_KEY_c, IBUS_KEY_o, 0, 0,
    0, 0x00A9, /* copyright */
  IBUS_KEY_Multi_key, IBUS_KEY_c, IBUS_KEY_cedilla, 0, 0,
    0, 0x00E7, /* ccedilla */
  IBUS_KEY_Multi_key, IBUS_KEY_d, IBUS_KEY_minus, 0, 0,
    0, 0x00F0, /* eth */
  IBUS_KEY_Multi_key, IBUS_KEY_o, IBUS_KEY_minus, 0, 0,
    0, 0x00F5, /* otilde */
  IBUS_KEY_Multi_key, IBUS_KEY_v, IBUS_KEY_b, 0, 0,
    0, 0x00A6, /* brokenbar */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_ETA,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_alpha,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_eta,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_less, IBUS_KEY_Greek_omega,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_ETA,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_alpha,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_eta,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_greater, IBUS_KEY_Greek_omega,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha, 0,
    0, 0x1FB4, /* U1fb4 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta, 0,
    0, 0x1FC4, /* U1fc4 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega, 0,
    0, 0x1FF4, /* U1ff4 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8D, /* U1f8d */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ETA,
    0, 0x1F9D, /* U1f9d */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAD, /* U1fad */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha,
    0, 0x1F85, /* U1f85 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta,
    0, 0x1F95, /* U1f95 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega,
    0, 0x1FA5, /* U1fa5 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_ETA,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_alpha,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_eta,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_grave, IBUS_KEY_Greek_omega,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ETA,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F89, /* U1f89 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F99, /* U1f99 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FA9, /* U1fa9 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F81, /* U1f81 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_eta, 0,
    0, 0x1F91, /* U1f91 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA1, /* U1fa1 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8C, /* U1f8c */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_ETA,
    0, 0x1F9C, /* U1f9c */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAC, /* U1fac */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_alpha,
    0, 0x1F84, /* U1f84 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_eta,
    0, 0x1F94, /* U1f94 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_apostrophe, IBUS_KEY_Greek_omega,
    0, 0x1FA4, /* U1fa4 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_ETA,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_alpha,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_eta,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_grave, IBUS_KEY_Greek_omega,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_ETA,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F88, /* U1f88 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F98, /* U1f98 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1FA8, /* U1fa8 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F80, /* U1f80 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_eta, 0,
    0, 0x1F90, /* U1f90 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_omega, 0,
    0, 0x1FA0, /* U1fa0 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8B, /* U1f8b */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_ETA,
    0, 0x1F9B, /* U1f9b */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAB, /* U1fab */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_alpha,
    0, 0x1F83, /* U1f83 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_eta,
    0, 0x1F93, /* U1f93 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_less, IBUS_KEY_Greek_omega,
    0, 0x1FA3, /* U1fa3 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8A, /* U1f8a */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_ETA,
    0, 0x1F9A, /* U1f9a */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAA, /* U1faa */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_alpha,
    0, 0x1F82, /* U1f82 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_eta,
    0, 0x1F92, /* U1f92 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_greater, IBUS_KEY_Greek_omega,
    0, 0x1FA2, /* U1fa2 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_alpha, 0,
    0, 0x1FB2, /* U1fb2 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_eta, 0,
    0, 0x1FC2, /* U1fc2 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_grave, IBUS_KEY_Greek_omega, 0,
    0, 0x1FF2, /* U1ff2 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_bar, 0, 0,
    0, 0x00A6, /* brokenbar */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_ETA,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_alpha,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_eta,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_omega,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_ETA,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_alpha,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_eta,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_omega,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_alpha, 0,
    0, 0x1FB7, /* U1fb7 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_eta, 0,
    0, 0x1FC7, /* U1fc7 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_asciitilde, IBUS_KEY_Greek_omega, 0,
    0, 0x1FF7, /* U1ff7 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA, 0, 0,
    0, 0x1FBC, /* U1fbc */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_Greek_ETA, 0, 0,
    0, 0x1FCC, /* U1fcc */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA, 0, 0,
    0, 0x1FFC, /* U1ffc */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_Greek_alpha, 0, 0,
    0, 0x1FB3, /* U1fb3 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_Greek_eta, 0, 0,
    0, 0x1FC3, /* U1fc3 */
  IBUS_KEY_Multi_key, IBUS_KEY_bar, IBUS_KEY_Greek_omega, 0, 0,
    0, 0x1FF3, /* U1ff3 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0F, /* U1f0f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2F, /* U1f2f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3F, /* U1f3f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_UPSILON, 0,
    0, 0x1F5F, /* U1f5f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6F, /* U1f6f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F07, /* U1f07 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_eta, 0,
    0, 0x1F27, /* U1f27 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_iota, 0,
    0, 0x1F37, /* U1f37 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F57, /* U1f57 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_less, IBUS_KEY_Greek_omega, 0,
    0, 0x1F67, /* U1f67 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_ETA,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_alpha,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_eta,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_bar, IBUS_KEY_Greek_omega,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA, 0,
    0, 0x1F0E, /* U1f0e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_ETA, 0,
    0, 0x1F2E, /* U1f2e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_IOTA, 0,
    0, 0x1F3E, /* U1f3e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA, 0,
    0, 0x1F6E, /* U1f6e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_alpha, 0,
    0, 0x1F06, /* U1f06 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_eta, 0,
    0, 0x1F26, /* U1f26 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_iota, 0,
    0, 0x1F36, /* U1f36 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_upsilon, 0,
    0, 0x1F56, /* U1f56 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_greater, IBUS_KEY_Greek_omega, 0,
    0, 0x1F66, /* U1f66 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8F, /* U1f8f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_ETA,
    0, 0x1F9F, /* U1f9f */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAF, /* U1faf */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_alpha,
    0, 0x1F87, /* U1f87 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_eta,
    0, 0x1F97, /* U1f97 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_less, IBUS_KEY_Greek_omega,
    0, 0x1FA7, /* U1fa7 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ALPHA,
    0, 0x1F8E, /* U1f8e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_ETA,
    0, 0x1F9E, /* U1f9e */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_OMEGA,
    0, 0x1FAE, /* U1fae */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_alpha,
    0, 0x1F86, /* U1f86 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_eta,
    0, 0x1F96, /* U1f96 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_greater, IBUS_KEY_Greek_omega,
    0, 0x1FA6, /* U1fa6 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_alpha, 0,
    0, 0x1FB7, /* U1fb7 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_eta, 0,
    0, 0x1FC7, /* U1fc7 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_bar, IBUS_KEY_Greek_omega, 0,
    0, 0x1FF7, /* U1ff7 */
  IBUS_KEY_Multi_key, IBUS_KEY_asciitilde, IBUS_KEY_asciitilde, 0, 0,
    0, 0x2015, /* Greek_horizbar */
  IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_C, 0, 0,
    0, 0x00C7, /* Ccedilla */
  IBUS_KEY_Multi_key, IBUS_KEY_acute, IBUS_KEY_c, 0, 0,
    0, 0x00E7, /* ccedilla */
  IBUS_KEY_Multi_key, IBUS_KEY_Greek_DELTA, IBUS_KEY_Greek_RHO, 0, 0,
    0, 0x20AF, /* U20af */
  IBUS_KEY_Multi_key, IBUS_KEY_Greek_DELTA, IBUS_KEY_Greek_rho, 0, 0,
    0, 0x20AF, /* U20af */
  IBUS_KEY_Multi_key, IBUS_KEY_Greek_EPSILON, IBUS_KEY_equal, 0, 0,
    0, 0x20AC, /* EuroSign */
  IBUS_KEY_Multi_key, IBUS_KEY_Greek_delta, IBUS_KEY_Greek_RHO, 0, 0,
    0, 0x20AF, /* U20af */
  IBUS_KEY_Multi_key, IBUS_KEY_Greek_delta, IBUS_KEY_Greek_rho, 0, 0,
    0, 0x20AF, /* U20af */
  IBUS_KEY_Multi_key, IBUS_KEY_Greek_epsilon, IBUS_KEY_equal, 0, 0,
    0, 0x20AC  /* EuroSign */
};

static const IBusComposeTable ibus_compose_table_el_gr = {
    ibus_compose_seqs_el_gr,
    5,
    G_N_ELEMENTS (ibus_compose_seqs_el_gr) / (5 + 2)
};

static const guint16 ibus_compose_seqs_fi_fi[] = {
  IBUS_KEY_dead_acute, IBUS_KEY_space, 0, 0,
    0, 0x00B4, /* # ACUTE ACCENT */
  IBUS_KEY_dead_acute, IBUS_KEY_dead_circumflex, IBUS_KEY_E, 0,
    0, 0x1EC6, /* # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_space, 0, 0,
    0, 0x00A8, /* # DIAERESIS */
  IBUS_KEY_dead_hook, IBUS_KEY_dead_horn, IBUS_KEY_o, 0,
    0, 0x1EDD, /* # LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE */
  IBUS_KEY_dead_stroke, IBUS_KEY_D, 0, 0,
    0, 0x0110, /* # LATIN CAPITAL LETTER D WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_G, 0, 0,
    0, 0x01E4, /* # LATIN CAPITAL LETTER G WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_H, 0, 0,
    0, 0x0126, /* # LATIN CAPITAL LETTER H WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_L, 0, 0,
    0, 0x0141, /* # LATIN CAPITAL LETTER L WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_O, 0, 0,
    0, 0x00D8, /* # LATIN CAPITAL LETTER O WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_T, 0, 0,
    0, 0x0166, /* # LATIN CAPITAL LETTER T WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_d, 0, 0,
    0, 0x0111, /* # LATIN SMALL LETTER D WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_g, 0, 0,
    0, 0x01E5, /* # LATIN SMALL LETTER G WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_h, 0, 0,
    0, 0x0127, /* # LATIN SMALL LETTER H WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_l, 0, 0,
    0, 0x0142, /* # LATIN SMALL LETTER L WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_o, 0, 0,
    0, 0x00F8, /* # LATIN SMALL LETTER O WITH STROKE */
  IBUS_KEY_dead_stroke, IBUS_KEY_t, 0, 0,
    0, 0x0167, /* # LATIN SMALL LETTER T WITH STROKE */
  IBUS_KEY_dead_belowcomma, IBUS_KEY_S, 0, 0,
    0, 0x0218, /* # LATIN CAPITAL LETTER S WITH COMMA BELOW */
  IBUS_KEY_dead_belowcomma, IBUS_KEY_T, 0, 0,
    0, 0x021A, /* # LATIN CAPITAL LETTER T WITH COMMA BELOW */
  IBUS_KEY_dead_belowcomma, IBUS_KEY_s, 0, 0,
    0, 0x0219, /* # LATIN SMALL LETTER S WITH COMMA BELOW */
  IBUS_KEY_dead_belowcomma, IBUS_KEY_t, 0, 0,
    0, 0x021B, /* # LATIN SMALL LETTER T WITH COMMA BELOW */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, IBUS_KEY_space, IBUS_KEY_n,
    0, 0x0149  /* # LATIN SMALL LETTER N PRECEDED BY APOSTROPHE */
};

static const IBusComposeTable ibus_compose_table_fi_fi = {
    ibus_compose_seqs_fi_fi,
    4,
    G_N_ELEMENTS (ibus_compose_seqs_fi_fi) / (4 + 2)
};

static const guint16 ibus_compose_seqs_pt_br[] = {
  IBUS_KEY_dead_grave, 0x1F00, 0, 0, 0,
    0, 0x1F02, /* U1F02 # GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA */
  IBUS_KEY_dead_grave, 0x1F01, 0, 0, 0,
    0, 0x1F03, /* U1F03 # GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA */
  IBUS_KEY_dead_grave, 0x1F08, 0, 0, 0,
    0, 0x1F0A, /* U1F0A # GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA */
  IBUS_KEY_dead_grave, 0x1F09, 0, 0, 0,
    0, 0x1F0B, /* U1F0B # GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA */
  IBUS_KEY_dead_grave, 0x1F10, 0, 0, 0,
    0, 0x1F12, /* U1F12 # GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA */
  IBUS_KEY_dead_grave, 0x1F11, 0, 0, 0,
    0, 0x1F13, /* U1F13 # GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA */
  IBUS_KEY_dead_grave, 0x1F18, 0, 0, 0,
    0, 0x1F1A, /* U1F1A # GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA */
  IBUS_KEY_dead_grave, 0x1F19, 0, 0, 0,
    0, 0x1F1B, /* U1F1B # GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA */
  IBUS_KEY_dead_grave, 0x1F20, 0, 0, 0,
    0, 0x1F22, /* U1F22 # GREEK SMALL LETTER ETA WITH PSILI AND VARIA */
  IBUS_KEY_dead_grave, 0x1F21, 0, 0, 0,
    0, 0x1F23, /* U1F23 # GREEK SMALL LETTER ETA WITH DASIA AND VARIA */
  IBUS_KEY_dead_grave, 0x1F28, 0, 0, 0,
    0, 0x1F2A, /* U1F2A # GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA */
  IBUS_KEY_dead_grave, 0x1F29, 0, 0, 0,
    0, 0x1F2B, /* U1F2B # GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA */
  IBUS_KEY_dead_grave, 0x1F30, 0, 0, 0,
    0, 0x1F32, /* U1F32 # GREEK SMALL LETTER IOTA WITH PSILI AND VARIA */
  IBUS_KEY_dead_grave, 0x1F31, 0, 0, 0,
    0, 0x1F33, /* U1F33 # GREEK SMALL LETTER IOTA WITH DASIA AND VARIA */
  IBUS_KEY_dead_grave, 0x1F38, 0, 0, 0,
    0, 0x1F3A, /* U1F3A # GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA */
  IBUS_KEY_dead_grave, 0x1F39, 0, 0, 0,
    0, 0x1F3B, /* U1F3B # GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA */
  IBUS_KEY_dead_grave, 0x1F40, 0, 0, 0,
    0, 0x1F42, /* U1F42 # GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA */
  IBUS_KEY_dead_grave, 0x1F41, 0, 0, 0,
    0, 0x1F43, /* U1F43 # GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA */
  IBUS_KEY_dead_grave, 0x1F48, 0, 0, 0,
    0, 0x1F4A, /* U1F4A # GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA */
  IBUS_KEY_dead_grave, 0x1F49, 0, 0, 0,
    0, 0x1F4B, /* U1F4B # GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA */
  IBUS_KEY_dead_grave, 0x1F50, 0, 0, 0,
    0, 0x1F52, /* U1F52 # GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA */
  IBUS_KEY_dead_grave, 0x1F51, 0, 0, 0,
    0, 0x1F53, /* U1F53 # GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA */
  IBUS_KEY_dead_grave, 0x1F59, 0, 0, 0,
    0, 0x1F5B, /* U1F5B # GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA */
  IBUS_KEY_dead_grave, 0x1F60, 0, 0, 0,
    0, 0x1F62, /* U1F62 # GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA */
  IBUS_KEY_dead_grave, 0x1F61, 0, 0, 0,
    0, 0x1F63, /* U1F63 # GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA */
  IBUS_KEY_dead_grave, 0x1F68, 0, 0, 0,
    0, 0x1F6A, /* U1F6A # GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA */
  IBUS_KEY_dead_grave, 0x1F69, 0, 0, 0,
    0, 0x1F6B, /* U1F6B # GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA */
  IBUS_KEY_dead_acute, IBUS_KEY_C, 0, 0, 0,
    0, 0x00C7, /* Ccedilla # LATIN CAPITAL LETTER C WITH CEDILLA */
  IBUS_KEY_dead_acute, IBUS_KEY_c, 0, 0, 0,
    0, 0x00E7, /* ccedilla # LATIN SMALL LETTER C WITH CEDILLA */
  IBUS_KEY_dead_acute, 0x1F00, 0, 0, 0,
    0, 0x1F04, /* U1F04 # GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA */
  IBUS_KEY_dead_acute, 0x1F01, 0, 0, 0,
    0, 0x1F05, /* U1F05 # GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA */
  IBUS_KEY_dead_acute, 0x1F08, 0, 0, 0,
    0, 0x1F0C, /* U1F0C # GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA */
  IBUS_KEY_dead_acute, 0x1F09, 0, 0, 0,
    0, 0x1F0D, /* U1F0D # GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA */
  IBUS_KEY_dead_acute, 0x1F10, 0, 0, 0,
    0, 0x1F14, /* U1F14 # GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA */
  IBUS_KEY_dead_acute, 0x1F11, 0, 0, 0,
    0, 0x1F15, /* U1F15 # GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA */
  IBUS_KEY_dead_acute, 0x1F18, 0, 0, 0,
    0, 0x1F1C, /* U1F1C # GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA */
  IBUS_KEY_dead_acute, 0x1F19, 0, 0, 0,
    0, 0x1F1D, /* U1F1D # GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA */
  IBUS_KEY_dead_acute, 0x1F20, 0, 0, 0,
    0, 0x1F24, /* U1F24 # GREEK SMALL LETTER ETA WITH PSILI AND OXIA */
  IBUS_KEY_dead_acute, 0x1F21, 0, 0, 0,
    0, 0x1F25, /* U1F25 # GREEK SMALL LETTER ETA WITH DASIA AND OXIA */
  IBUS_KEY_dead_acute, 0x1F28, 0, 0, 0,
    0, 0x1F2C, /* U1F2C # GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA */
  IBUS_KEY_dead_acute, 0x1F29, 0, 0, 0,
    0, 0x1F2D, /* U1F2D # GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA */
  IBUS_KEY_dead_acute, 0x1F30, 0, 0, 0,
    0, 0x1F34, /* U1F34 # GREEK SMALL LETTER IOTA WITH PSILI AND OXIA */
  IBUS_KEY_dead_acute, 0x1F31, 0, 0, 0,
    0, 0x1F35, /* U1F35 # GREEK SMALL LETTER IOTA WITH DASIA AND OXIA */
  IBUS_KEY_dead_acute, 0x1F38, 0, 0, 0,
    0, 0x1F3C, /* U1F3C # GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA */
  IBUS_KEY_dead_acute, 0x1F39, 0, 0, 0,
    0, 0x1F3D, /* U1F3D # GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA */
  IBUS_KEY_dead_acute, 0x1F40, 0, 0, 0,
    0, 0x1F44, /* U1F44 # GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA */
  IBUS_KEY_dead_acute, 0x1F41, 0, 0, 0,
    0, 0x1F45, /* U1F45 # GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA */
  IBUS_KEY_dead_acute, 0x1F48, 0, 0, 0,
    0, 0x1F4C, /* U1F4C # GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA */
  IBUS_KEY_dead_acute, 0x1F49, 0, 0, 0,
    0, 0x1F4D, /* U1F4D # GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA */
  IBUS_KEY_dead_acute, 0x1F50, 0, 0, 0,
    0, 0x1F54, /* U1F54 # GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA */
  IBUS_KEY_dead_acute, 0x1F51, 0, 0, 0,
    0, 0x1F55, /* U1F55 # GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA */
  IBUS_KEY_dead_acute, 0x1F59, 0, 0, 0,
    0, 0x1F5D, /* U1F5D # GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA */
  IBUS_KEY_dead_acute, 0x1F60, 0, 0, 0,
    0, 0x1F64, /* U1F64 # GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA */
  IBUS_KEY_dead_acute, 0x1F61, 0, 0, 0,
    0, 0x1F65, /* U1F65 # GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA */
  IBUS_KEY_dead_acute, 0x1F68, 0, 0, 0,
    0, 0x1F6C, /* U1F6C # GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA */
  IBUS_KEY_dead_acute, 0x1F69, 0, 0, 0,
    0, 0x1F6D, /* U1F6D # GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA */
  IBUS_KEY_dead_circumflex, 0x1EA0, 0, 0, 0,
    0, 0x1EAC, /* U1EAC # LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW */
  IBUS_KEY_dead_circumflex, 0x1EA1, 0, 0, 0,
    0, 0x1EAD, /* U1EAD # LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW */
  IBUS_KEY_dead_circumflex, 0x1EB8, 0, 0, 0,
    0, 0x1EC6, /* U1EC6 # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW */
  IBUS_KEY_dead_circumflex, 0x1EB9, 0, 0, 0,
    0, 0x1EC7, /* U1EC7 # LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW */
  IBUS_KEY_dead_circumflex, 0x1ECC, 0, 0, 0,
    0, 0x1ED8, /* U1ED8 # LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW */
  IBUS_KEY_dead_circumflex, 0x1ECD, 0, 0, 0,
    0, 0x1ED9, /* U1ED9 # LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW */
  IBUS_KEY_dead_macron, 0x01EA, 0, 0, 0,
    0, 0x01EC, /* U01EC # LATIN CAPITAL LETTER O WITH OGONEK AND MACRON */
  IBUS_KEY_dead_macron, 0x01EB, 0, 0, 0,
    0, 0x01ED, /* U01ED # LATIN SMALL LETTER O WITH OGONEK AND MACRON */
  IBUS_KEY_dead_macron, 0x0226, 0, 0, 0,
    0, 0x01E0, /* U01E0 # LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON */
  IBUS_KEY_dead_macron, 0x0227, 0, 0, 0,
    0, 0x01E1, /* U01E1 # LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON */
  IBUS_KEY_dead_macron, 0x022E, 0, 0, 0,
    0, 0x0230, /* U0230 # LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON */
  IBUS_KEY_dead_macron, 0x022F, 0, 0, 0,
    0, 0x0231, /* U0231 # LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON */
  IBUS_KEY_dead_macron, 0x1E36, 0, 0, 0,
    0, 0x1E38, /* U1E38 # LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON */
  IBUS_KEY_dead_macron, 0x1E37, 0, 0, 0,
    0, 0x1E39, /* U1E39 # LATIN SMALL LETTER L WITH DOT BELOW AND MACRON */
  IBUS_KEY_dead_macron, 0x1E5A, 0, 0, 0,
    0, 0x1E5C, /* U1E5C # LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON */
  IBUS_KEY_dead_macron, 0x1E5B, 0, 0, 0,
    0, 0x1E5D, /* U1E5D # LATIN SMALL LETTER R WITH DOT BELOW AND MACRON */
  IBUS_KEY_dead_macron, IBUS_KEY_dead_diaeresis, IBUS_KEY_U, 0, 0,
    0, 0x01D5, /* U01D5 # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON */
  IBUS_KEY_dead_macron, IBUS_KEY_dead_diaeresis, IBUS_KEY_u, 0, 0,
    0, 0x01D6, /* U01D6 # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON */
  IBUS_KEY_dead_breve, 0x0228, 0, 0, 0,
    0, 0x1E1C, /* U1E1C # LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE */
  IBUS_KEY_dead_breve, 0x0229, 0, 0, 0,
    0, 0x1E1D, /* U1E1D # LATIN SMALL LETTER E WITH CEDILLA AND BREVE */
  IBUS_KEY_dead_breve, 0x1EA0, 0, 0, 0,
    0, 0x1EB6, /* U1EB6 # LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW */
  IBUS_KEY_dead_breve, 0x1EA1, 0, 0, 0,
    0, 0x1EB7, /* U1EB7 # LATIN SMALL LETTER A WITH BREVE AND DOT BELOW */
  IBUS_KEY_dead_abovedot, 0x017F, 0, 0, 0,
    0, 0x1E9B, /* U1E9B # LATIN SMALL LETTER LONG S WITH DOT ABOVE */
  IBUS_KEY_dead_abovedot, 0x1E62, 0, 0, 0,
    0, 0x1E68, /* U1E68 # LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE */
  IBUS_KEY_dead_abovedot, 0x1E63, 0, 0, 0,
    0, 0x1E69, /* U1E69 # LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE */
  IBUS_KEY_dead_diaeresis, 0x04D8, 0, 0, 0,
    0, 0x04DA, /* U04DA # CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS */
  IBUS_KEY_dead_diaeresis, 0x04D9, 0, 0, 0,
    0, 0x04DB, /* U04DB # CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS */
  IBUS_KEY_dead_diaeresis, 0x04E8, 0, 0, 0,
    0, 0x04EA, /* U04EA # CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS */
  IBUS_KEY_dead_diaeresis, 0x04E9, 0, 0, 0,
    0, 0x04EB, /* U04EB # CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_dead_macron, IBUS_KEY_U, 0, 0,
    0, 0x1E7A, /* U1E7A # LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS */
  IBUS_KEY_dead_diaeresis, IBUS_KEY_dead_macron, IBUS_KEY_u, 0, 0,
    0, 0x1E7B, /* U1E7B # LATIN SMALL LETTER U WITH MACRON AND DIAERESIS */
  IBUS_KEY_dead_iota, 0x1F00, 0, 0, 0,
    0, 0x1F80, /* U1F80 # GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F01, 0, 0, 0,
    0, 0x1F81, /* U1F81 # GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F02, 0, 0, 0,
    0, 0x1F82, /* U1F82 # GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F03, 0, 0, 0,
    0, 0x1F83, /* U1F83 # GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F04, 0, 0, 0,
    0, 0x1F84, /* U1F84 # GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F05, 0, 0, 0,
    0, 0x1F85, /* U1F85 # GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F06, 0, 0, 0,
    0, 0x1F86, /* U1F86 # GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F07, 0, 0, 0,
    0, 0x1F87, /* U1F87 # GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F08, 0, 0, 0,
    0, 0x1F88, /* U1F88 # GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F09, 0, 0, 0,
    0, 0x1F89, /* U1F89 # GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F0A, 0, 0, 0,
    0, 0x1F8A, /* U1F8A # GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F0B, 0, 0, 0,
    0, 0x1F8B, /* U1F8B # GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F0C, 0, 0, 0,
    0, 0x1F8C, /* U1F8C # GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F0D, 0, 0, 0,
    0, 0x1F8D, /* U1F8D # GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F0E, 0, 0, 0,
    0, 0x1F8E, /* U1F8E # GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F0F, 0, 0, 0,
    0, 0x1F8F, /* U1F8F # GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F20, 0, 0, 0,
    0, 0x1F90, /* U1F90 # GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F21, 0, 0, 0,
    0, 0x1F91, /* U1F91 # GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F22, 0, 0, 0,
    0, 0x1F92, /* U1F92 # GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F23, 0, 0, 0,
    0, 0x1F93, /* U1F93 # GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F24, 0, 0, 0,
    0, 0x1F94, /* U1F94 # GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F25, 0, 0, 0,
    0, 0x1F95, /* U1F95 # GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F26, 0, 0, 0,
    0, 0x1F96, /* U1F96 # GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F27, 0, 0, 0,
    0, 0x1F97, /* U1F97 # GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F28, 0, 0, 0,
    0, 0x1F98, /* U1F98 # GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F29, 0, 0, 0,
    0, 0x1F99, /* U1F99 # GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F2A, 0, 0, 0,
    0, 0x1F9A, /* U1F9A # GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F2B, 0, 0, 0,
    0, 0x1F9B, /* U1F9B # GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F2C, 0, 0, 0,
    0, 0x1F9C, /* U1F9C # GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F2D, 0, 0, 0,
    0, 0x1F9D, /* U1F9D # GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F2E, 0, 0, 0,
    0, 0x1F9E, /* U1F9E # GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F2F, 0, 0, 0,
    0, 0x1F9F, /* U1F9F # GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F60, 0, 0, 0,
    0, 0x1FA0, /* U1FA0 # GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F61, 0, 0, 0,
    0, 0x1FA1, /* U1FA1 # GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F62, 0, 0, 0,
    0, 0x1FA2, /* U1FA2 # GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F63, 0, 0, 0,
    0, 0x1FA3, /* U1FA3 # GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F64, 0, 0, 0,
    0, 0x1FA4, /* U1FA4 # GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F65, 0, 0, 0,
    0, 0x1FA5, /* U1FA5 # GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F66, 0, 0, 0,
    0, 0x1FA6, /* U1FA6 # GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F67, 0, 0, 0,
    0, 0x1FA7, /* U1FA7 # GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F68, 0, 0, 0,
    0, 0x1FA8, /* U1FA8 # GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F69, 0, 0, 0,
    0, 0x1FA9, /* U1FA9 # GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F6A, 0, 0, 0,
    0, 0x1FAA, /* U1FAA # GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F6B, 0, 0, 0,
    0, 0x1FAB, /* U1FAB # GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F6C, 0, 0, 0,
    0, 0x1FAC, /* U1FAC # GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F6D, 0, 0, 0,
    0, 0x1FAD, /* U1FAD # GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F6E, 0, 0, 0,
    0, 0x1FAE, /* U1FAE # GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F6F, 0, 0, 0,
    0, 0x1FAF, /* U1FAF # GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F70, 0, 0, 0,
    0, 0x1FB2, /* U1FB2 # GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F74, 0, 0, 0,
    0, 0x1FC2, /* U1FC2 # GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1F7C, 0, 0, 0,
    0, 0x1FF2, /* U1FF2 # GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1FB6, 0, 0, 0,
    0, 0x1FB7, /* U1FB7 # GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1FC6, 0, 0, 0,
    0, 0x1FC7, /* U1FC7 # GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, 0x1FF6, 0, 0, 0,
    0, 0x1FF7, /* U1FF7 # GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, 0x1F00, 0, 0,
    0, 0x1F82, /* U1F82 # GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, 0x1F01, 0, 0,
    0, 0x1F83, /* U1F83 # GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, 0x1F08, 0, 0,
    0, 0x1F8A, /* U1F8A # GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, 0x1F09, 0, 0,
    0, 0x1F8B, /* U1F8B # GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, 0x1F20, 0, 0,
    0, 0x1F92, /* U1F92 # GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, 0x1F21, 0, 0,
    0, 0x1F93, /* U1F93 # GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, 0x1F28, 0, 0,
    0, 0x1F9A, /* U1F9A # GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, 0x1F29, 0, 0,
    0, 0x1F9B, /* U1F9B # GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, 0x1F60, 0, 0,
    0, 0x1FA2, /* U1FA2 # GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, 0x1F61, 0, 0,
    0, 0x1FA3, /* U1FA3 # GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, 0x1F68, 0, 0,
    0, 0x1FAA, /* U1FAA # GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_grave, 0x1F69, 0, 0,
    0, 0x1FAB, /* U1FAB # GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, 0x1F00, 0, 0,
    0, 0x1F84, /* U1F84 # GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, 0x1F01, 0, 0,
    0, 0x1F85, /* U1F85 # GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, 0x1F08, 0, 0,
    0, 0x1F8C, /* U1F8C # GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, 0x1F09, 0, 0,
    0, 0x1F8D, /* U1F8D # GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, 0x1F20, 0, 0,
    0, 0x1F94, /* U1F94 # GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, 0x1F21, 0, 0,
    0, 0x1F95, /* U1F95 # GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, 0x1F28, 0, 0,
    0, 0x1F9C, /* U1F9C # GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, 0x1F29, 0, 0,
    0, 0x1F9D, /* U1F9D # GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, 0x1F60, 0, 0,
    0, 0x1FA4, /* U1FA4 # GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, 0x1F61, 0, 0,
    0, 0x1FA5, /* U1FA5 # GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, 0x1F68, 0, 0,
    0, 0x1FAC, /* U1FAC # GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_iota, IBUS_KEY_dead_acute, 0x1F69, 0, 0,
    0, 0x1FAD, /* U1FAD # GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI */
  IBUS_KEY_dead_voiced_sound, 0x3046, 0, 0, 0,
    0, 0x3094, /* U3094 # HIRAGANA LETTER VU */
  IBUS_KEY_dead_voiced_sound, 0x304B, 0, 0, 0,
    0, 0x304C, /* U304C # HIRAGANA LETTER GA */
  IBUS_KEY_dead_voiced_sound, 0x304D, 0, 0, 0,
    0, 0x304E, /* U304E # HIRAGANA LETTER GI */
  IBUS_KEY_dead_voiced_sound, 0x304F, 0, 0, 0,
    0, 0x3050, /* U3050 # HIRAGANA LETTER GU */
  IBUS_KEY_dead_voiced_sound, 0x3051, 0, 0, 0,
    0, 0x3052, /* U3052 # HIRAGANA LETTER GE */
  IBUS_KEY_dead_voiced_sound, 0x3053, 0, 0, 0,
    0, 0x3054, /* U3054 # HIRAGANA LETTER GO */
  IBUS_KEY_dead_voiced_sound, 0x3055, 0, 0, 0,
    0, 0x3056, /* U3056 # HIRAGANA LETTER ZA */
  IBUS_KEY_dead_voiced_sound, 0x3057, 0, 0, 0,
    0, 0x3058, /* U3058 # HIRAGANA LETTER ZI */
  IBUS_KEY_dead_voiced_sound, 0x3059, 0, 0, 0,
    0, 0x305A, /* U305A # HIRAGANA LETTER ZU */
  IBUS_KEY_dead_voiced_sound, 0x305B, 0, 0, 0,
    0, 0x305C, /* U305C # HIRAGANA LETTER ZE */
  IBUS_KEY_dead_voiced_sound, 0x305D, 0, 0, 0,
    0, 0x305E, /* U305E # HIRAGANA LETTER ZO */
  IBUS_KEY_dead_voiced_sound, 0x305F, 0, 0, 0,
    0, 0x3060, /* U3060 # HIRAGANA LETTER DA */
  IBUS_KEY_dead_voiced_sound, 0x3061, 0, 0, 0,
    0, 0x3062, /* U3062 # HIRAGANA LETTER DI */
  IBUS_KEY_dead_voiced_sound, 0x3064, 0, 0, 0,
    0, 0x3065, /* U3065 # HIRAGANA LETTER DU */
  IBUS_KEY_dead_voiced_sound, 0x3066, 0, 0, 0,
    0, 0x3067, /* U3067 # HIRAGANA LETTER DE */
  IBUS_KEY_dead_voiced_sound, 0x3068, 0, 0, 0,
    0, 0x3069, /* U3069 # HIRAGANA LETTER DO */
  IBUS_KEY_dead_voiced_sound, 0x306F, 0, 0, 0,
    0, 0x3070, /* U3070 # HIRAGANA LETTER BA */
  IBUS_KEY_dead_voiced_sound, 0x3072, 0, 0, 0,
    0, 0x3073, /* U3073 # HIRAGANA LETTER BI */
  IBUS_KEY_dead_voiced_sound, 0x3075, 0, 0, 0,
    0, 0x3076, /* U3076 # HIRAGANA LETTER BU */
  IBUS_KEY_dead_voiced_sound, 0x3078, 0, 0, 0,
    0, 0x3079, /* U3079 # HIRAGANA LETTER BE */
  IBUS_KEY_dead_voiced_sound, 0x307B, 0, 0, 0,
    0, 0x307C, /* U307C # HIRAGANA LETTER BO */
  IBUS_KEY_dead_voiced_sound, 0x309D, 0, 0, 0,
    0, 0x309E, /* U309E # HIRAGANA VOICED ITERATION MARK */
  IBUS_KEY_dead_voiced_sound, 0x30F0, 0, 0, 0,
    0, 0x30F8, /* U30F8 # KATAKANA LETTER VI */
  IBUS_KEY_dead_voiced_sound, 0x30F1, 0, 0, 0,
    0, 0x30F9, /* U30F9 # KATAKANA LETTER VE */
  IBUS_KEY_dead_voiced_sound, 0x30FD, 0, 0, 0,
    0, 0x30FE, /* U30FE # KATAKANA VOICED ITERATION MARK */
  IBUS_KEY_dead_semivoiced_sound, 0x306F, 0, 0, 0,
    0, 0x3071, /* U3071 # HIRAGANA LETTER PA */
  IBUS_KEY_dead_semivoiced_sound, 0x3072, 0, 0, 0,
    0, 0x3074, /* U3074 # HIRAGANA LETTER PI */
  IBUS_KEY_dead_semivoiced_sound, 0x3075, 0, 0, 0,
    0, 0x3077, /* U3077 # HIRAGANA LETTER PU */
  IBUS_KEY_dead_semivoiced_sound, 0x3078, 0, 0, 0,
    0, 0x307A, /* U307A # HIRAGANA LETTER PE */
  IBUS_KEY_dead_semivoiced_sound, 0x307B, 0, 0, 0,
    0, 0x307D, /* U307D # HIRAGANA LETTER PO */
  IBUS_KEY_dead_doublegrave, IBUS_KEY_A, 0, 0, 0,
    0, 0x0200, /* U0200 # LATIN CAPITAL LETTER A WITH DOUBLE GRAVE */
  IBUS_KEY_dead_doublegrave, IBUS_KEY_E, 0, 0, 0,
    0, 0x0204, /* U0204 # LATIN CAPITAL LETTER E WITH DOUBLE GRAVE */
  IBUS_KEY_dead_doublegrave, IBUS_KEY_I, 0, 0, 0,
    0, 0x0208, /* U0208 # LATIN CAPITAL LETTER I WITH DOUBLE GRAVE */
  IBUS_KEY_dead_doublegrave, IBUS_KEY_O, 0, 0, 0,
    0, 0x020C, /* U020C # LATIN CAPITAL LETTER O WITH DOUBLE GRAVE */
  IBUS_KEY_dead_doublegrave, IBUS_KEY_R, 0, 0, 0,
    0, 0x0210, /* U0210 # LATIN CAPITAL LETTER R WITH DOUBLE GRAVE */
  IBUS_KEY_dead_doublegrave, IBUS_KEY_U, 0, 0, 0,
    0, 0x0214, /* U0214 # LATIN CAPITAL LETTER U WITH DOUBLE GRAVE */
  IBUS_KEY_dead_doublegrave, IBUS_KEY_a, 0, 0, 0,
    0, 0x0201, /* U0201 # LATIN SMALL LETTER A WITH DOUBLE GRAVE */
  IBUS_KEY_dead_doublegrave, IBUS_KEY_e, 0, 0, 0,
    0, 0x0205, /* U0205 # LATIN SMALL LETTER E WITH DOUBLE GRAVE */
  IBUS_KEY_dead_doublegrave, IBUS_KEY_i, 0, 0, 0,
    0, 0x0209, /* U0209 # LATIN SMALL LETTER I WITH DOUBLE GRAVE */
  IBUS_KEY_dead_doublegrave, IBUS_KEY_o, 0, 0, 0,
    0, 0x020D, /* U020D # LATIN SMALL LETTER O WITH DOUBLE GRAVE */
  IBUS_KEY_dead_doublegrave, IBUS_KEY_r, 0, 0, 0,
    0, 0x0211, /* U0211 # LATIN SMALL LETTER R WITH DOUBLE GRAVE */
  IBUS_KEY_dead_doublegrave, IBUS_KEY_u, 0, 0, 0,
    0, 0x0215, /* U0215 # LATIN SMALL LETTER U WITH DOUBLE GRAVE */
  IBUS_KEY_dead_doublegrave, 0x0474, 0, 0, 0,
    0, 0x0476, /* U0476 # CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT */
  IBUS_KEY_dead_doublegrave, 0x0475, 0, 0, 0,
    0, 0x0477, /* U0477 # CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT */
  IBUS_KEY_dead_belowring, IBUS_KEY_A, 0, 0, 0,
    0, 0x1E00, /* U1E00 # LATIN CAPITAL LETTER A WITH RING BELOW */
  IBUS_KEY_dead_belowring, IBUS_KEY_a, 0, 0, 0,
    0, 0x1E01, /* U1E01 # LATIN SMALL LETTER A WITH RING BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_B, 0, 0, 0,
    0, 0x1E06, /* U1E06 # LATIN CAPITAL LETTER B WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_D, 0, 0, 0,
    0, 0x1E0E, /* U1E0E # LATIN CAPITAL LETTER D WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_K, 0, 0, 0,
    0, 0x1E34, /* U1E34 # LATIN CAPITAL LETTER K WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_L, 0, 0, 0,
    0, 0x1E3A, /* U1E3A # LATIN CAPITAL LETTER L WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_N, 0, 0, 0,
    0, 0x1E48, /* U1E48 # LATIN CAPITAL LETTER N WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_R, 0, 0, 0,
    0, 0x1E5E, /* U1E5E # LATIN CAPITAL LETTER R WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_T, 0, 0, 0,
    0, 0x1E6E, /* U1E6E # LATIN CAPITAL LETTER T WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_Z, 0, 0, 0,
    0, 0x1E94, /* U1E94 # LATIN CAPITAL LETTER Z WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_b, 0, 0, 0,
    0, 0x1E07, /* U1E07 # LATIN SMALL LETTER B WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_d, 0, 0, 0,
    0, 0x1E0F, /* U1E0F # LATIN SMALL LETTER D WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_h, 0, 0, 0,
    0, 0x1E96, /* U1E96 # LATIN SMALL LETTER H WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_k, 0, 0, 0,
    0, 0x1E35, /* U1E35 # LATIN SMALL LETTER K WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_l, 0, 0, 0,
    0, 0x1E3B, /* U1E3B # LATIN SMALL LETTER L WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_n, 0, 0, 0,
    0, 0x1E49, /* U1E49 # LATIN SMALL LETTER N WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_r, 0, 0, 0,
    0, 0x1E5F, /* U1E5F # LATIN SMALL LETTER R WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_t, 0, 0, 0,
    0, 0x1E6F, /* U1E6F # LATIN SMALL LETTER T WITH LINE BELOW */
  IBUS_KEY_dead_belowmacron, IBUS_KEY_z, 0, 0, 0,
    0, 0x1E95, /* U1E95 # LATIN SMALL LETTER Z WITH LINE BELOW */
  IBUS_KEY_dead_belowcircumflex, IBUS_KEY_D, 0, 0, 0,
    0, 0x1E12, /* U1E12 # LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW */
  IBUS_KEY_dead_belowcircumflex, IBUS_KEY_E, 0, 0, 0,
    0, 0x1E18, /* U1E18 # LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW */
  IBUS_KEY_dead_belowcircumflex, IBUS_KEY_L, 0, 0, 0,
    0, 0x1E3C, /* U1E3C # LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW */
  IBUS_KEY_dead_belowcircumflex, IBUS_KEY_N, 0, 0, 0,
    0, 0x1E4A, /* U1E4A # LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW */
  IBUS_KEY_dead_belowcircumflex, IBUS_KEY_T, 0, 0, 0,
    0, 0x1E70, /* U1E70 # LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW */
  IBUS_KEY_dead_belowcircumflex, IBUS_KEY_U, 0, 0, 0,
    0, 0x1E76, /* U1E76 # LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW */
  IBUS_KEY_dead_belowcircumflex, IBUS_KEY_d, 0, 0, 0,
    0, 0x1E13, /* U1E13 # LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW */
  IBUS_KEY_dead_belowcircumflex, IBUS_KEY_e, 0, 0, 0,
    0, 0x1E19, /* U1E19 # LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW */
  IBUS_KEY_dead_belowcircumflex, IBUS_KEY_l, 0, 0, 0,
    0, 0x1E3D, /* U1E3D # LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW */
  IBUS_KEY_dead_belowcircumflex, IBUS_KEY_n, 0, 0, 0,
    0, 0x1E4B, /* U1E4B # LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW */
  IBUS_KEY_dead_belowcircumflex, IBUS_KEY_t, 0, 0, 0,
    0, 0x1E71, /* U1E71 # LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW */
  IBUS_KEY_dead_belowcircumflex, IBUS_KEY_u, 0, 0, 0,
    0, 0x1E77, /* U1E77 # LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW */
  IBUS_KEY_dead_belowtilde, IBUS_KEY_E, 0, 0, 0,
    0, 0x1E1A, /* U1E1A # LATIN CAPITAL LETTER E WITH TILDE BELOW */
  IBUS_KEY_dead_belowtilde, IBUS_KEY_I, 0, 0, 0,
    0, 0x1E2C, /* U1E2C # LATIN CAPITAL LETTER I WITH TILDE BELOW */
  IBUS_KEY_dead_belowtilde, IBUS_KEY_U, 0, 0, 0,
    0, 0x1E74, /* U1E74 # LATIN CAPITAL LETTER U WITH TILDE BELOW */
  IBUS_KEY_dead_belowtilde, IBUS_KEY_e, 0, 0, 0,
    0, 0x1E1B, /* U1E1B # LATIN SMALL LETTER E WITH TILDE BELOW */
  IBUS_KEY_dead_belowtilde, IBUS_KEY_i, 0, 0, 0,
    0, 0x1E2D, /* U1E2D # LATIN SMALL LETTER I WITH TILDE BELOW */
  IBUS_KEY_dead_belowtilde, IBUS_KEY_u, 0, 0, 0,
    0, 0x1E75, /* U1E75 # LATIN SMALL LETTER U WITH TILDE BELOW */
  IBUS_KEY_dead_belowbreve, IBUS_KEY_H, 0, 0, 0,
    0, 0x1E2A, /* U1E2A # LATIN CAPITAL LETTER H WITH BREVE BELOW */
  IBUS_KEY_dead_belowbreve, IBUS_KEY_h, 0, 0, 0,
    0, 0x1E2B, /* U1E2B # LATIN SMALL LETTER H WITH BREVE BELOW */
  IBUS_KEY_dead_belowdiaeresis, IBUS_KEY_U, 0, 0, 0,
    0, 0x1E72, /* U1E72 # LATIN CAPITAL LETTER U WITH DIAERESIS BELOW */
  IBUS_KEY_dead_belowdiaeresis, IBUS_KEY_u, 0, 0, 0,
    0, 0x1E73, /* U1E73 # LATIN SMALL LETTER U WITH DIAERESIS BELOW */
  IBUS_KEY_dead_invertedbreve, IBUS_KEY_A, 0, 0, 0,
    0, 0x0202, /* U0202 # LATIN CAPITAL LETTER A WITH INVERTED BREVE */
  IBUS_KEY_dead_invertedbreve, IBUS_KEY_E, 0, 0, 0,
    0, 0x0206, /* U0206 # LATIN CAPITAL LETTER E WITH INVERTED BREVE */
  IBUS_KEY_dead_invertedbreve, IBUS_KEY_I, 0, 0, 0,
    0, 0x020A, /* U020A # LATIN CAPITAL LETTER I WITH INVERTED BREVE */
  IBUS_KEY_dead_invertedbreve, IBUS_KEY_O, 0, 0, 0,
    0, 0x020E, /* U020E # LATIN CAPITAL LETTER O WITH INVERTED BREVE */
  IBUS_KEY_dead_invertedbreve, IBUS_KEY_R, 0, 0, 0,
    0, 0x0212, /* U0212 # LATIN CAPITAL LETTER R WITH INVERTED BREVE */
  IBUS_KEY_dead_invertedbreve, IBUS_KEY_U, 0, 0, 0,
    0, 0x0216, /* U0216 # LATIN CAPITAL LETTER U WITH INVERTED BREVE */
  IBUS_KEY_dead_invertedbreve, IBUS_KEY_a, 0, 0, 0,
    0, 0x0203, /* U0203 # LATIN SMALL LETTER A WITH INVERTED BREVE */
  IBUS_KEY_dead_invertedbreve, IBUS_KEY_e, 0, 0, 0,
    0, 0x0207, /* U0207 # LATIN SMALL LETTER E WITH INVERTED BREVE */
  IBUS_KEY_dead_invertedbreve, IBUS_KEY_i, 0, 0, 0,
    0, 0x020B, /* U020B # LATIN SMALL LETTER I WITH INVERTED BREVE */
  IBUS_KEY_dead_invertedbreve, IBUS_KEY_o, 0, 0, 0,
    0, 0x020F, /* U020F # LATIN SMALL LETTER O WITH INVERTED BREVE */
  IBUS_KEY_dead_invertedbreve, IBUS_KEY_r, 0, 0, 0,
    0, 0x0213, /* U0213 # LATIN SMALL LETTER R WITH INVERTED BREVE */
  IBUS_KEY_dead_invertedbreve, IBUS_KEY_u, 0, 0, 0,
    0, 0x0217, /* U0217 # LATIN SMALL LETTER U WITH INVERTED BREVE */
  IBUS_KEY_dead_belowcomma, IBUS_KEY_S, 0, 0, 0,
    0, 0x0218, /* U0218 # LATIN CAPITAL LETTER S WITH COMMA BELOW */
  IBUS_KEY_dead_belowcomma, IBUS_KEY_T, 0, 0, 0,
    0, 0x021A, /* U021A # LATIN CAPITAL LETTER T WITH COMMA BELOW */
  IBUS_KEY_dead_belowcomma, IBUS_KEY_s, 0, 0, 0,
    0, 0x0219, /* U0219 # LATIN SMALL LETTER S WITH COMMA BELOW */
  IBUS_KEY_dead_belowcomma, IBUS_KEY_t, 0, 0, 0,
    0, 0x021B, /* U021B # LATIN SMALL LETTER T WITH COMMA BELOW */
  IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_slash, 0, 0,
    0, 0x301E, /* U301e # DOUBLE PRIME QUOTATION MARK */
  IBUS_KEY_Multi_key, IBUS_KEY_quotedbl, IBUS_KEY_backslash, 0, 0,
    0, 0x301D, /* U301d # REVERSED DOUBLE PRIME QUOTATION MARK */
  IBUS_KEY_Multi_key, IBUS_KEY_apostrophe, 0x03D2, 0, 0,
    0, 0x03D3, /* U03D3 # GREEK UPSILON WITH ACUTE AND HOOK SYMBOL */
  IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_5, IBUS_KEY_0, IBUS_KEY_parenright,
    0, 0x32BF, /* U32BF # CIRCLED NUMBER FIFTY */
  IBUS_KEY_Multi_key, IBUS_KEY_parenleft, IBUS_KEY_KP_5, IBUS_KEY_0, IBUS_KEY_parenright,
    0, 0x32BF, /* U32BF # CIRCLED NUMBER FIFTY */
  IBUS_KEY_Multi_key, IBUS_KEY_comma, IBUS_KEY_E, 0, 0,
    0, 0x0228, /* U0228 # LATIN CAPITAL LETTER E WITH CEDILLA */
  IBUS_KEY_Multi_key, IBUS_KEY_comma, IBUS_KEY_e, 0, 0,
    0, 0x0229, /* U0229 # LATIN SMALL LETTER E WITH CEDILLA */
  IBUS_KEY_Multi_key, IBUS_KEY_period, 0x1E63, 0, 0,
    0, 0x1E69, /* U1E69 # LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE */
  IBUS_KEY_Multi_key, IBUS_KEY_question, IBUS_KEY_exclam, 0, 0,
    0, 0x203D, /* U203D # INTERROBANG */
  IBUS_KEY_Multi_key, IBUS_KEY_L, IBUS_KEY_equal, 0, 0,
    0, 0x20A4, /* U20a4 # LIRA SIGN */
  IBUS_KEY_Multi_key, IBUS_KEY_U, IBUS_KEY_comma, IBUS_KEY_E, 0,
    0, 0x1E1C, /* U1E1C # LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE */
  IBUS_KEY_Multi_key, IBUS_KEY_U, IBUS_KEY_comma, IBUS_KEY_e, 0,
    0, 0x1E1D, /* U1E1D # LATIN SMALL LETTER E WITH CEDILLA AND BREVE */
  IBUS_KEY_Multi_key, IBUS_KEY_d, IBUS_KEY_minus, 0, 0,
    0, 0x20AB, /* U20ab # DONG SIGN */
  IBUS_KEY_Multi_key, IBUS_KEY_e, IBUS_KEY_e, 0, 0,
    0, 0x018F, /* U018f */
  IBUS_KEY_Multi_key, IBUS_KEY_acute, 0x03D2, 0, 0,
    0, 0x03D3, /* U03D3 # GREEK UPSILON WITH ACUTE AND HOOK SYMBOL */
  IBUS_KEY_Multi_key, 0x2203, 0x0338, 0, 0,
    0, 0x2204, /* U2204 # THERE DOES NOT EXIST */
  IBUS_KEY_Multi_key, 0x2208, 0x0338, 0, 0,
    0, 0x2209, /* U2209 # NOT AN ELEMENT OF */
  IBUS_KEY_Multi_key, 0x220B, 0x0338, 0, 0,
    0, 0x220C, /* U220C # DOES NOT CONTAIN AS MEMBER */
  IBUS_KEY_Multi_key, 0x2223, 0x0338, 0, 0,
    0, 0x2224, /* U2224 # DOES NOT DIVIDE */
  IBUS_KEY_Multi_key, 0x2225, 0x0338, 0, 0,
    0, 0x2226, /* U2226 # NOT PARALLEL TO */
  IBUS_KEY_Multi_key, 0x2286, 0x0338, 0, 0,
    0, 0x2288, /* U2288 # NEITHER A SUBSET OF NOR EQUAL TO */
  IBUS_KEY_Multi_key, 0x2287, 0x0338, 0, 0,
    0, 0x2289, /* U2289 # NEITHER A SUPERSET OF NOR EQUAL TO */
  IBUS_KEY_Multi_key, 0x2291, 0x0338, 0, 0,
    0, 0x22E2, /* U22E2 # NOT SQUARE IMAGE OF OR EQUAL TO */
  IBUS_KEY_Multi_key, 0x2292, 0x0338, 0, 0,
    0, 0x22E3, /* U22E3 # NOT SQUARE ORIGINAL OF OR EQUAL TO */
  IBUS_KEY_Multi_key, 0x22B4, 0x0338, 0, 0,
    0, 0x22EC, /* U22EC # NOT NORMAL SUBGROUP OF OR EQUAL TO */
  IBUS_KEY_Multi_key, 0x22B5, 0x0338, 0, 0,
    0, 0x22ED  /* U22ED # DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL */
};

static const IBusComposeTable ibus_compose_table_pt_br = {
    ibus_compose_seqs_pt_br,
    5,
    G_N_ELEMENTS (ibus_compose_seqs_pt_br) / (5 + 2)
};

static const IBusComposeTableLocaleList ibus_compose_table_locale_list[] = {
    { "el_gr", &ibus_compose_table_el_gr },
    { "fi_fi", &ibus_compose_table_fi_fi },
    { "pt_br", &ibus_compose_table_pt_br },
    { NULL, NULL }
};

#endif
