// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::ffi;
use glib::{prelude::*, translate::*};

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GBusType")]
pub enum BusType {
    #[doc(alias = "G_BUS_TYPE_STARTER")]
    Starter,
    #[doc(alias = "G_BUS_TYPE_NONE")]
    None,
    #[doc(alias = "G_BUS_TYPE_SYSTEM")]
    System,
    #[doc(alias = "G_BUS_TYPE_SESSION")]
    Session,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for BusType {
    type GlibType = ffi::GBusType;

    #[inline]
    fn into_glib(self) -> ffi::GBusType {
        match self {
            Self::Starter => ffi::G_BUS_TYPE_STARTER,
            Self::None => ffi::G_BUS_TYPE_NONE,
            Self::System => ffi::G_BUS_TYPE_SYSTEM,
            Self::Session => ffi::G_BUS_TYPE_SESSION,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GBusType> for BusType {
    #[inline]
    unsafe fn from_glib(value: ffi::GBusType) -> Self {
        match value {
            ffi::G_BUS_TYPE_STARTER => Self::Starter,
            ffi::G_BUS_TYPE_NONE => Self::None,
            ffi::G_BUS_TYPE_SYSTEM => Self::System,
            ffi::G_BUS_TYPE_SESSION => Self::Session,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for BusType {
    #[inline]
    #[doc(alias = "g_bus_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_bus_type_get_type()) }
    }
}

impl glib::HasParamSpec for BusType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for BusType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for BusType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for BusType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<BusType> for glib::Value {
    #[inline]
    fn from(v: BusType) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GConverterResult")]
pub enum ConverterResult {
    #[doc(alias = "G_CONVERTER_ERROR")]
    Error,
    #[doc(alias = "G_CONVERTER_CONVERTED")]
    Converted,
    #[doc(alias = "G_CONVERTER_FINISHED")]
    Finished,
    #[doc(alias = "G_CONVERTER_FLUSHED")]
    Flushed,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ConverterResult {
    type GlibType = ffi::GConverterResult;

    #[inline]
    fn into_glib(self) -> ffi::GConverterResult {
        match self {
            Self::Error => ffi::G_CONVERTER_ERROR,
            Self::Converted => ffi::G_CONVERTER_CONVERTED,
            Self::Finished => ffi::G_CONVERTER_FINISHED,
            Self::Flushed => ffi::G_CONVERTER_FLUSHED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GConverterResult> for ConverterResult {
    #[inline]
    unsafe fn from_glib(value: ffi::GConverterResult) -> Self {
        match value {
            ffi::G_CONVERTER_ERROR => Self::Error,
            ffi::G_CONVERTER_CONVERTED => Self::Converted,
            ffi::G_CONVERTER_FINISHED => Self::Finished,
            ffi::G_CONVERTER_FLUSHED => Self::Flushed,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ConverterResult {
    #[inline]
    #[doc(alias = "g_converter_result_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_converter_result_get_type()) }
    }
}

impl glib::HasParamSpec for ConverterResult {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for ConverterResult {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for ConverterResult {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ConverterResult {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<ConverterResult> for glib::Value {
    #[inline]
    fn from(v: ConverterResult) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GCredentialsType")]
pub enum CredentialsType {
    #[doc(alias = "G_CREDENTIALS_TYPE_INVALID")]
    Invalid,
    #[doc(alias = "G_CREDENTIALS_TYPE_LINUX_UCRED")]
    LinuxUcred,
    #[doc(alias = "G_CREDENTIALS_TYPE_FREEBSD_CMSGCRED")]
    FreebsdCmsgcred,
    #[doc(alias = "G_CREDENTIALS_TYPE_OPENBSD_SOCKPEERCRED")]
    OpenbsdSockpeercred,
    #[doc(alias = "G_CREDENTIALS_TYPE_SOLARIS_UCRED")]
    SolarisUcred,
    #[doc(alias = "G_CREDENTIALS_TYPE_NETBSD_UNPCBID")]
    NetbsdUnpcbid,
    #[doc(alias = "G_CREDENTIALS_TYPE_APPLE_XUCRED")]
    AppleXucred,
    #[cfg(feature = "v2_72")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_72")))]
    #[doc(alias = "G_CREDENTIALS_TYPE_WIN32_PID")]
    Win32Pid,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for CredentialsType {
    type GlibType = ffi::GCredentialsType;

    #[inline]
    fn into_glib(self) -> ffi::GCredentialsType {
        match self {
            Self::Invalid => ffi::G_CREDENTIALS_TYPE_INVALID,
            Self::LinuxUcred => ffi::G_CREDENTIALS_TYPE_LINUX_UCRED,
            Self::FreebsdCmsgcred => ffi::G_CREDENTIALS_TYPE_FREEBSD_CMSGCRED,
            Self::OpenbsdSockpeercred => ffi::G_CREDENTIALS_TYPE_OPENBSD_SOCKPEERCRED,
            Self::SolarisUcred => ffi::G_CREDENTIALS_TYPE_SOLARIS_UCRED,
            Self::NetbsdUnpcbid => ffi::G_CREDENTIALS_TYPE_NETBSD_UNPCBID,
            Self::AppleXucred => ffi::G_CREDENTIALS_TYPE_APPLE_XUCRED,
            #[cfg(feature = "v2_72")]
            Self::Win32Pid => ffi::G_CREDENTIALS_TYPE_WIN32_PID,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GCredentialsType> for CredentialsType {
    #[inline]
    unsafe fn from_glib(value: ffi::GCredentialsType) -> Self {
        match value {
            ffi::G_CREDENTIALS_TYPE_INVALID => Self::Invalid,
            ffi::G_CREDENTIALS_TYPE_LINUX_UCRED => Self::LinuxUcred,
            ffi::G_CREDENTIALS_TYPE_FREEBSD_CMSGCRED => Self::FreebsdCmsgcred,
            ffi::G_CREDENTIALS_TYPE_OPENBSD_SOCKPEERCRED => Self::OpenbsdSockpeercred,
            ffi::G_CREDENTIALS_TYPE_SOLARIS_UCRED => Self::SolarisUcred,
            ffi::G_CREDENTIALS_TYPE_NETBSD_UNPCBID => Self::NetbsdUnpcbid,
            ffi::G_CREDENTIALS_TYPE_APPLE_XUCRED => Self::AppleXucred,
            #[cfg(feature = "v2_72")]
            ffi::G_CREDENTIALS_TYPE_WIN32_PID => Self::Win32Pid,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CredentialsType {
    #[inline]
    #[doc(alias = "g_credentials_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_credentials_type_get_type()) }
    }
}

impl glib::HasParamSpec for CredentialsType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for CredentialsType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for CredentialsType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CredentialsType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<CredentialsType> for glib::Value {
    #[inline]
    fn from(v: CredentialsType) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GDBusMessageByteOrder")]
pub enum DBusMessageByteOrder {
    #[doc(alias = "G_DBUS_MESSAGE_BYTE_ORDER_BIG_ENDIAN")]
    BigEndian,
    #[doc(alias = "G_DBUS_MESSAGE_BYTE_ORDER_LITTLE_ENDIAN")]
    LittleEndian,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for DBusMessageByteOrder {
    type GlibType = ffi::GDBusMessageByteOrder;

    #[inline]
    fn into_glib(self) -> ffi::GDBusMessageByteOrder {
        match self {
            Self::BigEndian => ffi::G_DBUS_MESSAGE_BYTE_ORDER_BIG_ENDIAN,
            Self::LittleEndian => ffi::G_DBUS_MESSAGE_BYTE_ORDER_LITTLE_ENDIAN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GDBusMessageByteOrder> for DBusMessageByteOrder {
    #[inline]
    unsafe fn from_glib(value: ffi::GDBusMessageByteOrder) -> Self {
        match value {
            ffi::G_DBUS_MESSAGE_BYTE_ORDER_BIG_ENDIAN => Self::BigEndian,
            ffi::G_DBUS_MESSAGE_BYTE_ORDER_LITTLE_ENDIAN => Self::LittleEndian,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for DBusMessageByteOrder {
    #[inline]
    #[doc(alias = "g_dbus_message_byte_order_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_dbus_message_byte_order_get_type()) }
    }
}

impl glib::HasParamSpec for DBusMessageByteOrder {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for DBusMessageByteOrder {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for DBusMessageByteOrder {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DBusMessageByteOrder {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<DBusMessageByteOrder> for glib::Value {
    #[inline]
    fn from(v: DBusMessageByteOrder) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GDBusMessageHeaderField")]
pub enum DBusMessageHeaderField {
    #[doc(alias = "G_DBUS_MESSAGE_HEADER_FIELD_INVALID")]
    Invalid,
    #[doc(alias = "G_DBUS_MESSAGE_HEADER_FIELD_PATH")]
    Path,
    #[doc(alias = "G_DBUS_MESSAGE_HEADER_FIELD_INTERFACE")]
    Interface,
    #[doc(alias = "G_DBUS_MESSAGE_HEADER_FIELD_MEMBER")]
    Member,
    #[doc(alias = "G_DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME")]
    ErrorName,
    #[doc(alias = "G_DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL")]
    ReplySerial,
    #[doc(alias = "G_DBUS_MESSAGE_HEADER_FIELD_DESTINATION")]
    Destination,
    #[doc(alias = "G_DBUS_MESSAGE_HEADER_FIELD_SENDER")]
    Sender,
    #[doc(alias = "G_DBUS_MESSAGE_HEADER_FIELD_SIGNATURE")]
    Signature,
    #[doc(alias = "G_DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS")]
    NumUnixFds,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for DBusMessageHeaderField {
    type GlibType = ffi::GDBusMessageHeaderField;

    #[inline]
    fn into_glib(self) -> ffi::GDBusMessageHeaderField {
        match self {
            Self::Invalid => ffi::G_DBUS_MESSAGE_HEADER_FIELD_INVALID,
            Self::Path => ffi::G_DBUS_MESSAGE_HEADER_FIELD_PATH,
            Self::Interface => ffi::G_DBUS_MESSAGE_HEADER_FIELD_INTERFACE,
            Self::Member => ffi::G_DBUS_MESSAGE_HEADER_FIELD_MEMBER,
            Self::ErrorName => ffi::G_DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME,
            Self::ReplySerial => ffi::G_DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL,
            Self::Destination => ffi::G_DBUS_MESSAGE_HEADER_FIELD_DESTINATION,
            Self::Sender => ffi::G_DBUS_MESSAGE_HEADER_FIELD_SENDER,
            Self::Signature => ffi::G_DBUS_MESSAGE_HEADER_FIELD_SIGNATURE,
            Self::NumUnixFds => ffi::G_DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GDBusMessageHeaderField> for DBusMessageHeaderField {
    #[inline]
    unsafe fn from_glib(value: ffi::GDBusMessageHeaderField) -> Self {
        match value {
            ffi::G_DBUS_MESSAGE_HEADER_FIELD_INVALID => Self::Invalid,
            ffi::G_DBUS_MESSAGE_HEADER_FIELD_PATH => Self::Path,
            ffi::G_DBUS_MESSAGE_HEADER_FIELD_INTERFACE => Self::Interface,
            ffi::G_DBUS_MESSAGE_HEADER_FIELD_MEMBER => Self::Member,
            ffi::G_DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME => Self::ErrorName,
            ffi::G_DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL => Self::ReplySerial,
            ffi::G_DBUS_MESSAGE_HEADER_FIELD_DESTINATION => Self::Destination,
            ffi::G_DBUS_MESSAGE_HEADER_FIELD_SENDER => Self::Sender,
            ffi::G_DBUS_MESSAGE_HEADER_FIELD_SIGNATURE => Self::Signature,
            ffi::G_DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS => Self::NumUnixFds,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for DBusMessageHeaderField {
    #[inline]
    #[doc(alias = "g_dbus_message_header_field_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_dbus_message_header_field_get_type()) }
    }
}

impl glib::HasParamSpec for DBusMessageHeaderField {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for DBusMessageHeaderField {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for DBusMessageHeaderField {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DBusMessageHeaderField {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<DBusMessageHeaderField> for glib::Value {
    #[inline]
    fn from(v: DBusMessageHeaderField) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GDBusMessageType")]
pub enum DBusMessageType {
    #[doc(alias = "G_DBUS_MESSAGE_TYPE_INVALID")]
    Invalid,
    #[doc(alias = "G_DBUS_MESSAGE_TYPE_METHOD_CALL")]
    MethodCall,
    #[doc(alias = "G_DBUS_MESSAGE_TYPE_METHOD_RETURN")]
    MethodReturn,
    #[doc(alias = "G_DBUS_MESSAGE_TYPE_ERROR")]
    Error,
    #[doc(alias = "G_DBUS_MESSAGE_TYPE_SIGNAL")]
    Signal,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for DBusMessageType {
    type GlibType = ffi::GDBusMessageType;

    #[inline]
    fn into_glib(self) -> ffi::GDBusMessageType {
        match self {
            Self::Invalid => ffi::G_DBUS_MESSAGE_TYPE_INVALID,
            Self::MethodCall => ffi::G_DBUS_MESSAGE_TYPE_METHOD_CALL,
            Self::MethodReturn => ffi::G_DBUS_MESSAGE_TYPE_METHOD_RETURN,
            Self::Error => ffi::G_DBUS_MESSAGE_TYPE_ERROR,
            Self::Signal => ffi::G_DBUS_MESSAGE_TYPE_SIGNAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GDBusMessageType> for DBusMessageType {
    #[inline]
    unsafe fn from_glib(value: ffi::GDBusMessageType) -> Self {
        match value {
            ffi::G_DBUS_MESSAGE_TYPE_INVALID => Self::Invalid,
            ffi::G_DBUS_MESSAGE_TYPE_METHOD_CALL => Self::MethodCall,
            ffi::G_DBUS_MESSAGE_TYPE_METHOD_RETURN => Self::MethodReturn,
            ffi::G_DBUS_MESSAGE_TYPE_ERROR => Self::Error,
            ffi::G_DBUS_MESSAGE_TYPE_SIGNAL => Self::Signal,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for DBusMessageType {
    #[inline]
    #[doc(alias = "g_dbus_message_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_dbus_message_type_get_type()) }
    }
}

impl glib::HasParamSpec for DBusMessageType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for DBusMessageType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for DBusMessageType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DBusMessageType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<DBusMessageType> for glib::Value {
    #[inline]
    fn from(v: DBusMessageType) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GDataStreamByteOrder")]
pub enum DataStreamByteOrder {
    #[doc(alias = "G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN")]
    BigEndian,
    #[doc(alias = "G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN")]
    LittleEndian,
    #[doc(alias = "G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN")]
    HostEndian,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for DataStreamByteOrder {
    type GlibType = ffi::GDataStreamByteOrder;

    #[inline]
    fn into_glib(self) -> ffi::GDataStreamByteOrder {
        match self {
            Self::BigEndian => ffi::G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN,
            Self::LittleEndian => ffi::G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN,
            Self::HostEndian => ffi::G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GDataStreamByteOrder> for DataStreamByteOrder {
    #[inline]
    unsafe fn from_glib(value: ffi::GDataStreamByteOrder) -> Self {
        match value {
            ffi::G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN => Self::BigEndian,
            ffi::G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN => Self::LittleEndian,
            ffi::G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN => Self::HostEndian,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for DataStreamByteOrder {
    #[inline]
    #[doc(alias = "g_data_stream_byte_order_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_data_stream_byte_order_get_type()) }
    }
}

impl glib::HasParamSpec for DataStreamByteOrder {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for DataStreamByteOrder {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for DataStreamByteOrder {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DataStreamByteOrder {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<DataStreamByteOrder> for glib::Value {
    #[inline]
    fn from(v: DataStreamByteOrder) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GDataStreamNewlineType")]
pub enum DataStreamNewlineType {
    #[doc(alias = "G_DATA_STREAM_NEWLINE_TYPE_LF")]
    Lf,
    #[doc(alias = "G_DATA_STREAM_NEWLINE_TYPE_CR")]
    Cr,
    #[doc(alias = "G_DATA_STREAM_NEWLINE_TYPE_CR_LF")]
    CrLf,
    #[doc(alias = "G_DATA_STREAM_NEWLINE_TYPE_ANY")]
    Any,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for DataStreamNewlineType {
    type GlibType = ffi::GDataStreamNewlineType;

    #[inline]
    fn into_glib(self) -> ffi::GDataStreamNewlineType {
        match self {
            Self::Lf => ffi::G_DATA_STREAM_NEWLINE_TYPE_LF,
            Self::Cr => ffi::G_DATA_STREAM_NEWLINE_TYPE_CR,
            Self::CrLf => ffi::G_DATA_STREAM_NEWLINE_TYPE_CR_LF,
            Self::Any => ffi::G_DATA_STREAM_NEWLINE_TYPE_ANY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GDataStreamNewlineType> for DataStreamNewlineType {
    #[inline]
    unsafe fn from_glib(value: ffi::GDataStreamNewlineType) -> Self {
        match value {
            ffi::G_DATA_STREAM_NEWLINE_TYPE_LF => Self::Lf,
            ffi::G_DATA_STREAM_NEWLINE_TYPE_CR => Self::Cr,
            ffi::G_DATA_STREAM_NEWLINE_TYPE_CR_LF => Self::CrLf,
            ffi::G_DATA_STREAM_NEWLINE_TYPE_ANY => Self::Any,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for DataStreamNewlineType {
    #[inline]
    #[doc(alias = "g_data_stream_newline_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_data_stream_newline_type_get_type()) }
    }
}

impl glib::HasParamSpec for DataStreamNewlineType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for DataStreamNewlineType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for DataStreamNewlineType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DataStreamNewlineType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<DataStreamNewlineType> for glib::Value {
    #[inline]
    fn from(v: DataStreamNewlineType) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GDriveStartStopType")]
pub enum DriveStartStopType {
    #[doc(alias = "G_DRIVE_START_STOP_TYPE_UNKNOWN")]
    Unknown,
    #[doc(alias = "G_DRIVE_START_STOP_TYPE_SHUTDOWN")]
    Shutdown,
    #[doc(alias = "G_DRIVE_START_STOP_TYPE_NETWORK")]
    Network,
    #[doc(alias = "G_DRIVE_START_STOP_TYPE_MULTIDISK")]
    Multidisk,
    #[doc(alias = "G_DRIVE_START_STOP_TYPE_PASSWORD")]
    Password,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for DriveStartStopType {
    type GlibType = ffi::GDriveStartStopType;

    #[inline]
    fn into_glib(self) -> ffi::GDriveStartStopType {
        match self {
            Self::Unknown => ffi::G_DRIVE_START_STOP_TYPE_UNKNOWN,
            Self::Shutdown => ffi::G_DRIVE_START_STOP_TYPE_SHUTDOWN,
            Self::Network => ffi::G_DRIVE_START_STOP_TYPE_NETWORK,
            Self::Multidisk => ffi::G_DRIVE_START_STOP_TYPE_MULTIDISK,
            Self::Password => ffi::G_DRIVE_START_STOP_TYPE_PASSWORD,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GDriveStartStopType> for DriveStartStopType {
    #[inline]
    unsafe fn from_glib(value: ffi::GDriveStartStopType) -> Self {
        match value {
            ffi::G_DRIVE_START_STOP_TYPE_UNKNOWN => Self::Unknown,
            ffi::G_DRIVE_START_STOP_TYPE_SHUTDOWN => Self::Shutdown,
            ffi::G_DRIVE_START_STOP_TYPE_NETWORK => Self::Network,
            ffi::G_DRIVE_START_STOP_TYPE_MULTIDISK => Self::Multidisk,
            ffi::G_DRIVE_START_STOP_TYPE_PASSWORD => Self::Password,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for DriveStartStopType {
    #[inline]
    #[doc(alias = "g_drive_start_stop_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_drive_start_stop_type_get_type()) }
    }
}

impl glib::HasParamSpec for DriveStartStopType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for DriveStartStopType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for DriveStartStopType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DriveStartStopType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<DriveStartStopType> for glib::Value {
    #[inline]
    fn from(v: DriveStartStopType) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GEmblemOrigin")]
pub enum EmblemOrigin {
    #[doc(alias = "G_EMBLEM_ORIGIN_UNKNOWN")]
    Unknown,
    #[doc(alias = "G_EMBLEM_ORIGIN_DEVICE")]
    Device,
    #[doc(alias = "G_EMBLEM_ORIGIN_LIVEMETADATA")]
    Livemetadata,
    #[doc(alias = "G_EMBLEM_ORIGIN_TAG")]
    Tag,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for EmblemOrigin {
    type GlibType = ffi::GEmblemOrigin;

    #[inline]
    fn into_glib(self) -> ffi::GEmblemOrigin {
        match self {
            Self::Unknown => ffi::G_EMBLEM_ORIGIN_UNKNOWN,
            Self::Device => ffi::G_EMBLEM_ORIGIN_DEVICE,
            Self::Livemetadata => ffi::G_EMBLEM_ORIGIN_LIVEMETADATA,
            Self::Tag => ffi::G_EMBLEM_ORIGIN_TAG,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GEmblemOrigin> for EmblemOrigin {
    #[inline]
    unsafe fn from_glib(value: ffi::GEmblemOrigin) -> Self {
        match value {
            ffi::G_EMBLEM_ORIGIN_UNKNOWN => Self::Unknown,
            ffi::G_EMBLEM_ORIGIN_DEVICE => Self::Device,
            ffi::G_EMBLEM_ORIGIN_LIVEMETADATA => Self::Livemetadata,
            ffi::G_EMBLEM_ORIGIN_TAG => Self::Tag,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for EmblemOrigin {
    #[inline]
    #[doc(alias = "g_emblem_origin_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_emblem_origin_get_type()) }
    }
}

impl glib::HasParamSpec for EmblemOrigin {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for EmblemOrigin {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for EmblemOrigin {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for EmblemOrigin {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<EmblemOrigin> for glib::Value {
    #[inline]
    fn from(v: EmblemOrigin) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GFileAttributeStatus")]
pub enum FileAttributeStatus {
    #[doc(alias = "G_FILE_ATTRIBUTE_STATUS_UNSET")]
    Unset,
    #[doc(alias = "G_FILE_ATTRIBUTE_STATUS_SET")]
    Set,
    #[doc(alias = "G_FILE_ATTRIBUTE_STATUS_ERROR_SETTING")]
    ErrorSetting,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for FileAttributeStatus {
    type GlibType = ffi::GFileAttributeStatus;

    #[inline]
    fn into_glib(self) -> ffi::GFileAttributeStatus {
        match self {
            Self::Unset => ffi::G_FILE_ATTRIBUTE_STATUS_UNSET,
            Self::Set => ffi::G_FILE_ATTRIBUTE_STATUS_SET,
            Self::ErrorSetting => ffi::G_FILE_ATTRIBUTE_STATUS_ERROR_SETTING,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GFileAttributeStatus> for FileAttributeStatus {
    #[inline]
    unsafe fn from_glib(value: ffi::GFileAttributeStatus) -> Self {
        match value {
            ffi::G_FILE_ATTRIBUTE_STATUS_UNSET => Self::Unset,
            ffi::G_FILE_ATTRIBUTE_STATUS_SET => Self::Set,
            ffi::G_FILE_ATTRIBUTE_STATUS_ERROR_SETTING => Self::ErrorSetting,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for FileAttributeStatus {
    #[inline]
    #[doc(alias = "g_file_attribute_status_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_file_attribute_status_get_type()) }
    }
}

impl glib::HasParamSpec for FileAttributeStatus {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for FileAttributeStatus {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for FileAttributeStatus {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FileAttributeStatus {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<FileAttributeStatus> for glib::Value {
    #[inline]
    fn from(v: FileAttributeStatus) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GFileAttributeType")]
pub enum FileAttributeType {
    #[doc(alias = "G_FILE_ATTRIBUTE_TYPE_INVALID")]
    Invalid,
    #[doc(alias = "G_FILE_ATTRIBUTE_TYPE_STRING")]
    String,
    #[doc(alias = "G_FILE_ATTRIBUTE_TYPE_BYTE_STRING")]
    ByteString,
    #[doc(alias = "G_FILE_ATTRIBUTE_TYPE_BOOLEAN")]
    Boolean,
    #[doc(alias = "G_FILE_ATTRIBUTE_TYPE_UINT32")]
    Uint32,
    #[doc(alias = "G_FILE_ATTRIBUTE_TYPE_INT32")]
    Int32,
    #[doc(alias = "G_FILE_ATTRIBUTE_TYPE_UINT64")]
    Uint64,
    #[doc(alias = "G_FILE_ATTRIBUTE_TYPE_INT64")]
    Int64,
    #[doc(alias = "G_FILE_ATTRIBUTE_TYPE_OBJECT")]
    Object,
    #[doc(alias = "G_FILE_ATTRIBUTE_TYPE_STRINGV")]
    Stringv,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for FileAttributeType {
    type GlibType = ffi::GFileAttributeType;

    #[inline]
    fn into_glib(self) -> ffi::GFileAttributeType {
        match self {
            Self::Invalid => ffi::G_FILE_ATTRIBUTE_TYPE_INVALID,
            Self::String => ffi::G_FILE_ATTRIBUTE_TYPE_STRING,
            Self::ByteString => ffi::G_FILE_ATTRIBUTE_TYPE_BYTE_STRING,
            Self::Boolean => ffi::G_FILE_ATTRIBUTE_TYPE_BOOLEAN,
            Self::Uint32 => ffi::G_FILE_ATTRIBUTE_TYPE_UINT32,
            Self::Int32 => ffi::G_FILE_ATTRIBUTE_TYPE_INT32,
            Self::Uint64 => ffi::G_FILE_ATTRIBUTE_TYPE_UINT64,
            Self::Int64 => ffi::G_FILE_ATTRIBUTE_TYPE_INT64,
            Self::Object => ffi::G_FILE_ATTRIBUTE_TYPE_OBJECT,
            Self::Stringv => ffi::G_FILE_ATTRIBUTE_TYPE_STRINGV,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GFileAttributeType> for FileAttributeType {
    #[inline]
    unsafe fn from_glib(value: ffi::GFileAttributeType) -> Self {
        match value {
            ffi::G_FILE_ATTRIBUTE_TYPE_INVALID => Self::Invalid,
            ffi::G_FILE_ATTRIBUTE_TYPE_STRING => Self::String,
            ffi::G_FILE_ATTRIBUTE_TYPE_BYTE_STRING => Self::ByteString,
            ffi::G_FILE_ATTRIBUTE_TYPE_BOOLEAN => Self::Boolean,
            ffi::G_FILE_ATTRIBUTE_TYPE_UINT32 => Self::Uint32,
            ffi::G_FILE_ATTRIBUTE_TYPE_INT32 => Self::Int32,
            ffi::G_FILE_ATTRIBUTE_TYPE_UINT64 => Self::Uint64,
            ffi::G_FILE_ATTRIBUTE_TYPE_INT64 => Self::Int64,
            ffi::G_FILE_ATTRIBUTE_TYPE_OBJECT => Self::Object,
            ffi::G_FILE_ATTRIBUTE_TYPE_STRINGV => Self::Stringv,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for FileAttributeType {
    #[inline]
    #[doc(alias = "g_file_attribute_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_file_attribute_type_get_type()) }
    }
}

impl glib::HasParamSpec for FileAttributeType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for FileAttributeType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for FileAttributeType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FileAttributeType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<FileAttributeType> for glib::Value {
    #[inline]
    fn from(v: FileAttributeType) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GFileMonitorEvent")]
pub enum FileMonitorEvent {
    #[doc(alias = "G_FILE_MONITOR_EVENT_CHANGED")]
    Changed,
    #[doc(alias = "G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT")]
    ChangesDoneHint,
    #[doc(alias = "G_FILE_MONITOR_EVENT_DELETED")]
    Deleted,
    #[doc(alias = "G_FILE_MONITOR_EVENT_CREATED")]
    Created,
    #[doc(alias = "G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED")]
    AttributeChanged,
    #[doc(alias = "G_FILE_MONITOR_EVENT_PRE_UNMOUNT")]
    PreUnmount,
    #[doc(alias = "G_FILE_MONITOR_EVENT_UNMOUNTED")]
    Unmounted,
    #[doc(alias = "G_FILE_MONITOR_EVENT_MOVED")]
    Moved,
    #[doc(alias = "G_FILE_MONITOR_EVENT_RENAMED")]
    Renamed,
    #[doc(alias = "G_FILE_MONITOR_EVENT_MOVED_IN")]
    MovedIn,
    #[doc(alias = "G_FILE_MONITOR_EVENT_MOVED_OUT")]
    MovedOut,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for FileMonitorEvent {
    type GlibType = ffi::GFileMonitorEvent;

    #[inline]
    fn into_glib(self) -> ffi::GFileMonitorEvent {
        match self {
            Self::Changed => ffi::G_FILE_MONITOR_EVENT_CHANGED,
            Self::ChangesDoneHint => ffi::G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT,
            Self::Deleted => ffi::G_FILE_MONITOR_EVENT_DELETED,
            Self::Created => ffi::G_FILE_MONITOR_EVENT_CREATED,
            Self::AttributeChanged => ffi::G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED,
            Self::PreUnmount => ffi::G_FILE_MONITOR_EVENT_PRE_UNMOUNT,
            Self::Unmounted => ffi::G_FILE_MONITOR_EVENT_UNMOUNTED,
            Self::Moved => ffi::G_FILE_MONITOR_EVENT_MOVED,
            Self::Renamed => ffi::G_FILE_MONITOR_EVENT_RENAMED,
            Self::MovedIn => ffi::G_FILE_MONITOR_EVENT_MOVED_IN,
            Self::MovedOut => ffi::G_FILE_MONITOR_EVENT_MOVED_OUT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GFileMonitorEvent> for FileMonitorEvent {
    #[inline]
    unsafe fn from_glib(value: ffi::GFileMonitorEvent) -> Self {
        match value {
            ffi::G_FILE_MONITOR_EVENT_CHANGED => Self::Changed,
            ffi::G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT => Self::ChangesDoneHint,
            ffi::G_FILE_MONITOR_EVENT_DELETED => Self::Deleted,
            ffi::G_FILE_MONITOR_EVENT_CREATED => Self::Created,
            ffi::G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED => Self::AttributeChanged,
            ffi::G_FILE_MONITOR_EVENT_PRE_UNMOUNT => Self::PreUnmount,
            ffi::G_FILE_MONITOR_EVENT_UNMOUNTED => Self::Unmounted,
            ffi::G_FILE_MONITOR_EVENT_MOVED => Self::Moved,
            ffi::G_FILE_MONITOR_EVENT_RENAMED => Self::Renamed,
            ffi::G_FILE_MONITOR_EVENT_MOVED_IN => Self::MovedIn,
            ffi::G_FILE_MONITOR_EVENT_MOVED_OUT => Self::MovedOut,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for FileMonitorEvent {
    #[inline]
    #[doc(alias = "g_file_monitor_event_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_file_monitor_event_get_type()) }
    }
}

impl glib::HasParamSpec for FileMonitorEvent {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for FileMonitorEvent {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for FileMonitorEvent {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FileMonitorEvent {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<FileMonitorEvent> for glib::Value {
    #[inline]
    fn from(v: FileMonitorEvent) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GFileType")]
pub enum FileType {
    #[doc(alias = "G_FILE_TYPE_UNKNOWN")]
    Unknown,
    #[doc(alias = "G_FILE_TYPE_REGULAR")]
    Regular,
    #[doc(alias = "G_FILE_TYPE_DIRECTORY")]
    Directory,
    #[doc(alias = "G_FILE_TYPE_SYMBOLIC_LINK")]
    SymbolicLink,
    #[doc(alias = "G_FILE_TYPE_SPECIAL")]
    Special,
    #[doc(alias = "G_FILE_TYPE_SHORTCUT")]
    Shortcut,
    #[doc(alias = "G_FILE_TYPE_MOUNTABLE")]
    Mountable,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for FileType {
    type GlibType = ffi::GFileType;

    #[inline]
    fn into_glib(self) -> ffi::GFileType {
        match self {
            Self::Unknown => ffi::G_FILE_TYPE_UNKNOWN,
            Self::Regular => ffi::G_FILE_TYPE_REGULAR,
            Self::Directory => ffi::G_FILE_TYPE_DIRECTORY,
            Self::SymbolicLink => ffi::G_FILE_TYPE_SYMBOLIC_LINK,
            Self::Special => ffi::G_FILE_TYPE_SPECIAL,
            Self::Shortcut => ffi::G_FILE_TYPE_SHORTCUT,
            Self::Mountable => ffi::G_FILE_TYPE_MOUNTABLE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GFileType> for FileType {
    #[inline]
    unsafe fn from_glib(value: ffi::GFileType) -> Self {
        match value {
            ffi::G_FILE_TYPE_UNKNOWN => Self::Unknown,
            ffi::G_FILE_TYPE_REGULAR => Self::Regular,
            ffi::G_FILE_TYPE_DIRECTORY => Self::Directory,
            ffi::G_FILE_TYPE_SYMBOLIC_LINK => Self::SymbolicLink,
            ffi::G_FILE_TYPE_SPECIAL => Self::Special,
            ffi::G_FILE_TYPE_SHORTCUT => Self::Shortcut,
            ffi::G_FILE_TYPE_MOUNTABLE => Self::Mountable,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for FileType {
    #[inline]
    #[doc(alias = "g_file_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_file_type_get_type()) }
    }
}

impl glib::HasParamSpec for FileType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for FileType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for FileType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FileType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<FileType> for glib::Value {
    #[inline]
    fn from(v: FileType) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GIOErrorEnum")]
pub enum IOErrorEnum {
    #[doc(alias = "G_IO_ERROR_FAILED")]
    Failed,
    #[doc(alias = "G_IO_ERROR_NOT_FOUND")]
    NotFound,
    #[doc(alias = "G_IO_ERROR_EXISTS")]
    Exists,
    #[doc(alias = "G_IO_ERROR_IS_DIRECTORY")]
    IsDirectory,
    #[doc(alias = "G_IO_ERROR_NOT_DIRECTORY")]
    NotDirectory,
    #[doc(alias = "G_IO_ERROR_NOT_EMPTY")]
    NotEmpty,
    #[doc(alias = "G_IO_ERROR_NOT_REGULAR_FILE")]
    NotRegularFile,
    #[doc(alias = "G_IO_ERROR_NOT_SYMBOLIC_LINK")]
    NotSymbolicLink,
    #[doc(alias = "G_IO_ERROR_NOT_MOUNTABLE_FILE")]
    NotMountableFile,
    #[doc(alias = "G_IO_ERROR_FILENAME_TOO_LONG")]
    FilenameTooLong,
    #[doc(alias = "G_IO_ERROR_INVALID_FILENAME")]
    InvalidFilename,
    #[doc(alias = "G_IO_ERROR_TOO_MANY_LINKS")]
    TooManyLinks,
    #[doc(alias = "G_IO_ERROR_NO_SPACE")]
    NoSpace,
    #[doc(alias = "G_IO_ERROR_INVALID_ARGUMENT")]
    InvalidArgument,
    #[doc(alias = "G_IO_ERROR_PERMISSION_DENIED")]
    PermissionDenied,
    #[doc(alias = "G_IO_ERROR_NOT_SUPPORTED")]
    NotSupported,
    #[doc(alias = "G_IO_ERROR_NOT_MOUNTED")]
    NotMounted,
    #[doc(alias = "G_IO_ERROR_ALREADY_MOUNTED")]
    AlreadyMounted,
    #[doc(alias = "G_IO_ERROR_CLOSED")]
    Closed,
    #[doc(alias = "G_IO_ERROR_CANCELLED")]
    Cancelled,
    #[doc(alias = "G_IO_ERROR_PENDING")]
    Pending,
    #[doc(alias = "G_IO_ERROR_READ_ONLY")]
    ReadOnly,
    #[doc(alias = "G_IO_ERROR_CANT_CREATE_BACKUP")]
    CantCreateBackup,
    #[doc(alias = "G_IO_ERROR_WRONG_ETAG")]
    WrongEtag,
    #[doc(alias = "G_IO_ERROR_TIMED_OUT")]
    TimedOut,
    #[doc(alias = "G_IO_ERROR_WOULD_RECURSE")]
    WouldRecurse,
    #[doc(alias = "G_IO_ERROR_BUSY")]
    Busy,
    #[doc(alias = "G_IO_ERROR_WOULD_BLOCK")]
    WouldBlock,
    #[doc(alias = "G_IO_ERROR_HOST_NOT_FOUND")]
    HostNotFound,
    #[doc(alias = "G_IO_ERROR_WOULD_MERGE")]
    WouldMerge,
    #[doc(alias = "G_IO_ERROR_FAILED_HANDLED")]
    FailedHandled,
    #[doc(alias = "G_IO_ERROR_TOO_MANY_OPEN_FILES")]
    TooManyOpenFiles,
    #[doc(alias = "G_IO_ERROR_NOT_INITIALIZED")]
    NotInitialized,
    #[doc(alias = "G_IO_ERROR_ADDRESS_IN_USE")]
    AddressInUse,
    #[doc(alias = "G_IO_ERROR_PARTIAL_INPUT")]
    PartialInput,
    #[doc(alias = "G_IO_ERROR_INVALID_DATA")]
    InvalidData,
    #[doc(alias = "G_IO_ERROR_DBUS_ERROR")]
    DbusError,
    #[doc(alias = "G_IO_ERROR_HOST_UNREACHABLE")]
    HostUnreachable,
    #[doc(alias = "G_IO_ERROR_NETWORK_UNREACHABLE")]
    NetworkUnreachable,
    #[doc(alias = "G_IO_ERROR_CONNECTION_REFUSED")]
    ConnectionRefused,
    #[doc(alias = "G_IO_ERROR_PROXY_FAILED")]
    ProxyFailed,
    #[doc(alias = "G_IO_ERROR_PROXY_AUTH_FAILED")]
    ProxyAuthFailed,
    #[doc(alias = "G_IO_ERROR_PROXY_NEED_AUTH")]
    ProxyNeedAuth,
    #[doc(alias = "G_IO_ERROR_PROXY_NOT_ALLOWED")]
    ProxyNotAllowed,
    #[doc(alias = "G_IO_ERROR_BROKEN_PIPE")]
    BrokenPipe,
    #[doc(alias = "G_IO_ERROR_NOT_CONNECTED")]
    NotConnected,
    #[doc(alias = "G_IO_ERROR_MESSAGE_TOO_LARGE")]
    MessageTooLarge,
    #[cfg(feature = "v2_72")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_72")))]
    #[doc(alias = "G_IO_ERROR_NO_SUCH_DEVICE")]
    NoSuchDevice,
    #[cfg(feature = "v2_80")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_80")))]
    #[doc(alias = "G_IO_ERROR_DESTINATION_UNSET")]
    DestinationUnset,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for IOErrorEnum {
    type GlibType = ffi::GIOErrorEnum;

    fn into_glib(self) -> ffi::GIOErrorEnum {
        match self {
            Self::Failed => ffi::G_IO_ERROR_FAILED,
            Self::NotFound => ffi::G_IO_ERROR_NOT_FOUND,
            Self::Exists => ffi::G_IO_ERROR_EXISTS,
            Self::IsDirectory => ffi::G_IO_ERROR_IS_DIRECTORY,
            Self::NotDirectory => ffi::G_IO_ERROR_NOT_DIRECTORY,
            Self::NotEmpty => ffi::G_IO_ERROR_NOT_EMPTY,
            Self::NotRegularFile => ffi::G_IO_ERROR_NOT_REGULAR_FILE,
            Self::NotSymbolicLink => ffi::G_IO_ERROR_NOT_SYMBOLIC_LINK,
            Self::NotMountableFile => ffi::G_IO_ERROR_NOT_MOUNTABLE_FILE,
            Self::FilenameTooLong => ffi::G_IO_ERROR_FILENAME_TOO_LONG,
            Self::InvalidFilename => ffi::G_IO_ERROR_INVALID_FILENAME,
            Self::TooManyLinks => ffi::G_IO_ERROR_TOO_MANY_LINKS,
            Self::NoSpace => ffi::G_IO_ERROR_NO_SPACE,
            Self::InvalidArgument => ffi::G_IO_ERROR_INVALID_ARGUMENT,
            Self::PermissionDenied => ffi::G_IO_ERROR_PERMISSION_DENIED,
            Self::NotSupported => ffi::G_IO_ERROR_NOT_SUPPORTED,
            Self::NotMounted => ffi::G_IO_ERROR_NOT_MOUNTED,
            Self::AlreadyMounted => ffi::G_IO_ERROR_ALREADY_MOUNTED,
            Self::Closed => ffi::G_IO_ERROR_CLOSED,
            Self::Cancelled => ffi::G_IO_ERROR_CANCELLED,
            Self::Pending => ffi::G_IO_ERROR_PENDING,
            Self::ReadOnly => ffi::G_IO_ERROR_READ_ONLY,
            Self::CantCreateBackup => ffi::G_IO_ERROR_CANT_CREATE_BACKUP,
            Self::WrongEtag => ffi::G_IO_ERROR_WRONG_ETAG,
            Self::TimedOut => ffi::G_IO_ERROR_TIMED_OUT,
            Self::WouldRecurse => ffi::G_IO_ERROR_WOULD_RECURSE,
            Self::Busy => ffi::G_IO_ERROR_BUSY,
            Self::WouldBlock => ffi::G_IO_ERROR_WOULD_BLOCK,
            Self::HostNotFound => ffi::G_IO_ERROR_HOST_NOT_FOUND,
            Self::WouldMerge => ffi::G_IO_ERROR_WOULD_MERGE,
            Self::FailedHandled => ffi::G_IO_ERROR_FAILED_HANDLED,
            Self::TooManyOpenFiles => ffi::G_IO_ERROR_TOO_MANY_OPEN_FILES,
            Self::NotInitialized => ffi::G_IO_ERROR_NOT_INITIALIZED,
            Self::AddressInUse => ffi::G_IO_ERROR_ADDRESS_IN_USE,
            Self::PartialInput => ffi::G_IO_ERROR_PARTIAL_INPUT,
            Self::InvalidData => ffi::G_IO_ERROR_INVALID_DATA,
            Self::DbusError => ffi::G_IO_ERROR_DBUS_ERROR,
            Self::HostUnreachable => ffi::G_IO_ERROR_HOST_UNREACHABLE,
            Self::NetworkUnreachable => ffi::G_IO_ERROR_NETWORK_UNREACHABLE,
            Self::ConnectionRefused => ffi::G_IO_ERROR_CONNECTION_REFUSED,
            Self::ProxyFailed => ffi::G_IO_ERROR_PROXY_FAILED,
            Self::ProxyAuthFailed => ffi::G_IO_ERROR_PROXY_AUTH_FAILED,
            Self::ProxyNeedAuth => ffi::G_IO_ERROR_PROXY_NEED_AUTH,
            Self::ProxyNotAllowed => ffi::G_IO_ERROR_PROXY_NOT_ALLOWED,
            Self::BrokenPipe => ffi::G_IO_ERROR_BROKEN_PIPE,
            Self::NotConnected => ffi::G_IO_ERROR_NOT_CONNECTED,
            Self::MessageTooLarge => ffi::G_IO_ERROR_MESSAGE_TOO_LARGE,
            #[cfg(feature = "v2_72")]
            Self::NoSuchDevice => ffi::G_IO_ERROR_NO_SUCH_DEVICE,
            #[cfg(feature = "v2_80")]
            Self::DestinationUnset => ffi::G_IO_ERROR_DESTINATION_UNSET,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GIOErrorEnum> for IOErrorEnum {
    unsafe fn from_glib(value: ffi::GIOErrorEnum) -> Self {
        match value {
            ffi::G_IO_ERROR_FAILED => Self::Failed,
            ffi::G_IO_ERROR_NOT_FOUND => Self::NotFound,
            ffi::G_IO_ERROR_EXISTS => Self::Exists,
            ffi::G_IO_ERROR_IS_DIRECTORY => Self::IsDirectory,
            ffi::G_IO_ERROR_NOT_DIRECTORY => Self::NotDirectory,
            ffi::G_IO_ERROR_NOT_EMPTY => Self::NotEmpty,
            ffi::G_IO_ERROR_NOT_REGULAR_FILE => Self::NotRegularFile,
            ffi::G_IO_ERROR_NOT_SYMBOLIC_LINK => Self::NotSymbolicLink,
            ffi::G_IO_ERROR_NOT_MOUNTABLE_FILE => Self::NotMountableFile,
            ffi::G_IO_ERROR_FILENAME_TOO_LONG => Self::FilenameTooLong,
            ffi::G_IO_ERROR_INVALID_FILENAME => Self::InvalidFilename,
            ffi::G_IO_ERROR_TOO_MANY_LINKS => Self::TooManyLinks,
            ffi::G_IO_ERROR_NO_SPACE => Self::NoSpace,
            ffi::G_IO_ERROR_INVALID_ARGUMENT => Self::InvalidArgument,
            ffi::G_IO_ERROR_PERMISSION_DENIED => Self::PermissionDenied,
            ffi::G_IO_ERROR_NOT_SUPPORTED => Self::NotSupported,
            ffi::G_IO_ERROR_NOT_MOUNTED => Self::NotMounted,
            ffi::G_IO_ERROR_ALREADY_MOUNTED => Self::AlreadyMounted,
            ffi::G_IO_ERROR_CLOSED => Self::Closed,
            ffi::G_IO_ERROR_CANCELLED => Self::Cancelled,
            ffi::G_IO_ERROR_PENDING => Self::Pending,
            ffi::G_IO_ERROR_READ_ONLY => Self::ReadOnly,
            ffi::G_IO_ERROR_CANT_CREATE_BACKUP => Self::CantCreateBackup,
            ffi::G_IO_ERROR_WRONG_ETAG => Self::WrongEtag,
            ffi::G_IO_ERROR_TIMED_OUT => Self::TimedOut,
            ffi::G_IO_ERROR_WOULD_RECURSE => Self::WouldRecurse,
            ffi::G_IO_ERROR_BUSY => Self::Busy,
            ffi::G_IO_ERROR_WOULD_BLOCK => Self::WouldBlock,
            ffi::G_IO_ERROR_HOST_NOT_FOUND => Self::HostNotFound,
            ffi::G_IO_ERROR_WOULD_MERGE => Self::WouldMerge,
            ffi::G_IO_ERROR_FAILED_HANDLED => Self::FailedHandled,
            ffi::G_IO_ERROR_TOO_MANY_OPEN_FILES => Self::TooManyOpenFiles,
            ffi::G_IO_ERROR_NOT_INITIALIZED => Self::NotInitialized,
            ffi::G_IO_ERROR_ADDRESS_IN_USE => Self::AddressInUse,
            ffi::G_IO_ERROR_PARTIAL_INPUT => Self::PartialInput,
            ffi::G_IO_ERROR_INVALID_DATA => Self::InvalidData,
            ffi::G_IO_ERROR_DBUS_ERROR => Self::DbusError,
            ffi::G_IO_ERROR_HOST_UNREACHABLE => Self::HostUnreachable,
            ffi::G_IO_ERROR_NETWORK_UNREACHABLE => Self::NetworkUnreachable,
            ffi::G_IO_ERROR_CONNECTION_REFUSED => Self::ConnectionRefused,
            ffi::G_IO_ERROR_PROXY_FAILED => Self::ProxyFailed,
            ffi::G_IO_ERROR_PROXY_AUTH_FAILED => Self::ProxyAuthFailed,
            ffi::G_IO_ERROR_PROXY_NEED_AUTH => Self::ProxyNeedAuth,
            ffi::G_IO_ERROR_PROXY_NOT_ALLOWED => Self::ProxyNotAllowed,
            ffi::G_IO_ERROR_BROKEN_PIPE => Self::BrokenPipe,
            ffi::G_IO_ERROR_NOT_CONNECTED => Self::NotConnected,
            ffi::G_IO_ERROR_MESSAGE_TOO_LARGE => Self::MessageTooLarge,
            #[cfg(feature = "v2_72")]
            ffi::G_IO_ERROR_NO_SUCH_DEVICE => Self::NoSuchDevice,
            #[cfg(feature = "v2_80")]
            ffi::G_IO_ERROR_DESTINATION_UNSET => Self::DestinationUnset,
            value => Self::__Unknown(value),
        }
    }
}

impl glib::error::ErrorDomain for IOErrorEnum {
    #[inline]
    fn domain() -> glib::Quark {
        unsafe { from_glib(ffi::g_io_error_quark()) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        match unsafe { from_glib(code) } {
            Self::__Unknown(_) => Some(Self::Failed),
            value => Some(value),
        }
    }
}

impl StaticType for IOErrorEnum {
    #[inline]
    #[doc(alias = "g_io_error_enum_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_io_error_enum_get_type()) }
    }
}

impl glib::HasParamSpec for IOErrorEnum {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for IOErrorEnum {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for IOErrorEnum {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for IOErrorEnum {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<IOErrorEnum> for glib::Value {
    #[inline]
    fn from(v: IOErrorEnum) -> Self {
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v2_64")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_64")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMemoryMonitorWarningLevel")]
pub enum MemoryMonitorWarningLevel {
    #[doc(alias = "G_MEMORY_MONITOR_WARNING_LEVEL_LOW")]
    Low,
    #[doc(alias = "G_MEMORY_MONITOR_WARNING_LEVEL_MEDIUM")]
    Medium,
    #[doc(alias = "G_MEMORY_MONITOR_WARNING_LEVEL_CRITICAL")]
    Critical,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v2_64")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_64")))]
#[doc(hidden)]
impl IntoGlib for MemoryMonitorWarningLevel {
    type GlibType = ffi::GMemoryMonitorWarningLevel;

    #[inline]
    fn into_glib(self) -> ffi::GMemoryMonitorWarningLevel {
        match self {
            Self::Low => ffi::G_MEMORY_MONITOR_WARNING_LEVEL_LOW,
            Self::Medium => ffi::G_MEMORY_MONITOR_WARNING_LEVEL_MEDIUM,
            Self::Critical => ffi::G_MEMORY_MONITOR_WARNING_LEVEL_CRITICAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v2_64")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_64")))]
#[doc(hidden)]
impl FromGlib<ffi::GMemoryMonitorWarningLevel> for MemoryMonitorWarningLevel {
    #[inline]
    unsafe fn from_glib(value: ffi::GMemoryMonitorWarningLevel) -> Self {
        match value {
            ffi::G_MEMORY_MONITOR_WARNING_LEVEL_LOW => Self::Low,
            ffi::G_MEMORY_MONITOR_WARNING_LEVEL_MEDIUM => Self::Medium,
            ffi::G_MEMORY_MONITOR_WARNING_LEVEL_CRITICAL => Self::Critical,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v2_64")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_64")))]
impl StaticType for MemoryMonitorWarningLevel {
    #[inline]
    #[doc(alias = "g_memory_monitor_warning_level_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_memory_monitor_warning_level_get_type()) }
    }
}

#[cfg(feature = "v2_64")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_64")))]
impl glib::HasParamSpec for MemoryMonitorWarningLevel {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v2_64")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_64")))]
impl glib::value::ValueType for MemoryMonitorWarningLevel {
    type Type = Self;
}

#[cfg(feature = "v2_64")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_64")))]
unsafe impl<'a> glib::value::FromValue<'a> for MemoryMonitorWarningLevel {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v2_64")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_64")))]
impl ToValue for MemoryMonitorWarningLevel {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v2_64")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_64")))]
impl From<MemoryMonitorWarningLevel> for glib::Value {
    #[inline]
    fn from(v: MemoryMonitorWarningLevel) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMountOperationResult")]
pub enum MountOperationResult {
    #[doc(alias = "G_MOUNT_OPERATION_HANDLED")]
    Handled,
    #[doc(alias = "G_MOUNT_OPERATION_ABORTED")]
    Aborted,
    #[doc(alias = "G_MOUNT_OPERATION_UNHANDLED")]
    Unhandled,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for MountOperationResult {
    type GlibType = ffi::GMountOperationResult;

    #[inline]
    fn into_glib(self) -> ffi::GMountOperationResult {
        match self {
            Self::Handled => ffi::G_MOUNT_OPERATION_HANDLED,
            Self::Aborted => ffi::G_MOUNT_OPERATION_ABORTED,
            Self::Unhandled => ffi::G_MOUNT_OPERATION_UNHANDLED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMountOperationResult> for MountOperationResult {
    #[inline]
    unsafe fn from_glib(value: ffi::GMountOperationResult) -> Self {
        match value {
            ffi::G_MOUNT_OPERATION_HANDLED => Self::Handled,
            ffi::G_MOUNT_OPERATION_ABORTED => Self::Aborted,
            ffi::G_MOUNT_OPERATION_UNHANDLED => Self::Unhandled,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for MountOperationResult {
    #[inline]
    #[doc(alias = "g_mount_operation_result_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_mount_operation_result_get_type()) }
    }
}

impl glib::HasParamSpec for MountOperationResult {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for MountOperationResult {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for MountOperationResult {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for MountOperationResult {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<MountOperationResult> for glib::Value {
    #[inline]
    fn from(v: MountOperationResult) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GNetworkConnectivity")]
pub enum NetworkConnectivity {
    #[doc(alias = "G_NETWORK_CONNECTIVITY_LOCAL")]
    Local,
    #[doc(alias = "G_NETWORK_CONNECTIVITY_LIMITED")]
    Limited,
    #[doc(alias = "G_NETWORK_CONNECTIVITY_PORTAL")]
    Portal,
    #[doc(alias = "G_NETWORK_CONNECTIVITY_FULL")]
    Full,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for NetworkConnectivity {
    type GlibType = ffi::GNetworkConnectivity;

    #[inline]
    fn into_glib(self) -> ffi::GNetworkConnectivity {
        match self {
            Self::Local => ffi::G_NETWORK_CONNECTIVITY_LOCAL,
            Self::Limited => ffi::G_NETWORK_CONNECTIVITY_LIMITED,
            Self::Portal => ffi::G_NETWORK_CONNECTIVITY_PORTAL,
            Self::Full => ffi::G_NETWORK_CONNECTIVITY_FULL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GNetworkConnectivity> for NetworkConnectivity {
    #[inline]
    unsafe fn from_glib(value: ffi::GNetworkConnectivity) -> Self {
        match value {
            ffi::G_NETWORK_CONNECTIVITY_LOCAL => Self::Local,
            ffi::G_NETWORK_CONNECTIVITY_LIMITED => Self::Limited,
            ffi::G_NETWORK_CONNECTIVITY_PORTAL => Self::Portal,
            ffi::G_NETWORK_CONNECTIVITY_FULL => Self::Full,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for NetworkConnectivity {
    #[inline]
    #[doc(alias = "g_network_connectivity_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_network_connectivity_get_type()) }
    }
}

impl glib::HasParamSpec for NetworkConnectivity {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for NetworkConnectivity {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for NetworkConnectivity {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for NetworkConnectivity {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<NetworkConnectivity> for glib::Value {
    #[inline]
    fn from(v: NetworkConnectivity) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GNotificationPriority")]
pub enum NotificationPriority {
    #[doc(alias = "G_NOTIFICATION_PRIORITY_NORMAL")]
    Normal,
    #[doc(alias = "G_NOTIFICATION_PRIORITY_LOW")]
    Low,
    #[doc(alias = "G_NOTIFICATION_PRIORITY_HIGH")]
    High,
    #[doc(alias = "G_NOTIFICATION_PRIORITY_URGENT")]
    Urgent,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for NotificationPriority {
    type GlibType = ffi::GNotificationPriority;

    #[inline]
    fn into_glib(self) -> ffi::GNotificationPriority {
        match self {
            Self::Normal => ffi::G_NOTIFICATION_PRIORITY_NORMAL,
            Self::Low => ffi::G_NOTIFICATION_PRIORITY_LOW,
            Self::High => ffi::G_NOTIFICATION_PRIORITY_HIGH,
            Self::Urgent => ffi::G_NOTIFICATION_PRIORITY_URGENT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GNotificationPriority> for NotificationPriority {
    #[inline]
    unsafe fn from_glib(value: ffi::GNotificationPriority) -> Self {
        match value {
            ffi::G_NOTIFICATION_PRIORITY_NORMAL => Self::Normal,
            ffi::G_NOTIFICATION_PRIORITY_LOW => Self::Low,
            ffi::G_NOTIFICATION_PRIORITY_HIGH => Self::High,
            ffi::G_NOTIFICATION_PRIORITY_URGENT => Self::Urgent,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for NotificationPriority {
    #[inline]
    #[doc(alias = "g_notification_priority_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_notification_priority_get_type()) }
    }
}

impl glib::HasParamSpec for NotificationPriority {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for NotificationPriority {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for NotificationPriority {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for NotificationPriority {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<NotificationPriority> for glib::Value {
    #[inline]
    fn from(v: NotificationPriority) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GPasswordSave")]
pub enum PasswordSave {
    #[doc(alias = "G_PASSWORD_SAVE_NEVER")]
    Never,
    #[doc(alias = "G_PASSWORD_SAVE_FOR_SESSION")]
    ForSession,
    #[doc(alias = "G_PASSWORD_SAVE_PERMANENTLY")]
    Permanently,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for PasswordSave {
    type GlibType = ffi::GPasswordSave;

    #[inline]
    fn into_glib(self) -> ffi::GPasswordSave {
        match self {
            Self::Never => ffi::G_PASSWORD_SAVE_NEVER,
            Self::ForSession => ffi::G_PASSWORD_SAVE_FOR_SESSION,
            Self::Permanently => ffi::G_PASSWORD_SAVE_PERMANENTLY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GPasswordSave> for PasswordSave {
    #[inline]
    unsafe fn from_glib(value: ffi::GPasswordSave) -> Self {
        match value {
            ffi::G_PASSWORD_SAVE_NEVER => Self::Never,
            ffi::G_PASSWORD_SAVE_FOR_SESSION => Self::ForSession,
            ffi::G_PASSWORD_SAVE_PERMANENTLY => Self::Permanently,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PasswordSave {
    #[inline]
    #[doc(alias = "g_password_save_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_password_save_get_type()) }
    }
}

impl glib::HasParamSpec for PasswordSave {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for PasswordSave {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for PasswordSave {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PasswordSave {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<PasswordSave> for glib::Value {
    #[inline]
    fn from(v: PasswordSave) -> Self {
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v2_60")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_60")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GPollableReturn")]
pub enum PollableReturn {
    #[doc(alias = "G_POLLABLE_RETURN_FAILED")]
    Failed,
    #[doc(alias = "G_POLLABLE_RETURN_OK")]
    Ok,
    #[doc(alias = "G_POLLABLE_RETURN_WOULD_BLOCK")]
    WouldBlock,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v2_60")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_60")))]
#[doc(hidden)]
impl IntoGlib for PollableReturn {
    type GlibType = ffi::GPollableReturn;

    #[inline]
    fn into_glib(self) -> ffi::GPollableReturn {
        match self {
            Self::Failed => ffi::G_POLLABLE_RETURN_FAILED,
            Self::Ok => ffi::G_POLLABLE_RETURN_OK,
            Self::WouldBlock => ffi::G_POLLABLE_RETURN_WOULD_BLOCK,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v2_60")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_60")))]
#[doc(hidden)]
impl FromGlib<ffi::GPollableReturn> for PollableReturn {
    #[inline]
    unsafe fn from_glib(value: ffi::GPollableReturn) -> Self {
        match value {
            ffi::G_POLLABLE_RETURN_FAILED => Self::Failed,
            ffi::G_POLLABLE_RETURN_OK => Self::Ok,
            ffi::G_POLLABLE_RETURN_WOULD_BLOCK => Self::WouldBlock,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v2_60")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_60")))]
impl StaticType for PollableReturn {
    #[inline]
    #[doc(alias = "g_pollable_return_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_pollable_return_get_type()) }
    }
}

#[cfg(feature = "v2_60")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_60")))]
impl glib::HasParamSpec for PollableReturn {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v2_60")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_60")))]
impl glib::value::ValueType for PollableReturn {
    type Type = Self;
}

#[cfg(feature = "v2_60")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_60")))]
unsafe impl<'a> glib::value::FromValue<'a> for PollableReturn {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v2_60")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_60")))]
impl ToValue for PollableReturn {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v2_60")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_60")))]
impl From<PollableReturn> for glib::Value {
    #[inline]
    fn from(v: PollableReturn) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GResolverError")]
pub enum ResolverError {
    #[doc(alias = "G_RESOLVER_ERROR_NOT_FOUND")]
    NotFound,
    #[doc(alias = "G_RESOLVER_ERROR_TEMPORARY_FAILURE")]
    TemporaryFailure,
    #[doc(alias = "G_RESOLVER_ERROR_INTERNAL")]
    Internal,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ResolverError {
    type GlibType = ffi::GResolverError;

    #[inline]
    fn into_glib(self) -> ffi::GResolverError {
        match self {
            Self::NotFound => ffi::G_RESOLVER_ERROR_NOT_FOUND,
            Self::TemporaryFailure => ffi::G_RESOLVER_ERROR_TEMPORARY_FAILURE,
            Self::Internal => ffi::G_RESOLVER_ERROR_INTERNAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GResolverError> for ResolverError {
    #[inline]
    unsafe fn from_glib(value: ffi::GResolverError) -> Self {
        match value {
            ffi::G_RESOLVER_ERROR_NOT_FOUND => Self::NotFound,
            ffi::G_RESOLVER_ERROR_TEMPORARY_FAILURE => Self::TemporaryFailure,
            ffi::G_RESOLVER_ERROR_INTERNAL => Self::Internal,
            value => Self::__Unknown(value),
        }
    }
}

impl glib::error::ErrorDomain for ResolverError {
    #[inline]
    fn domain() -> glib::Quark {
        unsafe { from_glib(ffi::g_resolver_error_quark()) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        match unsafe { from_glib(code) } {
            value => Some(value),
        }
    }
}

impl StaticType for ResolverError {
    #[inline]
    #[doc(alias = "g_resolver_error_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_resolver_error_get_type()) }
    }
}

impl glib::HasParamSpec for ResolverError {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for ResolverError {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for ResolverError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ResolverError {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<ResolverError> for glib::Value {
    #[inline]
    fn from(v: ResolverError) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GResolverRecordType")]
pub enum ResolverRecordType {
    #[doc(alias = "G_RESOLVER_RECORD_SRV")]
    Srv,
    #[doc(alias = "G_RESOLVER_RECORD_MX")]
    Mx,
    #[doc(alias = "G_RESOLVER_RECORD_TXT")]
    Txt,
    #[doc(alias = "G_RESOLVER_RECORD_SOA")]
    Soa,
    #[doc(alias = "G_RESOLVER_RECORD_NS")]
    Ns,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ResolverRecordType {
    type GlibType = ffi::GResolverRecordType;

    #[inline]
    fn into_glib(self) -> ffi::GResolverRecordType {
        match self {
            Self::Srv => ffi::G_RESOLVER_RECORD_SRV,
            Self::Mx => ffi::G_RESOLVER_RECORD_MX,
            Self::Txt => ffi::G_RESOLVER_RECORD_TXT,
            Self::Soa => ffi::G_RESOLVER_RECORD_SOA,
            Self::Ns => ffi::G_RESOLVER_RECORD_NS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GResolverRecordType> for ResolverRecordType {
    #[inline]
    unsafe fn from_glib(value: ffi::GResolverRecordType) -> Self {
        match value {
            ffi::G_RESOLVER_RECORD_SRV => Self::Srv,
            ffi::G_RESOLVER_RECORD_MX => Self::Mx,
            ffi::G_RESOLVER_RECORD_TXT => Self::Txt,
            ffi::G_RESOLVER_RECORD_SOA => Self::Soa,
            ffi::G_RESOLVER_RECORD_NS => Self::Ns,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ResolverRecordType {
    #[inline]
    #[doc(alias = "g_resolver_record_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_resolver_record_type_get_type()) }
    }
}

impl glib::HasParamSpec for ResolverRecordType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for ResolverRecordType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for ResolverRecordType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ResolverRecordType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<ResolverRecordType> for glib::Value {
    #[inline]
    fn from(v: ResolverRecordType) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GResourceError")]
pub enum ResourceError {
    #[doc(alias = "G_RESOURCE_ERROR_NOT_FOUND")]
    NotFound,
    #[doc(alias = "G_RESOURCE_ERROR_INTERNAL")]
    Internal,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ResourceError {
    type GlibType = ffi::GResourceError;

    #[inline]
    fn into_glib(self) -> ffi::GResourceError {
        match self {
            Self::NotFound => ffi::G_RESOURCE_ERROR_NOT_FOUND,
            Self::Internal => ffi::G_RESOURCE_ERROR_INTERNAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GResourceError> for ResourceError {
    #[inline]
    unsafe fn from_glib(value: ffi::GResourceError) -> Self {
        match value {
            ffi::G_RESOURCE_ERROR_NOT_FOUND => Self::NotFound,
            ffi::G_RESOURCE_ERROR_INTERNAL => Self::Internal,
            value => Self::__Unknown(value),
        }
    }
}

impl glib::error::ErrorDomain for ResourceError {
    #[inline]
    fn domain() -> glib::Quark {
        unsafe { from_glib(ffi::g_resource_error_quark()) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        match unsafe { from_glib(code) } {
            value => Some(value),
        }
    }
}

impl StaticType for ResourceError {
    #[inline]
    #[doc(alias = "g_resource_error_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_resource_error_get_type()) }
    }
}

impl glib::HasParamSpec for ResourceError {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for ResourceError {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for ResourceError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ResourceError {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<ResourceError> for glib::Value {
    #[inline]
    fn from(v: ResourceError) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GSocketClientEvent")]
pub enum SocketClientEvent {
    #[doc(alias = "G_SOCKET_CLIENT_RESOLVING")]
    Resolving,
    #[doc(alias = "G_SOCKET_CLIENT_RESOLVED")]
    Resolved,
    #[doc(alias = "G_SOCKET_CLIENT_CONNECTING")]
    Connecting,
    #[doc(alias = "G_SOCKET_CLIENT_CONNECTED")]
    Connected,
    #[doc(alias = "G_SOCKET_CLIENT_PROXY_NEGOTIATING")]
    ProxyNegotiating,
    #[doc(alias = "G_SOCKET_CLIENT_PROXY_NEGOTIATED")]
    ProxyNegotiated,
    #[doc(alias = "G_SOCKET_CLIENT_TLS_HANDSHAKING")]
    TlsHandshaking,
    #[doc(alias = "G_SOCKET_CLIENT_TLS_HANDSHAKED")]
    TlsHandshaked,
    #[doc(alias = "G_SOCKET_CLIENT_COMPLETE")]
    Complete,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for SocketClientEvent {
    type GlibType = ffi::GSocketClientEvent;

    #[inline]
    fn into_glib(self) -> ffi::GSocketClientEvent {
        match self {
            Self::Resolving => ffi::G_SOCKET_CLIENT_RESOLVING,
            Self::Resolved => ffi::G_SOCKET_CLIENT_RESOLVED,
            Self::Connecting => ffi::G_SOCKET_CLIENT_CONNECTING,
            Self::Connected => ffi::G_SOCKET_CLIENT_CONNECTED,
            Self::ProxyNegotiating => ffi::G_SOCKET_CLIENT_PROXY_NEGOTIATING,
            Self::ProxyNegotiated => ffi::G_SOCKET_CLIENT_PROXY_NEGOTIATED,
            Self::TlsHandshaking => ffi::G_SOCKET_CLIENT_TLS_HANDSHAKING,
            Self::TlsHandshaked => ffi::G_SOCKET_CLIENT_TLS_HANDSHAKED,
            Self::Complete => ffi::G_SOCKET_CLIENT_COMPLETE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GSocketClientEvent> for SocketClientEvent {
    #[inline]
    unsafe fn from_glib(value: ffi::GSocketClientEvent) -> Self {
        match value {
            ffi::G_SOCKET_CLIENT_RESOLVING => Self::Resolving,
            ffi::G_SOCKET_CLIENT_RESOLVED => Self::Resolved,
            ffi::G_SOCKET_CLIENT_CONNECTING => Self::Connecting,
            ffi::G_SOCKET_CLIENT_CONNECTED => Self::Connected,
            ffi::G_SOCKET_CLIENT_PROXY_NEGOTIATING => Self::ProxyNegotiating,
            ffi::G_SOCKET_CLIENT_PROXY_NEGOTIATED => Self::ProxyNegotiated,
            ffi::G_SOCKET_CLIENT_TLS_HANDSHAKING => Self::TlsHandshaking,
            ffi::G_SOCKET_CLIENT_TLS_HANDSHAKED => Self::TlsHandshaked,
            ffi::G_SOCKET_CLIENT_COMPLETE => Self::Complete,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SocketClientEvent {
    #[inline]
    #[doc(alias = "g_socket_client_event_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_socket_client_event_get_type()) }
    }
}

impl glib::HasParamSpec for SocketClientEvent {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for SocketClientEvent {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for SocketClientEvent {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SocketClientEvent {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<SocketClientEvent> for glib::Value {
    #[inline]
    fn from(v: SocketClientEvent) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GSocketFamily")]
pub enum SocketFamily {
    #[doc(alias = "G_SOCKET_FAMILY_INVALID")]
    Invalid,
    #[doc(alias = "G_SOCKET_FAMILY_UNIX")]
    Unix,
    #[doc(alias = "G_SOCKET_FAMILY_IPV4")]
    Ipv4,
    #[doc(alias = "G_SOCKET_FAMILY_IPV6")]
    Ipv6,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for SocketFamily {
    type GlibType = ffi::GSocketFamily;

    #[inline]
    fn into_glib(self) -> ffi::GSocketFamily {
        match self {
            Self::Invalid => ffi::G_SOCKET_FAMILY_INVALID,
            Self::Unix => ffi::G_SOCKET_FAMILY_UNIX,
            Self::Ipv4 => ffi::G_SOCKET_FAMILY_IPV4,
            Self::Ipv6 => ffi::G_SOCKET_FAMILY_IPV6,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GSocketFamily> for SocketFamily {
    #[inline]
    unsafe fn from_glib(value: ffi::GSocketFamily) -> Self {
        match value {
            ffi::G_SOCKET_FAMILY_INVALID => Self::Invalid,
            ffi::G_SOCKET_FAMILY_UNIX => Self::Unix,
            ffi::G_SOCKET_FAMILY_IPV4 => Self::Ipv4,
            ffi::G_SOCKET_FAMILY_IPV6 => Self::Ipv6,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SocketFamily {
    #[inline]
    #[doc(alias = "g_socket_family_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_socket_family_get_type()) }
    }
}

impl glib::HasParamSpec for SocketFamily {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for SocketFamily {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for SocketFamily {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SocketFamily {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<SocketFamily> for glib::Value {
    #[inline]
    fn from(v: SocketFamily) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GSocketListenerEvent")]
pub enum SocketListenerEvent {
    #[doc(alias = "G_SOCKET_LISTENER_BINDING")]
    Binding,
    #[doc(alias = "G_SOCKET_LISTENER_BOUND")]
    Bound,
    #[doc(alias = "G_SOCKET_LISTENER_LISTENING")]
    Listening,
    #[doc(alias = "G_SOCKET_LISTENER_LISTENED")]
    Listened,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for SocketListenerEvent {
    type GlibType = ffi::GSocketListenerEvent;

    #[inline]
    fn into_glib(self) -> ffi::GSocketListenerEvent {
        match self {
            Self::Binding => ffi::G_SOCKET_LISTENER_BINDING,
            Self::Bound => ffi::G_SOCKET_LISTENER_BOUND,
            Self::Listening => ffi::G_SOCKET_LISTENER_LISTENING,
            Self::Listened => ffi::G_SOCKET_LISTENER_LISTENED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GSocketListenerEvent> for SocketListenerEvent {
    #[inline]
    unsafe fn from_glib(value: ffi::GSocketListenerEvent) -> Self {
        match value {
            ffi::G_SOCKET_LISTENER_BINDING => Self::Binding,
            ffi::G_SOCKET_LISTENER_BOUND => Self::Bound,
            ffi::G_SOCKET_LISTENER_LISTENING => Self::Listening,
            ffi::G_SOCKET_LISTENER_LISTENED => Self::Listened,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SocketListenerEvent {
    #[inline]
    #[doc(alias = "g_socket_listener_event_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_socket_listener_event_get_type()) }
    }
}

impl glib::HasParamSpec for SocketListenerEvent {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for SocketListenerEvent {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for SocketListenerEvent {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SocketListenerEvent {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<SocketListenerEvent> for glib::Value {
    #[inline]
    fn from(v: SocketListenerEvent) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GSocketProtocol")]
pub enum SocketProtocol {
    #[doc(alias = "G_SOCKET_PROTOCOL_UNKNOWN")]
    Unknown,
    #[doc(alias = "G_SOCKET_PROTOCOL_DEFAULT")]
    Default,
    #[doc(alias = "G_SOCKET_PROTOCOL_TCP")]
    Tcp,
    #[doc(alias = "G_SOCKET_PROTOCOL_UDP")]
    Udp,
    #[doc(alias = "G_SOCKET_PROTOCOL_SCTP")]
    Sctp,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for SocketProtocol {
    type GlibType = ffi::GSocketProtocol;

    #[inline]
    fn into_glib(self) -> ffi::GSocketProtocol {
        match self {
            Self::Unknown => ffi::G_SOCKET_PROTOCOL_UNKNOWN,
            Self::Default => ffi::G_SOCKET_PROTOCOL_DEFAULT,
            Self::Tcp => ffi::G_SOCKET_PROTOCOL_TCP,
            Self::Udp => ffi::G_SOCKET_PROTOCOL_UDP,
            Self::Sctp => ffi::G_SOCKET_PROTOCOL_SCTP,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GSocketProtocol> for SocketProtocol {
    #[inline]
    unsafe fn from_glib(value: ffi::GSocketProtocol) -> Self {
        match value {
            ffi::G_SOCKET_PROTOCOL_UNKNOWN => Self::Unknown,
            ffi::G_SOCKET_PROTOCOL_DEFAULT => Self::Default,
            ffi::G_SOCKET_PROTOCOL_TCP => Self::Tcp,
            ffi::G_SOCKET_PROTOCOL_UDP => Self::Udp,
            ffi::G_SOCKET_PROTOCOL_SCTP => Self::Sctp,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SocketProtocol {
    #[inline]
    #[doc(alias = "g_socket_protocol_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_socket_protocol_get_type()) }
    }
}

impl glib::HasParamSpec for SocketProtocol {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for SocketProtocol {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for SocketProtocol {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SocketProtocol {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<SocketProtocol> for glib::Value {
    #[inline]
    fn from(v: SocketProtocol) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GSocketType")]
pub enum SocketType {
    #[doc(alias = "G_SOCKET_TYPE_INVALID")]
    Invalid,
    #[doc(alias = "G_SOCKET_TYPE_STREAM")]
    Stream,
    #[doc(alias = "G_SOCKET_TYPE_DATAGRAM")]
    Datagram,
    #[doc(alias = "G_SOCKET_TYPE_SEQPACKET")]
    Seqpacket,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for SocketType {
    type GlibType = ffi::GSocketType;

    #[inline]
    fn into_glib(self) -> ffi::GSocketType {
        match self {
            Self::Invalid => ffi::G_SOCKET_TYPE_INVALID,
            Self::Stream => ffi::G_SOCKET_TYPE_STREAM,
            Self::Datagram => ffi::G_SOCKET_TYPE_DATAGRAM,
            Self::Seqpacket => ffi::G_SOCKET_TYPE_SEQPACKET,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GSocketType> for SocketType {
    #[inline]
    unsafe fn from_glib(value: ffi::GSocketType) -> Self {
        match value {
            ffi::G_SOCKET_TYPE_INVALID => Self::Invalid,
            ffi::G_SOCKET_TYPE_STREAM => Self::Stream,
            ffi::G_SOCKET_TYPE_DATAGRAM => Self::Datagram,
            ffi::G_SOCKET_TYPE_SEQPACKET => Self::Seqpacket,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SocketType {
    #[inline]
    #[doc(alias = "g_socket_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_socket_type_get_type()) }
    }
}

impl glib::HasParamSpec for SocketType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for SocketType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for SocketType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SocketType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<SocketType> for glib::Value {
    #[inline]
    fn from(v: SocketType) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GTlsAuthenticationMode")]
pub enum TlsAuthenticationMode {
    #[doc(alias = "G_TLS_AUTHENTICATION_NONE")]
    None,
    #[doc(alias = "G_TLS_AUTHENTICATION_REQUESTED")]
    Requested,
    #[doc(alias = "G_TLS_AUTHENTICATION_REQUIRED")]
    Required,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TlsAuthenticationMode {
    type GlibType = ffi::GTlsAuthenticationMode;

    #[inline]
    fn into_glib(self) -> ffi::GTlsAuthenticationMode {
        match self {
            Self::None => ffi::G_TLS_AUTHENTICATION_NONE,
            Self::Requested => ffi::G_TLS_AUTHENTICATION_REQUESTED,
            Self::Required => ffi::G_TLS_AUTHENTICATION_REQUIRED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GTlsAuthenticationMode> for TlsAuthenticationMode {
    #[inline]
    unsafe fn from_glib(value: ffi::GTlsAuthenticationMode) -> Self {
        match value {
            ffi::G_TLS_AUTHENTICATION_NONE => Self::None,
            ffi::G_TLS_AUTHENTICATION_REQUESTED => Self::Requested,
            ffi::G_TLS_AUTHENTICATION_REQUIRED => Self::Required,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TlsAuthenticationMode {
    #[inline]
    #[doc(alias = "g_tls_authentication_mode_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_tls_authentication_mode_get_type()) }
    }
}

impl glib::HasParamSpec for TlsAuthenticationMode {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for TlsAuthenticationMode {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for TlsAuthenticationMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TlsAuthenticationMode {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<TlsAuthenticationMode> for glib::Value {
    #[inline]
    fn from(v: TlsAuthenticationMode) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GTlsCertificateRequestFlags")]
pub enum TlsCertificateRequestFlags {
    #[doc(alias = "G_TLS_CERTIFICATE_REQUEST_NONE")]
    None,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TlsCertificateRequestFlags {
    type GlibType = ffi::GTlsCertificateRequestFlags;

    #[inline]
    fn into_glib(self) -> ffi::GTlsCertificateRequestFlags {
        match self {
            Self::None => ffi::G_TLS_CERTIFICATE_REQUEST_NONE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GTlsCertificateRequestFlags> for TlsCertificateRequestFlags {
    #[inline]
    unsafe fn from_glib(value: ffi::GTlsCertificateRequestFlags) -> Self {
        match value {
            ffi::G_TLS_CERTIFICATE_REQUEST_NONE => Self::None,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TlsCertificateRequestFlags {
    #[inline]
    #[doc(alias = "g_tls_certificate_request_flags_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_tls_certificate_request_flags_get_type()) }
    }
}

impl glib::HasParamSpec for TlsCertificateRequestFlags {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for TlsCertificateRequestFlags {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for TlsCertificateRequestFlags {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TlsCertificateRequestFlags {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<TlsCertificateRequestFlags> for glib::Value {
    #[inline]
    fn from(v: TlsCertificateRequestFlags) -> Self {
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v2_66")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_66")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GTlsChannelBindingType")]
pub enum TlsChannelBindingType {
    #[doc(alias = "G_TLS_CHANNEL_BINDING_TLS_UNIQUE")]
    Unique,
    #[doc(alias = "G_TLS_CHANNEL_BINDING_TLS_SERVER_END_POINT")]
    ServerEndPoint,
    #[cfg(feature = "v2_74")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_74")))]
    #[doc(alias = "G_TLS_CHANNEL_BINDING_TLS_EXPORTER")]
    Exporter,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v2_66")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_66")))]
#[doc(hidden)]
impl IntoGlib for TlsChannelBindingType {
    type GlibType = ffi::GTlsChannelBindingType;

    #[inline]
    fn into_glib(self) -> ffi::GTlsChannelBindingType {
        match self {
            Self::Unique => ffi::G_TLS_CHANNEL_BINDING_TLS_UNIQUE,
            Self::ServerEndPoint => ffi::G_TLS_CHANNEL_BINDING_TLS_SERVER_END_POINT,
            #[cfg(feature = "v2_74")]
            Self::Exporter => ffi::G_TLS_CHANNEL_BINDING_TLS_EXPORTER,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v2_66")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_66")))]
#[doc(hidden)]
impl FromGlib<ffi::GTlsChannelBindingType> for TlsChannelBindingType {
    #[inline]
    unsafe fn from_glib(value: ffi::GTlsChannelBindingType) -> Self {
        match value {
            ffi::G_TLS_CHANNEL_BINDING_TLS_UNIQUE => Self::Unique,
            ffi::G_TLS_CHANNEL_BINDING_TLS_SERVER_END_POINT => Self::ServerEndPoint,
            #[cfg(feature = "v2_74")]
            ffi::G_TLS_CHANNEL_BINDING_TLS_EXPORTER => Self::Exporter,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v2_66")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_66")))]
impl StaticType for TlsChannelBindingType {
    #[inline]
    #[doc(alias = "g_tls_channel_binding_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_tls_channel_binding_type_get_type()) }
    }
}

#[cfg(feature = "v2_66")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_66")))]
impl glib::HasParamSpec for TlsChannelBindingType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v2_66")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_66")))]
impl glib::value::ValueType for TlsChannelBindingType {
    type Type = Self;
}

#[cfg(feature = "v2_66")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_66")))]
unsafe impl<'a> glib::value::FromValue<'a> for TlsChannelBindingType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v2_66")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_66")))]
impl ToValue for TlsChannelBindingType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v2_66")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_66")))]
impl From<TlsChannelBindingType> for glib::Value {
    #[inline]
    fn from(v: TlsChannelBindingType) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GTlsDatabaseLookupFlags")]
pub enum TlsDatabaseLookupFlags {
    #[doc(alias = "G_TLS_DATABASE_LOOKUP_NONE")]
    None,
    #[doc(alias = "G_TLS_DATABASE_LOOKUP_KEYPAIR")]
    Keypair,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TlsDatabaseLookupFlags {
    type GlibType = ffi::GTlsDatabaseLookupFlags;

    #[inline]
    fn into_glib(self) -> ffi::GTlsDatabaseLookupFlags {
        match self {
            Self::None => ffi::G_TLS_DATABASE_LOOKUP_NONE,
            Self::Keypair => ffi::G_TLS_DATABASE_LOOKUP_KEYPAIR,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GTlsDatabaseLookupFlags> for TlsDatabaseLookupFlags {
    #[inline]
    unsafe fn from_glib(value: ffi::GTlsDatabaseLookupFlags) -> Self {
        match value {
            ffi::G_TLS_DATABASE_LOOKUP_NONE => Self::None,
            ffi::G_TLS_DATABASE_LOOKUP_KEYPAIR => Self::Keypair,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TlsDatabaseLookupFlags {
    #[inline]
    #[doc(alias = "g_tls_database_lookup_flags_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_tls_database_lookup_flags_get_type()) }
    }
}

impl glib::HasParamSpec for TlsDatabaseLookupFlags {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for TlsDatabaseLookupFlags {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for TlsDatabaseLookupFlags {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TlsDatabaseLookupFlags {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<TlsDatabaseLookupFlags> for glib::Value {
    #[inline]
    fn from(v: TlsDatabaseLookupFlags) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GTlsError")]
pub enum TlsError {
    #[doc(alias = "G_TLS_ERROR_UNAVAILABLE")]
    Unavailable,
    #[doc(alias = "G_TLS_ERROR_MISC")]
    Misc,
    #[doc(alias = "G_TLS_ERROR_BAD_CERTIFICATE")]
    BadCertificate,
    #[doc(alias = "G_TLS_ERROR_NOT_TLS")]
    NotTls,
    #[doc(alias = "G_TLS_ERROR_HANDSHAKE")]
    Handshake,
    #[doc(alias = "G_TLS_ERROR_CERTIFICATE_REQUIRED")]
    CertificateRequired,
    #[doc(alias = "G_TLS_ERROR_EOF")]
    Eof,
    #[doc(alias = "G_TLS_ERROR_INAPPROPRIATE_FALLBACK")]
    InappropriateFallback,
    #[cfg(feature = "v2_72")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_72")))]
    #[doc(alias = "G_TLS_ERROR_BAD_CERTIFICATE_PASSWORD")]
    BadCertificatePassword,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TlsError {
    type GlibType = ffi::GTlsError;

    #[inline]
    fn into_glib(self) -> ffi::GTlsError {
        match self {
            Self::Unavailable => ffi::G_TLS_ERROR_UNAVAILABLE,
            Self::Misc => ffi::G_TLS_ERROR_MISC,
            Self::BadCertificate => ffi::G_TLS_ERROR_BAD_CERTIFICATE,
            Self::NotTls => ffi::G_TLS_ERROR_NOT_TLS,
            Self::Handshake => ffi::G_TLS_ERROR_HANDSHAKE,
            Self::CertificateRequired => ffi::G_TLS_ERROR_CERTIFICATE_REQUIRED,
            Self::Eof => ffi::G_TLS_ERROR_EOF,
            Self::InappropriateFallback => ffi::G_TLS_ERROR_INAPPROPRIATE_FALLBACK,
            #[cfg(feature = "v2_72")]
            Self::BadCertificatePassword => ffi::G_TLS_ERROR_BAD_CERTIFICATE_PASSWORD,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GTlsError> for TlsError {
    #[inline]
    unsafe fn from_glib(value: ffi::GTlsError) -> Self {
        match value {
            ffi::G_TLS_ERROR_UNAVAILABLE => Self::Unavailable,
            ffi::G_TLS_ERROR_MISC => Self::Misc,
            ffi::G_TLS_ERROR_BAD_CERTIFICATE => Self::BadCertificate,
            ffi::G_TLS_ERROR_NOT_TLS => Self::NotTls,
            ffi::G_TLS_ERROR_HANDSHAKE => Self::Handshake,
            ffi::G_TLS_ERROR_CERTIFICATE_REQUIRED => Self::CertificateRequired,
            ffi::G_TLS_ERROR_EOF => Self::Eof,
            ffi::G_TLS_ERROR_INAPPROPRIATE_FALLBACK => Self::InappropriateFallback,
            #[cfg(feature = "v2_72")]
            ffi::G_TLS_ERROR_BAD_CERTIFICATE_PASSWORD => Self::BadCertificatePassword,
            value => Self::__Unknown(value),
        }
    }
}

impl glib::error::ErrorDomain for TlsError {
    #[inline]
    fn domain() -> glib::Quark {
        unsafe { from_glib(ffi::g_tls_error_quark()) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        match unsafe { from_glib(code) } {
            value => Some(value),
        }
    }
}

impl StaticType for TlsError {
    #[inline]
    #[doc(alias = "g_tls_error_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_tls_error_get_type()) }
    }
}

impl glib::HasParamSpec for TlsError {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for TlsError {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for TlsError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TlsError {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<TlsError> for glib::Value {
    #[inline]
    fn from(v: TlsError) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GTlsInteractionResult")]
pub enum TlsInteractionResult {
    #[doc(alias = "G_TLS_INTERACTION_UNHANDLED")]
    Unhandled,
    #[doc(alias = "G_TLS_INTERACTION_HANDLED")]
    Handled,
    #[doc(alias = "G_TLS_INTERACTION_FAILED")]
    Failed,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TlsInteractionResult {
    type GlibType = ffi::GTlsInteractionResult;

    #[inline]
    fn into_glib(self) -> ffi::GTlsInteractionResult {
        match self {
            Self::Unhandled => ffi::G_TLS_INTERACTION_UNHANDLED,
            Self::Handled => ffi::G_TLS_INTERACTION_HANDLED,
            Self::Failed => ffi::G_TLS_INTERACTION_FAILED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GTlsInteractionResult> for TlsInteractionResult {
    #[inline]
    unsafe fn from_glib(value: ffi::GTlsInteractionResult) -> Self {
        match value {
            ffi::G_TLS_INTERACTION_UNHANDLED => Self::Unhandled,
            ffi::G_TLS_INTERACTION_HANDLED => Self::Handled,
            ffi::G_TLS_INTERACTION_FAILED => Self::Failed,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TlsInteractionResult {
    #[inline]
    #[doc(alias = "g_tls_interaction_result_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_tls_interaction_result_get_type()) }
    }
}

impl glib::HasParamSpec for TlsInteractionResult {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for TlsInteractionResult {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for TlsInteractionResult {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TlsInteractionResult {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<TlsInteractionResult> for glib::Value {
    #[inline]
    fn from(v: TlsInteractionResult) -> Self {
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v2_70")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_70")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GTlsProtocolVersion")]
pub enum TlsProtocolVersion {
    #[doc(alias = "G_TLS_PROTOCOL_VERSION_UNKNOWN")]
    Unknown,
    #[doc(alias = "G_TLS_PROTOCOL_VERSION_SSL_3_0")]
    Ssl30,
    #[doc(alias = "G_TLS_PROTOCOL_VERSION_TLS_1_0")]
    Tls10,
    #[doc(alias = "G_TLS_PROTOCOL_VERSION_TLS_1_1")]
    Tls11,
    #[doc(alias = "G_TLS_PROTOCOL_VERSION_TLS_1_2")]
    Tls12,
    #[doc(alias = "G_TLS_PROTOCOL_VERSION_TLS_1_3")]
    Tls13,
    #[doc(alias = "G_TLS_PROTOCOL_VERSION_DTLS_1_0")]
    Dtls10,
    #[doc(alias = "G_TLS_PROTOCOL_VERSION_DTLS_1_2")]
    Dtls12,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v2_70")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_70")))]
#[doc(hidden)]
impl IntoGlib for TlsProtocolVersion {
    type GlibType = ffi::GTlsProtocolVersion;

    #[inline]
    fn into_glib(self) -> ffi::GTlsProtocolVersion {
        match self {
            Self::Unknown => ffi::G_TLS_PROTOCOL_VERSION_UNKNOWN,
            Self::Ssl30 => ffi::G_TLS_PROTOCOL_VERSION_SSL_3_0,
            Self::Tls10 => ffi::G_TLS_PROTOCOL_VERSION_TLS_1_0,
            Self::Tls11 => ffi::G_TLS_PROTOCOL_VERSION_TLS_1_1,
            Self::Tls12 => ffi::G_TLS_PROTOCOL_VERSION_TLS_1_2,
            Self::Tls13 => ffi::G_TLS_PROTOCOL_VERSION_TLS_1_3,
            Self::Dtls10 => ffi::G_TLS_PROTOCOL_VERSION_DTLS_1_0,
            Self::Dtls12 => ffi::G_TLS_PROTOCOL_VERSION_DTLS_1_2,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v2_70")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_70")))]
#[doc(hidden)]
impl FromGlib<ffi::GTlsProtocolVersion> for TlsProtocolVersion {
    #[inline]
    unsafe fn from_glib(value: ffi::GTlsProtocolVersion) -> Self {
        match value {
            ffi::G_TLS_PROTOCOL_VERSION_UNKNOWN => Self::Unknown,
            ffi::G_TLS_PROTOCOL_VERSION_SSL_3_0 => Self::Ssl30,
            ffi::G_TLS_PROTOCOL_VERSION_TLS_1_0 => Self::Tls10,
            ffi::G_TLS_PROTOCOL_VERSION_TLS_1_1 => Self::Tls11,
            ffi::G_TLS_PROTOCOL_VERSION_TLS_1_2 => Self::Tls12,
            ffi::G_TLS_PROTOCOL_VERSION_TLS_1_3 => Self::Tls13,
            ffi::G_TLS_PROTOCOL_VERSION_DTLS_1_0 => Self::Dtls10,
            ffi::G_TLS_PROTOCOL_VERSION_DTLS_1_2 => Self::Dtls12,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v2_70")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_70")))]
impl StaticType for TlsProtocolVersion {
    #[inline]
    #[doc(alias = "g_tls_protocol_version_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_tls_protocol_version_get_type()) }
    }
}

#[cfg(feature = "v2_70")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_70")))]
impl glib::HasParamSpec for TlsProtocolVersion {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v2_70")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_70")))]
impl glib::value::ValueType for TlsProtocolVersion {
    type Type = Self;
}

#[cfg(feature = "v2_70")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_70")))]
unsafe impl<'a> glib::value::FromValue<'a> for TlsProtocolVersion {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v2_70")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_70")))]
impl ToValue for TlsProtocolVersion {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v2_70")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_70")))]
impl From<TlsProtocolVersion> for glib::Value {
    #[inline]
    fn from(v: TlsProtocolVersion) -> Self {
        ToValue::to_value(&v)
    }
}

#[cfg_attr(feature = "v2_60", deprecated = "Since 2.60")]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GTlsRehandshakeMode")]
pub enum TlsRehandshakeMode {
    #[doc(alias = "G_TLS_REHANDSHAKE_NEVER")]
    Never,
    #[doc(alias = "G_TLS_REHANDSHAKE_SAFELY")]
    Safely,
    #[doc(alias = "G_TLS_REHANDSHAKE_UNSAFELY")]
    Unsafely,
    #[doc(hidden)]
    __Unknown(i32),
}

#[allow(deprecated)]
#[doc(hidden)]
impl IntoGlib for TlsRehandshakeMode {
    type GlibType = ffi::GTlsRehandshakeMode;

    #[inline]
    fn into_glib(self) -> ffi::GTlsRehandshakeMode {
        match self {
            Self::Never => ffi::G_TLS_REHANDSHAKE_NEVER,
            Self::Safely => ffi::G_TLS_REHANDSHAKE_SAFELY,
            Self::Unsafely => ffi::G_TLS_REHANDSHAKE_UNSAFELY,
            Self::__Unknown(value) => value,
        }
    }
}

#[allow(deprecated)]
#[doc(hidden)]
impl FromGlib<ffi::GTlsRehandshakeMode> for TlsRehandshakeMode {
    #[inline]
    unsafe fn from_glib(value: ffi::GTlsRehandshakeMode) -> Self {
        match value {
            ffi::G_TLS_REHANDSHAKE_NEVER => Self::Never,
            ffi::G_TLS_REHANDSHAKE_SAFELY => Self::Safely,
            ffi::G_TLS_REHANDSHAKE_UNSAFELY => Self::Unsafely,
            value => Self::__Unknown(value),
        }
    }
}

#[allow(deprecated)]
impl StaticType for TlsRehandshakeMode {
    #[inline]
    #[doc(alias = "g_tls_rehandshake_mode_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_tls_rehandshake_mode_get_type()) }
    }
}

#[allow(deprecated)]
impl glib::HasParamSpec for TlsRehandshakeMode {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[allow(deprecated)]
impl glib::value::ValueType for TlsRehandshakeMode {
    type Type = Self;
}

#[allow(deprecated)]
unsafe impl<'a> glib::value::FromValue<'a> for TlsRehandshakeMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[allow(deprecated)]
impl ToValue for TlsRehandshakeMode {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[allow(deprecated)]
impl From<TlsRehandshakeMode> for glib::Value {
    #[inline]
    fn from(v: TlsRehandshakeMode) -> Self {
        ToValue::to_value(&v)
    }
}

#[cfg(unix)]
#[cfg_attr(docsrs, doc(cfg(unix)))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GUnixSocketAddressType")]
pub enum UnixSocketAddressType {
    #[doc(alias = "G_UNIX_SOCKET_ADDRESS_INVALID")]
    Invalid,
    #[doc(alias = "G_UNIX_SOCKET_ADDRESS_ANONYMOUS")]
    Anonymous,
    #[doc(alias = "G_UNIX_SOCKET_ADDRESS_PATH")]
    Path,
    #[doc(alias = "G_UNIX_SOCKET_ADDRESS_ABSTRACT")]
    Abstract,
    #[doc(alias = "G_UNIX_SOCKET_ADDRESS_ABSTRACT_PADDED")]
    AbstractPadded,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(unix)]
#[doc(hidden)]
impl IntoGlib for UnixSocketAddressType {
    type GlibType = ffi::GUnixSocketAddressType;

    #[inline]
    fn into_glib(self) -> ffi::GUnixSocketAddressType {
        match self {
            Self::Invalid => ffi::G_UNIX_SOCKET_ADDRESS_INVALID,
            Self::Anonymous => ffi::G_UNIX_SOCKET_ADDRESS_ANONYMOUS,
            Self::Path => ffi::G_UNIX_SOCKET_ADDRESS_PATH,
            Self::Abstract => ffi::G_UNIX_SOCKET_ADDRESS_ABSTRACT,
            Self::AbstractPadded => ffi::G_UNIX_SOCKET_ADDRESS_ABSTRACT_PADDED,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(unix)]
#[doc(hidden)]
impl FromGlib<ffi::GUnixSocketAddressType> for UnixSocketAddressType {
    #[inline]
    unsafe fn from_glib(value: ffi::GUnixSocketAddressType) -> Self {
        match value {
            ffi::G_UNIX_SOCKET_ADDRESS_INVALID => Self::Invalid,
            ffi::G_UNIX_SOCKET_ADDRESS_ANONYMOUS => Self::Anonymous,
            ffi::G_UNIX_SOCKET_ADDRESS_PATH => Self::Path,
            ffi::G_UNIX_SOCKET_ADDRESS_ABSTRACT => Self::Abstract,
            ffi::G_UNIX_SOCKET_ADDRESS_ABSTRACT_PADDED => Self::AbstractPadded,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(unix)]
impl StaticType for UnixSocketAddressType {
    #[inline]
    #[doc(alias = "g_unix_socket_address_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_unix_socket_address_type_get_type()) }
    }
}

#[cfg(unix)]
impl glib::HasParamSpec for UnixSocketAddressType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(unix)]
impl glib::value::ValueType for UnixSocketAddressType {
    type Type = Self;
}

#[cfg(unix)]
unsafe impl<'a> glib::value::FromValue<'a> for UnixSocketAddressType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(unix)]
impl ToValue for UnixSocketAddressType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(unix)]
impl From<UnixSocketAddressType> for glib::Value {
    #[inline]
    fn from(v: UnixSocketAddressType) -> Self {
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GZlibCompressorFormat")]
pub enum ZlibCompressorFormat {
    #[doc(alias = "G_ZLIB_COMPRESSOR_FORMAT_ZLIB")]
    Zlib,
    #[doc(alias = "G_ZLIB_COMPRESSOR_FORMAT_GZIP")]
    Gzip,
    #[doc(alias = "G_ZLIB_COMPRESSOR_FORMAT_RAW")]
    Raw,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ZlibCompressorFormat {
    type GlibType = ffi::GZlibCompressorFormat;

    #[inline]
    fn into_glib(self) -> ffi::GZlibCompressorFormat {
        match self {
            Self::Zlib => ffi::G_ZLIB_COMPRESSOR_FORMAT_ZLIB,
            Self::Gzip => ffi::G_ZLIB_COMPRESSOR_FORMAT_GZIP,
            Self::Raw => ffi::G_ZLIB_COMPRESSOR_FORMAT_RAW,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GZlibCompressorFormat> for ZlibCompressorFormat {
    #[inline]
    unsafe fn from_glib(value: ffi::GZlibCompressorFormat) -> Self {
        match value {
            ffi::G_ZLIB_COMPRESSOR_FORMAT_ZLIB => Self::Zlib,
            ffi::G_ZLIB_COMPRESSOR_FORMAT_GZIP => Self::Gzip,
            ffi::G_ZLIB_COMPRESSOR_FORMAT_RAW => Self::Raw,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ZlibCompressorFormat {
    #[inline]
    #[doc(alias = "g_zlib_compressor_format_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::g_zlib_compressor_format_get_type()) }
    }
}

impl glib::HasParamSpec for ZlibCompressorFormat {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for ZlibCompressorFormat {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for ZlibCompressorFormat {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ZlibCompressorFormat {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<ZlibCompressorFormat> for glib::Value {
    #[inline]
    fn from(v: ZlibCompressorFormat) -> Self {
        ToValue::to_value(&v)
    }
}
