/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.view.View;
import android.widget.TextView;
import com.jayway.android.robotium.solo.ViewLocationComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotiumUtils {
    public static <T extends View> ArrayList<T> removeInvisibleViews(Iterable<T> viewList) {
        ArrayList<View> tmpViewList = new ArrayList<View>();
        for (View view : viewList) {
            if (view == null || !view.isShown()) continue;
            tmpViewList.add(view);
        }
        return tmpViewList;
    }

    public static <T> ArrayList<T> filterViews(Class<T> classToFilterBy, Iterable<?> viewList) {
        ArrayList<T> filteredViews = new ArrayList<T>();
        for (Object view : viewList) {
            if (view == null || !classToFilterBy.isAssignableFrom(view.getClass())) continue;
            filteredViews.add(classToFilterBy.cast(view));
        }
        viewList = null;
        return filteredViews;
    }

    public static ArrayList<View> filterViewsToSet(Class<View>[] classSet, Iterable<View> viewList) {
        ArrayList<View> filteredViews = new ArrayList<View>();
        block0: for (View view : viewList) {
            if (view == null) continue;
            for (Class<View> filter : classSet) {
                if (!filter.isAssignableFrom(view.getClass())) continue;
                filteredViews.add(view);
                continue block0;
            }
        }
        return filteredViews;
    }

    public static void sortViewsByLocationOnScreen(List<? extends View> views) {
        Collections.sort(views, new ViewLocationComparator());
    }

    public static void sortViewsByLocationOnScreen(List<? extends View> views, boolean yAxisFirst) {
        Collections.sort(views, new ViewLocationComparator(yAxisFirst));
    }

    public static int getNumberOfMatches(String regex, TextView view, Set<TextView> uniqueTextViews) {
        if (view == null) {
            return uniqueTextViews.size();
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            pattern = Pattern.compile(regex, 16);
        }
        String viewText = ((Object)view.getText()).toString();
        viewText = viewText.replaceAll("[\n\r]", " ");
        Matcher matcher = pattern.matcher(viewText);
        if (matcher.find()) {
            uniqueTextViews.add(view);
        }
        if (view.getError() != null && (matcher = pattern.matcher(((Object)view.getError()).toString())).find()) {
            uniqueTextViews.add(view);
        }
        if (((Object)view.getText()).toString().equals("") && view.getHint() != null && (matcher = pattern.matcher(((Object)view.getHint()).toString())).find()) {
            uniqueTextViews.add(view);
        }
        return uniqueTextViews.size();
    }

    public static <T extends TextView> List<T> filterViewsByText(Iterable<T> views, String regex) {
        return RobotiumUtils.filterViewsByText(views, Pattern.compile(regex));
    }

    public static <T extends TextView> List<T> filterViewsByText(Iterable<T> views, Pattern regex) {
        ArrayList<TextView> filteredViews = new ArrayList<TextView>();
        for (TextView view : views) {
            if (view == null || !regex.matcher(view.getText()).matches()) continue;
            filteredViews.add(view);
        }
        return filteredViews;
    }
}

