//  Copyright (c) 2006 John Maddock
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
// Test data for RD, each row contains in order:
//
// x, y, z, RD(x, y, z)
//
   static const boost::array<boost::array<typename table_type<T>::type, 4>, 201> ellint_rd_data = {{
      {{ SC_(0.60682196926171104626767727515008970841312337712241e-30), SC_(0.20031258624e11), SC_(0.10313978271484375e4), SC_(0.20551372495384815463856604017047221545095240191057e-7) }}, 
      {{ SC_(0.13810928266794127506964991575307193802925529863273e-29), SC_(0.2529551275074481964111328125e-3), SC_(0.7030536597341097149183042347431182861328125e-8), SC_(0.26827491422802771467722943731540343461246213838861e11) }}, 
      {{ SC_(0.44767214645416419053919245787147718165594030426536e-29), SC_(0.26553176031232e14), SC_(0.2085586588137791946752e23), SC_(0.10585138723496739834534066073267118675522211779171e-31) }}, 
      {{ SC_(0.60078474312334545656635060929362382794743178141472e-29), SC_(0.37131016039637643189053051173686981201171875e-8), SC_(0.32517390764125836699536241120728208287005145393778e-20), SC_(0.15139742233407639223792275679902886417433224652453e26) }}, 
      {{ SC_(0.61834249098451553748337548320711315606925672313013e-29), SC_(0.15125532639232e16), SC_(0.11666782739894188125617802143096923828125e-6), SC_(0.66117253645648417600031762235375783237535720054585e0) }}, 
      {{ SC_(0.80490202086679616440767211156605911864354431197377e-29), SC_(0.263248904192e12), SC_(0.297980882347216843954978816e27), SC_(0.10333434770883940055455846219131687005742728721005e-37) }}, 
      {{ SC_(0.15386248307178551019952166983379913769903023636025e-28), SC_(0.11083928e9), SC_(0.210290006361901760101318359375e-2), SC_(0.13550514102538012513935665942320904977981297554257e0) }}, 
      {{ SC_(0.27790564235134654243337661318427908127768828411199e-28), SC_(0.21656921296023725949679903214975529301966616912978e-20), SC_(0.16200692698475904762744903564453125e-4), SC_(0.85856403820113222790454310518632166416049096576362e9) }}, 
      {{ SC_(0.75787209056271355952485380019348769132814133643247e-28), SC_(0.3443290234375e5), SC_(0.87738095954812459262649215691458087947041111220869e-24), SC_(0.18256962837089036695688975681087926934231777165353e23) }}, 
      {{ SC_(0.83892250504513065845701871993405683214864787598623e-28), SC_(0.1116302655645995400846004486083984375e-5), SC_(0.5191992844812585795584e22), SC_(0.25853043071836854153543603031360043116599575432972e-30) }}, 
      {{ SC_(0.1287535325337014953720268054032123824574619620157e-27), SC_(0.13705567485615801022446745431989965211687137938007e-26), SC_(0.5078582763671875e0), SC_(0.25453721736248252436275234446728359554220261644493e3) }}, 
      {{ SC_(0.55263283825603576259688637477087526891102295303199e-27), SC_(0.14570690537170526341649579027404115549870766699314e-16), SC_(0.12941088853490731622934705547460304161866623869764e-26), SC_(0.36729174819285901249546490822632941293048355712711e36) }}, 
      {{ SC_(0.56127809703514701593677302775789618452802567406812e-27), SC_(0.9228809556838246663801328395493328571319580078125e-11), SC_(0.86422194270699415064029835775727406144142150878906e-12), SC_(0.10781910269701214744433782310389927085727282773814e19) }}, 
      {{ SC_(0.11649136528196886067987694424015483218044894522109e-26), SC_(0.36767340167168e14), SC_(0.4968523085117340087890625e0), SC_(0.99577870866168728614595399908281899687867831139901e-6) }}, 
      {{ SC_(0.25172518744793432127678756566548684645107602196601e-26), SC_(0.432213410600102056165376e24), SC_(0.1959631583933896656101239768660304818581607833039e-18), SC_(0.23283511871909436551998718906785080640182682915363e8) }}, 
      {{ SC_(0.28601321158264026057365024112938563807684451932578e-26), SC_(0.40558081566683637682324548023871102486737072467804e-15), SC_(0.208714828125e6), SC_(0.76237261396619453885730994908723652541092525168043e-6) }}, 
      {{ SC_(0.73955594308673193523198369636584653936223991005372e-26), SC_(0.15995684594580228399252064264146611094474792480469e-12), SC_(0.170420291286861873152e22), SC_(0.1687006236430131643441016712281856878753726523535e-29) }}, 
      {{ SC_(0.25325901731494375978251987705874090841683295149966e-25), SC_(0.2247014312744140625e3), SC_(0.275117858615052709715247104e27), SC_(0.18485690522734605390476411600907452658544362635922e-37) }}, 
      {{ SC_(0.34857664908449107348958795506280082952452713251912e-25), SC_(0.4151866912841796875e2), SC_(0.84098145009994339684283693509730169685090217512879e-22), SC_(0.54257544703354289137242893169458880766652554745316e22) }}, 
      {{ SC_(0.34919368622379363366113344149995795887854964367758e-25), SC_(0.253342638931968e15), SC_(0.7562174072265625e3), SC_(0.249241547815296223838694888499925239323224138633e-9) }}, 
      {{ SC_(0.43573388456807634241895548780677530339229715228289e-25), SC_(0.4951682e8), SC_(0.27826294978205525521980137859608542144911232096849e-25), SC_(0.68052511685869677076187126812000404571638179018885e22) }}, 
      {{ SC_(0.79820903020739723608895214436397557193018231780357e-25), SC_(0.64729720161775472443612539086288393264112528413534e-17), SC_(0.68450550546432e14), SC_(0.19125532541215326384896730405964498227631338694385e-18) }}, 
      {{ SC_(0.87440356429873925658498856170228582591246249688943e-25), SC_(0.897631640625e4), SC_(0.386145068359375e4), SC_(0.70431488067233168809120506088634745460689092194161e-5) }}, 
      {{ SC_(0.94440849851249091320281320378524601844016927998382e-25), SC_(0.339495296e9), SC_(0.27455182077952e14), SC_(0.12588696277491280442424745508482566976425259261561e-18) }}, 
      {{ SC_(0.14235380836999617679740726134029336127093459674064e-24), SC_(0.13978527726259656235898667313173260930711863658793e-24), SC_(0.2028485946357250213623046875e-1), SC_(0.27366411869676160015961055866442893198667542321359e5) }}, 
      {{ SC_(0.19953517994584643852448181812338140391502663839596e-24), SC_(0.20741449842688e14), SC_(0.4743499375e6), SC_(0.13886820075171731514726499953757541277555907027004e-11) }}, 
      {{ SC_(0.24754359063412526643006257824154938047573476511687e-24), SC_(0.542938704356835328e18), SC_(0.44974670432440498891960159215184658369128360699829e-26), SC_(0.10752772537029819829836280199737653161290081988757e18) }}, 
      {{ SC_(0.31317834636651731435069138009717243018286553235541e-24), SC_(0.446171086848e12), SC_(0.49623249953612003082525916397571563720703125e-9), SC_(0.90507658227268922734361508605808168072270615976688e4) }}, 
      {{ SC_(0.49794778812580822691949943719295546451682199506905e-24), SC_(0.1241846768099137683456e22), SC_(0.16907547929525060340181807204941172504655995389999e-25), SC_(0.78343915398198934519415679862427240727586271564883e15) }}, 
      {{ SC_(0.56225779987930131445265275562229206527363467582603e-24), SC_(0.59220483766176692878700381014733800100202643079683e-19), SC_(0.170295034922225631232e22), SC_(0.20048163240230817674563773499193885173665982026089e-29) }}, 
      {{ SC_(0.63171350201374448567926894124993295043246632758382e-24), SC_(0.34594001439795600424927311319582115491182941913878e-27), SC_(0.63795086741914598182229839666991088459324643622494e-23), SC_(0.30128244387255120033790929863955407018683622956366e36) }}, 
      {{ SC_(0.13769532587968157644195235343886302517048270122046e-23), SC_(0.2007315487162486533634364604949951171875e-6), SC_(0.484821384427736035149791860021650791168212890625e-10), SC_(0.13804448026385854623972866111304415486550268685946e15) }}, 
      {{ SC_(0.1809900535358029636909945199492450026643175498009e-23), SC_(0.4521496521192602813243865966796875e-5), SC_(0.8669365225699721122509799897670745849609375e-10), SC_(0.16273113459057256254769276696724703797987842259227e14) }}, 
      {{ SC_(0.23768503319901658006414734019219381138884883419848e-23), SC_(0.545301093941248e15), SC_(0.1237108193663516431115567684173583984375e-9), SC_(0.10384732803004085499895888503014146907429299054875e4) }}, 
      {{ SC_(0.30307608021550191165014175615417981032514993522398e-23), SC_(0.112407951746718026697635650634765625e-5), SC_(0.2082685879058432e16), SC_(0.78504137547976820009624215245629935490941195781392e-21) }}, 
      {{ SC_(0.62520772668534154026944814518561754825703991045316e-23), SC_(0.19445130267235161963321360384e29), SC_(0.27158976561908717618255837411567199524142779409885e-16), SC_(0.79176099627370786959440226480012961415298742955765e3) }}, 
      {{ SC_(0.13102694856934221302627057835335012189043046859638e-22), SC_(0.557648090759990083584e22), SC_(0.511986668338959560742296162061393260955810546875e-10), SC_(0.78466137092077764354738487755677479556614922112935e0) }}, 
      {{ SC_(0.22752379870925977520487843277428559665698237779452e-22), SC_(0.169495918280704e15), SC_(0.106314858496e12), SC_(0.21650121297190654998249828534683860885914030587266e-17) }}, 
      {{ SC_(0.25335998731998849030698736206528910198942927678445e-22), SC_(0.99404931640625e3), SC_(0.204871795654296875e3), SC_(0.42132166564785080959023378471888313620164092769291e-3) }}, 
      {{ SC_(0.34646067293379381351152691325339738961930358129848e-22), SC_(0.26973976499394821796760860105960760360263583912399e-23), SC_(0.238645943284598871514390339143574237823486328125e-10), SC_(0.35432548942737632785957707186626141058866961729541e18) }}, 
      {{ SC_(0.71863877935764437100797607417958061393203905709015e-22), SC_(0.174722980453023744e19), SC_(0.13073324703744e14), SC_(0.1736004266338139270794293208784155064732837114576e-21) }}, 
      {{ SC_(0.96362472102334232055222076765519517715929964651878e-21), SC_(0.229194643907248973846435546875e-3), SC_(0.354709317473833607436972670257091522216796875e-9), SC_(0.55865475580945127826780252757531774517543358031385e12) }}, 
      {{ SC_(0.27589042212186362242123678200494962808875243354123e-20), SC_(0.16342684e8), SC_(0.10564504593401150001064081607182743027806282043457e-12), SC_(0.70232843197284835279286086968072241001475849391442e10) }}, 
      {{ SC_(0.10233203223084091273258880352287070181205308472272e-19), SC_(0.85809811133878005628972118756792042404413223266602e-13), SC_(0.231948544e9), SC_(0.21282358830663000454676497251299241238551176927446e-10) }}, 
      {{ SC_(0.18673345450030310831705831391483241255002667458029e-19), SC_(0.16140768350376832622251404282443946390469477480956e-24), SC_(0.35751782069791464758326094786154009108614104661683e-22), SC_(0.57362515961254887975882907105995424791809261862104e33) }}, 
      {{ SC_(0.21109476364529939751075359117074570214356299402425e-19), SC_(0.8756801014807582267041677127782781970980266472715e-25), SC_(0.19232578752860259808180970650021732008816410797181e-22), SC_(0.10040849239749431240730130421363049484424180456536e34) }}, 
      {{ SC_(0.48988976909583188869227858043553514022505623870529e-19), SC_(0.20838384443777613341808319091796875e-4), SC_(0.15278292e8), SC_(0.70563639547351817695354788729725173202298905165509e-9) }}, 
      {{ SC_(0.82997499668329372719087076888666576479636205476709e-19), SC_(0.13155479315039595949803718770027355301939497866925e-23), SC_(0.1327809695148788465823841420387907419353723526001e-14), SC_(0.32382452643409713657086228689471450756020929884496e24) }}, 
      {{ SC_(0.16677509527778160624086499150275919589603290660307e-18), SC_(0.50082130538252574789989333416135111329551950562359e-29), SC_(0.27393523857242675896004658903787332135948417999316e-20), SC_(0.26379890286497467800536742716267974869467674676907e31) }}, 
      {{ SC_(0.30420727664434581210352358596193944606511649908498e-18), SC_(0.28656053473241627216339111328125e-4), SC_(0.94969911521617292598785838378394608128019171999767e-19), SC_(0.21152520435266024826733886337057191990575481859773e22) }}, 
      {{ SC_(0.75868695590633990953827528458397466692986199632287e-18), SC_(0.930611462144e12), SC_(0.18147922618313051311153033283257685840533790511131e-24), SC_(0.83768344778024722769204816337111831433373325848511e16) }}, 
      {{ SC_(0.79597584432992412060764095271814255738718202337623e-18), SC_(0.75974287571611502022633594876763844865744160884209e-30), SC_(0.20657736771171195551744e23), SC_(0.47403170903497016250215067728483228381506772219895e-31) }}, 
      {{ SC_(0.12784377253954858878954355810853016350847610738128e-17), SC_(0.687874899968e12), SC_(0.2496727752685546875e2), SC_(0.14487562897240575462420431915733354323986381404974e-6) }}, 
      {{ SC_(0.22468750405760049766485005051652734664457966573536e-17), SC_(0.20721947294077835977077484130859375e-4), SC_(0.33333534375e6), SC_(0.1891939096717128299814570834532131624242218004607e-6) }}, 
      {{ SC_(0.33297255999405977634352134242323728585688513703644e-17), SC_(0.31191365320704e14), SC_(0.2293932139873504638671875e0), SC_(0.23416581491449832804939246015659888605843645930834e-5) }}, 
      {{ SC_(0.35736448257653877024582131372021365223190514370799e-17), SC_(0.1626183676572159287754752e26), SC_(0.18501463382170069138510370976291596889495849609375e-11), SC_(0.40153851788485548350521938534047362493332593188358e0) }}, 
      {{ SC_(0.46871312598868006987253009842930850936681963503361e-17), SC_(0.3093168493023691324522496e26), SC_(0.16793731632787596740420928687663819571897812904515e-26), SC_(0.60797270634828688834833132685695209121001352766598e10) }}, 
      {{ SC_(0.57842544071306897015280826246375056598481023684144e-17), SC_(0.29870528793496387010009129880927503108978271484375e-12), SC_(0.2262512535863296e17), SC_(0.29646119268293442517889863887012770015886764481583e-22) }}, 
      {{ SC_(0.152616857880340486461855087352290638591512106359e-16), SC_(0.2803833618070566221119488e25), SC_(0.130162216009921394288539886474609375e-4), SC_(0.13764477533975189296577420989460030210624358668897e-6) }}, 
      {{ SC_(0.27022364375023134885640124780437076879024971276522e-16), SC_(0.27506543358959030582888269221280574638246675400223e-29), SC_(0.10302131894484992e19), SC_(0.11533202298793762115879808476821158493089208267767e-24) }}, 
      {{ SC_(0.51905646303429040628284185654450766378431580960751e-16), SC_(0.15583587e8), SC_(0.46741176605224609375e2), SC_(0.16258625638384341129980088810715602413277009050755e-4) }}, 
      {{ SC_(0.54374770505732477601443242143375300656771287322044e-16), SC_(0.4562802734375e3), SC_(0.10197021348467909816516131089894163913918803398168e-29), SC_(0.18861228040658158783485684274667884467513804993808e23) }}, 
      {{ SC_(0.60475637804894883005346617466102543403394520282745e-16), SC_(0.56145323516737172227849140410116390853545453865081e-18), SC_(0.64836257251954521052539348602294921875e-7), SC_(0.19426856083161503849129240968279840607620575171493e13) }}, 
      {{ SC_(0.17055543082513291604229710429763144929893314838409e-15), SC_(0.6943710148334503173828125e-1), SC_(0.61840874921367523613102701318666731822304427623749e-15), SC_(0.12070723069489973584177449356829135215953130632198e17) }}, 
      {{ SC_(0.31354745663454523796342954256033408455550670623779e-15), SC_(0.18973853599391077295877039432525634765625e-8), SC_(0.15741248433312655941040958396115456707775592803955e-13), SC_(0.38340329268483399676355291918194933462116017467071e19) }}, 
      {{ SC_(0.92657114094649205629505850367877428652718663215637e-15), SC_(0.32666126748015500425026402808725833892822265625e-10), SC_(0.62660384591791979530528422515089914668351411819458e-14), SC_(0.60469431091148756507917001500985998650828444618344e20) }}, 
      {{ SC_(0.10318525717298732830018437311991874594241380691528e-14), SC_(0.14367766698608619435617583803832530975341796875e-9), SC_(0.5059831664766534231603145599365234375e-6), SC_(0.37240456346135514582020163258162977421115936310552e11) }}, 
      {{ SC_(0.63024210653626119155168439078806841280311346054077e-14), SC_(0.83430262439221944230360872296614616061560809612274e-15), SC_(0.38344456302173223195286237326130017242619817813276e-26), SC_(0.21127757229591123502084107843796645070269626006089e29) }}, 
      {{ SC_(0.68559452379320356268932457055598206352442502975464e-14), SC_(0.322791595458984375e3), SC_(0.86205957643638764405225050069248027284629642963409e-15), SC_(0.5070464522925097491100578039956621014507338348222e14) }}, 
      {{ SC_(0.96442290460109492133966568871983326971530914306641e-14), SC_(0.9353629648877212663808e22), SC_(0.52655215867828667928533109554578572897298727184534e-17), SC_(0.13450724270522347382379901409784950912908729078726e6) }}, 
      {{ SC_(0.10676147262794234704674778413391322828829288482666e-13), SC_(0.43214794983836329352138753913566138198376620493946e-21), SC_(0.13713993780991436762807365477498389161326031171484e-19), SC_(0.17979661672341056120541486805388070626904785412941e28) }}, 
      {{ SC_(0.40149480284466451673885956097365124151110649108887e-13), SC_(0.256623141467571258544921875e-1), SC_(0.33872525312e11), SC_(0.69010795178555815328380066886327027775732548313008e-14) }}, 
      {{ SC_(0.5554841051654164918449652077470091171562671661377e-13), SC_(0.12544762676037794895951386908716784773787367157638e-18), SC_(0.20581069188704517551523841788208013525718342862092e-18), SC_(0.34730610212848338186315105471341205240679027355204e26) }}, 
      {{ SC_(0.19550562611967553516834072979690972715616226196289e-12), SC_(0.18799281123449514653822470500968856016443808698568e-21), SC_(0.205092546875e6), SC_(0.68260136417276461849255990158184122817857291611521e-6) }}, 
      {{ SC_(0.35943559868918673050330880869296379387378692626953e-12), SC_(0.35023133106665160704e20), SC_(0.2881296007168e13), SC_(0.17593641420990612480757675345235956768570657023439e-21) }}, 
      {{ SC_(0.15664042328847327389951260556699708104133605957031e-11), SC_(0.40672445e7), SC_(0.45362430968070144e18), SC_(0.12868159051971997720302525310429992610797966319908e-24) }}, 
      {{ SC_(0.164856496509546701645376742817461490631103515625e-11), SC_(0.12800646827237915914565746788866817951202392578125e-10), SC_(0.130841693878173828125e2), SC_(0.88146998265763878715593876508509714886416387301537e0) }}, 
      {{ SC_(0.16011657277825719347674748860299587249755859375e-10), SC_(0.389046929776668548583984375e-1), SC_(0.18785430908203125e2), SC_(0.12826163996780515895628163745276639196285356189002e0) }}, 
      {{ SC_(0.1943433088069657088681196910329163074493408203125e-10), SC_(0.22031295035060773623229295812958821278778470675874e-24), SC_(0.39424006729538510485078006695403018966317176818848e-13), SC_(0.17208935846814855474858783681943464492271379781251e20) }}, 
      {{ SC_(0.55001718457514670035379822365939617156982421875e-10), SC_(0.74622654356062412261962890625e-2), SC_(0.11046793904970209077021081611746922135353088378906e-11), SC_(0.39022957778049595212041111646106992003089162296055e13) }}, 
      {{ SC_(0.755542572949963187056710012257099151611328125e-10), SC_(0.140444835444342210428928e24), SC_(0.468889537015105749778432e24), SC_(0.11133716624562663818120719842466773968408193063679e-34) }}, 
      {{ SC_(0.573736336217933740044827573001384735107421875e-9), SC_(0.141051064161956674070097506046295166015625e-7), SC_(0.2359947e8), SC_(0.46393758660551432981135887835476128122204846147684e-9) }}, 
      {{ SC_(0.2402602117257401914685033261775970458984375e-8), SC_(0.42540803535525434114020215409929237537767221510876e-19), SC_(0.4942538125e6), SC_(0.14560752605725533180948291219479606724490318886823e-6) }}, 
      {{ SC_(0.1000261828920656625996343791484832763671875e-7), SC_(0.56146556854248046875e2), SC_(0.11031288903647689304752638145772731734228777611406e-22), SC_(0.12052848527398278799832911416294667755106492294105e16) }}, 
      {{ SC_(0.11262596188998941215686500072479248046875e-7), SC_(0.15615465734711286849289990641409531235694885253906e-12), SC_(0.24870398826241113884932236596184834676037667122728e-20), SC_(0.14342615136271148815337084129716804758860091713852e22) }}, 
      {{ SC_(0.199429788239058325416408479213714599609375e-7), SC_(0.3046932220458984375e1), SC_(0.18625525552055897944743393684375905872507558290159e-28), SC_(0.28199445975752883777683066688026201569387335503589e19) }}, 
      {{ SC_(0.3125807523929324815981090068817138671875e-7), SC_(0.82854125568e11), SC_(0.58830391620982291911135882706044579926359106014644e-24), SC_(0.76856782244221849714163500215346774357484772577875e11) }}, 
      {{ SC_(0.43614054590079831541515886783599853515625e-7), SC_(0.84901359375e5), SC_(0.18469835205078125e4), SC_(0.54623902209860442229151811145622184504642829732335e-5) }}, 
      {{ SC_(0.108193802361711277626454830169677734375e-6), SC_(0.3542151123046875e4), SC_(0.23456829198204715014597354638681281358003616333008e-13), SC_(0.10001144380703963441897324290469056535051202600889e10) }}, 
      {{ SC_(0.66861986169897136278450489044189453125e-6), SC_(0.1611108507323484384264192e25), SC_(0.11971012087915599989354498156046702206367626786232e-15), SC_(0.26417880833139837075003994904446957544591390247203e0) }}, 
      {{ SC_(0.2085087317027500830590724945068359375e-5), SC_(0.23632697338789035110002273443186027179763186722994e-16), SC_(0.503470934927463531494140625e-2), SC_(0.35960301930045747424111739376688179190687610273877e5) }}, 
      {{ SC_(0.23743823476252146065235137939453125e-5), SC_(0.12017452733891625937800995416182558983564376831055e-12), SC_(0.355727936e9), SC_(0.7470065785959632348025349187216488890857914570702e-11) }}, 
      {{ SC_(0.14422212188947014510631561279296875e-4), SC_(0.3083335169004797952e20), SC_(0.25554565784928256e17), SC_(0.2111170543500163253881802959081230566812418255998e-25) }}, 
      {{ SC_(0.759344620746560394763946533203125e-4), SC_(0.22148209406780902835423848339554340607932845033396e-29), SC_(0.19855378956352178823888896e26), SC_(0.11615021168805924887771805758470812549280791431838e-35) }}, 
      {{ SC_(0.13287944602780044078826904296875e-3), SC_(0.9115189375e6), SC_(0.179409878467662494683889664e27), SC_(0.29650242659037947615123357258080617286726369971703e-37) }}, 
      {{ SC_(0.34799534478224813938140869140625e-3), SC_(0.131195640625e6), SC_(0.399027378608056683915492826862951233901632974721e-21), SC_(0.22226623207731501805303523899997800479877319903756e11) }}, 
      {{ SC_(0.40748735773377120494842529296875e-3), SC_(0.57247653448122368e17), SC_(0.147901005859375e5), SC_(0.84761610791413708184102124441300162758244096872165e-12) }}, 
      {{ SC_(0.8751563727855682373046875e-3), SC_(0.423289281913088785772479250432e30), SC_(0.9735179031543808e18), SC_(0.47365123725509543439971727739170068342860121165597e-32) }}, 
      {{ SC_(0.27153925038874149322509765625e-2), SC_(0.2655967255122959613800048828125e-3), SC_(0.9400097640298840064e19), SC_(0.25931933912240334891174482201662724425930654998897e-26) }}, 
      {{ SC_(0.4837694466114044189453125e0), SC_(0.2555249786376953125e2), SC_(0.14830236860416e15), SC_(0.2483720376425113862422543136112213202436935879191e-19) }}, 
      {{ SC_(0.15793964862823486328125e1), SC_(0.21153786174505042274269802208549073334284835448335e-27), SC_(0.12200210459945015628591136191971600055694580078125e-11), SC_(0.19566283540029067278121530833386806424315313727408e13) }}, 
      {{ SC_(0.2704489231109619140625e1), SC_(0.80231539790356115235923917250460135619505308568478e-17), SC_(0.48408881335894016e17), SC_(0.53792671402241349248545063015804106306968516352921e-23) }}, 
      {{ SC_(0.23412235260009765625e2), SC_(0.14768327260674323415826432e26), SC_(0.345189679104e12), SC_(0.22614876588635814725794181088071280690286615301413e-23) }}, 
      {{ SC_(0.316759090423583984375e2), SC_(0.153310129036299258586950600147247314453125e-7), SC_(0.15191832576e11), SC_(0.16631236244909872192077961607934570866900493512459e-13) }}, 
      {{ SC_(0.3255878448486328125e2), SC_(0.20426069933899679481125376462984716200236491481616e-28), SC_(0.3943929741312e13), SC_(0.50353928117824032357527410766164816007624085670378e-17) }}, 
      {{ SC_(0.43738616943359375e2), SC_(0.12385733574656e14), SC_(0.18116829833984375e4), SC_(0.40724319301281764660058342651643062705390654723387e-9) }}, 
      {{ SC_(0.4479792022705078125e2), SC_(0.11175146230483004594624674155056709423661231994629e-13), SC_(0.13292268387650598312620966562043814396254504117678e-22), SC_(0.11629236230289651656345450088745089161234800251595e19) }}, 
      {{ SC_(0.482386627197265625e2), SC_(0.371529138647019863128662109375e-3), SC_(0.12312668720852486471439889495482766790246387245134e-18), SC_(0.6386325930109877551531089847402324568981044656055e11) }}, 
      {{ SC_(0.10465634918212890625e3), SC_(0.60640822994173504412174224853515625e-5), SC_(0.24925849334950778558742528e26), SC_(0.65811829666888908826875876066862188512661412630752e-36) }}, 
      {{ SC_(0.50384063720703125e3), SC_(0.404188410838900933656576e24), SC_(0.15307389070737408e17), SC_(0.30826772490126137669951644592625777899396040552077e-27) }}, 
      {{ SC_(0.53687359619140625e3), SC_(0.22982227952519826732488902867652779863117686563745e-26), SC_(0.33525770516606100656031852480509769520722329616547e-15), SC_(0.38619382633246480698279035386804404841962200896354e15) }}, 
      {{ SC_(0.7166851806640625e3), SC_(0.1690176772380537639327398519769468654416755271086e-22), SC_(0.47753922915140458067828621580019898829050362110138e-15), SC_(0.23462068136128667108162025031768655357099942719956e15) }}, 
      {{ SC_(0.82290283203125e3), SC_(0.36223742228003175114281475543975830078125e-7), SC_(0.12701055793371805794043341177064064973639689881679e-22), SC_(0.15418083695250383678552202189981589244172193225686e15) }}, 
      {{ SC_(0.11206973876953125e4), SC_(0.159823103248039936e18), SC_(0.10259405824e11), SC_(0.73119908229313550917582888390408170817531581243981e-18) }}, 
      {{ SC_(0.3524259033203125e4), SC_(0.38758790625e6), SC_(0.4173026783555223552e19), SC_(0.53840141339823144164749266297779626405026075250354e-26) }}, 
      {{ SC_(0.503876328125e5), SC_(0.72534660121208050493385086597564193056086878641509e-19), SC_(0.12543467133030450355590801336802542209625244140625e-10), SC_(0.10653900989744106753051987452865655428050550636145e10) }}, 
      {{ SC_(0.106680765625e6), SC_(0.56570606632127019614208e23), SC_(0.34145346314045075233544504794608567192597259332132e-24), SC_(0.66087148559582045987244548210211279428436117754187e-1) }}, 
      {{ SC_(0.22300921875e6), SC_(0.22960517578125e4), SC_(0.46933254639405441853106942079784734541910233270121e-28), SC_(0.19352125587645692677443985028630474308382325346085e11) }}, 
      {{ SC_(0.41534478125e6), SC_(0.1918984889984130859375e1), SC_(0.44006012e8), SC_(0.28082710296947187740954711717710296711776400921903e-10) }}, 
      {{ SC_(0.2068948375e7), SC_(0.20907895301679711719256005153511068783700466156006e-13), SC_(0.893892793119022144310292787849903106689453125e-9), SC_(0.23220185234104289565189456830426781269822420101649e7) }}, 
      {{ SC_(0.47946235e7), SC_(0.22622955483503716568203720238550147314526839181781e-18), SC_(0.85913526136044117637383110697157917456934228539467e-16), SC_(0.1516874379835050342838340936028885659767370366596e14) }}, 
      {{ SC_(0.14619622e8), SC_(0.815536015625e5), SC_(0.230844914913177490234375e0), SC_(0.57086613986241415694637371690066831951886129801915e-5) }}, 
      {{ SC_(0.123742392e9), SC_(0.10912435391066719332460695603753930316446923640128e-25), SC_(0.701712293691392e16), SC_(0.4753049899425421501464028407935694092644489233471e-22) }}, 
      {{ SC_(0.2606888e9), SC_(0.38372283060996710610105527722302198867510014679283e-18), SC_(0.738515392e9), SC_(0.16899537620100468885521495060585278478833440423956e-12) }}, 
      {{ SC_(0.670079424e9), SC_(0.14044194233643483429544463937103636612564738772591e-24), SC_(0.11511007425024644135191920213401317596435546875e-10), SC_(0.10068035345075574011893714808378880691913968655047e8) }}, 
      {{ SC_(0.911282624e9), SC_(0.1114427401123063379525632e25), SC_(0.53440565956804888993886271109090557729359716176987e-17), SC_(0.40722393361131223694875712619630727084056015372761e-7) }}, 
      {{ SC_(0.1161228928e10), SC_(0.18421718410258806513944641963201765549884569850292e-21), SC_(0.22427656323344421104955380977729814673260477775329e-21), SC_(0.20591436627603819494995715646309833117702290434193e18) }}, 
      {{ SC_(0.1535589888e10), SC_(0.29343589097392396787046010830923847834128537215292e-17), SC_(0.988066171875e5), SC_(0.77469678981488935733995438768613592415271273150107e-9) }}, 
      {{ SC_(0.1910448768e10), SC_(0.19696330564073048658818435820590984305819001943432e-28), SC_(0.32238440243425309843308409068705787565729120602853e-24), SC_(0.21125068341742162462647544763682405635604368927636e21) }}, 
      {{ SC_(0.2606333696e10), SC_(0.12266837021255184297929829995155159849673509597778e-13), SC_(0.14248488e9), SC_(0.39627043221972042336166285233706057104657589115659e-12) }}, 
      {{ SC_(0.3957605632e10), SC_(0.55799657429356219751070966594852507114410400390625e-13), SC_(0.45080659638616064e17), SC_(0.26674037369791867164639711571859268973615887454244e-23) }}, 
      {{ SC_(0.7560605184e10), SC_(0.62840314285494969226419925689697265625e-7), SC_(0.3143396352e11), SC_(0.68666153248448673089341550512928561615491669715129e-15) }}, 
      {{ SC_(0.35244982272e11), SC_(0.181061646295454711808e21), SC_(0.18019738841891322915192832e27), SC_(0.90432439304473156212717626924185472610810741907204e-38) }}, 
      {{ SC_(0.732471296e11), SC_(0.4801772534847259521484375e-2), SC_(0.45398853613796871007741958773072074733645399780696e-27), SC_(0.75076274709327970844147190347182778322685039704522e10) }}, 
      {{ SC_(0.11738591232e12), SC_(0.761073704058645716941100545227527618408203125e-10), SC_(0.1885123992906301282346248626708984375e-5), SC_(0.46155407631902785095848397106563785922944194045686e1) }}, 
      {{ SC_(0.191893782528e12), SC_(0.174726296875e6), SC_(0.24141449950396592978032251394348434159198291126813e-20), SC_(0.33344943919892270945971542443654069589927768202531e3) }}, 
      {{ SC_(0.210419040256e12), SC_(0.15455189208984375e4), SC_(0.90718428578382195030384883514111792400934880018881e-30), SC_(0.17466014425028305478165893754999050226185977330753e9) }}, 
      {{ SC_(0.217494208512e12), SC_(0.140845240494850048e18), SC_(0.15238641357421875e4), SC_(0.4390528931099285855029463157097120990069377534872e-15) }}, 
      {{ SC_(0.572994879488e12), SC_(0.4479686882443445386870784e25), SC_(0.3949284499458758322165682321378970124179942071882e-27), SC_(0.94224283649343820821727631166828903159482878092905e-4) }}, 
      {{ SC_(0.64654147584e12), SC_(0.24521487702843957217058619392e29), SC_(0.921704585926541312e18), SC_(0.20767896690791054519935065644432011180835481458451e-31) }}, 
      {{ SC_(0.1494682042368e13), SC_(0.6869200625e6), SC_(0.12406291034494643099606037139892578125e-5), SC_(0.26581052905672381844740821940931122853787851217105e-5) }}, 
      {{ SC_(0.3518738464768e13), SC_(0.98092148011034996368806559985387139022350311279297e-13), SC_(0.8399241342592483328e19), SC_(0.95255153845747286192062451983557134108999906775529e-27) }}, 
      {{ SC_(0.395945312256e13), SC_(0.516478977703936e15), SC_(0.68443482659479816375487801854053577534347380106894e-25), SC_(0.2535778278917846265208084888613213161043251220247e0) }}, 
      {{ SC_(0.589840515072e13), SC_(0.11837831633021164326650292224515978315498715423004e-25), SC_(0.27219574150194603134877979755401611328125e-7), SC_(0.45380850193684529549916365876123433705384130624401e2) }}, 
      {{ SC_(0.51712110886912e14), SC_(0.156551992965379627797503279104e30), SC_(0.47173579223453998565673828125e-2), SC_(0.15351343966945931206569033370561284731402195178945e-19) }}, 
      {{ SC_(0.86229714468864e14), SC_(0.14452686009774895481427847698796540498733520507813e-13), SC_(0.669478515625e5), SC_(0.48256534943951386340918361637227021878577560800017e-11) }}, 
      {{ SC_(0.8952989351936e14), SC_(0.5821022205054759979248046875e-4), SC_(0.16930462580604928e17), SC_(0.41100941381473513911311626770434246282405013362988e-23) }}, 
      {{ SC_(0.3135611338752e15), SC_(0.2348838144e10), SC_(0.111468466401642984919817536137998104095458984375e-9), SC_(0.3310987818594775551634409929713950668720513185194e-6) }}, 
      {{ SC_(0.323813657018368e15), SC_(0.156708486328125e5), SC_(0.16682115902222024485246354430501014576293528079987e-14), SC_(0.32606324691495083414901689521365944975222646764363e-1) }}, 
      {{ SC_(0.95759886188544e15), SC_(0.4659874708323741288040764629840850830078125e-8), SC_(0.727262651482112e15), SC_(0.10816915862847177055794166008038797474693843131559e-21) }}, 
      {{ SC_(0.1551973144854528e16), SC_(0.10139344880747031860591903938868807433237861914677e-19), SC_(0.7740245504e10), SC_(0.9838251718134408598992601115526735906681602754507e-17) }}, 
      {{ SC_(0.183459460939776e16), SC_(0.58535432060362684618705258305616519358052915120161e-26), SC_(0.151380081803154098452068865299224853515625e-7), SC_(0.462681848842073289149702267338964557315073422797e1) }}, 
      {{ SC_(0.3762704347037696e16), SC_(0.10164524532769642241629852708355797252185587220552e-24), SC_(0.27152649027584e16), SC_(0.14699154732025769283571926131601897366775031030076e-22) }}, 
      {{ SC_(0.6551729407524864e16), SC_(0.25762003497220575809478759765625e-3), SC_(0.156271296e9), SC_(0.23717202528322099316627229293548821703600369558169e-15) }}, 
      {{ SC_(0.6565417468297216e16), SC_(0.174148595112480631422976e24), SC_(0.187841462272e12), SC_(0.20361865097500372485155107117802705969273207578608e-24) }}, 
      {{ SC_(0.9007602981666816e16), SC_(0.25765624e9), SC_(0.1591604150272e14), SC_(0.19726797826086290726900599041820484051327569566171e-20) }}, 
      {{ SC_(0.18448819419086848e17), SC_(0.55460104261295954577309919031335994077380746603012e-16), SC_(0.154132149174272e16), SC_(0.13580314631955561794382801022694745071290705109491e-22) }}, 
      {{ SC_(0.41172763385266176e17), SC_(0.69560673828125e4), SC_(0.747194576263427734375e1), SC_(0.62793115296093377148750971856138022413722904539364e-10) }}, 
      {{ SC_(0.59877638017122304e17), SC_(0.53512100536178474827209150532780768116936087608337e-15), SC_(0.60865414403362585004788968196643994088311036341765e-26), SC_(0.67932276518492118905647587709216361710433902821356e13) }}, 
      {{ SC_(0.11384566732292096e18), SC_(0.58757351632535552e19), SC_(0.273440826416015625e3), SC_(0.2218197410675072553866425364806973969075261727874e-18) }}, 
      {{ SC_(0.128395461743607808e18), SC_(0.206836903384823477636694016e27), SC_(0.53310077419155277311801910400390625e-5), SC_(0.25213187167619695580929289478697105906035912959449e-18) }}, 
      {{ SC_(0.245924553149120512e18), SC_(0.12432241406593107741605394588021265875441186132822e-25), SC_(0.11698430441812742785454260394458960094979845402414e-30), SC_(0.15814359980865698013833243813020147773628412638471e21) }}, 
      {{ SC_(0.304309702915784704e18), SC_(0.530327327997952e15), SC_(0.10366431646728266850195727608041629252966231433675e-18), SC_(0.73346046074259210722247465233594194982314902683682e-6) }}, 
      {{ SC_(0.351564170056957952e18), SC_(0.39915753210320770987303899714279126384431587576396e-26), SC_(0.21695373623974084952946051325821291927687106275468e-28), SC_(0.16012914574357507234163722206932362300988672115721e20) }}, 
      {{ SC_(0.805980574786256896e18), SC_(0.7298279296875e4), SC_(0.135008262029312e15), SC_(0.24742374685179778771251059396546742229781662198914e-22) }}, 
      {{ SC_(0.1429457475085533184e20), SC_(0.14041162752e11), SC_(0.16802999673239973138530304e26), SC_(0.32121431604673931143271876891436876644565038320042e-36) }}, 
      {{ SC_(0.221162365880631296e20), SC_(0.4426536e8), SC_(0.89961878334825112180062577083017316681434749625623e-18), SC_(0.10108911246070441761891693525755853616606808949316e-3) }}, 
      {{ SC_(0.38083625921602912256e20), SC_(0.14043506688e11), SC_(0.13209346463532805303342509972708285204134881496429e-15), SC_(0.35692228203582006473843647627664557137685858827968e-6) }}, 
      {{ SC_(0.57692237126522896384e20), SC_(0.63429242800339125096797943115234375e-5), SC_(0.31824542466005171886425636864e29), SC_(0.55222293820695175519018810756922011735863676741191e-41) }}, 
      {{ SC_(0.6036870791327383552e20), SC_(0.7191220191232e13), SC_(0.68897207938789506442844867706298828125e-6), SC_(0.17346553888445511526875601632160113537907688737997e-12) }}, 
      {{ SC_(0.113674073964877447168e21), SC_(0.183615109375e6), SC_(0.404058591811917722225189208984375e-4), SC_(0.10330175955957541532693528313466256772187391201874e-9) }}, 
      {{ SC_(0.140771054246300745728e21), SC_(0.4364620208740234375e2), SC_(0.10711124272997777587041261201942927950011067906889e-29), SC_(0.36980588192743195268081186143904811424184826509079e5) }}, 
      {{ SC_(0.486625867239520206848e21), SC_(0.2663514463837359985504355062296832912238642165903e-19), SC_(0.4719122320543576863524228422930565122003386188676e-26), SC_(0.12125027886646699970512476707156771853870273067952e14) }}, 
      {{ SC_(0.1146824826980038344704e22), SC_(0.123134608e9), SC_(0.36464645756234167146109012677852867501115952109103e-20), SC_(0.13220462423972425935917229500420846663825040326569e-3) }}, 
      {{ SC_(0.317074383652647862272e22), SC_(0.89612589356621110444032e24), SC_(0.2342108211970048e16), SC_(0.11619224315234818923589971905969099280156494799642e-29) }}, 
      {{ SC_(0.32148523727519219712e22), SC_(0.60515264161661452673922225736467336588411333742066e-25), SC_(0.787468255232e13), SC_(0.67190469656717598102688231195715810897773628309487e-23) }}, 
      {{ SC_(0.13571258581209030066176e23), SC_(0.2301062643527984619140625e-1), SC_(0.14359374149799930542314996273489668965339660644531e-11), SC_(0.14166931188327778230186785722742287698171547666982e-3) }}, 
      {{ SC_(0.20821377315431516209152e23), SC_(0.31614863423832064e17), SC_(0.64014885e7), SC_(0.4621406894160877827384001215215505228565154941349e-22) }}, 
      {{ SC_(0.55817784918415767502848e23), SC_(0.229345916576958775296e21), SC_(0.181080293376e13), SC_(0.62303863493181421011759609358700084332302564282572e-27) }}, 
      {{ SC_(0.210179409744077661405184e24), SC_(0.775467603201754089842406683474462128114628768627e-26), SC_(0.1351436267417501696e19), SC_(0.48419735649202961080115073168670433174544124355214e-29) }}, 
      {{ SC_(0.277204771630374352584704e24), SC_(0.178649388253688812255859375e-1), SC_(0.1626075136e10), SC_(0.35041190711483516523923271898554740595024898229225e-20) }}, 
      {{ SC_(0.286204729096914532827136e24), SC_(0.18205785323743839398957788944244384765625e-7), SC_(0.6443661400749065109504e22), SC_(0.85231956001222048244789008910270023125100724496553e-33) }}, 
      {{ SC_(0.292186842467552253181952e24), SC_(0.8000304500511383121995759616e28), SC_(0.12346179962158203125e2), SC_(0.17659213899312742611429666455779433659781019844976e-25) }}, 
      {{ SC_(0.393077021751861389033472e24), SC_(0.85326592849126535957377352366076878413243909232699e-28), SC_(0.11113272845378330266896682587685063481330871582031e-11), SC_(0.43056670697313120117799317169619739766527357451448e1) }}, 
      {{ SC_(0.48688847917066659823616e24), SC_(0.12212552573408426924125600686592708205013835254249e-21), SC_(0.1269279595243605041993096779751049041351507185027e-17), SC_(0.33543623251839576830546760936703173774870805103267e7) }}, 
      {{ SC_(0.6959596827501176488460288e25), SC_(0.56396991515163736959758100092886750224006554485772e-29), SC_(0.164767579074269378772992e24), SC_(0.67539896107197358427396075668773079100885280216386e-35) }}, 
      {{ SC_(0.18820064668587267094216704e26), SC_(0.302210201308383830109960399568080902099609375e-9), SC_(0.33895318467300131244893458519885746926814107382597e-21), SC_(0.21606569536016446005127644096871253975571307187249e4) }}, 
      {{ SC_(0.66192871423119660955992064e26), SC_(0.65104581211365760324995297566040105840304400052279e-28), SC_(0.700861590985368820838630199432373046875e-9), SC_(0.5261182706092194133617741726329224767119336720926e-3) }}, 
      {{ SC_(0.9036469625899950631026688e26), SC_(0.690641880035400390625e1), SC_(0.1238969862461090087890625e0), SC_(0.3008677996342580895031853541445446250478520113248e-12) }}, 
      {{ SC_(0.351293559140227787146657792e27), SC_(0.92746285056e12), SC_(0.7325884342193603515625e1), SC_(0.61405412064015393151121436181259576895276598600887e-19) }}, 
      {{ SC_(0.48555353730121618377670656e27), SC_(0.41366469991877353664505423235416110752209856263632e-29), SC_(0.1080339869874636584075679427013641468012674864323e-29), SC_(0.42620833187540100646142696579397880259804927864477e17) }}, 
      {{ SC_(0.3196617981363007079661436928e28), SC_(0.357227936120807498809881508350372314453125e-8), SC_(0.190531306287766710738651454448699951171875e-7), SC_(0.19434029391873011348314670331341701583590531402094e-5) }}, 
      {{ SC_(0.4932620110638545248192561152e28), SC_(0.39087764918804168701171875e-1), SC_(0.37496308203098109226999139757157200603110425163322e-21), SC_(0.11157521852141686174291251786184006118424156415823e-1) }}, 
      {{ SC_(0.516425012058796509045456896e28), SC_(0.3000732163818651513042917353020530062720192427143e-28), SC_(0.28816120624542236328125e1), SC_(0.14487121655367107180122470700505306007568660707101e-13) }}, 
      {{ SC_(0.6724360036363488659828113408e28), SC_(0.39914275e7), SC_(0.5617260831058956682682037353515625e-4), SC_(0.24432489934783656632287527852861417375460919006681e-14) }}, 
      {{ SC_(0.7376334675354954747676196864e28), SC_(0.3832167254355459644063744e25), SC_(0.86986000872677090266227306614155168063007295131683e-15), SC_(0.60499813791534240550577796444003132563462392194689e-18) }}, 
      {{ SC_(0.1240879712420966629044649984e29), SC_(0.35030939907262229474824187104684165838808240778235e-22), SC_(0.23553908385443359223970771765266363217961043119431e-16), SC_(0.11419947735685798535870442055414653068651348519666e4) }}, 
      {{ SC_(0.13622372113626680630865559552e29), SC_(0.5065993732313771067901500902430633743733778828755e-18), SC_(0.1568245533434264871175400912761688232421875e-11), SC_(0.1638076044611111663076389515306947175644793927095e-1) }}, 
      {{ SC_(0.21413030105610117647127543808e29), SC_(0.56796892335439872e17), SC_(0.44545595303495604738852208133448318250202646595426e-19), SC_(0.40758436912717219001309081424162965116278950127384e-12) }}, 
      {{ SC_(0.240611655851932728105631744e29), SC_(0.15126033260477136128765155826087636266509091563425e-30), SC_(0.147685372829437255859375e1), SC_(0.13095601170876630580259197493117307804833462447144e-13) }}, 
      {{ SC_(0.61731988312258099732254031872e29), SC_(0.47155488899394500240213479534565823420775918905622e-28), SC_(0.4463543296e10), SC_(0.27051189723173151307626070067360099122375990020391e-23) }}
   }};


