/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ForeignObjectHandler;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class SVGForeignObjectElementBridge
extends AbstractGraphicsNodeBridge {
    protected ForeignObjectHandler handler;
    protected Element foreignContent;

    public String getLocalName() {
        return "foreignObject";
    }

    public Bridge getInstance() {
        return new SVGForeignObjectElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Node node;
        for (node = element.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        if (node == null) {
            return null;
        }
        Element element2 = (Element)node;
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)super.createGraphicsNode(bridgeContext, element);
        if (compositeGraphicsNode == null) {
            return null;
        }
        ForeignObjectHandler foreignObjectHandler = bridgeContext.createForeignObjectHandler(element2.getNamespaceURI());
        if (foreignObjectHandler == null) {
            return null;
        }
        this.buildForeignObjectNode(bridgeContext, element, element2, compositeGraphicsNode, foreignObjectHandler);
        if (bridgeContext.isDynamic()) {
            this.handler = foreignObjectHandler;
            this.foreignContent = element2;
        }
        return compositeGraphicsNode;
    }

    public void buildForeignObjectNode(BridgeContext bridgeContext, Element element, Element element2, CompositeGraphicsNode compositeGraphicsNode, ForeignObjectHandler foreignObjectHandler) {
        while (!compositeGraphicsNode.isEmpty()) {
            compositeGraphicsNode.remove(compositeGraphicsNode.size() - 1);
        }
        UnitProcessor.Context context = this.updatePosition(bridgeContext, element, compositeGraphicsNode);
        String string = element.getAttributeNS(null, "width");
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"width", string});
        }
        float f = UnitProcessor.svgHorizontalLengthToUserSpace(string, "width", context);
        string = element.getAttributeNS(null, "height");
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"height", string});
        }
        float f2 = UnitProcessor.svgVerticalLengthToUserSpace(string, "height", context);
        if (f == 0.0f || f2 == 0.0f) {
            return;
        }
        GraphicsNode graphicsNode = foreignObjectHandler.createGraphicsNode(bridgeContext, element2, f, f2);
        if (graphicsNode != null) {
            compositeGraphicsNode.add((Object)graphicsNode);
        }
    }

    protected UnitProcessor.Context updatePosition(BridgeContext bridgeContext, Element element, CompositeGraphicsNode compositeGraphicsNode) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        String string = element.getAttributeNS(null, "x");
        float f = 0.0f;
        if (string.length() != 0) {
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "x", context);
        }
        string = element.getAttributeNS(null, "y");
        float f2 = 0.0f;
        if (string.length() != 0) {
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "y", context);
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        compositeGraphicsNode.setTransform(affineTransform);
        return context;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new CompositeGraphicsNode();
    }

    public boolean isComposite() {
        return false;
    }

    protected void initializeDynamicSupport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        if (!bridgeContext.isInteractive()) {
            return;
        }
        if (bridgeContext.isDynamic()) {
            this.e = element;
            this.node = graphicsNode;
            this.ctx = bridgeContext;
            ((SVGOMElement)element).setSVGContext((SVGContext)this);
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        Node node = mutationEvent.getRelatedNode();
        if (string.equals("x") || string.equals("y")) {
            this.updatePosition(this.ctx, this.e, (CompositeGraphicsNode)this.node);
        } else if (string.equals("width") || string.equals("height")) {
            float f = 0.0f;
            float f2 = 0.0f;
            String string2 = mutationEvent.getPrevValue();
            UnitProcessor.Context context = UnitProcessor.createContext(this.ctx, this.e);
            if (string2.length() != 0) {
                f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string2, string, context);
            }
            if ((string2 = mutationEvent.getNewValue()).length() != 0) {
                f2 = UnitProcessor.svgHorizontalCoordinateToUserSpace(string2, string, context);
            }
            if (f == f2) {
                return;
            }
            this.buildForeignObjectNode(this.ctx, this.e, this.foreignContent, (CompositeGraphicsNode)this.node, this.handler);
        } else {
            super.handleDOMAttrModifiedEvent(mutationEvent);
        }
    }
}

