#import <Foundation/Foundation.h>

#import "IMoney.h"

@interface Money : NSObject <IMoney> {
@private
    int fAmount;
    NSString *fCurrency;
}

- (id)initWithAmount:(int)amount currency:(NSString *)currency;

- (id<IMoney>)add:(id<IMoney>)money;
- (id<IMoney>)addMoney:(Money *)money;
- (id<IMoney>)addMoneyBag:(MoneyBag *)bag;

- (int)amount;
- (NSString *)currency;

- (BOOL)isEqual:(id)anObject;

- (BOOL)isZero;

- (id<IMoney>)multiply:(int)factor;

- (id<IMoney>)negate;

- (id<IMoney>)subtract:(id<IMoney>)money;

- (NSString *)description;

@end
