#ifndef ELP82B_H
#define ELP82B_H

/*
  This is an abbreviated version of the full ELP82B theory, where all
  terms with amplitudes greater than 1 arcsec or 1 km have been
  discarded.
 */

static const int NUM01 = 59;
static const int ilu01[NUM01 * 4] = {
  0,  0,  0,  2,
  0,  0,  1, -2,
  0,  0,  1,  0,
  0,  0,  1,  2,
  0,  0,  2, -2,
  0,  0,  2,  0,
  0,  0,  2,  2,
  0,  0,  3,  0,
  0,  0,  4,  0,
  0,  1, -2,  0,
  0,  1, -1,  0,
  0,  1,  0,  0,
  0,  1,  1,  0,
  0,  1,  2,  0,
  0,  2, -1,  0,
  0,  2,  0,  0,
  0,  2,  1,  0,
  1,  0, -2,  0,
  1,  0, -1,  0,
  1,  0,  0,  0,
  1,  0,  1,  0,
  1,  1, -1,  0,
  1,  1,  0,  0,
  1,  1,  1,  0,
  2, -2, -1,  0,
  2, -2,  0,  0,
  2, -1, -2,  0,
  2, -1, -1,  0,
  2, -1,  0, -2,
  2, -1,  0,  0,
  2, -1,  1,  0,
  2, -1,  2,  0,
  2,  0, -3,  0,
  2,  0, -2,  0,
  2,  0, -1,  0,
  2,  0, -1,  2,
  2,  0,  0, -2,
  2,  0,  0,  0,
  2,  0,  0,  2,
  2,  0,  1, -2,
  2,  0,  1,  0,
  2,  0,  2,  0,
  2,  0,  3,  0,
  2,  1, -2,  0,
  2,  1, -1,  0,
  2,  1,  0, -2,
  2,  1,  0,  0,
  2,  1,  1,  0,
  2,  2, -1,  0,
  3,  0, -2,  0,
  3,  0, -1,  0,
  4, -1, -2,  0,
  4, -1, -1,  0,
  4, -1,  0,  0,
  4,  0, -3,  0,
  4,  0, -2,  0,
  4,  0, -1,  0,
  4,  0,  0,  0,
  4,  0,  1,   0
};
static const double coef01[NUM01 * 7] = {
   -411.60287,      168.48,   -18433.81,     -121.62,        0.40,       -0.18,        0.00,
     39.53393,     -395.24,     1788.33,      720.91,       -2.60,        0.90,        0.00,
  22639.55000,        0.00,        0.00,   412529.61,        0.00,        0.00,        0.00,
    -45.10032,       17.41,    -2019.78,     -830.20,        0.09,       -0.02,        0.00,
     -1.37259,       -7.58,      -62.49,      -50.12,       -0.07,        0.00,        0.00,
    769.02326,     -257.51,      -47.39,    28008.99,       -6.83,       -0.56,        0.00,
     -3.99767,        2.40,     -178.94,     -146.18,        0.05,        0.00,        0.00,
     36.12364,      -28.42,       -5.10,     1972.74,       -0.93,       -0.08,        0.00,
      1.93367,       -2.65,       -0.44,      140.75,       -0.10,        0.00,        0.00,
     -9.67938,     -235.29,        4.90,     -352.52,     -579.94,       -0.15,        0.00,
   -147.32654,    -3778.62,       68.68,    -2688.53,    -8829.17,       -0.76,        0.00,
   -666.44186,    -5206.84,      258.79,     -555.98,   -39887.79,        1.73,        0.00,
   -109.38419,    -2193.78,       51.64,    -2018.13,    -6556.10,        0.54,        0.00,
     -7.63041,     -156.07,        4.09,     -279.89,     -457.41,        0.12,        0.00,
     -2.56813,      -81.06,        1.44,      -46.94,     -307.62,        0.00,        0.00,
     -7.44804,      -12.64,        2.98,       -9.32,     -891.27,        0.03,        0.00,
     -1.16177,      -19.75,        0.43,      -21.52,     -139.13,        0.00,        0.00,
     -1.75296,      -48.87,        1.67,      -64.28,       -0.51,     -681.60,        3.59,
    -18.58467,     -437.66,       18.91,     -346.51,       -1.00,    -7226.22,       38.10,
   -124.98806,    -2831.88,      136.18,      -86.60,       -2.68,   -48598.15,      256.21,
     -8.45308,     -187.78,       10.10,     -158.62,        0.77,    -3286.75,       17.33,
      1.07773,        9.38,       -1.15,       21.49,       64.24,      418.88,       -2.21,
     17.95512,        6.59,      -11.64,       21.84,     1074.24,     6981.34,      -36.80,
      1.26186,        1.83,       -0.90,       24.50,       75.50,      490.64,       -2.59,
      7.37173,      165.38,       -1.06,      134.79,      881.89,       -0.04,        0.00,
      8.05076,      289.14,       -3.14,       21.09,      962.91,       -0.06,        0.00,
      8.60582,      187.04,       -1.14,      313.85,      515.03,        0.02,        0.00,
    205.44315,     4157.78,      -32.99,     3751.43,    12284.72,       -0.13,        0.00,
      2.14619,       18.77,       95.81,       -0.84,      128.22,        0.05,        0.00,
    164.73458,     5378.28,      -77.43,      545.71,     9844.15,       -0.18,        0.00,
     14.53078,      497.46,       -9.38,      307.25,      867.99,        0.00,        0.00,
      1.17704,       41.72,       -0.96,       46.23,       70.28,        0.00,        0.00,
     13.19400,      279.87,       -3.19,      721.29,        0.65,        0.14,        0.00,
    211.65487,     4685.54,      -42.06,     7715.64,        7.86,        2.12,       -0.01,
   4586.43061,    87132.46,     -842.12,    83586.18,     -191.17,       20.31,       -0.17,
     -9.36601,     -173.58,     -417.66,     -173.70,        0.48,       -0.06,        0.00,
     55.17801,      530.97,     2463.55,      -15.35,       -6.96,        1.20,        0.00,
   2369.91227,    69551.14,    -1472.50,    10817.07,     -255.36,       22.07,       -0.15,
     -5.74170,     -155.85,     -254.00,      -59.77,        0.64,       -0.10,        0.00,
     -6.38325,      -72.70,     -288.51,     -117.47,        1.16,        0.00,        0.00,
    191.95575,     5619.27,     -153.09,     4250.55,      -30.10,        2.78,       -0.02,
     14.37964,      417.80,      -13.71,      577.47,       -3.08,        0.28,        0.00,
      1.05949,       30.46,       -1.16,       61.74,       -0.30,        0.03,        0.00,
      2.48897,      257.30,       -3.72,       89.71,      150.19,        0.26,        0.00,
    -28.39810,      915.46,      -16.70,     -528.73,    -1693.30,       -0.38,        0.00,
     -1.43724,      -23.32,      -64.11,       -0.16,      -86.03,       -0.04,        0.00,
    -24.35910,     -661.00,       29.13,     -128.06,    -1457.61,       -5.21,        0.03,
     -2.91464,     -100.96,        4.26,      -66.13,     -174.49,       -0.75,        0.00,
     -2.52138,      -84.66,        0.74,      -46.07,     -302.13,        0.07,        0.00,
     -1.22412,      -28.10,        0.42,      -44.73,       -0.15,     -475.97,        2.51,
     -3.20968,     -121.62,        3.09,      -62.39,        1.61,    -1248.01,        6.58,
      2.73198,      106.73,       -1.04,       99.83,      163.20,        0.11,        0.00,
      4.37416,      221.00,       -3.71,       93.87,      260.99,       -0.05,        0.00,
      1.87083,      111.80,       -2.35,       25.65,      111.49,        0.16,        0.00,
      1.18682,       52.89,       -0.50,       64.88,        0.22,        0.25,        0.00,
     30.77247,     1164.74,      -12.42,     1123.35,       -4.25,        1.18,        0.00,
     38.42974,     1853.28,      -37.86,      849.77,       -9.84,        0.08,        0.00,
     13.89903,      782.37,      -19.88,      215.74,       -5.22,        1.37,        0.00,
      1.97772,      113.34,       -3.31,       59.21,       -0.94,        0.18,        0.00
};
static const int NUM02 = 45;
static const int ilu02[NUM02 * 4] = {
  0,  0,  0,  1,
  0,  0,  0,  3,
  0,  0,  1, -3,
  0,  0,  1, -1,
  0,  0,  1,  1,
  0,  0,  1,  3,
  0,  0,  2, -1,
  0,  0,  2,  1,
  0,  0,  3, -1,
  0,  0,  3,  1,
  0,  1, -1, -1,
  0,  1, -1,  1,
  0,  1,  0, -1,
  0,  1,  0,  1,
  0,  1,  1, -1,
  0,  1,  1,  1,
  1,  0,  0, -1,
  1,  0,  0,  1,
  2, -2,  0, -1,
  2, -1, -1, -1,
  2, -1, -1,  1,
  2, -1,  0, -1,
  2, -1,  0,  1,
  2, -1,  1, -1,
  2, -1,  1,  1,
  2,  0, -3, -1,
  2,  0, -2, -1,
  2,  0, -2,  1,
  2,  0, -1, -1,
  2,  0, -1,  1,
  2,  0,  0, -3,
  2,  0,  0, -1,
  2,  0,  0,  1,
  2,  0,  1, -1,
  2,  0,  1,  1,
  2,  0,  2, -1,
  2,  0,  2,  1,
  2,  1, -1,  1,
  2,  1,  0, -1,
  2,  1,  0,  1,
  4,  0, -2,  1,
  4,  0, -1, -1,
  4,  0, -1,  1,
  4,  0,  0, -1,
  4,  0,  0,   1
};
static const double coef02[NUM02 * 7] = {
  18461.40000,        0.00,   412529.61,        0.00,        0.00,        0.00,        0.00,
     -6.29664,        7.68,     -422.65,      -13.21,        0.02,       -0.02,        0.00,
      2.79871,      -17.13,      188.68,       50.78,       -0.11,        0.04,        0.00,
    999.70079,     -563.82,    22508.54,    18298.82,       -0.92,       -0.21,        0.00,
   1010.17430,      -93.16,    22571.83,    18386.36,       -0.76,       -0.17,        0.00,
     -1.01941,        0.95,      -68.42,      -19.88,        0.00,        0.00,        0.00,
     31.75985,     -167.64,      723.95,     1159.97,       -1.09,        0.22,        0.00,
     61.91229,      -23.73,     1382.40,     2253.18,       -0.62,       -0.06,        0.00,
      1.58131,      -10.25,       36.06,       86.53,       -0.08,        0.00,        0.00,
      3.98407,       -3.30,       88.86,      217.43,       -0.11,       -0.01,        0.00,
     -6.73173,     -159.36,     -146.94,     -122.89,     -403.36,       -0.03,        0.00,
     -5.63260,     -148.81,     -123.96,     -102.80,     -337.62,       -0.04,        0.00,
     -4.83983,       70.86,     -100.97,       -8.74,     -289.05,        0.02,        0.00,
     -6.46036,       28.14,     -136.25,      -20.21,     -386.09,        0.29,        0.00,
     -5.07614,     -113.16,     -112.23,      -93.12,     -304.28,        0.00,        0.00,
     -5.31151,      -99.03,     -115.96,      -99.19,     -318.30,        0.06,        0.00,
     -4.80578,     -102.50,     -103.39,       -3.12,       -0.09,    -1868.59,        9.85,
     -5.36844,     -119.82,     -113.86,       -3.16,       -0.08,    -2087.37,       11.00,
      1.08587,       23.51,       24.25,        0.47,      129.87,        0.00,        0.00,
      7.43488,      154.99,      165.14,      135.90,      444.61,       -0.02,        0.00,
      8.86853,      174.25,      196.33,      161.68,      530.29,       -0.01,        0.00,
     29.57794,      553.39,      661.64,       12.43,     1767.42,        0.16,        0.00,
      7.95891,      253.11,      175.21,       44.35,      475.60,        0.00,        0.00,
      1.76606,       35.98,       38.73,       33.43,      105.50,        0.02,        0.00,
      1.13466,       38.36,       24.88,       25.43,       67.78,        0.00,        0.00,
      1.51564,       31.76,       33.59,       82.84,        0.07,        0.00,        0.00,
     15.56635,      330.35,      344.99,      567.47,        0.23,        0.03,        0.00,
     -1.62443,      -20.88,      -36.38,      -59.20,        0.18,       -0.02,        0.00,
    166.57528,     3219.29,     3695.90,     3042.80,       -5.99,        0.39,        0.00,
    199.48515,     3726.28,     4413.25,     3627.39,       -8.68,        0.73,        0.00,
      2.18637,       23.85,      146.45,       -2.38,       -0.27,        0.03,        0.00,
    623.65783,     9963.62,    13978.19,      245.16,      -70.26,        5.00,       -0.03,
    117.26161,     3313.25,     2575.66,      874.52,      -12.65,        1.79,       -0.01,
     33.35743,      512.77,      735.76,      630.31,       -5.21,        0.43,        0.00,
     15.12165,      433.44,      331.25,      359.20,       -2.40,        0.31,        0.00,
      2.14618,       33.22,       46.62,       80.12,       -0.45,        0.04,        0.00,
      1.51976,       43.48,       33.21,       62.71,       -0.33,        0.04,        0.00,
     -1.31788,       39.71,      -29.98,      -24.58,      -78.59,        0.00,        0.00,
    -12.09470,     -205.76,     -271.06,       -3.14,     -723.84,       -0.31,        0.00,
     -1.26433,      -30.65,      -27.38,      -10.59,      -75.65,       -0.41,        0.00,
      2.41389,       90.53,       52.84,       87.95,       -0.35,        0.07,        0.00,
      6.57962,      223.57,      146.75,      123.07,       -1.94,        0.26,        0.00,
      2.99850,      142.57,       65.02,       71.12,       -0.78,        0.06,        0.00,
      3.67449,      157.55,       81.63,       29.57,       -1.61,        0.06,        0.00,
      1.19188,       65.39,       25.66,       23.11,       -0.45,        0.08,        0.00
};
static const int NUM03 = 49;
static const int ilu03[NUM03 * 4] = {
  0,  0,  0,  0,
  0,  0,  0,  2,
  0,  0,  1, -2,
  0,  0,  1,  0,
  0,  0,  2, -2,
  0,  0,  2,  0,
  0,  0,  3,  0,
  0,  0,  4,  0,
  0,  1, -2,  0,
  0,  1, -1,  0,
  0,  1,  0,  0,
  0,  1,  1,  0,
  0,  1,  2,  0,
  0,  2, -1,  0,
  0,  2,  0,  0,
  0,  2,  1,  0,
  1,  0, -2,  0,
  1,  0, -1,  0,
  1,  0,  0,  0,
  1,  0,  1,  0,
  1,  1,  0,  0,
  2, -2, -1,  0,
  2, -2,  0,  0,
  2, -1, -2,  0,
  2, -1, -1,  0,
  2, -1,  0,  0,
  2, -1,  1,  0,
  2,  0, -3,  0,
  2,  0, -2,  0,
  2,  0, -1, -2,
  2,  0, -1,  0,
  2,  0,  0, -2,
  2,  0,  0,  0,
  2,  0,  1, -2,
  2,  0,  1,  0,
  2,  0,  2,  0,
  2,  1, -1,  0,
  2,  1,  0,  0,
  2,  1,  1,  0,
  2,  2, -1,  0,
  3,  0, -1,  0,
  3,  0,  0,  0,
  4, -1, -2,  0,
  4, -1, -1,  0,
  4, -1,  0,  0,
  4,  0, -2,  0,
  4,  0, -1,  0,
  4,  0,  0,  0,
  4,  0,  1,   0
};
static const double coef03[NUM03 * 7] = {
 385000.52719,    -7992.63,      -11.06,    21578.08,       -4.53,       11.39,       -0.06,
     -3.14837,     -204.48,     -138.94,      159.64,       -0.39,        0.12,        0.00,
     79.66183,     -359.45,     3583.79,     1454.02,       -2.37,        0.85,        0.00,
 -20905.32206,     6888.23,      -35.83,  -380331.74,       22.31,        1.77,        0.00,
     -4.42124,       18.29,     -198.91,     -161.90,        0.14,       -0.04,        0.00,
   -569.92332,      374.44,       -1.99,   -20737.33,        5.79,        0.44,        0.00,
    -23.21032,       26.49,       -0.14,    -1266.64,        0.63,        0.05,        0.00,
     -1.11693,        1.98,        0.00,      -81.26,        0.06,        0.00,        0.00,
     -7.00293,     -161.63,        3.29,     -254.78,     -419.55,       -0.12,        0.00,
   -129.62476,    -3122.77,       61.80,    -2362.46,    -7767.84,       -0.74,        0.00,
     48.89010,     1082.40,      -25.99,      156.78,     2926.50,       -3.76,        0.02,
    104.75896,     2165.07,      -47.62,     1929.10,     6279.07,       -0.60,        0.00,
      5.75105,      119.47,       -2.62,      210.76,      344.76,       -0.09,        0.00,
     -2.11728,      -59.78,        1.22,      -38.70,     -253.61,        0.00,        0.00,
      1.06575,       16.47,       -0.60,        3.28,      127.54,        0.00,        0.00,
      1.16562,       22.20,       -0.39,       21.49,      139.60,        0.00,        0.00,
     -1.73852,      -48.13,        1.59,      -63.71,       -0.50,     -675.99,        3.56,
     -8.37909,     -219.27,        9.53,     -156.07,       -0.84,    -3257.99,       17.18,
    108.74265,     2351.06,     -120.48,       69.82,        2.01,    42281.56,     -222.90,
      6.32199,      138.54,       -6.74,      118.10,       -0.56,     2458.13,      -12.96,
    -16.67533,       -4.78,       10.81,      -19.36,     -997.67,    -6483.73,       34.18,
     -4.95049,      -84.90,        0.91,      -90.35,     -592.24,        0.03,        0.00,
     -9.88519,     -346.35,        1.99,      -14.48,    -1182.31,        0.07,        0.00,
     10.05654,      188.87,       -1.29,      366.36,      601.57,       -0.03,        0.00,
   -152.14314,    -2564.20,       30.40,    -2771.74,    -9097.84,        0.06,        0.00,
   -204.59357,    -6583.80,       38.79,     -377.95,   -12225.82,        0.27,        0.00,
    -12.83185,     -434.14,        2.98,     -260.02,     -766.51,        0.02,        0.00,
     14.40262,      282.85,       -2.35,      786.99,        0.58,        0.14,        0.00,
    246.15768,     4806.36,      -51.78,     8962.91,       -0.43,        1.11,        0.00,
      8.75170,      133.45,      390.01,      155.98,       -0.28,        0.20,        0.00,
  -3699.10468,   -63127.05,      818.00,   -67236.74,      147.86,      -15.95,        0.14,
     10.32129,      282.08,      460.16,      -60.76,       -1.29,        0.06,        0.00,
  -2955.96651,   -86674.51,      507.99,    -7597.69,      323.54,      -19.09,        0.14,
      4.13118,       20.86,      186.87,       75.09,       -0.76,        0.00,        0.00,
   -170.73274,    -4963.30,       29.72,    -3579.16,       26.82,       -1.82,        0.00,
    -10.44472,     -300.48,        1.81,     -410.75,        2.24,       -0.17,        0.00,
     24.20935,     -837.26,       13.30,      449.34,     1443.45,        0.26,        0.00,
     30.82498,      873.36,       -8.40,       94.40,     1844.57,        3.86,       -0.02,
      2.61650,       90.88,       -1.01,       56.02,      156.64,        0.49,        0.00,
      2.35380,       79.52,       -0.72,       42.86,      282.05,       -0.06,        0.00,
      3.25823,      117.77,       -2.27,       61.91,       -1.34,     1266.88,       -6.68,
     -1.41893,      -19.43,       -0.69,       10.76,       -0.63,     -551.71,        2.91,
     -1.89710,      -73.13,        0.79,      -69.17,     -113.34,       -0.12,        0.00,
     -3.95812,     -199.78,        1.54,      -80.75,     -236.16,        0.15,        0.00,
     -1.57145,      -94.02,        0.59,      -18.48,      -93.65,       -0.26,        0.00,
    -21.63627,     -808.81,        9.47,     -788.01,        2.77,       -1.21,        0.00,
    -34.78245,    -1678.73,       13.50,     -725.23,        8.97,        0.88,        0.00,
    -11.64993,     -657.42,        4.13,     -155.60,        4.42,       -2.17,        0.00,
     -1.42255,      -81.30,        0.50,      -40.47,        0.68,       -0.21,        0.00
};
static const int NUM04 = 1;
static const int iz04[NUM04] = {
  1
};
static const int ilu04[NUM04 * 4] = {
  0,  0,  0, -1
};
static const double pha04[NUM04] = {
   0.00094
};
static const double x04[NUM04] = {
   7.06304
};
static const int NUM05 = 1;
static const int iz05[NUM05] = {
  1
};
static const int ilu05[NUM05 * 4] = {
  0,  0,  0,  0
};
static const double pha05[NUM05] = {
 180.00071
};
static const double x05[NUM05] = {
   8.04508
};
static const int NUM06 = 0;
static const int *iz06 = NULL;
static const int *ilu06 = NULL;
static const double *pha06 = NULL;
static const double *x06 = NULL;
static const int NUM07 = 0;
static const int *iz07 = NULL;
static const int *ilu07 = NULL;
static const double *pha07 = NULL;
static const double *x07 = NULL;
static const int NUM08 = 0;
static const int *iz08 = NULL;
static const int *ilu08 = NULL;
static const double *pha08 = NULL;
static const double *x08 = NULL;
static const int NUM09 = 0;
static const int *iz09 = NULL;
static const int *ilu09 = NULL;
static const double *pha09 = NULL;
static const double *x09 = NULL;
static const int NUM22 = 0;
static const int *iz22 = NULL;
static const int *ilu22 = NULL;
static const double *pha22 = NULL;
static const double *x22 = NULL;
static const int NUM23 = 0;
static const int *iz23 = NULL;
static const int *ilu23 = NULL;
static const double *pha23 = NULL;
static const double *x23 = NULL;
static const int NUM24 = 0;
static const int *iz24 = NULL;
static const int *ilu24 = NULL;
static const double *pha24 = NULL;
static const double *x24 = NULL;
static const int NUM25 = 0;
static const int *iz25 = NULL;
static const int *ilu25 = NULL;
static const double *pha25 = NULL;
static const double *x25 = NULL;
static const int NUM26 = 0;
static const int *iz26 = NULL;
static const int *ilu26 = NULL;
static const double *pha26 = NULL;
static const double *x26 = NULL;
static const int NUM27 = 0;
static const int *iz27 = NULL;
static const int *ilu27 = NULL;
static const double *pha27 = NULL;
static const double *x27 = NULL;
static const int NUM28 = 0;
static const int *iz28 = NULL;
static const int *ilu28 = NULL;
static const double *pha28 = NULL;
static const double *x28 = NULL;
static const int NUM29 = 0;
static const int *iz29 = NULL;
static const int *ilu29 = NULL;
static const double *pha29 = NULL;
static const double *x29 = NULL;
static const int NUM30 = 0;
static const int *iz30 = NULL;
static const int *ilu30 = NULL;
static const double *pha30 = NULL;
static const double *x30 = NULL;
static const int NUM31 = 0;
static const int *iz31 = NULL;
static const int *ilu31 = NULL;
static const double *pha31 = NULL;
static const double *x31 = NULL;
static const int NUM32 = 0;
static const int *iz32 = NULL;
static const int *ilu32 = NULL;
static const double *pha32 = NULL;
static const double *x32 = NULL;
static const int NUM33 = 0;
static const int *iz33 = NULL;
static const int *ilu33 = NULL;
static const double *pha33 = NULL;
static const double *x33 = NULL;
static const int NUM34 = 0;
static const int *iz34 = NULL;
static const int *ilu34 = NULL;
static const double *pha34 = NULL;
static const double *x34 = NULL;
static const int NUM35 = 0;
static const int *iz35 = NULL;
static const int *ilu35 = NULL;
static const double *pha35 = NULL;
static const double *x35 = NULL;
static const int NUM36 = 0;
static const int *iz36 = NULL;
static const int *ilu36 = NULL;
static const double *pha36 = NULL;
static const double *x36 = NULL;
static const int NUM10 = 2;
static const int ipla10[NUM10 * 11] = {
  0,  0,  2,  0, -2,  0,  0,  0,  2, -1,  0,
  0, 18,-16,  0,  0,  0,  0,  0,  0, -1,  0
};
static const double pha10[NUM10] = {
 180.11977,
  26.54261
};
static const double x10[NUM10] = {
   1.14307,
  14.24883
};
static const int NUM11 = 0;
static const int *ipla11 = NULL;
static const double *pha11 = NULL;
static const double *x11 = NULL;
static const int NUM12 = 1;
static const int ipla12[NUM12 * 11] = {
  0,  0,  2,  0, -2,  0,  0,  0,  2, -1,  0
};
static const double pha12[NUM12] = {
  90.11969
};
static const double x12[NUM12] = {
   1.05870
};
static const int NUM13 = 0;
static const int *ipla13 = NULL;
static const double *pha13 = NULL;
static const double *x13 = NULL;
static const int NUM14 = 0;
static const int *ipla14 = NULL;
static const double *pha14 = NULL;
static const double *x14 = NULL;
static const int NUM15 = 0;
static const int *ipla15 = NULL;
static const double *pha15 = NULL;
static const double *x15 = NULL;
static const int NUM16 = 0;
static const int *ipla16 = NULL;
static const double *pha16 = NULL;
static const double *x16 = NULL;
static const int NUM17 = 1;
static const int ipla17[NUM17 * 11] = {
  0,  0,  1,  0,  0,  0,  0,  1,  0,  0,  0
};
static const double pha17[NUM17] = {
 275.13226
};
static const double x17[NUM17] = {
   1.37497
};
static const int NUM18 = 0;
static const int *ipla18 = NULL;
static const double *pha18 = NULL;
static const double *x18 = NULL;
static const int NUM19 = 1;
static const int ipla19[NUM19 * 11] = {
  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0
};
static const double pha19[NUM19] = {
   0.00000
};
static const double x19[NUM19] = {
   1.67680
};
static const int NUM20 = 0;
static const int *ipla20 = NULL;
static const double *pha20 = NULL;
static const double *x20 = NULL;
static const int NUM21 = 0;
static const int *ipla21 = NULL;
static const double *pha21 = NULL;
static const double *x21 = NULL;
static const int NUM[36] = {
    NUM01,
    NUM02,
    NUM03,
    NUM04,
    NUM05,
    NUM06,
    NUM07,
    NUM08,
    NUM09,
    NUM10,
    NUM11,
    NUM12,
    NUM13,
    NUM14,
    NUM15,
    NUM16,
    NUM17,
    NUM18,
    NUM19,
    NUM20,
    NUM21,
    NUM22,
    NUM23,
    NUM24,
    NUM25,
    NUM26,
    NUM27,
    NUM28,
    NUM29,
    NUM30,
    NUM31,
    NUM32,
    NUM33,
    NUM34,
    NUM35,
    NUM36
};
static const int *ILU[36] = {
    ilu01,
    ilu02,
    ilu03,
    ilu04,
    ilu05,
    ilu06,
    ilu07,
    ilu08,
    ilu09,
     NULL,
     NULL,
     NULL,
     NULL,
     NULL,
     NULL,
     NULL,
     NULL,
     NULL,
     NULL,
     NULL,
     NULL,
    ilu22,
    ilu23,
    ilu24,
    ilu25,
    ilu26,
    ilu27,
    ilu28,
    ilu29,
    ilu30,
    ilu31,
    ilu32,
    ilu33,
    ilu34,
    ilu35,
ilu36
};
static const double *COEF[3] = {
    coef01,
    coef02,
    coef03
};
static const int *IZ[36] = {
    NULL,
    NULL,
    NULL,
    iz04,
    iz05,
    iz06,
    iz07,
    iz08,
    iz09,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    iz22,
    iz23,
    iz24,
    iz25,
    iz26,
    iz27,
    iz28,
    iz29,
    iz30,
    iz31,
    iz32,
    iz33,
    iz34,
    iz35,
    iz36
};
static const double *PHA[36] = {
     NULL,
     NULL,
     NULL,
    pha04,
    pha05,
    pha06,
    pha07,
    pha08,
    pha09,
    pha10,
    pha11,
    pha12,
    pha13,
    pha14,
    pha15,
    pha16,
    pha17,
    pha18,
    pha19,
    pha20,
    pha21,
    pha22,
    pha23,
    pha24,
    pha25,
    pha26,
    pha27,
    pha28,
    pha29,
    pha30,
    pha31,
    pha32,
    pha33,
    pha34,
    pha35,
    pha36
};
static const double *XX[36] = {
    NULL,
    NULL,
    NULL,
     x04,
     x05,
     x06,
     x07,
     x08,
     x09,
     x10,
     x11,
     x12,
     x13,
     x14,
     x15,
     x16,
     x17,
     x18,
     x19,
     x20,
     x21,
     x22,
     x23,
     x24,
     x25,
     x26,
     x27,
     x28,
     x29,
     x30,
     x31,
     x32,
     x33,
     x34,
     x35,
x36
};
static const int *IPLA[21] = {
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
    ipla10,
    ipla11,
    ipla12,
    ipla13,
    ipla14,
    ipla15,
    ipla16,
    ipla17,
    ipla18,
    ipla19,
    ipla20,
    ipla21
};
#endif
