/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.evpull.EndDocumentEvent;
import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.StartDocumentEvent;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.om.NamespaceDeclarationsImpl;
import net.sf.saxon.tinytree.TinyElementImpl;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.trans.XPathException;

public class TinyTreeEventIterator
implements EventIterator {
    private int startNodeNr;
    private int currentNodeNr;
    private int pendingEndEvents = 0;
    private boolean startAtDocument = false;
    private TinyTree tree;
    private NamespaceDeclarationsImpl nsDeclarations;
    private int[] nsBuffer = new int[10];

    public TinyTreeEventIterator(TinyNodeImpl startNode) {
        int kind = startNode.getNodeKind();
        if (kind != 9 && kind != 1) {
            throw new IllegalArgumentException("TinyTreeEventIterator must start at a document or element node");
        }
        this.currentNodeNr = this.startNodeNr = startNode.nodeNr;
        this.tree = startNode.tree;
        this.pendingEndEvents = 0;
        this.startAtDocument = kind == 9;
        this.nsDeclarations = new NamespaceDeclarationsImpl();
        this.nsDeclarations.setNamePool(startNode.getNamePool());
    }

    public PullEvent next() throws XPathException {
        boolean atEnd;
        if (this.startNodeNr < 0) {
            return null;
        }
        short thisDepth = this.tree.depth[this.currentNodeNr];
        boolean lastNode = this.currentNodeNr + 1 >= this.tree.numberOfNodes;
        short nextDepth = lastNode ? (short)0 : this.tree.depth[this.currentNodeNr + 1];
        boolean bl = atEnd = thisDepth == this.tree.depth[this.startNodeNr] && this.currentNodeNr != this.startNodeNr;
        if (atEnd && this.pendingEndEvents == 1) {
            --this.pendingEndEvents;
            this.startNodeNr = -1;
            if (this.startAtDocument) {
                return EndDocumentEvent.getInstance();
            }
            return EndElementEvent.getInstance();
        }
        if (this.pendingEndEvents > 0) {
            --this.pendingEndEvents;
            return EndElementEvent.getInstance();
        }
        byte kind = this.tree.nodeKind[this.currentNodeNr];
        switch (kind) {
            case 9: {
                this.pendingEndEvents = thisDepth - nextDepth + 1;
                ++this.currentNodeNr;
                return StartDocumentEvent.getInstance();
            }
            case 1: {
                this.pendingEndEvents = thisDepth - nextDepth + 1;
                StartElementEvent see = new StartElementEvent(this.tree.getConfiguration());
                see.setNameCode(this.tree.nameCode[this.currentNodeNr]);
                see.setTypeCode(this.tree.getTypeAnnotation(this.currentNodeNr));
                int index = this.tree.alpha[this.currentNodeNr];
                if (index >= 0) {
                    while (index < this.tree.numberOfAttributes || this.tree.attParent[index] == this.currentNodeNr) {
                        see.addAttribute(this.tree.getAttributeNode(index++));
                    }
                }
                if (this.currentNodeNr == this.startNodeNr) {
                    see.setLocalNamespaces(TinyElementImpl.getInScopeNamespaces(this.tree, this.currentNodeNr, this.nsBuffer));
                } else {
                    see.setLocalNamespaces(TinyElementImpl.getDeclaredNamespaces(this.tree, this.currentNodeNr, this.nsBuffer));
                }
                ++this.currentNodeNr;
                return see;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                this.pendingEndEvents = thisDepth - nextDepth;
                return this.tree.getNode(this.currentNodeNr++);
            }
            case 12: {
                throw new IllegalStateException("First child node must not be a parent-pointer pseudo-node");
            }
        }
        throw new IllegalStateException("Unknown node kind " + this.tree.nodeKind[this.currentNodeNr]);
    }

    public boolean isFlatSequence() {
        return true;
    }
}

