/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.exslt;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DoubleValue;

public abstract class Random {
    public static SequenceIterator randomSequence(int numberOfItems, double seed) throws IllegalArgumentException {
        if (numberOfItems < 1) {
            throw new IllegalArgumentException("numberOfItems supplied to randomSequence() must be positive");
        }
        long javaSeed = Double.doubleToLongBits(seed);
        return new RandomIterator(numberOfItems, javaSeed);
    }

    public static SequenceIterator randomSequence(int numberOfItems) throws IllegalArgumentException {
        return Random.randomSequence(numberOfItems, System.currentTimeMillis());
    }

    public static DoubleValue randomSequence() throws XPathException {
        return (DoubleValue)Random.randomSequence(1).next();
    }

    private static class RandomIterator
    implements UnfailingIterator {
        protected int position = 0;
        protected Item current;
        private int count;
        private long seed;
        private java.util.Random generator;

        public RandomIterator(int count, long seed) {
            this.count = count;
            this.seed = seed;
            this.generator = new java.util.Random(seed);
        }

        public Item next() {
            if (this.position++ >= this.count) {
                this.current = null;
                this.position = -1;
                return null;
            }
            this.current = new DoubleValue(this.generator.nextDouble());
            return this.current;
        }

        public final Item current() {
            return this.current;
        }

        public final int position() {
            return this.position;
        }

        public SequenceIterator getAnother() {
            return new RandomIterator(this.count, this.seed);
        }

        public int getProperties() {
            return 0;
        }
    }
}

