/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Properties;
import javax.xml.transform.Result;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.ImplicitResultChecker;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.SerializerFactory;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.LocalParam;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.DateTimeValue;

public class XPathContextMinor
implements XPathContext {
    Controller controller;
    SequenceIterator currentIterator;
    int last = -1;
    SequenceReceiver currentReceiver;
    boolean isTemporaryDestination = false;
    XPathContext caller = null;
    protected StackFrame stackFrame;
    Object origin = null;

    protected XPathContextMinor() {
    }

    public XPathContextMajor newContext() {
        return XPathContextMajor.newContext(this);
    }

    public XPathContextMinor newMinorContext() {
        XPathContextMinor c = new XPathContextMinor();
        c.controller = this.controller;
        c.caller = this;
        c.currentIterator = this.currentIterator;
        c.currentReceiver = this.currentReceiver;
        c.last = this.last;
        c.isTemporaryDestination = this.isTemporaryDestination;
        c.stackFrame = this.stackFrame;
        return c;
    }

    public void setCaller(XPathContext caller) {
        this.caller = caller;
    }

    public XPathContextMajor newCleanContext() {
        XPathContextMajor c = new XPathContextMajor(this.getController());
        c.setCaller(this);
        return c;
    }

    public ParameterSet getLocalParameters() {
        return this.getCaller().getLocalParameters();
    }

    public ParameterSet getTunnelParameters() {
        return this.getCaller().getTunnelParameters();
    }

    public void setOrigin(InstructionInfoProvider expr) {
        this.origin = expr;
    }

    public void setOriginatingConstructType(int loc) {
        this.origin = new Integer(loc);
    }

    public int getOriginatingConstructType() {
        if (this.origin == null) {
            return -1;
        }
        if (this.origin instanceof InstructionInfoProvider) {
            return ((InstructionInfoProvider)this.origin).getInstructionInfo().getConstructType();
        }
        return (Integer)this.origin;
    }

    public InstructionInfoProvider getOrigin() {
        if (this.origin instanceof InstructionInfoProvider) {
            return (InstructionInfoProvider)this.origin;
        }
        return null;
    }

    public final Controller getController() {
        return this.controller;
    }

    public final Configuration getConfiguration() {
        return this.controller.getConfiguration();
    }

    public final NamePool getNamePool() {
        return this.controller.getNamePool();
    }

    public final NameChecker getNameChecker() {
        return this.controller.getConfiguration().getNameChecker();
    }

    public final XPathContext getCaller() {
        return this.caller;
    }

    public void setCurrentIterator(SequenceIterator iter) {
        this.currentIterator = iter;
        this.last = 0;
    }

    public final SequenceIterator getCurrentIterator() {
        return this.currentIterator;
    }

    public final int getContextPosition() throws XPathException {
        if (this.currentIterator == null) {
            XPathException e = new XPathException("The context position is currently undefined");
            e.setXPathContext(this);
            e.setErrorCode("FONC0001");
            throw e;
        }
        return this.currentIterator.position();
    }

    public final Item getContextItem() {
        if (this.currentIterator == null) {
            return null;
        }
        return this.currentIterator.current();
    }

    public final int getLast() throws XPathException {
        if (this.last > 0) {
            return this.last;
        }
        if (this.currentIterator == null) {
            XPathException e = new XPathException("The context size is currently undefined");
            e.setXPathContext(this);
            e.setErrorCode("FONC0001");
            throw e;
        }
        if ((this.currentIterator.getProperties() & 2) == 0) {
            SequenceIterator another = this.currentIterator.getAnother();
            this.last = 0;
            while (another.next() != null) {
                ++this.last;
            }
            return this.last;
        }
        this.last = ((LastPositionFinder)this.currentIterator).getLastPosition();
        return this.last;
    }

    public final boolean isAtLast() throws XPathException {
        if ((this.currentIterator.getProperties() & 4) != 0) {
            return !((LookaheadIterator)this.currentIterator).hasNext();
        }
        return this.getContextPosition() == this.getLast();
    }

    public final StringCollator getCollation(String name) throws XPathException {
        if (name.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        StringCollator collation = null;
        if (this.controller != null && (collation = this.controller.getExecutable().getNamedCollation(name)) == null) {
            Configuration config = this.controller.getConfiguration();
            collation = config.getCollationURIResolver().resolve(name, null, config);
        }
        if (collation == null) {
            XPathException e = new XPathException("Unknown collation " + name);
            e.setErrorCode("FOCH0002");
            e.setXPathContext(this);
            throw e;
        }
        return collation;
    }

    public final StringCollator getDefaultCollation() {
        if (this.controller != null) {
            return this.controller.getExecutable().getDefaultCollation();
        }
        return CodepointCollator.getInstance();
    }

    public StackFrame getStackFrame() {
        return this.stackFrame;
    }

    public ValueRepresentation evaluateLocalVariable(int slotnumber) {
        return this.stackFrame.slots[slotnumber];
    }

    public void setLocalVariable(int slotnumber, ValueRepresentation value) {
        this.stackFrame.slots[slotnumber] = value;
    }

    public void changeOutputDestination(Properties props, Result result, boolean isFinal, int hostLanguage, int validation, SchemaType schemaType) throws XPathException {
        if (isFinal && this.isTemporaryDestination) {
            XPathException err = new XPathException("Cannot switch to a final result destination while writing a temporary tree");
            err.setErrorCode("XTDE1480");
            throw err;
        }
        if (isFinal) {
            validation |= 0x10000;
        } else {
            this.isTemporaryDestination = true;
        }
        PipelineConfiguration pipe = null;
        if (result instanceof Receiver) {
            pipe = ((Receiver)result).getPipelineConfiguration();
        }
        if (pipe == null) {
            pipe = this.controller.makePipelineConfiguration();
            pipe.setSerializing(isFinal);
            pipe.setHostLanguage(hostLanguage);
        }
        ComplexContentOutputter out = new ComplexContentOutputter();
        out.setHostLanguage(hostLanguage);
        out.setPipelineConfiguration(pipe);
        if (props == null) {
            props = new Properties();
        }
        SerializerFactory sf = this.getConfiguration().getSerializerFactory();
        Receiver receiver = sf.getReceiver(result, pipe, props);
        if ("yes".equals(props.getProperty("{http://saxon.sf.net/}implicit-result-document"))) {
            receiver = new ImplicitResultChecker(receiver, this.controller);
        }
        NamespaceReducer ne = new NamespaceReducer();
        ne.setUnderlyingReceiver(receiver);
        ne.setPipelineConfiguration(pipe);
        receiver = this.controller.getConfiguration().getDocumentValidator(ne, receiver.getSystemId(), validation, 0, schemaType, -1);
        out.setReceiver(receiver);
        this.currentReceiver = out;
    }

    public void setTemporaryReceiver(SequenceReceiver out) {
        this.isTemporaryDestination = true;
        this.currentReceiver = out;
    }

    public void setReceiver(SequenceReceiver receiver) {
        this.currentReceiver = receiver;
    }

    public final SequenceReceiver getReceiver() {
        return this.currentReceiver;
    }

    public boolean useLocalParameter(StructuredQName qName, LocalParam binding, boolean isTunnel) throws XPathException {
        return this.getCaller().useLocalParameter(qName, binding, isTunnel);
    }

    public Mode getCurrentMode() {
        return this.getCaller().getCurrentMode();
    }

    public Rule getCurrentTemplateRule() {
        return this.getCaller().getCurrentTemplateRule();
    }

    public GroupIterator getCurrentGroupIterator() {
        return this.getCaller().getCurrentGroupIterator();
    }

    public RegexIterator getCurrentRegexIterator() {
        return this.getCaller().getCurrentRegexIterator();
    }

    public DateTimeValue getCurrentDateTime() {
        return this.controller.getCurrentDateTime();
    }

    public final int getImplicitTimezone() {
        return this.controller.getImplicitTimezone();
    }
}

