/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceExtent;

public final class AtomicSequenceConverter
extends UnaryExpression {
    private AtomicType requiredItemType;
    private BuiltInAtomicType requiredPrimitiveType;

    public AtomicSequenceConverter(Expression sequence, AtomicType requiredItemType) {
        super(sequence);
        this.requiredItemType = requiredItemType;
        this.requiredPrimitiveType = (BuiltInAtomicType)requiredItemType.getPrimitiveItemType();
        ExpressionTool.copyLocationInfo(sequence, this);
    }

    public AtomicType getRequiredPrimitiveType() {
        return this.requiredPrimitiveType;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        if (this.operand instanceof Literal) {
            return Literal.makeLiteral(new SequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext())));
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (th.isSubType(this.operand.getItemType(th), this.requiredItemType)) {
            return this.operand;
        }
        if (!Cardinality.allowsMany(this.operand.getCardinality())) {
            CastExpression cast = new CastExpression(this.operand, this.requiredItemType, (this.operand.getCardinality() & 0x2000) != 0);
            ExpressionTool.copyLocationInfo(this, cast);
            return cast;
        }
        return this;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy() {
        return new AtomicSequenceConverter(this.getBaseExpression().copy(), this.requiredItemType);
    }

    public SequenceIterator iterate(final XPathContext context) throws XPathException {
        SequenceIterator base = this.operand.iterate(context);
        ItemMappingFunction converter = new ItemMappingFunction(){

            public Item map(Item item) throws XPathException {
                return ((AtomicValue)item).convert(AtomicSequenceConverter.this.requiredPrimitiveType, true, context).asAtomic();
            }
        };
        return new ItemMappingIterator(base, converter);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item = this.operand.evaluateItem(context);
        if (item == null) {
            return null;
        }
        return ((AtomicValue)item).convert(this.requiredPrimitiveType, true, context).asAtomic();
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.requiredItemType;
    }

    public int computeCardinality() {
        return this.operand.getCardinality();
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.requiredPrimitiveType == ((AtomicSequenceConverter)other).requiredPrimitiveType;
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("convertItems");
        destination.emitAttribute("to", this.requiredItemType.toString(destination.getNamePool()));
        this.operand.explain(destination);
        destination.endElement();
    }
}

