/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.charcode;

public class UTF16 {
    public static final int NONBMP_MIN = 65536;
    public static final int NONBMP_MAX = 0x10FFFF;
    public static final char SURROGATE1_MIN = '\ud800';
    public static final char SURROGATE1_MAX = '\udbff';
    public static final char SURROGATE2_MIN = '\udc00';
    public static final char SURROGATE2_MAX = '\udfff';

    public static int combinePair(char high, char low) {
        return (high - 55296) * 1024 + (low - 56320) + 65536;
    }

    public static char highSurrogate(int ch) {
        return (char)((ch - 65536 >> 10) + 55296);
    }

    public static char lowSurrogate(int ch) {
        return (char)((ch - 65536 & 0x3FF) + 56320);
    }

    public static boolean isSurrogate(int c) {
        return (c & 0xF800) == 55296;
    }

    public static boolean isHighSurrogate(int ch) {
        return 55296 <= ch && ch <= 56319;
    }

    public static boolean isLowSurrogate(int ch) {
        return 56320 <= ch && ch <= 57343;
    }
}

