/*
 * Copyright (C) 2000-2024 the xine project
 *
 * This file is part of xine, a unix video player.
 *
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 */

#ifndef EVENT_SENDER_H
#define EVENT_SENDER_H

/** fill in the translated navigation menu names for the current mrl. */
int event_sender_menu_names (gGui_t *gui, const char *names[7]);

/** open/toggle/close navigation window (supports XUI_W_*). */
void event_sender_main (xitk_widget_t *mode, void *gui);

/** make navigation window follow the panel position. */
void event_sender_sticky_cb (void *gui, xine_cfg_entry_t *cfg);
/** tell that panel has moved. */
void event_sender_move (gGui_t *gui);

/** adjust the navigation window menu for a new mrl, */
void event_sender_update_menu_buttons (gGui_t *gui);
/** a new skin has been loaded. */
void event_sender_change_skins (xui_event_sender_t *es, int synthetic);

#endif
