/*
 *----------------------------------------------------------------------
 *
 * PROGRAM  : gksmc
 *
 * FILE     : defns.h
 *
 * CONTENTS : Contains definitions for values of global variables,
 *	      and the entries in the tables and enumerations.
 *
 * DATE     : 17th March 1988
 *
 *----------------------------------------------------------------------
 */

/* Structure used to hold a point */
typedef struct {
    double x, y ;
   } Point ;


/* Structure used to hold a colour definition */
typedef struct {
    int ColrIndex ;
    int red, green, blue ;
   } ColourDef ;


/*
 *-----------------------------------------
 * Names for each row in the enumeration
 * table
 *-----------------------------------------
 */
#define E_PREPVS	0
#define E_UPDATE	1
#define E_DEFMODE	2
#define E_DEFREGEN	3
#define E_MESSAGE	4
#define E_TEXTEND	5
#define E_TEXTPATH	6
#define E_TEXTPREC	7
#define E_HORIZ		8
#define E_VERT		9
#define E_INTERIOR	10
#define E_SEGVIS	11
#define E_SEGHL		12
#define E_SEGDET	13
#define E_ASFNAME	14
#define E_ASFTYPE	15
#define E_PSEUDOASF	16
#define E_MFCAT		17
#define E_VDCTYPE	18
#define E_SCALESPEC	19
#define E_COLRSEL	20
#define E_SPEC		21
#define E_ELEMGROUP	22
#define E_DVSPECMODE	23
#define E_CHARCODING	24


/*
 *---------------------------------------------
 * Definitions for values of cgm global
 * variables
 *---------------------------------------------
 */

#define FALSE		0
#define TRUE		1

/* VDC type */
#define VDC_INT		0
#define VDC_REAL	1

/* Metafile category */
#define CGM		0
#define GKSM		1
#define CGMEXT1		2

/* Point list formats */
#define LIST_ABSOLUTE	0
#define LIST_INCR	1

/* Encodings */
#define CLEAR_TEXT	0
#define CHARACTER	1

/* CGM item name tables */
#define OP_TABLE	0
#define CGM_TABLE	1

#define DEFAULT		-1

/* Real representation used in Annex E */
#define	REAL_AS_REAL	1
#define	REAL_AS_INT	2

/* Number format in Annex E - clear text or binary */
#define BINARY_FORMAT	2

/*
 *---------------------------------------------------
 * Definitions for values in enumerations where the
 * value is given explicitly in a routine
 *---------------------------------------------------
 */

/* Device viewport specification mode */
#define UNKNOWN -1
#define FRACTION 0
#define MM 1
#define PHYDEVICEUNITS 2

/* MF element list */
#define DRAWINGSET	0
#define DRAWINGPLUS	1

/* Scaling Mode */
#define ABSTRACT	0
#define METRIC		1

/* Colour selection mode */
#define INDEXED		0
#define DIRECT		1

/* Linewidth and marker size specification mode */
#define ABSOLUTE	0
#define SCALED		1

/* Prepare view surface */
#define CONDITIONAL	0
#define FORCEHARDCOPY	1

/* Real precision exponents allowed parameter */
#define ALLOWED		0
#define FORBIDDEN	1

/* Text Final or not final flag */
#define NOTFINAL	0
#define FINAL		1

/* Message */
#define NOACTION	0
#define	ACTION		1

/* Character Coding Announcer */
#define BASIC7BIT	0
#define BASIC8BIT	1
#define EXTD7BIT	2
#define EXTD8BIT	3

/*
 *-----------------------------------------
 * Miscellaneous definitions
 *-----------------------------------------
 */

/* Start Of String and String Terminator sequences used to delimit
   character encoding strings */
#define SOS			"\033\130"
#define ST			"\033\134"

#define LOG_10_ON_LOG_2		3.3219280949

/* Code for the ALL pseudo ASF in character encoding */
#define CE_ALL_ASF		511

#define NO_SOS			0

#define SOFTSEP			0
#define OPTSEP			1
#define HARDSEP			2
#define SEP			3
#define TERMINATOR		4

/* Position of COLRTABLE item in OpTable */
#define COLRTABLE		55

/* restrictions on integer parameters */
#define	ANY		0
#define POSITIVE	1
#define	NON_NEGATIVE	2
