/*
 *========================================================================
 * $Id: meminfo.c 88 2004-09-28 22:49:38Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include <wulfware/libwulf.h>

/*
 * <meminfo> tag init and update (same thing)
 */
void init_meminfo(Host *hostptr)
{

 /* 
  * scratch: current timestamp and delta (to microsecond resolution) 
  */
 unsigned long seconds,useconds;

 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: Starting init_meminfo().  Use -v %d to focus.\n",D_VALUES);
   
 }

 /* 
  * meminfo - tv_sec and tv_usec timestamps.
  */
 /* <meminfo tv_sec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&seconds,value_xpath[MEMINFO],
                      "tv_sec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[MEMINFO]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: seconds = %d\n",seconds);
 }
 hostptr->val.meminfo_tv_sec = seconds;

 /* <meminfo tv_usec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&useconds,value_xpath[MEMINFO],
                      "tv_usec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[MEMINFO]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: useconds = %d\n",useconds);
 }
 hostptr->val.meminfo_tv_usec = useconds;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: meminfo_tv_sec = %ul meminfo_tv_usec = %ul\n",hostptr->val.meminfo_tv_sec,hostptr->val.meminfo_tv_usec);
 }

 /* meminfo - memory */
 if(xtract_attribute(STRING,&tmp_buf,value_xpath[MEM_TOTAL],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[MEM_TOTAL]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_total unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.mem_total,value_xpath[MEM_TOTAL],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[MEM_TOTAL]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.mem_total *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_total = %d\n",hostptr->val.mem_total);
 }

 if(xtract_attribute(STRING,&tmp_buf,value_xpath[MEM_USED],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[MEM_USED]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_used unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.mem_used,value_xpath[MEM_USED],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[MEM_USED]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.mem_used *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_used = %d\n",hostptr->val.mem_used);
 }

 if(xtract_attribute(STRING,&tmp_buf,value_xpath[MEM_FREE],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[MEM_FREE]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_free unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.mem_free,value_xpath[MEM_FREE],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[MEM_FREE]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.mem_free *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_free = %d\n",hostptr->val.mem_free);
 }

 /*
  * Cruft as of the 2.6 kernel, so it won't need a unit.
  */
 if(xtract(UNSIGNED_LONG,&hostptr->val.mem_shared,value_xpath[MEM_SHARED],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[MEM_SHARED]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_shared = %d\n",hostptr->val.mem_shared);
 }

 if(xtract_attribute(STRING,&tmp_buf,value_xpath[MEM_BUFFERS],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[MEM_BUFFERS]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_buffers unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.mem_buffers,value_xpath[MEM_BUFFERS],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[MEM_BUFFERS]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.mem_buffers *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_buffers = %d\n",hostptr->val.mem_buffers);
 }
    
 if(xtract_attribute(STRING,&tmp_buf,value_xpath[MEM_CACHED],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[MEM_CACHED]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_cached unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.mem_cached,value_xpath[MEM_CACHED],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[MEM_CACHED]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.mem_cached *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_cached = %d\n",hostptr->val.mem_cached);
 }
      
 /* meminfo - swap */
 if(xtract_attribute(STRING,&tmp_buf,value_xpath[SWAP_TOTAL],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[SWAP_TOTAL]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: swap_total unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.swap_total,value_xpath[SWAP_TOTAL],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[SWAP_TOTAL]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.swap_total *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: swap_total = %d\n",hostptr->val.swap_total);
 }

 if(xtract_attribute(STRING,&tmp_buf,value_xpath[SWAP_USED],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[SWAP_USED]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: swap_used unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.swap_used,value_xpath[SWAP_USED],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[SWAP_USED]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.swap_used *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: swap_used = %d\n",hostptr->val.swap_used);
 }

 if(xtract_attribute(STRING,&tmp_buf,value_xpath[SWAP_FREE],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[SWAP_FREE]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: swap_free unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.swap_free,value_xpath[SWAP_FREE],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[SWAP_FREE]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.swap_free *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: swap_free = %d\n",hostptr->val.swap_free);
 }

}


void update_meminfo(Host *hostptr)
{

 /* 
  * scratch: current timestamp and delta (to microsecond resolution) 
  */
 unsigned long seconds,useconds;

 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: Starting init_meminfo().  Use -v %d to focus.\n",D_VALUES);
   
 }

 /* 
  * meminfo - tv_sec and tv_usec timestamps.
  */
 /* <meminfo tv_sec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&seconds,value_xpath[MEMINFO],
                      "tv_sec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[MEMINFO]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: seconds = %d\n",seconds);
 }
 hostptr->val.meminfo_tv_sec = seconds;

 /* <meminfo tv_usec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&useconds,value_xpath[MEMINFO],
                      "tv_usec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[MEMINFO]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: useconds = %d\n",useconds);
 }
 hostptr->val.meminfo_tv_usec = useconds;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: meminfo_tv_sec = %ul meminfo_tv_usec = %ul\n",hostptr->val.meminfo_tv_sec,hostptr->val.meminfo_tv_usec);
 }

 /* meminfo - memory */
 if(xtract_attribute(STRING,&tmp_buf,value_xpath[MEM_TOTAL],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[MEM_TOTAL]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_total unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.mem_total,value_xpath[MEM_TOTAL],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[MEM_TOTAL]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.mem_total *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_total = %d\n",hostptr->val.mem_total);
 }

 if(xtract_attribute(STRING,&tmp_buf,value_xpath[MEM_USED],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[MEM_USED]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_used unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.mem_used,value_xpath[MEM_USED],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[MEM_USED]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.mem_used *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_used = %d\n",hostptr->val.mem_used);
 }

 if(xtract_attribute(STRING,&tmp_buf,value_xpath[MEM_FREE],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[MEM_FREE]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_free unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.mem_free,value_xpath[MEM_FREE],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[MEM_FREE]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.mem_free *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_free = %d\n",hostptr->val.mem_free);
 }

 /*
  * Cruft as of 2.6 kernel
  */
 if(xtract(UNSIGNED_LONG,&hostptr->val.mem_shared,value_xpath[MEM_SHARED],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[MEM_SHARED]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_shared = %d\n",hostptr->val.mem_shared);
 }

 if(xtract_attribute(STRING,&tmp_buf,value_xpath[MEM_BUFFERS],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[MEM_BUFFERS]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_buffers unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.mem_buffers,value_xpath[MEM_BUFFERS],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[MEM_BUFFERS]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.mem_buffers *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_buffers = %d\n",hostptr->val.mem_buffers);
 }
    
 if(xtract_attribute(STRING,&tmp_buf,value_xpath[MEM_CACHED],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[MEM_CACHED]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_cached unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.mem_cached,value_xpath[MEM_CACHED],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[MEM_CACHED]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.mem_cached *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: mem_cached = %d\n",hostptr->val.mem_cached);
 }
      
 /* meminfo - swap */
 if(xtract_attribute(STRING,&tmp_buf,value_xpath[SWAP_TOTAL],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[SWAP_TOTAL]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: swap_total unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.swap_total,value_xpath[SWAP_TOTAL],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[SWAP_TOTAL]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.swap_total *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: swap_total = %d\n",hostptr->val.swap_total);
 }

 if(xtract_attribute(STRING,&tmp_buf,value_xpath[SWAP_USED],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[SWAP_USED]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: swap_used unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.swap_used,value_xpath[SWAP_USED],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[SWAP_USED]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.swap_used *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: swap_used = %d\n",hostptr->val.swap_used);
 }

 if(xtract_attribute(STRING,&tmp_buf,value_xpath[SWAP_FREE],
                      "unit",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[SWAP_FREE]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: swap_free unit = %s\n",tmp_buf);
 }
 if(xtract(UNSIGNED_LONG,&hostptr->val.swap_free,value_xpath[SWAP_FREE],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[SWAP_FREE]);
 }
 /* rescale to kB if necessary */
 if(strncmp(tmp_buf,"kB",2) == 0) hostptr->val.swap_free *= 1024;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: swap_free = %d\n",hostptr->val.swap_free);
 }

}
