/* -*-mode:java; c-basic-offset:2; -*- */
/* WeirdX - Guess.
 *
 * Copyright (C) 2000-2004 JCraft, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.weirdx;
import java.io.*;
import java.awt.event.KeyEvent;
import java.net.*;

final class Keymap_gb extends Keymap{
  private int[] _map={
    0xff08,    0x0, 0x0, 0x0,      //   8 BackSpace
    0xff09,    0x0, 0x0, 0x0,      //   9 Tab
    0xff8d,    0x0, 0x0, 0x0,      //  10 KP_Enter
    0xffe4,    0x0, 0x0, 0x0,      //  11 Control_R
    0xff0b,    0x0, 0x0, 0x0,      //  12 Clear
    0xff0d,    0x0, 0x0, 0x0,      //  13 Return
    0xff7e,    0x0, 0x0, 0x0,      //  14 Mode_switch
    0xff55,    0x0, 0x0, 0x0,      //  15 Prior
    0xffe1,    0x0, 0x0, 0x0,      //  16 Shift_L
    0xffe3,    0x0, 0x0, 0x0,      //  17 Control_L
    0xffe9, 0xffe7, 0x0, 0x0,      //  18 Alt_L Meta_L
    0xff13,    0x0, 0x0, 0x0,      //  19 Pause
    0xffe5,    0x0, 0x0, 0x0,      //  20 Caps_Lock
       0x0,    0x0, 0x0, 0x0,      //  21
       0x0,    0x0, 0x0, 0x0,      //  22
       0x0,    0x0, 0x0, 0x0,      //  23
       0x0,    0x0, 0x0, 0x0,      //  24
       0x0,    0x0, 0x0, 0x0,      //  25
    0xff56,    0x0, 0x0, 0x0,      //  26 Next
    0xff1b,    0x0, 0x0, 0x0,      //  27 Escape
       0x0,    0x0, 0x0, 0x0,      //  28
       0x0,    0x0, 0x0, 0x0,      //  29
       0x0,    0x0, 0x0, 0x0,      //  30
       0x0,    0x0, 0x0, 0x0,      //  31
      0x20,    0x0, 0x0, 0x0,      //  32 Space
    0xff55,    0x0, 0x0, 0x0,      //  33 Prior
    0xff56,    0x0, 0x0, 0x0,      //  34 Next
    0xff57,    0x0, 0x0, 0x0,      //  35 End
    0xff50,    0x0, 0x0, 0x0,      //  36 Home
    0xff51,    0x0, 0x0, 0x0,      //  37 Left
    0xff52,    0x0, 0x0, 0x0,      //  38 Up
    0xff53,    0x0, 0x0, 0x0,      //  39 Right
    0xff54,    0x0, 0x0, 0x0,      //  40 Down
    0xff60,    0x0, 0x0, 0x0,      //  41 Select
       0x0,    0x0, 0x0, 0x0,      //  42
    0xff62,    0x0, 0x0, 0x0,      //  43 Execute
    0xff61,    0x0, 0x0, 0x0,      //  44 Print
    0xff63,    0x0, 0x0, 0x0,      //  45 Intset
    0xffff,    0x0, 0x0, 0x0,      //  46 Delete
    0xff6a,    0x0, 0x0, 0x0,      //  47 Help
      0x30,   0x29, 0x0, 0x0,      //  48 0 parenright
      0x31,   0x21, 0x0, 0x0,      //  49 1 excalm
      0x32,   0x22, 0x0, 0x0,      //  50 2 quotedbl
      0x33,   0xa3, 0x0, 0x0,      //  51 3 sterling
      0x34,   0x24, 0x0, 0x0,      //  52 4 dollar
      0x35,   0x25, 0x0, 0x0,      //  53 5 percent
      0x36,   0x5e, 0x0, 0x0,      //  54 6 asciicircum
      0x37,   0x26, 0x0, 0x0,      //  55 7 ampersand
      0x38,   0x2a, 0x0, 0x0,      //  56 5 asterisk
      0x39,   0x28, 0x0, 0x0,      //  57 5 parenleft
    0xff57,    0x0, 0x0, 0x0,      //  58 End
    0xff50,    0x0, 0x0, 0x0,      //  59 Home
    0xff51,    0x0, 0x0, 0x0,      //  60 Keft
    0xff52,    0x0, 0x0, 0x0,      //  61 Up
    0xff53,    0x0, 0x0, 0x0,      //  62 Right
    0xff54,    0x0, 0x0, 0x0,      //  63 Down
    0xff63,    0x0, 0x0, 0x0,      //  64 Insert
      0x41,    0x0, 0xc1, 0x0,     // 65 A NoSymbol Aacute
      0x42,    0x0, 0x0, 0x0,      // 66 B
      0x43,    0x0, 0x0, 0x0,      // 67 C
      0x44,    0x0, 0x0, 0x0,      // 68 D
      0x45,    0x0, 0xc9, 0x0,     // 69 E NoSymbol Eacute
      0x46,    0x0, 0x0, 0x0,      // 70 F
      0x47,    0x0, 0x0, 0x0,      // 71 G
      0x48,    0x0, 0x0, 0x0,      // 72 H
      0x49,    0x0, 0xcd, 0x0,     // 73 I NoSymbol Iacute
      0x4a,    0x0, 0x0, 0x0,      // 74 J
      0x4b,    0x0, 0x0, 0x0,      // 75 K
      0x4c,    0x0, 0x0, 0x0,      // 76 L
      0x4d,    0x0, 0x0, 0x0,      // 77 M
      0x4e,    0x0, 0x0, 0x0,      // 78 N
      0x4f,    0x0, 0xd3, 0x0,     // 79 O NoSymbol Oacute
      0x50,    0x0, 0x0, 0x0,      // 80 P
      0x51,    0x0, 0x0, 0x0,      // 81 Q
      0x52,    0x0, 0x0, 0x0,      // 82 R
      0x53,    0x0, 0x0, 0x0,      // 83 S
      0x54,    0x0, 0x0, 0x0,      // 84 T
      0x55,    0x0, 0xda, 0x0,     // 85 U NoSymbol Uacute
      0x56,    0x0, 0x0, 0x0,      // 86 V 
      0x57,    0x0, 0x0, 0x0,      // 87 W
      0x58,    0x0, 0x0, 0x0,      // 88 X
      0x59,    0x0, 0x0, 0x0,      // 89 Y
      0x5a,    0x0, 0x0, 0x0,      // 90 Z
    0xffff,    0x0, 0x0, 0x0,      // 91 Delete
    0xffac,    0x0, 0x0, 0x0,      // 92 KP_Separator
    0xffaf,    0x0, 0x0, 0x0,      // 93 KP_Divide
    0xffca,    0x0, 0x0, 0x0,      // 94 F13
    0xffcb,    0x0, 0x0, 0x0,      // 95 F14
    0xffb0,    0x0, 0x0, 0x0,      // 96 KP_0
    0xffb1,    0x0, 0x0, 0x0,      // 97 KP_1
    0xffb2,    0x0, 0x0, 0x0,      // 98 KP_2
    0xffb3,    0x0, 0x0, 0x0,      // 99 KP_3
    0xffb4,    0x0, 0x0, 0x0,      //100 KP_4
    0xffb5,    0x0, 0x0, 0x0,      //101 KP_5
    0xffb6,    0x0, 0x0, 0x0,      //102 KP_6
    0xffb7,    0x0, 0x0, 0x0,      //103 KP_7
    0xffb8,    0x0, 0x0, 0x0,      //104 KP_8
    0xffb9,    0x0, 0x0, 0x0,      //105 KP_9
    0xffaa,    0x0, 0x0, 0x0,      //106 KP_Multiply
    0xffab,    0x0, 0x0, 0x0,      //107 KP_Add
    0xffac,    0x0, 0x0, 0x0,      //108 KP_Separator
    0xffad,    0x0, 0x0, 0x0,      //109 KP_Subtract
    0xffae,    0x0, 0x0, 0x0,      //110 KP_Decimal
//    0x002f,    0x0, 0x0, 0x0,      //111 slash
    0x0000,    0x0, 0x0, 0x0,      //111 slash
    0xffbe,    0x0, 0x0, 0x0,      //112 F1
    0xffbf,    0x0, 0x0, 0x0,      //113 F2
    0xffc0,    0x0, 0x0, 0x0,      //114 F3
    0xffc1,    0x0, 0x0, 0x0,      //115 F4
    0xffc2,    0x0, 0x0, 0x0,      //116 F5
    0xffc3,    0x0, 0x0, 0x0,      //117 F6
    0xffc4,    0x0, 0x0, 0x0,      //118 F7
    0xffc5,    0x0, 0x0, 0x0,      //119 F8
    0xffc6,    0x0, 0x0, 0x0,      //120 F9
    0xffc7,    0x0, 0x0, 0x0,      //121 F10
    0xffc8,    0x0, 0x0, 0x0,      //122 F11
    0xffc9,    0x0, 0x0, 0x0,      //123 F12
    0xffca,    0x0, 0x0, 0x0,      //124 F13
    0xffcb,    0x0, 0x0, 0x0,      //125 F14
    0xffcc,    0x0, 0x0, 0x0,      //126 F15
    0xffcd,    0x0, 0x0, 0x0,      //127 F16
    0xffce,    0x0, 0x0, 0x0,      //128 F17
    0xffcf,    0x0, 0x0, 0x0,      //129 F18
    0xffd0,    0x0, 0x0, 0x0,      //130 F19
    0xffd1,    0x0, 0x0, 0x0,      //131 F20
    0xffd2,    0x0, 0x0, 0x0,      //132 F21
    0xffd3,    0x0, 0x0, 0x0,      //133 F22
    0xffd4,    0x0, 0x0, 0x0,      //134 F23
    0xffd5,    0x0, 0x0, 0x0,      //135 F24
    0xffcc,    0x0, 0x0, 0x0,      //136 F15
    0xffcd,    0x0, 0x0, 0x0,      //137 F16
    0xffce,    0x0, 0x0, 0x0,      //138 F17
    0xffcf,    0x0, 0x0, 0x0,      //139 F18
    0xffd0,    0x0, 0x0, 0x0,      //140 F19
    0xffd1,    0x0, 0x0, 0x0,      //141 F20
    0xffd2,    0x0, 0x0, 0x0,      //142 F21
    0xffd3,    0x0, 0x0, 0x0,      //143 F22
    0xffd4,    0x0, 0x0, 0x0,      //144 F23
    0xff14,    0x0, 0x0, 0x0,      //145 Scroll_Lock
       0x0,    0x0, 0xc8, 0x0,     //146 NoSymbol NoSymbol Egrave
    0xffd5,    0x0, 0x0, 0x0,      //147 F24
    0xff7f,    0x0, 0x0, 0x0,      //148 Num_Lock
    0x0afd,    0x0, 0xca, 0x0,     //149 singlelowquotemark NoSymbox Ecircumflex
    0xff6b,    0x0, 0x0, 0x0,      //150 Break
    0xffe2,    0x0, 0x0, 0x0,      //151 Shift_R
    0xffeb, 0xffed, 0x0, 0x0,      //152 Super_L Hyper_L
    0xffec, 0xffee, 0x0, 0x0,      //153 Super_R Hyper_R
    0xff67,    0x0, 0x0, 0x0,      //154 Menu
    0x08f6,    0x0, 0xcb, 0x0,     //155 function NoSymbol Ediaeresis
    0x0afe,    0x0, 0xcc, 0x0,     //156 doublelowquotemark NoSymbol Igrave
    0x0aae,    0x0, 0xce, 0x0,     //157 Ellipsis NoSymbol Icircum
    0x0af1,    0x0, 0xcf, 0x0,     //158 dagger NoSymbol Idiaeresis
    0x0af2,    0x0, 0xd0, 0x0,     //159 doubledagger NoSymbol ETH
    0x0afc,    0x0, 0xd1, 0x0,     //160 caret NoSymbol Ntilde
    0x01a9,    0x0, 0xd2, 0x0,     //161 Scaron NoSymbol Ograve
    0x0abc,    0x0, 0xd4, 0x0,     //162 leftanglebracket NoSymbol Ocircumflex
    0x0ad0,    0x0, 0xd5, 0x0,     //163 leftsinglequotemark NoSymbol Otilde
    0x0ad1,    0x0, 0xd6, 0x0,     //164 rightsinglequotemark NoSymbol Odiaeresis
    0x0ad2,    0x0, 0xd7, 0xf7,    //165 leftdoublequotemark NoSymbol multiply division
    0x0ad3,    0x0, 0xd8, 0x0,     //166 rightdowblequotemark NoSymbol Ooblique
    0x0ae6,    0x0, 0xd9, 0x0,     //167 enfilledcircbullet NoSymbol Ugrave
    0x0aaa,    0x0, 0xdb, 0x0,     //168 endash NoSymbol Ucircumflex
    0x0aa9,    0x0, 0xdc, 0x0,     //169 emdash NoSymbol Udiaeresis
    0x0ac9,    0x0, 0xdd, 0x0,     //170 trademark NoSymbol Yacute
    0x01b9,    0x0, 0xde, 0x0,     //171 scaron NoSymbol THORN
    0x0abe,    0x0, 0xdf, 0xff,    //172 rightanglebracket NoSymbol ssharp ydiaeresis
      0xa0,    0x0,  0x0, 0x0,     //173 nobreakspace
      0xa1,    0x0,  0x0, 0x0,     //174 exclamdown
      0xa2,    0x0,  0x0, 0x0,     //175 cent
       0x0,    0x0,  0x0, 0x0,     //176
       0x0,    0x0,  0x0, 0x0,     //177
      0xa4,    0x0,  0x0, 0x0,     //178 currency
       0x0,    0x0,  0x0, 0x0,     //179
      0xa5,    0x0,  0x0, 0x0,     //180 yen
       0x0,    0x0,  0x0, 0x0,     //181
      0xa7,    0x0,  0x0, 0x0,     //182 section
      0xa8,    0x0,  0x0, 0x0,     //183 diaeresis
      0xa9,    0x0,  0x0, 0x0,     //184 copyright
      0xaa,    0x0,  0x0, 0x0,     //185 ordfeminine
      0x3b,    0x3a,  0x0, 0x0,    //186 semicolon colon
      0x3d,    0x2b,  0x0, 0x0,    //187 equal plus
      0x2c,    0x3c,  0x0, 0x0,    //188 comma less
      0x2d,    0x5f,  0x0, 0x0,    //189 minus underscore
      0x2e,    0x3e,  0x0, 0x0,    //190 period greater
      0x2f,    0x3f,  0x0, 0x0,    //191 slash question
      0x27,    0x40,  0x0, 0x0,    //192 apostrophe at
      0xab,     0x0,  0x0, 0x0,    //193 guillemotleft
       0x0,     0x0,  0x0, 0x0,    //194
       0x0,     0x0,  0x0, 0x0,    //195
      0xad,     0x0,  0x0, 0x0,    //196 hyphen
       0x0,     0x0,  0x0, 0x0,    //197
       0x0,     0x0,  0x0, 0x0,    //198
       0x0,     0x0,  0x0, 0x0,    //199
      0xae,     0x0,  0x0, 0x0,    //200 registered
      0xaf,     0x0,  0x0, 0x0,    //201 macron
       0x0,     0x0,  0x0, 0x0,    //202
       0x0,     0x0,  0x0, 0x0,    //203
       0x0,     0x0,  0x0, 0x0,    //204
       0x0,     0x0,  0x0, 0x0,    //205
       0x0,     0x0,  0x0, 0x0,    //206
      0xb0,     0x0,  0x0, 0x0,    //207 degree
      0xb1,     0x0,  0x0, 0x0,    //208 plusminus
      0xb2,     0x0,  0x0, 0x0,    //209 twosuperior
      0xb3,     0x0,  0x0, 0x0,    //210 threesuperior
      0xb4,     0x0,  0x0, 0x0,    //211 acute
      0xb5,     0x0,  0x0, 0x0,    //212 mu
      0xb6,     0x0,  0x0, 0x0,    //213 paragraph
      0xb7,     0x0,  0x0, 0x0,    //214 peridcentered
      0xb8,     0x0,  0x0, 0x0,    //215 cedilla
      0xb9,     0x0,  0x0, 0x0,    //216 onesuperior
      0xba,     0x0,  0x0, 0x0,    //217 masculine
      0xbb,     0x0,  0x0, 0x0,    //218 guillemotright
      0x5b,     0x7b,  0x0, 0x0,   //219 brackeleft braceleft
      0x5c,     0x7c,  0x0, 0x0,   //220 backslash bar
      0x5d,     0x7d,  0x0, 0x0,   //221 bracketright braceright
      0x23,     0x7e,  0x0, 0x0,   //222 numbersigh asciitilde
      0x60,     0xac,  0xa6, 0x0,  //223 grave notsigh brokenbar
       0x0,     0x0,  0x0, 0x0,    //224
       0x0,     0x0,  0x0, 0x0,    //225
       0x0,     0x0,  0x0, 0x0,    //226
       0x0,     0x0,  0x0, 0x0,    //227
       0x0,     0x0,  0x0, 0x0,    //228
       0x0,     0x0,  0x0, 0x0,    //229
       0x0,     0x0,  0x0, 0x0,    //230
      0xbc,     0x0,  0x0, 0x0,    //231 onequarter
      0xbd,     0x0,  0x0, 0x0,    //232 onehalf
       0x0,     0x0,  0x0, 0x0,    //233
       0x0,     0x0,  0x0, 0x0,    //234
       0x0,     0x0,  0x0, 0x0,    //235
       0x0,     0x0,  0x0, 0x0,    //236
       0x0,     0x0,  0x0, 0x0,    //237
       0x0,     0x0,  0x0, 0x0,    //238
       0x0,     0x0,  0x0, 0x0,    //239
       0x0,     0x0,  0x0, 0x0,    //240
       0x0,     0x0,  0x0, 0x0,    //241
       0x0,     0x0,  0x0, 0x0,    //242
       0x0,     0x0,  0x0, 0x0,    //243
       0x0,     0x0,  0x0, 0x0,    //244
       0x0,     0x0,  0x0, 0x0,    //245
       0xbe,     0x0,  0x0, 0x0,   //246 threequarters
       0xbf,     0x0,  0x0, 0x0,   //247 questiondown
       0xc0,     0x0,  0x0, 0x0,   //248 Agrave
       0xc2,     0x0,  0x0, 0x0,   //249 Acircumflex
       0xc3,     0x0,  0x0, 0x0,   //250 Atilde
       0xc4,     0x0,  0x0, 0x0,   //251 Adiaeresis
       0xc5,     0x0,  0x0, 0x0,   //252 Aring 
       0xc6,     0x0,  0x0, 0x0,   //253 AE
       0xc7,     0x0,  0x0, 0x0    //254 Ccedilla
  };

  Keymap_gb(){
    start=8;
    width=4;
    count=247; // 254-8+1
    map=_map;
  }

  final int getCode(KeyEvent e){
    if(e.isShiftDown()) state|=1;
    if(e.isControlDown()) state|=4;
    if(e.isAltDown()) state|=8;
    int key=e.getKeyCode();
    if(key!=0){
      switch(key){
      case KeyEvent.VK_A:
      case KeyEvent.VK_B:
      case KeyEvent.VK_C:
      case KeyEvent.VK_D:
      case KeyEvent.VK_E:
      case KeyEvent.VK_F:
      case KeyEvent.VK_G:
      case KeyEvent.VK_H:
      case KeyEvent.VK_I:
      case KeyEvent.VK_J:
      case KeyEvent.VK_K:
      case KeyEvent.VK_L:
      case KeyEvent.VK_M:
      case KeyEvent.VK_N:
      case KeyEvent.VK_O:
      case KeyEvent.VK_P:
      case KeyEvent.VK_Q:
      case KeyEvent.VK_R:
      case KeyEvent.VK_S:
      case KeyEvent.VK_T:
      case KeyEvent.VK_U:
      case KeyEvent.VK_V:
      case KeyEvent.VK_W:
      case KeyEvent.VK_X:
      case KeyEvent.VK_Y:
      case KeyEvent.VK_Z:
	//key=key+0x20;
	break;
      case KeyEvent.VK_0:
      case KeyEvent.VK_1:
      case KeyEvent.VK_2:
      case KeyEvent.VK_3:
      case KeyEvent.VK_4:
      case KeyEvent.VK_5:
      case KeyEvent.VK_6:
      case KeyEvent.VK_7:
      case KeyEvent.VK_8:
      case KeyEvent.VK_9:
       break;
      case KeyEvent.VK_ENTER:
	key=0xff0d; break;
      case KeyEvent.VK_BACK_SPACE:
	key=0xff08; break;
      case KeyEvent.VK_TAB:
	key=0xff09; break;
//      case KeyEvent.VK_CANCEL:
//	key=0xff69;
//	break;
//      case KeyEvent.VK_CLEAR:
//	key=0xff0b;
//	break;
      case KeyEvent.VK_COMMA:
      case KeyEvent.VK_PERIOD:
      case KeyEvent.VK_SLASH:
      case KeyEvent.VK_SEMICOLON:
      case KeyEvent.VK_EQUALS:
      case KeyEvent.VK_OPEN_BRACKET:
      case KeyEvent.VK_BACK_SLASH:
      case KeyEvent.VK_CLOSE_BRACKET:
      case KeyEvent.VK_SPACE:
	break;
      case KeyEvent.VK_BACK_QUOTE:
        if(e.getKeyChar()==0x27){key=0x27;}
        else if(e.getKeyChar()==0x40){key=0x40;}
        else
	key=0x60; break;
      case KeyEvent.VK_QUOTE:
        if(e.getKeyChar()==0x23){key=0x23;}
        else if(e.getKeyChar()==0x7e){key=0x7e;}
	else
	key=0x27; break;
      case KeyEvent.VK_SHIFT:
	key=0xffe1; break;
      case KeyEvent.VK_CONTROL:
	key=0xffe3; break;
      case KeyEvent.VK_ALT:
	key=0xffe9; break;
      case KeyEvent.VK_PAUSE:
	key=0xff13; break;
      case KeyEvent.VK_CAPS_LOCK:
	key=0xffe5; break;
      case KeyEvent.VK_ESCAPE:
	key=0xff1b; break;
      case KeyEvent.VK_PAGE_UP:
	key=0xff55; break;
      case KeyEvent.VK_PAGE_DOWN:
	key=0xff56; break;
      case KeyEvent.VK_END:
	key=0xff57; break;
      case KeyEvent.VK_HOME:
	key=0xff50; break;
      case KeyEvent.VK_LEFT:
	key=0xff51; break;
      case KeyEvent.VK_UP:
	key=0xff52; break;
      case KeyEvent.VK_RIGHT:
	key=0xff53; break;
      case KeyEvent.VK_DOWN:
	key=0xff54; break;
      case KeyEvent.VK_NUMPAD0:
	key=0xffb0; break;
      case KeyEvent.VK_NUMPAD1:
	key=0xffb1; break;
      case KeyEvent.VK_NUMPAD2:
	key=0xffb2; break;
      case KeyEvent.VK_NUMPAD3:
	key=0xffb3; break;
      case KeyEvent.VK_NUMPAD4:
	key=0xffb4; break;
      case KeyEvent.VK_NUMPAD5:
	key=0xffb5; break;
      case KeyEvent.VK_NUMPAD6:
	key=0xffb6; break;
      case KeyEvent.VK_NUMPAD7:
	key=0xffb7; break;
      case KeyEvent.VK_NUMPAD8:
	key=0xffb8; break;
      case KeyEvent.VK_NUMPAD9:
	key=0xffb9; break;
      case KeyEvent.VK_MULTIPLY:
	key=0xffaa; break;
      case KeyEvent.VK_ADD:
	key=0xffab; break;
      case KeyEvent.VK_SEPARATER:
	key=0xffac; break;
      case KeyEvent.VK_SUBTRACT:
	key=0xffad; break;
      case KeyEvent.VK_DECIMAL:
	key=0xffae; break;
      case KeyEvent.VK_DIVIDE:
	key=0xffaf; break;
      case KeyEvent.VK_F1:
	key=0xffbe; break;
      case KeyEvent.VK_F2:
	key=0xffbf; break;
      case KeyEvent.VK_F3:
	key=0xffc0; break;
      case KeyEvent.VK_F4:
	key=0xffc1; break;
      case KeyEvent.VK_F5:
	key=0xffc2; break;
      case KeyEvent.VK_F6:
	key=0xffc3; break;
      case KeyEvent.VK_F7:
	key=0xffc4; break;
      case KeyEvent.VK_F8:
	key=0xffc5; break;
      case KeyEvent.VK_F9:
	key=0xffc6; break;
      case KeyEvent.VK_F10:
	key=0xffc7; break;
      case KeyEvent.VK_F11:
	key=0xffc8; break;
      case KeyEvent.VK_F12:
	key=0xffc9; break;
      case KeyEvent.VK_DELETE:
	key=0xffff; break;
      case KeyEvent.VK_NUM_LOCK:
	key=0xff7f; break;
      case KeyEvent.VK_SCROLL_LOCK:
	key=0xff14; break;
      case KeyEvent.VK_PRINTSCREEN:
	key=0xff61; break;
      case KeyEvent.VK_INSERT:
	key=0xff63; break;
      case KeyEvent.VK_HELP:
	key=0xff6a; break;
      case KeyEvent.VK_META:
	key=0xffe7; break;
//      case KeyEvent.VK_KP_UP:
//	key=0xff97; break;
//      case KeyEvent.VK_KP_DOWN:
//	key=0xff99; break;
//      case KeyEvent.VK_KP_LEFT:
//	key=0xff96; break;
//      case KeyEvent.VK_KP_RIGHT:
//	key=0xff98; break;

/*    
      // For European keyboards 
      case KeyEvent.VK_DEAD_GRAVE:
      case KeyEvent.VK_DEAD_ACUTE:
      case KeyEvent.VK_DEAD_CIRCUMFLEX:
      case KeyEvent.VK_DEAD_TILDE:
      case KeyEvent.VK_DEAD_MACRON:
      case KeyEvent.VK_DEAD_BREVE:
      case KeyEvent.VK_DEAD_ABOVEDOT:
      case KeyEvent.VK_DEAD_DIAERESIS:
      case KeyEvent.VK_DEAD_ABOVERING:
      case KeyEvent.VK_DEAD_DOUBLEACUTE:
      case KeyEvent.VK_DEAD_CARON:
      case KeyEvent.VK_DEAD_CEDILLA:
      case KeyEvent.VK_DEAD_OGONEK:
      case KeyEvent.VK_DEAD_IOTA:
      case KeyEvent.VK_DEAD_VOICED_SOUND:
      case KeyEvent.VK_DEAD_SEMIVOICED_SOUND:

      case KeyEvent.VK_AMPERSAND:
      case KeyEvent.VK_ASTERISK:
      case KeyEvent.VK_QUOTEDBL:
      case KeyEvent.VK_LESS:

      case KeyEvent.VK_GREATER:
      case KeyEvent.VK_BRACELEFT:
      case KeyEvent.VK_BRACERIGHT:

      // for Asian Keyboards
      case KeyEvent.VK_FINAL:
      case KeyEvent.VK_CONVERT:
      case KeyEvent.VK_NONCONVERT:
      case KeyEvent.VK_ACCEPT:
      case KeyEvent.VK_MODECHANGE:
      case KeyEvent.VK_KANA:
      case KeyEvent.VK_KANJI:

      // for Sun keyboards
      case KeyEvent.VK_CUT:
      case KeyEvent.VK_COPY:
      case KeyEvent.VK_PASTE:
      case KeyEvent.VK_UNDO:
      case KeyEvent.VK_AGAIN:
      case KeyEvent.VK_FIND:
      case KeyEvent.VK_PROPS:
      case KeyEvent.VK_STOP:
*/
      default:
	key=e.getKeyChar();
      }
    }
    else{
      key=e.getKeyChar();
    }
    int s=32;
    if(km!=null){
      int i=0;
      int j=0;
      s=km.start;
      while(i<km.count*km.width){
	if(km.map[i]==key)break;
	i++;
	j++;
	if(j==km.width){
	  j=0;
	  s++;
	}
      }
    }
    return s;
  }
/*
  public static int getCode(int key){
    if(key==KeyEvent.VK_BACK_SPACE){
      key=0xff08;
    }
    else if(key==KeyEvent.VK_TAB){
      key=0xff09;
    }
    else if(key==KeyEvent.VK_ENTER){
      key=0xff0d;
    }
    else if(key==KeyEvent.VK_ESCAPE){
      key=0xff1b;
    }
    else if(key==KeyEvent.VK_DELETE){
      key=0xffff;
    }

    int s=10;
    if(km!=null){
      int i=0;
      int j=0;
      s=km.start;
      while(i<km.count*km.width){
	if(km.map[i]==key)break;
	i++;
	j++;
	if(j==km.width){
	  j=0;
	  s++;
	}
      }
    }
    return s;
  }
  public static void main(String[] arg){
    km=new Keymap_gb();
    if(km!=null){
      int i=0;
      int j=0;
      int s=km.start;
      System.out.print(s+": ");
      while(i<km.count*km.width){
	System.out.print(km.map[i]+", ");
	i++;
	j++;
	if(j==km.width){
	  j=0;
	  s++;
	  System.out.print("\n"+s+": ");
	}
      }
    }
  }
*/
}
