/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.weirdx;

import com.jcraft.weirdx.Colormap;
import com.jcraft.weirdx.Drawable;
import com.jcraft.weirdx.Pixmap16;
import com.jcraft.weirdx.Resizable;
import java.awt.image.MemoryImageSource;

class ResizablePixmap16
extends Pixmap16
implements Resizable {
    int real_width = 0;
    int real_height = 0;

    ResizablePixmap16(int n, Drawable drawable, int n2, int n3) {
        super(n, drawable, n2, n3);
        this.getData();
        this.real_width = n2;
        this.real_height = n3;
    }

    public void setColormap(Colormap colormap) {
    }

    public void setSize(int n, int n2) {
        if (n <= this.real_width && n2 <= this.real_height) {
            if (2 * n < this.real_width && 2 * n2 < this.real_height) {
                this.real_width /= 2;
                this.real_height /= 2;
                this.data = new byte[this.real_width * this.real_height * 2];
                this.idata = new int[this.real_width * this.real_height];
                this.mis = new MemoryImageSource(this.real_width, this.real_height, this.idata, 0, this.real_width);
                this.mis.setAnimated(true);
            }
        } else {
            if (this.real_width < n) {
                this.real_width = n;
            }
            if (this.real_height < n2) {
                this.real_height = n2;
            }
            this.data = new byte[this.real_width * this.real_height * 2];
            this.idata = new int[this.real_width * this.real_height];
            this.mis = new MemoryImageSource(this.real_width, this.real_height, this.idata, 0, this.real_width);
            this.mis.setAnimated(true);
        }
        this.width = n;
        this.height = n2;
    }

    public int getRealWidth() {
        return this.real_width;
    }

    public int getRealHeight() {
        return this.real_height;
    }

    int getScanWidth() {
        return this.real_width * 2;
    }
}

