// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_FCVTZS_2D_2OPIMM_TRACE_AARCH64_H_
#define VIXL_SIM_FCVTZS_2D_2OPIMM_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_fcvtzs_2D_2OPIMM[] = {
  0x00000000ffffffff, 0x0000000000000000,
  0x00000001ffffffff, 0x0000000000000000,
  0x00000003fffffffe, 0x0000000000000000,
  0x00000007fffffffc, 0x0000000000000000,
  0x0000000ffffffff8, 0x0000000000000000,
  0x0000001ffffffff0, 0x0000000000000000,
  0x0000003fffffffe0, 0x0000000000000000,
  0x0000007fffffffc0, 0x0000000000000000,
  0x000000ffffffff80, 0x0000000000000000,
  0x000001ffffffff00, 0x0000000000000000,
  0x000003fffffffe00, 0x0000000000000000,
  0x000007fffffffc00, 0x0000000000000000,
  0x00000ffffffff800, 0x0000000000000000,
  0x00001ffffffff000, 0x0000000000000000,
  0x00003fffffffe000, 0x0000000000000000,
  0x00007fffffffc000, 0x0000000000000000,
  0x0000ffffffff8000, 0x0000000000000000,
  0x0001ffffffff0000, 0x0000000000000000,
  0x0003fffffffe0000, 0x0000000000000000,
  0x0007fffffffc0000, 0x0000000000000000,
  0x000ffffffff80000, 0x0000000000000000,
  0x001ffffffff00001, 0x0000000000000000,
  0x003fffffffe00002, 0x0000000000000000,
  0x007fffffffc00004, 0x0000000000000000,
  0x00ffffffff800008, 0x0000000000000000,
  0x01ffffffff000010, 0x0000000000000000,
  0x03fffffffe000020, 0x0000000000000000,
  0x07fffffffc000040, 0x0000000000000000,
  0x0ffffffff8000080, 0x0000000000000000,
  0x1ffffffff0000100, 0x0000000000000000,
  0x3fffffffe0000200, 0x0000000000000000,
  0x7fffffffc0000400, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000000, 0x0000000000000007,
  0x0000000000000000, 0x000000000000000f,
  0x0000000000000000, 0x000000000000001f,
  0x0000000000000000, 0x000000000000003f,
  0x0000000000000000, 0x000000000000007f,
  0x0000000000000000, 0x00000000000000ff,
  0x0000000000000000, 0x00000000000001ff,
  0x0000000000000000, 0x00000000000003ff,
  0x0000000000000000, 0x00000000000007ff,
  0x0000000000000000, 0x0000000000000fff,
  0x0000000000000000, 0x0000000000001fff,
  0x0000000000000000, 0x0000000000003fff,
  0x0000000000000000, 0x0000000000007fff,
  0x0000000000000000, 0x000000000000ffff,
  0x0000000000000000, 0x000000000001ffff,
  0x0000000000000000, 0x000000000003ffff,
  0x0000000000000000, 0x000000000007ffff,
  0x0000000000000000, 0x00000000000fffff,
  0x0000000000000000, 0x00000000001fffff,
  0x0000000000000000, 0x00000000003fffff,
  0x0000000000000000, 0x00000000007fffff,
  0x0000000000000000, 0x0000000000ffffff,
  0x0000000000000000, 0x0000000001ffffff,
  0x0000000000000000, 0x0000000003ffffff,
  0x0000000000000000, 0x0000000007ffffff,
  0x0000000000000000, 0x000000000fffffff,
  0x0000000000000000, 0x000000001fffffff,
  0x0000000000000000, 0x000000003fffffff,
  0x0000000000000000, 0x000000007fffffff,
  0x0000000000000000, 0x00000000ffffffff,
  0x0000000000000000, 0x00000001ffffffff,
  0x0000000000000000, 0x00000003ffffffff,
  0x0000000000000000, 0x00000007ffffffff,
  0x0000000000000000, 0x0000000fffffffff,
  0x0000000000000000, 0x0000001fffffffff,
  0x0000000000000000, 0x0000003fffffffff,
  0x0000000000000000, 0x0000007fffffffff,
  0x0000000000000000, 0x000000ffffffffff,
  0x0000000000000000, 0x000001ffffffffff,
  0x0000000000000000, 0x000003ffffffffff,
  0x0000000000000000, 0x000007ffffffffff,
  0x0000000000000000, 0x00000fffffffffff,
  0x0000000000000000, 0x00001fffffffffff,
  0x0000000000000000, 0x00003fffffffffff,
  0x0000000000000000, 0x00007fffffffffff,
  0x0000000000000000, 0x0000ffffffffffff,
  0x0000000000000000, 0x0001ffffffffffff,
  0x0000000000000000, 0x0003ffffffffffff,
  0x0000000000000000, 0x0007ffffffffffff,
  0x0000000000000000, 0x000fffffffffffff,
  0x0000000000000000, 0x001fffffffffffff,
  0x0000000000000000, 0x003ffffffffffffe,
  0x0000000000000000, 0x007ffffffffffffc,
  0x0000000000000000, 0x00fffffffffffff8,
  0x0000000000000000, 0x01fffffffffffff0,
  0x0000000000000000, 0x03ffffffffffffe0,
  0x0000000000000000, 0x07ffffffffffffc0,
  0x0000000000000000, 0x0fffffffffffff80,
  0x0000000000000000, 0x1fffffffffffff00,
  0x0000000000000000, 0x3ffffffffffffe00,
  0x0000000000000000, 0x7ffffffffffffc00,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000001, 0x0000000000000002,
  0x0000000000000003, 0x0000000000000004,
  0x0000000000000007, 0x0000000000000008,
  0x000000000000000f, 0x0000000000000010,
  0x000000000000001f, 0x0000000000000020,
  0x000000000000003f, 0x0000000000000040,
  0x000000000000007f, 0x0000000000000080,
  0x00000000000000ff, 0x0000000000000100,
  0x00000000000001ff, 0x0000000000000200,
  0x00000000000003ff, 0x0000000000000400,
  0x00000000000007ff, 0x0000000000000800,
  0x0000000000000fff, 0x0000000000001000,
  0x0000000000001fff, 0x0000000000002000,
  0x0000000000003fff, 0x0000000000004000,
  0x0000000000007fff, 0x0000000000008000,
  0x000000000000ffff, 0x0000000000010000,
  0x000000000001ffff, 0x0000000000020000,
  0x000000000003ffff, 0x0000000000040000,
  0x000000000007ffff, 0x0000000000080000,
  0x00000000000fffff, 0x0000000000100000,
  0x00000000001fffff, 0x0000000000200000,
  0x00000000003fffff, 0x0000000000400000,
  0x00000000007fffff, 0x0000000000800000,
  0x0000000000ffffff, 0x0000000001000000,
  0x0000000001ffffff, 0x0000000002000000,
  0x0000000003ffffff, 0x0000000004000000,
  0x0000000007ffffff, 0x0000000008000000,
  0x000000000fffffff, 0x0000000010000000,
  0x000000001fffffff, 0x0000000020000000,
  0x000000003fffffff, 0x0000000040000000,
  0x000000007fffffff, 0x0000000080000000,
  0x00000000ffffffff, 0x0000000100000000,
  0x00000001ffffffff, 0x0000000200000000,
  0x00000003ffffffff, 0x0000000400000000,
  0x00000007ffffffff, 0x0000000800000000,
  0x0000000fffffffff, 0x0000001000000000,
  0x0000001fffffffff, 0x0000002000000000,
  0x0000003fffffffff, 0x0000004000000000,
  0x0000007fffffffff, 0x0000008000000000,
  0x000000ffffffffff, 0x0000010000000000,
  0x000001ffffffffff, 0x0000020000000000,
  0x000003ffffffffff, 0x0000040000000000,
  0x000007ffffffffff, 0x0000080000000000,
  0x00000fffffffffff, 0x0000100000000000,
  0x00001fffffffffff, 0x0000200000000000,
  0x00003fffffffffff, 0x0000400000000000,
  0x00007fffffffffff, 0x0000800000000000,
  0x0000ffffffffffff, 0x0001000000000000,
  0x0001ffffffffffff, 0x0002000000000000,
  0x0003ffffffffffff, 0x0004000000000000,
  0x0007ffffffffffff, 0x0008000000000000,
  0x000fffffffffffff, 0x0010000000000000,
  0x001fffffffffffff, 0x0020000000000000,
  0x003ffffffffffffe, 0x0040000000000000,
  0x007ffffffffffffc, 0x0080000000000000,
  0x00fffffffffffff8, 0x0100000000000000,
  0x01fffffffffffff0, 0x0200000000000000,
  0x03ffffffffffffe0, 0x0400000000000000,
  0x07ffffffffffffc0, 0x0800000000000000,
  0x0fffffffffffff80, 0x1000000000000000,
  0x1fffffffffffff00, 0x2000000000000000,
  0x3ffffffffffffe00, 0x4000000000000000,
  0x7ffffffffffffc00, 0x7fffffffffffffff,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000008, 0x0000000000000008,
  0x0000000000000010, 0x0000000000000010,
  0x0000000000000020, 0x0000000000000020,
  0x0000000000000040, 0x0000000000000040,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000100, 0x0000000000000100,
  0x0000000000000200, 0x0000000000000200,
  0x0000000000000400, 0x0000000000000400,
  0x0000000000000800, 0x0000000000000800,
  0x0000000000001000, 0x0000000000001000,
  0x0000000000002000, 0x0000000000002000,
  0x0000000000004000, 0x0000000000004000,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000010000, 0x0000000000010000,
  0x0000000000020000, 0x0000000000020000,
  0x0000000000040000, 0x0000000000040000,
  0x0000000000080000, 0x0000000000080000,
  0x0000000000100000, 0x0000000000100000,
  0x0000000000200000, 0x0000000000200000,
  0x0000000000400000, 0x0000000000400000,
  0x0000000000800000, 0x0000000000800000,
  0x0000000001000000, 0x0000000001000000,
  0x0000000002000000, 0x0000000002000000,
  0x0000000004000000, 0x0000000004000000,
  0x0000000008000000, 0x0000000008000000,
  0x0000000010000000, 0x0000000010000000,
  0x0000000020000000, 0x0000000020000000,
  0x0000000040000000, 0x0000000040000000,
  0x0000000080000000, 0x0000000080000000,
  0x0000000100000000, 0x0000000100000000,
  0x0000000200000000, 0x0000000200000000,
  0x0000000400000000, 0x0000000400000000,
  0x0000000800000000, 0x0000000800000000,
  0x0000001000000000, 0x0000001000000000,
  0x0000002000000000, 0x0000002000000000,
  0x0000004000000000, 0x0000004000000000,
  0x0000008000000000, 0x0000008000000000,
  0x0000010000000000, 0x0000010000000000,
  0x0000020000000000, 0x0000020000000000,
  0x0000040000000000, 0x0000040000000000,
  0x0000080000000000, 0x0000080000000000,
  0x0000100000000000, 0x0000100000000000,
  0x0000200000000000, 0x0000200000000000,
  0x0000400000000000, 0x0000400000000000,
  0x0000800000000000, 0x0000800000000000,
  0x0001000000000000, 0x0001000000000000,
  0x0002000000000000, 0x0002000000000000,
  0x0004000000000000, 0x0004000000000000,
  0x0008000000000000, 0x0008000000000000,
  0x0010000000000000, 0x0010000000000001,
  0x0020000000000000, 0x0020000000000002,
  0x0040000000000000, 0x0040000000000004,
  0x0080000000000000, 0x0080000000000008,
  0x0100000000000000, 0x0100000000000010,
  0x0200000000000000, 0x0200000000000020,
  0x0400000000000000, 0x0400000000000040,
  0x0800000000000000, 0x0800000000000080,
  0x1000000000000000, 0x1000000000000100,
  0x2000000000000000, 0x2000000000000200,
  0x4000000000000000, 0x4000000000000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000003,
  0x0000000000000004, 0x0000000000000007,
  0x0000000000000008, 0x000000000000000f,
  0x0000000000000010, 0x000000000000001f,
  0x0000000000000020, 0x000000000000003f,
  0x0000000000000040, 0x000000000000007f,
  0x0000000000000080, 0x00000000000000ff,
  0x0000000000000100, 0x00000000000001ff,
  0x0000000000000200, 0x00000000000003ff,
  0x0000000000000400, 0x00000000000007ff,
  0x0000000000000800, 0x0000000000000fff,
  0x0000000000001000, 0x0000000000001fff,
  0x0000000000002000, 0x0000000000003fff,
  0x0000000000004000, 0x0000000000007fff,
  0x0000000000008000, 0x000000000000ffff,
  0x0000000000010000, 0x000000000001ffff,
  0x0000000000020000, 0x000000000003ffff,
  0x0000000000040000, 0x000000000007ffff,
  0x0000000000080000, 0x00000000000fffff,
  0x0000000000100000, 0x00000000001fffff,
  0x0000000000200000, 0x00000000003fffff,
  0x0000000000400000, 0x00000000007fffff,
  0x0000000000800000, 0x0000000000ffffff,
  0x0000000001000000, 0x0000000001ffffff,
  0x0000000002000000, 0x0000000003ffffff,
  0x0000000004000000, 0x0000000007ffffff,
  0x0000000008000000, 0x000000000fffffff,
  0x0000000010000000, 0x000000001fffffff,
  0x0000000020000000, 0x000000003fffffff,
  0x0000000040000000, 0x000000007fffffff,
  0x0000000080000000, 0x00000000ffffffff,
  0x0000000100000000, 0x00000001ffffffff,
  0x0000000200000000, 0x00000003ffffffff,
  0x0000000400000000, 0x00000007ffffffff,
  0x0000000800000000, 0x0000000fffffffff,
  0x0000001000000000, 0x0000001fffffffff,
  0x0000002000000000, 0x0000003fffffffff,
  0x0000004000000000, 0x0000007fffffffff,
  0x0000008000000000, 0x000000ffffffffff,
  0x0000010000000000, 0x000001ffffffffff,
  0x0000020000000000, 0x000003ffffffffff,
  0x0000040000000000, 0x000007ffffffffff,
  0x0000080000000000, 0x00000fffffffffff,
  0x0000100000000000, 0x00001fffffffffff,
  0x0000200000000000, 0x00003fffffffffff,
  0x0000400000000000, 0x00007fffffffffff,
  0x0000800000000000, 0x0000ffffffffffff,
  0x0001000000000000, 0x0001ffffffffffff,
  0x0002000000000000, 0x0003ffffffffffff,
  0x0004000000000000, 0x0007ffffffffffff,
  0x0008000000000000, 0x000fffffffffffff,
  0x0010000000000001, 0x001fffffffffffff,
  0x0020000000000002, 0x003ffffffffffffe,
  0x0040000000000004, 0x007ffffffffffffc,
  0x0080000000000008, 0x00fffffffffffff8,
  0x0100000000000010, 0x01fffffffffffff0,
  0x0200000000000020, 0x03ffffffffffffe0,
  0x0400000000000040, 0x07ffffffffffffc0,
  0x0800000000000080, 0x0fffffffffffff80,
  0x1000000000000100, 0x1fffffffffffff00,
  0x2000000000000200, 0x3ffffffffffffe00,
  0x4000000000000400, 0x7ffffffffffffc00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000001, 0x0000000000000002,
  0x0000000000000003, 0x0000000000000004,
  0x0000000000000007, 0x0000000000000008,
  0x000000000000000f, 0x0000000000000010,
  0x000000000000001f, 0x0000000000000020,
  0x000000000000003f, 0x0000000000000040,
  0x000000000000007f, 0x0000000000000080,
  0x00000000000000ff, 0x0000000000000100,
  0x00000000000001ff, 0x0000000000000200,
  0x00000000000003ff, 0x0000000000000400,
  0x00000000000007ff, 0x0000000000000800,
  0x0000000000000fff, 0x0000000000001000,
  0x0000000000001fff, 0x0000000000002000,
  0x0000000000003fff, 0x0000000000004000,
  0x0000000000007fff, 0x0000000000008000,
  0x000000000000ffff, 0x0000000000010000,
  0x000000000001ffff, 0x0000000000020000,
  0x000000000003ffff, 0x0000000000040000,
  0x000000000007ffff, 0x0000000000080000,
  0x00000000000fffff, 0x0000000000100000,
  0x00000000001fffff, 0x0000000000200000,
  0x00000000003fffff, 0x0000000000400000,
  0x00000000007fffff, 0x0000000000800000,
  0x0000000000ffffff, 0x0000000001000000,
  0x0000000001ffffff, 0x0000000002000000,
  0x0000000003ffffff, 0x0000000004000000,
  0x0000000007ffffff, 0x0000000008000000,
  0x000000000fffffff, 0x0000000010000000,
  0x000000001fffffff, 0x0000000020000000,
  0x000000003fffffff, 0x0000000040000000,
  0x000000007fffffff, 0x0000000080000000,
  0x00000000ffffffff, 0x0000000100000000,
  0x00000001ffffffff, 0x0000000200000000,
  0x00000003ffffffff, 0x0000000400000000,
  0x00000007ffffffff, 0x0000000800000000,
  0x0000000fffffffff, 0x0000001000000000,
  0x0000001fffffffff, 0x0000002000000000,
  0x0000003fffffffff, 0x0000004000000000,
  0x0000007fffffffff, 0x0000008000000000,
  0x000000ffffffffff, 0x0000010000000000,
  0x000001ffffffffff, 0x0000020000000000,
  0x000003ffffffffff, 0x0000040000000000,
  0x000007ffffffffff, 0x0000080000000000,
  0x00000fffffffffff, 0x0000100000000000,
  0x00001fffffffffff, 0x0000200000000000,
  0x00003fffffffffff, 0x0000400000000000,
  0x00007fffffffffff, 0x0000800000000000,
  0x0000ffffffffffff, 0x0001000000000000,
  0x0001ffffffffffff, 0x0002000000000000,
  0x0003ffffffffffff, 0x0004000000000000,
  0x0007ffffffffffff, 0x0008000000000000,
  0x000fffffffffffff, 0x0010000000000000,
  0x001fffffffffffff, 0x0020000000000000,
  0x003ffffffffffffe, 0x0040000000000000,
  0x007ffffffffffffc, 0x0080000000000000,
  0x00fffffffffffff8, 0x0100000000000000,
  0x01fffffffffffff0, 0x0200000000000000,
  0x03ffffffffffffe0, 0x0400000000000000,
  0x07ffffffffffffc0, 0x0800000000000000,
  0x0fffffffffffff80, 0x1000000000000000,
  0x1fffffffffffff00, 0x2000000000000000,
  0x3ffffffffffffe00, 0x4000000000000000,
  0x7ffffffffffffc00, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000008, 0x0000000000000008,
  0x0000000000000010, 0x0000000000000010,
  0x0000000000000020, 0x0000000000000020,
  0x0000000000000040, 0x0000000000000040,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000100, 0x0000000000000100,
  0x0000000000000200, 0x0000000000000200,
  0x0000000000000400, 0x0000000000000400,
  0x0000000000000800, 0x0000000000000800,
  0x0000000000001000, 0x0000000000001000,
  0x0000000000002000, 0x0000000000002000,
  0x0000000000004000, 0x0000000000004000,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000010000, 0x0000000000010000,
  0x0000000000020000, 0x0000000000020000,
  0x0000000000040000, 0x0000000000040000,
  0x0000000000080000, 0x0000000000080000,
  0x0000000000100000, 0x0000000000100000,
  0x0000000000200000, 0x0000000000200000,
  0x0000000000400000, 0x0000000000400000,
  0x0000000000800000, 0x0000000000800000,
  0x0000000001000000, 0x0000000001000000,
  0x0000000002000000, 0x0000000002000000,
  0x0000000004000000, 0x0000000004000000,
  0x0000000008000000, 0x0000000008000000,
  0x0000000010000000, 0x0000000010000000,
  0x0000000020000000, 0x0000000020000000,
  0x0000000040000000, 0x0000000040000000,
  0x0000000080000000, 0x0000000080000000,
  0x0000000100000000, 0x0000000100000000,
  0x0000000200000000, 0x0000000200000000,
  0x0000000400000000, 0x0000000400000000,
  0x0000000800000000, 0x0000000800000000,
  0x0000001000000000, 0x0000001000000000,
  0x0000002000000000, 0x0000002000000000,
  0x0000004000000000, 0x0000004000000000,
  0x0000008000000000, 0x0000008000000000,
  0x0000010000000000, 0x0000010000000000,
  0x0000020000000000, 0x0000020000000000,
  0x0000040000000000, 0x0000040000000000,
  0x0000080000000000, 0x0000080000000000,
  0x0000100000000000, 0x0000100000000000,
  0x0000200000000000, 0x0000200000000000,
  0x0000400000000000, 0x0000400000000000,
  0x0000800000000000, 0x0000800000000000,
  0x0001000000000000, 0x0001000000000000,
  0x0002000000000000, 0x0002000000000000,
  0x0004000000000000, 0x0004000000000000,
  0x0008000000000000, 0x0008000000000000,
  0x0010000000000000, 0x0010000000000001,
  0x0020000000000000, 0x0020000000000002,
  0x0040000000000000, 0x0040000000000004,
  0x0080000000000000, 0x0080000000000008,
  0x0100000000000000, 0x0100000000000010,
  0x0200000000000000, 0x0200000000000020,
  0x0400000000000000, 0x0400000000000040,
  0x0800000000000000, 0x0800000000000080,
  0x1000000000000000, 0x1000000000000100,
  0x2000000000000000, 0x2000000000000200,
  0x4000000000000000, 0x4000000000000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000003,
  0x0000000000000004, 0x0000000000000006,
  0x0000000000000008, 0x000000000000000c,
  0x0000000000000010, 0x0000000000000018,
  0x0000000000000020, 0x0000000000000030,
  0x0000000000000040, 0x0000000000000060,
  0x0000000000000080, 0x00000000000000c0,
  0x0000000000000100, 0x0000000000000180,
  0x0000000000000200, 0x0000000000000300,
  0x0000000000000400, 0x0000000000000600,
  0x0000000000000800, 0x0000000000000c00,
  0x0000000000001000, 0x0000000000001800,
  0x0000000000002000, 0x0000000000003000,
  0x0000000000004000, 0x0000000000006000,
  0x0000000000008000, 0x000000000000c000,
  0x0000000000010000, 0x0000000000018000,
  0x0000000000020000, 0x0000000000030000,
  0x0000000000040000, 0x0000000000060000,
  0x0000000000080000, 0x00000000000c0000,
  0x0000000000100000, 0x0000000000180000,
  0x0000000000200000, 0x0000000000300000,
  0x0000000000400000, 0x0000000000600000,
  0x0000000000800000, 0x0000000000c00000,
  0x0000000001000000, 0x0000000001800000,
  0x0000000002000000, 0x0000000003000000,
  0x0000000004000000, 0x0000000006000000,
  0x0000000008000000, 0x000000000c000000,
  0x0000000010000000, 0x0000000018000000,
  0x0000000020000000, 0x0000000030000000,
  0x0000000040000000, 0x0000000060000000,
  0x0000000080000000, 0x00000000c0000000,
  0x0000000100000000, 0x0000000180000000,
  0x0000000200000000, 0x0000000300000000,
  0x0000000400000000, 0x0000000600000000,
  0x0000000800000000, 0x0000000c00000000,
  0x0000001000000000, 0x0000001800000000,
  0x0000002000000000, 0x0000003000000000,
  0x0000004000000000, 0x0000006000000000,
  0x0000008000000000, 0x000000c000000000,
  0x0000010000000000, 0x0000018000000000,
  0x0000020000000000, 0x0000030000000000,
  0x0000040000000000, 0x0000060000000000,
  0x0000080000000000, 0x00000c0000000000,
  0x0000100000000000, 0x0000180000000000,
  0x0000200000000000, 0x0000300000000000,
  0x0000400000000000, 0x0000600000000000,
  0x0000800000000000, 0x0000c00000000000,
  0x0001000000000000, 0x0001800000000000,
  0x0002000000000000, 0x0003000000000000,
  0x0004000000000000, 0x0006000000000000,
  0x0008000000000000, 0x000c000000000000,
  0x0010000000000001, 0x0018000000000000,
  0x0020000000000002, 0x0030000000000000,
  0x0040000000000004, 0x0060000000000000,
  0x0080000000000008, 0x00c0000000000000,
  0x0100000000000010, 0x0180000000000000,
  0x0200000000000020, 0x0300000000000000,
  0x0400000000000040, 0x0600000000000000,
  0x0800000000000080, 0x0c00000000000000,
  0x1000000000000100, 0x1800000000000000,
  0x2000000000000200, 0x3000000000000000,
  0x4000000000000400, 0x6000000000000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000001, 0x000000000000000a,
  0x0000000000000003, 0x0000000000000014,
  0x0000000000000006, 0x0000000000000028,
  0x000000000000000c, 0x0000000000000050,
  0x0000000000000018, 0x00000000000000a0,
  0x0000000000000030, 0x0000000000000140,
  0x0000000000000060, 0x0000000000000280,
  0x00000000000000c0, 0x0000000000000500,
  0x0000000000000180, 0x0000000000000a00,
  0x0000000000000300, 0x0000000000001400,
  0x0000000000000600, 0x0000000000002800,
  0x0000000000000c00, 0x0000000000005000,
  0x0000000000001800, 0x000000000000a000,
  0x0000000000003000, 0x0000000000014000,
  0x0000000000006000, 0x0000000000028000,
  0x000000000000c000, 0x0000000000050000,
  0x0000000000018000, 0x00000000000a0000,
  0x0000000000030000, 0x0000000000140000,
  0x0000000000060000, 0x0000000000280000,
  0x00000000000c0000, 0x0000000000500000,
  0x0000000000180000, 0x0000000000a00000,
  0x0000000000300000, 0x0000000001400000,
  0x0000000000600000, 0x0000000002800000,
  0x0000000000c00000, 0x0000000005000000,
  0x0000000001800000, 0x000000000a000000,
  0x0000000003000000, 0x0000000014000000,
  0x0000000006000000, 0x0000000028000000,
  0x000000000c000000, 0x0000000050000000,
  0x0000000018000000, 0x00000000a0000000,
  0x0000000030000000, 0x0000000140000000,
  0x0000000060000000, 0x0000000280000000,
  0x00000000c0000000, 0x0000000500000000,
  0x0000000180000000, 0x0000000a00000000,
  0x0000000300000000, 0x0000001400000000,
  0x0000000600000000, 0x0000002800000000,
  0x0000000c00000000, 0x0000005000000000,
  0x0000001800000000, 0x000000a000000000,
  0x0000003000000000, 0x0000014000000000,
  0x0000006000000000, 0x0000028000000000,
  0x000000c000000000, 0x0000050000000000,
  0x0000018000000000, 0x00000a0000000000,
  0x0000030000000000, 0x0000140000000000,
  0x0000060000000000, 0x0000280000000000,
  0x00000c0000000000, 0x0000500000000000,
  0x0000180000000000, 0x0000a00000000000,
  0x0000300000000000, 0x0001400000000000,
  0x0000600000000000, 0x0002800000000000,
  0x0000c00000000000, 0x0005000000000000,
  0x0001800000000000, 0x000a000000000000,
  0x0003000000000000, 0x0014000000000000,
  0x0006000000000000, 0x0028000000000000,
  0x000c000000000000, 0x0050000000000000,
  0x0018000000000000, 0x00a0000000000000,
  0x0030000000000000, 0x0140000000000000,
  0x0060000000000000, 0x0280000000000000,
  0x00c0000000000000, 0x0500000000000000,
  0x0180000000000000, 0x0a00000000000000,
  0x0300000000000000, 0x1400000000000000,
  0x0600000000000000, 0x2800000000000000,
  0x0c00000000000000, 0x5000000000000000,
  0x1800000000000000, 0x7fffffffffffffff,
  0x3000000000000000, 0x7fffffffffffffff,
  0x6000000000000000, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000000000000000a, 0x7fffffffffffffff,
  0x0000000000000014, 0x7fffffffffffffff,
  0x0000000000000028, 0x7fffffffffffffff,
  0x0000000000000050, 0x7fffffffffffffff,
  0x00000000000000a0, 0x7fffffffffffffff,
  0x0000000000000140, 0x7fffffffffffffff,
  0x0000000000000280, 0x7fffffffffffffff,
  0x0000000000000500, 0x7fffffffffffffff,
  0x0000000000000a00, 0x7fffffffffffffff,
  0x0000000000001400, 0x7fffffffffffffff,
  0x0000000000002800, 0x7fffffffffffffff,
  0x0000000000005000, 0x7fffffffffffffff,
  0x000000000000a000, 0x7fffffffffffffff,
  0x0000000000014000, 0x7fffffffffffffff,
  0x0000000000028000, 0x7fffffffffffffff,
  0x0000000000050000, 0x7fffffffffffffff,
  0x00000000000a0000, 0x7fffffffffffffff,
  0x0000000000140000, 0x7fffffffffffffff,
  0x0000000000280000, 0x7fffffffffffffff,
  0x0000000000500000, 0x7fffffffffffffff,
  0x0000000000a00000, 0x7fffffffffffffff,
  0x0000000001400000, 0x7fffffffffffffff,
  0x0000000002800000, 0x7fffffffffffffff,
  0x0000000005000000, 0x7fffffffffffffff,
  0x000000000a000000, 0x7fffffffffffffff,
  0x0000000014000000, 0x7fffffffffffffff,
  0x0000000028000000, 0x7fffffffffffffff,
  0x0000000050000000, 0x7fffffffffffffff,
  0x00000000a0000000, 0x7fffffffffffffff,
  0x0000000140000000, 0x7fffffffffffffff,
  0x0000000280000000, 0x7fffffffffffffff,
  0x0000000500000000, 0x7fffffffffffffff,
  0x0000000a00000000, 0x7fffffffffffffff,
  0x0000001400000000, 0x7fffffffffffffff,
  0x0000002800000000, 0x7fffffffffffffff,
  0x0000005000000000, 0x7fffffffffffffff,
  0x000000a000000000, 0x7fffffffffffffff,
  0x0000014000000000, 0x7fffffffffffffff,
  0x0000028000000000, 0x7fffffffffffffff,
  0x0000050000000000, 0x7fffffffffffffff,
  0x00000a0000000000, 0x7fffffffffffffff,
  0x0000140000000000, 0x7fffffffffffffff,
  0x0000280000000000, 0x7fffffffffffffff,
  0x0000500000000000, 0x7fffffffffffffff,
  0x0000a00000000000, 0x7fffffffffffffff,
  0x0001400000000000, 0x7fffffffffffffff,
  0x0002800000000000, 0x7fffffffffffffff,
  0x0005000000000000, 0x7fffffffffffffff,
  0x000a000000000000, 0x7fffffffffffffff,
  0x0014000000000000, 0x7fffffffffffffff,
  0x0028000000000000, 0x7fffffffffffffff,
  0x0050000000000000, 0x7fffffffffffffff,
  0x00a0000000000000, 0x7fffffffffffffff,
  0x0140000000000000, 0x7fffffffffffffff,
  0x0280000000000000, 0x7fffffffffffffff,
  0x0500000000000000, 0x7fffffffffffffff,
  0x0a00000000000000, 0x7fffffffffffffff,
  0x1400000000000000, 0x7fffffffffffffff,
  0x2800000000000000, 0x7fffffffffffffff,
  0x5000000000000000, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0xfffffffffffffffd,
  0x0000000000000000, 0xfffffffffffffff9,
  0x0000000000000000, 0xfffffffffffffff1,
  0x0000000000000000, 0xffffffffffffffe1,
  0x0000000000000000, 0xffffffffffffffc1,
  0x0000000000000000, 0xffffffffffffff81,
  0x0000000000000000, 0xffffffffffffff01,
  0x0000000000000000, 0xfffffffffffffe01,
  0x0000000000000000, 0xfffffffffffffc01,
  0x0000000000000000, 0xfffffffffffff801,
  0x0000000000000000, 0xfffffffffffff001,
  0x0000000000000000, 0xffffffffffffe001,
  0x0000000000000000, 0xffffffffffffc001,
  0x0000000000000000, 0xffffffffffff8001,
  0x0000000000000000, 0xffffffffffff0001,
  0x0000000000000000, 0xfffffffffffe0001,
  0x0000000000000000, 0xfffffffffffc0001,
  0x0000000000000000, 0xfffffffffff80001,
  0x0000000000000000, 0xfffffffffff00001,
  0x0000000000000000, 0xffffffffffe00001,
  0x0000000000000000, 0xffffffffffc00001,
  0x0000000000000000, 0xffffffffff800001,
  0x0000000000000000, 0xffffffffff000001,
  0x0000000000000000, 0xfffffffffe000001,
  0x0000000000000000, 0xfffffffffc000001,
  0x0000000000000000, 0xfffffffff8000001,
  0x0000000000000000, 0xfffffffff0000001,
  0x0000000000000000, 0xffffffffe0000001,
  0x0000000000000000, 0xffffffffc0000001,
  0x0000000000000000, 0xffffffff80000001,
  0x0000000000000000, 0xffffffff00000001,
  0x0000000000000000, 0xfffffffe00000001,
  0x0000000000000000, 0xfffffffc00000001,
  0x0000000000000000, 0xfffffff800000001,
  0x0000000000000000, 0xfffffff000000001,
  0x0000000000000000, 0xffffffe000000001,
  0x0000000000000000, 0xffffffc000000001,
  0x0000000000000000, 0xffffff8000000001,
  0x0000000000000000, 0xffffff0000000001,
  0x0000000000000000, 0xfffffe0000000001,
  0x0000000000000000, 0xfffffc0000000001,
  0x0000000000000000, 0xfffff80000000001,
  0x0000000000000000, 0xfffff00000000001,
  0x0000000000000000, 0xffffe00000000001,
  0x0000000000000000, 0xffffc00000000001,
  0x0000000000000000, 0xffff800000000001,
  0x0000000000000000, 0xffff000000000001,
  0x0000000000000000, 0xfffe000000000001,
  0x0000000000000000, 0xfffc000000000001,
  0x0000000000000000, 0xfff8000000000001,
  0x0000000000000000, 0xfff0000000000001,
  0x0000000000000000, 0xffe0000000000001,
  0x0000000000000000, 0xffc0000000000002,
  0x0000000000000000, 0xff80000000000004,
  0x0000000000000000, 0xff00000000000008,
  0x0000000000000000, 0xfe00000000000010,
  0x0000000000000000, 0xfc00000000000020,
  0x0000000000000000, 0xf800000000000040,
  0x0000000000000000, 0xf000000000000080,
  0x0000000000000000, 0xe000000000000100,
  0x0000000000000000, 0xc000000000000200,
  0x0000000000000000, 0x8000000000000400,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xfffffffffffffffc,
  0xfffffffffffffff9, 0xfffffffffffffff8,
  0xfffffffffffffff1, 0xfffffffffffffff0,
  0xffffffffffffffe1, 0xffffffffffffffe0,
  0xffffffffffffffc1, 0xffffffffffffffc0,
  0xffffffffffffff81, 0xffffffffffffff80,
  0xffffffffffffff01, 0xffffffffffffff00,
  0xfffffffffffffe01, 0xfffffffffffffe00,
  0xfffffffffffffc01, 0xfffffffffffffc00,
  0xfffffffffffff801, 0xfffffffffffff800,
  0xfffffffffffff001, 0xfffffffffffff000,
  0xffffffffffffe001, 0xffffffffffffe000,
  0xffffffffffffc001, 0xffffffffffffc000,
  0xffffffffffff8001, 0xffffffffffff8000,
  0xffffffffffff0001, 0xffffffffffff0000,
  0xfffffffffffe0001, 0xfffffffffffe0000,
  0xfffffffffffc0001, 0xfffffffffffc0000,
  0xfffffffffff80001, 0xfffffffffff80000,
  0xfffffffffff00001, 0xfffffffffff00000,
  0xffffffffffe00001, 0xffffffffffe00000,
  0xffffffffffc00001, 0xffffffffffc00000,
  0xffffffffff800001, 0xffffffffff800000,
  0xffffffffff000001, 0xffffffffff000000,
  0xfffffffffe000001, 0xfffffffffe000000,
  0xfffffffffc000001, 0xfffffffffc000000,
  0xfffffffff8000001, 0xfffffffff8000000,
  0xfffffffff0000001, 0xfffffffff0000000,
  0xffffffffe0000001, 0xffffffffe0000000,
  0xffffffffc0000001, 0xffffffffc0000000,
  0xffffffff80000001, 0xffffffff80000000,
  0xffffffff00000001, 0xffffffff00000000,
  0xfffffffe00000001, 0xfffffffe00000000,
  0xfffffffc00000001, 0xfffffffc00000000,
  0xfffffff800000001, 0xfffffff800000000,
  0xfffffff000000001, 0xfffffff000000000,
  0xffffffe000000001, 0xffffffe000000000,
  0xffffffc000000001, 0xffffffc000000000,
  0xffffff8000000001, 0xffffff8000000000,
  0xffffff0000000001, 0xffffff0000000000,
  0xfffffe0000000001, 0xfffffe0000000000,
  0xfffffc0000000001, 0xfffffc0000000000,
  0xfffff80000000001, 0xfffff80000000000,
  0xfffff00000000001, 0xfffff00000000000,
  0xffffe00000000001, 0xffffe00000000000,
  0xffffc00000000001, 0xffffc00000000000,
  0xffff800000000001, 0xffff800000000000,
  0xffff000000000001, 0xffff000000000000,
  0xfffe000000000001, 0xfffe000000000000,
  0xfffc000000000001, 0xfffc000000000000,
  0xfff8000000000001, 0xfff8000000000000,
  0xfff0000000000001, 0xfff0000000000000,
  0xffe0000000000001, 0xffe0000000000000,
  0xffc0000000000002, 0xffc0000000000000,
  0xff80000000000004, 0xff80000000000000,
  0xff00000000000008, 0xff00000000000000,
  0xfe00000000000010, 0xfe00000000000000,
  0xfc00000000000020, 0xfc00000000000000,
  0xf800000000000040, 0xf800000000000000,
  0xf000000000000080, 0xf000000000000000,
  0xe000000000000100, 0xe000000000000000,
  0xc000000000000200, 0xc000000000000000,
  0x8000000000000400, 0x8000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc0, 0xffffffffffffffc0,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff00, 0xffffffffffffff00,
  0xfffffffffffffe00, 0xfffffffffffffe00,
  0xfffffffffffffc00, 0xfffffffffffffc00,
  0xfffffffffffff800, 0xfffffffffffff800,
  0xfffffffffffff000, 0xfffffffffffff000,
  0xffffffffffffe000, 0xffffffffffffe000,
  0xffffffffffffc000, 0xffffffffffffc000,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff0000, 0xffffffffffff0000,
  0xfffffffffffe0000, 0xfffffffffffe0000,
  0xfffffffffffc0000, 0xfffffffffffc0000,
  0xfffffffffff80000, 0xfffffffffff80000,
  0xfffffffffff00000, 0xfffffffffff00000,
  0xffffffffffe00000, 0xffffffffffe00000,
  0xffffffffffc00000, 0xffffffffffc00000,
  0xffffffffff800000, 0xffffffffff800000,
  0xffffffffff000000, 0xffffffffff000000,
  0xfffffffffe000000, 0xfffffffffe000000,
  0xfffffffffc000000, 0xfffffffffc000000,
  0xfffffffff8000000, 0xfffffffff8000000,
  0xfffffffff0000000, 0xfffffffff0000000,
  0xffffffffe0000000, 0xffffffffe0000000,
  0xffffffffc0000000, 0xffffffffc0000000,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff00000000, 0xffffffff00000000,
  0xfffffffe00000000, 0xfffffffe00000000,
  0xfffffffc00000000, 0xfffffffc00000000,
  0xfffffff800000000, 0xfffffff800000000,
  0xfffffff000000000, 0xfffffff000000000,
  0xffffffe000000000, 0xffffffe000000000,
  0xffffffc000000000, 0xffffffc000000000,
  0xffffff8000000000, 0xffffff8000000000,
  0xffffff0000000000, 0xffffff0000000000,
  0xfffffe0000000000, 0xfffffe0000000000,
  0xfffffc0000000000, 0xfffffc0000000000,
  0xfffff80000000000, 0xfffff80000000000,
  0xfffff00000000000, 0xfffff00000000000,
  0xffffe00000000000, 0xffffe00000000000,
  0xffffc00000000000, 0xffffc00000000000,
  0xffff800000000000, 0xffff800000000000,
  0xffff000000000000, 0xffff000000000000,
  0xfffe000000000000, 0xfffe000000000000,
  0xfffc000000000000, 0xfffc000000000000,
  0xfff8000000000000, 0xfff8000000000000,
  0xfff0000000000000, 0xffefffffffffffff,
  0xffe0000000000000, 0xffdffffffffffffe,
  0xffc0000000000000, 0xffbffffffffffffc,
  0xff80000000000000, 0xff7ffffffffffff8,
  0xff00000000000000, 0xfefffffffffffff0,
  0xfe00000000000000, 0xfdffffffffffffe0,
  0xfc00000000000000, 0xfbffffffffffffc0,
  0xf800000000000000, 0xf7ffffffffffff80,
  0xf000000000000000, 0xefffffffffffff00,
  0xe000000000000000, 0xdffffffffffffe00,
  0xc000000000000000, 0xbffffffffffffc00,
  0x8000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffd,
  0xfffffffffffffffc, 0xfffffffffffffff9,
  0xfffffffffffffff8, 0xfffffffffffffff1,
  0xfffffffffffffff0, 0xffffffffffffffe1,
  0xffffffffffffffe0, 0xffffffffffffffc1,
  0xffffffffffffffc0, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff01,
  0xffffffffffffff00, 0xfffffffffffffe01,
  0xfffffffffffffe00, 0xfffffffffffffc01,
  0xfffffffffffffc00, 0xfffffffffffff801,
  0xfffffffffffff800, 0xfffffffffffff001,
  0xfffffffffffff000, 0xffffffffffffe001,
  0xffffffffffffe000, 0xffffffffffffc001,
  0xffffffffffffc000, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff0001,
  0xffffffffffff0000, 0xfffffffffffe0001,
  0xfffffffffffe0000, 0xfffffffffffc0001,
  0xfffffffffffc0000, 0xfffffffffff80001,
  0xfffffffffff80000, 0xfffffffffff00001,
  0xfffffffffff00000, 0xffffffffffe00001,
  0xffffffffffe00000, 0xffffffffffc00001,
  0xffffffffffc00000, 0xffffffffff800001,
  0xffffffffff800000, 0xffffffffff000001,
  0xffffffffff000000, 0xfffffffffe000001,
  0xfffffffffe000000, 0xfffffffffc000001,
  0xfffffffffc000000, 0xfffffffff8000001,
  0xfffffffff8000000, 0xfffffffff0000001,
  0xfffffffff0000000, 0xffffffffe0000001,
  0xffffffffe0000000, 0xffffffffc0000001,
  0xffffffffc0000000, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff00000001,
  0xffffffff00000000, 0xfffffffe00000001,
  0xfffffffe00000000, 0xfffffffc00000001,
  0xfffffffc00000000, 0xfffffff800000001,
  0xfffffff800000000, 0xfffffff000000001,
  0xfffffff000000000, 0xffffffe000000001,
  0xffffffe000000000, 0xffffffc000000001,
  0xffffffc000000000, 0xffffff8000000001,
  0xffffff8000000000, 0xffffff0000000001,
  0xffffff0000000000, 0xfffffe0000000001,
  0xfffffe0000000000, 0xfffffc0000000001,
  0xfffffc0000000000, 0xfffff80000000001,
  0xfffff80000000000, 0xfffff00000000001,
  0xfffff00000000000, 0xffffe00000000001,
  0xffffe00000000000, 0xffffc00000000001,
  0xffffc00000000000, 0xffff800000000001,
  0xffff800000000000, 0xffff000000000001,
  0xffff000000000000, 0xfffe000000000001,
  0xfffe000000000000, 0xfffc000000000001,
  0xfffc000000000000, 0xfff8000000000001,
  0xfff8000000000000, 0xfff0000000000001,
  0xffefffffffffffff, 0xffe0000000000001,
  0xffdffffffffffffe, 0xffc0000000000002,
  0xffbffffffffffffc, 0xff80000000000004,
  0xff7ffffffffffff8, 0xff00000000000008,
  0xfefffffffffffff0, 0xfe00000000000010,
  0xfdffffffffffffe0, 0xfc00000000000020,
  0xfbffffffffffffc0, 0xf800000000000040,
  0xf7ffffffffffff80, 0xf000000000000080,
  0xefffffffffffff00, 0xe000000000000100,
  0xdffffffffffffe00, 0xc000000000000200,
  0xbffffffffffffc00, 0x8000000000000400,
  0x8000000000000000, 0x8000000000000000,
  0x0000000000000000, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xfffffffffffffffc,
  0xfffffffffffffff9, 0xfffffffffffffff8,
  0xfffffffffffffff1, 0xfffffffffffffff0,
  0xffffffffffffffe1, 0xffffffffffffffe0,
  0xffffffffffffffc1, 0xffffffffffffffc0,
  0xffffffffffffff81, 0xffffffffffffff80,
  0xffffffffffffff01, 0xffffffffffffff00,
  0xfffffffffffffe01, 0xfffffffffffffe00,
  0xfffffffffffffc01, 0xfffffffffffffc00,
  0xfffffffffffff801, 0xfffffffffffff800,
  0xfffffffffffff001, 0xfffffffffffff000,
  0xffffffffffffe001, 0xffffffffffffe000,
  0xffffffffffffc001, 0xffffffffffffc000,
  0xffffffffffff8001, 0xffffffffffff8000,
  0xffffffffffff0001, 0xffffffffffff0000,
  0xfffffffffffe0001, 0xfffffffffffe0000,
  0xfffffffffffc0001, 0xfffffffffffc0000,
  0xfffffffffff80001, 0xfffffffffff80000,
  0xfffffffffff00001, 0xfffffffffff00000,
  0xffffffffffe00001, 0xffffffffffe00000,
  0xffffffffffc00001, 0xffffffffffc00000,
  0xffffffffff800001, 0xffffffffff800000,
  0xffffffffff000001, 0xffffffffff000000,
  0xfffffffffe000001, 0xfffffffffe000000,
  0xfffffffffc000001, 0xfffffffffc000000,
  0xfffffffff8000001, 0xfffffffff8000000,
  0xfffffffff0000001, 0xfffffffff0000000,
  0xffffffffe0000001, 0xffffffffe0000000,
  0xffffffffc0000001, 0xffffffffc0000000,
  0xffffffff80000001, 0xffffffff80000000,
  0xffffffff00000001, 0xffffffff00000000,
  0xfffffffe00000001, 0xfffffffe00000000,
  0xfffffffc00000001, 0xfffffffc00000000,
  0xfffffff800000001, 0xfffffff800000000,
  0xfffffff000000001, 0xfffffff000000000,
  0xffffffe000000001, 0xffffffe000000000,
  0xffffffc000000001, 0xffffffc000000000,
  0xffffff8000000001, 0xffffff8000000000,
  0xffffff0000000001, 0xffffff0000000000,
  0xfffffe0000000001, 0xfffffe0000000000,
  0xfffffc0000000001, 0xfffffc0000000000,
  0xfffff80000000001, 0xfffff80000000000,
  0xfffff00000000001, 0xfffff00000000000,
  0xffffe00000000001, 0xffffe00000000000,
  0xffffc00000000001, 0xffffc00000000000,
  0xffff800000000001, 0xffff800000000000,
  0xffff000000000001, 0xffff000000000000,
  0xfffe000000000001, 0xfffe000000000000,
  0xfffc000000000001, 0xfffc000000000000,
  0xfff8000000000001, 0xfff8000000000000,
  0xfff0000000000001, 0xfff0000000000000,
  0xffe0000000000001, 0xffe0000000000000,
  0xffc0000000000002, 0xffc0000000000000,
  0xff80000000000004, 0xff80000000000000,
  0xff00000000000008, 0xff00000000000000,
  0xfe00000000000010, 0xfe00000000000000,
  0xfc00000000000020, 0xfc00000000000000,
  0xf800000000000040, 0xf800000000000000,
  0xf000000000000080, 0xf000000000000000,
  0xe000000000000100, 0xe000000000000000,
  0xc000000000000200, 0xc000000000000000,
  0x8000000000000400, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc0, 0xffffffffffffffc0,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff00, 0xffffffffffffff00,
  0xfffffffffffffe00, 0xfffffffffffffe00,
  0xfffffffffffffc00, 0xfffffffffffffc00,
  0xfffffffffffff800, 0xfffffffffffff800,
  0xfffffffffffff000, 0xfffffffffffff000,
  0xffffffffffffe000, 0xffffffffffffe000,
  0xffffffffffffc000, 0xffffffffffffc000,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff0000, 0xffffffffffff0000,
  0xfffffffffffe0000, 0xfffffffffffe0000,
  0xfffffffffffc0000, 0xfffffffffffc0000,
  0xfffffffffff80000, 0xfffffffffff80000,
  0xfffffffffff00000, 0xfffffffffff00000,
  0xffffffffffe00000, 0xffffffffffe00000,
  0xffffffffffc00000, 0xffffffffffc00000,
  0xffffffffff800000, 0xffffffffff800000,
  0xffffffffff000000, 0xffffffffff000000,
  0xfffffffffe000000, 0xfffffffffe000000,
  0xfffffffffc000000, 0xfffffffffc000000,
  0xfffffffff8000000, 0xfffffffff8000000,
  0xfffffffff0000000, 0xfffffffff0000000,
  0xffffffffe0000000, 0xffffffffe0000000,
  0xffffffffc0000000, 0xffffffffc0000000,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff00000000, 0xffffffff00000000,
  0xfffffffe00000000, 0xfffffffe00000000,
  0xfffffffc00000000, 0xfffffffc00000000,
  0xfffffff800000000, 0xfffffff800000000,
  0xfffffff000000000, 0xfffffff000000000,
  0xffffffe000000000, 0xffffffe000000000,
  0xffffffc000000000, 0xffffffc000000000,
  0xffffff8000000000, 0xffffff8000000000,
  0xffffff0000000000, 0xffffff0000000000,
  0xfffffe0000000000, 0xfffffe0000000000,
  0xfffffc0000000000, 0xfffffc0000000000,
  0xfffff80000000000, 0xfffff80000000000,
  0xfffff00000000000, 0xfffff00000000000,
  0xffffe00000000000, 0xffffe00000000000,
  0xffffc00000000000, 0xffffc00000000000,
  0xffff800000000000, 0xffff800000000000,
  0xffff000000000000, 0xffff000000000000,
  0xfffe000000000000, 0xfffe000000000000,
  0xfffc000000000000, 0xfffc000000000000,
  0xfff8000000000000, 0xfff8000000000000,
  0xfff0000000000000, 0xffefffffffffffff,
  0xffe0000000000000, 0xffdffffffffffffe,
  0xffc0000000000000, 0xffbffffffffffffc,
  0xff80000000000000, 0xff7ffffffffffff8,
  0xff00000000000000, 0xfefffffffffffff0,
  0xfe00000000000000, 0xfdffffffffffffe0,
  0xfc00000000000000, 0xfbffffffffffffc0,
  0xf800000000000000, 0xf7ffffffffffff80,
  0xf000000000000000, 0xefffffffffffff00,
  0xe000000000000000, 0xdffffffffffffe00,
  0xc000000000000000, 0xbffffffffffffc00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffd,
  0xfffffffffffffffc, 0xfffffffffffffffa,
  0xfffffffffffffff8, 0xfffffffffffffff4,
  0xfffffffffffffff0, 0xffffffffffffffe8,
  0xffffffffffffffe0, 0xffffffffffffffd0,
  0xffffffffffffffc0, 0xffffffffffffffa0,
  0xffffffffffffff80, 0xffffffffffffff40,
  0xffffffffffffff00, 0xfffffffffffffe80,
  0xfffffffffffffe00, 0xfffffffffffffd00,
  0xfffffffffffffc00, 0xfffffffffffffa00,
  0xfffffffffffff800, 0xfffffffffffff400,
  0xfffffffffffff000, 0xffffffffffffe800,
  0xffffffffffffe000, 0xffffffffffffd000,
  0xffffffffffffc000, 0xffffffffffffa000,
  0xffffffffffff8000, 0xffffffffffff4000,
  0xffffffffffff0000, 0xfffffffffffe8000,
  0xfffffffffffe0000, 0xfffffffffffd0000,
  0xfffffffffffc0000, 0xfffffffffffa0000,
  0xfffffffffff80000, 0xfffffffffff40000,
  0xfffffffffff00000, 0xffffffffffe80000,
  0xffffffffffe00000, 0xffffffffffd00000,
  0xffffffffffc00000, 0xffffffffffa00000,
  0xffffffffff800000, 0xffffffffff400000,
  0xffffffffff000000, 0xfffffffffe800000,
  0xfffffffffe000000, 0xfffffffffd000000,
  0xfffffffffc000000, 0xfffffffffa000000,
  0xfffffffff8000000, 0xfffffffff4000000,
  0xfffffffff0000000, 0xffffffffe8000000,
  0xffffffffe0000000, 0xffffffffd0000000,
  0xffffffffc0000000, 0xffffffffa0000000,
  0xffffffff80000000, 0xffffffff40000000,
  0xffffffff00000000, 0xfffffffe80000000,
  0xfffffffe00000000, 0xfffffffd00000000,
  0xfffffffc00000000, 0xfffffffa00000000,
  0xfffffff800000000, 0xfffffff400000000,
  0xfffffff000000000, 0xffffffe800000000,
  0xffffffe000000000, 0xffffffd000000000,
  0xffffffc000000000, 0xffffffa000000000,
  0xffffff8000000000, 0xffffff4000000000,
  0xffffff0000000000, 0xfffffe8000000000,
  0xfffffe0000000000, 0xfffffd0000000000,
  0xfffffc0000000000, 0xfffffa0000000000,
  0xfffff80000000000, 0xfffff40000000000,
  0xfffff00000000000, 0xffffe80000000000,
  0xffffe00000000000, 0xffffd00000000000,
  0xffffc00000000000, 0xffffa00000000000,
  0xffff800000000000, 0xffff400000000000,
  0xffff000000000000, 0xfffe800000000000,
  0xfffe000000000000, 0xfffd000000000000,
  0xfffc000000000000, 0xfffa000000000000,
  0xfff8000000000000, 0xfff4000000000000,
  0xffefffffffffffff, 0xffe8000000000000,
  0xffdffffffffffffe, 0xffd0000000000000,
  0xffbffffffffffffc, 0xffa0000000000000,
  0xff7ffffffffffff8, 0xff40000000000000,
  0xfefffffffffffff0, 0xfe80000000000000,
  0xfdffffffffffffe0, 0xfd00000000000000,
  0xfbffffffffffffc0, 0xfa00000000000000,
  0xf7ffffffffffff80, 0xf400000000000000,
  0xefffffffffffff00, 0xe800000000000000,
  0xdffffffffffffe00, 0xd000000000000000,
  0xbffffffffffffc00, 0xa000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xfffffffffffffff6,
  0xfffffffffffffffd, 0xffffffffffffffec,
  0xfffffffffffffffa, 0xffffffffffffffd8,
  0xfffffffffffffff4, 0xffffffffffffffb0,
  0xffffffffffffffe8, 0xffffffffffffff60,
  0xffffffffffffffd0, 0xfffffffffffffec0,
  0xffffffffffffffa0, 0xfffffffffffffd80,
  0xffffffffffffff40, 0xfffffffffffffb00,
  0xfffffffffffffe80, 0xfffffffffffff600,
  0xfffffffffffffd00, 0xffffffffffffec00,
  0xfffffffffffffa00, 0xffffffffffffd800,
  0xfffffffffffff400, 0xffffffffffffb000,
  0xffffffffffffe800, 0xffffffffffff6000,
  0xffffffffffffd000, 0xfffffffffffec000,
  0xffffffffffffa000, 0xfffffffffffd8000,
  0xffffffffffff4000, 0xfffffffffffb0000,
  0xfffffffffffe8000, 0xfffffffffff60000,
  0xfffffffffffd0000, 0xffffffffffec0000,
  0xfffffffffffa0000, 0xffffffffffd80000,
  0xfffffffffff40000, 0xffffffffffb00000,
  0xffffffffffe80000, 0xffffffffff600000,
  0xffffffffffd00000, 0xfffffffffec00000,
  0xffffffffffa00000, 0xfffffffffd800000,
  0xffffffffff400000, 0xfffffffffb000000,
  0xfffffffffe800000, 0xfffffffff6000000,
  0xfffffffffd000000, 0xffffffffec000000,
  0xfffffffffa000000, 0xffffffffd8000000,
  0xfffffffff4000000, 0xffffffffb0000000,
  0xffffffffe8000000, 0xffffffff60000000,
  0xffffffffd0000000, 0xfffffffec0000000,
  0xffffffffa0000000, 0xfffffffd80000000,
  0xffffffff40000000, 0xfffffffb00000000,
  0xfffffffe80000000, 0xfffffff600000000,
  0xfffffffd00000000, 0xffffffec00000000,
  0xfffffffa00000000, 0xffffffd800000000,
  0xfffffff400000000, 0xffffffb000000000,
  0xffffffe800000000, 0xffffff6000000000,
  0xffffffd000000000, 0xfffffec000000000,
  0xffffffa000000000, 0xfffffd8000000000,
  0xffffff4000000000, 0xfffffb0000000000,
  0xfffffe8000000000, 0xfffff60000000000,
  0xfffffd0000000000, 0xffffec0000000000,
  0xfffffa0000000000, 0xffffd80000000000,
  0xfffff40000000000, 0xffffb00000000000,
  0xffffe80000000000, 0xffff600000000000,
  0xffffd00000000000, 0xfffec00000000000,
  0xffffa00000000000, 0xfffd800000000000,
  0xffff400000000000, 0xfffb000000000000,
  0xfffe800000000000, 0xfff6000000000000,
  0xfffd000000000000, 0xffec000000000000,
  0xfffa000000000000, 0xffd8000000000000,
  0xfff4000000000000, 0xffb0000000000000,
  0xffe8000000000000, 0xff60000000000000,
  0xffd0000000000000, 0xfec0000000000000,
  0xffa0000000000000, 0xfd80000000000000,
  0xff40000000000000, 0xfb00000000000000,
  0xfe80000000000000, 0xf600000000000000,
  0xfd00000000000000, 0xec00000000000000,
  0xfa00000000000000, 0xd800000000000000,
  0xf400000000000000, 0xb000000000000000,
  0xe800000000000000, 0x8000000000000000,
  0xd000000000000000, 0x8000000000000000,
  0xa000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfffffffffffffff6, 0x8000000000000000,
  0xffffffffffffffec, 0x8000000000000000,
  0xffffffffffffffd8, 0x8000000000000000,
  0xffffffffffffffb0, 0x8000000000000000,
  0xffffffffffffff60, 0x8000000000000000,
  0xfffffffffffffec0, 0x8000000000000000,
  0xfffffffffffffd80, 0x8000000000000000,
  0xfffffffffffffb00, 0x8000000000000000,
  0xfffffffffffff600, 0x8000000000000000,
  0xffffffffffffec00, 0x8000000000000000,
  0xffffffffffffd800, 0x8000000000000000,
  0xffffffffffffb000, 0x8000000000000000,
  0xffffffffffff6000, 0x8000000000000000,
  0xfffffffffffec000, 0x8000000000000000,
  0xfffffffffffd8000, 0x8000000000000000,
  0xfffffffffffb0000, 0x8000000000000000,
  0xfffffffffff60000, 0x8000000000000000,
  0xffffffffffec0000, 0x8000000000000000,
  0xffffffffffd80000, 0x8000000000000000,
  0xffffffffffb00000, 0x8000000000000000,
  0xffffffffff600000, 0x8000000000000000,
  0xfffffffffec00000, 0x8000000000000000,
  0xfffffffffd800000, 0x8000000000000000,
  0xfffffffffb000000, 0x8000000000000000,
  0xfffffffff6000000, 0x8000000000000000,
  0xffffffffec000000, 0x8000000000000000,
  0xffffffffd8000000, 0x8000000000000000,
  0xffffffffb0000000, 0x8000000000000000,
  0xffffffff60000000, 0x8000000000000000,
  0xfffffffec0000000, 0x8000000000000000,
  0xfffffffd80000000, 0x8000000000000000,
  0xfffffffb00000000, 0x8000000000000000,
  0xfffffff600000000, 0x8000000000000000,
  0xffffffec00000000, 0x8000000000000000,
  0xffffffd800000000, 0x8000000000000000,
  0xffffffb000000000, 0x8000000000000000,
  0xffffff6000000000, 0x8000000000000000,
  0xfffffec000000000, 0x8000000000000000,
  0xfffffd8000000000, 0x8000000000000000,
  0xfffffb0000000000, 0x8000000000000000,
  0xfffff60000000000, 0x8000000000000000,
  0xffffec0000000000, 0x8000000000000000,
  0xffffd80000000000, 0x8000000000000000,
  0xffffb00000000000, 0x8000000000000000,
  0xffff600000000000, 0x8000000000000000,
  0xfffec00000000000, 0x8000000000000000,
  0xfffd800000000000, 0x8000000000000000,
  0xfffb000000000000, 0x8000000000000000,
  0xfff6000000000000, 0x8000000000000000,
  0xffec000000000000, 0x8000000000000000,
  0xffd8000000000000, 0x8000000000000000,
  0xffb0000000000000, 0x8000000000000000,
  0xff60000000000000, 0x8000000000000000,
  0xfec0000000000000, 0x8000000000000000,
  0xfd80000000000000, 0x8000000000000000,
  0xfb00000000000000, 0x8000000000000000,
  0xf600000000000000, 0x8000000000000000,
  0xec00000000000000, 0x8000000000000000,
  0xd800000000000000, 0x8000000000000000,
  0xb000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000008,
  0x0000000000000000, 0x0000000000000010,
  0x0000000000000000, 0x0000000000000020,
  0x0000000000000000, 0x0000000000000040,
  0x0000000000000000, 0x0000000000000080,
  0x0000000000000000, 0x0000000000000100,
  0x0000000000000000, 0x0000000000000200,
  0x0000000000000000, 0x0000000000000400,
  0x0000000000000000, 0x0000000000000800,
  0x0000000000000000, 0x0000000000001000,
  0x0000000000000000, 0x0000000000002000,
  0x0000000000000000, 0x0000000000004000,
  0x0000000000000000, 0x0000000000008000,
  0x0000000000000000, 0x0000000000010000,
  0x0000000000000000, 0x0000000000020000,
  0x0000000000000000, 0x0000000000040000,
  0x0000000000000000, 0x0000000000080000,
  0x0000000000000000, 0x0000000000100000,
  0x0000000000000000, 0x0000000000200000,
  0x0000000000000000, 0x0000000000400000,
  0x0000000000000000, 0x0000000000800000,
  0x0000000000000000, 0x0000000001000000,
  0x0000000000000000, 0x0000000002000000,
  0x0000000000000000, 0x0000000004000000,
  0x0000000000000000, 0x0000000008000000,
  0x0000000000000000, 0x0000000010000000,
  0x0000000000000000, 0x0000000020000000,
  0x0000000000000000, 0x0000000040000000,
  0x0000000000000000, 0x0000000080000000,
  0x0000000000000000, 0x0000000100000000,
  0x0000000000000000, 0x0000000200000000,
  0x0000000000000000, 0x0000000400000000,
  0x0000000000000000, 0x0000000800000000,
  0x0000000000000000, 0x0000001000000000,
  0x0000000000000000, 0x0000002000000000,
  0x0000000000000000, 0x0000004000000000,
  0x0000000000000000, 0x0000008000000000,
  0x0000000000000000, 0x0000010000000000,
  0x0000000000000000, 0x0000020000000000,
  0x0000000000000000, 0x0000040000000000,
  0x0000000000000000, 0x0000080000000000,
  0x0000000000000000, 0x0000100000000000,
  0x0000000000000000, 0x0000200000000000,
  0x0000000000000000, 0x0000400000000000,
  0x0000000000000000, 0x0000800000000000,
  0x0000000000000000, 0x0001000000000000,
  0x0000000000000000, 0x0002000000000000,
  0x0000000000000000, 0x0004000000000000,
  0x0000000000000000, 0x0008000000000000,
  0x0000000000000000, 0x0010000000000000,
  0x0000000000000000, 0x0020000000000000,
  0x0000000000000000, 0x0040000000000000,
  0x0000000000000000, 0x0080000000000000,
  0x0000000000000000, 0x0100000000000000,
  0x0000000000000000, 0x0200000000000000,
  0x0000000000000000, 0x0400000000000000,
  0x0000000000000000, 0x0800000000000000,
  0x0000000000000000, 0x1000000000000000,
  0x0000000000000000, 0x2000000000000000,
  0x0000000000000000, 0x4000000000000000,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000008, 0x0000000000000008,
  0x0000000000000010, 0x0000000000000010,
  0x0000000000000020, 0x0000000000000020,
  0x0000000000000040, 0x0000000000000040,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000100, 0x0000000000000100,
  0x0000000000000200, 0x0000000000000200,
  0x0000000000000400, 0x0000000000000400,
  0x0000000000000800, 0x0000000000000800,
  0x0000000000001000, 0x0000000000001000,
  0x0000000000002000, 0x0000000000002000,
  0x0000000000004000, 0x0000000000004000,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000010000, 0x0000000000010000,
  0x0000000000020000, 0x0000000000020000,
  0x0000000000040000, 0x0000000000040000,
  0x0000000000080000, 0x0000000000080000,
  0x0000000000100000, 0x0000000000100000,
  0x0000000000200000, 0x0000000000200000,
  0x0000000000400000, 0x0000000000400000,
  0x0000000000800000, 0x0000000000800000,
  0x0000000001000000, 0x0000000001000000,
  0x0000000002000000, 0x0000000002000000,
  0x0000000004000000, 0x0000000004000000,
  0x0000000008000000, 0x0000000008000000,
  0x0000000010000000, 0x0000000010000000,
  0x0000000020000000, 0x0000000020000000,
  0x0000000040000000, 0x0000000040000000,
  0x0000000080000000, 0x0000000080000000,
  0x0000000100000000, 0x0000000100000000,
  0x0000000200000000, 0x0000000200000000,
  0x0000000400000000, 0x0000000400000000,
  0x0000000800000000, 0x0000000800000000,
  0x0000001000000000, 0x0000001000000000,
  0x0000002000000000, 0x0000002000000000,
  0x0000004000000000, 0x0000004000000000,
  0x0000008000000000, 0x0000008000000000,
  0x0000010000000000, 0x0000010000000000,
  0x0000020000000000, 0x0000020000000000,
  0x0000040000000000, 0x0000040000000000,
  0x0000080000000000, 0x0000080000000000,
  0x0000100000000000, 0x0000100000000000,
  0x0000200000000000, 0x0000200000000000,
  0x0000400000000000, 0x0000400000000000,
  0x0000800000000000, 0x0000800000000000,
  0x0001000000000000, 0x0001000000000000,
  0x0002000000000000, 0x0002000000000000,
  0x0004000000000000, 0x0004000000000000,
  0x0008000000000000, 0x0008000000000000,
  0x0010000000000000, 0x0010000000000001,
  0x0020000000000000, 0x0020000000000002,
  0x0040000000000000, 0x0040000000000004,
  0x0080000000000000, 0x0080000000000008,
  0x0100000000000000, 0x0100000000000010,
  0x0200000000000000, 0x0200000000000020,
  0x0400000000000000, 0x0400000000000040,
  0x0800000000000000, 0x0800000000000080,
  0x1000000000000000, 0x1000000000000100,
  0x2000000000000000, 0x2000000000000200,
  0x4000000000000000, 0x4000000000000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000008, 0x0000000000000008,
  0x0000000000000010, 0x0000000000000010,
  0x0000000000000020, 0x0000000000000020,
  0x0000000000000040, 0x0000000000000040,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000100, 0x0000000000000100,
  0x0000000000000200, 0x0000000000000200,
  0x0000000000000400, 0x0000000000000400,
  0x0000000000000800, 0x0000000000000800,
  0x0000000000001000, 0x0000000000001000,
  0x0000000000002000, 0x0000000000002000,
  0x0000000000004000, 0x0000000000004000,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000010000, 0x0000000000010000,
  0x0000000000020000, 0x0000000000020000,
  0x0000000000040000, 0x0000000000040000,
  0x0000000000080000, 0x0000000000080000,
  0x0000000000100000, 0x0000000000100000,
  0x0000000000200000, 0x0000000000200000,
  0x0000000000400000, 0x0000000000400000,
  0x0000000000800000, 0x0000000000800000,
  0x0000000001000000, 0x0000000001000001,
  0x0000000002000000, 0x0000000002000002,
  0x0000000004000000, 0x0000000004000004,
  0x0000000008000000, 0x0000000008000008,
  0x0000000010000000, 0x0000000010000010,
  0x0000000020000000, 0x0000000020000020,
  0x0000000040000000, 0x0000000040000040,
  0x0000000080000000, 0x0000000080000080,
  0x0000000100000000, 0x0000000100000100,
  0x0000000200000000, 0x0000000200000200,
  0x0000000400000000, 0x0000000400000400,
  0x0000000800000000, 0x0000000800000800,
  0x0000001000000000, 0x0000001000001000,
  0x0000002000000000, 0x0000002000002000,
  0x0000004000000000, 0x0000004000004000,
  0x0000008000000000, 0x0000008000008000,
  0x0000010000000000, 0x0000010000010000,
  0x0000020000000000, 0x0000020000020000,
  0x0000040000000000, 0x0000040000040000,
  0x0000080000000000, 0x0000080000080000,
  0x0000100000000000, 0x0000100000100000,
  0x0000200000000000, 0x0000200000200000,
  0x0000400000000000, 0x0000400000400000,
  0x0000800000000000, 0x0000800000800000,
  0x0001000000000000, 0x0001000001000000,
  0x0002000000000000, 0x0002000002000000,
  0x0004000000000000, 0x0004000004000000,
  0x0008000000000000, 0x0008000008000000,
  0x0010000000000001, 0x0010000010000000,
  0x0020000000000002, 0x0020000020000000,
  0x0040000000000004, 0x0040000040000000,
  0x0080000000000008, 0x0080000080000000,
  0x0100000000000010, 0x0100000100000000,
  0x0200000000000020, 0x0200000200000000,
  0x0400000000000040, 0x0400000400000000,
  0x0800000000000080, 0x0800000800000000,
  0x1000000000000100, 0x1000001000000000,
  0x2000000000000200, 0x2000002000000000,
  0x4000000000000400, 0x4000004000000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000008, 0x0000000000000008,
  0x0000000000000010, 0x0000000000000010,
  0x0000000000000020, 0x0000000000000020,
  0x0000000000000040, 0x0000000000000040,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000100, 0x0000000000000100,
  0x0000000000000200, 0x0000000000000200,
  0x0000000000000400, 0x0000000000000400,
  0x0000000000000800, 0x0000000000000800,
  0x0000000000001000, 0x0000000000001000,
  0x0000000000002000, 0x0000000000002000,
  0x0000000000004000, 0x0000000000004000,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000010000, 0x0000000000010000,
  0x0000000000020000, 0x0000000000020000,
  0x0000000000040000, 0x0000000000040000,
  0x0000000000080000, 0x0000000000080000,
  0x0000000000100000, 0x0000000000100000,
  0x0000000000200000, 0x0000000000200000,
  0x0000000000400000, 0x0000000000400000,
  0x0000000000800000, 0x0000000000800000,
  0x0000000001000001, 0x0000000001000001,
  0x0000000002000002, 0x0000000002000002,
  0x0000000004000004, 0x0000000004000004,
  0x0000000008000008, 0x0000000008000008,
  0x0000000010000010, 0x0000000010000010,
  0x0000000020000020, 0x0000000020000020,
  0x0000000040000040, 0x0000000040000040,
  0x0000000080000080, 0x0000000080000080,
  0x0000000100000100, 0x0000000100000100,
  0x0000000200000200, 0x0000000200000200,
  0x0000000400000400, 0x0000000400000400,
  0x0000000800000800, 0x0000000800000800,
  0x0000001000001000, 0x0000001000001000,
  0x0000002000002000, 0x0000002000002000,
  0x0000004000004000, 0x0000004000004000,
  0x0000008000008000, 0x0000008000008000,
  0x0000010000010000, 0x0000010000010000,
  0x0000020000020000, 0x0000020000020000,
  0x0000040000040000, 0x0000040000040000,
  0x0000080000080000, 0x0000080000080000,
  0x0000100000100000, 0x0000100000100000,
  0x0000200000200000, 0x0000200000200000,
  0x0000400000400000, 0x0000400000400000,
  0x0000800000800000, 0x0000800000800000,
  0x0001000001000000, 0x0001000001000000,
  0x0002000002000000, 0x0002000002000000,
  0x0004000004000000, 0x0004000004000000,
  0x0008000008000000, 0x0008000008000000,
  0x0010000010000000, 0x0010000010000001,
  0x0020000020000000, 0x0020000020000002,
  0x0040000040000000, 0x0040000040000004,
  0x0080000080000000, 0x0080000080000008,
  0x0100000100000000, 0x0100000100000010,
  0x0200000200000000, 0x0200000200000020,
  0x0400000400000000, 0x0400000400000040,
  0x0800000800000000, 0x0800000800000080,
  0x1000001000000000, 0x1000001000000100,
  0x2000002000000000, 0x2000002000000200,
  0x4000004000000000, 0x4000004000000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000008, 0x0000000000000008,
  0x0000000000000010, 0x0000000000000010,
  0x0000000000000020, 0x0000000000000020,
  0x0000000000000040, 0x0000000000000040,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000100, 0x0000000000000100,
  0x0000000000000200, 0x0000000000000200,
  0x0000000000000400, 0x0000000000000400,
  0x0000000000000800, 0x0000000000000800,
  0x0000000000001000, 0x0000000000001000,
  0x0000000000002000, 0x0000000000002000,
  0x0000000000004000, 0x0000000000004000,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000010000, 0x0000000000010000,
  0x0000000000020000, 0x0000000000020000,
  0x0000000000040000, 0x0000000000040000,
  0x0000000000080000, 0x0000000000080000,
  0x0000000000100000, 0x0000000000100000,
  0x0000000000200000, 0x0000000000200000,
  0x0000000000400000, 0x0000000000400000,
  0x0000000000800000, 0x0000000000800001,
  0x0000000001000001, 0x0000000001000002,
  0x0000000002000002, 0x0000000002000004,
  0x0000000004000004, 0x0000000004000008,
  0x0000000008000008, 0x0000000008000010,
  0x0000000010000010, 0x0000000010000020,
  0x0000000020000020, 0x0000000020000040,
  0x0000000040000040, 0x0000000040000080,
  0x0000000080000080, 0x0000000080000100,
  0x0000000100000100, 0x0000000100000200,
  0x0000000200000200, 0x0000000200000400,
  0x0000000400000400, 0x0000000400000800,
  0x0000000800000800, 0x0000000800001000,
  0x0000001000001000, 0x0000001000002000,
  0x0000002000002000, 0x0000002000004000,
  0x0000004000004000, 0x0000004000008000,
  0x0000008000008000, 0x0000008000010000,
  0x0000010000010000, 0x0000010000020000,
  0x0000020000020000, 0x0000020000040000,
  0x0000040000040000, 0x0000040000080000,
  0x0000080000080000, 0x0000080000100000,
  0x0000100000100000, 0x0000100000200000,
  0x0000200000200000, 0x0000200000400000,
  0x0000400000400000, 0x0000400000800000,
  0x0000800000800000, 0x0000800001000000,
  0x0001000001000000, 0x0001000002000000,
  0x0002000002000000, 0x0002000004000000,
  0x0004000004000000, 0x0004000008000000,
  0x0008000008000000, 0x0008000010000000,
  0x0010000010000001, 0x0010000020000000,
  0x0020000020000002, 0x0020000040000000,
  0x0040000040000004, 0x0040000080000000,
  0x0080000080000008, 0x0080000100000000,
  0x0100000100000010, 0x0100000200000000,
  0x0200000200000020, 0x0200000400000000,
  0x0400000400000040, 0x0400000800000000,
  0x0800000800000080, 0x0800001000000000,
  0x1000001000000100, 0x1000002000000000,
  0x2000002000000200, 0x2000004000000000,
  0x4000004000000400, 0x4000008000000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000008, 0x0000000000000008,
  0x0000000000000010, 0x0000000000000010,
  0x0000000000000020, 0x0000000000000020,
  0x0000000000000040, 0x0000000000000040,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000100, 0x0000000000000100,
  0x0000000000000200, 0x0000000000000200,
  0x0000000000000400, 0x0000000000000400,
  0x0000000000000800, 0x0000000000000800,
  0x0000000000001000, 0x0000000000001000,
  0x0000000000002000, 0x0000000000002000,
  0x0000000000004000, 0x0000000000004000,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000010000, 0x0000000000010000,
  0x0000000000020000, 0x0000000000020000,
  0x0000000000040000, 0x0000000000040000,
  0x0000000000080000, 0x0000000000080000,
  0x0000000000100000, 0x0000000000100000,
  0x0000000000200000, 0x0000000000200000,
  0x0000000000400000, 0x0000000000400000,
  0x0000000000800001, 0x0000000000800001,
  0x0000000001000002, 0x0000000001000002,
  0x0000000002000004, 0x0000000002000004,
  0x0000000004000008, 0x0000000004000008,
  0x0000000008000010, 0x0000000008000010,
  0x0000000010000020, 0x0000000010000020,
  0x0000000020000040, 0x0000000020000040,
  0x0000000040000080, 0x0000000040000080,
  0x0000000080000100, 0x0000000080000100,
  0x0000000100000200, 0x0000000100000200,
  0x0000000200000400, 0x0000000200000400,
  0x0000000400000800, 0x0000000400000800,
  0x0000000800001000, 0x0000000800001000,
  0x0000001000002000, 0x0000001000002000,
  0x0000002000004000, 0x0000002000004000,
  0x0000004000008000, 0x0000004000008000,
  0x0000008000010000, 0x0000008000010000,
  0x0000010000020000, 0x0000010000020000,
  0x0000020000040000, 0x0000020000040000,
  0x0000040000080000, 0x0000040000080000,
  0x0000080000100000, 0x0000080000100000,
  0x0000100000200000, 0x0000100000200000,
  0x0000200000400000, 0x0000200000400000,
  0x0000400000800000, 0x0000400000800000,
  0x0000800001000000, 0x0000800001000000,
  0x0001000002000000, 0x0001000002000000,
  0x0002000004000000, 0x0002000004000000,
  0x0004000008000000, 0x0004000008000000,
  0x0008000010000000, 0x0008000010000000,
  0x0010000020000000, 0x0010000020000001,
  0x0020000040000000, 0x0020000040000002,
  0x0040000080000000, 0x0040000080000004,
  0x0080000100000000, 0x0080000100000008,
  0x0100000200000000, 0x0100000200000010,
  0x0200000400000000, 0x0200000400000020,
  0x0400000800000000, 0x0400000800000040,
  0x0800001000000000, 0x0800001000000080,
  0x1000002000000000, 0x1000002000000100,
  0x2000004000000000, 0x2000004000000200,
  0x4000008000000000, 0x4000008000000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000008, 0x0000000000000008,
  0x0000000000000010, 0x0000000000000010,
  0x0000000000000020, 0x0000000000000020,
  0x0000000000000040, 0x0000000000000040,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000100, 0x0000000000000100,
  0x0000000000000200, 0x0000000000000200,
  0x0000000000000400, 0x0000000000000400,
  0x0000000000000800, 0x0000000000000800,
  0x0000000000001000, 0x0000000000001000,
  0x0000000000002000, 0x0000000000002000,
  0x0000000000004000, 0x0000000000004000,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000010000, 0x0000000000010000,
  0x0000000000020000, 0x0000000000020000,
  0x0000000000040000, 0x0000000000040000,
  0x0000000000080000, 0x0000000000080000,
  0x0000000000100000, 0x0000000000100000,
  0x0000000000200000, 0x0000000000200000,
  0x0000000000400000, 0x0000000000400000,
  0x0000000000800001, 0x0000000000800001,
  0x0000000001000002, 0x0000000001000003,
  0x0000000002000004, 0x0000000002000006,
  0x0000000004000008, 0x000000000400000c,
  0x0000000008000010, 0x0000000008000018,
  0x0000000010000020, 0x0000000010000030,
  0x0000000020000040, 0x0000000020000060,
  0x0000000040000080, 0x00000000400000c0,
  0x0000000080000100, 0x0000000080000180,
  0x0000000100000200, 0x0000000100000300,
  0x0000000200000400, 0x0000000200000600,
  0x0000000400000800, 0x0000000400000c00,
  0x0000000800001000, 0x0000000800001800,
  0x0000001000002000, 0x0000001000003000,
  0x0000002000004000, 0x0000002000006000,
  0x0000004000008000, 0x000000400000c000,
  0x0000008000010000, 0x0000008000018000,
  0x0000010000020000, 0x0000010000030000,
  0x0000020000040000, 0x0000020000060000,
  0x0000040000080000, 0x00000400000c0000,
  0x0000080000100000, 0x0000080000180000,
  0x0000100000200000, 0x0000100000300000,
  0x0000200000400000, 0x0000200000600000,
  0x0000400000800000, 0x0000400000c00000,
  0x0000800001000000, 0x0000800001800000,
  0x0001000002000000, 0x0001000003000000,
  0x0002000004000000, 0x0002000006000000,
  0x0004000008000000, 0x000400000c000000,
  0x0008000010000000, 0x0008000018000000,
  0x0010000020000001, 0x0010000030000000,
  0x0020000040000002, 0x0020000060000000,
  0x0040000080000004, 0x00400000c0000000,
  0x0080000100000008, 0x0080000180000000,
  0x0100000200000010, 0x0100000300000000,
  0x0200000400000020, 0x0200000600000000,
  0x0400000800000040, 0x0400000c00000000,
  0x0800001000000080, 0x0800001800000000,
  0x1000002000000100, 0x1000003000000000,
  0x2000004000000200, 0x2000006000000000,
  0x4000008000000400, 0x400000c000000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000008, 0x0000000000000008,
  0x0000000000000010, 0x0000000000000010,
  0x0000000000000020, 0x0000000000000020,
  0x0000000000000040, 0x0000000000000040,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000100, 0x0000000000000100,
  0x0000000000000200, 0x0000000000000200,
  0x0000000000000400, 0x0000000000000400,
  0x0000000000000800, 0x0000000000000800,
  0x0000000000001000, 0x0000000000001000,
  0x0000000000002000, 0x0000000000002000,
  0x0000000000004000, 0x0000000000004000,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000010000, 0x0000000000010000,
  0x0000000000020000, 0x0000000000020000,
  0x0000000000040000, 0x0000000000040000,
  0x0000000000080000, 0x0000000000080000,
  0x0000000000100000, 0x0000000000100000,
  0x0000000000200000, 0x0000000000200000,
  0x0000000000400000, 0x0000000000400000,
  0x0000000000800001, 0x0000000000800001,
  0x0000000001000003, 0x0000000001000003,
  0x0000000002000006, 0x0000000002000006,
  0x000000000400000c, 0x000000000400000c,
  0x0000000008000018, 0x0000000008000018,
  0x0000000010000030, 0x0000000010000030,
  0x0000000020000060, 0x0000000020000060,
  0x00000000400000c0, 0x00000000400000c0,
  0x0000000080000180, 0x0000000080000180,
  0x0000000100000300, 0x0000000100000300,
  0x0000000200000600, 0x0000000200000600,
  0x0000000400000c00, 0x0000000400000c00,
  0x0000000800001800, 0x0000000800001800,
  0x0000001000003000, 0x0000001000003000,
  0x0000002000006000, 0x0000002000006000,
  0x000000400000c000, 0x000000400000c000,
  0x0000008000018000, 0x0000008000018000,
  0x0000010000030000, 0x0000010000030000,
  0x0000020000060000, 0x0000020000060000,
  0x00000400000c0000, 0x00000400000c0000,
  0x0000080000180000, 0x0000080000180000,
  0x0000100000300000, 0x0000100000300000,
  0x0000200000600000, 0x0000200000600000,
  0x0000400000c00000, 0x0000400000c00000,
  0x0000800001800000, 0x0000800001800000,
  0x0001000003000000, 0x0001000003000000,
  0x0002000006000000, 0x0002000006000000,
  0x000400000c000000, 0x000400000c000000,
  0x0008000018000000, 0x0008000018000000,
  0x0010000030000000, 0x0010000030000001,
  0x0020000060000000, 0x0020000060000002,
  0x00400000c0000000, 0x00400000c0000004,
  0x0080000180000000, 0x0080000180000008,
  0x0100000300000000, 0x0100000300000010,
  0x0200000600000000, 0x0200000600000020,
  0x0400000c00000000, 0x0400000c00000040,
  0x0800001800000000, 0x0800001800000080,
  0x1000003000000000, 0x1000003000000100,
  0x2000006000000000, 0x2000006000000200,
  0x400000c000000000, 0x400000c000000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000008, 0x0000000000000008,
  0x0000000000000010, 0x0000000000000010,
  0x0000000000000020, 0x0000000000000020,
  0x0000000000000040, 0x0000000000000040,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000100, 0x0000000000000100,
  0x0000000000000200, 0x0000000000000200,
  0x0000000000000400, 0x0000000000000400,
  0x0000000000000800, 0x0000000000000800,
  0x0000000000001000, 0x0000000000001000,
  0x0000000000002000, 0x0000000000002000,
  0x0000000000004000, 0x0000000000004000,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000010000, 0x0000000000010000,
  0x0000000000020000, 0x0000000000020000,
  0x0000000000040000, 0x0000000000040000,
  0x0000000000080000, 0x0000000000080000,
  0x0000000000100000, 0x0000000000100000,
  0x0000000000200000, 0x0000000000200000,
  0x0000000000400000, 0x0000000000400001,
  0x0000000000800001, 0x0000000000800002,
  0x0000000001000003, 0x0000000001000004,
  0x0000000002000006, 0x0000000002000008,
  0x000000000400000c, 0x0000000004000010,
  0x0000000008000018, 0x0000000008000020,
  0x0000000010000030, 0x0000000010000040,
  0x0000000020000060, 0x0000000020000080,
  0x00000000400000c0, 0x0000000040000100,
  0x0000000080000180, 0x0000000080000200,
  0x0000000100000300, 0x0000000100000400,
  0x0000000200000600, 0x0000000200000800,
  0x0000000400000c00, 0x0000000400001000,
  0x0000000800001800, 0x0000000800002000,
  0x0000001000003000, 0x0000001000004000,
  0x0000002000006000, 0x0000002000008000,
  0x000000400000c000, 0x0000004000010000,
  0x0000008000018000, 0x0000008000020000,
  0x0000010000030000, 0x0000010000040000,
  0x0000020000060000, 0x0000020000080000,
  0x00000400000c0000, 0x0000040000100000,
  0x0000080000180000, 0x0000080000200000,
  0x0000100000300000, 0x0000100000400000,
  0x0000200000600000, 0x0000200000800000,
  0x0000400000c00000, 0x0000400001000000,
  0x0000800001800000, 0x0000800002000000,
  0x0001000003000000, 0x0001000004000000,
  0x0002000006000000, 0x0002000008000000,
  0x000400000c000000, 0x0004000010000000,
  0x0008000018000000, 0x0008000020000000,
  0x0010000030000001, 0x0010000040000000,
  0x0020000060000002, 0x0020000080000000,
  0x00400000c0000004, 0x0040000100000000,
  0x0080000180000008, 0x0080000200000000,
  0x0100000300000010, 0x0100000400000000,
  0x0200000600000020, 0x0200000800000000,
  0x0400000c00000040, 0x0400001000000000,
  0x0800001800000080, 0x0800002000000000,
  0x1000003000000100, 0x1000004000000000,
  0x2000006000000200, 0x2000008000000000,
  0x400000c000000400, 0x4000010000000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000008, 0x0000000000000008,
  0x0000000000000010, 0x0000000000000010,
  0x0000000000000020, 0x0000000000000020,
  0x0000000000000040, 0x0000000000000040,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000100, 0x0000000000000100,
  0x0000000000000200, 0x0000000000000200,
  0x0000000000000400, 0x0000000000000400,
  0x0000000000000800, 0x0000000000000800,
  0x0000000000001000, 0x0000000000001000,
  0x0000000000002000, 0x0000000000002000,
  0x0000000000004000, 0x0000000000004000,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000010000, 0x0000000000010000,
  0x0000000000020000, 0x0000000000020000,
  0x0000000000040000, 0x0000000000040000,
  0x0000000000080000, 0x0000000000080000,
  0x0000000000100000, 0x0000000000100000,
  0x0000000000200000, 0x0000000000200000,
  0x0000000000400001, 0x0000000000400001,
  0x0000000000800002, 0x0000000000800002,
  0x0000000001000004, 0x0000000001000004,
  0x0000000002000008, 0x0000000002000008,
  0x0000000004000010, 0x0000000004000010,
  0x0000000008000020, 0x0000000008000020,
  0x0000000010000040, 0x0000000010000040,
  0x0000000020000080, 0x0000000020000080,
  0x0000000040000100, 0x0000000040000100,
  0x0000000080000200, 0x0000000080000200,
  0x0000000100000400, 0x0000000100000400,
  0x0000000200000800, 0x0000000200000800,
  0x0000000400001000, 0x0000000400001000,
  0x0000000800002000, 0x0000000800002000,
  0x0000001000004000, 0x0000001000004000,
  0x0000002000008000, 0x0000002000008000,
  0x0000004000010000, 0x0000004000010000,
  0x0000008000020000, 0x0000008000020000,
  0x0000010000040000, 0x0000010000040000,
  0x0000020000080000, 0x0000020000080000,
  0x0000040000100000, 0x0000040000100000,
  0x0000080000200000, 0x0000080000200000,
  0x0000100000400000, 0x0000100000400000,
  0x0000200000800000, 0x0000200000800000,
  0x0000400001000000, 0x0000400001000000,
  0x0000800002000000, 0x0000800002000000,
  0x0001000004000000, 0x0001000004000000,
  0x0002000008000000, 0x0002000008000000,
  0x0004000010000000, 0x0004000010000000,
  0x0008000020000000, 0x0008000020000000,
  0x0010000040000000, 0x0010000040000001,
  0x0020000080000000, 0x0020000080000002,
  0x0040000100000000, 0x0040000100000004,
  0x0080000200000000, 0x0080000200000008,
  0x0100000400000000, 0x0100000400000010,
  0x0200000800000000, 0x0200000800000020,
  0x0400001000000000, 0x0400001000000040,
  0x0800002000000000, 0x0800002000000080,
  0x1000004000000000, 0x1000004000000100,
  0x2000008000000000, 0x2000008000000200,
  0x4000010000000000, 0x4000010000000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000008, 0x0000000000000008,
  0x0000000000000010, 0x0000000000000010,
  0x0000000000000020, 0x0000000000000020,
  0x0000000000000040, 0x0000000000000040,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000100, 0x0000000000000100,
  0x0000000000000200, 0x0000000000000200,
  0x0000000000000400, 0x0000000000000400,
  0x0000000000000800, 0x0000000000000800,
  0x0000000000001000, 0x0000000000001000,
  0x0000000000002000, 0x0000000000002000,
  0x0000000000004000, 0x0000000000004000,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000010000, 0x0000000000010000,
  0x0000000000020000, 0x0000000000020000,
  0x0000000000040000, 0x0000000000040000,
  0x0000000000080000, 0x0000000000080000,
  0x0000000000100000, 0x0000000000100000,
  0x0000000000200000, 0x0000000000200000,
  0x0000000000400001, 0x0000000000400001,
  0x0000000000800002, 0x0000000000800002,
  0x0000000001000004, 0x0000000001000005,
  0x0000000002000008, 0x000000000200000a,
  0x0000000004000010, 0x0000000004000014,
  0x0000000008000020, 0x0000000008000028,
  0x0000000010000040, 0x0000000010000050,
  0x0000000020000080, 0x00000000200000a0,
  0x0000000040000100, 0x0000000040000140,
  0x0000000080000200, 0x0000000080000280,
  0x0000000100000400, 0x0000000100000500,
  0x0000000200000800, 0x0000000200000a00,
  0x0000000400001000, 0x0000000400001400,
  0x0000000800002000, 0x0000000800002800,
  0x0000001000004000, 0x0000001000005000,
  0x0000002000008000, 0x000000200000a000,
  0x0000004000010000, 0x0000004000014000,
  0x0000008000020000, 0x0000008000028000,
  0x0000010000040000, 0x0000010000050000,
  0x0000020000080000, 0x00000200000a0000,
  0x0000040000100000, 0x0000040000140000,
  0x0000080000200000, 0x0000080000280000,
  0x0000100000400000, 0x0000100000500000,
  0x0000200000800000, 0x0000200000a00000,
  0x0000400001000000, 0x0000400001400000,
  0x0000800002000000, 0x0000800002800000,
  0x0001000004000000, 0x0001000005000000,
  0x0002000008000000, 0x000200000a000000,
  0x0004000010000000, 0x0004000014000000,
  0x0008000020000000, 0x0008000028000000,
  0x0010000040000001, 0x0010000050000000,
  0x0020000080000002, 0x00200000a0000000,
  0x0040000100000004, 0x0040000140000000,
  0x0080000200000008, 0x0080000280000000,
  0x0100000400000010, 0x0100000500000000,
  0x0200000800000020, 0x0200000a00000000,
  0x0400001000000040, 0x0400001400000000,
  0x0800002000000080, 0x0800002800000000,
  0x1000004000000100, 0x1000005000000000,
  0x2000008000000200, 0x200000a000000000,
  0x4000010000000400, 0x4000014000000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000008, 0x0000000000000008,
  0x0000000000000010, 0x0000000000000010,
  0x0000000000000020, 0x0000000000000020,
  0x0000000000000040, 0x0000000000000040,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000100, 0x0000000000000100,
  0x0000000000000200, 0x0000000000000200,
  0x0000000000000400, 0x0000000000000400,
  0x0000000000000800, 0x0000000000000800,
  0x0000000000001000, 0x0000000000001000,
  0x0000000000002000, 0x0000000000002000,
  0x0000000000004000, 0x0000000000004000,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000010000, 0x0000000000010000,
  0x0000000000020000, 0x0000000000020000,
  0x0000000000040000, 0x0000000000040000,
  0x0000000000080000, 0x0000000000080000,
  0x0000000000100000, 0x0000000000100000,
  0x0000000000200000, 0x0000000000200000,
  0x0000000000400001, 0x0000000000400001,
  0x0000000000800002, 0x0000000000800002,
  0x0000000001000005, 0x0000000001000005,
  0x000000000200000a, 0x000000000200000a,
  0x0000000004000014, 0x0000000004000014,
  0x0000000008000028, 0x0000000008000028,
  0x0000000010000050, 0x0000000010000050,
  0x00000000200000a0, 0x00000000200000a0,
  0x0000000040000140, 0x0000000040000140,
  0x0000000080000280, 0x0000000080000280,
  0x0000000100000500, 0x0000000100000500,
  0x0000000200000a00, 0x0000000200000a00,
  0x0000000400001400, 0x0000000400001400,
  0x0000000800002800, 0x0000000800002800,
  0x0000001000005000, 0x0000001000005000,
  0x000000200000a000, 0x000000200000a000,
  0x0000004000014000, 0x0000004000014000,
  0x0000008000028000, 0x0000008000028000,
  0x0000010000050000, 0x0000010000050000,
  0x00000200000a0000, 0x00000200000a0000,
  0x0000040000140000, 0x0000040000140000,
  0x0000080000280000, 0x0000080000280000,
  0x0000100000500000, 0x0000100000500000,
  0x0000200000a00000, 0x0000200000a00000,
  0x0000400001400000, 0x0000400001400000,
  0x0000800002800000, 0x0000800002800000,
  0x0001000005000000, 0x0001000005000000,
  0x000200000a000000, 0x000200000a000000,
  0x0004000014000000, 0x0004000014000000,
  0x0008000028000000, 0x0008000028000000,
  0x0010000050000000, 0x0010000050000001,
  0x00200000a0000000, 0x00200000a0000002,
  0x0040000140000000, 0x0040000140000004,
  0x0080000280000000, 0x0080000280000008,
  0x0100000500000000, 0x0100000500000010,
  0x0200000a00000000, 0x0200000a00000020,
  0x0400001400000000, 0x0400001400000040,
  0x0800002800000000, 0x0800002800000080,
  0x1000005000000000, 0x1000005000000100,
  0x200000a000000000, 0x200000a000000200,
  0x4000014000000000, 0x4000014000000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000008, 0x0000000000000008,
  0x0000000000000010, 0x0000000000000010,
  0x0000000000000020, 0x0000000000000020,
  0x0000000000000040, 0x0000000000000040,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000100, 0x0000000000000100,
  0x0000000000000200, 0x0000000000000200,
  0x0000000000000400, 0x0000000000000400,
  0x0000000000000800, 0x0000000000000800,
  0x0000000000001000, 0x0000000000001000,
  0x0000000000002000, 0x0000000000002000,
  0x0000000000004000, 0x0000000000004000,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000010000, 0x0000000000010000,
  0x0000000000020000, 0x0000000000020000,
  0x0000000000040000, 0x0000000000040000,
  0x0000000000080000, 0x0000000000080000,
  0x0000000000100000, 0x0000000000100000,
  0x0000000000200000, 0x0000000000200000,
  0x0000000000400001, 0x0000000000400001,
  0x0000000000800002, 0x0000000000800003,
  0x0000000001000005, 0x0000000001000006,
  0x000000000200000a, 0x000000000200000c,
  0x0000000004000014, 0x0000000004000018,
  0x0000000008000028, 0x0000000008000030,
  0x0000000010000050, 0x0000000010000060,
  0x00000000200000a0, 0x00000000200000c0,
  0x0000000040000140, 0x0000000040000180,
  0x0000000080000280, 0x0000000080000300,
  0x0000000100000500, 0x0000000100000600,
  0x0000000200000a00, 0x0000000200000c00,
  0x0000000400001400, 0x0000000400001800,
  0x0000000800002800, 0x0000000800003000,
  0x0000001000005000, 0x0000001000006000,
  0x000000200000a000, 0x000000200000c000,
  0x0000004000014000, 0x0000004000018000,
  0x0000008000028000, 0x0000008000030000,
  0x0000010000050000, 0x0000010000060000,
  0x00000200000a0000, 0x00000200000c0000,
  0x0000040000140000, 0x0000040000180000,
  0x0000080000280000, 0x0000080000300000,
  0x0000100000500000, 0x0000100000600000,
  0x0000200000a00000, 0x0000200000c00000,
  0x0000400001400000, 0x0000400001800000,
  0x0000800002800000, 0x0000800003000000,
  0x0001000005000000, 0x0001000006000000,
  0x000200000a000000, 0x000200000c000000,
  0x0004000014000000, 0x0004000018000000,
  0x0008000028000000, 0x0008000030000000,
  0x0010000050000001, 0x0010000060000000,
  0x00200000a0000002, 0x00200000c0000000,
  0x0040000140000004, 0x0040000180000000,
  0x0080000280000008, 0x0080000300000000,
  0x0100000500000010, 0x0100000600000000,
  0x0200000a00000020, 0x0200000c00000000,
  0x0400001400000040, 0x0400001800000000,
  0x0800002800000080, 0x0800003000000000,
  0x1000005000000100, 0x1000006000000000,
  0x200000a000000200, 0x200000c000000000,
  0x4000014000000400, 0x4000018000000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000001,
  0x0000000000000004, 0x0000000000000003,
  0x0000000000000008, 0x0000000000000007,
  0x0000000000000010, 0x000000000000000f,
  0x0000000000000020, 0x000000000000001f,
  0x0000000000000040, 0x000000000000003f,
  0x0000000000000080, 0x000000000000007f,
  0x0000000000000100, 0x00000000000000ff,
  0x0000000000000200, 0x00000000000001ff,
  0x0000000000000400, 0x00000000000003ff,
  0x0000000000000800, 0x00000000000007ff,
  0x0000000000001000, 0x0000000000000fff,
  0x0000000000002000, 0x0000000000001fff,
  0x0000000000004000, 0x0000000000003fff,
  0x0000000000008000, 0x0000000000007fff,
  0x0000000000010000, 0x000000000000ffff,
  0x0000000000020000, 0x000000000001ffff,
  0x0000000000040000, 0x000000000003ffff,
  0x0000000000080000, 0x000000000007ffff,
  0x0000000000100000, 0x00000000000fffff,
  0x0000000000200000, 0x00000000001fffff,
  0x0000000000400001, 0x00000000003fffff,
  0x0000000000800003, 0x00000000007fffff,
  0x0000000001000006, 0x0000000000ffffff,
  0x000000000200000c, 0x0000000001ffffff,
  0x0000000004000018, 0x0000000003fffffe,
  0x0000000008000030, 0x0000000007fffffc,
  0x0000000010000060, 0x000000000ffffff8,
  0x00000000200000c0, 0x000000001ffffff0,
  0x0000000040000180, 0x000000003fffffe0,
  0x0000000080000300, 0x000000007fffffc0,
  0x0000000100000600, 0x00000000ffffff80,
  0x0000000200000c00, 0x00000001ffffff00,
  0x0000000400001800, 0x00000003fffffe00,
  0x0000000800003000, 0x00000007fffffc00,
  0x0000001000006000, 0x0000000ffffff800,
  0x000000200000c000, 0x0000001ffffff000,
  0x0000004000018000, 0x0000003fffffe000,
  0x0000008000030000, 0x0000007fffffc000,
  0x0000010000060000, 0x000000ffffff8000,
  0x00000200000c0000, 0x000001ffffff0000,
  0x0000040000180000, 0x000003fffffe0000,
  0x0000080000300000, 0x000007fffffc0000,
  0x0000100000600000, 0x00000ffffff80000,
  0x0000200000c00000, 0x00001ffffff00000,
  0x0000400001800000, 0x00003fffffe00000,
  0x0000800003000000, 0x00007fffffc00000,
  0x0001000006000000, 0x0000ffffff800000,
  0x000200000c000000, 0x0001ffffff000000,
  0x0004000018000000, 0x0003fffffe000000,
  0x0008000030000000, 0x0007fffffc000000,
  0x0010000060000000, 0x000ffffff8000000,
  0x00200000c0000000, 0x001ffffff0000000,
  0x0040000180000000, 0x003fffffe0000000,
  0x0080000300000000, 0x007fffffc0000000,
  0x0100000600000000, 0x00ffffff80000000,
  0x0200000c00000000, 0x01ffffff00000000,
  0x0400001800000000, 0x03fffffe00000000,
  0x0800003000000000, 0x07fffffc00000000,
  0x1000006000000000, 0x0ffffff800000000,
  0x200000c000000000, 0x1ffffff000000000,
  0x4000018000000000, 0x3fffffe000000000,
  0x7fffffffffffffff, 0x7fffffc000000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000001, 0x7fffffffffffffff,
  0x0000000000000003, 0x7fffffffffffffff,
  0x0000000000000007, 0x7fffffffffffffff,
  0x000000000000000f, 0x7fffffffffffffff,
  0x000000000000001f, 0x7fffffffffffffff,
  0x000000000000003f, 0x7fffffffffffffff,
  0x000000000000007f, 0x7fffffffffffffff,
  0x00000000000000ff, 0x7fffffffffffffff,
  0x00000000000001ff, 0x7fffffffffffffff,
  0x00000000000003ff, 0x7fffffffffffffff,
  0x00000000000007ff, 0x7fffffffffffffff,
  0x0000000000000fff, 0x7fffffffffffffff,
  0x0000000000001fff, 0x7fffffffffffffff,
  0x0000000000003fff, 0x7fffffffffffffff,
  0x0000000000007fff, 0x7fffffffffffffff,
  0x000000000000ffff, 0x7fffffffffffffff,
  0x000000000001ffff, 0x7fffffffffffffff,
  0x000000000003ffff, 0x7fffffffffffffff,
  0x000000000007ffff, 0x7fffffffffffffff,
  0x00000000000fffff, 0x7fffffffffffffff,
  0x00000000001fffff, 0x7fffffffffffffff,
  0x00000000003fffff, 0x7fffffffffffffff,
  0x00000000007fffff, 0x7fffffffffffffff,
  0x0000000000ffffff, 0x7fffffffffffffff,
  0x0000000001ffffff, 0x7fffffffffffffff,
  0x0000000003fffffe, 0x7fffffffffffffff,
  0x0000000007fffffc, 0x7fffffffffffffff,
  0x000000000ffffff8, 0x7fffffffffffffff,
  0x000000001ffffff0, 0x7fffffffffffffff,
  0x000000003fffffe0, 0x7fffffffffffffff,
  0x000000007fffffc0, 0x7fffffffffffffff,
  0x00000000ffffff80, 0x7fffffffffffffff,
  0x00000001ffffff00, 0x7fffffffffffffff,
  0x00000003fffffe00, 0x7fffffffffffffff,
  0x00000007fffffc00, 0x7fffffffffffffff,
  0x0000000ffffff800, 0x7fffffffffffffff,
  0x0000001ffffff000, 0x7fffffffffffffff,
  0x0000003fffffe000, 0x7fffffffffffffff,
  0x0000007fffffc000, 0x7fffffffffffffff,
  0x000000ffffff8000, 0x7fffffffffffffff,
  0x000001ffffff0000, 0x7fffffffffffffff,
  0x000003fffffe0000, 0x7fffffffffffffff,
  0x000007fffffc0000, 0x7fffffffffffffff,
  0x00000ffffff80000, 0x7fffffffffffffff,
  0x00001ffffff00000, 0x7fffffffffffffff,
  0x00003fffffe00000, 0x7fffffffffffffff,
  0x00007fffffc00000, 0x7fffffffffffffff,
  0x0000ffffff800000, 0x7fffffffffffffff,
  0x0001ffffff000000, 0x7fffffffffffffff,
  0x0003fffffe000000, 0x7fffffffffffffff,
  0x0007fffffc000000, 0x7fffffffffffffff,
  0x000ffffff8000000, 0x7fffffffffffffff,
  0x001ffffff0000000, 0x7fffffffffffffff,
  0x003fffffe0000000, 0x7fffffffffffffff,
  0x007fffffc0000000, 0x7fffffffffffffff,
  0x00ffffff80000000, 0x7fffffffffffffff,
  0x01ffffff00000000, 0x7fffffffffffffff,
  0x03fffffe00000000, 0x7fffffffffffffff,
  0x07fffffc00000000, 0x7fffffffffffffff,
  0x0ffffff800000000, 0x7fffffffffffffff,
  0x1ffffff000000000, 0x7fffffffffffffff,
  0x3fffffe000000000, 0x7fffffffffffffff,
  0x7fffffc000000000, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0xfffffffffffffffe,
  0x0000000000000000, 0xfffffffffffffffc,
  0x0000000000000000, 0xfffffffffffffff8,
  0x0000000000000000, 0xfffffffffffffff0,
  0x0000000000000000, 0xffffffffffffffe0,
  0x0000000000000000, 0xffffffffffffffc0,
  0x0000000000000000, 0xffffffffffffff80,
  0x0000000000000000, 0xffffffffffffff00,
  0x0000000000000000, 0xfffffffffffffe00,
  0x0000000000000000, 0xfffffffffffffc00,
  0x0000000000000000, 0xfffffffffffff800,
  0x0000000000000000, 0xfffffffffffff000,
  0x0000000000000000, 0xffffffffffffe000,
  0x0000000000000000, 0xffffffffffffc000,
  0x0000000000000000, 0xffffffffffff8000,
  0x0000000000000000, 0xffffffffffff0000,
  0x0000000000000000, 0xfffffffffffe0000,
  0x0000000000000000, 0xfffffffffffc0000,
  0x0000000000000000, 0xfffffffffff80000,
  0x0000000000000000, 0xfffffffffff00000,
  0x0000000000000000, 0xffffffffffe00000,
  0x0000000000000000, 0xffffffffffc00000,
  0x0000000000000000, 0xffffffffff800000,
  0x0000000000000000, 0xffffffffff000000,
  0x0000000000000000, 0xfffffffffe000000,
  0x0000000000000000, 0xfffffffffc000000,
  0x0000000000000000, 0xfffffffff8000000,
  0x0000000000000000, 0xfffffffff0000000,
  0x0000000000000000, 0xffffffffe0000000,
  0x0000000000000000, 0xffffffffc0000000,
  0x0000000000000000, 0xffffffff80000000,
  0x0000000000000000, 0xffffffff00000000,
  0x0000000000000000, 0xfffffffe00000000,
  0x0000000000000000, 0xfffffffc00000000,
  0x0000000000000000, 0xfffffff800000000,
  0x0000000000000000, 0xfffffff000000000,
  0x0000000000000000, 0xffffffe000000000,
  0x0000000000000000, 0xffffffc000000000,
  0x0000000000000000, 0xffffff8000000000,
  0x0000000000000000, 0xffffff0000000000,
  0x0000000000000000, 0xfffffe0000000000,
  0x0000000000000000, 0xfffffc0000000000,
  0x0000000000000000, 0xfffff80000000000,
  0x0000000000000000, 0xfffff00000000000,
  0x0000000000000000, 0xffffe00000000000,
  0x0000000000000000, 0xffffc00000000000,
  0x0000000000000000, 0xffff800000000000,
  0x0000000000000000, 0xffff000000000000,
  0x0000000000000000, 0xfffe000000000000,
  0x0000000000000000, 0xfffc000000000000,
  0x0000000000000000, 0xfff8000000000000,
  0x0000000000000000, 0xfff0000000000000,
  0x0000000000000000, 0xffe0000000000000,
  0x0000000000000000, 0xffc0000000000000,
  0x0000000000000000, 0xff80000000000000,
  0x0000000000000000, 0xff00000000000000,
  0x0000000000000000, 0xfe00000000000000,
  0x0000000000000000, 0xfc00000000000000,
  0x0000000000000000, 0xf800000000000000,
  0x0000000000000000, 0xf000000000000000,
  0x0000000000000000, 0xe000000000000000,
  0x0000000000000000, 0xc000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc0, 0xffffffffffffffc0,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff00, 0xffffffffffffff00,
  0xfffffffffffffe00, 0xfffffffffffffe00,
  0xfffffffffffffc00, 0xfffffffffffffc00,
  0xfffffffffffff800, 0xfffffffffffff800,
  0xfffffffffffff000, 0xfffffffffffff000,
  0xffffffffffffe000, 0xffffffffffffe000,
  0xffffffffffffc000, 0xffffffffffffc000,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff0000, 0xffffffffffff0000,
  0xfffffffffffe0000, 0xfffffffffffe0000,
  0xfffffffffffc0000, 0xfffffffffffc0000,
  0xfffffffffff80000, 0xfffffffffff80000,
  0xfffffffffff00000, 0xfffffffffff00000,
  0xffffffffffe00000, 0xffffffffffe00000,
  0xffffffffffc00000, 0xffffffffffc00000,
  0xffffffffff800000, 0xffffffffff800000,
  0xffffffffff000000, 0xffffffffff000000,
  0xfffffffffe000000, 0xfffffffffe000000,
  0xfffffffffc000000, 0xfffffffffc000000,
  0xfffffffff8000000, 0xfffffffff8000000,
  0xfffffffff0000000, 0xfffffffff0000000,
  0xffffffffe0000000, 0xffffffffe0000000,
  0xffffffffc0000000, 0xffffffffc0000000,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff00000000, 0xffffffff00000000,
  0xfffffffe00000000, 0xfffffffe00000000,
  0xfffffffc00000000, 0xfffffffc00000000,
  0xfffffff800000000, 0xfffffff800000000,
  0xfffffff000000000, 0xfffffff000000000,
  0xffffffe000000000, 0xffffffe000000000,
  0xffffffc000000000, 0xffffffc000000000,
  0xffffff8000000000, 0xffffff8000000000,
  0xffffff0000000000, 0xffffff0000000000,
  0xfffffe0000000000, 0xfffffe0000000000,
  0xfffffc0000000000, 0xfffffc0000000000,
  0xfffff80000000000, 0xfffff80000000000,
  0xfffff00000000000, 0xfffff00000000000,
  0xffffe00000000000, 0xffffe00000000000,
  0xffffc00000000000, 0xffffc00000000000,
  0xffff800000000000, 0xffff800000000000,
  0xffff000000000000, 0xffff000000000000,
  0xfffe000000000000, 0xfffe000000000000,
  0xfffc000000000000, 0xfffc000000000000,
  0xfff8000000000000, 0xfff8000000000000,
  0xfff0000000000000, 0xffefffffffffffff,
  0xffe0000000000000, 0xffdffffffffffffe,
  0xffc0000000000000, 0xffbffffffffffffc,
  0xff80000000000000, 0xff7ffffffffffff8,
  0xff00000000000000, 0xfefffffffffffff0,
  0xfe00000000000000, 0xfdffffffffffffe0,
  0xfc00000000000000, 0xfbffffffffffffc0,
  0xf800000000000000, 0xf7ffffffffffff80,
  0xf000000000000000, 0xefffffffffffff00,
  0xe000000000000000, 0xdffffffffffffe00,
  0xc000000000000000, 0xbffffffffffffc00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc0, 0xffffffffffffffc0,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff00, 0xffffffffffffff00,
  0xfffffffffffffe00, 0xfffffffffffffe00,
  0xfffffffffffffc00, 0xfffffffffffffc00,
  0xfffffffffffff800, 0xfffffffffffff800,
  0xfffffffffffff000, 0xfffffffffffff000,
  0xffffffffffffe000, 0xffffffffffffe000,
  0xffffffffffffc000, 0xffffffffffffc000,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff0000, 0xffffffffffff0000,
  0xfffffffffffe0000, 0xfffffffffffe0000,
  0xfffffffffffc0000, 0xfffffffffffc0000,
  0xfffffffffff80000, 0xfffffffffff80000,
  0xfffffffffff00000, 0xfffffffffff00000,
  0xffffffffffe00000, 0xffffffffffe00000,
  0xffffffffffc00000, 0xffffffffffc00000,
  0xffffffffff800000, 0xffffffffff800000,
  0xffffffffff000000, 0xfffffffffeffffff,
  0xfffffffffe000000, 0xfffffffffdfffffe,
  0xfffffffffc000000, 0xfffffffffbfffffc,
  0xfffffffff8000000, 0xfffffffff7fffff8,
  0xfffffffff0000000, 0xffffffffeffffff0,
  0xffffffffe0000000, 0xffffffffdfffffe0,
  0xffffffffc0000000, 0xffffffffbfffffc0,
  0xffffffff80000000, 0xffffffff7fffff80,
  0xffffffff00000000, 0xfffffffeffffff00,
  0xfffffffe00000000, 0xfffffffdfffffe00,
  0xfffffffc00000000, 0xfffffffbfffffc00,
  0xfffffff800000000, 0xfffffff7fffff800,
  0xfffffff000000000, 0xffffffeffffff000,
  0xffffffe000000000, 0xffffffdfffffe000,
  0xffffffc000000000, 0xffffffbfffffc000,
  0xffffff8000000000, 0xffffff7fffff8000,
  0xffffff0000000000, 0xfffffeffffff0000,
  0xfffffe0000000000, 0xfffffdfffffe0000,
  0xfffffc0000000000, 0xfffffbfffffc0000,
  0xfffff80000000000, 0xfffff7fffff80000,
  0xfffff00000000000, 0xffffeffffff00000,
  0xffffe00000000000, 0xffffdfffffe00000,
  0xffffc00000000000, 0xffffbfffffc00000,
  0xffff800000000000, 0xffff7fffff800000,
  0xffff000000000000, 0xfffeffffff000000,
  0xfffe000000000000, 0xfffdfffffe000000,
  0xfffc000000000000, 0xfffbfffffc000000,
  0xfff8000000000000, 0xfff7fffff8000000,
  0xffefffffffffffff, 0xffeffffff0000000,
  0xffdffffffffffffe, 0xffdfffffe0000000,
  0xffbffffffffffffc, 0xffbfffffc0000000,
  0xff7ffffffffffff8, 0xff7fffff80000000,
  0xfefffffffffffff0, 0xfeffffff00000000,
  0xfdffffffffffffe0, 0xfdfffffe00000000,
  0xfbffffffffffffc0, 0xfbfffffc00000000,
  0xf7ffffffffffff80, 0xf7fffff800000000,
  0xefffffffffffff00, 0xeffffff000000000,
  0xdffffffffffffe00, 0xdfffffe000000000,
  0xbffffffffffffc00, 0xbfffffc000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc0, 0xffffffffffffffc0,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff00, 0xffffffffffffff00,
  0xfffffffffffffe00, 0xfffffffffffffe00,
  0xfffffffffffffc00, 0xfffffffffffffc00,
  0xfffffffffffff800, 0xfffffffffffff800,
  0xfffffffffffff000, 0xfffffffffffff000,
  0xffffffffffffe000, 0xffffffffffffe000,
  0xffffffffffffc000, 0xffffffffffffc000,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff0000, 0xffffffffffff0000,
  0xfffffffffffe0000, 0xfffffffffffe0000,
  0xfffffffffffc0000, 0xfffffffffffc0000,
  0xfffffffffff80000, 0xfffffffffff80000,
  0xfffffffffff00000, 0xfffffffffff00000,
  0xffffffffffe00000, 0xffffffffffe00000,
  0xffffffffffc00000, 0xffffffffffc00000,
  0xffffffffff800000, 0xffffffffff800000,
  0xfffffffffeffffff, 0xfffffffffeffffff,
  0xfffffffffdfffffe, 0xfffffffffdfffffe,
  0xfffffffffbfffffc, 0xfffffffffbfffffc,
  0xfffffffff7fffff8, 0xfffffffff7fffff8,
  0xffffffffeffffff0, 0xffffffffeffffff0,
  0xffffffffdfffffe0, 0xffffffffdfffffe0,
  0xffffffffbfffffc0, 0xffffffffbfffffc0,
  0xffffffff7fffff80, 0xffffffff7fffff80,
  0xfffffffeffffff00, 0xfffffffeffffff00,
  0xfffffffdfffffe00, 0xfffffffdfffffe00,
  0xfffffffbfffffc00, 0xfffffffbfffffc00,
  0xfffffff7fffff800, 0xfffffff7fffff800,
  0xffffffeffffff000, 0xffffffeffffff000,
  0xffffffdfffffe000, 0xffffffdfffffe000,
  0xffffffbfffffc000, 0xffffffbfffffc000,
  0xffffff7fffff8000, 0xffffff7fffff8000,
  0xfffffeffffff0000, 0xfffffeffffff0000,
  0xfffffdfffffe0000, 0xfffffdfffffe0000,
  0xfffffbfffffc0000, 0xfffffbfffffc0000,
  0xfffff7fffff80000, 0xfffff7fffff80000,
  0xffffeffffff00000, 0xffffeffffff00000,
  0xffffdfffffe00000, 0xffffdfffffe00000,
  0xffffbfffffc00000, 0xffffbfffffc00000,
  0xffff7fffff800000, 0xffff7fffff800000,
  0xfffeffffff000000, 0xfffeffffff000000,
  0xfffdfffffe000000, 0xfffdfffffe000000,
  0xfffbfffffc000000, 0xfffbfffffc000000,
  0xfff7fffff8000000, 0xfff7fffff8000000,
  0xffeffffff0000000, 0xffefffffefffffff,
  0xffdfffffe0000000, 0xffdfffffdffffffe,
  0xffbfffffc0000000, 0xffbfffffbffffffc,
  0xff7fffff80000000, 0xff7fffff7ffffff8,
  0xfeffffff00000000, 0xfefffffefffffff0,
  0xfdfffffe00000000, 0xfdfffffdffffffe0,
  0xfbfffffc00000000, 0xfbfffffbffffffc0,
  0xf7fffff800000000, 0xf7fffff7ffffff80,
  0xeffffff000000000, 0xefffffefffffff00,
  0xdfffffe000000000, 0xdfffffdffffffe00,
  0xbfffffc000000000, 0xbfffffbffffffc00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc0, 0xffffffffffffffc0,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff00, 0xffffffffffffff00,
  0xfffffffffffffe00, 0xfffffffffffffe00,
  0xfffffffffffffc00, 0xfffffffffffffc00,
  0xfffffffffffff800, 0xfffffffffffff800,
  0xfffffffffffff000, 0xfffffffffffff000,
  0xffffffffffffe000, 0xffffffffffffe000,
  0xffffffffffffc000, 0xffffffffffffc000,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff0000, 0xffffffffffff0000,
  0xfffffffffffe0000, 0xfffffffffffe0000,
  0xfffffffffffc0000, 0xfffffffffffc0000,
  0xfffffffffff80000, 0xfffffffffff80000,
  0xfffffffffff00000, 0xfffffffffff00000,
  0xffffffffffe00000, 0xffffffffffe00000,
  0xffffffffffc00000, 0xffffffffffc00000,
  0xffffffffff800000, 0xffffffffff7fffff,
  0xfffffffffeffffff, 0xfffffffffefffffe,
  0xfffffffffdfffffe, 0xfffffffffdfffffc,
  0xfffffffffbfffffc, 0xfffffffffbfffff8,
  0xfffffffff7fffff8, 0xfffffffff7fffff0,
  0xffffffffeffffff0, 0xffffffffefffffe0,
  0xffffffffdfffffe0, 0xffffffffdfffffc0,
  0xffffffffbfffffc0, 0xffffffffbfffff80,
  0xffffffff7fffff80, 0xffffffff7fffff00,
  0xfffffffeffffff00, 0xfffffffefffffe00,
  0xfffffffdfffffe00, 0xfffffffdfffffc00,
  0xfffffffbfffffc00, 0xfffffffbfffff800,
  0xfffffff7fffff800, 0xfffffff7fffff000,
  0xffffffeffffff000, 0xffffffefffffe000,
  0xffffffdfffffe000, 0xffffffdfffffc000,
  0xffffffbfffffc000, 0xffffffbfffff8000,
  0xffffff7fffff8000, 0xffffff7fffff0000,
  0xfffffeffffff0000, 0xfffffefffffe0000,
  0xfffffdfffffe0000, 0xfffffdfffffc0000,
  0xfffffbfffffc0000, 0xfffffbfffff80000,
  0xfffff7fffff80000, 0xfffff7fffff00000,
  0xffffeffffff00000, 0xffffefffffe00000,
  0xffffdfffffe00000, 0xffffdfffffc00000,
  0xffffbfffffc00000, 0xffffbfffff800000,
  0xffff7fffff800000, 0xffff7fffff000000,
  0xfffeffffff000000, 0xfffefffffe000000,
  0xfffdfffffe000000, 0xfffdfffffc000000,
  0xfffbfffffc000000, 0xfffbfffff8000000,
  0xfff7fffff8000000, 0xfff7fffff0000000,
  0xffefffffefffffff, 0xffefffffe0000000,
  0xffdfffffdffffffe, 0xffdfffffc0000000,
  0xffbfffffbffffffc, 0xffbfffff80000000,
  0xff7fffff7ffffff8, 0xff7fffff00000000,
  0xfefffffefffffff0, 0xfefffffe00000000,
  0xfdfffffdffffffe0, 0xfdfffffc00000000,
  0xfbfffffbffffffc0, 0xfbfffff800000000,
  0xf7fffff7ffffff80, 0xf7fffff000000000,
  0xefffffefffffff00, 0xefffffe000000000,
  0xdfffffdffffffe00, 0xdfffffc000000000,
  0xbfffffbffffffc00, 0xbfffff8000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc0, 0xffffffffffffffc0,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff00, 0xffffffffffffff00,
  0xfffffffffffffe00, 0xfffffffffffffe00,
  0xfffffffffffffc00, 0xfffffffffffffc00,
  0xfffffffffffff800, 0xfffffffffffff800,
  0xfffffffffffff000, 0xfffffffffffff000,
  0xffffffffffffe000, 0xffffffffffffe000,
  0xffffffffffffc000, 0xffffffffffffc000,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff0000, 0xffffffffffff0000,
  0xfffffffffffe0000, 0xfffffffffffe0000,
  0xfffffffffffc0000, 0xfffffffffffc0000,
  0xfffffffffff80000, 0xfffffffffff80000,
  0xfffffffffff00000, 0xfffffffffff00000,
  0xffffffffffe00000, 0xffffffffffe00000,
  0xffffffffffc00000, 0xffffffffffc00000,
  0xffffffffff7fffff, 0xffffffffff7fffff,
  0xfffffffffefffffe, 0xfffffffffefffffe,
  0xfffffffffdfffffc, 0xfffffffffdfffffc,
  0xfffffffffbfffff8, 0xfffffffffbfffff8,
  0xfffffffff7fffff0, 0xfffffffff7fffff0,
  0xffffffffefffffe0, 0xffffffffefffffe0,
  0xffffffffdfffffc0, 0xffffffffdfffffc0,
  0xffffffffbfffff80, 0xffffffffbfffff80,
  0xffffffff7fffff00, 0xffffffff7fffff00,
  0xfffffffefffffe00, 0xfffffffefffffe00,
  0xfffffffdfffffc00, 0xfffffffdfffffc00,
  0xfffffffbfffff800, 0xfffffffbfffff800,
  0xfffffff7fffff000, 0xfffffff7fffff000,
  0xffffffefffffe000, 0xffffffefffffe000,
  0xffffffdfffffc000, 0xffffffdfffffc000,
  0xffffffbfffff8000, 0xffffffbfffff8000,
  0xffffff7fffff0000, 0xffffff7fffff0000,
  0xfffffefffffe0000, 0xfffffefffffe0000,
  0xfffffdfffffc0000, 0xfffffdfffffc0000,
  0xfffffbfffff80000, 0xfffffbfffff80000,
  0xfffff7fffff00000, 0xfffff7fffff00000,
  0xffffefffffe00000, 0xffffefffffe00000,
  0xffffdfffffc00000, 0xffffdfffffc00000,
  0xffffbfffff800000, 0xffffbfffff800000,
  0xffff7fffff000000, 0xffff7fffff000000,
  0xfffefffffe000000, 0xfffefffffe000000,
  0xfffdfffffc000000, 0xfffdfffffc000000,
  0xfffbfffff8000000, 0xfffbfffff8000000,
  0xfff7fffff0000000, 0xfff7fffff0000000,
  0xffefffffe0000000, 0xffefffffdfffffff,
  0xffdfffffc0000000, 0xffdfffffbffffffe,
  0xffbfffff80000000, 0xffbfffff7ffffffc,
  0xff7fffff00000000, 0xff7ffffefffffff8,
  0xfefffffe00000000, 0xfefffffdfffffff0,
  0xfdfffffc00000000, 0xfdfffffbffffffe0,
  0xfbfffff800000000, 0xfbfffff7ffffffc0,
  0xf7fffff000000000, 0xf7ffffefffffff80,
  0xefffffe000000000, 0xefffffdfffffff00,
  0xdfffffc000000000, 0xdfffffbffffffe00,
  0xbfffff8000000000, 0xbfffff7ffffffc00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc0, 0xffffffffffffffc0,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff00, 0xffffffffffffff00,
  0xfffffffffffffe00, 0xfffffffffffffe00,
  0xfffffffffffffc00, 0xfffffffffffffc00,
  0xfffffffffffff800, 0xfffffffffffff800,
  0xfffffffffffff000, 0xfffffffffffff000,
  0xffffffffffffe000, 0xffffffffffffe000,
  0xffffffffffffc000, 0xffffffffffffc000,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff0000, 0xffffffffffff0000,
  0xfffffffffffe0000, 0xfffffffffffe0000,
  0xfffffffffffc0000, 0xfffffffffffc0000,
  0xfffffffffff80000, 0xfffffffffff80000,
  0xfffffffffff00000, 0xfffffffffff00000,
  0xffffffffffe00000, 0xffffffffffe00000,
  0xffffffffffc00000, 0xffffffffffc00000,
  0xffffffffff7fffff, 0xffffffffff7fffff,
  0xfffffffffefffffe, 0xfffffffffefffffd,
  0xfffffffffdfffffc, 0xfffffffffdfffffa,
  0xfffffffffbfffff8, 0xfffffffffbfffff4,
  0xfffffffff7fffff0, 0xfffffffff7ffffe8,
  0xffffffffefffffe0, 0xffffffffefffffd0,
  0xffffffffdfffffc0, 0xffffffffdfffffa0,
  0xffffffffbfffff80, 0xffffffffbfffff40,
  0xffffffff7fffff00, 0xffffffff7ffffe80,
  0xfffffffefffffe00, 0xfffffffefffffd00,
  0xfffffffdfffffc00, 0xfffffffdfffffa00,
  0xfffffffbfffff800, 0xfffffffbfffff400,
  0xfffffff7fffff000, 0xfffffff7ffffe800,
  0xffffffefffffe000, 0xffffffefffffd000,
  0xffffffdfffffc000, 0xffffffdfffffa000,
  0xffffffbfffff8000, 0xffffffbfffff4000,
  0xffffff7fffff0000, 0xffffff7ffffe8000,
  0xfffffefffffe0000, 0xfffffefffffd0000,
  0xfffffdfffffc0000, 0xfffffdfffffa0000,
  0xfffffbfffff80000, 0xfffffbfffff40000,
  0xfffff7fffff00000, 0xfffff7ffffe80000,
  0xffffefffffe00000, 0xffffefffffd00000,
  0xffffdfffffc00000, 0xffffdfffffa00000,
  0xffffbfffff800000, 0xffffbfffff400000,
  0xffff7fffff000000, 0xffff7ffffe800000,
  0xfffefffffe000000, 0xfffefffffd000000,
  0xfffdfffffc000000, 0xfffdfffffa000000,
  0xfffbfffff8000000, 0xfffbfffff4000000,
  0xfff7fffff0000000, 0xfff7ffffe8000000,
  0xffefffffdfffffff, 0xffefffffd0000000,
  0xffdfffffbffffffe, 0xffdfffffa0000000,
  0xffbfffff7ffffffc, 0xffbfffff40000000,
  0xff7ffffefffffff8, 0xff7ffffe80000000,
  0xfefffffdfffffff0, 0xfefffffd00000000,
  0xfdfffffbffffffe0, 0xfdfffffa00000000,
  0xfbfffff7ffffffc0, 0xfbfffff400000000,
  0xf7ffffefffffff80, 0xf7ffffe800000000,
  0xefffffdfffffff00, 0xefffffd000000000,
  0xdfffffbffffffe00, 0xdfffffa000000000,
  0xbfffff7ffffffc00, 0xbfffff4000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc0, 0xffffffffffffffc0,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff00, 0xffffffffffffff00,
  0xfffffffffffffe00, 0xfffffffffffffe00,
  0xfffffffffffffc00, 0xfffffffffffffc00,
  0xfffffffffffff800, 0xfffffffffffff800,
  0xfffffffffffff000, 0xfffffffffffff000,
  0xffffffffffffe000, 0xffffffffffffe000,
  0xffffffffffffc000, 0xffffffffffffc000,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff0000, 0xffffffffffff0000,
  0xfffffffffffe0000, 0xfffffffffffe0000,
  0xfffffffffffc0000, 0xfffffffffffc0000,
  0xfffffffffff80000, 0xfffffffffff80000,
  0xfffffffffff00000, 0xfffffffffff00000,
  0xffffffffffe00000, 0xffffffffffe00000,
  0xffffffffffc00000, 0xffffffffffc00000,
  0xffffffffff7fffff, 0xffffffffff7fffff,
  0xfffffffffefffffd, 0xfffffffffefffffd,
  0xfffffffffdfffffa, 0xfffffffffdfffffa,
  0xfffffffffbfffff4, 0xfffffffffbfffff4,
  0xfffffffff7ffffe8, 0xfffffffff7ffffe8,
  0xffffffffefffffd0, 0xffffffffefffffd0,
  0xffffffffdfffffa0, 0xffffffffdfffffa0,
  0xffffffffbfffff40, 0xffffffffbfffff40,
  0xffffffff7ffffe80, 0xffffffff7ffffe80,
  0xfffffffefffffd00, 0xfffffffefffffd00,
  0xfffffffdfffffa00, 0xfffffffdfffffa00,
  0xfffffffbfffff400, 0xfffffffbfffff400,
  0xfffffff7ffffe800, 0xfffffff7ffffe800,
  0xffffffefffffd000, 0xffffffefffffd000,
  0xffffffdfffffa000, 0xffffffdfffffa000,
  0xffffffbfffff4000, 0xffffffbfffff4000,
  0xffffff7ffffe8000, 0xffffff7ffffe8000,
  0xfffffefffffd0000, 0xfffffefffffd0000,
  0xfffffdfffffa0000, 0xfffffdfffffa0000,
  0xfffffbfffff40000, 0xfffffbfffff40000,
  0xfffff7ffffe80000, 0xfffff7ffffe80000,
  0xffffefffffd00000, 0xffffefffffd00000,
  0xffffdfffffa00000, 0xffffdfffffa00000,
  0xffffbfffff400000, 0xffffbfffff400000,
  0xffff7ffffe800000, 0xffff7ffffe800000,
  0xfffefffffd000000, 0xfffefffffd000000,
  0xfffdfffffa000000, 0xfffdfffffa000000,
  0xfffbfffff4000000, 0xfffbfffff4000000,
  0xfff7ffffe8000000, 0xfff7ffffe8000000,
  0xffefffffd0000000, 0xffefffffcfffffff,
  0xffdfffffa0000000, 0xffdfffff9ffffffe,
  0xffbfffff40000000, 0xffbfffff3ffffffc,
  0xff7ffffe80000000, 0xff7ffffe7ffffff8,
  0xfefffffd00000000, 0xfefffffcfffffff0,
  0xfdfffffa00000000, 0xfdfffff9ffffffe0,
  0xfbfffff400000000, 0xfbfffff3ffffffc0,
  0xf7ffffe800000000, 0xf7ffffe7ffffff80,
  0xefffffd000000000, 0xefffffcfffffff00,
  0xdfffffa000000000, 0xdfffff9ffffffe00,
  0xbfffff4000000000, 0xbfffff3ffffffc00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc0, 0xffffffffffffffc0,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff00, 0xffffffffffffff00,
  0xfffffffffffffe00, 0xfffffffffffffe00,
  0xfffffffffffffc00, 0xfffffffffffffc00,
  0xfffffffffffff800, 0xfffffffffffff800,
  0xfffffffffffff000, 0xfffffffffffff000,
  0xffffffffffffe000, 0xffffffffffffe000,
  0xffffffffffffc000, 0xffffffffffffc000,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff0000, 0xffffffffffff0000,
  0xfffffffffffe0000, 0xfffffffffffe0000,
  0xfffffffffffc0000, 0xfffffffffffc0000,
  0xfffffffffff80000, 0xfffffffffff80000,
  0xfffffffffff00000, 0xfffffffffff00000,
  0xffffffffffe00000, 0xffffffffffe00000,
  0xffffffffffc00000, 0xffffffffffbfffff,
  0xffffffffff7fffff, 0xffffffffff7ffffe,
  0xfffffffffefffffd, 0xfffffffffefffffc,
  0xfffffffffdfffffa, 0xfffffffffdfffff8,
  0xfffffffffbfffff4, 0xfffffffffbfffff0,
  0xfffffffff7ffffe8, 0xfffffffff7ffffe0,
  0xffffffffefffffd0, 0xffffffffefffffc0,
  0xffffffffdfffffa0, 0xffffffffdfffff80,
  0xffffffffbfffff40, 0xffffffffbfffff00,
  0xffffffff7ffffe80, 0xffffffff7ffffe00,
  0xfffffffefffffd00, 0xfffffffefffffc00,
  0xfffffffdfffffa00, 0xfffffffdfffff800,
  0xfffffffbfffff400, 0xfffffffbfffff000,
  0xfffffff7ffffe800, 0xfffffff7ffffe000,
  0xffffffefffffd000, 0xffffffefffffc000,
  0xffffffdfffffa000, 0xffffffdfffff8000,
  0xffffffbfffff4000, 0xffffffbfffff0000,
  0xffffff7ffffe8000, 0xffffff7ffffe0000,
  0xfffffefffffd0000, 0xfffffefffffc0000,
  0xfffffdfffffa0000, 0xfffffdfffff80000,
  0xfffffbfffff40000, 0xfffffbfffff00000,
  0xfffff7ffffe80000, 0xfffff7ffffe00000,
  0xffffefffffd00000, 0xffffefffffc00000,
  0xffffdfffffa00000, 0xffffdfffff800000,
  0xffffbfffff400000, 0xffffbfffff000000,
  0xffff7ffffe800000, 0xffff7ffffe000000,
  0xfffefffffd000000, 0xfffefffffc000000,
  0xfffdfffffa000000, 0xfffdfffff8000000,
  0xfffbfffff4000000, 0xfffbfffff0000000,
  0xfff7ffffe8000000, 0xfff7ffffe0000000,
  0xffefffffcfffffff, 0xffefffffc0000000,
  0xffdfffff9ffffffe, 0xffdfffff80000000,
  0xffbfffff3ffffffc, 0xffbfffff00000000,
  0xff7ffffe7ffffff8, 0xff7ffffe00000000,
  0xfefffffcfffffff0, 0xfefffffc00000000,
  0xfdfffff9ffffffe0, 0xfdfffff800000000,
  0xfbfffff3ffffffc0, 0xfbfffff000000000,
  0xf7ffffe7ffffff80, 0xf7ffffe000000000,
  0xefffffcfffffff00, 0xefffffc000000000,
  0xdfffff9ffffffe00, 0xdfffff8000000000,
  0xbfffff3ffffffc00, 0xbfffff0000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc0, 0xffffffffffffffc0,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff00, 0xffffffffffffff00,
  0xfffffffffffffe00, 0xfffffffffffffe00,
  0xfffffffffffffc00, 0xfffffffffffffc00,
  0xfffffffffffff800, 0xfffffffffffff800,
  0xfffffffffffff000, 0xfffffffffffff000,
  0xffffffffffffe000, 0xffffffffffffe000,
  0xffffffffffffc000, 0xffffffffffffc000,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff0000, 0xffffffffffff0000,
  0xfffffffffffe0000, 0xfffffffffffe0000,
  0xfffffffffffc0000, 0xfffffffffffc0000,
  0xfffffffffff80000, 0xfffffffffff80000,
  0xfffffffffff00000, 0xfffffffffff00000,
  0xffffffffffe00000, 0xffffffffffe00000,
  0xffffffffffbfffff, 0xffffffffffbfffff,
  0xffffffffff7ffffe, 0xffffffffff7ffffe,
  0xfffffffffefffffc, 0xfffffffffefffffc,
  0xfffffffffdfffff8, 0xfffffffffdfffff8,
  0xfffffffffbfffff0, 0xfffffffffbfffff0,
  0xfffffffff7ffffe0, 0xfffffffff7ffffe0,
  0xffffffffefffffc0, 0xffffffffefffffc0,
  0xffffffffdfffff80, 0xffffffffdfffff80,
  0xffffffffbfffff00, 0xffffffffbfffff00,
  0xffffffff7ffffe00, 0xffffffff7ffffe00,
  0xfffffffefffffc00, 0xfffffffefffffc00,
  0xfffffffdfffff800, 0xfffffffdfffff800,
  0xfffffffbfffff000, 0xfffffffbfffff000,
  0xfffffff7ffffe000, 0xfffffff7ffffe000,
  0xffffffefffffc000, 0xffffffefffffc000,
  0xffffffdfffff8000, 0xffffffdfffff8000,
  0xffffffbfffff0000, 0xffffffbfffff0000,
  0xffffff7ffffe0000, 0xffffff7ffffe0000,
  0xfffffefffffc0000, 0xfffffefffffc0000,
  0xfffffdfffff80000, 0xfffffdfffff80000,
  0xfffffbfffff00000, 0xfffffbfffff00000,
  0xfffff7ffffe00000, 0xfffff7ffffe00000,
  0xffffefffffc00000, 0xffffefffffc00000,
  0xffffdfffff800000, 0xffffdfffff800000,
  0xffffbfffff000000, 0xffffbfffff000000,
  0xffff7ffffe000000, 0xffff7ffffe000000,
  0xfffefffffc000000, 0xfffefffffc000000,
  0xfffdfffff8000000, 0xfffdfffff8000000,
  0xfffbfffff0000000, 0xfffbfffff0000000,
  0xfff7ffffe0000000, 0xfff7ffffe0000000,
  0xffefffffc0000000, 0xffefffffbfffffff,
  0xffdfffff80000000, 0xffdfffff7ffffffe,
  0xffbfffff00000000, 0xffbffffefffffffc,
  0xff7ffffe00000000, 0xff7ffffdfffffff8,
  0xfefffffc00000000, 0xfefffffbfffffff0,
  0xfdfffff800000000, 0xfdfffff7ffffffe0,
  0xfbfffff000000000, 0xfbffffefffffffc0,
  0xf7ffffe000000000, 0xf7ffffdfffffff80,
  0xefffffc000000000, 0xefffffbfffffff00,
  0xdfffff8000000000, 0xdfffff7ffffffe00,
  0xbfffff0000000000, 0xbffffefffffffc00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc0, 0xffffffffffffffc0,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff00, 0xffffffffffffff00,
  0xfffffffffffffe00, 0xfffffffffffffe00,
  0xfffffffffffffc00, 0xfffffffffffffc00,
  0xfffffffffffff800, 0xfffffffffffff800,
  0xfffffffffffff000, 0xfffffffffffff000,
  0xffffffffffffe000, 0xffffffffffffe000,
  0xffffffffffffc000, 0xffffffffffffc000,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff0000, 0xffffffffffff0000,
  0xfffffffffffe0000, 0xfffffffffffe0000,
  0xfffffffffffc0000, 0xfffffffffffc0000,
  0xfffffffffff80000, 0xfffffffffff80000,
  0xfffffffffff00000, 0xfffffffffff00000,
  0xffffffffffe00000, 0xffffffffffe00000,
  0xffffffffffbfffff, 0xffffffffffbfffff,
  0xffffffffff7ffffe, 0xffffffffff7ffffe,
  0xfffffffffefffffc, 0xfffffffffefffffb,
  0xfffffffffdfffff8, 0xfffffffffdfffff6,
  0xfffffffffbfffff0, 0xfffffffffbffffec,
  0xfffffffff7ffffe0, 0xfffffffff7ffffd8,
  0xffffffffefffffc0, 0xffffffffefffffb0,
  0xffffffffdfffff80, 0xffffffffdfffff60,
  0xffffffffbfffff00, 0xffffffffbffffec0,
  0xffffffff7ffffe00, 0xffffffff7ffffd80,
  0xfffffffefffffc00, 0xfffffffefffffb00,
  0xfffffffdfffff800, 0xfffffffdfffff600,
  0xfffffffbfffff000, 0xfffffffbffffec00,
  0xfffffff7ffffe000, 0xfffffff7ffffd800,
  0xffffffefffffc000, 0xffffffefffffb000,
  0xffffffdfffff8000, 0xffffffdfffff6000,
  0xffffffbfffff0000, 0xffffffbffffec000,
  0xffffff7ffffe0000, 0xffffff7ffffd8000,
  0xfffffefffffc0000, 0xfffffefffffb0000,
  0xfffffdfffff80000, 0xfffffdfffff60000,
  0xfffffbfffff00000, 0xfffffbffffec0000,
  0xfffff7ffffe00000, 0xfffff7ffffd80000,
  0xffffefffffc00000, 0xffffefffffb00000,
  0xffffdfffff800000, 0xffffdfffff600000,
  0xffffbfffff000000, 0xffffbffffec00000,
  0xffff7ffffe000000, 0xffff7ffffd800000,
  0xfffefffffc000000, 0xfffefffffb000000,
  0xfffdfffff8000000, 0xfffdfffff6000000,
  0xfffbfffff0000000, 0xfffbffffec000000,
  0xfff7ffffe0000000, 0xfff7ffffd8000000,
  0xffefffffbfffffff, 0xffefffffb0000000,
  0xffdfffff7ffffffe, 0xffdfffff60000000,
  0xffbffffefffffffc, 0xffbffffec0000000,
  0xff7ffffdfffffff8, 0xff7ffffd80000000,
  0xfefffffbfffffff0, 0xfefffffb00000000,
  0xfdfffff7ffffffe0, 0xfdfffff600000000,
  0xfbffffefffffffc0, 0xfbffffec00000000,
  0xf7ffffdfffffff80, 0xf7ffffd800000000,
  0xefffffbfffffff00, 0xefffffb000000000,
  0xdfffff7ffffffe00, 0xdfffff6000000000,
  0xbffffefffffffc00, 0xbffffec000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc0, 0xffffffffffffffc0,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff00, 0xffffffffffffff00,
  0xfffffffffffffe00, 0xfffffffffffffe00,
  0xfffffffffffffc00, 0xfffffffffffffc00,
  0xfffffffffffff800, 0xfffffffffffff800,
  0xfffffffffffff000, 0xfffffffffffff000,
  0xffffffffffffe000, 0xffffffffffffe000,
  0xffffffffffffc000, 0xffffffffffffc000,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff0000, 0xffffffffffff0000,
  0xfffffffffffe0000, 0xfffffffffffe0000,
  0xfffffffffffc0000, 0xfffffffffffc0000,
  0xfffffffffff80000, 0xfffffffffff80000,
  0xfffffffffff00000, 0xfffffffffff00000,
  0xffffffffffe00000, 0xffffffffffe00000,
  0xffffffffffbfffff, 0xffffffffffbfffff,
  0xffffffffff7ffffe, 0xffffffffff7ffffe,
  0xfffffffffefffffb, 0xfffffffffefffffb,
  0xfffffffffdfffff6, 0xfffffffffdfffff6,
  0xfffffffffbffffec, 0xfffffffffbffffec,
  0xfffffffff7ffffd8, 0xfffffffff7ffffd8,
  0xffffffffefffffb0, 0xffffffffefffffb0,
  0xffffffffdfffff60, 0xffffffffdfffff60,
  0xffffffffbffffec0, 0xffffffffbffffec0,
  0xffffffff7ffffd80, 0xffffffff7ffffd80,
  0xfffffffefffffb00, 0xfffffffefffffb00,
  0xfffffffdfffff600, 0xfffffffdfffff600,
  0xfffffffbffffec00, 0xfffffffbffffec00,
  0xfffffff7ffffd800, 0xfffffff7ffffd800,
  0xffffffefffffb000, 0xffffffefffffb000,
  0xffffffdfffff6000, 0xffffffdfffff6000,
  0xffffffbffffec000, 0xffffffbffffec000,
  0xffffff7ffffd8000, 0xffffff7ffffd8000,
  0xfffffefffffb0000, 0xfffffefffffb0000,
  0xfffffdfffff60000, 0xfffffdfffff60000,
  0xfffffbffffec0000, 0xfffffbffffec0000,
  0xfffff7ffffd80000, 0xfffff7ffffd80000,
  0xffffefffffb00000, 0xffffefffffb00000,
  0xffffdfffff600000, 0xffffdfffff600000,
  0xffffbffffec00000, 0xffffbffffec00000,
  0xffff7ffffd800000, 0xffff7ffffd800000,
  0xfffefffffb000000, 0xfffefffffb000000,
  0xfffdfffff6000000, 0xfffdfffff6000000,
  0xfffbffffec000000, 0xfffbffffec000000,
  0xfff7ffffd8000000, 0xfff7ffffd8000000,
  0xffefffffb0000000, 0xffefffffafffffff,
  0xffdfffff60000000, 0xffdfffff5ffffffe,
  0xffbffffec0000000, 0xffbffffebffffffc,
  0xff7ffffd80000000, 0xff7ffffd7ffffff8,
  0xfefffffb00000000, 0xfefffffafffffff0,
  0xfdfffff600000000, 0xfdfffff5ffffffe0,
  0xfbffffec00000000, 0xfbffffebffffffc0,
  0xf7ffffd800000000, 0xf7ffffd7ffffff80,
  0xefffffb000000000, 0xefffffafffffff00,
  0xdfffff6000000000, 0xdfffff5ffffffe00,
  0xbffffec000000000, 0xbffffebffffffc00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc0, 0xffffffffffffffc0,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff00, 0xffffffffffffff00,
  0xfffffffffffffe00, 0xfffffffffffffe00,
  0xfffffffffffffc00, 0xfffffffffffffc00,
  0xfffffffffffff800, 0xfffffffffffff800,
  0xfffffffffffff000, 0xfffffffffffff000,
  0xffffffffffffe000, 0xffffffffffffe000,
  0xffffffffffffc000, 0xffffffffffffc000,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff0000, 0xffffffffffff0000,
  0xfffffffffffe0000, 0xfffffffffffe0000,
  0xfffffffffffc0000, 0xfffffffffffc0000,
  0xfffffffffff80000, 0xfffffffffff80000,
  0xfffffffffff00000, 0xfffffffffff00000,
  0xffffffffffe00000, 0xffffffffffe00000,
  0xffffffffffbfffff, 0xffffffffffbfffff,
  0xffffffffff7ffffe, 0xffffffffff7ffffd,
  0xfffffffffefffffb, 0xfffffffffefffffa,
  0xfffffffffdfffff6, 0xfffffffffdfffff4,
  0xfffffffffbffffec, 0xfffffffffbffffe8,
  0xfffffffff7ffffd8, 0xfffffffff7ffffd0,
  0xffffffffefffffb0, 0xffffffffefffffa0,
  0xffffffffdfffff60, 0xffffffffdfffff40,
  0xffffffffbffffec0, 0xffffffffbffffe80,
  0xffffffff7ffffd80, 0xffffffff7ffffd00,
  0xfffffffefffffb00, 0xfffffffefffffa00,
  0xfffffffdfffff600, 0xfffffffdfffff400,
  0xfffffffbffffec00, 0xfffffffbffffe800,
  0xfffffff7ffffd800, 0xfffffff7ffffd000,
  0xffffffefffffb000, 0xffffffefffffa000,
  0xffffffdfffff6000, 0xffffffdfffff4000,
  0xffffffbffffec000, 0xffffffbffffe8000,
  0xffffff7ffffd8000, 0xffffff7ffffd0000,
  0xfffffefffffb0000, 0xfffffefffffa0000,
  0xfffffdfffff60000, 0xfffffdfffff40000,
  0xfffffbffffec0000, 0xfffffbffffe80000,
  0xfffff7ffffd80000, 0xfffff7ffffd00000,
  0xffffefffffb00000, 0xffffefffffa00000,
  0xffffdfffff600000, 0xffffdfffff400000,
  0xffffbffffec00000, 0xffffbffffe800000,
  0xffff7ffffd800000, 0xffff7ffffd000000,
  0xfffefffffb000000, 0xfffefffffa000000,
  0xfffdfffff6000000, 0xfffdfffff4000000,
  0xfffbffffec000000, 0xfffbffffe8000000,
  0xfff7ffffd8000000, 0xfff7ffffd0000000,
  0xffefffffafffffff, 0xffefffffa0000000,
  0xffdfffff5ffffffe, 0xffdfffff40000000,
  0xffbffffebffffffc, 0xffbffffe80000000,
  0xff7ffffd7ffffff8, 0xff7ffffd00000000,
  0xfefffffafffffff0, 0xfefffffa00000000,
  0xfdfffff5ffffffe0, 0xfdfffff400000000,
  0xfbffffebffffffc0, 0xfbffffe800000000,
  0xf7ffffd7ffffff80, 0xf7ffffd000000000,
  0xefffffafffffff00, 0xefffffa000000000,
  0xdfffff5ffffffe00, 0xdfffff4000000000,
  0xbffffebffffffc00, 0xbffffe8000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xfffffffffffffffe, 0xffffffffffffffff,
  0xfffffffffffffffc, 0xfffffffffffffffd,
  0xfffffffffffffff8, 0xfffffffffffffff9,
  0xfffffffffffffff0, 0xfffffffffffffff1,
  0xffffffffffffffe0, 0xffffffffffffffe1,
  0xffffffffffffffc0, 0xffffffffffffffc1,
  0xffffffffffffff80, 0xffffffffffffff81,
  0xffffffffffffff00, 0xffffffffffffff01,
  0xfffffffffffffe00, 0xfffffffffffffe01,
  0xfffffffffffffc00, 0xfffffffffffffc01,
  0xfffffffffffff800, 0xfffffffffffff801,
  0xfffffffffffff000, 0xfffffffffffff001,
  0xffffffffffffe000, 0xffffffffffffe001,
  0xffffffffffffc000, 0xffffffffffffc001,
  0xffffffffffff8000, 0xffffffffffff8001,
  0xffffffffffff0000, 0xffffffffffff0001,
  0xfffffffffffe0000, 0xfffffffffffe0001,
  0xfffffffffffc0000, 0xfffffffffffc0001,
  0xfffffffffff80000, 0xfffffffffff80001,
  0xfffffffffff00000, 0xfffffffffff00001,
  0xffffffffffe00000, 0xffffffffffe00001,
  0xffffffffffbfffff, 0xffffffffffc00001,
  0xffffffffff7ffffd, 0xffffffffff800001,
  0xfffffffffefffffa, 0xffffffffff000001,
  0xfffffffffdfffff4, 0xfffffffffe000001,
  0xfffffffffbffffe8, 0xfffffffffc000002,
  0xfffffffff7ffffd0, 0xfffffffff8000004,
  0xffffffffefffffa0, 0xfffffffff0000008,
  0xffffffffdfffff40, 0xffffffffe0000010,
  0xffffffffbffffe80, 0xffffffffc0000020,
  0xffffffff7ffffd00, 0xffffffff80000040,
  0xfffffffefffffa00, 0xffffffff00000080,
  0xfffffffdfffff400, 0xfffffffe00000100,
  0xfffffffbffffe800, 0xfffffffc00000200,
  0xfffffff7ffffd000, 0xfffffff800000400,
  0xffffffefffffa000, 0xfffffff000000800,
  0xffffffdfffff4000, 0xffffffe000001000,
  0xffffffbffffe8000, 0xffffffc000002000,
  0xffffff7ffffd0000, 0xffffff8000004000,
  0xfffffefffffa0000, 0xffffff0000008000,
  0xfffffdfffff40000, 0xfffffe0000010000,
  0xfffffbffffe80000, 0xfffffc0000020000,
  0xfffff7ffffd00000, 0xfffff80000040000,
  0xffffefffffa00000, 0xfffff00000080000,
  0xffffdfffff400000, 0xffffe00000100000,
  0xffffbffffe800000, 0xffffc00000200000,
  0xffff7ffffd000000, 0xffff800000400000,
  0xfffefffffa000000, 0xffff000000800000,
  0xfffdfffff4000000, 0xfffe000001000000,
  0xfffbffffe8000000, 0xfffc000002000000,
  0xfff7ffffd0000000, 0xfff8000004000000,
  0xffefffffa0000000, 0xfff0000008000000,
  0xffdfffff40000000, 0xffe0000010000000,
  0xffbffffe80000000, 0xffc0000020000000,
  0xff7ffffd00000000, 0xff80000040000000,
  0xfefffffa00000000, 0xff00000080000000,
  0xfdfffff400000000, 0xfe00000100000000,
  0xfbffffe800000000, 0xfc00000200000000,
  0xf7ffffd000000000, 0xf800000400000000,
  0xefffffa000000000, 0xf000000800000000,
  0xdfffff4000000000, 0xe000001000000000,
  0xbffffe8000000000, 0xc000002000000000,
  0x8000000000000000, 0x8000004000000000,
  0x8000000000000000, 0x8000000000000000,
  0x0000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0x8000000000000000,
  0xfffffffffffffffd, 0x8000000000000000,
  0xfffffffffffffff9, 0x8000000000000000,
  0xfffffffffffffff1, 0x8000000000000000,
  0xffffffffffffffe1, 0x8000000000000000,
  0xffffffffffffffc1, 0x8000000000000000,
  0xffffffffffffff81, 0x8000000000000000,
  0xffffffffffffff01, 0x8000000000000000,
  0xfffffffffffffe01, 0x8000000000000000,
  0xfffffffffffffc01, 0x8000000000000000,
  0xfffffffffffff801, 0x8000000000000000,
  0xfffffffffffff001, 0x8000000000000000,
  0xffffffffffffe001, 0x8000000000000000,
  0xffffffffffffc001, 0x8000000000000000,
  0xffffffffffff8001, 0x8000000000000000,
  0xffffffffffff0001, 0x8000000000000000,
  0xfffffffffffe0001, 0x8000000000000000,
  0xfffffffffffc0001, 0x8000000000000000,
  0xfffffffffff80001, 0x8000000000000000,
  0xfffffffffff00001, 0x8000000000000000,
  0xffffffffffe00001, 0x8000000000000000,
  0xffffffffffc00001, 0x8000000000000000,
  0xffffffffff800001, 0x8000000000000000,
  0xffffffffff000001, 0x8000000000000000,
  0xfffffffffe000001, 0x8000000000000000,
  0xfffffffffc000002, 0x8000000000000000,
  0xfffffffff8000004, 0x8000000000000000,
  0xfffffffff0000008, 0x8000000000000000,
  0xffffffffe0000010, 0x8000000000000000,
  0xffffffffc0000020, 0x8000000000000000,
  0xffffffff80000040, 0x8000000000000000,
  0xffffffff00000080, 0x8000000000000000,
  0xfffffffe00000100, 0x8000000000000000,
  0xfffffffc00000200, 0x8000000000000000,
  0xfffffff800000400, 0x8000000000000000,
  0xfffffff000000800, 0x8000000000000000,
  0xffffffe000001000, 0x8000000000000000,
  0xffffffc000002000, 0x8000000000000000,
  0xffffff8000004000, 0x8000000000000000,
  0xffffff0000008000, 0x8000000000000000,
  0xfffffe0000010000, 0x8000000000000000,
  0xfffffc0000020000, 0x8000000000000000,
  0xfffff80000040000, 0x8000000000000000,
  0xfffff00000080000, 0x8000000000000000,
  0xffffe00000100000, 0x8000000000000000,
  0xffffc00000200000, 0x8000000000000000,
  0xffff800000400000, 0x8000000000000000,
  0xffff000000800000, 0x8000000000000000,
  0xfffe000001000000, 0x8000000000000000,
  0xfffc000002000000, 0x8000000000000000,
  0xfff8000004000000, 0x8000000000000000,
  0xfff0000008000000, 0x8000000000000000,
  0xffe0000010000000, 0x8000000000000000,
  0xffc0000020000000, 0x8000000000000000,
  0xff80000040000000, 0x8000000000000000,
  0xff00000080000000, 0x8000000000000000,
  0xfe00000100000000, 0x8000000000000000,
  0xfc00000200000000, 0x8000000000000000,
  0xf800000400000000, 0x8000000000000000,
  0xf000000800000000, 0x8000000000000000,
  0xe000001000000000, 0x8000000000000000,
  0xc000002000000000, 0x8000000000000000,
  0x8000004000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0010000000000000,
  0x0000000000000000, 0x0020000000000000,
  0x0000000000000000, 0x0040000000000000,
  0x0000000000000000, 0x0080000000000000,
  0x0000000000000000, 0x0100000000000000,
  0x0000000000000000, 0x0200000000000000,
  0x0000000000000000, 0x0400000000000000,
  0x0000000000000000, 0x0800000000000000,
  0x0000000000000000, 0x1000000000000000,
  0x0000000000000000, 0x2000000000000000,
  0x0000000000000000, 0x4000000000000000,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0000000000000000, 0x7fffffffffffffff,
  0x0010000000000000, 0x0010000000000001,
  0x0020000000000000, 0x0020000000000002,
  0x0040000000000000, 0x0040000000000004,
  0x0080000000000000, 0x0080000000000008,
  0x0100000000000000, 0x0100000000000010,
  0x0200000000000000, 0x0200000000000020,
  0x0400000000000000, 0x0400000000000040,
  0x0800000000000000, 0x0800000000000080,
  0x1000000000000000, 0x1000000000000100,
  0x2000000000000000, 0x2000000000000200,
  0x4000000000000000, 0x4000000000000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0010000000000001, 0x0010000000000002,
  0x0020000000000002, 0x0020000000000004,
  0x0040000000000004, 0x0040000000000008,
  0x0080000000000008, 0x0080000000000010,
  0x0100000000000010, 0x0100000000000020,
  0x0200000000000020, 0x0200000000000040,
  0x0400000000000040, 0x0400000000000080,
  0x0800000000000080, 0x0800000000000100,
  0x1000000000000100, 0x1000000000000200,
  0x2000000000000200, 0x2000000000000400,
  0x4000000000000400, 0x4000000000000800,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0010000000000002, 0x0010000000000003,
  0x0020000000000004, 0x0020000000000006,
  0x0040000000000008, 0x004000000000000c,
  0x0080000000000010, 0x0080000000000018,
  0x0100000000000020, 0x0100000000000030,
  0x0200000000000040, 0x0200000000000060,
  0x0400000000000080, 0x04000000000000c0,
  0x0800000000000100, 0x0800000000000180,
  0x1000000000000200, 0x1000000000000300,
  0x2000000000000400, 0x2000000000000600,
  0x4000000000000800, 0x4000000000000c00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0010000000000003, 0x001fedcba9876543,
  0x0020000000000006, 0x003fdb97530eca86,
  0x004000000000000c, 0x007fb72ea61d950c,
  0x0080000000000018, 0x00ff6e5d4c3b2a18,
  0x0100000000000030, 0x01fedcba98765430,
  0x0200000000000060, 0x03fdb97530eca860,
  0x04000000000000c0, 0x07fb72ea61d950c0,
  0x0800000000000180, 0x0ff6e5d4c3b2a180,
  0x1000000000000300, 0x1fedcba987654300,
  0x2000000000000600, 0x3fdb97530eca8600,
  0x4000000000000c00, 0x7fb72ea61d950c00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x001fedcba9876543, 0x001ffffffffffffc,
  0x003fdb97530eca86, 0x003ffffffffffff8,
  0x007fb72ea61d950c, 0x007ffffffffffff0,
  0x00ff6e5d4c3b2a18, 0x00ffffffffffffe0,
  0x01fedcba98765430, 0x01ffffffffffffc0,
  0x03fdb97530eca860, 0x03ffffffffffff80,
  0x07fb72ea61d950c0, 0x07ffffffffffff00,
  0x0ff6e5d4c3b2a180, 0x0ffffffffffffe00,
  0x1fedcba987654300, 0x1ffffffffffffc00,
  0x3fdb97530eca8600, 0x3ffffffffffff800,
  0x7fb72ea61d950c00, 0x7ffffffffffff000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x001ffffffffffffc, 0x001ffffffffffffd,
  0x003ffffffffffff8, 0x003ffffffffffffa,
  0x007ffffffffffff0, 0x007ffffffffffff4,
  0x00ffffffffffffe0, 0x00ffffffffffffe8,
  0x01ffffffffffffc0, 0x01ffffffffffffd0,
  0x03ffffffffffff80, 0x03ffffffffffffa0,
  0x07ffffffffffff00, 0x07ffffffffffff40,
  0x0ffffffffffffe00, 0x0ffffffffffffe80,
  0x1ffffffffffffc00, 0x1ffffffffffffd00,
  0x3ffffffffffff800, 0x3ffffffffffffa00,
  0x7ffffffffffff000, 0x7ffffffffffff400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x001ffffffffffffd, 0x001ffffffffffffe,
  0x003ffffffffffffa, 0x003ffffffffffffc,
  0x007ffffffffffff4, 0x007ffffffffffff8,
  0x00ffffffffffffe8, 0x00fffffffffffff0,
  0x01ffffffffffffd0, 0x01ffffffffffffe0,
  0x03ffffffffffffa0, 0x03ffffffffffffc0,
  0x07ffffffffffff40, 0x07ffffffffffff80,
  0x0ffffffffffffe80, 0x0fffffffffffff00,
  0x1ffffffffffffd00, 0x1ffffffffffffe00,
  0x3ffffffffffffa00, 0x3ffffffffffffc00,
  0x7ffffffffffff400, 0x7ffffffffffff800,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x001ffffffffffffe, 0x001fffffffffffff,
  0x003ffffffffffffc, 0x003ffffffffffffe,
  0x007ffffffffffff8, 0x007ffffffffffffc,
  0x00fffffffffffff0, 0x00fffffffffffff8,
  0x01ffffffffffffe0, 0x01fffffffffffff0,
  0x03ffffffffffffc0, 0x03ffffffffffffe0,
  0x07ffffffffffff80, 0x07ffffffffffffc0,
  0x0fffffffffffff00, 0x0fffffffffffff80,
  0x1ffffffffffffe00, 0x1fffffffffffff00,
  0x3ffffffffffffc00, 0x3ffffffffffffe00,
  0x7ffffffffffff800, 0x7ffffffffffffc00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x001fffffffffffff, 0x0008000000000000,
  0x003ffffffffffffe, 0x0010000000000000,
  0x007ffffffffffffc, 0x0020000000000000,
  0x00fffffffffffff8, 0x0040000000000000,
  0x01fffffffffffff0, 0x0080000000000000,
  0x03ffffffffffffe0, 0x0100000000000000,
  0x07ffffffffffffc0, 0x0200000000000000,
  0x0fffffffffffff80, 0x0400000000000000,
  0x1fffffffffffff00, 0x0800000000000000,
  0x3ffffffffffffe00, 0x1000000000000000,
  0x7ffffffffffffc00, 0x2000000000000000,
  0x7fffffffffffffff, 0x4000000000000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0008000000000000, 0x0008000000000000,
  0x0010000000000000, 0x0010000000000001,
  0x0020000000000000, 0x0020000000000002,
  0x0040000000000000, 0x0040000000000004,
  0x0080000000000000, 0x0080000000000008,
  0x0100000000000000, 0x0100000000000010,
  0x0200000000000000, 0x0200000000000020,
  0x0400000000000000, 0x0400000000000040,
  0x0800000000000000, 0x0800000000000080,
  0x1000000000000000, 0x1000000000000100,
  0x2000000000000000, 0x2000000000000200,
  0x4000000000000000, 0x4000000000000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0008000000000000, 0x0008000000000001,
  0x0010000000000001, 0x0010000000000002,
  0x0020000000000002, 0x0020000000000004,
  0x0040000000000004, 0x0040000000000008,
  0x0080000000000008, 0x0080000000000010,
  0x0100000000000010, 0x0100000000000020,
  0x0200000000000020, 0x0200000000000040,
  0x0400000000000040, 0x0400000000000080,
  0x0800000000000080, 0x0800000000000100,
  0x1000000000000100, 0x1000000000000200,
  0x2000000000000200, 0x2000000000000400,
  0x4000000000000400, 0x4000000000000800,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0008000000000001, 0x0008000000000001,
  0x0010000000000002, 0x0010000000000003,
  0x0020000000000004, 0x0020000000000006,
  0x0040000000000008, 0x004000000000000c,
  0x0080000000000010, 0x0080000000000018,
  0x0100000000000020, 0x0100000000000030,
  0x0200000000000040, 0x0200000000000060,
  0x0400000000000080, 0x04000000000000c0,
  0x0800000000000100, 0x0800000000000180,
  0x1000000000000200, 0x1000000000000300,
  0x2000000000000400, 0x2000000000000600,
  0x4000000000000800, 0x4000000000000c00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0008000000000001, 0x000ff6e5d4c3b2a1,
  0x0010000000000003, 0x001fedcba9876543,
  0x0020000000000006, 0x003fdb97530eca86,
  0x004000000000000c, 0x007fb72ea61d950c,
  0x0080000000000018, 0x00ff6e5d4c3b2a18,
  0x0100000000000030, 0x01fedcba98765430,
  0x0200000000000060, 0x03fdb97530eca860,
  0x04000000000000c0, 0x07fb72ea61d950c0,
  0x0800000000000180, 0x0ff6e5d4c3b2a180,
  0x1000000000000300, 0x1fedcba987654300,
  0x2000000000000600, 0x3fdb97530eca8600,
  0x4000000000000c00, 0x7fb72ea61d950c00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000ff6e5d4c3b2a1, 0x000ffffffffffffe,
  0x001fedcba9876543, 0x001ffffffffffffc,
  0x003fdb97530eca86, 0x003ffffffffffff8,
  0x007fb72ea61d950c, 0x007ffffffffffff0,
  0x00ff6e5d4c3b2a18, 0x00ffffffffffffe0,
  0x01fedcba98765430, 0x01ffffffffffffc0,
  0x03fdb97530eca860, 0x03ffffffffffff80,
  0x07fb72ea61d950c0, 0x07ffffffffffff00,
  0x0ff6e5d4c3b2a180, 0x0ffffffffffffe00,
  0x1fedcba987654300, 0x1ffffffffffffc00,
  0x3fdb97530eca8600, 0x3ffffffffffff800,
  0x7fb72ea61d950c00, 0x7ffffffffffff000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000ffffffffffffe, 0x000ffffffffffffe,
  0x001ffffffffffffc, 0x001ffffffffffffd,
  0x003ffffffffffff8, 0x003ffffffffffffa,
  0x007ffffffffffff0, 0x007ffffffffffff4,
  0x00ffffffffffffe0, 0x00ffffffffffffe8,
  0x01ffffffffffffc0, 0x01ffffffffffffd0,
  0x03ffffffffffff80, 0x03ffffffffffffa0,
  0x07ffffffffffff00, 0x07ffffffffffff40,
  0x0ffffffffffffe00, 0x0ffffffffffffe80,
  0x1ffffffffffffc00, 0x1ffffffffffffd00,
  0x3ffffffffffff800, 0x3ffffffffffffa00,
  0x7ffffffffffff000, 0x7ffffffffffff400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000ffffffffffffe, 0x000fffffffffffff,
  0x001ffffffffffffd, 0x001ffffffffffffe,
  0x003ffffffffffffa, 0x003ffffffffffffc,
  0x007ffffffffffff4, 0x007ffffffffffff8,
  0x00ffffffffffffe8, 0x00fffffffffffff0,
  0x01ffffffffffffd0, 0x01ffffffffffffe0,
  0x03ffffffffffffa0, 0x03ffffffffffffc0,
  0x07ffffffffffff40, 0x07ffffffffffff80,
  0x0ffffffffffffe80, 0x0fffffffffffff00,
  0x1ffffffffffffd00, 0x1ffffffffffffe00,
  0x3ffffffffffffa00, 0x3ffffffffffffc00,
  0x7ffffffffffff400, 0x7ffffffffffff800,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000fffffffffffff, 0x000fffffffffffff,
  0x001ffffffffffffe, 0x001fffffffffffff,
  0x003ffffffffffffc, 0x003ffffffffffffe,
  0x007ffffffffffff8, 0x007ffffffffffffc,
  0x00fffffffffffff0, 0x00fffffffffffff8,
  0x01ffffffffffffe0, 0x01fffffffffffff0,
  0x03ffffffffffffc0, 0x03ffffffffffffe0,
  0x07ffffffffffff80, 0x07ffffffffffffc0,
  0x0fffffffffffff00, 0x0fffffffffffff80,
  0x1ffffffffffffe00, 0x1fffffffffffff00,
  0x3ffffffffffffc00, 0x3ffffffffffffe00,
  0x7ffffffffffff800, 0x7ffffffffffffc00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000fffffffffffff, 0x0004000000000000,
  0x001fffffffffffff, 0x0008000000000000,
  0x003ffffffffffffe, 0x0010000000000000,
  0x007ffffffffffffc, 0x0020000000000000,
  0x00fffffffffffff8, 0x0040000000000000,
  0x01fffffffffffff0, 0x0080000000000000,
  0x03ffffffffffffe0, 0x0100000000000000,
  0x07ffffffffffffc0, 0x0200000000000000,
  0x0fffffffffffff80, 0x0400000000000000,
  0x1fffffffffffff00, 0x0800000000000000,
  0x3ffffffffffffe00, 0x1000000000000000,
  0x7ffffffffffffc00, 0x2000000000000000,
  0x7fffffffffffffff, 0x4000000000000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0004000000000000, 0x0004000000000000,
  0x0008000000000000, 0x0008000000000000,
  0x0010000000000000, 0x0010000000000001,
  0x0020000000000000, 0x0020000000000002,
  0x0040000000000000, 0x0040000000000004,
  0x0080000000000000, 0x0080000000000008,
  0x0100000000000000, 0x0100000000000010,
  0x0200000000000000, 0x0200000000000020,
  0x0400000000000000, 0x0400000000000040,
  0x0800000000000000, 0x0800000000000080,
  0x1000000000000000, 0x1000000000000100,
  0x2000000000000000, 0x2000000000000200,
  0x4000000000000000, 0x4000000000000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0004000000000000, 0x0004000000000000,
  0x0008000000000000, 0x0008000000000001,
  0x0010000000000001, 0x0010000000000002,
  0x0020000000000002, 0x0020000000000004,
  0x0040000000000004, 0x0040000000000008,
  0x0080000000000008, 0x0080000000000010,
  0x0100000000000010, 0x0100000000000020,
  0x0200000000000020, 0x0200000000000040,
  0x0400000000000040, 0x0400000000000080,
  0x0800000000000080, 0x0800000000000100,
  0x1000000000000100, 0x1000000000000200,
  0x2000000000000200, 0x2000000000000400,
  0x4000000000000400, 0x4000000000000800,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0004000000000000, 0x0004000000000000,
  0x0008000000000001, 0x0008000000000001,
  0x0010000000000002, 0x0010000000000003,
  0x0020000000000004, 0x0020000000000006,
  0x0040000000000008, 0x004000000000000c,
  0x0080000000000010, 0x0080000000000018,
  0x0100000000000020, 0x0100000000000030,
  0x0200000000000040, 0x0200000000000060,
  0x0400000000000080, 0x04000000000000c0,
  0x0800000000000100, 0x0800000000000180,
  0x1000000000000200, 0x1000000000000300,
  0x2000000000000400, 0x2000000000000600,
  0x4000000000000800, 0x4000000000000c00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0004000000000000, 0x0007fb72ea61d950,
  0x0008000000000001, 0x000ff6e5d4c3b2a1,
  0x0010000000000003, 0x001fedcba9876543,
  0x0020000000000006, 0x003fdb97530eca86,
  0x004000000000000c, 0x007fb72ea61d950c,
  0x0080000000000018, 0x00ff6e5d4c3b2a18,
  0x0100000000000030, 0x01fedcba98765430,
  0x0200000000000060, 0x03fdb97530eca860,
  0x04000000000000c0, 0x07fb72ea61d950c0,
  0x0800000000000180, 0x0ff6e5d4c3b2a180,
  0x1000000000000300, 0x1fedcba987654300,
  0x2000000000000600, 0x3fdb97530eca8600,
  0x4000000000000c00, 0x7fb72ea61d950c00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0007fb72ea61d950, 0x0007ffffffffffff,
  0x000ff6e5d4c3b2a1, 0x000ffffffffffffe,
  0x001fedcba9876543, 0x001ffffffffffffc,
  0x003fdb97530eca86, 0x003ffffffffffff8,
  0x007fb72ea61d950c, 0x007ffffffffffff0,
  0x00ff6e5d4c3b2a18, 0x00ffffffffffffe0,
  0x01fedcba98765430, 0x01ffffffffffffc0,
  0x03fdb97530eca860, 0x03ffffffffffff80,
  0x07fb72ea61d950c0, 0x07ffffffffffff00,
  0x0ff6e5d4c3b2a180, 0x0ffffffffffffe00,
  0x1fedcba987654300, 0x1ffffffffffffc00,
  0x3fdb97530eca8600, 0x3ffffffffffff800,
  0x7fb72ea61d950c00, 0x7ffffffffffff000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0007ffffffffffff, 0x0007ffffffffffff,
  0x000ffffffffffffe, 0x000ffffffffffffe,
  0x001ffffffffffffc, 0x001ffffffffffffd,
  0x003ffffffffffff8, 0x003ffffffffffffa,
  0x007ffffffffffff0, 0x007ffffffffffff4,
  0x00ffffffffffffe0, 0x00ffffffffffffe8,
  0x01ffffffffffffc0, 0x01ffffffffffffd0,
  0x03ffffffffffff80, 0x03ffffffffffffa0,
  0x07ffffffffffff00, 0x07ffffffffffff40,
  0x0ffffffffffffe00, 0x0ffffffffffffe80,
  0x1ffffffffffffc00, 0x1ffffffffffffd00,
  0x3ffffffffffff800, 0x3ffffffffffffa00,
  0x7ffffffffffff000, 0x7ffffffffffff400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0007ffffffffffff, 0x0007ffffffffffff,
  0x000ffffffffffffe, 0x000fffffffffffff,
  0x001ffffffffffffd, 0x001ffffffffffffe,
  0x003ffffffffffffa, 0x003ffffffffffffc,
  0x007ffffffffffff4, 0x007ffffffffffff8,
  0x00ffffffffffffe8, 0x00fffffffffffff0,
  0x01ffffffffffffd0, 0x01ffffffffffffe0,
  0x03ffffffffffffa0, 0x03ffffffffffffc0,
  0x07ffffffffffff40, 0x07ffffffffffff80,
  0x0ffffffffffffe80, 0x0fffffffffffff00,
  0x1ffffffffffffd00, 0x1ffffffffffffe00,
  0x3ffffffffffffa00, 0x3ffffffffffffc00,
  0x7ffffffffffff400, 0x7ffffffffffff800,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0007ffffffffffff, 0x0007ffffffffffff,
  0x000fffffffffffff, 0x000fffffffffffff,
  0x001ffffffffffffe, 0x001fffffffffffff,
  0x003ffffffffffffc, 0x003ffffffffffffe,
  0x007ffffffffffff8, 0x007ffffffffffffc,
  0x00fffffffffffff0, 0x00fffffffffffff8,
  0x01ffffffffffffe0, 0x01fffffffffffff0,
  0x03ffffffffffffc0, 0x03ffffffffffffe0,
  0x07ffffffffffff80, 0x07ffffffffffffc0,
  0x0fffffffffffff00, 0x0fffffffffffff80,
  0x1ffffffffffffe00, 0x1fffffffffffff00,
  0x3ffffffffffffc00, 0x3ffffffffffffe00,
  0x7ffffffffffff800, 0x7ffffffffffffc00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0007ffffffffffff, 0xfff0000000000000,
  0x000fffffffffffff, 0xffe0000000000000,
  0x001fffffffffffff, 0xffc0000000000000,
  0x003ffffffffffffe, 0xff80000000000000,
  0x007ffffffffffffc, 0xff00000000000000,
  0x00fffffffffffff8, 0xfe00000000000000,
  0x01fffffffffffff0, 0xfc00000000000000,
  0x03ffffffffffffe0, 0xf800000000000000,
  0x07ffffffffffffc0, 0xf000000000000000,
  0x0fffffffffffff80, 0xe000000000000000,
  0x1fffffffffffff00, 0xc000000000000000,
  0x3ffffffffffffe00, 0x8000000000000000,
  0x7ffffffffffffc00, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0xfff0000000000000, 0xffefffffffffffff,
  0xffe0000000000000, 0xffdffffffffffffe,
  0xffc0000000000000, 0xffbffffffffffffc,
  0xff80000000000000, 0xff7ffffffffffff8,
  0xff00000000000000, 0xfefffffffffffff0,
  0xfe00000000000000, 0xfdffffffffffffe0,
  0xfc00000000000000, 0xfbffffffffffffc0,
  0xf800000000000000, 0xf7ffffffffffff80,
  0xf000000000000000, 0xefffffffffffff00,
  0xe000000000000000, 0xdffffffffffffe00,
  0xc000000000000000, 0xbffffffffffffc00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffefffffffffffff, 0xffeffffffffffffe,
  0xffdffffffffffffe, 0xffdffffffffffffc,
  0xffbffffffffffffc, 0xffbffffffffffff8,
  0xff7ffffffffffff8, 0xff7ffffffffffff0,
  0xfefffffffffffff0, 0xfeffffffffffffe0,
  0xfdffffffffffffe0, 0xfdffffffffffffc0,
  0xfbffffffffffffc0, 0xfbffffffffffff80,
  0xf7ffffffffffff80, 0xf7ffffffffffff00,
  0xefffffffffffff00, 0xeffffffffffffe00,
  0xdffffffffffffe00, 0xdffffffffffffc00,
  0xbffffffffffffc00, 0xbffffffffffff800,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffeffffffffffffe, 0xffeffffffffffffd,
  0xffdffffffffffffc, 0xffdffffffffffffa,
  0xffbffffffffffff8, 0xffbffffffffffff4,
  0xff7ffffffffffff0, 0xff7fffffffffffe8,
  0xfeffffffffffffe0, 0xfeffffffffffffd0,
  0xfdffffffffffffc0, 0xfdffffffffffffa0,
  0xfbffffffffffff80, 0xfbffffffffffff40,
  0xf7ffffffffffff00, 0xf7fffffffffffe80,
  0xeffffffffffffe00, 0xeffffffffffffd00,
  0xdffffffffffffc00, 0xdffffffffffffa00,
  0xbffffffffffff800, 0xbffffffffffff400,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffeffffffffffffd, 0xffe0123456789abd,
  0xffdffffffffffffa, 0xffc02468acf1357a,
  0xffbffffffffffff4, 0xff8048d159e26af4,
  0xff7fffffffffffe8, 0xff0091a2b3c4d5e8,
  0xfeffffffffffffd0, 0xfe0123456789abd0,
  0xfdffffffffffffa0, 0xfc02468acf1357a0,
  0xfbffffffffffff40, 0xf8048d159e26af40,
  0xf7fffffffffffe80, 0xf0091a2b3c4d5e80,
  0xeffffffffffffd00, 0xe0123456789abd00,
  0xdffffffffffffa00, 0xc02468acf1357a00,
  0xbffffffffffff400, 0x8048d159e26af400,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffe0123456789abd, 0xffe0000000000004,
  0xffc02468acf1357a, 0xffc0000000000008,
  0xff8048d159e26af4, 0xff80000000000010,
  0xff0091a2b3c4d5e8, 0xff00000000000020,
  0xfe0123456789abd0, 0xfe00000000000040,
  0xfc02468acf1357a0, 0xfc00000000000080,
  0xf8048d159e26af40, 0xf800000000000100,
  0xf0091a2b3c4d5e80, 0xf000000000000200,
  0xe0123456789abd00, 0xe000000000000400,
  0xc02468acf1357a00, 0xc000000000000800,
  0x8048d159e26af400, 0x8000000000001000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffe0000000000004, 0xffe0000000000003,
  0xffc0000000000008, 0xffc0000000000006,
  0xff80000000000010, 0xff8000000000000c,
  0xff00000000000020, 0xff00000000000018,
  0xfe00000000000040, 0xfe00000000000030,
  0xfc00000000000080, 0xfc00000000000060,
  0xf800000000000100, 0xf8000000000000c0,
  0xf000000000000200, 0xf000000000000180,
  0xe000000000000400, 0xe000000000000300,
  0xc000000000000800, 0xc000000000000600,
  0x8000000000001000, 0x8000000000000c00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffe0000000000003, 0xffe0000000000002,
  0xffc0000000000006, 0xffc0000000000004,
  0xff8000000000000c, 0xff80000000000008,
  0xff00000000000018, 0xff00000000000010,
  0xfe00000000000030, 0xfe00000000000020,
  0xfc00000000000060, 0xfc00000000000040,
  0xf8000000000000c0, 0xf800000000000080,
  0xf000000000000180, 0xf000000000000100,
  0xe000000000000300, 0xe000000000000200,
  0xc000000000000600, 0xc000000000000400,
  0x8000000000000c00, 0x8000000000000800,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffe0000000000002, 0xffe0000000000001,
  0xffc0000000000004, 0xffc0000000000002,
  0xff80000000000008, 0xff80000000000004,
  0xff00000000000010, 0xff00000000000008,
  0xfe00000000000020, 0xfe00000000000010,
  0xfc00000000000040, 0xfc00000000000020,
  0xf800000000000080, 0xf800000000000040,
  0xf000000000000100, 0xf000000000000080,
  0xe000000000000200, 0xe000000000000100,
  0xc000000000000400, 0xc000000000000200,
  0x8000000000000800, 0x8000000000000400,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffe0000000000001, 0xfff8000000000000,
  0xffc0000000000002, 0xfff0000000000000,
  0xff80000000000004, 0xffe0000000000000,
  0xff00000000000008, 0xffc0000000000000,
  0xfe00000000000010, 0xff80000000000000,
  0xfc00000000000020, 0xff00000000000000,
  0xf800000000000040, 0xfe00000000000000,
  0xf000000000000080, 0xfc00000000000000,
  0xe000000000000100, 0xf800000000000000,
  0xc000000000000200, 0xf000000000000000,
  0x8000000000000400, 0xe000000000000000,
  0x8000000000000000, 0xc000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfff8000000000000, 0xfff8000000000000,
  0xfff0000000000000, 0xffefffffffffffff,
  0xffe0000000000000, 0xffdffffffffffffe,
  0xffc0000000000000, 0xffbffffffffffffc,
  0xff80000000000000, 0xff7ffffffffffff8,
  0xff00000000000000, 0xfefffffffffffff0,
  0xfe00000000000000, 0xfdffffffffffffe0,
  0xfc00000000000000, 0xfbffffffffffffc0,
  0xf800000000000000, 0xf7ffffffffffff80,
  0xf000000000000000, 0xefffffffffffff00,
  0xe000000000000000, 0xdffffffffffffe00,
  0xc000000000000000, 0xbffffffffffffc00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfff8000000000000, 0xfff7ffffffffffff,
  0xffefffffffffffff, 0xffeffffffffffffe,
  0xffdffffffffffffe, 0xffdffffffffffffc,
  0xffbffffffffffffc, 0xffbffffffffffff8,
  0xff7ffffffffffff8, 0xff7ffffffffffff0,
  0xfefffffffffffff0, 0xfeffffffffffffe0,
  0xfdffffffffffffe0, 0xfdffffffffffffc0,
  0xfbffffffffffffc0, 0xfbffffffffffff80,
  0xf7ffffffffffff80, 0xf7ffffffffffff00,
  0xefffffffffffff00, 0xeffffffffffffe00,
  0xdffffffffffffe00, 0xdffffffffffffc00,
  0xbffffffffffffc00, 0xbffffffffffff800,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfff7ffffffffffff, 0xfff7ffffffffffff,
  0xffeffffffffffffe, 0xffeffffffffffffd,
  0xffdffffffffffffc, 0xffdffffffffffffa,
  0xffbffffffffffff8, 0xffbffffffffffff4,
  0xff7ffffffffffff0, 0xff7fffffffffffe8,
  0xfeffffffffffffe0, 0xfeffffffffffffd0,
  0xfdffffffffffffc0, 0xfdffffffffffffa0,
  0xfbffffffffffff80, 0xfbffffffffffff40,
  0xf7ffffffffffff00, 0xf7fffffffffffe80,
  0xeffffffffffffe00, 0xeffffffffffffd00,
  0xdffffffffffffc00, 0xdffffffffffffa00,
  0xbffffffffffff800, 0xbffffffffffff400,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfff7ffffffffffff, 0xfff0091a2b3c4d5f,
  0xffeffffffffffffd, 0xffe0123456789abd,
  0xffdffffffffffffa, 0xffc02468acf1357a,
  0xffbffffffffffff4, 0xff8048d159e26af4,
  0xff7fffffffffffe8, 0xff0091a2b3c4d5e8,
  0xfeffffffffffffd0, 0xfe0123456789abd0,
  0xfdffffffffffffa0, 0xfc02468acf1357a0,
  0xfbffffffffffff40, 0xf8048d159e26af40,
  0xf7fffffffffffe80, 0xf0091a2b3c4d5e80,
  0xeffffffffffffd00, 0xe0123456789abd00,
  0xdffffffffffffa00, 0xc02468acf1357a00,
  0xbffffffffffff400, 0x8048d159e26af400,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfff0091a2b3c4d5f, 0xfff0000000000002,
  0xffe0123456789abd, 0xffe0000000000004,
  0xffc02468acf1357a, 0xffc0000000000008,
  0xff8048d159e26af4, 0xff80000000000010,
  0xff0091a2b3c4d5e8, 0xff00000000000020,
  0xfe0123456789abd0, 0xfe00000000000040,
  0xfc02468acf1357a0, 0xfc00000000000080,
  0xf8048d159e26af40, 0xf800000000000100,
  0xf0091a2b3c4d5e80, 0xf000000000000200,
  0xe0123456789abd00, 0xe000000000000400,
  0xc02468acf1357a00, 0xc000000000000800,
  0x8048d159e26af400, 0x8000000000001000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfff0000000000002, 0xfff0000000000002,
  0xffe0000000000004, 0xffe0000000000003,
  0xffc0000000000008, 0xffc0000000000006,
  0xff80000000000010, 0xff8000000000000c,
  0xff00000000000020, 0xff00000000000018,
  0xfe00000000000040, 0xfe00000000000030,
  0xfc00000000000080, 0xfc00000000000060,
  0xf800000000000100, 0xf8000000000000c0,
  0xf000000000000200, 0xf000000000000180,
  0xe000000000000400, 0xe000000000000300,
  0xc000000000000800, 0xc000000000000600,
  0x8000000000001000, 0x8000000000000c00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfff0000000000002, 0xfff0000000000001,
  0xffe0000000000003, 0xffe0000000000002,
  0xffc0000000000006, 0xffc0000000000004,
  0xff8000000000000c, 0xff80000000000008,
  0xff00000000000018, 0xff00000000000010,
  0xfe00000000000030, 0xfe00000000000020,
  0xfc00000000000060, 0xfc00000000000040,
  0xf8000000000000c0, 0xf800000000000080,
  0xf000000000000180, 0xf000000000000100,
  0xe000000000000300, 0xe000000000000200,
  0xc000000000000600, 0xc000000000000400,
  0x8000000000000c00, 0x8000000000000800,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfff0000000000001, 0xfff0000000000001,
  0xffe0000000000002, 0xffe0000000000001,
  0xffc0000000000004, 0xffc0000000000002,
  0xff80000000000008, 0xff80000000000004,
  0xff00000000000010, 0xff00000000000008,
  0xfe00000000000020, 0xfe00000000000010,
  0xfc00000000000040, 0xfc00000000000020,
  0xf800000000000080, 0xf800000000000040,
  0xf000000000000100, 0xf000000000000080,
  0xe000000000000200, 0xe000000000000100,
  0xc000000000000400, 0xc000000000000200,
  0x8000000000000800, 0x8000000000000400,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfff0000000000001, 0xfffc000000000000,
  0xffe0000000000001, 0xfff8000000000000,
  0xffc0000000000002, 0xfff0000000000000,
  0xff80000000000004, 0xffe0000000000000,
  0xff00000000000008, 0xffc0000000000000,
  0xfe00000000000010, 0xff80000000000000,
  0xfc00000000000020, 0xff00000000000000,
  0xf800000000000040, 0xfe00000000000000,
  0xf000000000000080, 0xfc00000000000000,
  0xe000000000000100, 0xf800000000000000,
  0xc000000000000200, 0xf000000000000000,
  0x8000000000000400, 0xe000000000000000,
  0x8000000000000000, 0xc000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfffc000000000000, 0xfffc000000000000,
  0xfff8000000000000, 0xfff8000000000000,
  0xfff0000000000000, 0xffefffffffffffff,
  0xffe0000000000000, 0xffdffffffffffffe,
  0xffc0000000000000, 0xffbffffffffffffc,
  0xff80000000000000, 0xff7ffffffffffff8,
  0xff00000000000000, 0xfefffffffffffff0,
  0xfe00000000000000, 0xfdffffffffffffe0,
  0xfc00000000000000, 0xfbffffffffffffc0,
  0xf800000000000000, 0xf7ffffffffffff80,
  0xf000000000000000, 0xefffffffffffff00,
  0xe000000000000000, 0xdffffffffffffe00,
  0xc000000000000000, 0xbffffffffffffc00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfffc000000000000, 0xfffc000000000000,
  0xfff8000000000000, 0xfff7ffffffffffff,
  0xffefffffffffffff, 0xffeffffffffffffe,
  0xffdffffffffffffe, 0xffdffffffffffffc,
  0xffbffffffffffffc, 0xffbffffffffffff8,
  0xff7ffffffffffff8, 0xff7ffffffffffff0,
  0xfefffffffffffff0, 0xfeffffffffffffe0,
  0xfdffffffffffffe0, 0xfdffffffffffffc0,
  0xfbffffffffffffc0, 0xfbffffffffffff80,
  0xf7ffffffffffff80, 0xf7ffffffffffff00,
  0xefffffffffffff00, 0xeffffffffffffe00,
  0xdffffffffffffe00, 0xdffffffffffffc00,
  0xbffffffffffffc00, 0xbffffffffffff800,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfffc000000000000, 0xfffc000000000000,
  0xfff7ffffffffffff, 0xfff7ffffffffffff,
  0xffeffffffffffffe, 0xffeffffffffffffd,
  0xffdffffffffffffc, 0xffdffffffffffffa,
  0xffbffffffffffff8, 0xffbffffffffffff4,
  0xff7ffffffffffff0, 0xff7fffffffffffe8,
  0xfeffffffffffffe0, 0xfeffffffffffffd0,
  0xfdffffffffffffc0, 0xfdffffffffffffa0,
  0xfbffffffffffff80, 0xfbffffffffffff40,
  0xf7ffffffffffff00, 0xf7fffffffffffe80,
  0xeffffffffffffe00, 0xeffffffffffffd00,
  0xdffffffffffffc00, 0xdffffffffffffa00,
  0xbffffffffffff800, 0xbffffffffffff400,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfffc000000000000, 0xfff8048d159e26b0,
  0xfff7ffffffffffff, 0xfff0091a2b3c4d5f,
  0xffeffffffffffffd, 0xffe0123456789abd,
  0xffdffffffffffffa, 0xffc02468acf1357a,
  0xffbffffffffffff4, 0xff8048d159e26af4,
  0xff7fffffffffffe8, 0xff0091a2b3c4d5e8,
  0xfeffffffffffffd0, 0xfe0123456789abd0,
  0xfdffffffffffffa0, 0xfc02468acf1357a0,
  0xfbffffffffffff40, 0xf8048d159e26af40,
  0xf7fffffffffffe80, 0xf0091a2b3c4d5e80,
  0xeffffffffffffd00, 0xe0123456789abd00,
  0xdffffffffffffa00, 0xc02468acf1357a00,
  0xbffffffffffff400, 0x8048d159e26af400,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfff8048d159e26b0, 0xfff8000000000001,
  0xfff0091a2b3c4d5f, 0xfff0000000000002,
  0xffe0123456789abd, 0xffe0000000000004,
  0xffc02468acf1357a, 0xffc0000000000008,
  0xff8048d159e26af4, 0xff80000000000010,
  0xff0091a2b3c4d5e8, 0xff00000000000020,
  0xfe0123456789abd0, 0xfe00000000000040,
  0xfc02468acf1357a0, 0xfc00000000000080,
  0xf8048d159e26af40, 0xf800000000000100,
  0xf0091a2b3c4d5e80, 0xf000000000000200,
  0xe0123456789abd00, 0xe000000000000400,
  0xc02468acf1357a00, 0xc000000000000800,
  0x8048d159e26af400, 0x8000000000001000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfff8000000000001, 0xfff8000000000001,
  0xfff0000000000002, 0xfff0000000000002,
  0xffe0000000000004, 0xffe0000000000003,
  0xffc0000000000008, 0xffc0000000000006,
  0xff80000000000010, 0xff8000000000000c,
  0xff00000000000020, 0xff00000000000018,
  0xfe00000000000040, 0xfe00000000000030,
  0xfc00000000000080, 0xfc00000000000060,
  0xf800000000000100, 0xf8000000000000c0,
  0xf000000000000200, 0xf000000000000180,
  0xe000000000000400, 0xe000000000000300,
  0xc000000000000800, 0xc000000000000600,
  0x8000000000001000, 0x8000000000000c00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfff8000000000001, 0xfff8000000000001,
  0xfff0000000000002, 0xfff0000000000001,
  0xffe0000000000003, 0xffe0000000000002,
  0xffc0000000000006, 0xffc0000000000004,
  0xff8000000000000c, 0xff80000000000008,
  0xff00000000000018, 0xff00000000000010,
  0xfe00000000000030, 0xfe00000000000020,
  0xfc00000000000060, 0xfc00000000000040,
  0xf8000000000000c0, 0xf800000000000080,
  0xf000000000000180, 0xf000000000000100,
  0xe000000000000300, 0xe000000000000200,
  0xc000000000000600, 0xc000000000000400,
  0x8000000000000c00, 0x8000000000000800,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfff8000000000001, 0xfff8000000000001,
  0xfff0000000000001, 0xfff0000000000001,
  0xffe0000000000002, 0xffe0000000000001,
  0xffc0000000000004, 0xffc0000000000002,
  0xff80000000000008, 0xff80000000000004,
  0xff00000000000010, 0xff00000000000008,
  0xfe00000000000020, 0xfe00000000000010,
  0xfc00000000000040, 0xfc00000000000020,
  0xf800000000000080, 0xf800000000000040,
  0xf000000000000100, 0xf000000000000080,
  0xe000000000000200, 0xe000000000000100,
  0xc000000000000400, 0xc000000000000200,
  0x8000000000000800, 0x8000000000000400,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfff8000000000001, 0x8000000000000000,
  0xfff0000000000001, 0x8000000000000000,
  0xffe0000000000001, 0x8000000000000000,
  0xffc0000000000002, 0x8000000000000000,
  0xff80000000000004, 0x8000000000000000,
  0xff00000000000008, 0x8000000000000000,
  0xfe00000000000010, 0x8000000000000000,
  0xfc00000000000020, 0x8000000000000000,
  0xf800000000000040, 0x8000000000000000,
  0xf000000000000080, 0x8000000000000000,
  0xe000000000000100, 0x8000000000000000,
  0xc000000000000200, 0x8000000000000000,
  0x8000000000000400, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000400,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000400, 0x7ffffffffffffc00,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x7ffffffffffffc00, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0xffffffff7fffffff,
  0x7fffffffffffffff, 0xfffffffefffffffe,
  0x7fffffffffffffff, 0xfffffffdfffffffc,
  0x7fffffffffffffff, 0xfffffffbfffffff8,
  0x7fffffffffffffff, 0xfffffff7fffffff0,
  0x7fffffffffffffff, 0xffffffefffffffe0,
  0x7fffffffffffffff, 0xffffffdfffffffc0,
  0x7fffffffffffffff, 0xffffffbfffffff80,
  0x7fffffffffffffff, 0xffffff7fffffff00,
  0x7fffffffffffffff, 0xfffffefffffffe00,
  0x7fffffffffffffff, 0xfffffdfffffffc00,
  0x7fffffffffffffff, 0xfffffbfffffff800,
  0x7fffffffffffffff, 0xfffff7fffffff000,
  0x7fffffffffffffff, 0xffffefffffffe000,
  0x7fffffffffffffff, 0xffffdfffffffc000,
  0x7fffffffffffffff, 0xffffbfffffff8000,
  0x7fffffffffffffff, 0xffff7fffffff0000,
  0x7fffffffffffffff, 0xfffefffffffe0000,
  0x7fffffffffffffff, 0xfffdfffffffc0000,
  0x7fffffffffffffff, 0xfffbfffffff80000,
  0x7fffffffffffffff, 0xfff7fffffff00000,
  0x7fffffffffffffff, 0xffefffffffdfffff,
  0x7fffffffffffffff, 0xffdfffffffbffffe,
  0x7fffffffffffffff, 0xffbfffffff7ffffc,
  0x7fffffffffffffff, 0xff7ffffffefffff8,
  0x7fffffffffffffff, 0xfefffffffdfffff0,
  0x7fffffffffffffff, 0xfdfffffffbffffe0,
  0x7fffffffffffffff, 0xfbfffffff7ffffc0,
  0x7fffffffffffffff, 0xf7ffffffefffff80,
  0x7fffffffffffffff, 0xefffffffdfffff00,
  0x7fffffffffffffff, 0xdfffffffbffffe00,
  0x7fffffffffffffff, 0xbfffffff7ffffc00,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0xffffffff7fffffff, 0xffffffff7fffffff,
  0xfffffffefffffffe, 0xfffffffefffffffe,
  0xfffffffdfffffffc, 0xfffffffdfffffffc,
  0xfffffffbfffffff8, 0xfffffffbfffffff8,
  0xfffffff7fffffff0, 0xfffffff7fffffff0,
  0xffffffefffffffe0, 0xffffffefffffffe0,
  0xffffffdfffffffc0, 0xffffffdfffffffc0,
  0xffffffbfffffff80, 0xffffffbfffffff80,
  0xffffff7fffffff00, 0xffffff7fffffff00,
  0xfffffefffffffe00, 0xfffffefffffffe00,
  0xfffffdfffffffc00, 0xfffffdfffffffc00,
  0xfffffbfffffff800, 0xfffffbfffffff800,
  0xfffff7fffffff000, 0xfffff7fffffff000,
  0xffffefffffffe000, 0xffffefffffffe000,
  0xffffdfffffffc000, 0xffffdfffffffc000,
  0xffffbfffffff8000, 0xffffbfffffff8000,
  0xffff7fffffff0000, 0xffff7fffffff0000,
  0xfffefffffffe0000, 0xfffefffffffe0000,
  0xfffdfffffffc0000, 0xfffdfffffffc0000,
  0xfffbfffffff80000, 0xfffbfffffff80000,
  0xfff7fffffff00000, 0xfff7fffffff00000,
  0xffefffffffdfffff, 0xffefffffffe00000,
  0xffdfffffffbffffe, 0xffdfffffffc00000,
  0xffbfffffff7ffffc, 0xffbfffffff800000,
  0xff7ffffffefffff8, 0xff7fffffff000000,
  0xfefffffffdfffff0, 0xfefffffffe000000,
  0xfdfffffffbffffe0, 0xfdfffffffc000000,
  0xfbfffffff7ffffc0, 0xfbfffffff8000000,
  0xf7ffffffefffff80, 0xf7fffffff0000000,
  0xefffffffdfffff00, 0xefffffffe0000000,
  0xdfffffffbffffe00, 0xdfffffffc0000000,
  0xbfffffff7ffffc00, 0xbfffffff80000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffff7fffffff, 0xffffffff80000000,
  0xfffffffefffffffe, 0xfffffffeffffffff,
  0xfffffffdfffffffc, 0xfffffffdfffffffd,
  0xfffffffbfffffff8, 0xfffffffbfffffff9,
  0xfffffff7fffffff0, 0xfffffff7fffffff1,
  0xffffffefffffffe0, 0xffffffefffffffe1,
  0xffffffdfffffffc0, 0xffffffdfffffffc1,
  0xffffffbfffffff80, 0xffffffbfffffff81,
  0xffffff7fffffff00, 0xffffff7fffffff01,
  0xfffffefffffffe00, 0xfffffefffffffe01,
  0xfffffdfffffffc00, 0xfffffdfffffffc01,
  0xfffffbfffffff800, 0xfffffbfffffff801,
  0xfffff7fffffff000, 0xfffff7fffffff001,
  0xffffefffffffe000, 0xffffefffffffe001,
  0xffffdfffffffc000, 0xffffdfffffffc001,
  0xffffbfffffff8000, 0xffffbfffffff8001,
  0xffff7fffffff0000, 0xffff7fffffff0001,
  0xfffefffffffe0000, 0xfffefffffffe0001,
  0xfffdfffffffc0000, 0xfffdfffffffc0001,
  0xfffbfffffff80000, 0xfffbfffffff80001,
  0xfff7fffffff00000, 0xfff7fffffff00001,
  0xffefffffffe00000, 0xffefffffffe00001,
  0xffdfffffffc00000, 0xffdfffffffc00002,
  0xffbfffffff800000, 0xffbfffffff800004,
  0xff7fffffff000000, 0xff7fffffff000008,
  0xfefffffffe000000, 0xfefffffffe000010,
  0xfdfffffffc000000, 0xfdfffffffc000020,
  0xfbfffffff8000000, 0xfbfffffff8000040,
  0xf7fffffff0000000, 0xf7fffffff0000080,
  0xefffffffe0000000, 0xefffffffe0000100,
  0xdfffffffc0000000, 0xdfffffffc0000200,
  0xbfffffff80000000, 0xbfffffff80000400,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffff80000000, 0xffffffff80000000,
  0xfffffffeffffffff, 0xfffffffeffffffff,
  0xfffffffdfffffffd, 0xfffffffdfffffffe,
  0xfffffffbfffffff9, 0xfffffffbfffffffc,
  0xfffffff7fffffff1, 0xfffffff7fffffff8,
  0xffffffefffffffe1, 0xffffffeffffffff0,
  0xffffffdfffffffc1, 0xffffffdfffffffe0,
  0xffffffbfffffff81, 0xffffffbfffffffc0,
  0xffffff7fffffff01, 0xffffff7fffffff80,
  0xfffffefffffffe01, 0xfffffeffffffff00,
  0xfffffdfffffffc01, 0xfffffdfffffffe00,
  0xfffffbfffffff801, 0xfffffbfffffffc00,
  0xfffff7fffffff001, 0xfffff7fffffff800,
  0xffffefffffffe001, 0xffffeffffffff000,
  0xffffdfffffffc001, 0xffffdfffffffe000,
  0xffffbfffffff8001, 0xffffbfffffffc000,
  0xffff7fffffff0001, 0xffff7fffffff8000,
  0xfffefffffffe0001, 0xfffeffffffff0000,
  0xfffdfffffffc0001, 0xfffdfffffffe0000,
  0xfffbfffffff80001, 0xfffbfffffffc0000,
  0xfff7fffffff00001, 0xfff7fffffff80000,
  0xffefffffffe00001, 0xffefffffffefffff,
  0xffdfffffffc00002, 0xffdfffffffdffffe,
  0xffbfffffff800004, 0xffbfffffffbffffc,
  0xff7fffffff000008, 0xff7fffffff7ffff8,
  0xfefffffffe000010, 0xfefffffffefffff0,
  0xfdfffffffc000020, 0xfdfffffffdffffe0,
  0xfbfffffff8000040, 0xfbfffffffbffffc0,
  0xf7fffffff0000080, 0xf7fffffff7ffff80,
  0xefffffffe0000100, 0xefffffffefffff00,
  0xdfffffffc0000200, 0xdfffffffdffffe00,
  0xbfffffff80000400, 0xbfffffffbffffc00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffff80000000, 0xffffffff80000000,
  0xfffffffeffffffff, 0xfffffffeffffffff,
  0xfffffffdfffffffe, 0xfffffffdfffffffe,
  0xfffffffbfffffffc, 0xfffffffbfffffffc,
  0xfffffff7fffffff8, 0xfffffff7fffffff8,
  0xffffffeffffffff0, 0xffffffeffffffff0,
  0xffffffdfffffffe0, 0xffffffdfffffffe0,
  0xffffffbfffffffc0, 0xffffffbfffffffc0,
  0xffffff7fffffff80, 0xffffff7fffffff80,
  0xfffffeffffffff00, 0xfffffeffffffff00,
  0xfffffdfffffffe00, 0xfffffdfffffffe00,
  0xfffffbfffffffc00, 0xfffffbfffffffc00,
  0xfffff7fffffff800, 0xfffff7fffffff800,
  0xffffeffffffff000, 0xffffeffffffff000,
  0xffffdfffffffe000, 0xffffdfffffffe000,
  0xffffbfffffffc000, 0xffffbfffffffc000,
  0xffff7fffffff8000, 0xffff7fffffff8000,
  0xfffeffffffff0000, 0xfffeffffffff0000,
  0xfffdfffffffe0000, 0xfffdfffffffe0000,
  0xfffbfffffffc0000, 0xfffbfffffffc0000,
  0xfff7fffffff80000, 0xfff7fffffff80000,
  0xffefffffffefffff, 0xffeffffffff00000,
  0xffdfffffffdffffe, 0xffdfffffffe00000,
  0xffbfffffffbffffc, 0xffbfffffffc00000,
  0xff7fffffff7ffff8, 0xff7fffffff800000,
  0xfefffffffefffff0, 0xfeffffffff000000,
  0xfdfffffffdffffe0, 0xfdfffffffe000000,
  0xfbfffffffbffffc0, 0xfbfffffffc000000,
  0xf7fffffff7ffff80, 0xf7fffffff8000000,
  0xefffffffefffff00, 0xeffffffff0000000,
  0xdfffffffdffffe00, 0xdfffffffe0000000,
  0xbfffffffbffffc00, 0xbfffffffc0000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffff80000000, 0xffffffff80000000,
  0xfffffffeffffffff, 0xffffffff00000000,
  0xfffffffdfffffffe, 0xfffffffdffffffff,
  0xfffffffbfffffffc, 0xfffffffbfffffffd,
  0xfffffff7fffffff8, 0xfffffff7fffffff9,
  0xffffffeffffffff0, 0xffffffeffffffff1,
  0xffffffdfffffffe0, 0xffffffdfffffffe1,
  0xffffffbfffffffc0, 0xffffffbfffffffc1,
  0xffffff7fffffff80, 0xffffff7fffffff81,
  0xfffffeffffffff00, 0xfffffeffffffff01,
  0xfffffdfffffffe00, 0xfffffdfffffffe01,
  0xfffffbfffffffc00, 0xfffffbfffffffc01,
  0xfffff7fffffff800, 0xfffff7fffffff801,
  0xffffeffffffff000, 0xffffeffffffff001,
  0xffffdfffffffe000, 0xffffdfffffffe001,
  0xffffbfffffffc000, 0xffffbfffffffc001,
  0xffff7fffffff8000, 0xffff7fffffff8001,
  0xfffeffffffff0000, 0xfffeffffffff0001,
  0xfffdfffffffe0000, 0xfffdfffffffe0001,
  0xfffbfffffffc0000, 0xfffbfffffffc0001,
  0xfff7fffffff80000, 0xfff7fffffff80001,
  0xffeffffffff00000, 0xffeffffffff00001,
  0xffdfffffffe00000, 0xffdfffffffe00002,
  0xffbfffffffc00000, 0xffbfffffffc00004,
  0xff7fffffff800000, 0xff7fffffff800008,
  0xfeffffffff000000, 0xfeffffffff000010,
  0xfdfffffffe000000, 0xfdfffffffe000020,
  0xfbfffffffc000000, 0xfbfffffffc000040,
  0xf7fffffff8000000, 0xf7fffffff8000080,
  0xeffffffff0000000, 0xeffffffff0000100,
  0xdfffffffe0000000, 0xdfffffffe0000200,
  0xbfffffffc0000000, 0xbfffffffc0000400,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff00000000, 0xffffffff00000000,
  0xfffffffdffffffff, 0xfffffffe00000000,
  0xfffffffbfffffffd, 0xfffffffc00000000,
  0xfffffff7fffffff9, 0xfffffff800000000,
  0xffffffeffffffff1, 0xfffffff000000000,
  0xffffffdfffffffe1, 0xffffffe000000000,
  0xffffffbfffffffc1, 0xffffffc000000000,
  0xffffff7fffffff81, 0xffffff8000000000,
  0xfffffeffffffff01, 0xffffff0000000000,
  0xfffffdfffffffe01, 0xfffffe0000000000,
  0xfffffbfffffffc01, 0xfffffc0000000000,
  0xfffff7fffffff801, 0xfffff80000000000,
  0xffffeffffffff001, 0xfffff00000000000,
  0xffffdfffffffe001, 0xffffe00000000000,
  0xffffbfffffffc001, 0xffffc00000000000,
  0xffff7fffffff8001, 0xffff800000000000,
  0xfffeffffffff0001, 0xffff000000000000,
  0xfffdfffffffe0001, 0xfffe000000000000,
  0xfffbfffffffc0001, 0xfffc000000000000,
  0xfff7fffffff80001, 0xfff8000000000000,
  0xffeffffffff00001, 0xffefffffffffffff,
  0xffdfffffffe00002, 0xffdffffffffffffe,
  0xffbfffffffc00004, 0xffbffffffffffffc,
  0xff7fffffff800008, 0xff7ffffffffffff8,
  0xfeffffffff000010, 0xfefffffffffffff0,
  0xfdfffffffe000020, 0xfdffffffffffffe0,
  0xfbfffffffc000040, 0xfbffffffffffffc0,
  0xf7fffffff8000080, 0xf7ffffffffffff80,
  0xeffffffff0000100, 0xefffffffffffff00,
  0xdfffffffe0000200, 0xdffffffffffffe00,
  0xbfffffffc0000400, 0xbffffffffffffc00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff00000000, 0xffffffff00000000,
  0xfffffffe00000000, 0xfffffffe00000000,
  0xfffffffc00000000, 0xfffffffc00000000,
  0xfffffff800000000, 0xfffffff800000000,
  0xfffffff000000000, 0xfffffff000000000,
  0xffffffe000000000, 0xffffffe000000000,
  0xffffffc000000000, 0xffffffc000000000,
  0xffffff8000000000, 0xffffff8000000000,
  0xffffff0000000000, 0xffffff0000000000,
  0xfffffe0000000000, 0xfffffe0000000000,
  0xfffffc0000000000, 0xfffffc0000000000,
  0xfffff80000000000, 0xfffff80000000000,
  0xfffff00000000000, 0xfffff00000000000,
  0xffffe00000000000, 0xffffe00000000000,
  0xffffc00000000000, 0xffffc00000000000,
  0xffff800000000000, 0xffff800000000000,
  0xffff000000000000, 0xffff000000000000,
  0xfffe000000000000, 0xfffe000000000000,
  0xfffc000000000000, 0xfffc000000000000,
  0xfff8000000000000, 0xfff8000000000000,
  0xffefffffffffffff, 0xfff0000000000000,
  0xffdffffffffffffe, 0xffe0000000000000,
  0xffbffffffffffffc, 0xffc0000000000000,
  0xff7ffffffffffff8, 0xff80000000000000,
  0xfefffffffffffff0, 0xff00000000000000,
  0xfdffffffffffffe0, 0xfe00000000000000,
  0xfbffffffffffffc0, 0xfc00000000000000,
  0xf7ffffffffffff80, 0xf800000000000000,
  0xefffffffffffff00, 0xf000000000000000,
  0xdffffffffffffe00, 0xe000000000000000,
  0xbffffffffffffc00, 0xc000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffff80000000, 0xffffffff80000001,
  0xffffffff00000000, 0xffffffff00000001,
  0xfffffffe00000000, 0xfffffffe00000001,
  0xfffffffc00000000, 0xfffffffc00000001,
  0xfffffff800000000, 0xfffffff800000001,
  0xfffffff000000000, 0xfffffff000000001,
  0xffffffe000000000, 0xffffffe000000001,
  0xffffffc000000000, 0xffffffc000000001,
  0xffffff8000000000, 0xffffff8000000001,
  0xffffff0000000000, 0xffffff0000000001,
  0xfffffe0000000000, 0xfffffe0000000001,
  0xfffffc0000000000, 0xfffffc0000000001,
  0xfffff80000000000, 0xfffff80000000001,
  0xfffff00000000000, 0xfffff00000000001,
  0xffffe00000000000, 0xffffe00000000001,
  0xffffc00000000000, 0xffffc00000000001,
  0xffff800000000000, 0xffff800000000001,
  0xffff000000000000, 0xffff000000000001,
  0xfffe000000000000, 0xfffe000000000001,
  0xfffc000000000000, 0xfffc000000000001,
  0xfff8000000000000, 0xfff8000000000001,
  0xfff0000000000000, 0xfff0000000000001,
  0xffe0000000000000, 0xffe0000000000001,
  0xffc0000000000000, 0xffc0000000000002,
  0xff80000000000000, 0xff80000000000004,
  0xff00000000000000, 0xff00000000000008,
  0xfe00000000000000, 0xfe00000000000010,
  0xfc00000000000000, 0xfc00000000000020,
  0xf800000000000000, 0xf800000000000040,
  0xf000000000000000, 0xf000000000000080,
  0xe000000000000000, 0xe000000000000100,
  0xc000000000000000, 0xc000000000000200,
  0x8000000000000000, 0x8000000000000400,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffff80000001, 0xffffffff80000001,
  0xffffffff00000001, 0xffffffff00000001,
  0xfffffffe00000001, 0xfffffffe00000002,
  0xfffffffc00000001, 0xfffffffc00000004,
  0xfffffff800000001, 0xfffffff800000008,
  0xfffffff000000001, 0xfffffff000000010,
  0xffffffe000000001, 0xffffffe000000020,
  0xffffffc000000001, 0xffffffc000000040,
  0xffffff8000000001, 0xffffff8000000080,
  0xffffff0000000001, 0xffffff0000000100,
  0xfffffe0000000001, 0xfffffe0000000200,
  0xfffffc0000000001, 0xfffffc0000000400,
  0xfffff80000000001, 0xfffff80000000800,
  0xfffff00000000001, 0xfffff00000001000,
  0xffffe00000000001, 0xffffe00000002000,
  0xffffc00000000001, 0xffffc00000004000,
  0xffff800000000001, 0xffff800000008000,
  0xffff000000000001, 0xffff000000010000,
  0xfffe000000000001, 0xfffe000000020000,
  0xfffc000000000001, 0xfffc000000040000,
  0xfff8000000000001, 0xfff8000000080000,
  0xfff0000000000001, 0xfff0000000100000,
  0xffe0000000000001, 0xffe00000001fffff,
  0xffc0000000000002, 0xffc00000003ffffe,
  0xff80000000000004, 0xff800000007ffffc,
  0xff00000000000008, 0xff00000000fffff8,
  0xfe00000000000010, 0xfe00000001fffff0,
  0xfc00000000000020, 0xfc00000003ffffe0,
  0xf800000000000040, 0xf800000007ffffc0,
  0xf000000000000080, 0xf00000000fffff80,
  0xe000000000000100, 0xe00000001fffff00,
  0xc000000000000200, 0xc00000003ffffe00,
  0x8000000000000400, 0x800000007ffffc00,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffff80000001, 0xffffffff80000001,
  0xffffffff00000001, 0xffffffff00000001,
  0xfffffffe00000002, 0xfffffffe00000002,
  0xfffffffc00000004, 0xfffffffc00000004,
  0xfffffff800000008, 0xfffffff800000008,
  0xfffffff000000010, 0xfffffff000000010,
  0xffffffe000000020, 0xffffffe000000020,
  0xffffffc000000040, 0xffffffc000000040,
  0xffffff8000000080, 0xffffff8000000080,
  0xffffff0000000100, 0xffffff0000000100,
  0xfffffe0000000200, 0xfffffe0000000200,
  0xfffffc0000000400, 0xfffffc0000000400,
  0xfffff80000000800, 0xfffff80000000800,
  0xfffff00000001000, 0xfffff00000001000,
  0xffffe00000002000, 0xffffe00000002000,
  0xffffc00000004000, 0xffffc00000004000,
  0xffff800000008000, 0xffff800000008000,
  0xffff000000010000, 0xffff000000010000,
  0xfffe000000020000, 0xfffe000000020000,
  0xfffc000000040000, 0xfffc000000040000,
  0xfff8000000080000, 0xfff8000000080000,
  0xfff0000000100000, 0xfff0000000100000,
  0xffe00000001fffff, 0xffe0000000200000,
  0xffc00000003ffffe, 0xffc0000000400000,
  0xff800000007ffffc, 0xff80000000800000,
  0xff00000000fffff8, 0xff00000001000000,
  0xfe00000001fffff0, 0xfe00000002000000,
  0xfc00000003ffffe0, 0xfc00000004000000,
  0xf800000007ffffc0, 0xf800000008000000,
  0xf00000000fffff80, 0xf000000010000000,
  0xe00000001fffff00, 0xe000000020000000,
  0xc00000003ffffe00, 0xc000000040000000,
  0x800000007ffffc00, 0x8000000080000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffff80000001, 0xffffffff80000001,
  0xffffffff00000001, 0xffffffff00000002,
  0xfffffffe00000002, 0xfffffffe00000003,
  0xfffffffc00000004, 0xfffffffc00000005,
  0xfffffff800000008, 0xfffffff800000009,
  0xfffffff000000010, 0xfffffff000000011,
  0xffffffe000000020, 0xffffffe000000021,
  0xffffffc000000040, 0xffffffc000000041,
  0xffffff8000000080, 0xffffff8000000081,
  0xffffff0000000100, 0xffffff0000000101,
  0xfffffe0000000200, 0xfffffe0000000201,
  0xfffffc0000000400, 0xfffffc0000000401,
  0xfffff80000000800, 0xfffff80000000801,
  0xfffff00000001000, 0xfffff00000001001,
  0xffffe00000002000, 0xffffe00000002001,
  0xffffc00000004000, 0xffffc00000004001,
  0xffff800000008000, 0xffff800000008001,
  0xffff000000010000, 0xffff000000010001,
  0xfffe000000020000, 0xfffe000000020001,
  0xfffc000000040000, 0xfffc000000040001,
  0xfff8000000080000, 0xfff8000000080001,
  0xfff0000000100000, 0xfff0000000100001,
  0xffe0000000200000, 0xffe0000000200001,
  0xffc0000000400000, 0xffc0000000400002,
  0xff80000000800000, 0xff80000000800004,
  0xff00000001000000, 0xff00000001000008,
  0xfe00000002000000, 0xfe00000002000010,
  0xfc00000004000000, 0xfc00000004000020,
  0xf800000008000000, 0xf800000008000040,
  0xf000000010000000, 0xf000000010000080,
  0xe000000020000000, 0xe000000020000100,
  0xc000000040000000, 0xc000000040000200,
  0x8000000080000000, 0x8000000080000400,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffff80000001, 0x000000007ffffffd,
  0xffffffff00000002, 0x00000000fffffffb,
  0xfffffffe00000003, 0x00000001fffffff7,
  0xfffffffc00000005, 0x00000003ffffffef,
  0xfffffff800000009, 0x00000007ffffffdf,
  0xfffffff000000011, 0x0000000fffffffbf,
  0xffffffe000000021, 0x0000001fffffff7f,
  0xffffffc000000041, 0x0000003ffffffeff,
  0xffffff8000000081, 0x0000007ffffffdff,
  0xffffff0000000101, 0x000000fffffffbff,
  0xfffffe0000000201, 0x000001fffffff7ff,
  0xfffffc0000000401, 0x000003ffffffefff,
  0xfffff80000000801, 0x000007ffffffdfff,
  0xfffff00000001001, 0x00000fffffffbfff,
  0xffffe00000002001, 0x00001fffffff7fff,
  0xffffc00000004001, 0x00003ffffffeffff,
  0xffff800000008001, 0x00007ffffffdffff,
  0xffff000000010001, 0x0000fffffffbffff,
  0xfffe000000020001, 0x0001fffffff7ffff,
  0xfffc000000040001, 0x0003ffffffefffff,
  0xfff8000000080001, 0x0007ffffffdfffff,
  0xfff0000000100001, 0x000fffffffbfffff,
  0xffe0000000200001, 0x001fffffff7fffff,
  0xffc0000000400002, 0x003ffffffefffffe,
  0xff80000000800004, 0x007ffffffdfffffc,
  0xff00000001000008, 0x00fffffffbfffff8,
  0xfe00000002000010, 0x01fffffff7fffff0,
  0xfc00000004000020, 0x03ffffffefffffe0,
  0xf800000008000040, 0x07ffffffdfffffc0,
  0xf000000010000080, 0x0fffffffbfffff80,
  0xe000000020000100, 0x1fffffff7fffff00,
  0xc000000040000200, 0x3ffffffefffffe00,
  0x8000000080000400, 0x7ffffffdfffffc00,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x000000007ffffffd, 0x000000007ffffffe,
  0x00000000fffffffb, 0x00000000fffffffc,
  0x00000001fffffff7, 0x00000001fffffff8,
  0x00000003ffffffef, 0x00000003fffffff0,
  0x00000007ffffffdf, 0x00000007ffffffe0,
  0x0000000fffffffbf, 0x0000000fffffffc0,
  0x0000001fffffff7f, 0x0000001fffffff80,
  0x0000003ffffffeff, 0x0000003fffffff00,
  0x0000007ffffffdff, 0x0000007ffffffe00,
  0x000000fffffffbff, 0x000000fffffffc00,
  0x000001fffffff7ff, 0x000001fffffff800,
  0x000003ffffffefff, 0x000003fffffff000,
  0x000007ffffffdfff, 0x000007ffffffe000,
  0x00000fffffffbfff, 0x00000fffffffc000,
  0x00001fffffff7fff, 0x00001fffffff8000,
  0x00003ffffffeffff, 0x00003fffffff0000,
  0x00007ffffffdffff, 0x00007ffffffe0000,
  0x0000fffffffbffff, 0x0000fffffffc0000,
  0x0001fffffff7ffff, 0x0001fffffff80000,
  0x0003ffffffefffff, 0x0003fffffff00000,
  0x0007ffffffdfffff, 0x0007ffffffe00000,
  0x000fffffffbfffff, 0x000fffffffc00000,
  0x001fffffff7fffff, 0x001fffffff800000,
  0x003ffffffefffffe, 0x003fffffff000000,
  0x007ffffffdfffffc, 0x007ffffffe000000,
  0x00fffffffbfffff8, 0x00fffffffc000000,
  0x01fffffff7fffff0, 0x01fffffff8000000,
  0x03ffffffefffffe0, 0x03fffffff0000000,
  0x07ffffffdfffffc0, 0x07ffffffe0000000,
  0x0fffffffbfffff80, 0x0fffffffc0000000,
  0x1fffffff7fffff00, 0x1fffffff80000000,
  0x3ffffffefffffe00, 0x3fffffff00000000,
  0x7ffffffdfffffc00, 0x7ffffffe00000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x00000000fffffffc, 0x00000000fffffffc,
  0x00000001fffffff8, 0x00000001fffffff8,
  0x00000003fffffff0, 0x00000003fffffff0,
  0x00000007ffffffe0, 0x00000007ffffffe0,
  0x0000000fffffffc0, 0x0000000fffffffc0,
  0x0000001fffffff80, 0x0000001fffffff80,
  0x0000003fffffff00, 0x0000003fffffff00,
  0x0000007ffffffe00, 0x0000007ffffffe00,
  0x000000fffffffc00, 0x000000fffffffc00,
  0x000001fffffff800, 0x000001fffffff800,
  0x000003fffffff000, 0x000003fffffff000,
  0x000007ffffffe000, 0x000007ffffffe000,
  0x00000fffffffc000, 0x00000fffffffc000,
  0x00001fffffff8000, 0x00001fffffff8000,
  0x00003fffffff0000, 0x00003fffffff0000,
  0x00007ffffffe0000, 0x00007ffffffe0000,
  0x0000fffffffc0000, 0x0000fffffffc0000,
  0x0001fffffff80000, 0x0001fffffff80000,
  0x0003fffffff00000, 0x0003fffffff00000,
  0x0007ffffffe00000, 0x0007ffffffe00000,
  0x000fffffffc00000, 0x000fffffffc00000,
  0x001fffffff800000, 0x001fffffff800001,
  0x003fffffff000000, 0x003fffffff000002,
  0x007ffffffe000000, 0x007ffffffe000004,
  0x00fffffffc000000, 0x00fffffffc000008,
  0x01fffffff8000000, 0x01fffffff8000010,
  0x03fffffff0000000, 0x03fffffff0000020,
  0x07ffffffe0000000, 0x07ffffffe0000040,
  0x0fffffffc0000000, 0x0fffffffc0000080,
  0x1fffffff80000000, 0x1fffffff80000100,
  0x3fffffff00000000, 0x3fffffff00000200,
  0x7ffffffe00000000, 0x7ffffffe00000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x00000000fffffffc, 0x00000000fffffffc,
  0x00000001fffffff8, 0x00000001fffffff9,
  0x00000003fffffff0, 0x00000003fffffff3,
  0x00000007ffffffe0, 0x00000007ffffffe7,
  0x0000000fffffffc0, 0x0000000fffffffcf,
  0x0000001fffffff80, 0x0000001fffffff9f,
  0x0000003fffffff00, 0x0000003fffffff3f,
  0x0000007ffffffe00, 0x0000007ffffffe7f,
  0x000000fffffffc00, 0x000000fffffffcff,
  0x000001fffffff800, 0x000001fffffff9ff,
  0x000003fffffff000, 0x000003fffffff3ff,
  0x000007ffffffe000, 0x000007ffffffe7ff,
  0x00000fffffffc000, 0x00000fffffffcfff,
  0x00001fffffff8000, 0x00001fffffff9fff,
  0x00003fffffff0000, 0x00003fffffff3fff,
  0x00007ffffffe0000, 0x00007ffffffe7fff,
  0x0000fffffffc0000, 0x0000fffffffcffff,
  0x0001fffffff80000, 0x0001fffffff9ffff,
  0x0003fffffff00000, 0x0003fffffff3ffff,
  0x0007ffffffe00000, 0x0007ffffffe7ffff,
  0x000fffffffc00000, 0x000fffffffcfffff,
  0x001fffffff800001, 0x001fffffff9fffff,
  0x003fffffff000002, 0x003fffffff3ffffe,
  0x007ffffffe000004, 0x007ffffffe7ffffc,
  0x00fffffffc000008, 0x00fffffffcfffff8,
  0x01fffffff8000010, 0x01fffffff9fffff0,
  0x03fffffff0000020, 0x03fffffff3ffffe0,
  0x07ffffffe0000040, 0x07ffffffe7ffffc0,
  0x0fffffffc0000080, 0x0fffffffcfffff80,
  0x1fffffff80000100, 0x1fffffff9fffff00,
  0x3fffffff00000200, 0x3fffffff3ffffe00,
  0x7ffffffe00000400, 0x7ffffffe7ffffc00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x00000000fffffffc, 0x00000000fffffffd,
  0x00000001fffffff9, 0x00000001fffffffa,
  0x00000003fffffff3, 0x00000003fffffff4,
  0x00000007ffffffe7, 0x00000007ffffffe8,
  0x0000000fffffffcf, 0x0000000fffffffd0,
  0x0000001fffffff9f, 0x0000001fffffffa0,
  0x0000003fffffff3f, 0x0000003fffffff40,
  0x0000007ffffffe7f, 0x0000007ffffffe80,
  0x000000fffffffcff, 0x000000fffffffd00,
  0x000001fffffff9ff, 0x000001fffffffa00,
  0x000003fffffff3ff, 0x000003fffffff400,
  0x000007ffffffe7ff, 0x000007ffffffe800,
  0x00000fffffffcfff, 0x00000fffffffd000,
  0x00001fffffff9fff, 0x00001fffffffa000,
  0x00003fffffff3fff, 0x00003fffffff4000,
  0x00007ffffffe7fff, 0x00007ffffffe8000,
  0x0000fffffffcffff, 0x0000fffffffd0000,
  0x0001fffffff9ffff, 0x0001fffffffa0000,
  0x0003fffffff3ffff, 0x0003fffffff40000,
  0x0007ffffffe7ffff, 0x0007ffffffe80000,
  0x000fffffffcfffff, 0x000fffffffd00000,
  0x001fffffff9fffff, 0x001fffffffa00000,
  0x003fffffff3ffffe, 0x003fffffff400000,
  0x007ffffffe7ffffc, 0x007ffffffe800000,
  0x00fffffffcfffff8, 0x00fffffffd000000,
  0x01fffffff9fffff0, 0x01fffffffa000000,
  0x03fffffff3ffffe0, 0x03fffffff4000000,
  0x07ffffffe7ffffc0, 0x07ffffffe8000000,
  0x0fffffffcfffff80, 0x0fffffffd0000000,
  0x1fffffff9fffff00, 0x1fffffffa0000000,
  0x3fffffff3ffffe00, 0x3fffffff40000000,
  0x7ffffffe7ffffc00, 0x7ffffffe80000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x00000000fffffffd, 0x00000000fffffffd,
  0x00000001fffffffa, 0x00000001fffffffa,
  0x00000003fffffff4, 0x00000003fffffff4,
  0x00000007ffffffe8, 0x00000007ffffffe8,
  0x0000000fffffffd0, 0x0000000fffffffd0,
  0x0000001fffffffa0, 0x0000001fffffffa0,
  0x0000003fffffff40, 0x0000003fffffff40,
  0x0000007ffffffe80, 0x0000007ffffffe80,
  0x000000fffffffd00, 0x000000fffffffd00,
  0x000001fffffffa00, 0x000001fffffffa00,
  0x000003fffffff400, 0x000003fffffff400,
  0x000007ffffffe800, 0x000007ffffffe800,
  0x00000fffffffd000, 0x00000fffffffd000,
  0x00001fffffffa000, 0x00001fffffffa000,
  0x00003fffffff4000, 0x00003fffffff4000,
  0x00007ffffffe8000, 0x00007ffffffe8000,
  0x0000fffffffd0000, 0x0000fffffffd0000,
  0x0001fffffffa0000, 0x0001fffffffa0000,
  0x0003fffffff40000, 0x0003fffffff40000,
  0x0007ffffffe80000, 0x0007ffffffe80000,
  0x000fffffffd00000, 0x000fffffffd00000,
  0x001fffffffa00000, 0x001fffffffa00001,
  0x003fffffff400000, 0x003fffffff400002,
  0x007ffffffe800000, 0x007ffffffe800004,
  0x00fffffffd000000, 0x00fffffffd000008,
  0x01fffffffa000000, 0x01fffffffa000010,
  0x03fffffff4000000, 0x03fffffff4000020,
  0x07ffffffe8000000, 0x07ffffffe8000040,
  0x0fffffffd0000000, 0x0fffffffd0000080,
  0x1fffffffa0000000, 0x1fffffffa0000100,
  0x3fffffff40000000, 0x3fffffff40000200,
  0x7ffffffe80000000, 0x7ffffffe80000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x00000000fffffffd, 0x00000000fffffffd,
  0x00000001fffffffa, 0x00000001fffffffb,
  0x00000003fffffff4, 0x00000003fffffff7,
  0x00000007ffffffe8, 0x00000007ffffffef,
  0x0000000fffffffd0, 0x0000000fffffffdf,
  0x0000001fffffffa0, 0x0000001fffffffbf,
  0x0000003fffffff40, 0x0000003fffffff7f,
  0x0000007ffffffe80, 0x0000007ffffffeff,
  0x000000fffffffd00, 0x000000fffffffdff,
  0x000001fffffffa00, 0x000001fffffffbff,
  0x000003fffffff400, 0x000003fffffff7ff,
  0x000007ffffffe800, 0x000007ffffffefff,
  0x00000fffffffd000, 0x00000fffffffdfff,
  0x00001fffffffa000, 0x00001fffffffbfff,
  0x00003fffffff4000, 0x00003fffffff7fff,
  0x00007ffffffe8000, 0x00007ffffffeffff,
  0x0000fffffffd0000, 0x0000fffffffdffff,
  0x0001fffffffa0000, 0x0001fffffffbffff,
  0x0003fffffff40000, 0x0003fffffff7ffff,
  0x0007ffffffe80000, 0x0007ffffffefffff,
  0x000fffffffd00000, 0x000fffffffdfffff,
  0x001fffffffa00001, 0x001fffffffbfffff,
  0x003fffffff400002, 0x003fffffff7ffffe,
  0x007ffffffe800004, 0x007ffffffefffffc,
  0x00fffffffd000008, 0x00fffffffdfffff8,
  0x01fffffffa000010, 0x01fffffffbfffff0,
  0x03fffffff4000020, 0x03fffffff7ffffe0,
  0x07ffffffe8000040, 0x07ffffffefffffc0,
  0x0fffffffd0000080, 0x0fffffffdfffff80,
  0x1fffffffa0000100, 0x1fffffffbfffff00,
  0x3fffffff40000200, 0x3fffffff7ffffe00,
  0x7ffffffe80000400, 0x7ffffffefffffc00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000000007ffffffe, 0x000000007fffffff,
  0x00000000fffffffd, 0x00000000fffffffe,
  0x00000001fffffffb, 0x00000001fffffffc,
  0x00000003fffffff7, 0x00000003fffffff8,
  0x00000007ffffffef, 0x00000007fffffff0,
  0x0000000fffffffdf, 0x0000000fffffffe0,
  0x0000001fffffffbf, 0x0000001fffffffc0,
  0x0000003fffffff7f, 0x0000003fffffff80,
  0x0000007ffffffeff, 0x0000007fffffff00,
  0x000000fffffffdff, 0x000000fffffffe00,
  0x000001fffffffbff, 0x000001fffffffc00,
  0x000003fffffff7ff, 0x000003fffffff800,
  0x000007ffffffefff, 0x000007fffffff000,
  0x00000fffffffdfff, 0x00000fffffffe000,
  0x00001fffffffbfff, 0x00001fffffffc000,
  0x00003fffffff7fff, 0x00003fffffff8000,
  0x00007ffffffeffff, 0x00007fffffff0000,
  0x0000fffffffdffff, 0x0000fffffffe0000,
  0x0001fffffffbffff, 0x0001fffffffc0000,
  0x0003fffffff7ffff, 0x0003fffffff80000,
  0x0007ffffffefffff, 0x0007fffffff00000,
  0x000fffffffdfffff, 0x000fffffffe00000,
  0x001fffffffbfffff, 0x001fffffffc00000,
  0x003fffffff7ffffe, 0x003fffffff800000,
  0x007ffffffefffffc, 0x007fffffff000000,
  0x00fffffffdfffff8, 0x00fffffffe000000,
  0x01fffffffbfffff0, 0x01fffffffc000000,
  0x03fffffff7ffffe0, 0x03fffffff8000000,
  0x07ffffffefffffc0, 0x07fffffff0000000,
  0x0fffffffdfffff80, 0x0fffffffe0000000,
  0x1fffffffbfffff00, 0x1fffffffc0000000,
  0x3fffffff7ffffe00, 0x3fffffff80000000,
  0x7ffffffefffffc00, 0x7fffffff00000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000000007fffffff, 0x000000007fffffff,
  0x00000000fffffffe, 0x00000000fffffffe,
  0x00000001fffffffc, 0x00000001fffffffc,
  0x00000003fffffff8, 0x00000003fffffff8,
  0x00000007fffffff0, 0x00000007fffffff0,
  0x0000000fffffffe0, 0x0000000fffffffe0,
  0x0000001fffffffc0, 0x0000001fffffffc0,
  0x0000003fffffff80, 0x0000003fffffff80,
  0x0000007fffffff00, 0x0000007fffffff00,
  0x000000fffffffe00, 0x000000fffffffe00,
  0x000001fffffffc00, 0x000001fffffffc00,
  0x000003fffffff800, 0x000003fffffff800,
  0x000007fffffff000, 0x000007fffffff000,
  0x00000fffffffe000, 0x00000fffffffe000,
  0x00001fffffffc000, 0x00001fffffffc000,
  0x00003fffffff8000, 0x00003fffffff8000,
  0x00007fffffff0000, 0x00007fffffff0000,
  0x0000fffffffe0000, 0x0000fffffffe0000,
  0x0001fffffffc0000, 0x0001fffffffc0000,
  0x0003fffffff80000, 0x0003fffffff80000,
  0x0007fffffff00000, 0x0007fffffff00000,
  0x000fffffffe00000, 0x000fffffffe00000,
  0x001fffffffc00000, 0x001fffffffc00001,
  0x003fffffff800000, 0x003fffffff800002,
  0x007fffffff000000, 0x007fffffff000004,
  0x00fffffffe000000, 0x00fffffffe000008,
  0x01fffffffc000000, 0x01fffffffc000010,
  0x03fffffff8000000, 0x03fffffff8000020,
  0x07fffffff0000000, 0x07fffffff0000040,
  0x0fffffffe0000000, 0x0fffffffe0000080,
  0x1fffffffc0000000, 0x1fffffffc0000100,
  0x3fffffff80000000, 0x3fffffff80000200,
  0x7fffffff00000000, 0x7fffffff00000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000000007fffffff, 0x000000007fffffff,
  0x00000000fffffffe, 0x00000000fffffffe,
  0x00000001fffffffc, 0x00000001fffffffd,
  0x00000003fffffff8, 0x00000003fffffffb,
  0x00000007fffffff0, 0x00000007fffffff7,
  0x0000000fffffffe0, 0x0000000fffffffef,
  0x0000001fffffffc0, 0x0000001fffffffdf,
  0x0000003fffffff80, 0x0000003fffffffbf,
  0x0000007fffffff00, 0x0000007fffffff7f,
  0x000000fffffffe00, 0x000000fffffffeff,
  0x000001fffffffc00, 0x000001fffffffdff,
  0x000003fffffff800, 0x000003fffffffbff,
  0x000007fffffff000, 0x000007fffffff7ff,
  0x00000fffffffe000, 0x00000fffffffefff,
  0x00001fffffffc000, 0x00001fffffffdfff,
  0x00003fffffff8000, 0x00003fffffffbfff,
  0x00007fffffff0000, 0x00007fffffff7fff,
  0x0000fffffffe0000, 0x0000fffffffeffff,
  0x0001fffffffc0000, 0x0001fffffffdffff,
  0x0003fffffff80000, 0x0003fffffffbffff,
  0x0007fffffff00000, 0x0007fffffff7ffff,
  0x000fffffffe00000, 0x000fffffffefffff,
  0x001fffffffc00001, 0x001fffffffdfffff,
  0x003fffffff800002, 0x003fffffffbffffe,
  0x007fffffff000004, 0x007fffffff7ffffc,
  0x00fffffffe000008, 0x00fffffffefffff8,
  0x01fffffffc000010, 0x01fffffffdfffff0,
  0x03fffffff8000020, 0x03fffffffbffffe0,
  0x07fffffff0000040, 0x07fffffff7ffffc0,
  0x0fffffffe0000080, 0x0fffffffefffff80,
  0x1fffffffc0000100, 0x1fffffffdfffff00,
  0x3fffffff80000200, 0x3fffffffbffffe00,
  0x7fffffff00000400, 0x7fffffff7ffffc00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000000007fffffff, 0x000000007fffffff,
  0x00000000fffffffe, 0x00000000ffffffff,
  0x00000001fffffffd, 0x00000001fffffffe,
  0x00000003fffffffb, 0x00000003fffffffc,
  0x00000007fffffff7, 0x00000007fffffff8,
  0x0000000fffffffef, 0x0000000ffffffff0,
  0x0000001fffffffdf, 0x0000001fffffffe0,
  0x0000003fffffffbf, 0x0000003fffffffc0,
  0x0000007fffffff7f, 0x0000007fffffff80,
  0x000000fffffffeff, 0x000000ffffffff00,
  0x000001fffffffdff, 0x000001fffffffe00,
  0x000003fffffffbff, 0x000003fffffffc00,
  0x000007fffffff7ff, 0x000007fffffff800,
  0x00000fffffffefff, 0x00000ffffffff000,
  0x00001fffffffdfff, 0x00001fffffffe000,
  0x00003fffffffbfff, 0x00003fffffffc000,
  0x00007fffffff7fff, 0x00007fffffff8000,
  0x0000fffffffeffff, 0x0000ffffffff0000,
  0x0001fffffffdffff, 0x0001fffffffe0000,
  0x0003fffffffbffff, 0x0003fffffffc0000,
  0x0007fffffff7ffff, 0x0007fffffff80000,
  0x000fffffffefffff, 0x000ffffffff00000,
  0x001fffffffdfffff, 0x001fffffffe00000,
  0x003fffffffbffffe, 0x003fffffffc00000,
  0x007fffffff7ffffc, 0x007fffffff800000,
  0x00fffffffefffff8, 0x00ffffffff000000,
  0x01fffffffdfffff0, 0x01fffffffe000000,
  0x03fffffffbffffe0, 0x03fffffffc000000,
  0x07fffffff7ffffc0, 0x07fffffff8000000,
  0x0fffffffefffff80, 0x0ffffffff0000000,
  0x1fffffffdfffff00, 0x1fffffffe0000000,
  0x3fffffffbffffe00, 0x3fffffffc0000000,
  0x7fffffff7ffffc00, 0x7fffffff80000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000000007fffffff, 0x000000007fffffff,
  0x00000000ffffffff, 0x00000000ffffffff,
  0x00000001fffffffe, 0x00000001fffffffe,
  0x00000003fffffffc, 0x00000003fffffffc,
  0x00000007fffffff8, 0x00000007fffffff8,
  0x0000000ffffffff0, 0x0000000ffffffff0,
  0x0000001fffffffe0, 0x0000001fffffffe0,
  0x0000003fffffffc0, 0x0000003fffffffc0,
  0x0000007fffffff80, 0x0000007fffffff80,
  0x000000ffffffff00, 0x000000ffffffff00,
  0x000001fffffffe00, 0x000001fffffffe00,
  0x000003fffffffc00, 0x000003fffffffc00,
  0x000007fffffff800, 0x000007fffffff800,
  0x00000ffffffff000, 0x00000ffffffff000,
  0x00001fffffffe000, 0x00001fffffffe000,
  0x00003fffffffc000, 0x00003fffffffc000,
  0x00007fffffff8000, 0x00007fffffff8000,
  0x0000ffffffff0000, 0x0000ffffffff0000,
  0x0001fffffffe0000, 0x0001fffffffe0000,
  0x0003fffffffc0000, 0x0003fffffffc0000,
  0x0007fffffff80000, 0x0007fffffff80000,
  0x000ffffffff00000, 0x000ffffffff00000,
  0x001fffffffe00000, 0x001fffffffe00001,
  0x003fffffffc00000, 0x003fffffffc00002,
  0x007fffffff800000, 0x007fffffff800004,
  0x00ffffffff000000, 0x00ffffffff000008,
  0x01fffffffe000000, 0x01fffffffe000010,
  0x03fffffffc000000, 0x03fffffffc000020,
  0x07fffffff8000000, 0x07fffffff8000040,
  0x0ffffffff0000000, 0x0ffffffff0000080,
  0x1fffffffe0000000, 0x1fffffffe0000100,
  0x3fffffffc0000000, 0x3fffffffc0000200,
  0x7fffffff80000000, 0x7fffffff80000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x000000007fffffff, 0x00000000fffffffd,
  0x00000000ffffffff, 0x00000001fffffffb,
  0x00000001fffffffe, 0x00000003fffffff7,
  0x00000003fffffffc, 0x00000007ffffffef,
  0x00000007fffffff8, 0x0000000fffffffdf,
  0x0000000ffffffff0, 0x0000001fffffffbf,
  0x0000001fffffffe0, 0x0000003fffffff7f,
  0x0000003fffffffc0, 0x0000007ffffffeff,
  0x0000007fffffff80, 0x000000fffffffdff,
  0x000000ffffffff00, 0x000001fffffffbff,
  0x000001fffffffe00, 0x000003fffffff7ff,
  0x000003fffffffc00, 0x000007ffffffefff,
  0x000007fffffff800, 0x00000fffffffdfff,
  0x00000ffffffff000, 0x00001fffffffbfff,
  0x00001fffffffe000, 0x00003fffffff7fff,
  0x00003fffffffc000, 0x00007ffffffeffff,
  0x00007fffffff8000, 0x0000fffffffdffff,
  0x0000ffffffff0000, 0x0001fffffffbffff,
  0x0001fffffffe0000, 0x0003fffffff7ffff,
  0x0003fffffffc0000, 0x0007ffffffefffff,
  0x0007fffffff80000, 0x000fffffffdfffff,
  0x000ffffffff00000, 0x001fffffffbfffff,
  0x001fffffffe00001, 0x003fffffff7ffffe,
  0x003fffffffc00002, 0x007ffffffefffffc,
  0x007fffffff800004, 0x00fffffffdfffff8,
  0x00ffffffff000008, 0x01fffffffbfffff0,
  0x01fffffffe000010, 0x03fffffff7ffffe0,
  0x03fffffffc000020, 0x07ffffffefffffc0,
  0x07fffffff8000040, 0x0fffffffdfffff80,
  0x0ffffffff0000080, 0x1fffffffbfffff00,
  0x1fffffffe0000100, 0x3fffffff7ffffe00,
  0x3fffffffc0000200, 0x7ffffffefffffc00,
  0x7fffffff80000400, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000000fffffffd, 0x00000000fffffffe,
  0x00000001fffffffb, 0x00000001fffffffc,
  0x00000003fffffff7, 0x00000003fffffff8,
  0x00000007ffffffef, 0x00000007fffffff0,
  0x0000000fffffffdf, 0x0000000fffffffe0,
  0x0000001fffffffbf, 0x0000001fffffffc0,
  0x0000003fffffff7f, 0x0000003fffffff80,
  0x0000007ffffffeff, 0x0000007fffffff00,
  0x000000fffffffdff, 0x000000fffffffe00,
  0x000001fffffffbff, 0x000001fffffffc00,
  0x000003fffffff7ff, 0x000003fffffff800,
  0x000007ffffffefff, 0x000007fffffff000,
  0x00000fffffffdfff, 0x00000fffffffe000,
  0x00001fffffffbfff, 0x00001fffffffc000,
  0x00003fffffff7fff, 0x00003fffffff8000,
  0x00007ffffffeffff, 0x00007fffffff0000,
  0x0000fffffffdffff, 0x0000fffffffe0000,
  0x0001fffffffbffff, 0x0001fffffffc0000,
  0x0003fffffff7ffff, 0x0003fffffff80000,
  0x0007ffffffefffff, 0x0007fffffff00000,
  0x000fffffffdfffff, 0x000fffffffe00000,
  0x001fffffffbfffff, 0x001fffffffc00000,
  0x003fffffff7ffffe, 0x003fffffff800000,
  0x007ffffffefffffc, 0x007fffffff000000,
  0x00fffffffdfffff8, 0x00fffffffe000000,
  0x01fffffffbfffff0, 0x01fffffffc000000,
  0x03fffffff7ffffe0, 0x03fffffff8000000,
  0x07ffffffefffffc0, 0x07fffffff0000000,
  0x0fffffffdfffff80, 0x0fffffffe0000000,
  0x1fffffffbfffff00, 0x1fffffffc0000000,
  0x3fffffff7ffffe00, 0x3fffffff80000000,
  0x7ffffffefffffc00, 0x7fffffff00000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000000fffffffe, 0x00000000fffffffe,
  0x00000001fffffffc, 0x00000001fffffffc,
  0x00000003fffffff8, 0x00000003fffffff8,
  0x00000007fffffff0, 0x00000007fffffff0,
  0x0000000fffffffe0, 0x0000000fffffffe0,
  0x0000001fffffffc0, 0x0000001fffffffc0,
  0x0000003fffffff80, 0x0000003fffffff80,
  0x0000007fffffff00, 0x0000007fffffff00,
  0x000000fffffffe00, 0x000000fffffffe00,
  0x000001fffffffc00, 0x000001fffffffc00,
  0x000003fffffff800, 0x000003fffffff800,
  0x000007fffffff000, 0x000007fffffff000,
  0x00000fffffffe000, 0x00000fffffffe000,
  0x00001fffffffc000, 0x00001fffffffc000,
  0x00003fffffff8000, 0x00003fffffff8000,
  0x00007fffffff0000, 0x00007fffffff0000,
  0x0000fffffffe0000, 0x0000fffffffe0000,
  0x0001fffffffc0000, 0x0001fffffffc0000,
  0x0003fffffff80000, 0x0003fffffff80000,
  0x0007fffffff00000, 0x0007fffffff00000,
  0x000fffffffe00000, 0x000fffffffe00000,
  0x001fffffffc00000, 0x001fffffffc00001,
  0x003fffffff800000, 0x003fffffff800002,
  0x007fffffff000000, 0x007fffffff000004,
  0x00fffffffe000000, 0x00fffffffe000008,
  0x01fffffffc000000, 0x01fffffffc000010,
  0x03fffffff8000000, 0x03fffffff8000020,
  0x07fffffff0000000, 0x07fffffff0000040,
  0x0fffffffe0000000, 0x0fffffffe0000080,
  0x1fffffffc0000000, 0x1fffffffc0000100,
  0x3fffffff80000000, 0x3fffffff80000200,
  0x7fffffff00000000, 0x7fffffff00000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000000fffffffe, 0x00000000fffffffe,
  0x00000001fffffffc, 0x00000001fffffffc,
  0x00000003fffffff8, 0x00000003fffffff9,
  0x00000007fffffff0, 0x00000007fffffff3,
  0x0000000fffffffe0, 0x0000000fffffffe7,
  0x0000001fffffffc0, 0x0000001fffffffcf,
  0x0000003fffffff80, 0x0000003fffffff9f,
  0x0000007fffffff00, 0x0000007fffffff3f,
  0x000000fffffffe00, 0x000000fffffffe7f,
  0x000001fffffffc00, 0x000001fffffffcff,
  0x000003fffffff800, 0x000003fffffff9ff,
  0x000007fffffff000, 0x000007fffffff3ff,
  0x00000fffffffe000, 0x00000fffffffe7ff,
  0x00001fffffffc000, 0x00001fffffffcfff,
  0x00003fffffff8000, 0x00003fffffff9fff,
  0x00007fffffff0000, 0x00007fffffff3fff,
  0x0000fffffffe0000, 0x0000fffffffe7fff,
  0x0001fffffffc0000, 0x0001fffffffcffff,
  0x0003fffffff80000, 0x0003fffffff9ffff,
  0x0007fffffff00000, 0x0007fffffff3ffff,
  0x000fffffffe00000, 0x000fffffffe7ffff,
  0x001fffffffc00001, 0x001fffffffcfffff,
  0x003fffffff800002, 0x003fffffff9ffffe,
  0x007fffffff000004, 0x007fffffff3ffffc,
  0x00fffffffe000008, 0x00fffffffe7ffff8,
  0x01fffffffc000010, 0x01fffffffcfffff0,
  0x03fffffff8000020, 0x03fffffff9ffffe0,
  0x07fffffff0000040, 0x07fffffff3ffffc0,
  0x0fffffffe0000080, 0x0fffffffe7ffff80,
  0x1fffffffc0000100, 0x1fffffffcfffff00,
  0x3fffffff80000200, 0x3fffffff9ffffe00,
  0x7fffffff00000400, 0x7fffffff3ffffc00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000000fffffffe, 0x00000000fffffffe,
  0x00000001fffffffc, 0x00000001fffffffd,
  0x00000003fffffff9, 0x00000003fffffffa,
  0x00000007fffffff3, 0x00000007fffffff4,
  0x0000000fffffffe7, 0x0000000fffffffe8,
  0x0000001fffffffcf, 0x0000001fffffffd0,
  0x0000003fffffff9f, 0x0000003fffffffa0,
  0x0000007fffffff3f, 0x0000007fffffff40,
  0x000000fffffffe7f, 0x000000fffffffe80,
  0x000001fffffffcff, 0x000001fffffffd00,
  0x000003fffffff9ff, 0x000003fffffffa00,
  0x000007fffffff3ff, 0x000007fffffff400,
  0x00000fffffffe7ff, 0x00000fffffffe800,
  0x00001fffffffcfff, 0x00001fffffffd000,
  0x00003fffffff9fff, 0x00003fffffffa000,
  0x00007fffffff3fff, 0x00007fffffff4000,
  0x0000fffffffe7fff, 0x0000fffffffe8000,
  0x0001fffffffcffff, 0x0001fffffffd0000,
  0x0003fffffff9ffff, 0x0003fffffffa0000,
  0x0007fffffff3ffff, 0x0007fffffff40000,
  0x000fffffffe7ffff, 0x000fffffffe80000,
  0x001fffffffcfffff, 0x001fffffffd00000,
  0x003fffffff9ffffe, 0x003fffffffa00000,
  0x007fffffff3ffffc, 0x007fffffff400000,
  0x00fffffffe7ffff8, 0x00fffffffe800000,
  0x01fffffffcfffff0, 0x01fffffffd000000,
  0x03fffffff9ffffe0, 0x03fffffffa000000,
  0x07fffffff3ffffc0, 0x07fffffff4000000,
  0x0fffffffe7ffff80, 0x0fffffffe8000000,
  0x1fffffffcfffff00, 0x1fffffffd0000000,
  0x3fffffff9ffffe00, 0x3fffffffa0000000,
  0x7fffffff3ffffc00, 0x7fffffff40000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000000fffffffe, 0x00000000fffffffe,
  0x00000001fffffffd, 0x00000001fffffffd,
  0x00000003fffffffa, 0x00000003fffffffa,
  0x00000007fffffff4, 0x00000007fffffff4,
  0x0000000fffffffe8, 0x0000000fffffffe8,
  0x0000001fffffffd0, 0x0000001fffffffd0,
  0x0000003fffffffa0, 0x0000003fffffffa0,
  0x0000007fffffff40, 0x0000007fffffff40,
  0x000000fffffffe80, 0x000000fffffffe80,
  0x000001fffffffd00, 0x000001fffffffd00,
  0x000003fffffffa00, 0x000003fffffffa00,
  0x000007fffffff400, 0x000007fffffff400,
  0x00000fffffffe800, 0x00000fffffffe800,
  0x00001fffffffd000, 0x00001fffffffd000,
  0x00003fffffffa000, 0x00003fffffffa000,
  0x00007fffffff4000, 0x00007fffffff4000,
  0x0000fffffffe8000, 0x0000fffffffe8000,
  0x0001fffffffd0000, 0x0001fffffffd0000,
  0x0003fffffffa0000, 0x0003fffffffa0000,
  0x0007fffffff40000, 0x0007fffffff40000,
  0x000fffffffe80000, 0x000fffffffe80000,
  0x001fffffffd00000, 0x001fffffffd00001,
  0x003fffffffa00000, 0x003fffffffa00002,
  0x007fffffff400000, 0x007fffffff400004,
  0x00fffffffe800000, 0x00fffffffe800008,
  0x01fffffffd000000, 0x01fffffffd000010,
  0x03fffffffa000000, 0x03fffffffa000020,
  0x07fffffff4000000, 0x07fffffff4000040,
  0x0fffffffe8000000, 0x0fffffffe8000080,
  0x1fffffffd0000000, 0x1fffffffd0000100,
  0x3fffffffa0000000, 0x3fffffffa0000200,
  0x7fffffff40000000, 0x7fffffff40000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000000fffffffe, 0x00000000fffffffe,
  0x00000001fffffffd, 0x00000001fffffffd,
  0x00000003fffffffa, 0x00000003fffffffb,
  0x00000007fffffff4, 0x00000007fffffff7,
  0x0000000fffffffe8, 0x0000000fffffffef,
  0x0000001fffffffd0, 0x0000001fffffffdf,
  0x0000003fffffffa0, 0x0000003fffffffbf,
  0x0000007fffffff40, 0x0000007fffffff7f,
  0x000000fffffffe80, 0x000000fffffffeff,
  0x000001fffffffd00, 0x000001fffffffdff,
  0x000003fffffffa00, 0x000003fffffffbff,
  0x000007fffffff400, 0x000007fffffff7ff,
  0x00000fffffffe800, 0x00000fffffffefff,
  0x00001fffffffd000, 0x00001fffffffdfff,
  0x00003fffffffa000, 0x00003fffffffbfff,
  0x00007fffffff4000, 0x00007fffffff7fff,
  0x0000fffffffe8000, 0x0000fffffffeffff,
  0x0001fffffffd0000, 0x0001fffffffdffff,
  0x0003fffffffa0000, 0x0003fffffffbffff,
  0x0007fffffff40000, 0x0007fffffff7ffff,
  0x000fffffffe80000, 0x000fffffffefffff,
  0x001fffffffd00001, 0x001fffffffdfffff,
  0x003fffffffa00002, 0x003fffffffbffffe,
  0x007fffffff400004, 0x007fffffff7ffffc,
  0x00fffffffe800008, 0x00fffffffefffff8,
  0x01fffffffd000010, 0x01fffffffdfffff0,
  0x03fffffffa000020, 0x03fffffffbffffe0,
  0x07fffffff4000040, 0x07fffffff7ffffc0,
  0x0fffffffe8000080, 0x0fffffffefffff80,
  0x1fffffffd0000100, 0x1fffffffdfffff00,
  0x3fffffffa0000200, 0x3fffffffbffffe00,
  0x7fffffff40000400, 0x7fffffff7ffffc00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000000fffffffe, 0x00000000ffffffff,
  0x00000001fffffffd, 0x00000001fffffffe,
  0x00000003fffffffb, 0x00000003fffffffc,
  0x00000007fffffff7, 0x00000007fffffff8,
  0x0000000fffffffef, 0x0000000ffffffff0,
  0x0000001fffffffdf, 0x0000001fffffffe0,
  0x0000003fffffffbf, 0x0000003fffffffc0,
  0x0000007fffffff7f, 0x0000007fffffff80,
  0x000000fffffffeff, 0x000000ffffffff00,
  0x000001fffffffdff, 0x000001fffffffe00,
  0x000003fffffffbff, 0x000003fffffffc00,
  0x000007fffffff7ff, 0x000007fffffff800,
  0x00000fffffffefff, 0x00000ffffffff000,
  0x00001fffffffdfff, 0x00001fffffffe000,
  0x00003fffffffbfff, 0x00003fffffffc000,
  0x00007fffffff7fff, 0x00007fffffff8000,
  0x0000fffffffeffff, 0x0000ffffffff0000,
  0x0001fffffffdffff, 0x0001fffffffe0000,
  0x0003fffffffbffff, 0x0003fffffffc0000,
  0x0007fffffff7ffff, 0x0007fffffff80000,
  0x000fffffffefffff, 0x000ffffffff00000,
  0x001fffffffdfffff, 0x001fffffffe00000,
  0x003fffffffbffffe, 0x003fffffffc00000,
  0x007fffffff7ffffc, 0x007fffffff800000,
  0x00fffffffefffff8, 0x00ffffffff000000,
  0x01fffffffdfffff0, 0x01fffffffe000000,
  0x03fffffffbffffe0, 0x03fffffffc000000,
  0x07fffffff7ffffc0, 0x07fffffff8000000,
  0x0fffffffefffff80, 0x0ffffffff0000000,
  0x1fffffffdfffff00, 0x1fffffffe0000000,
  0x3fffffffbffffe00, 0x3fffffffc0000000,
  0x7fffffff7ffffc00, 0x7fffffff80000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000000ffffffff, 0x00000000ffffffff,
  0x00000001fffffffe, 0x00000001fffffffe,
  0x00000003fffffffc, 0x00000003fffffffc,
  0x00000007fffffff8, 0x00000007fffffff8,
  0x0000000ffffffff0, 0x0000000ffffffff0,
  0x0000001fffffffe0, 0x0000001fffffffe0,
  0x0000003fffffffc0, 0x0000003fffffffc0,
  0x0000007fffffff80, 0x0000007fffffff80,
  0x000000ffffffff00, 0x000000ffffffff00,
  0x000001fffffffe00, 0x000001fffffffe00,
  0x000003fffffffc00, 0x000003fffffffc00,
  0x000007fffffff800, 0x000007fffffff800,
  0x00000ffffffff000, 0x00000ffffffff000,
  0x00001fffffffe000, 0x00001fffffffe000,
  0x00003fffffffc000, 0x00003fffffffc000,
  0x00007fffffff8000, 0x00007fffffff8000,
  0x0000ffffffff0000, 0x0000ffffffff0000,
  0x0001fffffffe0000, 0x0001fffffffe0000,
  0x0003fffffffc0000, 0x0003fffffffc0000,
  0x0007fffffff80000, 0x0007fffffff80000,
  0x000ffffffff00000, 0x000ffffffff00000,
  0x001fffffffe00000, 0x001fffffffe00001,
  0x003fffffffc00000, 0x003fffffffc00002,
  0x007fffffff800000, 0x007fffffff800004,
  0x00ffffffff000000, 0x00ffffffff000008,
  0x01fffffffe000000, 0x01fffffffe000010,
  0x03fffffffc000000, 0x03fffffffc000020,
  0x07fffffff8000000, 0x07fffffff8000040,
  0x0ffffffff0000000, 0x0ffffffff0000080,
  0x1fffffffe0000000, 0x1fffffffe0000100,
  0x3fffffffc0000000, 0x3fffffffc0000200,
  0x7fffffff80000000, 0x7fffffff80000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000000ffffffff, 0x00000000ffffffff,
  0x00000001fffffffe, 0x00000001fffffffe,
  0x00000003fffffffc, 0x00000003fffffffd,
  0x00000007fffffff8, 0x00000007fffffffb,
  0x0000000ffffffff0, 0x0000000ffffffff7,
  0x0000001fffffffe0, 0x0000001fffffffef,
  0x0000003fffffffc0, 0x0000003fffffffdf,
  0x0000007fffffff80, 0x0000007fffffffbf,
  0x000000ffffffff00, 0x000000ffffffff7f,
  0x000001fffffffe00, 0x000001fffffffeff,
  0x000003fffffffc00, 0x000003fffffffdff,
  0x000007fffffff800, 0x000007fffffffbff,
  0x00000ffffffff000, 0x00000ffffffff7ff,
  0x00001fffffffe000, 0x00001fffffffefff,
  0x00003fffffffc000, 0x00003fffffffdfff,
  0x00007fffffff8000, 0x00007fffffffbfff,
  0x0000ffffffff0000, 0x0000ffffffff7fff,
  0x0001fffffffe0000, 0x0001fffffffeffff,
  0x0003fffffffc0000, 0x0003fffffffdffff,
  0x0007fffffff80000, 0x0007fffffffbffff,
  0x000ffffffff00000, 0x000ffffffff7ffff,
  0x001fffffffe00001, 0x001fffffffefffff,
  0x003fffffffc00002, 0x003fffffffdffffe,
  0x007fffffff800004, 0x007fffffffbffffc,
  0x00ffffffff000008, 0x00ffffffff7ffff8,
  0x01fffffffe000010, 0x01fffffffefffff0,
  0x03fffffffc000020, 0x03fffffffdffffe0,
  0x07fffffff8000040, 0x07fffffffbffffc0,
  0x0ffffffff0000080, 0x0ffffffff7ffff80,
  0x1fffffffe0000100, 0x1fffffffefffff00,
  0x3fffffffc0000200, 0x3fffffffdffffe00,
  0x7fffffff80000400, 0x7fffffffbffffc00,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000000ffffffff, 0x00000000ffffffff,
  0x00000001fffffffe, 0x00000001ffffffff,
  0x00000003fffffffd, 0x00000003fffffffe,
  0x00000007fffffffb, 0x00000007fffffffc,
  0x0000000ffffffff7, 0x0000000ffffffff8,
  0x0000001fffffffef, 0x0000001ffffffff0,
  0x0000003fffffffdf, 0x0000003fffffffe0,
  0x0000007fffffffbf, 0x0000007fffffffc0,
  0x000000ffffffff7f, 0x000000ffffffff80,
  0x000001fffffffeff, 0x000001ffffffff00,
  0x000003fffffffdff, 0x000003fffffffe00,
  0x000007fffffffbff, 0x000007fffffffc00,
  0x00000ffffffff7ff, 0x00000ffffffff800,
  0x00001fffffffefff, 0x00001ffffffff000,
  0x00003fffffffdfff, 0x00003fffffffe000,
  0x00007fffffffbfff, 0x00007fffffffc000,
  0x0000ffffffff7fff, 0x0000ffffffff8000,
  0x0001fffffffeffff, 0x0001ffffffff0000,
  0x0003fffffffdffff, 0x0003fffffffe0000,
  0x0007fffffffbffff, 0x0007fffffffc0000,
  0x000ffffffff7ffff, 0x000ffffffff80000,
  0x001fffffffefffff, 0x001ffffffff00000,
  0x003fffffffdffffe, 0x003fffffffe00000,
  0x007fffffffbffffc, 0x007fffffffc00000,
  0x00ffffffff7ffff8, 0x00ffffffff800000,
  0x01fffffffefffff0, 0x01ffffffff000000,
  0x03fffffffdffffe0, 0x03fffffffe000000,
  0x07fffffffbffffc0, 0x07fffffffc000000,
  0x0ffffffff7ffff80, 0x0ffffffff8000000,
  0x1fffffffefffff00, 0x1ffffffff0000000,
  0x3fffffffdffffe00, 0x3fffffffe0000000,
  0x7fffffffbffffc00, 0x7fffffffc0000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000000ffffffff, 0x00000000ffffffff,
  0x00000001ffffffff, 0x00000001ffffffff,
  0x00000003fffffffe, 0x00000003fffffffe,
  0x00000007fffffffc, 0x00000007fffffffc,
  0x0000000ffffffff8, 0x0000000ffffffff8,
  0x0000001ffffffff0, 0x0000001ffffffff0,
  0x0000003fffffffe0, 0x0000003fffffffe0,
  0x0000007fffffffc0, 0x0000007fffffffc0,
  0x000000ffffffff80, 0x000000ffffffff80,
  0x000001ffffffff00, 0x000001ffffffff00,
  0x000003fffffffe00, 0x000003fffffffe00,
  0x000007fffffffc00, 0x000007fffffffc00,
  0x00000ffffffff800, 0x00000ffffffff800,
  0x00001ffffffff000, 0x00001ffffffff000,
  0x00003fffffffe000, 0x00003fffffffe000,
  0x00007fffffffc000, 0x00007fffffffc000,
  0x0000ffffffff8000, 0x0000ffffffff8000,
  0x0001ffffffff0000, 0x0001ffffffff0000,
  0x0003fffffffe0000, 0x0003fffffffe0000,
  0x0007fffffffc0000, 0x0007fffffffc0000,
  0x000ffffffff80000, 0x000ffffffff80000,
  0x001ffffffff00000, 0x001ffffffff00001,
  0x003fffffffe00000, 0x003fffffffe00002,
  0x007fffffffc00000, 0x007fffffffc00004,
  0x00ffffffff800000, 0x00ffffffff800008,
  0x01ffffffff000000, 0x01ffffffff000010,
  0x03fffffffe000000, 0x03fffffffe000020,
  0x07fffffffc000000, 0x07fffffffc000040,
  0x0ffffffff8000000, 0x0ffffffff8000080,
  0x1ffffffff0000000, 0x1ffffffff0000100,
  0x3fffffffe0000000, 0x3fffffffe0000200,
  0x7fffffffc0000000, 0x7fffffffc0000400,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
};
const unsigned kExpectedCount_NEON_fcvtzs_2D_2OPIMM = 13455;

#endif  // VIXL_SIM_FCVTZS_2D_2OPIMM_TRACE_AARCH64_H_
