// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_ASSEMBLER_COND_RD_RN_RM_SEL_A32_H_
#define VIXL_ASSEMBLER_COND_RD_RN_RM_SEL_A32_H_

const byte kInstruction_sel_hi_r1_r9_r5[] = {
  0xb5, 0x1f, 0x89, 0x86 // sel hi r1 r9 r5
};
const byte kInstruction_sel_pl_r8_r6_r2[] = {
  0xb2, 0x8f, 0x86, 0x56 // sel pl r8 r6 r2
};
const byte kInstruction_sel_hi_r5_r8_r2[] = {
  0xb2, 0x5f, 0x88, 0x86 // sel hi r5 r8 r2
};
const byte kInstruction_sel_vc_r9_r2_r7[] = {
  0xb7, 0x9f, 0x82, 0x76 // sel vc r9 r2 r7
};
const byte kInstruction_sel_lt_r4_r6_r3[] = {
  0xb3, 0x4f, 0x86, 0xb6 // sel lt r4 r6 r3
};
const byte kInstruction_sel_le_r11_r6_r2[] = {
  0xb2, 0xbf, 0x86, 0xd6 // sel le r11 r6 r2
};
const byte kInstruction_sel_cc_r8_r14_r4[] = {
  0xb4, 0x8f, 0x8e, 0x36 // sel cc r8 r14 r4
};
const byte kInstruction_sel_le_r5_r14_r6[] = {
  0xb6, 0x5f, 0x8e, 0xd6 // sel le r5 r14 r6
};
const byte kInstruction_sel_lt_r6_r1_r0[] = {
  0xb0, 0x6f, 0x81, 0xb6 // sel lt r6 r1 r0
};
const byte kInstruction_sel_lt_r5_r0_r9[] = {
  0xb9, 0x5f, 0x80, 0xb6 // sel lt r5 r0 r9
};
const byte kInstruction_sel_le_r8_r12_r7[] = {
  0xb7, 0x8f, 0x8c, 0xd6 // sel le r8 r12 r7
};
const byte kInstruction_sel_eq_r7_r14_r6[] = {
  0xb6, 0x7f, 0x8e, 0x06 // sel eq r7 r14 r6
};
const byte kInstruction_sel_cs_r7_r4_r6[] = {
  0xb6, 0x7f, 0x84, 0x26 // sel cs r7 r4 r6
};
const byte kInstruction_sel_gt_r9_r6_r9[] = {
  0xb9, 0x9f, 0x86, 0xc6 // sel gt r9 r6 r9
};
const byte kInstruction_sel_ne_r13_r9_r1[] = {
  0xb1, 0xdf, 0x89, 0x16 // sel ne r13 r9 r1
};
const byte kInstruction_sel_ge_r13_r1_r13[] = {
  0xbd, 0xdf, 0x81, 0xa6 // sel ge r13 r1 r13
};
const byte kInstruction_sel_ls_r8_r10_r2[] = {
  0xb2, 0x8f, 0x8a, 0x96 // sel ls r8 r10 r2
};
const byte kInstruction_sel_hi_r0_r13_r5[] = {
  0xb5, 0x0f, 0x8d, 0x86 // sel hi r0 r13 r5
};
const byte kInstruction_sel_pl_r13_r7_r8[] = {
  0xb8, 0xdf, 0x87, 0x56 // sel pl r13 r7 r8
};
const byte kInstruction_sel_ge_r4_r13_r11[] = {
  0xbb, 0x4f, 0x8d, 0xa6 // sel ge r4 r13 r11
};
const byte kInstruction_sel_cs_r5_r10_r5[] = {
  0xb5, 0x5f, 0x8a, 0x26 // sel cs r5 r10 r5
};
const byte kInstruction_sel_cs_r5_r4_r3[] = {
  0xb3, 0x5f, 0x84, 0x26 // sel cs r5 r4 r3
};
const byte kInstruction_sel_ls_r6_r14_r8[] = {
  0xb8, 0x6f, 0x8e, 0x96 // sel ls r6 r14 r8
};
const byte kInstruction_sel_vs_r3_r8_r6[] = {
  0xb6, 0x3f, 0x88, 0x66 // sel vs r3 r8 r6
};
const byte kInstruction_sel_vc_r7_r12_r3[] = {
  0xb3, 0x7f, 0x8c, 0x76 // sel vc r7 r12 r3
};
const byte kInstruction_sel_ge_r1_r4_r1[] = {
  0xb1, 0x1f, 0x84, 0xa6 // sel ge r1 r4 r1
};
const byte kInstruction_sel_cc_r4_r7_r10[] = {
  0xba, 0x4f, 0x87, 0x36 // sel cc r4 r7 r10
};
const byte kInstruction_sel_cc_r2_r0_r13[] = {
  0xbd, 0x2f, 0x80, 0x36 // sel cc r2 r0 r13
};
const byte kInstruction_sel_vs_r9_r6_r8[] = {
  0xb8, 0x9f, 0x86, 0x66 // sel vs r9 r6 r8
};
const byte kInstruction_sel_cs_r14_r11_r13[] = {
  0xbd, 0xef, 0x8b, 0x26 // sel cs r14 r11 r13
};
const byte kInstruction_sel_pl_r5_r8_r4[] = {
  0xb4, 0x5f, 0x88, 0x56 // sel pl r5 r8 r4
};
const byte kInstruction_sel_pl_r2_r3_r7[] = {
  0xb7, 0x2f, 0x83, 0x56 // sel pl r2 r3 r7
};
const byte kInstruction_sel_cs_r7_r12_r14[] = {
  0xbe, 0x7f, 0x8c, 0x26 // sel cs r7 r12 r14
};
const byte kInstruction_sel_hi_r6_r6_r1[] = {
  0xb1, 0x6f, 0x86, 0x86 // sel hi r6 r6 r1
};
const byte kInstruction_sel_cc_r6_r9_r6[] = {
  0xb6, 0x6f, 0x89, 0x36 // sel cc r6 r9 r6
};
const byte kInstruction_sel_ne_r12_r12_r0[] = {
  0xb0, 0xcf, 0x8c, 0x16 // sel ne r12 r12 r0
};
const byte kInstruction_sel_cc_r9_r3_r8[] = {
  0xb8, 0x9f, 0x83, 0x36 // sel cc r9 r3 r8
};
const byte kInstruction_sel_mi_r13_r6_r1[] = {
  0xb1, 0xdf, 0x86, 0x46 // sel mi r13 r6 r1
};
const byte kInstruction_sel_lt_r4_r8_r6[] = {
  0xb6, 0x4f, 0x88, 0xb6 // sel lt r4 r8 r6
};
const byte kInstruction_sel_hi_r11_r5_r9[] = {
  0xb9, 0xbf, 0x85, 0x86 // sel hi r11 r5 r9
};
const byte kInstruction_sel_cc_r6_r10_r6[] = {
  0xb6, 0x6f, 0x8a, 0x36 // sel cc r6 r10 r6
};
const byte kInstruction_sel_eq_r10_r10_r5[] = {
  0xb5, 0xaf, 0x8a, 0x06 // sel eq r10 r10 r5
};
const byte kInstruction_sel_al_r5_r4_r11[] = {
  0xbb, 0x5f, 0x84, 0xe6 // sel al r5 r4 r11
};
const byte kInstruction_sel_pl_r11_r11_r2[] = {
  0xb2, 0xbf, 0x8b, 0x56 // sel pl r11 r11 r2
};
const byte kInstruction_sel_ls_r6_r14_r12[] = {
  0xbc, 0x6f, 0x8e, 0x96 // sel ls r6 r14 r12
};
const byte kInstruction_sel_vc_r7_r7_r2[] = {
  0xb2, 0x7f, 0x87, 0x76 // sel vc r7 r7 r2
};
const byte kInstruction_sel_eq_r10_r8_r4[] = {
  0xb4, 0xaf, 0x88, 0x06 // sel eq r10 r8 r4
};
const byte kInstruction_sel_al_r14_r7_r2[] = {
  0xb2, 0xef, 0x87, 0xe6 // sel al r14 r7 r2
};
const byte kInstruction_sel_cs_r3_r11_r10[] = {
  0xba, 0x3f, 0x8b, 0x26 // sel cs r3 r11 r10
};
const byte kInstruction_sel_ls_r11_r4_r0[] = {
  0xb0, 0xbf, 0x84, 0x96 // sel ls r11 r4 r0
};
const byte kInstruction_sel_hi_r11_r8_r9[] = {
  0xb9, 0xbf, 0x88, 0x86 // sel hi r11 r8 r9
};
const byte kInstruction_sel_vs_r2_r14_r13[] = {
  0xbd, 0x2f, 0x8e, 0x66 // sel vs r2 r14 r13
};
const byte kInstruction_sel_al_r1_r13_r9[] = {
  0xb9, 0x1f, 0x8d, 0xe6 // sel al r1 r13 r9
};
const byte kInstruction_sel_eq_r3_r9_r13[] = {
  0xbd, 0x3f, 0x89, 0x06 // sel eq r3 r9 r13
};
const byte kInstruction_sel_ge_r10_r3_r13[] = {
  0xbd, 0xaf, 0x83, 0xa6 // sel ge r10 r3 r13
};
const byte kInstruction_sel_pl_r8_r5_r10[] = {
  0xba, 0x8f, 0x85, 0x56 // sel pl r8 r5 r10
};
const byte kInstruction_sel_vc_r8_r11_r6[] = {
  0xb6, 0x8f, 0x8b, 0x76 // sel vc r8 r11 r6
};
const byte kInstruction_sel_eq_r0_r0_r5[] = {
  0xb5, 0x0f, 0x80, 0x06 // sel eq r0 r0 r5
};
const byte kInstruction_sel_ne_r6_r5_r8[] = {
  0xb8, 0x6f, 0x85, 0x16 // sel ne r6 r5 r8
};
const byte kInstruction_sel_hi_r5_r13_r3[] = {
  0xb3, 0x5f, 0x8d, 0x86 // sel hi r5 r13 r3
};
const byte kInstruction_sel_ne_r11_r14_r14[] = {
  0xbe, 0xbf, 0x8e, 0x16 // sel ne r11 r14 r14
};
const byte kInstruction_sel_mi_r1_r0_r6[] = {
  0xb6, 0x1f, 0x80, 0x46 // sel mi r1 r0 r6
};
const byte kInstruction_sel_le_r14_r8_r2[] = {
  0xb2, 0xef, 0x88, 0xd6 // sel le r14 r8 r2
};
const byte kInstruction_sel_eq_r9_r6_r5[] = {
  0xb5, 0x9f, 0x86, 0x06 // sel eq r9 r6 r5
};
const byte kInstruction_sel_eq_r11_r0_r13[] = {
  0xbd, 0xbf, 0x80, 0x06 // sel eq r11 r0 r13
};
const byte kInstruction_sel_pl_r4_r5_r14[] = {
  0xbe, 0x4f, 0x85, 0x56 // sel pl r4 r5 r14
};
const byte kInstruction_sel_cs_r13_r5_r13[] = {
  0xbd, 0xdf, 0x85, 0x26 // sel cs r13 r5 r13
};
const byte kInstruction_sel_mi_r0_r13_r8[] = {
  0xb8, 0x0f, 0x8d, 0x46 // sel mi r0 r13 r8
};
const byte kInstruction_sel_lt_r2_r13_r3[] = {
  0xb3, 0x2f, 0x8d, 0xb6 // sel lt r2 r13 r3
};
const byte kInstruction_sel_ls_r8_r1_r11[] = {
  0xbb, 0x8f, 0x81, 0x96 // sel ls r8 r1 r11
};
const byte kInstruction_sel_vc_r14_r11_r8[] = {
  0xb8, 0xef, 0x8b, 0x76 // sel vc r14 r11 r8
};
const byte kInstruction_sel_lt_r4_r13_r12[] = {
  0xbc, 0x4f, 0x8d, 0xb6 // sel lt r4 r13 r12
};
const byte kInstruction_sel_eq_r2_r1_r14[] = {
  0xbe, 0x2f, 0x81, 0x06 // sel eq r2 r1 r14
};
const byte kInstruction_sel_eq_r9_r4_r14[] = {
  0xbe, 0x9f, 0x84, 0x06 // sel eq r9 r4 r14
};
const byte kInstruction_sel_hi_r10_r6_r13[] = {
  0xbd, 0xaf, 0x86, 0x86 // sel hi r10 r6 r13
};
const byte kInstruction_sel_ge_r12_r9_r4[] = {
  0xb4, 0xcf, 0x89, 0xa6 // sel ge r12 r9 r4
};
const byte kInstruction_sel_le_r9_r11_r14[] = {
  0xbe, 0x9f, 0x8b, 0xd6 // sel le r9 r11 r14
};
const byte kInstruction_sel_ls_r0_r9_r5[] = {
  0xb5, 0x0f, 0x89, 0x96 // sel ls r0 r9 r5
};
const byte kInstruction_sel_mi_r2_r3_r8[] = {
  0xb8, 0x2f, 0x83, 0x46 // sel mi r2 r3 r8
};
const byte kInstruction_sel_ne_r14_r10_r14[] = {
  0xbe, 0xef, 0x8a, 0x16 // sel ne r14 r10 r14
};
const byte kInstruction_sel_eq_r6_r2_r10[] = {
  0xba, 0x6f, 0x82, 0x06 // sel eq r6 r2 r10
};
const byte kInstruction_sel_lt_r11_r0_r12[] = {
  0xbc, 0xbf, 0x80, 0xb6 // sel lt r11 r0 r12
};
const byte kInstruction_sel_ne_r1_r12_r10[] = {
  0xba, 0x1f, 0x8c, 0x16 // sel ne r1 r12 r10
};
const byte kInstruction_sel_cc_r1_r0_r2[] = {
  0xb2, 0x1f, 0x80, 0x36 // sel cc r1 r0 r2
};
const byte kInstruction_sel_al_r5_r5_r7[] = {
  0xb7, 0x5f, 0x85, 0xe6 // sel al r5 r5 r7
};
const byte kInstruction_sel_hi_r7_r13_r1[] = {
  0xb1, 0x7f, 0x8d, 0x86 // sel hi r7 r13 r1
};
const byte kInstruction_sel_cs_r4_r4_r9[] = {
  0xb9, 0x4f, 0x84, 0x26 // sel cs r4 r4 r9
};
const byte kInstruction_sel_eq_r14_r4_r14[] = {
  0xbe, 0xef, 0x84, 0x06 // sel eq r14 r4 r14
};
const byte kInstruction_sel_vs_r10_r5_r14[] = {
  0xbe, 0xaf, 0x85, 0x66 // sel vs r10 r5 r14
};
const byte kInstruction_sel_gt_r4_r3_r11[] = {
  0xbb, 0x4f, 0x83, 0xc6 // sel gt r4 r3 r11
};
const byte kInstruction_sel_ne_r14_r10_r12[] = {
  0xbc, 0xef, 0x8a, 0x16 // sel ne r14 r10 r12
};
const byte kInstruction_sel_vs_r2_r11_r0[] = {
  0xb0, 0x2f, 0x8b, 0x66 // sel vs r2 r11 r0
};
const byte kInstruction_sel_ge_r5_r12_r7[] = {
  0xb7, 0x5f, 0x8c, 0xa6 // sel ge r5 r12 r7
};
const byte kInstruction_sel_mi_r7_r14_r6[] = {
  0xb6, 0x7f, 0x8e, 0x46 // sel mi r7 r14 r6
};
const byte kInstruction_sel_gt_r8_r3_r8[] = {
  0xb8, 0x8f, 0x83, 0xc6 // sel gt r8 r3 r8
};
const byte kInstruction_sel_hi_r9_r14_r3[] = {
  0xb3, 0x9f, 0x8e, 0x86 // sel hi r9 r14 r3
};
const byte kInstruction_sel_vc_r2_r11_r2[] = {
  0xb2, 0x2f, 0x8b, 0x76 // sel vc r2 r11 r2
};
const byte kInstruction_sel_hi_r11_r7_r12[] = {
  0xbc, 0xbf, 0x87, 0x86 // sel hi r11 r7 r12
};
const byte kInstruction_sel_cs_r6_r4_r11[] = {
  0xbb, 0x6f, 0x84, 0x26 // sel cs r6 r4 r11
};
const byte kInstruction_sel_cs_r12_r5_r9[] = {
  0xb9, 0xcf, 0x85, 0x26 // sel cs r12 r5 r9
};
const byte kInstruction_sel_ls_r5_r10_r5[] = {
  0xb5, 0x5f, 0x8a, 0x96 // sel ls r5 r10 r5
};
const byte kInstruction_sel_ls_r0_r9_r13[] = {
  0xbd, 0x0f, 0x89, 0x96 // sel ls r0 r9 r13
};
const byte kInstruction_sel_lt_r3_r3_r5[] = {
  0xb5, 0x3f, 0x83, 0xb6 // sel lt r3 r3 r5
};
const byte kInstruction_sel_mi_r0_r12_r8[] = {
  0xb8, 0x0f, 0x8c, 0x46 // sel mi r0 r12 r8
};
const byte kInstruction_sel_pl_r3_r12_r12[] = {
  0xbc, 0x3f, 0x8c, 0x56 // sel pl r3 r12 r12
};
const byte kInstruction_sel_eq_r8_r12_r5[] = {
  0xb5, 0x8f, 0x8c, 0x06 // sel eq r8 r12 r5
};
const byte kInstruction_sel_cc_r7_r8_r1[] = {
  0xb1, 0x7f, 0x88, 0x36 // sel cc r7 r8 r1
};
const byte kInstruction_sel_hi_r2_r13_r10[] = {
  0xba, 0x2f, 0x8d, 0x86 // sel hi r2 r13 r10
};
const byte kInstruction_sel_al_r7_r10_r10[] = {
  0xba, 0x7f, 0x8a, 0xe6 // sel al r7 r10 r10
};
const byte kInstruction_sel_vc_r1_r12_r2[] = {
  0xb2, 0x1f, 0x8c, 0x76 // sel vc r1 r12 r2
};
const byte kInstruction_sel_cc_r8_r5_r8[] = {
  0xb8, 0x8f, 0x85, 0x36 // sel cc r8 r5 r8
};
const byte kInstruction_sel_ls_r3_r7_r9[] = {
  0xb9, 0x3f, 0x87, 0x96 // sel ls r3 r7 r9
};
const byte kInstruction_sel_al_r8_r10_r8[] = {
  0xb8, 0x8f, 0x8a, 0xe6 // sel al r8 r10 r8
};
const byte kInstruction_sel_lt_r4_r12_r10[] = {
  0xba, 0x4f, 0x8c, 0xb6 // sel lt r4 r12 r10
};
const byte kInstruction_sel_ge_r10_r5_r11[] = {
  0xbb, 0xaf, 0x85, 0xa6 // sel ge r10 r5 r11
};
const byte kInstruction_sel_ls_r3_r14_r4[] = {
  0xb4, 0x3f, 0x8e, 0x96 // sel ls r3 r14 r4
};
const byte kInstruction_sel_hi_r3_r6_r12[] = {
  0xbc, 0x3f, 0x86, 0x86 // sel hi r3 r6 r12
};
const byte kInstruction_sel_hi_r6_r0_r4[] = {
  0xb4, 0x6f, 0x80, 0x86 // sel hi r6 r0 r4
};
const byte kInstruction_sel_al_r11_r6_r0[] = {
  0xb0, 0xbf, 0x86, 0xe6 // sel al r11 r6 r0
};
const byte kInstruction_sel_mi_r3_r1_r9[] = {
  0xb9, 0x3f, 0x81, 0x46 // sel mi r3 r1 r9
};
const byte kInstruction_sel_mi_r12_r13_r0[] = {
  0xb0, 0xcf, 0x8d, 0x46 // sel mi r12 r13 r0
};
const byte kInstruction_sel_le_r1_r2_r5[] = {
  0xb5, 0x1f, 0x82, 0xd6 // sel le r1 r2 r5
};
const byte kInstruction_sel_hi_r4_r3_r14[] = {
  0xbe, 0x4f, 0x83, 0x86 // sel hi r4 r3 r14
};
const byte kInstruction_sel_eq_r6_r11_r11[] = {
  0xbb, 0x6f, 0x8b, 0x06 // sel eq r6 r11 r11
};
const byte kInstruction_sel_cc_r14_r11_r14[] = {
  0xbe, 0xef, 0x8b, 0x36 // sel cc r14 r11 r14
};
const byte kInstruction_sel_hi_r4_r10_r0[] = {
  0xb0, 0x4f, 0x8a, 0x86 // sel hi r4 r10 r0
};
const byte kInstruction_sel_cc_r7_r11_r1[] = {
  0xb1, 0x7f, 0x8b, 0x36 // sel cc r7 r11 r1
};
const byte kInstruction_sel_mi_r14_r6_r10[] = {
  0xba, 0xef, 0x86, 0x46 // sel mi r14 r6 r10
};
const byte kInstruction_sel_eq_r2_r0_r11[] = {
  0xbb, 0x2f, 0x80, 0x06 // sel eq r2 r0 r11
};
const byte kInstruction_sel_mi_r13_r5_r12[] = {
  0xbc, 0xdf, 0x85, 0x46 // sel mi r13 r5 r12
};
const byte kInstruction_sel_eq_r2_r12_r5[] = {
  0xb5, 0x2f, 0x8c, 0x06 // sel eq r2 r12 r5
};
const byte kInstruction_sel_le_r12_r0_r2[] = {
  0xb2, 0xcf, 0x80, 0xd6 // sel le r12 r0 r2
};
const byte kInstruction_sel_vc_r10_r10_r9[] = {
  0xb9, 0xaf, 0x8a, 0x76 // sel vc r10 r10 r9
};
const byte kInstruction_sel_ls_r11_r11_r8[] = {
  0xb8, 0xbf, 0x8b, 0x96 // sel ls r11 r11 r8
};
const byte kInstruction_sel_hi_r10_r11_r9[] = {
  0xb9, 0xaf, 0x8b, 0x86 // sel hi r10 r11 r9
};
const byte kInstruction_sel_vs_r7_r12_r14[] = {
  0xbe, 0x7f, 0x8c, 0x66 // sel vs r7 r12 r14
};
const byte kInstruction_sel_gt_r11_r14_r12[] = {
  0xbc, 0xbf, 0x8e, 0xc6 // sel gt r11 r14 r12
};
const byte kInstruction_sel_vs_r0_r12_r8[] = {
  0xb8, 0x0f, 0x8c, 0x66 // sel vs r0 r12 r8
};
const byte kInstruction_sel_al_r0_r5_r7[] = {
  0xb7, 0x0f, 0x85, 0xe6 // sel al r0 r5 r7
};
const byte kInstruction_sel_hi_r5_r13_r8[] = {
  0xb8, 0x5f, 0x8d, 0x86 // sel hi r5 r13 r8
};
const byte kInstruction_sel_le_r9_r9_r7[] = {
  0xb7, 0x9f, 0x89, 0xd6 // sel le r9 r9 r7
};
const byte kInstruction_sel_cc_r4_r9_r5[] = {
  0xb5, 0x4f, 0x89, 0x36 // sel cc r4 r9 r5
};
const byte kInstruction_sel_vs_r8_r1_r3[] = {
  0xb3, 0x8f, 0x81, 0x66 // sel vs r8 r1 r3
};
const byte kInstruction_sel_cc_r0_r10_r12[] = {
  0xbc, 0x0f, 0x8a, 0x36 // sel cc r0 r10 r12
};
const byte kInstruction_sel_eq_r7_r14_r0[] = {
  0xb0, 0x7f, 0x8e, 0x06 // sel eq r7 r14 r0
};
const byte kInstruction_sel_vs_r12_r9_r11[] = {
  0xbb, 0xcf, 0x89, 0x66 // sel vs r12 r9 r11
};
const byte kInstruction_sel_gt_r5_r9_r11[] = {
  0xbb, 0x5f, 0x89, 0xc6 // sel gt r5 r9 r11
};
const byte kInstruction_sel_cs_r14_r13_r7[] = {
  0xb7, 0xef, 0x8d, 0x26 // sel cs r14 r13 r7
};
const byte kInstruction_sel_mi_r11_r3_r10[] = {
  0xba, 0xbf, 0x83, 0x46 // sel mi r11 r3 r10
};
const byte kInstruction_sel_hi_r11_r8_r12[] = {
  0xbc, 0xbf, 0x88, 0x86 // sel hi r11 r8 r12
};
const byte kInstruction_sel_cs_r3_r8_r13[] = {
  0xbd, 0x3f, 0x88, 0x26 // sel cs r3 r8 r13
};
const byte kInstruction_sel_pl_r10_r12_r6[] = {
  0xb6, 0xaf, 0x8c, 0x56 // sel pl r10 r12 r6
};
const byte kInstruction_sel_vc_r7_r3_r2[] = {
  0xb2, 0x7f, 0x83, 0x76 // sel vc r7 r3 r2
};
const byte kInstruction_sel_mi_r9_r0_r8[] = {
  0xb8, 0x9f, 0x80, 0x46 // sel mi r9 r0 r8
};
const byte kInstruction_sel_eq_r2_r13_r7[] = {
  0xb7, 0x2f, 0x8d, 0x06 // sel eq r2 r13 r7
};
const byte kInstruction_sel_ne_r2_r14_r0[] = {
  0xb0, 0x2f, 0x8e, 0x16 // sel ne r2 r14 r0
};
const byte kInstruction_sel_vs_r4_r10_r0[] = {
  0xb0, 0x4f, 0x8a, 0x66 // sel vs r4 r10 r0
};
const byte kInstruction_sel_ls_r0_r2_r2[] = {
  0xb2, 0x0f, 0x82, 0x96 // sel ls r0 r2 r2
};
const byte kInstruction_sel_cc_r1_r6_r0[] = {
  0xb0, 0x1f, 0x86, 0x36 // sel cc r1 r6 r0
};
const byte kInstruction_sel_lt_r12_r0_r8[] = {
  0xb8, 0xcf, 0x80, 0xb6 // sel lt r12 r0 r8
};
const byte kInstruction_sel_cc_r9_r3_r14[] = {
  0xbe, 0x9f, 0x83, 0x36 // sel cc r9 r3 r14
};
const byte kInstruction_sel_vs_r7_r9_r1[] = {
  0xb1, 0x7f, 0x89, 0x66 // sel vs r7 r9 r1
};
const byte kInstruction_sel_eq_r11_r9_r14[] = {
  0xbe, 0xbf, 0x89, 0x06 // sel eq r11 r9 r14
};
const byte kInstruction_sel_pl_r6_r10_r4[] = {
  0xb4, 0x6f, 0x8a, 0x56 // sel pl r6 r10 r4
};
const byte kInstruction_sel_ne_r8_r5_r6[] = {
  0xb6, 0x8f, 0x85, 0x16 // sel ne r8 r5 r6
};
const byte kInstruction_sel_cs_r0_r6_r2[] = {
  0xb2, 0x0f, 0x86, 0x26 // sel cs r0 r6 r2
};
const byte kInstruction_sel_eq_r11_r12_r4[] = {
  0xb4, 0xbf, 0x8c, 0x06 // sel eq r11 r12 r4
};
const byte kInstruction_sel_lt_r14_r3_r14[] = {
  0xbe, 0xef, 0x83, 0xb6 // sel lt r14 r3 r14
};
const byte kInstruction_sel_le_r7_r12_r14[] = {
  0xbe, 0x7f, 0x8c, 0xd6 // sel le r7 r12 r14
};
const byte kInstruction_sel_hi_r2_r9_r9[] = {
  0xb9, 0x2f, 0x89, 0x86 // sel hi r2 r9 r9
};
const byte kInstruction_sel_ne_r8_r1_r0[] = {
  0xb0, 0x8f, 0x81, 0x16 // sel ne r8 r1 r0
};
const byte kInstruction_sel_cc_r5_r11_r2[] = {
  0xb2, 0x5f, 0x8b, 0x36 // sel cc r5 r11 r2
};
const byte kInstruction_sel_hi_r0_r1_r2[] = {
  0xb2, 0x0f, 0x81, 0x86 // sel hi r0 r1 r2
};
const byte kInstruction_sel_al_r4_r9_r4[] = {
  0xb4, 0x4f, 0x89, 0xe6 // sel al r4 r9 r4
};
const byte kInstruction_sel_cs_r12_r7_r14[] = {
  0xbe, 0xcf, 0x87, 0x26 // sel cs r12 r7 r14
};
const byte kInstruction_sel_cc_r4_r12_r10[] = {
  0xba, 0x4f, 0x8c, 0x36 // sel cc r4 r12 r10
};
const byte kInstruction_sel_al_r3_r5_r10[] = {
  0xba, 0x3f, 0x85, 0xe6 // sel al r3 r5 r10
};
const byte kInstruction_sel_mi_r5_r3_r7[] = {
  0xb7, 0x5f, 0x83, 0x46 // sel mi r5 r3 r7
};
const byte kInstruction_sel_ls_r10_r6_r2[] = {
  0xb2, 0xaf, 0x86, 0x96 // sel ls r10 r6 r2
};
const byte kInstruction_sel_mi_r0_r12_r11[] = {
  0xbb, 0x0f, 0x8c, 0x46 // sel mi r0 r12 r11
};
const byte kInstruction_sel_vc_r12_r5_r6[] = {
  0xb6, 0xcf, 0x85, 0x76 // sel vc r12 r5 r6
};
const byte kInstruction_sel_cs_r3_r9_r4[] = {
  0xb4, 0x3f, 0x89, 0x26 // sel cs r3 r9 r4
};
const byte kInstruction_sel_ls_r4_r9_r11[] = {
  0xbb, 0x4f, 0x89, 0x96 // sel ls r4 r9 r11
};
const byte kInstruction_sel_le_r14_r8_r13[] = {
  0xbd, 0xef, 0x88, 0xd6 // sel le r14 r8 r13
};
const byte kInstruction_sel_gt_r4_r10_r8[] = {
  0xb8, 0x4f, 0x8a, 0xc6 // sel gt r4 r10 r8
};
const byte kInstruction_sel_al_r6_r9_r9[] = {
  0xb9, 0x6f, 0x89, 0xe6 // sel al r6 r9 r9
};
const byte kInstruction_sel_ne_r8_r5_r12[] = {
  0xbc, 0x8f, 0x85, 0x16 // sel ne r8 r5 r12
};
const byte kInstruction_sel_ne_r0_r4_r8[] = {
  0xb8, 0x0f, 0x84, 0x16 // sel ne r0 r4 r8
};
const byte kInstruction_sel_mi_r7_r13_r3[] = {
  0xb3, 0x7f, 0x8d, 0x46 // sel mi r7 r13 r3
};
const byte kInstruction_sel_cc_r11_r7_r0[] = {
  0xb0, 0xbf, 0x87, 0x36 // sel cc r11 r7 r0
};
const byte kInstruction_sel_hi_r1_r0_r12[] = {
  0xbc, 0x1f, 0x80, 0x86 // sel hi r1 r0 r12
};
const byte kInstruction_sel_lt_r8_r9_r3[] = {
  0xb3, 0x8f, 0x89, 0xb6 // sel lt r8 r9 r3
};
const byte kInstruction_sel_al_r0_r2_r1[] = {
  0xb1, 0x0f, 0x82, 0xe6 // sel al r0 r2 r1
};
const byte kInstruction_sel_vs_r4_r3_r14[] = {
  0xbe, 0x4f, 0x83, 0x66 // sel vs r4 r3 r14
};
const byte kInstruction_sel_ge_r2_r11_r1[] = {
  0xb1, 0x2f, 0x8b, 0xa6 // sel ge r2 r11 r1
};
const byte kInstruction_sel_lt_r12_r9_r6[] = {
  0xb6, 0xcf, 0x89, 0xb6 // sel lt r12 r9 r6
};
const byte kInstruction_sel_ls_r8_r2_r7[] = {
  0xb7, 0x8f, 0x82, 0x96 // sel ls r8 r2 r7
};
const byte kInstruction_sel_le_r8_r13_r3[] = {
  0xb3, 0x8f, 0x8d, 0xd6 // sel le r8 r13 r3
};
const byte kInstruction_sel_eq_r11_r13_r14[] = {
  0xbe, 0xbf, 0x8d, 0x06 // sel eq r11 r13 r14
};
const byte kInstruction_sel_lt_r1_r6_r13[] = {
  0xbd, 0x1f, 0x86, 0xb6 // sel lt r1 r6 r13
};
const byte kInstruction_sel_cs_r3_r8_r11[] = {
  0xbb, 0x3f, 0x88, 0x26 // sel cs r3 r8 r11
};
const byte kInstruction_sel_pl_r12_r5_r4[] = {
  0xb4, 0xcf, 0x85, 0x56 // sel pl r12 r5 r4
};
const byte kInstruction_sel_eq_r8_r7_r2[] = {
  0xb2, 0x8f, 0x87, 0x06 // sel eq r8 r7 r2
};
const byte kInstruction_sel_ls_r2_r12_r2[] = {
  0xb2, 0x2f, 0x8c, 0x96 // sel ls r2 r12 r2
};
const byte kInstruction_sel_le_r14_r2_r3[] = {
  0xb3, 0xef, 0x82, 0xd6 // sel le r14 r2 r3
};
const byte kInstruction_sel_ge_r10_r11_r6[] = {
  0xb6, 0xaf, 0x8b, 0xa6 // sel ge r10 r11 r6
};
const byte kInstruction_sel_hi_r0_r2_r2[] = {
  0xb2, 0x0f, 0x82, 0x86 // sel hi r0 r2 r2
};
const byte kInstruction_sel_ge_r2_r0_r2[] = {
  0xb2, 0x2f, 0x80, 0xa6 // sel ge r2 r0 r2
};
const byte kInstruction_sel_vs_r11_r14_r0[] = {
  0xb0, 0xbf, 0x8e, 0x66 // sel vs r11 r14 r0
};
const byte kInstruction_sel_lt_r2_r0_r1[] = {
  0xb1, 0x2f, 0x80, 0xb6 // sel lt r2 r0 r1
};
const byte kInstruction_sel_cs_r2_r5_r11[] = {
  0xbb, 0x2f, 0x85, 0x26 // sel cs r2 r5 r11
};
const byte kInstruction_sel_ls_r7_r14_r5[] = {
  0xb5, 0x7f, 0x8e, 0x96 // sel ls r7 r14 r5
};
const byte kInstruction_sel_pl_r0_r0_r3[] = {
  0xb3, 0x0f, 0x80, 0x56 // sel pl r0 r0 r3
};
const byte kInstruction_sel_ge_r6_r8_r8[] = {
  0xb8, 0x6f, 0x88, 0xa6 // sel ge r6 r8 r8
};
const byte kInstruction_sel_le_r11_r1_r10[] = {
  0xba, 0xbf, 0x81, 0xd6 // sel le r11 r1 r10
};
const byte kInstruction_sel_vs_r5_r2_r7[] = {
  0xb7, 0x5f, 0x82, 0x66 // sel vs r5 r2 r7
};
const byte kInstruction_sel_ne_r4_r4_r8[] = {
  0xb8, 0x4f, 0x84, 0x16 // sel ne r4 r4 r8
};
const byte kInstruction_sel_cc_r9_r14_r13[] = {
  0xbd, 0x9f, 0x8e, 0x36 // sel cc r9 r14 r13
};
const byte kInstruction_sel_hi_r14_r6_r3[] = {
  0xb3, 0xef, 0x86, 0x86 // sel hi r14 r6 r3
};
const byte kInstruction_sel_al_r0_r8_r0[] = {
  0xb0, 0x0f, 0x88, 0xe6 // sel al r0 r8 r0
};
const byte kInstruction_sel_lt_r6_r11_r1[] = {
  0xb1, 0x6f, 0x8b, 0xb6 // sel lt r6 r11 r1
};
const byte kInstruction_sel_ge_r7_r6_r12[] = {
  0xbc, 0x7f, 0x86, 0xa6 // sel ge r7 r6 r12
};
const byte kInstruction_sel_cs_r4_r6_r14[] = {
  0xbe, 0x4f, 0x86, 0x26 // sel cs r4 r6 r14
};
const byte kInstruction_sel_cs_r7_r6_r7[] = {
  0xb7, 0x7f, 0x86, 0x26 // sel cs r7 r6 r7
};
const byte kInstruction_sel_cs_r3_r7_r10[] = {
  0xba, 0x3f, 0x87, 0x26 // sel cs r3 r7 r10
};
const byte kInstruction_sel_ne_r0_r2_r1[] = {
  0xb1, 0x0f, 0x82, 0x16 // sel ne r0 r2 r1
};
const byte kInstruction_sel_vs_r9_r10_r13[] = {
  0xbd, 0x9f, 0x8a, 0x66 // sel vs r9 r10 r13
};
const byte kInstruction_sel_vc_r11_r14_r12[] = {
  0xbc, 0xbf, 0x8e, 0x76 // sel vc r11 r14 r12
};
const byte kInstruction_sel_ge_r14_r8_r7[] = {
  0xb7, 0xef, 0x88, 0xa6 // sel ge r14 r8 r7
};
const byte kInstruction_sel_lt_r13_r0_r11[] = {
  0xbb, 0xdf, 0x80, 0xb6 // sel lt r13 r0 r11
};
const byte kInstruction_sel_lt_r14_r13_r4[] = {
  0xb4, 0xef, 0x8d, 0xb6 // sel lt r14 r13 r4
};
const byte kInstruction_sel_al_r1_r10_r9[] = {
  0xb9, 0x1f, 0x8a, 0xe6 // sel al r1 r10 r9
};
const byte kInstruction_sel_ge_r11_r14_r11[] = {
  0xbb, 0xbf, 0x8e, 0xa6 // sel ge r11 r14 r11
};
const byte kInstruction_sel_cs_r11_r4_r11[] = {
  0xbb, 0xbf, 0x84, 0x26 // sel cs r11 r4 r11
};
const byte kInstruction_sel_ge_r0_r14_r7[] = {
  0xb7, 0x0f, 0x8e, 0xa6 // sel ge r0 r14 r7
};
const byte kInstruction_sel_mi_r1_r2_r9[] = {
  0xb9, 0x1f, 0x82, 0x46 // sel mi r1 r2 r9
};
const byte kInstruction_sel_eq_r5_r12_r3[] = {
  0xb3, 0x5f, 0x8c, 0x06 // sel eq r5 r12 r3
};
const byte kInstruction_sel_ge_r1_r5_r12[] = {
  0xbc, 0x1f, 0x85, 0xa6 // sel ge r1 r5 r12
};
const byte kInstruction_sel_lt_r10_r11_r4[] = {
  0xb4, 0xaf, 0x8b, 0xb6 // sel lt r10 r11 r4
};
const byte kInstruction_sel_le_r1_r1_r5[] = {
  0xb5, 0x1f, 0x81, 0xd6 // sel le r1 r1 r5
};
const byte kInstruction_sel_al_r9_r1_r8[] = {
  0xb8, 0x9f, 0x81, 0xe6 // sel al r9 r1 r8
};
const byte kInstruction_sel_ne_r6_r8_r4[] = {
  0xb4, 0x6f, 0x88, 0x16 // sel ne r6 r8 r4
};
const byte kInstruction_sel_ge_r12_r2_r9[] = {
  0xb9, 0xcf, 0x82, 0xa6 // sel ge r12 r2 r9
};
const byte kInstruction_sel_pl_r4_r3_r10[] = {
  0xba, 0x4f, 0x83, 0x56 // sel pl r4 r3 r10
};
const byte kInstruction_sel_eq_r14_r4_r11[] = {
  0xbb, 0xef, 0x84, 0x06 // sel eq r14 r4 r11
};
const byte kInstruction_sel_cc_r9_r7_r6[] = {
  0xb6, 0x9f, 0x87, 0x36 // sel cc r9 r7 r6
};
const byte kInstruction_sel_ge_r12_r4_r5[] = {
  0xb5, 0xcf, 0x84, 0xa6 // sel ge r12 r4 r5
};
const byte kInstruction_sel_hi_r2_r3_r4[] = {
  0xb4, 0x2f, 0x83, 0x86 // sel hi r2 r3 r4
};
const byte kInstruction_sel_cs_r0_r3_r1[] = {
  0xb1, 0x0f, 0x83, 0x26 // sel cs r0 r3 r1
};
const byte kInstruction_sel_hi_r6_r2_r8[] = {
  0xb8, 0x6f, 0x82, 0x86 // sel hi r6 r2 r8
};
const byte kInstruction_sel_cc_r3_r14_r13[] = {
  0xbd, 0x3f, 0x8e, 0x36 // sel cc r3 r14 r13
};
const byte kInstruction_sel_gt_r11_r4_r7[] = {
  0xb7, 0xbf, 0x84, 0xc6 // sel gt r11 r4 r7
};
const byte kInstruction_sel_hi_r5_r0_r12[] = {
  0xbc, 0x5f, 0x80, 0x86 // sel hi r5 r0 r12
};
const byte kInstruction_sel_gt_r0_r14_r14[] = {
  0xbe, 0x0f, 0x8e, 0xc6 // sel gt r0 r14 r14
};
const byte kInstruction_sel_hi_r9_r0_r10[] = {
  0xba, 0x9f, 0x80, 0x86 // sel hi r9 r0 r10
};
const byte kInstruction_sel_vc_r7_r11_r8[] = {
  0xb8, 0x7f, 0x8b, 0x76 // sel vc r7 r11 r8
};
const byte kInstruction_sel_pl_r11_r9_r6[] = {
  0xb6, 0xbf, 0x89, 0x56 // sel pl r11 r9 r6
};
const byte kInstruction_sel_al_r3_r3_r7[] = {
  0xb7, 0x3f, 0x83, 0xe6 // sel al r3 r3 r7
};
const byte kInstruction_sel_mi_r5_r7_r9[] = {
  0xb9, 0x5f, 0x87, 0x46 // sel mi r5 r7 r9
};
const byte kInstruction_sel_cc_r11_r2_r4[] = {
  0xb4, 0xbf, 0x82, 0x36 // sel cc r11 r2 r4
};
const byte kInstruction_sel_cc_r9_r13_r10[] = {
  0xba, 0x9f, 0x8d, 0x36 // sel cc r9 r13 r10
};
const byte kInstruction_sel_al_r5_r2_r6[] = {
  0xb6, 0x5f, 0x82, 0xe6 // sel al r5 r2 r6
};
const byte kInstruction_sel_ge_r9_r4_r6[] = {
  0xb6, 0x9f, 0x84, 0xa6 // sel ge r9 r4 r6
};
const byte kInstruction_sel_ls_r3_r3_r4[] = {
  0xb4, 0x3f, 0x83, 0x96 // sel ls r3 r3 r4
};
const byte kInstruction_sel_ge_r14_r1_r8[] = {
  0xb8, 0xef, 0x81, 0xa6 // sel ge r14 r1 r8
};
const byte kInstruction_sel_ls_r7_r12_r7[] = {
  0xb7, 0x7f, 0x8c, 0x96 // sel ls r7 r12 r7
};
const byte kInstruction_sel_al_r11_r10_r5[] = {
  0xb5, 0xbf, 0x8a, 0xe6 // sel al r11 r10 r5
};
const byte kInstruction_sel_al_r7_r4_r6[] = {
  0xb6, 0x7f, 0x84, 0xe6 // sel al r7 r4 r6
};
const byte kInstruction_sel_vs_r12_r4_r10[] = {
  0xba, 0xcf, 0x84, 0x66 // sel vs r12 r4 r10
};
const byte kInstruction_sel_eq_r4_r4_r4[] = {
  0xb4, 0x4f, 0x84, 0x06 // sel eq r4 r4 r4
};
const byte kInstruction_sel_vs_r6_r6_r12[] = {
  0xbc, 0x6f, 0x86, 0x66 // sel vs r6 r6 r12
};
const byte kInstruction_sel_pl_r9_r3_r5[] = {
  0xb5, 0x9f, 0x83, 0x56 // sel pl r9 r3 r5
};
const byte kInstruction_sel_eq_r6_r5_r13[] = {
  0xbd, 0x6f, 0x85, 0x06 // sel eq r6 r5 r13
};
const byte kInstruction_sel_cc_r8_r2_r12[] = {
  0xbc, 0x8f, 0x82, 0x36 // sel cc r8 r2 r12
};
const byte kInstruction_sel_le_r4_r2_r0[] = {
  0xb0, 0x4f, 0x82, 0xd6 // sel le r4 r2 r0
};
const byte kInstruction_sel_lt_r7_r9_r8[] = {
  0xb8, 0x7f, 0x89, 0xb6 // sel lt r7 r9 r8
};
const byte kInstruction_sel_le_r4_r7_r11[] = {
  0xbb, 0x4f, 0x87, 0xd6 // sel le r4 r7 r11
};
const byte kInstruction_sel_eq_r5_r7_r5[] = {
  0xb5, 0x5f, 0x87, 0x06 // sel eq r5 r7 r5
};
const byte kInstruction_sel_vc_r10_r7_r12[] = {
  0xbc, 0xaf, 0x87, 0x76 // sel vc r10 r7 r12
};
const byte kInstruction_sel_eq_r7_r10_r6[] = {
  0xb6, 0x7f, 0x8a, 0x06 // sel eq r7 r10 r6
};
const byte kInstruction_sel_pl_r1_r12_r2[] = {
  0xb2, 0x1f, 0x8c, 0x56 // sel pl r1 r12 r2
};
const byte kInstruction_sel_le_r14_r6_r6[] = {
  0xb6, 0xef, 0x86, 0xd6 // sel le r14 r6 r6
};
const byte kInstruction_sel_ne_r3_r8_r8[] = {
  0xb8, 0x3f, 0x88, 0x16 // sel ne r3 r8 r8
};
const byte kInstruction_sel_eq_r4_r12_r8[] = {
  0xb8, 0x4f, 0x8c, 0x06 // sel eq r4 r12 r8
};
const byte kInstruction_sel_ge_r11_r2_r3[] = {
  0xb3, 0xbf, 0x82, 0xa6 // sel ge r11 r2 r3
};
const byte kInstruction_sel_hi_r12_r6_r11[] = {
  0xbb, 0xcf, 0x86, 0x86 // sel hi r12 r6 r11
};
const byte kInstruction_sel_cs_r4_r5_r10[] = {
  0xba, 0x4f, 0x85, 0x26 // sel cs r4 r5 r10
};
const byte kInstruction_sel_ge_r10_r2_r10[] = {
  0xba, 0xaf, 0x82, 0xa6 // sel ge r10 r2 r10
};
const byte kInstruction_sel_ge_r5_r14_r6[] = {
  0xb6, 0x5f, 0x8e, 0xa6 // sel ge r5 r14 r6
};
const byte kInstruction_sel_gt_r13_r7_r5[] = {
  0xb5, 0xdf, 0x87, 0xc6 // sel gt r13 r7 r5
};
const byte kInstruction_sel_ge_r13_r4_r12[] = {
  0xbc, 0xdf, 0x84, 0xa6 // sel ge r13 r4 r12
};
const byte kInstruction_sel_lt_r8_r10_r14[] = {
  0xbe, 0x8f, 0x8a, 0xb6 // sel lt r8 r10 r14
};
const byte kInstruction_sel_le_r4_r3_r13[] = {
  0xbd, 0x4f, 0x83, 0xd6 // sel le r4 r3 r13
};
const byte kInstruction_sel_pl_r0_r9_r0[] = {
  0xb0, 0x0f, 0x89, 0x56 // sel pl r0 r9 r0
};
const byte kInstruction_sel_eq_r2_r3_r1[] = {
  0xb1, 0x2f, 0x83, 0x06 // sel eq r2 r3 r1
};
const byte kInstruction_sel_vc_r0_r0_r3[] = {
  0xb3, 0x0f, 0x80, 0x76 // sel vc r0 r0 r3
};
const byte kInstruction_sel_mi_r10_r8_r11[] = {
  0xbb, 0xaf, 0x88, 0x46 // sel mi r10 r8 r11
};
const byte kInstruction_sel_mi_r5_r14_r14[] = {
  0xbe, 0x5f, 0x8e, 0x46 // sel mi r5 r14 r14
};
const byte kInstruction_sel_gt_r5_r11_r2[] = {
  0xb2, 0x5f, 0x8b, 0xc6 // sel gt r5 r11 r2
};
const byte kInstruction_sel_al_r4_r7_r11[] = {
  0xbb, 0x4f, 0x87, 0xe6 // sel al r4 r7 r11
};
const TestResult kReferencesel[] = {
  {
    ARRAY_SIZE(kInstruction_sel_hi_r1_r9_r5),
    kInstruction_sel_hi_r1_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r8_r6_r2),
    kInstruction_sel_pl_r8_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r5_r8_r2),
    kInstruction_sel_hi_r5_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vc_r9_r2_r7),
    kInstruction_sel_vc_r9_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r4_r6_r3),
    kInstruction_sel_lt_r4_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r11_r6_r2),
    kInstruction_sel_le_r11_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r8_r14_r4),
    kInstruction_sel_cc_r8_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r5_r14_r6),
    kInstruction_sel_le_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r6_r1_r0),
    kInstruction_sel_lt_r6_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r5_r0_r9),
    kInstruction_sel_lt_r5_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r8_r12_r7),
    kInstruction_sel_le_r8_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r7_r14_r6),
    kInstruction_sel_eq_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r7_r4_r6),
    kInstruction_sel_cs_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_gt_r9_r6_r9),
    kInstruction_sel_gt_r9_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r13_r9_r1),
    kInstruction_sel_ne_r13_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r13_r1_r13),
    kInstruction_sel_ge_r13_r1_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r8_r10_r2),
    kInstruction_sel_ls_r8_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r0_r13_r5),
    kInstruction_sel_hi_r0_r13_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r13_r7_r8),
    kInstruction_sel_pl_r13_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r4_r13_r11),
    kInstruction_sel_ge_r4_r13_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r5_r10_r5),
    kInstruction_sel_cs_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r5_r4_r3),
    kInstruction_sel_cs_r5_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r6_r14_r8),
    kInstruction_sel_ls_r6_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r3_r8_r6),
    kInstruction_sel_vs_r3_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vc_r7_r12_r3),
    kInstruction_sel_vc_r7_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r1_r4_r1),
    kInstruction_sel_ge_r1_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r4_r7_r10),
    kInstruction_sel_cc_r4_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r2_r0_r13),
    kInstruction_sel_cc_r2_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r9_r6_r8),
    kInstruction_sel_vs_r9_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r14_r11_r13),
    kInstruction_sel_cs_r14_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r5_r8_r4),
    kInstruction_sel_pl_r5_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r2_r3_r7),
    kInstruction_sel_pl_r2_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r7_r12_r14),
    kInstruction_sel_cs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r6_r6_r1),
    kInstruction_sel_hi_r6_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r6_r9_r6),
    kInstruction_sel_cc_r6_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r12_r12_r0),
    kInstruction_sel_ne_r12_r12_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r9_r3_r8),
    kInstruction_sel_cc_r9_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r13_r6_r1),
    kInstruction_sel_mi_r13_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r4_r8_r6),
    kInstruction_sel_lt_r4_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r11_r5_r9),
    kInstruction_sel_hi_r11_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r6_r10_r6),
    kInstruction_sel_cc_r6_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r10_r10_r5),
    kInstruction_sel_eq_r10_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r5_r4_r11),
    kInstruction_sel_al_r5_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r11_r11_r2),
    kInstruction_sel_pl_r11_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r6_r14_r12),
    kInstruction_sel_ls_r6_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vc_r7_r7_r2),
    kInstruction_sel_vc_r7_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r10_r8_r4),
    kInstruction_sel_eq_r10_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r14_r7_r2),
    kInstruction_sel_al_r14_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r3_r11_r10),
    kInstruction_sel_cs_r3_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r11_r4_r0),
    kInstruction_sel_ls_r11_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r11_r8_r9),
    kInstruction_sel_hi_r11_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r2_r14_r13),
    kInstruction_sel_vs_r2_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r1_r13_r9),
    kInstruction_sel_al_r1_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r3_r9_r13),
    kInstruction_sel_eq_r3_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r10_r3_r13),
    kInstruction_sel_ge_r10_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r8_r5_r10),
    kInstruction_sel_pl_r8_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vc_r8_r11_r6),
    kInstruction_sel_vc_r8_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r0_r0_r5),
    kInstruction_sel_eq_r0_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r6_r5_r8),
    kInstruction_sel_ne_r6_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r5_r13_r3),
    kInstruction_sel_hi_r5_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r11_r14_r14),
    kInstruction_sel_ne_r11_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r1_r0_r6),
    kInstruction_sel_mi_r1_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r14_r8_r2),
    kInstruction_sel_le_r14_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r9_r6_r5),
    kInstruction_sel_eq_r9_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r11_r0_r13),
    kInstruction_sel_eq_r11_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r4_r5_r14),
    kInstruction_sel_pl_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r13_r5_r13),
    kInstruction_sel_cs_r13_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r0_r13_r8),
    kInstruction_sel_mi_r0_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r2_r13_r3),
    kInstruction_sel_lt_r2_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r8_r1_r11),
    kInstruction_sel_ls_r8_r1_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vc_r14_r11_r8),
    kInstruction_sel_vc_r14_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r4_r13_r12),
    kInstruction_sel_lt_r4_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r2_r1_r14),
    kInstruction_sel_eq_r2_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r9_r4_r14),
    kInstruction_sel_eq_r9_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r10_r6_r13),
    kInstruction_sel_hi_r10_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r12_r9_r4),
    kInstruction_sel_ge_r12_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r9_r11_r14),
    kInstruction_sel_le_r9_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r0_r9_r5),
    kInstruction_sel_ls_r0_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r2_r3_r8),
    kInstruction_sel_mi_r2_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r14_r10_r14),
    kInstruction_sel_ne_r14_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r6_r2_r10),
    kInstruction_sel_eq_r6_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r11_r0_r12),
    kInstruction_sel_lt_r11_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r1_r12_r10),
    kInstruction_sel_ne_r1_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r1_r0_r2),
    kInstruction_sel_cc_r1_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r5_r5_r7),
    kInstruction_sel_al_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r7_r13_r1),
    kInstruction_sel_hi_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r4_r4_r9),
    kInstruction_sel_cs_r4_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r14_r4_r14),
    kInstruction_sel_eq_r14_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r10_r5_r14),
    kInstruction_sel_vs_r10_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_gt_r4_r3_r11),
    kInstruction_sel_gt_r4_r3_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r14_r10_r12),
    kInstruction_sel_ne_r14_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r2_r11_r0),
    kInstruction_sel_vs_r2_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r5_r12_r7),
    kInstruction_sel_ge_r5_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r7_r14_r6),
    kInstruction_sel_mi_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_gt_r8_r3_r8),
    kInstruction_sel_gt_r8_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r9_r14_r3),
    kInstruction_sel_hi_r9_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vc_r2_r11_r2),
    kInstruction_sel_vc_r2_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r11_r7_r12),
    kInstruction_sel_hi_r11_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r6_r4_r11),
    kInstruction_sel_cs_r6_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r12_r5_r9),
    kInstruction_sel_cs_r12_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r5_r10_r5),
    kInstruction_sel_ls_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r0_r9_r13),
    kInstruction_sel_ls_r0_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r3_r3_r5),
    kInstruction_sel_lt_r3_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r0_r12_r8),
    kInstruction_sel_mi_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r3_r12_r12),
    kInstruction_sel_pl_r3_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r8_r12_r5),
    kInstruction_sel_eq_r8_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r7_r8_r1),
    kInstruction_sel_cc_r7_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r2_r13_r10),
    kInstruction_sel_hi_r2_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r7_r10_r10),
    kInstruction_sel_al_r7_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vc_r1_r12_r2),
    kInstruction_sel_vc_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r8_r5_r8),
    kInstruction_sel_cc_r8_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r3_r7_r9),
    kInstruction_sel_ls_r3_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r8_r10_r8),
    kInstruction_sel_al_r8_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r4_r12_r10),
    kInstruction_sel_lt_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r10_r5_r11),
    kInstruction_sel_ge_r10_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r3_r14_r4),
    kInstruction_sel_ls_r3_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r3_r6_r12),
    kInstruction_sel_hi_r3_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r6_r0_r4),
    kInstruction_sel_hi_r6_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r11_r6_r0),
    kInstruction_sel_al_r11_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r3_r1_r9),
    kInstruction_sel_mi_r3_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r12_r13_r0),
    kInstruction_sel_mi_r12_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r1_r2_r5),
    kInstruction_sel_le_r1_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r4_r3_r14),
    kInstruction_sel_hi_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r6_r11_r11),
    kInstruction_sel_eq_r6_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r14_r11_r14),
    kInstruction_sel_cc_r14_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r4_r10_r0),
    kInstruction_sel_hi_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r7_r11_r1),
    kInstruction_sel_cc_r7_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r14_r6_r10),
    kInstruction_sel_mi_r14_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r2_r0_r11),
    kInstruction_sel_eq_r2_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r13_r5_r12),
    kInstruction_sel_mi_r13_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r2_r12_r5),
    kInstruction_sel_eq_r2_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r12_r0_r2),
    kInstruction_sel_le_r12_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vc_r10_r10_r9),
    kInstruction_sel_vc_r10_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r11_r11_r8),
    kInstruction_sel_ls_r11_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r10_r11_r9),
    kInstruction_sel_hi_r10_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r7_r12_r14),
    kInstruction_sel_vs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_gt_r11_r14_r12),
    kInstruction_sel_gt_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r0_r12_r8),
    kInstruction_sel_vs_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r0_r5_r7),
    kInstruction_sel_al_r0_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r5_r13_r8),
    kInstruction_sel_hi_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r9_r9_r7),
    kInstruction_sel_le_r9_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r4_r9_r5),
    kInstruction_sel_cc_r4_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r8_r1_r3),
    kInstruction_sel_vs_r8_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r0_r10_r12),
    kInstruction_sel_cc_r0_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r7_r14_r0),
    kInstruction_sel_eq_r7_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r12_r9_r11),
    kInstruction_sel_vs_r12_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_gt_r5_r9_r11),
    kInstruction_sel_gt_r5_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r14_r13_r7),
    kInstruction_sel_cs_r14_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r11_r3_r10),
    kInstruction_sel_mi_r11_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r11_r8_r12),
    kInstruction_sel_hi_r11_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r3_r8_r13),
    kInstruction_sel_cs_r3_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r10_r12_r6),
    kInstruction_sel_pl_r10_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vc_r7_r3_r2),
    kInstruction_sel_vc_r7_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r9_r0_r8),
    kInstruction_sel_mi_r9_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r2_r13_r7),
    kInstruction_sel_eq_r2_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r2_r14_r0),
    kInstruction_sel_ne_r2_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r4_r10_r0),
    kInstruction_sel_vs_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r0_r2_r2),
    kInstruction_sel_ls_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r1_r6_r0),
    kInstruction_sel_cc_r1_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r12_r0_r8),
    kInstruction_sel_lt_r12_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r9_r3_r14),
    kInstruction_sel_cc_r9_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r7_r9_r1),
    kInstruction_sel_vs_r7_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r11_r9_r14),
    kInstruction_sel_eq_r11_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r6_r10_r4),
    kInstruction_sel_pl_r6_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r8_r5_r6),
    kInstruction_sel_ne_r8_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r0_r6_r2),
    kInstruction_sel_cs_r0_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r11_r12_r4),
    kInstruction_sel_eq_r11_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r14_r3_r14),
    kInstruction_sel_lt_r14_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r7_r12_r14),
    kInstruction_sel_le_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r2_r9_r9),
    kInstruction_sel_hi_r2_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r8_r1_r0),
    kInstruction_sel_ne_r8_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r5_r11_r2),
    kInstruction_sel_cc_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r0_r1_r2),
    kInstruction_sel_hi_r0_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r4_r9_r4),
    kInstruction_sel_al_r4_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r12_r7_r14),
    kInstruction_sel_cs_r12_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r4_r12_r10),
    kInstruction_sel_cc_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r3_r5_r10),
    kInstruction_sel_al_r3_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r5_r3_r7),
    kInstruction_sel_mi_r5_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r10_r6_r2),
    kInstruction_sel_ls_r10_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r0_r12_r11),
    kInstruction_sel_mi_r0_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vc_r12_r5_r6),
    kInstruction_sel_vc_r12_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r3_r9_r4),
    kInstruction_sel_cs_r3_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r4_r9_r11),
    kInstruction_sel_ls_r4_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r14_r8_r13),
    kInstruction_sel_le_r14_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_gt_r4_r10_r8),
    kInstruction_sel_gt_r4_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r6_r9_r9),
    kInstruction_sel_al_r6_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r8_r5_r12),
    kInstruction_sel_ne_r8_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r0_r4_r8),
    kInstruction_sel_ne_r0_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r7_r13_r3),
    kInstruction_sel_mi_r7_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r11_r7_r0),
    kInstruction_sel_cc_r11_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r1_r0_r12),
    kInstruction_sel_hi_r1_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r8_r9_r3),
    kInstruction_sel_lt_r8_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r0_r2_r1),
    kInstruction_sel_al_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r4_r3_r14),
    kInstruction_sel_vs_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r2_r11_r1),
    kInstruction_sel_ge_r2_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r12_r9_r6),
    kInstruction_sel_lt_r12_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r8_r2_r7),
    kInstruction_sel_ls_r8_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r8_r13_r3),
    kInstruction_sel_le_r8_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r11_r13_r14),
    kInstruction_sel_eq_r11_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r1_r6_r13),
    kInstruction_sel_lt_r1_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r3_r8_r11),
    kInstruction_sel_cs_r3_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r12_r5_r4),
    kInstruction_sel_pl_r12_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r8_r7_r2),
    kInstruction_sel_eq_r8_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r2_r12_r2),
    kInstruction_sel_ls_r2_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r14_r2_r3),
    kInstruction_sel_le_r14_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r10_r11_r6),
    kInstruction_sel_ge_r10_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r0_r2_r2),
    kInstruction_sel_hi_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r2_r0_r2),
    kInstruction_sel_ge_r2_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r11_r14_r0),
    kInstruction_sel_vs_r11_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r2_r0_r1),
    kInstruction_sel_lt_r2_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r2_r5_r11),
    kInstruction_sel_cs_r2_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r7_r14_r5),
    kInstruction_sel_ls_r7_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r0_r0_r3),
    kInstruction_sel_pl_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r6_r8_r8),
    kInstruction_sel_ge_r6_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r11_r1_r10),
    kInstruction_sel_le_r11_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r5_r2_r7),
    kInstruction_sel_vs_r5_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r4_r4_r8),
    kInstruction_sel_ne_r4_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r9_r14_r13),
    kInstruction_sel_cc_r9_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r14_r6_r3),
    kInstruction_sel_hi_r14_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r0_r8_r0),
    kInstruction_sel_al_r0_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r6_r11_r1),
    kInstruction_sel_lt_r6_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r7_r6_r12),
    kInstruction_sel_ge_r7_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r4_r6_r14),
    kInstruction_sel_cs_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r7_r6_r7),
    kInstruction_sel_cs_r7_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r3_r7_r10),
    kInstruction_sel_cs_r3_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r0_r2_r1),
    kInstruction_sel_ne_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r9_r10_r13),
    kInstruction_sel_vs_r9_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vc_r11_r14_r12),
    kInstruction_sel_vc_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r14_r8_r7),
    kInstruction_sel_ge_r14_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r13_r0_r11),
    kInstruction_sel_lt_r13_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r14_r13_r4),
    kInstruction_sel_lt_r14_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r1_r10_r9),
    kInstruction_sel_al_r1_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r11_r14_r11),
    kInstruction_sel_ge_r11_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r11_r4_r11),
    kInstruction_sel_cs_r11_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r0_r14_r7),
    kInstruction_sel_ge_r0_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r1_r2_r9),
    kInstruction_sel_mi_r1_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r5_r12_r3),
    kInstruction_sel_eq_r5_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r1_r5_r12),
    kInstruction_sel_ge_r1_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r10_r11_r4),
    kInstruction_sel_lt_r10_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r1_r1_r5),
    kInstruction_sel_le_r1_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r9_r1_r8),
    kInstruction_sel_al_r9_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r6_r8_r4),
    kInstruction_sel_ne_r6_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r12_r2_r9),
    kInstruction_sel_ge_r12_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r4_r3_r10),
    kInstruction_sel_pl_r4_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r14_r4_r11),
    kInstruction_sel_eq_r14_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r9_r7_r6),
    kInstruction_sel_cc_r9_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r12_r4_r5),
    kInstruction_sel_ge_r12_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r2_r3_r4),
    kInstruction_sel_hi_r2_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r0_r3_r1),
    kInstruction_sel_cs_r0_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r6_r2_r8),
    kInstruction_sel_hi_r6_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r3_r14_r13),
    kInstruction_sel_cc_r3_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_gt_r11_r4_r7),
    kInstruction_sel_gt_r11_r4_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r5_r0_r12),
    kInstruction_sel_hi_r5_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_gt_r0_r14_r14),
    kInstruction_sel_gt_r0_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r9_r0_r10),
    kInstruction_sel_hi_r9_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vc_r7_r11_r8),
    kInstruction_sel_vc_r7_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r11_r9_r6),
    kInstruction_sel_pl_r11_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r3_r3_r7),
    kInstruction_sel_al_r3_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r5_r7_r9),
    kInstruction_sel_mi_r5_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r11_r2_r4),
    kInstruction_sel_cc_r11_r2_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r9_r13_r10),
    kInstruction_sel_cc_r9_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r5_r2_r6),
    kInstruction_sel_al_r5_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r9_r4_r6),
    kInstruction_sel_ge_r9_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r3_r3_r4),
    kInstruction_sel_ls_r3_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r14_r1_r8),
    kInstruction_sel_ge_r14_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ls_r7_r12_r7),
    kInstruction_sel_ls_r7_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r11_r10_r5),
    kInstruction_sel_al_r11_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r7_r4_r6),
    kInstruction_sel_al_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r12_r4_r10),
    kInstruction_sel_vs_r12_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r4_r4_r4),
    kInstruction_sel_eq_r4_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vs_r6_r6_r12),
    kInstruction_sel_vs_r6_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r9_r3_r5),
    kInstruction_sel_pl_r9_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r6_r5_r13),
    kInstruction_sel_eq_r6_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cc_r8_r2_r12),
    kInstruction_sel_cc_r8_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r4_r2_r0),
    kInstruction_sel_le_r4_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r7_r9_r8),
    kInstruction_sel_lt_r7_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r4_r7_r11),
    kInstruction_sel_le_r4_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r5_r7_r5),
    kInstruction_sel_eq_r5_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vc_r10_r7_r12),
    kInstruction_sel_vc_r10_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r7_r10_r6),
    kInstruction_sel_eq_r7_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r1_r12_r2),
    kInstruction_sel_pl_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r14_r6_r6),
    kInstruction_sel_le_r14_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ne_r3_r8_r8),
    kInstruction_sel_ne_r3_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r4_r12_r8),
    kInstruction_sel_eq_r4_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r11_r2_r3),
    kInstruction_sel_ge_r11_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_hi_r12_r6_r11),
    kInstruction_sel_hi_r12_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_cs_r4_r5_r10),
    kInstruction_sel_cs_r4_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r10_r2_r10),
    kInstruction_sel_ge_r10_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r5_r14_r6),
    kInstruction_sel_ge_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_sel_gt_r13_r7_r5),
    kInstruction_sel_gt_r13_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_sel_ge_r13_r4_r12),
    kInstruction_sel_ge_r13_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_sel_lt_r8_r10_r14),
    kInstruction_sel_lt_r8_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_le_r4_r3_r13),
    kInstruction_sel_le_r4_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_sel_pl_r0_r9_r0),
    kInstruction_sel_pl_r0_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_sel_eq_r2_r3_r1),
    kInstruction_sel_eq_r2_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_sel_vc_r0_r0_r3),
    kInstruction_sel_vc_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r10_r8_r11),
    kInstruction_sel_mi_r10_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_sel_mi_r5_r14_r14),
    kInstruction_sel_mi_r5_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_sel_gt_r5_r11_r2),
    kInstruction_sel_gt_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_sel_al_r4_r7_r11),
    kInstruction_sel_al_r4_r7_r11,
  },
};

#endif  // VIXL_ASSEMBLER_COND_RD_RN_RM_SEL_A32_H_
