import wx
import vtk
import sys

from viper import *
import numpy
from dolfin import UnitSquare


class MyFrame(wx.Frame):

    def __init__(self,parent, id, title, size):
        wx.Frame.__init__(self, parent, id, title, size=size)
        self.parent = parent
        sizer = wx.GridBagSizer()

        button = wx.Button(self, -1, label="Close")
        sizer.Add(button, (0,0))
        self.Bind(wx.EVT_BUTTON, self.OnButtonClick, button)

        self.label = wx.StaticText(self,-1,label=u'Viper wx widget example')
        self.label.SetBackgroundColour(wx.WHITE)
        self.label.SetForegroundColour(wx.BLACK)
        sizer.Add( self.label, (3,0),(4,2))


        self.mesh = UnitSquare(128,128)
        coords = self.mesh.coordinates()
        self.x = numpy.sin(numpy.pi*coords[:,0])*numpy.cos(numpy.pi*coords[:,1])


        self.v = Viper(mesh=self.mesh, x=self.x, frame=self, warpscalar=True)
        sizer.Add(self.v.widget, (1,0), (2,2), wx.EXPAND)

        sizer.AddGrowableCol(0)
        self.SetSizerAndFit(sizer)
        self.SetSizeHints(-1,self.GetSize().y,-1,self.GetSize().y );


        self.Show(True)


    def OnButtonClick(self, event):
        sys.exit()
        print "Click!"


app = wx.App()
frame = MyFrame(None, -1, "wxViper", size=(400,400))
app.MainLoop()
