/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#ifndef UPM_LOWPOWER_H
#define UPM_LOWPOWER_H

#include <QObject>

#include "common.h"

#define DEFAULE_PERCENTAGE_LOW        20
#define DEFAULE_PERCENTAGE_ACTION     5

class UpmLowPower : public QObject
{
    Q_OBJECT
public:
    explicit UpmLowPower(QObject *parent = nullptr);

    bool getBatterySaveSwitch(void);
    bool getBatteryLowState(void);
private:
    int m_percentageLow = 0;
    int m_percentageAction = 0;

    quint32 m_notificationId = 0;
    bool m_batteryLowState = false;

    bool m_enableBatterySaver;
    bool m_autoEnableBatterySaver;
    bool m_enableReduceBrightness;

    int getPowerPolicyBattery(const QString &configName);

    void setUpmSystemConfig(const QString &key, bool value);
    void batteryPercentageLowAction();
    void batteryPercentageRecoveryAction();

private slots:
    void dealAcOnlineStateChanged(int, bool);
    void dealBatteryInfoChanged(int, QStringList);

    void dealPercentageLowChanged(QVariant);
    void dealPercentageActionChanged(QVariant);

    void dealBatterySaveSwitchChanged(QVariant);
    void dealLowBatteryAutoSaveChanged(QVariant);
    void dealBatterySaveReduceBrightnessChanged(QVariant);
signals:
    void percentageLowSignal(bool);
    void brightnessControlSignal(int);
};

#endif // UPM_LOWPOWER_H
