/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef CREATEUSERINTELDIALOG_H
#define CREATEUSERINTELDIALOG_H

#include <QDialog>
#include <QProcess>
#include <QPainter>
#include <QPainterPath>
#include <QKeyEvent>
#include <QFile>
#include <QStyledItemDelegate>
#include <QHBoxLayout>
#include <QPushButton>

#ifdef ENABLEPQ
extern "C" {

#include <pwquality.h>

}
#define PWCONF "/etc/security/pwquality.conf"
#define RFLAG 0x1
#define CFLAG 0x2
#endif

namespace Ui {
class CreateUserIntelDialog;
}

class CreateUserIntelDialog : public QDialog
{
    Q_OBJECT

public:
    explicit CreateUserIntelDialog(QStringList userlist, QWidget *parent = 0);
    ~CreateUserIntelDialog();

public:
    void setupComonpent();
    void setupConnect();
    void setRequireLabel(QString msg);

    void refreshConfirmBtnStatus();

    void nameLegalityCheck(QString username);
    void pwdLegalityCheck(QString pwd);
    bool nameTraverse(QString username);

    void initPwdChecked();

    QHBoxLayout * pwdLineEditHLayout;
    QHBoxLayout * pwdsureLineEditHLayout;
    QPushButton * showPwdBtn;
    QPushButton * showSurePwdBtn;

protected:
    void paintEvent(QPaintEvent *);
    void keyPressEvent(QKeyEvent *);
    bool eventFilter(QObject *w,QEvent *e);

private:
    QStringList getHomeUser();

private:
    Ui::CreateUserIntelDialog *ui;

    bool back;
    bool isCreateUser = false;
    bool enablePwdQuality;

    bool isPwdVisibel = false;
    bool isSurePwdVisibel = false;

    QProcess * process;

    QString nameTip;
    QString pwdTip;
    QString pwdSureTip;

    QStringList usersStringList;

#ifdef ENABLEPQ
    pwquality_settings_t *settings;
#endif

Q_SIGNALS:
    void newUserWillCreate(QString username, QString pwd, QString pin, int atype);

};

#endif // CREATEUSERINTELDIALOG_H
