/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2010  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include <ctype.h>
#include <stdarg.h>
#include <stdint.h>
#include <string.h>
#include <glib.h>

static char *base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"; 

int zg_string_veprintfa(const char *flags, GString *gs, char *fmt, va_list l){
	int oldlen, argi, len, i;
	char *add, *c, *d, *fmt2, type;
	unsigned char *bin;
	GString *gs2;
	
	oldlen = gs->len;
	fmt2 = g_new(char, strlen(fmt) + 1);
	argi = 0;
	for (c = fmt; *c != '\0'; c++){
		if (*c != '%'){
			g_string_append_c(gs, *c);
			continue;
		}
		type = '\0';
		for (d = fmt2; *c != '\0'; c++, d++){
			*d = *c;
			if (!isalpha(*c)) continue;
			type = *c;
			*d = tolower(*d);
			d++;
			*d = '\0';
			break;
		}
		add = NULL;
		switch (tolower(type)){
			case 'b': // base64
				bin = va_arg(l, unsigned char *);
				len = va_arg(l, int);
				for (i = 0; i < len; i+= 3){
					g_string_append_c(gs, base64[ bin[i] >> 2 ]); // output char 0
					if (i + 1 < len){
						g_string_append_c(gs, base64[ ((bin[i] & 0x03) << 4) | ((bin[i + 1] & 0xf0) >> 4)]); // output char 1
						if (i + 2 < len){
							g_string_append_c(gs, base64[ ((bin[i + 1] & 0x0f) << 2) | ((bin[i + 2] & 0xc0) >> 6)]); // output char 2
							g_string_append_c(gs, base64[ bin[i + 2] & 0x3f ]); // output char 3
						}else{
							g_string_append_c(gs, base64[ (bin[i + 1] & 0x0f) << 2]); // output char 2
							g_string_append_c(gs, '='); //output char 3
						}
					}else{
						g_string_append_c(gs, base64[ ((bin[i] & 0x03) << 4) ]); // output char 1
						g_string_append(gs, "=="); // output chars 2,3
					}
				}
				break;
			case 'c':
				add = g_strdup_printf(fmt2, va_arg(l, int)); // char is promoted to int when passed through ...
				break;
			case 'd':
			case 'i':
			case 'u':
			case 'x':
				add = g_strdup_printf(fmt2, va_arg(l, int));
				break;
			case 's':
				add = g_strdup_printf(fmt2, va_arg(l, char *));
				break;
			default:
				add = g_strdup(fmt2);
				break;

		}

		if (add != NULL && isupper(type)){
			for (d = add; *d != '\0'; d++) *d = toupper(*d);
		}

		switch(flags[0]){
			case 'b': // handled in code before
				break;
			case 'e': // escape with '\'   
				break;
			case 'h': // html
				for (d = add; *d != '\0'; d++){
					switch(*d){
						case '<':
							g_string_append(gs, "&lt;");
							break;
						case '>':
							g_string_append(gs, "&gt;");
							break;
						case '"':
							g_string_append(gs, "&quot;");
							break;
						case '&':
							g_string_append(gs, "&amp;");
							break;
						case '\'':
							g_string_append(gs, "&#39;");
							break;
						default:
							g_string_append_c(gs, *d);    
					}
				}
				break;
			case 'q': // quoted-printable
				gs2 = g_string_sized_new(strlen(add));
				for (d = add; *d != '\0'; d++){
					if (gs2->len > 70){
						g_string_append(gs, gs2->str);
						g_string_append(gs, "=\r\n");
						g_string_assign(gs2, "");
					}
					if (*d == '\r') continue;
					if (*d == '\n') {
						g_string_append(gs, "\r\n");
						continue;
					}
					if ((*(d+1) == '\r' || *(d+1) == '\n') && (*d == ' ' || *d == '\t')){
						g_string_sprintfa(gs, "=%02X", (unsigned char)*d);
						continue;
					}
					if (*d & 0x80 || *d == '=' || (*d & 0xf8) == 0){
						g_string_sprintfa(gs, "=%02X", (unsigned char)*d);
						continue;
					}
					g_string_append_c(gs, *d);
				}
				g_string_append(gs, gs2->str);
				g_string_free(gs, TRUE);
				break;
			case 's': // postgresql
				for (d = add; *d != '\0'; d++){
					switch (*c){
						case '\'':
							g_string_append(gs, "''");
							break;
						case '\\':
							g_string_append(gs, "\\\\");
							break;
					}
				}
				break;
			case 'u': // url
				for (d = add; *d != '\0'; d++){
					if (isalnum(*d) || *d == '_' || *d == '-' || *d == '.'){
						g_string_append_c(gs, *d);
						continue;
					}
					g_string_append_c(gs, '%');
					g_string_sprintfa(gs, "%02X", (unsigned char)*d);
				}
				break;
			case 'w': // wiki
			    g_string_append(gs, "<nowiki>");
				for (d = add; *d != '\0'; d++){
					switch (*c){
						case '<':
							g_string_append(gs, "&lt;");
							break;
						case '>':
							g_string_append(gs, "&gt;");
							break;
						case '"':
							g_string_append(gs, "&quot;");
							break;
						case '&':
							g_string_append(gs, "&amp;");
							break;
						case '\'':
							g_string_append(gs, "&#39;");
							break;
						default:
							g_string_append_c(gs, *d);    
					}
				}
			    g_string_append(gs, "</nowiki>");
				break;
			default:
				g_string_append(gs, add);
		} // switch
		if (add) g_free(add);
	} // for

	g_free(fmt2);
	return gs->len - oldlen;
}


int zg_string_eprintfa(const char *flags, GString *gs, char *fmt, ...){
	va_list l;
	int ret;

	va_start(l, fmt);
	ret = zg_string_veprintfa(flags, gs, fmt, l);
	va_end(l);
	return ret;
}

int zg_string_eprintf(const char *flags, GString *gs, char *fmt, ...){
	va_list l;
	int ret;

	g_string_assign(gs, "");
	va_start(l, fmt);
	ret = zg_string_veprintfa(flags, gs, fmt, l);
	va_end(l);
	return ret;
}

