(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    133915,       3366]
NotebookOptionsPosition[    128658,       3183]
NotebookOutlinePosition[    128992,       3198]
CellTagsIndexPosition[    128949,       3195]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Solution to Floquet test problem", "Subtitle",
 CellChangeTimes->{{3.519085670492625*^9, 3.51908568838926*^9}, {
  3.519085722725892*^9, 3.519085768994845*^9}}],

Cell["Here we find a periodic solution to Duffing equation", "Text",
 CellChangeTimes->{{3.519085769963976*^9, 3.519085800138992*^9}, {
  3.519085983681726*^9, 3.519085986585157*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"x", "''"}], "+", 
    RowBox[{"\[Gamma]", " ", 
     RowBox[{"x", "'"}]}], "+", 
    RowBox[{
     SubsuperscriptBox["w", "0", "2"], "x"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[Epsilon]"}], " ", 
     SubsuperscriptBox["w", "0", "2"], 
     SuperscriptBox[
      RowBox[{"a", "(", 
       FractionBox["x", "a"], ")"}], "3"]}], "+", 
    RowBox[{
     SubsuperscriptBox["w", "0", "2"], 
     SubscriptBox["F", "0"], 
     RowBox[{"sin", "(", 
      RowBox[{"w", " ", "t"}], ")"}]}]}]}], TraditionalForm]],
 TextAlignment->Center]], "Text",
 CellChangeTimes->{{3.519085801137692*^9, 3.519085976453862*^9}},
 TextAlignment->Center],

Cell["\<\
We first compute an approximate solution using perturbation theory. We'll use \
this as an initial guess in the Sundance code. The approximate solution is.\
\>", "Text",
 CellChangeTimes->{{3.51908604716103*^9, 3.519086057086577*^9}, {
  3.519086090987296*^9, 3.519086238681523*^9}, {3.519086344160177*^9, 
  3.51908637619429*^9}, {3.519086533052917*^9, 3.519086538058391*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "p"], "(", "t", ")"}], "\[TildeTilde]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "0.75`"}], " ", 
     RowBox[{"cos", "(", 
      RowBox[{"w", " ", "t"}], ")"}]}], "+", 
    RowBox[{"0.237", 
     RowBox[{"sin", "(", 
      RowBox[{"w", " ", "t"}], ")"}]}]}]}], TraditionalForm]],
 TextAlignment->Center]], "Text",
 CellChangeTimes->{{3.519086380727335*^9, 3.519086482502275*^9}},
 TextAlignment->Center],

Cell["\<\
Next, we compute a periodic solution numerically and use it as the base of a \
Floquet analysis. The Floquet eigenvalue is \
\>", "Text",
 CellChangeTimes->{{3.51908604716103*^9, 3.519086057086577*^9}, {
  3.519086090987296*^9, 3.519086238681523*^9}, {3.519086344160177*^9, 
  3.519086379729158*^9}, {3.519086541000248*^9, 3.519086564136864*^9}}],

Cell["\[Lambda]\[TildeTilde]0.1231", "Text",
 CellChangeTimes->{{3.519086565482754*^9, 3.519086600877208*^9}},
 TextAlignment->Center],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "[", "t_", "]"}], "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A0", " ", "+", 
      RowBox[{"\[Epsilon]", " ", "A1"}]}], ")"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"w", " ", "t"}], "]"}]}], " ", "+", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"B0", " ", "+", " ", 
      RowBox[{"\[Epsilon]", " ", "B1"}]}], ")"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"w", " ", "t"}], "]"}]}], " ", "+", " ", 
   RowBox[{"\[Epsilon]", " ", "A3", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"3", " ", "w", " ", "t"}], "]"}]}], "+", " ", 
   RowBox[{"\[Epsilon]", " ", "B3", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"3", " ", "w", " ", "t"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.519075415044418*^9, 3.519075460411083*^9}, {
  3.519076450540383*^9, 3.519076472626071*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"B0", "+", 
      RowBox[{"B1", " ", "\[Epsilon]"}]}], ")"}], " ", 
    RowBox[{"cos", "(", 
     RowBox[{"t", " ", "w"}], ")"}]}], "+", 
   RowBox[{"B3", " ", "\[Epsilon]", " ", 
    RowBox[{"cos", "(", 
     RowBox[{"3", " ", "t", " ", "w"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A0", "+", 
      RowBox[{"A1", " ", "\[Epsilon]"}]}], ")"}], " ", 
    RowBox[{"sin", "(", 
     RowBox[{"t", " ", "w"}], ")"}]}], "+", 
   RowBox[{"A3", " ", "\[Epsilon]", " ", 
    RowBox[{"sin", "(", 
     RowBox[{"3", " ", "t", " ", "w"}], ")"}]}]}], TraditionalForm]], "Output",\

 CellChangeTimes->{3.519075461228281*^9, 3.519076473434103*^9, 
  3.519077081484228*^9, 3.51907810957013*^9, 3.519078204078036*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"R", " ", "=", " ", 
   RowBox[{"TrigReduce", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
      RowBox[{
       RowBox[{"w0", "^", "2"}], " ", 
       RowBox[{"x", "[", "t", "]"}]}], " ", "+", " ", 
      RowBox[{"\[Gamma]", " ", 
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}]}], " ", "+", " ", 
      RowBox[{"\[Epsilon]", " ", 
       RowBox[{
        RowBox[{"w0", "^", "2"}], " ", "/", 
        RowBox[{"a", "^", "2"}]}], " ", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], "^", "3"}]}], " ", "-", " ", 
      RowBox[{"F", " ", 
       RowBox[{"w0", "^", "2"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"w", " ", "t"}], "]"}]}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.519075467118988*^9, 3.519075610179819*^9}, {
  3.519075643291466*^9, 3.519075666634972*^9}, {3.519078194080878*^9, 
  3.519078197181412*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"R1", " ", "=", " ", 
  RowBox[{"Normal", "[", 
   RowBox[{"Series", "[", 
    RowBox[{"R", ",", 
     RowBox[{"{", 
      RowBox[{"\[Epsilon]", ",", "0", ",", "1"}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.519075670836792*^9, 3.519075719505483*^9}, {
  3.519075754240061*^9, 3.519075770359361*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "B0"}], " ", 
    RowBox[{"cos", "(", 
     RowBox[{"t", " ", "w"}], ")"}], " ", 
    SuperscriptBox["w", "2"]}], "-", 
   RowBox[{"A0", " ", 
    RowBox[{"sin", "(", 
     RowBox[{"t", " ", "w"}], ")"}], " ", 
    SuperscriptBox["w", "2"]}], "+", 
   RowBox[{"A0", " ", "\[Gamma]", " ", 
    RowBox[{"cos", "(", 
     RowBox[{"t", " ", "w"}], ")"}], " ", "w"}], "-", 
   RowBox[{"B0", " ", "\[Gamma]", " ", 
    RowBox[{"sin", "(", 
     RowBox[{"t", " ", "w"}], ")"}], " ", "w"}], "+", 
   RowBox[{"B0", " ", 
    SuperscriptBox["w0", "2"], " ", 
    RowBox[{"cos", "(", 
     RowBox[{"t", " ", "w"}], ")"}]}], "+", 
   RowBox[{"A0", " ", 
    SuperscriptBox["w0", "2"], " ", 
    RowBox[{"sin", "(", 
     RowBox[{"t", " ", "w"}], ")"}]}], "-", 
   RowBox[{"F", " ", 
    SuperscriptBox["w0", "2"], " ", 
    RowBox[{"sin", "(", 
     RowBox[{"t", " ", "w"}], ")"}]}], "+", 
   RowBox[{"\[Epsilon]", " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox["w0", "2"], " ", 
        RowBox[{"sin", "(", 
         RowBox[{"t", " ", "w"}], ")"}], " ", 
        SuperscriptBox["A0", "3"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"]}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["w0", "2"], " ", 
        RowBox[{"sin", "(", 
         RowBox[{"3", " ", "t", " ", "w"}], ")"}], " ", 
        SuperscriptBox["A0", "3"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"]}]], "+", 
      FractionBox[
       RowBox[{"3", " ", "B0", " ", 
        SuperscriptBox["w0", "2"], " ", 
        RowBox[{"cos", "(", 
         RowBox[{"t", " ", "w"}], ")"}], " ", 
        SuperscriptBox["A0", "2"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"]}]], "-", 
      FractionBox[
       RowBox[{"3", " ", "B0", " ", 
        SuperscriptBox["w0", "2"], " ", 
        RowBox[{"cos", "(", 
         RowBox[{"3", " ", "t", " ", "w"}], ")"}], " ", 
        SuperscriptBox["A0", "2"]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"]}]], "+", 
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox["B0", "2"], " ", 
        SuperscriptBox["w0", "2"], " ", 
        RowBox[{"sin", "(", 
         RowBox[{"t", " ", "w"}], ")"}], " ", "A0"}], 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"]}]], "+", 
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox["B0", "2"], " ", 
        SuperscriptBox["w0", "2"], " ", 
        RowBox[{"sin", "(", 
         RowBox[{"3", " ", "t", " ", "w"}], ")"}], " ", "A0"}], 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"]}]], "-", 
      RowBox[{"B1", " ", 
       SuperscriptBox["w", "2"], " ", 
       RowBox[{"cos", "(", 
        RowBox[{"t", " ", "w"}], ")"}]}], "+", 
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox["B0", "3"], " ", 
        SuperscriptBox["w0", "2"], " ", 
        RowBox[{"cos", "(", 
         RowBox[{"t", " ", "w"}], ")"}]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"]}]], "+", 
      RowBox[{"B1", " ", 
       SuperscriptBox["w0", "2"], " ", 
       RowBox[{"cos", "(", 
        RowBox[{"t", " ", "w"}], ")"}]}], "+", 
      RowBox[{"A1", " ", "w", " ", "\[Gamma]", " ", 
       RowBox[{"cos", "(", 
        RowBox[{"t", " ", "w"}], ")"}]}], "-", 
      RowBox[{"9", " ", "B3", " ", 
       SuperscriptBox["w", "2"], " ", 
       RowBox[{"cos", "(", 
        RowBox[{"3", " ", "t", " ", "w"}], ")"}]}], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["B0", "3"], " ", 
        SuperscriptBox["w0", "2"], " ", 
        RowBox[{"cos", "(", 
         RowBox[{"3", " ", "t", " ", "w"}], ")"}]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"]}]], "+", 
      RowBox[{"B3", " ", 
       SuperscriptBox["w0", "2"], " ", 
       RowBox[{"cos", "(", 
        RowBox[{"3", " ", "t", " ", "w"}], ")"}]}], "+", 
      RowBox[{"3", " ", "A3", " ", "w", " ", "\[Gamma]", " ", 
       RowBox[{"cos", "(", 
        RowBox[{"3", " ", "t", " ", "w"}], ")"}]}], "-", 
      RowBox[{"A1", " ", 
       SuperscriptBox["w", "2"], " ", 
       RowBox[{"sin", "(", 
        RowBox[{"t", " ", "w"}], ")"}]}], "+", 
      RowBox[{"A1", " ", 
       SuperscriptBox["w0", "2"], " ", 
       RowBox[{"sin", "(", 
        RowBox[{"t", " ", "w"}], ")"}]}], "-", 
      RowBox[{"B1", " ", "w", " ", "\[Gamma]", " ", 
       RowBox[{"sin", "(", 
        RowBox[{"t", " ", "w"}], ")"}]}], "-", 
      RowBox[{"9", " ", "A3", " ", 
       SuperscriptBox["w", "2"], " ", 
       RowBox[{"sin", "(", 
        RowBox[{"3", " ", "t", " ", "w"}], ")"}]}], "+", 
      RowBox[{"A3", " ", 
       SuperscriptBox["w0", "2"], " ", 
       RowBox[{"sin", "(", 
        RowBox[{"3", " ", "t", " ", "w"}], ")"}]}], "-", 
      RowBox[{"3", " ", "B3", " ", "w", " ", "\[Gamma]", " ", 
       RowBox[{"sin", "(", 
        RowBox[{"3", " ", "t", " ", "w"}], ")"}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.51907572052976*^9, 3.519075771248635*^9, 
  3.519076479744845*^9, 3.519077082297224*^9, 3.519078110872134*^9, 
  3.519078205468596*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c1", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"R1", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"w", " ", "t"}], "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", " ", "0", ",", " ", 
      RowBox[{"2", " ", 
       RowBox[{"Pi", "/", "w"}]}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.519075818404147*^9, 3.519075873585334*^9}, {
  3.519076021687262*^9, 3.51907602902108*^9}, {3.51907812264832*^9, 
  3.519078127804*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "w"}]], 
   RowBox[{"\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "B1"}], " ", "\[Epsilon]", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"A0", " ", "\[Gamma]", " ", "w"}], "+", 
         RowBox[{"A1", " ", "\[Gamma]", " ", "\[Epsilon]", " ", "w"}], "+", 
         RowBox[{"B0", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["w0", "2"], "-", 
            SuperscriptBox["w", "2"]}], ")"}]}], "+", 
         RowBox[{"B1", " ", 
          SuperscriptBox["w0", "2"], " ", "\[Epsilon]"}]}], ")"}], " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"3", " ", "B0", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["A0", "2"], "+", 
         SuperscriptBox["B0", "2"]}], ")"}], " ", 
       SuperscriptBox["w0", "2"], " ", "\[Epsilon]"}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.519075847729056*^9, 3.519076029998781*^9, 3.51907649356393*^9, 
   3.519077085836682*^9, {3.519078116268226*^9, 3.519078134243555*^9}, 
   3.519078208384829*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"R1", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"w", " ", "t"}], "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", " ", "0", ",", " ", 
      RowBox[{"2", " ", 
       RowBox[{"Pi", "/", "w"}]}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.51907588343251*^9, 3.519075887964053*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "w"}]], 
   RowBox[{"\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", "A0", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["A0", "2"], "+", 
         SuperscriptBox["B0", "2"]}], ")"}], " ", 
       SuperscriptBox["w0", "2"], " ", "\[Epsilon]"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"A1", " ", "\[Epsilon]", " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{"B0", " ", "\[Gamma]", " ", "w"}], "+", 
         RowBox[{"B1", " ", "\[Gamma]", " ", "\[Epsilon]", " ", "w"}], "+", 
         RowBox[{"F", " ", 
          SuperscriptBox["w0", "2"]}], "+", 
         RowBox[{"A0", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["w", "2"], "-", 
            SuperscriptBox["w0", "2"]}], ")"}]}], "-", 
         RowBox[{"A1", " ", 
          SuperscriptBox["w0", "2"], " ", "\[Epsilon]"}]}], ")"}]}]}], 
     ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.519075891781065*^9, 3.519076504772552*^9, 
  3.51907708723945*^9, 3.519078119902395*^9, 3.519078212833823*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c3", " ", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"R1", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"3", "w", " ", "t"}], "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", " ", "0", ",", " ", 
      RowBox[{"2", " ", 
       RowBox[{"Pi", "/", "w"}]}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.519075919282897*^9, 3.519075929141771*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"B3", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["w0", "2"], "-", 
            RowBox[{"9", " ", 
             SuperscriptBox["w", "2"]}]}], ")"}]}], "+", 
         RowBox[{"3", " ", "A3", " ", "w", " ", "\[Gamma]"}]}], ")"}], " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"B0", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["B0", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["A0", "2"]}]}], ")"}], " ", 
       SuperscriptBox["w0", "2"]}]}], ")"}], " ", "\[Epsilon]"}], 
   RowBox[{"4", " ", 
    SuperscriptBox["a", "2"], " ", "w"}]], TraditionalForm]], "Output",
 CellChangeTimes->{3.519075930813304*^9, 3.519076512899681*^9, 
  3.519077088904953*^9, 3.519078125223913*^9, 3.519078216783362*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s3", " ", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"R1", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"3", "w", " ", "t"}], "]"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", " ", "0", ",", " ", 
      RowBox[{"2", " ", 
       RowBox[{"Pi", "/", "w"}]}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.519075940998967*^9, 3.519075949570012*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"9", " ", "A3", " ", 
           SuperscriptBox["w", "2"]}], "+", 
          RowBox[{"3", " ", "B3", " ", "\[Gamma]", " ", "w"}], "-", 
          RowBox[{"A3", " ", 
           SuperscriptBox["w0", "2"]}]}], ")"}], " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{"A0", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["A0", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["B0", "2"]}]}], ")"}], " ", 
        SuperscriptBox["w0", "2"]}]}], ")"}], " ", "\[Epsilon]"}], 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "w"}]]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.519075951705507*^9, 3.519076518883734*^9, 
  3.519077091210496*^9, 3.519078129484113*^9, 3.519078221547669*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ab0", " ", "=", " ", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c1", "\[Equal]", "0"}], ",", 
       RowBox[{"s1", "\[Equal]", "0"}]}], "}"}], "/.", " ", 
     RowBox[{"\[Epsilon]", "\[Rule]", "0"}]}], " ", ",", 
    RowBox[{"{", 
     RowBox[{"A0", ",", "B0"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.519075987085227*^9, 3.519075999863746*^9}, {
  3.519076137106144*^9, 3.519076141191882*^9}, {3.519076345668233*^9, 
  3.519076347866402*^9}, {3.519076423871228*^9, 3.519076424812303*^9}, {
  3.519076540165609*^9, 3.519076559361621*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"A0", "\[Rule]", 
      FractionBox[
       RowBox[{"F", " ", 
        SuperscriptBox["w0", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["w0", "2"], "-", 
          SuperscriptBox["w", "2"]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["w", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["w0", "2"], " ", 
         SuperscriptBox["w", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["\[Gamma]", "2"], " ", 
         SuperscriptBox["w", "2"]}], "+", 
        SuperscriptBox["w0", "4"]}]]}], ",", 
     RowBox[{"B0", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"F", " ", "w", " ", 
         SuperscriptBox["w0", "2"], " ", "\[Gamma]"}], 
        RowBox[{
         SuperscriptBox["w", "4"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["w0", "2"], " ", 
          SuperscriptBox["w", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["\[Gamma]", "2"], " ", 
          SuperscriptBox["w", "2"]}], "+", 
         SuperscriptBox["w0", "4"]}]]}]}]}], "}"}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.519076001486166*^9, 3.519076141824837*^9, 
  3.519076348357585*^9, 3.519076429346339*^9, 3.519076560102874*^9, 
  3.519077091399719*^9, 3.519078129694814*^9, 3.519078221846057*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ab1", " ", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"c1", "\[Equal]", "0"}], ",", 
        RowBox[{"s1", "\[Equal]", "0"}]}], "}"}], " ", ",", 
      RowBox[{"{", 
       RowBox[{"A1", ",", "B1"}], "}"}]}], "]"}], "/.", " ", 
    RowBox[{"ab0", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.519076563105177*^9, 3.519076593506472*^9}, {
  3.519076627950379*^9, 3.51907662982455*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"A1", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"3", " ", 
         SuperscriptBox["F", "3"], " ", 
         SuperscriptBox["w0", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["w", "4"], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["w0", "2"]}], "+", 
              SuperscriptBox["\[Gamma]", "2"]}], ")"}], " ", 
            SuperscriptBox["w", "2"]}], "+", 
           SuperscriptBox["w0", "4"]}], ")"}]}], 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["w", "2"], "-", 
               SuperscriptBox["w0", "2"]}], ")"}], "2"], "+", 
            RowBox[{
             SuperscriptBox["w", "2"], " ", 
             SuperscriptBox["\[Gamma]", "2"]}]}], ")"}], "3"]}]]}]}], ",", 
     RowBox[{"B1", "\[Rule]", 
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox["F", "3"], " ", "w", " ", 
        SuperscriptBox["w0", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["w0", "2"], "-", 
          SuperscriptBox["w", "2"]}], ")"}], " ", "\[Gamma]"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["w", "2"], "-", 
              SuperscriptBox["w0", "2"]}], ")"}], "2"], "+", 
           RowBox[{
            SuperscriptBox["w", "2"], " ", 
            SuperscriptBox["\[Gamma]", "2"]}]}], ")"}], "3"]}]]}]}], "}"}], 
   "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.519076578842035*^9, 3.519076594258449*^9}, 
   3.519076630584939*^9, 3.519077091526214*^9, 3.519078129852836*^9, 
   3.519078221981018*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ab3", " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"c3", "\[Equal]", "0"}], ",", 
        RowBox[{"s3", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"A3", ",", "B3"}], "}"}]}], "]"}], "/.", " ", 
    RowBox[{"Flatten", "[", 
     RowBox[{"{", 
      RowBox[{"ab0", ",", "ab1"}], "}"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.519076287380547*^9, 3.519076301754105*^9}, {
  3.519076351060696*^9, 3.519076369806694*^9}, {3.519076605234963*^9, 
  3.519076651222031*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"A3", "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["F", "3"], " ", 
         SuperscriptBox["w0", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["w", "4"], " ", 
            SuperscriptBox["\[Gamma]", "4"]}], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["w", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["w", "4"]}], "-", 
              RowBox[{"4", " ", 
               SuperscriptBox["w0", "2"], " ", 
               SuperscriptBox["w", "2"]}], "+", 
              SuperscriptBox["w0", "4"]}], ")"}], " ", 
            SuperscriptBox["\[Gamma]", "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["w0", "2"], "-", 
              RowBox[{"9", " ", 
               SuperscriptBox["w", "2"]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["w0", "2"], "-", 
               SuperscriptBox["w", "2"]}], ")"}], "3"]}]}], ")"}]}], ")"}], 
       "/", 
       RowBox[{"(", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["w", "2"], "-", 
               SuperscriptBox["w0", "2"]}], ")"}], "2"], "+", 
            RowBox[{
             SuperscriptBox["w", "2"], " ", 
             SuperscriptBox["\[Gamma]", "2"]}]}], ")"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["w0", "2"], "-", 
              RowBox[{"9", " ", 
               SuperscriptBox["w", "2"]}]}], ")"}], "2"], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["w", "2"], " ", 
            SuperscriptBox["\[Gamma]", "2"]}]}], ")"}]}], ")"}]}]}], ",", 
     RowBox[{"B3", "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["F", "3"], " ", "w", " ", 
         SuperscriptBox["w0", "8"], " ", "\[Gamma]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["w", "2"]}], "-", 
              SuperscriptBox["w0", "2"]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["w", "2"], "-", 
               SuperscriptBox["w0", "2"]}], ")"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox["w", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["w0", "2"]}], "-", 
              RowBox[{"9", " ", 
               SuperscriptBox["w", "2"]}]}], ")"}], " ", 
            SuperscriptBox["\[Gamma]", "2"]}]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["w", "2"], "-", 
               SuperscriptBox["w0", "2"]}], ")"}], "2"], "+", 
            RowBox[{
             SuperscriptBox["w", "2"], " ", 
             SuperscriptBox["\[Gamma]", "2"]}]}], ")"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["w0", "2"], "-", 
              RowBox[{"9", " ", 
               SuperscriptBox["w", "2"]}]}], ")"}], "2"], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["w", "2"], " ", 
            SuperscriptBox["\[Gamma]", "2"]}]}], ")"}]}], ")"}]}]}]}], "}"}], 
   "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.519076302258361*^9, {3.519076355467086*^9, 3.519076371096986*^9}, 
   3.519076652315424*^9, 3.519077091624026*^9, 3.519078129948035*^9, 
   3.519078222113*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coeffs", " ", "=", " ", 
  RowBox[{"Flatten", "[", 
   RowBox[{"{", 
    RowBox[{"ab0", ",", " ", "ab1", ",", " ", "ab3"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.519076671104574*^9, 3.519076686435349*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A0", "\[Rule]", 
     FractionBox[
      RowBox[{"F", " ", 
       SuperscriptBox["w0", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["w0", "2"], "-", 
         SuperscriptBox["w", "2"]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["w", "4"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["w0", "2"], " ", 
        SuperscriptBox["w", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["\[Gamma]", "2"], " ", 
        SuperscriptBox["w", "2"]}], "+", 
       SuperscriptBox["w0", "4"]}]]}], ",", 
    RowBox[{"B0", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"F", " ", "w", " ", 
        SuperscriptBox["w0", "2"], " ", "\[Gamma]"}], 
       RowBox[{
        SuperscriptBox["w", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["w0", "2"], " ", 
         SuperscriptBox["w", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["\[Gamma]", "2"], " ", 
         SuperscriptBox["w", "2"]}], "+", 
        SuperscriptBox["w0", "4"]}]]}]}], ",", 
    RowBox[{"A1", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["w0", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["w", "4"], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["w0", "2"]}], "+", 
             SuperscriptBox["\[Gamma]", "2"]}], ")"}], " ", 
           SuperscriptBox["w", "2"]}], "+", 
          SuperscriptBox["w0", "4"]}], ")"}]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["w", "2"], "-", 
              SuperscriptBox["w0", "2"]}], ")"}], "2"], "+", 
           RowBox[{
            SuperscriptBox["w", "2"], " ", 
            SuperscriptBox["\[Gamma]", "2"]}]}], ")"}], "3"]}]]}]}], ",", 
    RowBox[{"B1", "\[Rule]", 
     FractionBox[
      RowBox[{"3", " ", 
       SuperscriptBox["F", "3"], " ", "w", " ", 
       SuperscriptBox["w0", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["w0", "2"], "-", 
         SuperscriptBox["w", "2"]}], ")"}], " ", "\[Gamma]"}], 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["w", "2"], "-", 
             SuperscriptBox["w0", "2"]}], ")"}], "2"], "+", 
          RowBox[{
           SuperscriptBox["w", "2"], " ", 
           SuperscriptBox["\[Gamma]", "2"]}]}], ")"}], "3"]}]]}], ",", 
    RowBox[{"A3", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["w0", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["w", "4"], " ", 
           SuperscriptBox["\[Gamma]", "4"]}], "-", 
          RowBox[{"12", " ", 
           SuperscriptBox["w", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["w", "4"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["w0", "2"], " ", 
              SuperscriptBox["w", "2"]}], "+", 
             SuperscriptBox["w0", "4"]}], ")"}], " ", 
           SuperscriptBox["\[Gamma]", "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["w0", "2"], "-", 
             RowBox[{"9", " ", 
              SuperscriptBox["w", "2"]}]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["w0", "2"], "-", 
              SuperscriptBox["w", "2"]}], ")"}], "3"]}]}], ")"}]}], ")"}], 
      "/", 
      RowBox[{"(", 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["w", "2"], "-", 
              SuperscriptBox["w0", "2"]}], ")"}], "2"], "+", 
           RowBox[{
            SuperscriptBox["w", "2"], " ", 
            SuperscriptBox["\[Gamma]", "2"]}]}], ")"}], "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["w0", "2"], "-", 
             RowBox[{"9", " ", 
              SuperscriptBox["w", "2"]}]}], ")"}], "2"], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["w", "2"], " ", 
           SuperscriptBox["\[Gamma]", "2"]}]}], ")"}]}], ")"}]}]}], ",", 
    RowBox[{"B3", "\[Rule]", 
     FractionBox[
      RowBox[{
       SuperscriptBox["F", "3"], " ", "w", " ", 
       SuperscriptBox["w0", "8"], " ", "\[Gamma]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["w", "2"]}], "-", 
            SuperscriptBox["w0", "2"]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["w", "2"], "-", 
             SuperscriptBox["w0", "2"]}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["w", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["w0", "2"]}], "-", 
            RowBox[{"9", " ", 
             SuperscriptBox["w", "2"]}]}], ")"}], " ", 
          SuperscriptBox["\[Gamma]", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["w", "2"], "-", 
             SuperscriptBox["w0", "2"]}], ")"}], "2"], "+", 
          RowBox[{
           SuperscriptBox["w", "2"], " ", 
           SuperscriptBox["\[Gamma]", "2"]}]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["w0", "2"], "-", 
            RowBox[{"9", " ", 
             SuperscriptBox["w", "2"]}]}], ")"}], "2"], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["w", "2"], " ", 
          SuperscriptBox["\[Gamma]", "2"]}]}], ")"}]}]]}]}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.519076686898092*^9, 3.519077091735543*^9, 
  3.51907813006028*^9, 3.519078222265523*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vals", " ", "=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"F", "\[Rule]", 
     RowBox[{"1", "/", "2"}]}], ",", " ", 
    RowBox[{"\[Gamma]", "\[Rule]", 
     RowBox[{"2", "/", "3"}]}], ",", 
    RowBox[{"a", "\[Rule]", "1"}], ",", 
    RowBox[{"w", "\[Rule]", " ", "1"}], ",", " ", 
    RowBox[{"w0", "\[Rule]", "1"}], ",", " ", 
    RowBox[{"\[Epsilon]", "\[Rule]", 
     RowBox[{"1", "/", "2"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.519076691804167*^9, 3.51907675248986*^9}, {
  3.519076916597726*^9, 3.519076917056503*^9}, {3.519076952212997*^9, 
  3.519076958213784*^9}, {3.519077072396275*^9, 3.519077072528866*^9}, {
  3.519077877910886*^9, 3.519077885966674*^9}, {3.519078102551514*^9, 
  3.519078103931082*^9}, {3.519078144170555*^9, 3.519078144635938*^9}, {
  3.519078232552325*^9, 3.519078233563239*^9}, {3.519080192843014*^9, 
  3.519080193851301*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"F", "\[Rule]", 
     FractionBox["1", "2"]}], ",", 
    RowBox[{"\[Gamma]", "\[Rule]", 
     FractionBox["2", "3"]}], ",", 
    RowBox[{"a", "\[Rule]", "1"}], ",", 
    RowBox[{"w", "\[Rule]", "1"}], ",", 
    RowBox[{"w0", "\[Rule]", "1"}], ",", 
    RowBox[{"\[Epsilon]", "\[Rule]", 
     FractionBox["1", "2"]}]}], "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.519080194583387*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coeffs", " ", "//.", " ", "vals"}]], "Input",
 CellChangeTimes->{{3.519076756241016*^9, 3.519076771708874*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A0", "\[Rule]", "0"}], ",", 
    RowBox[{"B0", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["3", "4"]}]}], ",", 
    RowBox[{"A1", "\[Rule]", 
     FractionBox["243", "512"]}], ",", 
    RowBox[{"B1", "\[Rule]", "0"}], ",", 
    RowBox[{"A3", "\[Rule]", 
     FractionBox["27", "8704"]}], ",", 
    RowBox[{"B3", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["27", "2176"]}]}]}], "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.519076762578863*^9, 3.519076772247254*^9}, 
   3.51907692024454*^9, 3.519076964575828*^9, 3.519077091997394*^9, 
   3.5190778890340242`*^9, 3.519078130239876*^9, {3.519078160390592*^9, 
   3.519078165644137*^9}, 3.519078222536911*^9, 3.519080203924753*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f0", " ", "=", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"A0", ",", " ", "B0"}], "}"}], " ", "/.", " ", 
   RowBox[{"(", 
    RowBox[{"coeffs", " ", "//.", " ", "vals"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.519076801658431*^9, 3.519076826055931*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"0", ",", 
    RowBox[{"-", 
     FractionBox["3", "4"]}]}], "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.519076821207166*^9, 3.519076826534361*^9}, 
   3.519076922851639*^9, 3.519076967032433*^9, 3.519077092085925*^9, 
   3.519077893692225*^9, 3.519078130308418*^9, 3.519078222686662*^9, 
   3.519080206150872*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f1", " ", "=", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"A1", ",", " ", "B1"}], "}"}], " ", "/.", " ", 
   RowBox[{"(", 
    RowBox[{"coeffs", " ", "//.", " ", "vals"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.519076884447264*^9, 3.519076887576157*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    FractionBox["243", "512"], ",", "0"}], "}"}], TraditionalForm]], "Output",\

 CellChangeTimes->{3.519076888663393*^9, 3.51907692457862*^9, 
  3.519076968762065*^9, 3.519077092173609*^9, 3.519077895800488*^9, 
  3.519078130417038*^9, 3.519078222942026*^9, 3.519080207821036*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f3", " ", "=", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"A3", ",", " ", "B3"}], "}"}], " ", "/.", " ", 
   RowBox[{"(", 
    RowBox[{"coeffs", " ", "//.", " ", "vals"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.519076993707914*^9, 3.519076996618158*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    FractionBox["27", "8704"], ",", 
    RowBox[{"-", 
     FractionBox["27", "2176"]}]}], "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.519076997309575*^9, 3.519077092594986*^9, 
  3.519077903870588*^9, 3.519078130486213*^9, 3.519078223118104*^9, 
  3.519080209264804*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"soln", " ", "=", " ", 
  RowBox[{"Join", "[", 
   RowBox[{"coeffs", ",", " ", "vals"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.519077338591726*^9, 3.519077351733276*^9}, {
  3.519077428914945*^9, 3.519077491945134*^9}, {3.519077529586739*^9, 
  3.519077530702925*^9}, {3.51907756122333*^9, 3.519077561600587*^9}, {
  3.519077922176873*^9, 3.519077978843725*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A0", "\[Rule]", 
     FractionBox[
      RowBox[{"F", " ", 
       SuperscriptBox["w0", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["w0", "2"], "-", 
         SuperscriptBox["w", "2"]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["w", "4"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["w0", "2"], " ", 
        SuperscriptBox["w", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["\[Gamma]", "2"], " ", 
        SuperscriptBox["w", "2"]}], "+", 
       SuperscriptBox["w0", "4"]}]]}], ",", 
    RowBox[{"B0", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"F", " ", "w", " ", 
        SuperscriptBox["w0", "2"], " ", "\[Gamma]"}], 
       RowBox[{
        SuperscriptBox["w", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["w0", "2"], " ", 
         SuperscriptBox["w", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["\[Gamma]", "2"], " ", 
         SuperscriptBox["w", "2"]}], "+", 
        SuperscriptBox["w0", "4"]}]]}]}], ",", 
    RowBox[{"A1", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["w0", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["w", "4"], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["w0", "2"]}], "+", 
             SuperscriptBox["\[Gamma]", "2"]}], ")"}], " ", 
           SuperscriptBox["w", "2"]}], "+", 
          SuperscriptBox["w0", "4"]}], ")"}]}], 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["w", "2"], "-", 
              SuperscriptBox["w0", "2"]}], ")"}], "2"], "+", 
           RowBox[{
            SuperscriptBox["w", "2"], " ", 
            SuperscriptBox["\[Gamma]", "2"]}]}], ")"}], "3"]}]]}]}], ",", 
    RowBox[{"B1", "\[Rule]", 
     FractionBox[
      RowBox[{"3", " ", 
       SuperscriptBox["F", "3"], " ", "w", " ", 
       SuperscriptBox["w0", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["w0", "2"], "-", 
         SuperscriptBox["w", "2"]}], ")"}], " ", "\[Gamma]"}], 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["w", "2"], "-", 
             SuperscriptBox["w0", "2"]}], ")"}], "2"], "+", 
          RowBox[{
           SuperscriptBox["w", "2"], " ", 
           SuperscriptBox["\[Gamma]", "2"]}]}], ")"}], "3"]}]]}], ",", 
    RowBox[{"A3", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["F", "3"], " ", 
        SuperscriptBox["w0", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["w", "4"], " ", 
           SuperscriptBox["\[Gamma]", "4"]}], "-", 
          RowBox[{"12", " ", 
           SuperscriptBox["w", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["w", "4"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["w0", "2"], " ", 
              SuperscriptBox["w", "2"]}], "+", 
             SuperscriptBox["w0", "4"]}], ")"}], " ", 
           SuperscriptBox["\[Gamma]", "2"]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["w0", "2"], "-", 
             RowBox[{"9", " ", 
              SuperscriptBox["w", "2"]}]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["w0", "2"], "-", 
              SuperscriptBox["w", "2"]}], ")"}], "3"]}]}], ")"}]}], ")"}], 
      "/", 
      RowBox[{"(", 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["w", "2"], "-", 
              SuperscriptBox["w0", "2"]}], ")"}], "2"], "+", 
           RowBox[{
            SuperscriptBox["w", "2"], " ", 
            SuperscriptBox["\[Gamma]", "2"]}]}], ")"}], "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["w0", "2"], "-", 
             RowBox[{"9", " ", 
              SuperscriptBox["w", "2"]}]}], ")"}], "2"], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["w", "2"], " ", 
           SuperscriptBox["\[Gamma]", "2"]}]}], ")"}]}], ")"}]}]}], ",", 
    RowBox[{"B3", "\[Rule]", 
     FractionBox[
      RowBox[{
       SuperscriptBox["F", "3"], " ", "w", " ", 
       SuperscriptBox["w0", "8"], " ", "\[Gamma]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["w", "2"]}], "-", 
            SuperscriptBox["w0", "2"]}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["w", "2"], "-", 
             SuperscriptBox["w0", "2"]}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["w", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["w0", "2"]}], "-", 
            RowBox[{"9", " ", 
             SuperscriptBox["w", "2"]}]}], ")"}], " ", 
          SuperscriptBox["\[Gamma]", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["w", "2"], "-", 
             SuperscriptBox["w0", "2"]}], ")"}], "2"], "+", 
          RowBox[{
           SuperscriptBox["w", "2"], " ", 
           SuperscriptBox["\[Gamma]", "2"]}]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["w0", "2"], "-", 
            RowBox[{"9", " ", 
             SuperscriptBox["w", "2"]}]}], ")"}], "2"], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["w", "2"], " ", 
          SuperscriptBox["\[Gamma]", "2"]}]}], ")"}]}]]}], ",", 
    RowBox[{"F", "\[Rule]", 
     FractionBox["1", "2"]}], ",", 
    RowBox[{"\[Gamma]", "\[Rule]", 
     FractionBox["2", "3"]}], ",", 
    RowBox[{"a", "\[Rule]", "1"}], ",", 
    RowBox[{"w", "\[Rule]", "1"}], ",", 
    RowBox[{"w0", "\[Rule]", "1"}], ",", 
    RowBox[{"\[Epsilon]", "\[Rule]", 
     FractionBox["1", "2"]}]}], "}"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.519077442962325*^9, 3.519077460824682*^9}, 
   3.519077492734738*^9, 3.519077531561256*^9, 3.519077563325609*^9, {
   3.51907792630041*^9, 3.519077936706757*^9}, 3.519077979563766*^9, 
   3.519078130766276*^9, {3.519078223290153*^9, 3.51907824380558*^9}, 
   3.519080210616066*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.519082128396113*^9, 3.519082132104016*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "[", "t_", "]"}], " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "t", "]"}], " ", "//.", " ", "soln"}], " ", "//", 
   "N"}]}]], "Input",
 CellChangeTimes->{{3.51907798262974*^9, 3.519077997693023*^9}, {
  3.519082171871448*^9, 3.519082173192955*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.75`"}], " ", 
    RowBox[{"cos", "(", "t", ")"}]}], "-", 
   RowBox[{"0.0062040441176470585`", " ", 
    RowBox[{"cos", "(", 
     RowBox[{"3.`", " ", "t"}], ")"}]}], "+", 
   RowBox[{"0.2373046875`", " ", 
    RowBox[{"sin", "(", "t", ")"}]}], "+", 
   RowBox[{"0.0015510110294117646`", " ", 
    RowBox[{"sin", "(", 
     RowBox[{"3.`", " ", "t"}], ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.519077991611237*^9, 3.519077998380155*^9}, 
   3.519078130859479*^9, 3.519078175779579*^9, {3.519078223343064*^9, 
   3.519078246748502*^9}, 3.51908021265716*^9, 3.519082173658337*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y", "'"}], "[", "t", "]"}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.51908215116182*^9, 3.519082176486563*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"0.2373046875`", " ", 
    RowBox[{"cos", "(", "t", ")"}]}], "+", 
   RowBox[{"0.004653033088235294`", " ", 
    RowBox[{"cos", "(", 
     RowBox[{"3.`", " ", "t"}], ")"}]}], "+", 
   RowBox[{"0.75`", " ", 
    RowBox[{"sin", "(", "t", ")"}]}], "+", 
   RowBox[{"0.018612132352941176`", " ", 
    RowBox[{"sin", "(", 
     RowBox[{"3.`", " ", "t"}], ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.51908215477965*^9, 3.519082177243317*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"y", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", " ", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.519077463350662*^9, 3.519077483926682*^9}}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV2Xk4lN8XAHAGM9aQzAwhVAhfWaIF3VOJSLK3KREq2dcWpQWpJKSSkqVE
C1KJoq5EEUlSWSL7vC9SSmSJ3/39Nc/nmXnOvffcc84784yKu7+9J4OPjy+N
n4/v/68CWLS+x/DE6kt3NSsa9Sm8mH5hrHTRFV04VVj3T4fCkw+WerQk+SOT
n2WJqloU7pu37++TpEj0xb9s87aFFG41j6rITrqAShmuz47IUPiTa5J6WlI6
0p0dt7z0i4ftfeRaU5IK0I8b2bUL7/Ow+AqEL1s8QCX7l/rH5vDwz6eB0l1V
DxBfcNxofxYPP3n+uSi0ohDN/jO7m3iVh9dVZczcKH2E/LwbqLQYHt7ZtCxh
JK8YBUzhX0muPJz4y+XR5SSMuBKzDyfEefi8bKpJuUQ5OrvG7/ESFg83FkYv
MLQvRyHf9V/Y8/PwjgGXPqW2cmT0dunvC3/6sd8OscBfQy+Rj8YrpeL2fpxs
ui/2qlQlKjG19Xh2vx9/41ct5m2pRpVf2o7fWt+PjausRNcGNyDxgmuD8Xv6
sFTT7ffLLzagTyWnE5Nc+nBvN+PSf48aUPcfvbwEpz4cz1e6QO53A6pI+GIT
YdGHu421DH8GfUCrtvsckdbqw7EPxXbfCGpEGd2dkYYjvfhzel3RZGATmta6
XBlyqBcHHLZxexTQjB7ebFq9/XAP9i3xjGcs7ERaZ7PNltl04SbKUiTHvRft
OhHHb+bQjs8uHeN7so1C8l0H1b79/oIDtaovlWcPoe0XrYruvPqAJ/ccyG/3
+4lKV/y5vr39NXZ/7myb4PULzbsrYiSXXIT3jDSVl8eOIuUrq8ZclS6iON1i
/9sxY4iVcSE1Tf85YpQXL486/Bf9/hJQfsDhLZLW3Fj/LWUSyRmy1zXYfEQb
0tfe/Jk0jV6XLsmKfdWMOD/qzCOLZ5DqC1WJPqsOlPrmGb/Afj64pmx8PjO9
C5korplV9uAHc3aI0ImCHrTBpSnIfR8/yDi6RHUU9yDHa3v7b/rww3PRI1+M
ynvQAbn4d2qh/NDw79SPLw09KFW27Zp2DD8Msf+kto30oL8SoStW5PKDuqnL
yX79XvR4Jjdw8xA/2Mrcrxp/0Iu0OqV6j4YwwGjnvvTg633IhqdcEXaQAbbL
XRUns/pQwLBuhn8EAxwLpmOO3OlDj6dtXdyiGKA0p2ee/5M+ZCKX2GSWzICK
qjNd3IY+ZG0vXSX2mAG/uP8CQxn9yKdS+vbV3wxIGNcxNNvTj+JrVaKSxhlg
s++r/qL9/ehBo577uSkGbFPb1Tbj149GO+2UjgoIwNf9U4tuHe5HEf8SL++W
EQDPm1f35Cf2ozijuafVDQTgAce2Bb/oR3m5c/cVBQlAOX+cbs08Hor6hNcI
hAtAaYT97f3yPOTC8J1vd0QApKW5iQLKPCTq8qZ+6JQAHFU0LluoxUNekhGG
iy4JwGfRQHXZNTykHNbHuFgsADM71298doCHkteVpAVMk/jWlwb/lfLQgQDP
8Bd8glBWuS+pupyH1qbNtRMXEgTZb1pecVU8NDLmI5grIQgKib/PzdbzkM1d
lQPflASB6yxz6WIXDwlLn1ths0YQhsoWVAcIUSiiY+dHrRhBMPBL9BmxoNCo
hWma51lByLx/9GDtRgr5FCrsTY8XhNv5Ug9vbKbQjqi2yblXBEHam5mju4VC
qzS3qU7mkPXts7wYXhSaCHUMrK4RhPAS6smOkxQK+GZgzKgXhCP5RrVvoilE
bZARMmkUhJS9sSPaZyjUPL8xpaBVEPohxbf7AoVKXm4uvzwoCO9/nP0zcZ1C
YRIbJT0lhCBYZOZrSxGFhsM0W25IC4HW7uDNn0so5NUpcrNZVgj4rgY8qy2l
kPOjaiNrJSGwOfgrOPMlhQy3me8yWCoEExkLN/6tI+e7tSaP304Irh5yX2vf
Tc43RyXc2EkI8LY1ce29FOoN51sTuk0IcnPDit14FPpoRVrajcTPOXDfcYhC
D3+aTL8PEoK/tk8Hev9QKNBkxcYbyUKgZ1mblMeiEZ9fcuSFFCEQd5I9kyVC
o/j0n4+OXxcCXUe2caIYje4y7ijsuSUEqRut63dI0qi7Wm5Y/bEQxN/ddTmb
TaOAyVBVuRIheOa+ZPM+Lo1mtBqdRcuEgDE0VbpInkbzL5zFQ6+EYHghM/+s
Io0cnaYSCj8KwYDU6lbRRSRezJaqrC9CwA6plru2mMQreTRxsU0InF8uYS5W
p1HcfB/3sB4hWPlwpmuxJo2qur4aGP8Wgvsea+PbltLIyO/F58q5TJhz3pPB
XkWjynR5sSdsJhjN/e8+GNPI/kMYypFnwt/y4T8eJjTyW7Y094wqE7bWBHql
rqZRzmT6IRt9Jqx18cgpWUviaU/nISMmfPL+avJgHYm3c2u37iomSD/N8ck0
o1FnudRGmbVM8G6OSwkwpxH39AmFZjsmVEtvl6ywpNHtknbbGicmZOipecZY
0WjZwMroZ9vI+y/UbM020sh206/v192YYJ26q+e+NY06jtmoxnsyQVRq39kt
m2jk8+Cuc+R+Jkyts6qcIj4jswe7BTIBqzgN624m663Hv+1DmRCwy639JfHt
sPkaZoeYsOiExE5rWxpVtHxMUDvBhA0li8Rt7Mh6YrpVnGgm/BuMWlVF3GES
NyF8hglg7j9uaE+jyXQz98EEJnB/98oLOtBo9bhpkt4lJiRrhs7dT3zCZnlF
+FUmeCqWhbwmrszW/fU8jQlLfFXXKDjSSPjfElXBLCZ0vpcJ9ybe6LjQ3uo2
E+ylZ2ULiePvKZxMuMsEn3nOij+JGxnsh5/zmfCw6XycuhONZLdLdis8YsK5
vUp7thBvLRSeu6eYCXn/TmZEEl8XZqy9U0ry3bvSLIP4m+tU4A9M8nW6ctNT
YtXi0UzDSiawA3LK3hJ7zRn+cKSaxLfyTmgivuPJ46+oY0Jrz5Xqz8RDZZ16
wh+Y8FjrhccHYt15rW42n5hQb+TnUUkcfOBjYnILE1yRyZsC4icVdS9b25lw
5jaOu0g8Kfd6RLmbCef/JD32JzYNxCp7+5nA/81htRnx8eoSu7wBJojBzSXS
xJULHp74PcyEGJXFYZ/J+Vnh9wpX/ib1+fT4wmRiq/pbXZHjTBjy3q1n9f98
Lb4h/XqKCXdqAtP/knx/iLiyRpyPBW9TPH3Tiec1JQTaC7KA++5H6mrirVpn
M1OEWTB8/o36Z3Kf106e+tAhzgIroxwZL+KOlgj+xdIsaHey3jVM7t8z1t+t
UI4FBy2+z6FIveR+25c4rsiCKcuQkG3EQ0buL01VWYDVvix/ReorqM9R5a0m
C+6t9/4SaUPyYWJjJ7WUBQ6n0aNGUp8TFy1OOBuwQOPWqiFF4uNrV3V1G7NA
WVIqNI3U+6urBtJLgAWNVncqP5B+YI5or/E3Y8Gt1f0BM6RfzqcvyJyyZoHS
76EO2ECj1GlBt3m7yP7wZklv0m8dDjMJ293JftTnrnUj/ahyb7w8w4sF+hFS
H2xJv+ZuG1D+z58FSca1AnJAo6In7zvXH2dB696VzzeR/v8rUSMVF8WC1MTK
RhaZDyaeFdAYy4Ku5j9mz1aQfpEpytiVyAKjEy+QsBGNGgJSd4dnkXy/qU3a
oEsjzQSpqZDbLBBfPn3omw6NThXEXAq6y4LvB4qe+v9H5sVw0Fvfhyy4FhC6
LoLMp7QDG5d5VLDAKzAjej2Zb95e0yy7bhZETyT/TSHzsjI6KMumnwX5hxNP
Vs2jkWI2ZWI9wILBNJH9g3PJ+j1NgRa/WHDMqcJ6IZm3y93y2kwZwuDZsOrQ
OjKvBV12FWiqCsNZnXfP149RaNeRJksNNWFI8XpvIjxKoeJUq97FmsLg8umt
UuUIhbxbjORU9IVB/k+2hMZ3Cn1wljzFWSsMBb4bsjN6KHTDrtxZ0F0YTOvD
lju9p9BKC9WZ9kxhuHJF0aIhk0LLbr6NfZMtDG9OI/z+BoV0ZoNkCu8Iw9q7
/D+rr1Gk/15pRBUKw9G6kGO5lygkpu7poPlSGBKi/nkokOdlO5M8mTrJ+5lH
JJv9KHTi9X8OkgtEwMQ8UizbkDzPVT+3/1UVgRaBjNXteuT5eezYvm41ERAx
X2chqUP2b/T+aJGOCHSHbWjfrUYhh9sBuTtWi8Dbw5tXPWNTaHHMo385O0m8
z60F5mM8VLN+ZS5cF4GC3apl9Q946OCbYzqRGSIQ9Sahq/MeD2lYVj5+fksE
HOo0fw3e5qEY680vV+WJwCB+3DZ0nYfMHDxbl70QATWjBL7UWB4q350ovqRT
BCabPird3MVDxUfoAOlFopDqafDkqBAPZRdeXdl9TxS2R2PN16v7kffUDs3m
AlFInnDVSF7Rj3TXK82vfyQKv1M0/Vz0+1FZc9b001JR2Jgyv7VtcT/6OHsP
J9aKgvYTyvuyeD/it3mxfs2gKNSkndafbu5DOwe67TI0xcDYWaUxxbcPyS7U
9t51RwwufzX6LyGmFyUknXO+kycGslZzgnYd60WijMG1o4ViINeYfEstrBfx
dd2Zf/aZGFSa/uu45dmLhm6ovyuqFYODLl9mt5r1okr5hboSw2Kg55WYl8XX
i0Lmyo+V6ouD64USwcaQHtTIL3xSrkwcrFZix23W3ahIOPh2Q40E5LrFlEdf
+oa0ZaW83avmgKPfx3cL/VvRj/ixeQafJWFwcMfe7wFNaOHp00v9vaUg/mDt
05Mq71D39rbWtTwp8A+IM9Nc/xJt6Ps4UeQnDdNdCtGHOjLQwSDPfezv0gB8
o7tdmgqwzZNrVuywueCdNlVoOl6Jh6e9IwTG5kKIydkd4+4NOPPLicd+wTLw
QPOUjOvIJzy5z3T3oSkZKNQyHT+X2YYV/yXuCDw8D3xstHRUzTtxv8W5t8KC
shA5J+lRTX43fqVWh5TOyQKfe+sme9yLreK/WbHPy8Jf6b4r+1734oY/v5zm
XJAFC5kptcPvenFHpZzPTJIstPYOil1o68V/3femdKTKQuXhgCeR471YO50x
cuOuLJTZ6ZUd1unDlzkrsxa8lYWs4xe5NSl9WCHSOo9TJwvcm4N8Zul9+Ga/
a4lkvSwo3PIfeprdhx8UxdTPfpCFy5hXeflhH651aJr81iILZkGG6+bV9WG+
BH+HDFoWNjcFP1aY6cPewrcFVUTYENjIOeO0qx/XMmLPrxNjg0gk3/u7Hv1Y
+99+tpcEG6Iml32f8O7HP0b+07gnzQZ9h4e50eH9OKStaKOhPBvGHVO+2Cf0
46P5VUmWWmwQ38b787K8Hyc49ikHbWLDAoOaY90KPDxi8+ZO8mY2bP2cu9hP
lfw+t7yjX2zHBr/y+q2/1XlYdrWv2bQTGz5fqdk+oM/Dqep/9sbsYoN5TdP5
sxt4+NakYEGqPxtS38iWJAbxcHHGItNXiWzwbsgouPeShxfNmh15eZEN6SVl
x+a95uGEnZ5P8SU2mOmYBIa/5eF98rcNy66yIflOxlOtjzwsn6yuU5TJhi07
6dxNvTwccVpzQU4hG3xO7TwfKkThtX66/Oc+sCHnyD2u1ToK59fZojMf2fC6
+Ib6qDmF52sFHj39iQ3afefUUqwoPMornDjVwoYSW+vhd3YUznYz+BXRxYb1
x2OP/HSlsLCTUY/fCBtcDJ3XSR2hcL2xSZW9NAeY37OTHtyn8NmS0ClzGQ4E
RQ/ani6gsIVhgZ6xLAdcyyyltj6kcLmO6o2Fchzovul7nldM4UcqwuGjyhyw
4Bx3fVFB4RRWk8ZlXQ54sl9ss/pCYacoCdez+hz4fPVEankLhefyW1w6towD
NSYpNbpfKXxu8in/3hUcOFhkOTzTSeFj39NblwMHnB8P6tsPUHjPxwNxLZs5
MDcisOTjFIWVbbMr3tlx4F6+swv1j8Jf6zr+vnTgwJa82PaxWQo7v7bzvLuF
A/NxQzC/II03PF2++ogrB/QsNjTVidFYJ13gp4I/Bz6syT1vLE/jgfmmatKB
HCh+NZT4fT6Nc1LCXISCOdAyY+1xVZHGykl09fcwct7Yz/4dyjSWiX6f+eIY
B85IPBJRUqfxX+9rDrvjOaCUz40L0qfxhcM3WZEJHBCf8dRuN6Cx2tl7pWlJ
HHgwvjIIDGnsdKd0YdtlDowaJA38XE7jh7y2307pHFDV8gyeMKGx5XhPTkgm
B+o6DBcvWU3jTubQjos3Sb4WzAm1QzSWVJt+1ZDDgZ88q8Fza2js46GQvPEB
ib+oVi53PY0FQhZt8H7IgRV6qTevm9M49ZT2dOxjDrAeZleesaBxTZaJx+sS
kt/7a2s2WdJ490Mzbt8zDqzLWndvkRU5z0vrOoHnHDgivFtllFity2XZmpcc
6GqhX0dY0/j5Tw/K9RUHtNvbRw030diRz/f6sSoOiEZNPuIRn1pwVLCshgPu
g63dyzbTWH5pdElrLQciE0zsGogfrj7vM/GOA27ZDBsPW3K+nWlNRo0caFfn
/gy1o3G4b3asUxMHJv4oJP8mnnM0zyTkMwfKxn++2m9P49txRT+TmjlwC40d
ayY2vf78VmErBxo/J1YiBxo33ava2vCVA34vtJLJ903sU/pO/EcH2d+Izvdx
YoHaT+USXRyY2SPyfoMjyU9re4h2DwdeC2uvTCLWG+jT2NjHAZd6Ua0m4uqJ
71/38zgQk6Vwa44TyZfIWEIszQHd4Laba4jHuTNmOYMceLq0cokvcbwGc6Lq
OwdM3jobJhKrrZiT1/uDA60r2K/ziJ9bsN0EfnFAIDy2rYLYcYuSrOooBx7F
GIU2EA96qdXAGKnHwPtJ5Ps+Phmmc9T1Lwf6rA4ZfCKWjzHSOzbJAcelS7fU
ERdeWt13fZoDKRZ7/pUSb8g2v1o6w4GB6rzFt4g7H9tsauXjgvvYnfdRxOGV
zvwTDC4oqo5N7iSe07SriCPEBa98g5ylxNk9XvuNWFz4OofVNEHOb/LbT9FJ
hAtJNZwTZcRNjPAPwWJcWHZQKj+c+MDcyOgkCRKv5sZ2LWKG6umVhZJc8Dke
HPOF5DtV78L399JcUD20Vi+CuNo23UmCzYWDMvmMAnJ/3pV9L1hcLnhsfcu/
nlhihbYGQ54LYaetw5vI/dsveDo5psgF2cEXld9IvYwmze4ZWUA+r+lwfQfx
Zab5u0EVLjz3vkT/v77avjemdy7mQqB4TG+ODY2PucmJtKlzodZ7MFGEWPmT
a9CnJVw4XeXz2IPUq0fZkNnb/7jQfGHjVhap7+GzzIFHhsQNxdyZDTROmLF2
yF/OhepqTR8tYoOgi2W5K7nALyy8zJ7008FtyhfSTLmQOv5JOY70H0Nj1bLT
67mwcifbr5D0561rx9NOWHDBOU7F4y7Q2ELyDTPCkgtyz4/VXyf9HDfm0BKw
iQvP3try+ZnSWLbK99h2J3IfSa9bXq6gccmKxzzHLVyw4L0KjiHzYvv9SdvN
27gwfPDSSTMjGt+4eHqh2U4uCJ5aNHufzBsN98zq/zy50Po4KnypDo3ffuLp
aezlQl1IdinWprGvpc411f1cuM0tCbXUIv2oW+rL8eWCuG6AtaUGue/Zprn8
oVxg+3SemVShcUfQ/IipMC7IM5edcibz70S/W9+fg1yo2mEwek+Jxq/fDRcP
RHDBIBdWryPzc/N14Z1NUaTeFPwPL5xHY/eVJjk5yVzoOjTacpfM42/ILr7u
MhdSlO3Vghg0djH3Ch1J4QJYGNTp8dHY2SFhnXEaFzSrbqilknlv5dv7rT6b
C69LCxZL/qKwfmYcd+wJOa9BXNPZdgoX5GTOyj/lggavcvZLK4W185/0o1Iu
LHeLiVdsprBaaefjM5gLtszrLYmNFJb/tMxOsZoL/7jXjBe8oTBDpP2MWQs5
n8yW/nf5FI6U/BWwv43U9zW4m3mPwtOyrK3x7VwQjlb65ptL4TFVPbXmLi6s
WXQm/UcmhQdMoisODHChMyfpckoyhRsD/ptKmuKC0CpnsxMHKZzVfNSnS1EO
oNMjpmgV2V/M5McRYuFV6/QuEz8xCDdmKMmBjZV/axhxbXyA6ELiyisP1FcQ
j5rtyfUgLtBoznu2ksLmhRt6ecRzDJ/vwyvI+mdkXIYXyMH0pR8pb4woHLI8
4dUMcdmWMxK5xDO94lqSynIwMz/weCyxDDAnlxKfKdJ0syQ2Gft7JZD4vr/5
nFpDCse7d3wcJY7jqHLql1GYK7XDWEhFDkSU0wLyibOef8mSJbay86qOJy7m
fgg0Ir67vCdoM3Fn/SvJg8RyW04/ajCgsHcEhMcSt1HBsw+IR5c870ghTnyS
b5lILBz9JO8pcYSkZIsdcZK+gexb4sj0ZUr6xAqdBRGtxJzQXLe5xLfPa/cO
EOcked/8pU9hPeM7G6eIr04e7vn//zf/Awg5ZG8=
      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->
    NCache[{{0, 2 Pi}, {-0.7917282929152439, 0.7917283933485308}}, {{
      0, 6.283185307179586}, {-0.7917282929152439, 0.7917283933485308}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.519077534520428*^9, 3.519077565703603*^9, 3.519077939397512*^9, 
   3.519078001312882*^9, 3.519078130931162*^9, 3.519078179869718*^9, {
   3.51907822345784*^9, 3.519078248417798*^9}, 3.51908021493926*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "[", "0", "]"}]], "Input",
 CellChangeTimes->{{3.519077570708438*^9, 3.519077574415721*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   FractionBox["3291", "4352"]}], TraditionalForm]], "Output",
 CellChangeTimes->{3.51907757488623*^9, 3.519078007236622*^9, 
  3.519078131051441*^9, 3.519078184772125*^9, 3.51907822351803*^9, 
  3.519080216724677*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "'"}], "[", "0", "]"}]], "Input",
 CellChangeTimes->{{3.519077576276691*^9, 3.51907757744386*^9}}],

Cell[BoxData[
 FormBox[
  FractionBox["1053", "4352"], TraditionalForm]], "Output",
 CellChangeTimes->{3.519077578108824*^9, 3.519078009335246*^9, 
  3.519078131155883*^9, 3.519078223614673*^9, 3.519080219437289*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", "[", "u_", "]"}], ":=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"u", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "2"}], "}"}]}], "]"}], "+", " ", 
    RowBox[{"\[Gamma]", " ", 
     RowBox[{"D", "[", 
      RowBox[{"u", ",", "t"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"w0", "^", "2"}], " ", "u"}], "+", 
    RowBox[{"\[Epsilon]", " ", 
     RowBox[{
      RowBox[{"w0", "^", "2"}], " ", "/", 
      RowBox[{"a", "^", "2"}]}], " ", 
     RowBox[{"u", "^", "3"}]}], " ", "-", " ", 
    RowBox[{"F", " ", 
     RowBox[{"w0", "^", "2"}], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"w", " ", "t"}], "]"}]}]}], "\[Equal]", "0"}]}]], "Input",
 CellChangeTimes->{{3.519080020219326*^9, 3.519080046998347*^9}, {
  3.519080373982058*^9, 3.51908038347187*^9}, {3.519080423106968*^9, 
  3.519080451953977*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{"#", ",", "\[Delta]"}], "]"}], "&"}], ",", 
    RowBox[{"Expand", "[", 
     RowBox[{"e", "[", 
      RowBox[{
       RowBox[{"up", "[", "t", "]"}], "+", " ", 
       RowBox[{"\[Delta]", " ", 
        RowBox[{"du", "[", "t", "]"}]}]}], "]"}], "]"}]}], "]"}], "/.", " ", 
  "soln"}]], "Input",
 CellChangeTimes->{{3.519080250555973*^9, 3.519080318274463*^9}, {
  3.519080350463929*^9, 3.519080398924086*^9}, {3.519080468819971*^9, 
  3.519080630307265*^9}, {3.519080694854383*^9, 3.519080703843612*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["3", "2"], " ", 
     RowBox[{"du", "(", "t", ")"}], " ", 
     SuperscriptBox[
      RowBox[{"up", "(", "t", ")"}], "2"]}], "+", 
    RowBox[{"du", "(", "t", ")"}], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{
       SuperscriptBox["du", "\[Prime]",
        MultilineFunction->None], "(", "t", ")"}]}], "3"], "+", 
    RowBox[{
     SuperscriptBox["du", "\[Prime]\[Prime]",
      MultilineFunction->None], "(", "t", ")"}]}], "\[LongEqual]", "0"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.51908040024472*^9, {3.51908046007673*^9, 3.519080520519515*^9}, {
   3.51908055694929*^9, 3.519080631488643*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bvp", " ", "=", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"e", "[", 
      RowBox[{"u", "[", "t", "]"}], "]"}], ",", " ", 
     RowBox[{
      RowBox[{"u", "[", "0", "]"}], "\[Equal]", 
      RowBox[{"u", "[", 
       RowBox[{"2", "Pi"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"u", "'"}], "[", "0", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"u", "'"}], "[", 
       RowBox[{"2", "Pi"}], "]"}]}]}], "}"}], "/.", " ", "soln"}]}]], "Input",\

 CellChangeTimes->{{3.519077601950342*^9, 3.519077761860408*^9}, {
  3.519077803249591*^9, 3.519077803711769*^9}, {3.519078015296522*^9, 
  3.519078029614748*^9}, {3.51907924114321*^9, 3.519079257037327*^9}, {
  3.519080058688309*^9, 3.51908007917522*^9}, {3.519080648718349*^9, 
  3.519080649347044*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox[
       SuperscriptBox[
        RowBox[{"u", "(", "t", ")"}], "3"], "2"], "+", 
      RowBox[{"u", "(", "t", ")"}], "-", 
      FractionBox[
       RowBox[{"sin", "(", "t", ")"}], "2"], "+", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["u", "\[Prime]",
          MultilineFunction->None], "(", "t", ")"}]}], "3"], "+", 
      RowBox[{
       SuperscriptBox["u", "\[Prime]\[Prime]",
        MultilineFunction->None], "(", "t", ")"}]}], "\[LongEqual]", "0"}], 
    ",", 
    RowBox[{
     RowBox[{"u", "(", "0", ")"}], "\[LongEqual]", 
     RowBox[{"u", "(", 
      RowBox[{"2", " ", "\[Pi]"}], ")"}]}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["u", "\[Prime]",
       MultilineFunction->None], "(", "0", ")"}], "\[LongEqual]", 
     RowBox[{
      SuperscriptBox["u", "\[Prime]",
       MultilineFunction->None], "(", 
      RowBox[{"2", " ", "\[Pi]"}], ")"}]}]}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.51907774625712*^9, 3.519077762373701*^9}, 
   3.519077806048866*^9, 3.519078031343412*^9, 3.519078131214582*^9, 
   3.519078223708796*^9, 3.519078255495612*^9, 3.519079257708632*^9, {
   3.519080080983615*^9, 3.519080101617228*^9}, 3.519080227360232*^9, 
   3.51908065033507*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nSoln", " ", "=", " ", 
  RowBox[{
   RowBox[{"NDSolve", "[", 
    RowBox[{"bvp", ",", 
     RowBox[{"u", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.519077782448868*^9, 3.519077811758106*^9}, {
  3.519078051589421*^9, 3.519078059547678*^9}, {3.519078300552331*^9, 
  3.519078331203118*^9}, {3.519079261289685*^9, 3.51907926149703*^9}, {
  3.51908008737045*^9, 3.519080089051132*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u", "(", "t", ")"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"(", "\[NoBreak]", GridBox[{
           {"0.`", "6.283185307179586`"}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.7]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
            "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
        ",", "\<\"<>\"\>"}], "]"}],
      False,
      Editable->False], "[", "t", "]"}]}], "}"}], TraditionalForm]], "Output",\

 CellChangeTimes->{{3.519077792608382*^9, 3.519077812367455*^9}, {
   3.519078035966773*^9, 3.519078060010232*^9}, 3.51907813131622*^9, 
   3.519078223769707*^9, 3.519078257136498*^9, {3.519078302983607*^9, 
   3.519078331727514*^9}, 3.519079262758961*^9, {3.519080089670346*^9, 
   3.519080105100659*^9}, 3.519080156055724*^9, 3.519080230205731*^9, 
   3.519080653486864*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"up", "[", "t_", "]"}], " ", "=", " ", 
  RowBox[{
   RowBox[{"u", "[", "t", "]"}], "/.", " ", "nSoln"}]}]], "Input",
 CellChangeTimes->{{3.519080657208317*^9, 3.519080673594938*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0.`", "6.283185307179586`"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "t", "]"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.519080674140084*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"de", " ", "=", " ", 
  RowBox[{
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{"#", ",", "\[Delta]"}], "]"}], "&"}], ",", 
     RowBox[{"Expand", "[", 
      RowBox[{"e", "[", 
       RowBox[{
        RowBox[{"up", "[", "t", "]"}], "+", " ", 
        RowBox[{"\[Delta]", " ", 
         RowBox[{"du", "[", "t", "]"}]}]}], "]"}], "]"}]}], "]"}], "/.", " ", 
   "soln"}]}]], "Input",
 CellChangeTimes->{{3.519080757503583*^9, 3.519080758662326*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["3", "2"], " ", 
     RowBox[{"du", "(", "t", ")"}], " ", 
     SuperscriptBox[
      RowBox[{
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"(", "\[NoBreak]", GridBox[{
             {"0.`", "6.283185307179586`"}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.7]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
              "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
          ",", "\<\"<>\"\>"}], "]"}],
        False,
        Editable->False], "[", "t", "]"}], "2"]}], "+", 
    RowBox[{"du", "(", "t", ")"}], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{
       SuperscriptBox["du", "\[Prime]",
        MultilineFunction->None], "(", "t", ")"}]}], "3"], "+", 
    RowBox[{
     SuperscriptBox["du", "\[Prime]\[Prime]",
      MultilineFunction->None], "(", "t", ")"}]}], "\[LongEqual]", "0"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.519080717321006*^9, 3.519080759989058*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"soln1", " ", "=", " ", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"de", ",", 
      RowBox[{
       RowBox[{"du", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"du", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",",
     
    RowBox[{"du", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.519080725550624*^9, 3.519080730450324*^9}, {
  3.519080762947465*^9, 3.519080808747938*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"du", "(", "t", ")"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0.`", "6.283185307179586`"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.7]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False], "[", "t", "]"}]}], "}"}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{{3.519080785499586*^9, 3.519080811144477*^9}, 
   3.519080926988116*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"soln2", " ", "=", " ", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"de", ",", 
      RowBox[{
       RowBox[{"du", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"du", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",",
     
    RowBox[{"du", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.51908081409067*^9, 3.519080821864037*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"du", "(", "t", ")"}], "\[Rule]", 
     RowBox[{
      TagBox[
       RowBox[{"InterpolatingFunction", "[", 
        RowBox[{
         RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0.`", "6.283185307179586`"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.7]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
         ",", "\<\"<>\"\>"}], "]"}],
       False,
       Editable->False], "[", "t", "]"}]}], "}"}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.519080823825876*^9, 3.519080890301686*^9, 
  3.519080928980805*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "[", "t_", "]"}], "=", 
  RowBox[{
   RowBox[{"du", "[", "t", "]"}], "/.", " ", 
   RowBox[{"soln2", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.519081075185357*^9, 3.519081089522356*^9}, {
  3.519081208178679*^9, 3.519081221568485*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0.`", "6.283185307179586`"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "t", "]"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.519081222018537*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "'"}], "[", "t", "]"}]], "Input",
 CellChangeTimes->{{3.519081223761957*^9, 3.51908122625367*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0.`", "6.283185307179586`"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "t", "]"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.519081226863522*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"du", "[", "t", "]"}], "/.", " ", 
    RowBox[{"soln1", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ",", "t"}], "]"}]], "Input",
 CellChangeTimes->{{3.519081349336164*^9, 3.519081364861252*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0.`", "6.283185307179586`"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "t", "]"}], TraditionalForm]], "Output",
 CellChangeTimes->{{3.51908135938371*^9, 3.519081365563772*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"du1", "[", "t_", "]"}], "=", 
  RowBox[{
   RowBox[{"du", "[", "t", "]"}], "/.", " ", 
   RowBox[{"soln1", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.519081390531744*^9, 3.519081433642111*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0.`", "6.283185307179586`"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "t", "]"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.51908143496101*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"du2", "[", "t_", "]"}], "=", 
  RowBox[{
   RowBox[{"du", "[", "t", "]"}], "/.", " ", 
   RowBox[{"soln2", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.519081441555778*^9, 3.519081444827488*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0.`", "6.283185307179586`"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "t", "]"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.519081445495467*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"du1", "'"}], "[", "t", "]"}], ",", 
     RowBox[{
      RowBox[{"du2", "'"}], "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.519081267680606*^9, 3.519081292067169*^9}, {
  3.519081322260106*^9, 3.519081379988677*^9}, {3.519081451354133*^9, 
  3.519081462467492*^9}}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k0lN8bAHBR2WYQMaOiokVFhZDIcxEqZUlRWZK0fElSSllTWRKSQrJl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      "]]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk8VN8bB3DGDFoV5g6hUFRIi6RC5yGFStnb7Nl3ZcuaFoQkpYWkLJFK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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->
    NCache[{{0, 2 Pi}, {-0.7723581402867035, 0.999999912896193}}, {{
      0, 6.283185307179586}, {-0.7723581402867035, 0.999999912896193}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.519081292627763*^9, {3.519081330061879*^9, 3.519081347310498*^9}, 
   3.51908138085437*^9, {3.519081458319182*^9, 3.51908146322296*^9}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.519081316364789*^9, 3.519081316629878*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"K", " ", "=", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"du1", "[", 
       RowBox[{"2", "Pi"}], "]"}], ",", 
      RowBox[{"du2", "[", 
       RowBox[{"2", "Pi"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"du1", "'"}], "[", 
       RowBox[{"2", "Pi"}], "]"}], ",", 
      RowBox[{
       RowBox[{"du2", "'"}], "[", 
       RowBox[{"2", "Pi"}], "]"}]}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.519080947012203*^9, 3.51908095345371*^9}, {
  3.519081470473034*^9, 3.519081502252009*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.07649993592462377`", "0.03670098749466305`"},
     {
      RowBox[{"-", "0.14670470786064627`"}], "0.12784865349097504`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.519081502892042*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"Eigenvalues", "[", "K", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.519081113889362*^9, 3.519081115654554*^9}, {
  3.519081508635909*^9, 3.519081525894807*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"0.12314471750225746`", ",", "0.12314471750225746`"}], "}"}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.519081116079874*^9, {3.519081511798922*^9, 3.51908152641079*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "v", "]"}]], "Input",
 CellChangeTimes->{{3.519078068840872*^9, 3.519078072077073*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "t_", "]"}], " ", "=", " ", 
  RowBox[{
   RowBox[{"u", "[", "t", "]"}], " ", "/.", " ", "nSoln"}]}]], "Input",
 CellChangeTimes->{{3.519078039042575*^9, 3.519078064770515*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0.`", "6.283185307179586`"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
      ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], "[", "t", "]"}], TraditionalForm]], "Output",
 CellChangeTimes->{3.519080158632363*^9, 3.519080233859217*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "t", "]"}], ",", 
     RowBox[{"v", "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.519078074861733*^9, 3.519078087667655*^9}, {
  3.519078307342265*^9, 3.519078307804869*^9}, {3.519079276205215*^9, 
  3.519079276328094*^9}, {3.519080143162901*^9, 3.5190801725705*^9}}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV2Xk4lN8XAHAGM9aQzAwhVAhfWaIF3VOJSLK3KREq2dcWpQWpJKSSkqVE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      "]]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwV2XlYjF0bAPCappkWbdLMFO0kbUpEWs7NGyFapGzRorK0h7KkeFVEkkFS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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->
    NCache[{{0, 2 Pi}, {-0.7917282929152439, 0.7917283933485308}}, {{
      0, 6.283185307179586}, {-0.7917282929152439, 0.7917283933485308}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.519078088109175*^9, 3.519078131571923*^9, 3.519078224144356*^9, 
   3.519078262182831*^9, {3.519078308379773*^9, 3.519078335865521*^9}, {
   3.519079271740743*^9, 3.519079277065029*^9}, {3.519080121711464*^9, 
   3.519080173098534*^9}, 3.519080235695507*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "[", "t", "]"}]], "Input",
 CellChangeTimes->{{3.519079290894399*^9, 3.519079291544017*^9}}],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"3", " ", 
      RowBox[{"cos", "(", "t", ")"}]}], "4"]}], "-", 
   FractionBox[
    RowBox[{"27", " ", 
     RowBox[{"cos", "(", 
      RowBox[{"3", " ", "t"}], ")"}]}], "4352"], "+", 
   FractionBox[
    RowBox[{"243", " ", 
     RowBox[{"sin", "(", "t", ")"}]}], "1024"], "+", 
   FractionBox[
    RowBox[{"27", " ", 
     RowBox[{"sin", "(", 
      RowBox[{"3", " ", "t"}], ")"}]}], "17408"]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{3.519079292125783*^9, 3.51908024101158*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{640, 750},
WindowMargins->{{150, Automatic}, {Automatic, 52}},
FrontEndVersion->"6.0 for Linux x86 (32-bit) (June 19, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 166, 2, 64, "Subtitle"],
Cell[759, 27, 183, 2, 36, "Text"],
Cell[945, 31, 719, 23, 49, "Text"],
Cell[1667, 56, 387, 6, 82, "Text"],
Cell[2057, 64, 490, 15, 39, "Text"],
Cell[2550, 81, 356, 6, 59, "Text"],
Cell[2909, 89, 134, 2, 36, "Text"],
Cell[CellGroupData[{
Cell[3068, 95, 842, 23, 83, "Input"],
Cell[3913, 120, 799, 23, 81, "Output"]
}, Open  ]],
Cell[4727, 146, 976, 26, 83, "Input"],
Cell[CellGroupData[{
Cell[5728, 176, 343, 9, 36, "Input"],
Cell[6074, 187, 5164, 144, 480, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11275, 336, 497, 13, 36, "Input"],
Cell[11775, 351, 1266, 35, 145, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13078, 391, 403, 11, 36, "Input"],
Cell[13484, 404, 1262, 34, 145, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14783, 443, 409, 11, 36, "Input"],
Cell[15195, 456, 966, 27, 87, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16198, 488, 404, 11, 36, "Input"],
Cell[16605, 501, 956, 26, 87, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17598, 532, 631, 15, 36, "Input"],
Cell[18232, 549, 1380, 39, 153, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19649, 593, 548, 15, 83, "Input"],
Cell[20200, 610, 2083, 60, 186, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22320, 675, 633, 17, 83, "Input"],
Cell[22956, 694, 4279, 121, 299, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27272, 820, 243, 6, 36, "Input"],
Cell[27518, 828, 6755, 199, 582, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34310, 1032, 901, 19, 60, "Input"],
Cell[35214, 1053, 460, 13, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35711, 1071, 135, 2, 36, "Input"],
Cell[35849, 1075, 766, 19, 130, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36652, 1099, 285, 7, 36, "Input"],
Cell[36940, 1108, 379, 9, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37356, 1122, 285, 7, 36, "Input"],
Cell[37644, 1131, 333, 8, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38014, 1144, 285, 7, 36, "Input"],
Cell[38302, 1153, 336, 9, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38675, 1167, 388, 7, 36, "Input"],
Cell[39066, 1176, 7281, 210, 592, "Output"]
}, Open  ]],
Cell[46362, 1389, 92, 1, 36, "Input"],
Cell[CellGroupData[{
Cell[46479, 1394, 304, 8, 36, "Input"],
Cell[46786, 1404, 664, 16, 81, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47487, 1425, 162, 4, 36, "Input"],
Cell[47652, 1431, 500, 13, 81, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48189, 1449, 261, 7, 36, "Input"],
Cell[48453, 1458, 9181, 157, 304, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57671, 1620, 120, 2, 36, "Input"],
Cell[57794, 1624, 258, 6, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58089, 1635, 137, 3, 36, "Input"],
Cell[58229, 1640, 216, 4, 80, "Output"]
}, Open  ]],
Cell[58460, 1647, 877, 25, 83, "Input"],
Cell[CellGroupData[{
Cell[59362, 1676, 622, 16, 60, "Input"],
Cell[59987, 1694, 712, 21, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60736, 1720, 816, 22, 83, "Input"],
Cell[61555, 1744, 1356, 38, 123, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62948, 1787, 562, 13, 36, "Input"],
Cell[63513, 1802, 1293, 33, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64843, 1840, 217, 5, 36, "Input"],
Cell[65063, 1847, 820, 23, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65920, 1875, 524, 15, 83, "Input"],
Cell[66447, 1892, 1424, 40, 130, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67908, 1937, 588, 17, 60, "Input"],
Cell[68499, 1956, 1058, 30, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69594, 1991, 538, 16, 60, "Input"],
Cell[70135, 2009, 1055, 30, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71227, 2044, 310, 8, 36, "Input"],
Cell[71540, 2054, 820, 23, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[72397, 2082, 137, 3, 36, "Input"],
Cell[72537, 2087, 820, 23, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73394, 2115, 264, 7, 36, "Input"],
Cell[73661, 2124, 843, 23, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74541, 2152, 263, 7, 36, "Input"],
Cell[74807, 2161, 819, 23, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75663, 2189, 263, 7, 36, "Input"],
Cell[75929, 2198, 820, 23, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76786, 2226, 484, 14, 36, "Input"],
Cell[77273, 2242, 29299, 490, 306, 18612, 313, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[106587, 2735, 92, 1, 36, "Input"],
Cell[CellGroupData[{
Cell[106704, 2740, 600, 19, 60, "Input"],
Cell[107307, 2761, 692, 18, 80, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108036, 2784, 209, 4, 36, "Input"],
Cell[108248, 2790, 234, 6, 56, "Output"]
}, Open  ]],
Cell[108497, 2799, 127, 2, 36, "Input"],
Cell[CellGroupData[{
Cell[108649, 2805, 221, 5, 36, "Input"],
Cell[108873, 2812, 842, 23, 56, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109752, 2840, 480, 12, 36, "Input"],
Cell[110235, 2854, 17660, 297, 304, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[127932, 3156, 120, 2, 36, "Input"],
Cell[128055, 3160, 575, 19, 80, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

