/*
// @HEADER
// ***********************************************************************
//
//                    Teuchos: Common Tools Package
//                 Copyright (2004) Sandia Corporation
//
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact Michael A. Heroux (maherou@sandia.gov)
//
// ***********************************************************************
// @HEADER
*/

#include "Teuchos_CommandLineProcessor.hpp"
#include "Teuchos_GlobalMPISession.hpp"
#include "Teuchos_StandardCatchMacros.hpp"
#include "Teuchos_VerboseObject.hpp"
#include "Teuchos_RCPNode.hpp"

#include "TestClasses.hpp"

int main(int argc, char* argv[])
{

  using Teuchos::RCP;
  using Teuchos::rcp;

  Teuchos::GlobalMPISession mpiSession(&argc,&argv);
  const Teuchos::RCP<Teuchos::FancyOStream> out
    = Teuchos::VerboseObjectBase::getDefaultOStream();

  bool printActiveRcpNodesOnExit = true;
  bool success = true;

  try {

    // Read in commandline arguments
    Teuchos::CommandLineProcessor clp;
    clp.setOption("print-active-rcp-nodes-on-exit", "no-print-active-rcp-nodes-on-exit",
      &printActiveRcpNodesOnExit);
    (void)clp.parse(argc, argv);

    // Create a circular reference that will result in dangling active
    // RCPNodes at shutdown.
    RCP<A> a = rcp(new A);
    RCP<C> c = rcp(new C);
    a->set_C(c);
    c->set_A(a);

  } // try
  TEUCHOS_STANDARD_CATCH_STATEMENTS(true, std::cerr, success);

  if(success) {
    *out << "\nEnd Result: TEST PASSED" << std::endl;
  }

  if (!printActiveRcpNodesOnExit) {
    Teuchos::RCPNodeTracer::setPrintActiveRcpNodesOnExit(false);
  }
  // ABOVE: If not set to 'fasle', we leave it at the default which should be
  // true to make sure that the default is true!

  return ( success ? 0 : 1 );
}
