/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 1009-1013 Martin Brehm
                  1011-1013 Martin Thomas

    This file written by Martin Brehm.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#include "ffgen.h"


void CFFGen::InitFFParm()
{
	/********************************************/
	/*** Lennard-Jones parameters             ***/
	/*** Sigma (Angstrom), Epsilon (KJ/mol)   ***/
	/********************************************/

	// Liu's Force Field
	AddAtomParm("CR", 3.400f, 0.3598f );
	AddAtomParm("NA", 3.150f, 0.7113f );
	AddAtomParm("CW", 3.400f, 0.3598f );
	AddAtomParm("H4", 1.511f, 0.0618f );
	AddAtomParm("H5", 1.781f, 0.0618f );
	AddAtomParm("CT", 3.400f, 0.4577f );
	AddAtomParm("H1", 1.471f, 0.0657f );
	AddAtomParm("HC", 1.650f, 0.0657f );
	AddAtomParm("P",  3.741f, 0.8368f );
	AddAtomParm("B",  3.581f, 0.3975f );
	AddAtomParm("F",  3.118f, 0.1551f );
	AddAtomParm("Cl", 3.755f, 0.6849f );

	// Amber (parm99.dat)
//	AddAtomParm("OH", 3.067f, 0.8803f );
//	AddAtomParm("HO", 0.000f, 0.0000f );
	AddAtomParm("O",  1.960f, 0.8786f );
	AddAtomParm("O1", 1.960f, 0.8786f );
	AddAtomParm("C",  3.400f, 0.3598f );
	AddAtomParm("N3", 3.150f, 0.7113f );
	AddAtomParm("N",  3.150f, 0.7113f );
	AddAtomParm("H",  1.069f, 0.0657f );
	AddAtomParm("HA", 1.598f, 0.0619f );
	AddAtomParm("CA", 3.400f, 0.3603f );
	AddAtomParm("CZ", 3.400f, 0.3603f );
	AddAtomParm("HZ", 1.598f, 0.0619f );
	AddAtomParm("OM", 1.960f, 0.8786f ); // Molecular Oxygen
	AddAtomParm("S6", 3.564f, 1.0465f );

	// TIP3P Water
	AddAtomParm("OH", 3.151f, 0.6364f );
	AddAtomParm("HO", 0.400f, 0.1930f );


	/*****************************************************/
	/*** Bond parameters                               ***/
	/*** eq. Length (Angstrom), K (KJ*Angstrom^1/mol)  ***/
	/*****************************************************/

	// Liu's Force Field
	AddBondParm("CT", "CT", 1.516f, 1197.0f );
	AddBondParm("CT", "H1", 1.080f, 1413.0f );
	AddBondParm("CW", "H4", 1.070f, 1611.0f );
	AddBondParm("CR", "H5", 1.070f, 1590.0f );
	AddBondParm("CR", "NA", 1.315f, 1674.0f );
	AddBondParm("CR", "N",  1.386f, 1674.0f ); // Hack Coffeine
	AddBondParm("CW", "NA", 1.378f, 1506.0f );
	AddBondParm("CT", "NA", 1.471f, 1171.0f );
	AddBondParm("CT", "N",  1.483f, 1171.0f ); // Hack Coffeine
	AddBondParm("CW", "CW", 1.343f, 1715.0f );
	AddBondParm("CW", "CR", 1.391f, 1715.0f ); // Hack Coffeine
	AddBondParm("CW", "C",  1.433f, 1715.0f ); // Hack Coffeine
	AddBondParm("CT", "HC", 1.090f, 1413.0f );
	AddBondParm("P",  "F",  1.600f,  795.0f );
	AddBondParm("B",  "F",  1.389f, 1113.0f );

	// Amber (parm99.dat)
	AddBondParm("C",  "O1", 1.150f, 1744.7f );
	AddBondParm("C",  "CT", 1.511f, 1316.3f );
//	AddBondParm("OH", "HO", 0.960f, 1313.8f );
	AddBondParm("N3", "CT", 1.463f, 1410.0f );
	AddBondParm("N3", "H",  1.010f, 1815.9f );
	AddBondParm("CA", "CA", 1.400f, 1965.1f );
	AddBondParm("CA", "HA", 1.080f, 1537.7f );
	AddBondParm("CZ", "CZ", 1.106f, 1514.0f );
	AddBondParm("CZ", "HZ", 1.056f, 1676.0f );
	AddBondParm("OM", "OM", 1.110f,  700.0f );
	AddBondParm("CT", "F",  1.331f, 1536.3f );
	AddBondParm("CT", "S6", 1.774f, 1063.1f );
	AddBondParm("S6", "O",  1.436f, 1165.0f );

	AddBondParm("C",  "N",  1.335f, 1053.0f );
	AddBondParm("C",  "O",  1.119f, 1388.0f );

	// TIP3P Water
	AddBondParm("OH", "HO", 0.9572f, 1882.8f );


	/********************************************/
	/*** Angle parameters                     ***/
	/*** eq. Angle (deg), K (KJ*rad^1/mol)    ***/
	/********************************************/

	// Liu's Force Field
	AddAngleParm("CT", "CT", "CT", 109.5f, 167.0f );
	AddAngleParm("CT", "CT", "H1", 109.5f, 159.0f );
	AddAngleParm("CT", "CT", "HC", 109.5f, 155.0f );
	AddAngleParm("CT", "CT", "NA", 111.1f, 193.0f );
	AddAngleParm("H1", "CT", "H1", 109.5f, 146.0f );
	AddAngleParm("HC", "CT", "HC", 109.5f, 141.0f );
	AddAngleParm("H1", "CT", "NA", 109.5f, 130.0f );
	AddAngleParm("CW", "NA", "CT", 115.7f, 109.0f );
	AddAngleParm("CR", "NA", "CT", 116.3f, 109.0f );
	AddAngleParm("CW", "CW", "NA", 107.1f, 501.0f );
	AddAngleParm("CR", "CW", "NA", 105.1f, 501.0f ); // Hack Coffeine
	AddAngleParm("CW", "CR", "NA", 111.9f, 501.0f ); // Hack Coffeine
	AddAngleParm("C",  "CW", "NA", 130.5f, 501.0f ); // Hack Coffeine
	AddAngleParm("N",  "CR", "NA", 116.9f, 501.0f ); // Hack Coffeine
	AddAngleParm("CR", "CW", "C",  114.4f, 501.0f ); // Hack Coffeine
	AddAngleParm("CW", "CR", "N",  111.3f, 501.0f ); // Hack Coffeine
	AddAngleParm("CR", "NA", "CW", 108.0f, 501.0f );
	AddAngleParm("CR", "NA", "CR", 103.7f, 501.0f ); // Hack Coffeine
	AddAngleParm("CW", "C",  "N",  110.9f, 501.0f ); // Hack Coffeine
	AddAngleParm("CW", "C",  "O",  116.5f, 501.0f ); // Hack Coffeine
	AddAngleParm("N",  "C",  "O",  111.6f, 501.0f ); // Hack Coffeine
	AddAngleParm("C",  "N",  "C",  116.8f, 501.0f ); // Hack Coffeine
	AddAngleParm("C",  "N",  "CT", 116.5f, 501.0f ); // Hack Coffeine
	AddAngleParm("N",  "C",  "N",  116.6f, 501.0f ); // Hack Coffeine
	AddAngleParm("CR", "N",  "C",  110.0f, 501.0f ); // Hack Coffeine
	AddAngleParm("CR", "N",  "CT", 111.0f, 501.0f ); // Hack Coffeine
	AddAngleParm("N",  "CT", "H1", 107.6f, 501.0f ); // Hack Coffeine
	AddAngleParm("NA", "CR", "NA", 109.9f, 501.0f );
	AddAngleParm("H4", "CW", "NA", 111.1f, 116.0f );
	AddAngleParm("H5", "CR", "NA", 115.7f, 116.0f );
	AddAngleParm("CW", "CW", "H4", 130.7f, 116.0f );
	AddAngleParm("F",  "P",  "F",   90.0f, 335.0f );
	AddAngleParm("F",  "B",  "F",  109.5f, 109.0f );

	// Amber (parm99.dat)
	AddAngleParm("O1", "C",  "O1", 116.0f, 334.7f );
	AddAngleParm("CT", "C",  "O1", 110.4f, 334.7f );
	AddAngleParm("C",  "CT", "HC", 109.5f, 109.1f );
//	AddAngleParm("HO", "OH", "HO", 104.5f, 418.4f );
	AddAngleParm("CT", "N3", "CT", 109.5f, 109.1f );
	AddAngleParm("CT", "N3", "H",  109.5f, 109.1f );
	AddAngleParm("H",  "N3", "H",  109.5f, 146.4f );
	AddAngleParm("N3", "CT", "H1", 109.5f, 109.1f );
	AddAngleParm("N3", "CT", "CT", 111.1f, 334.7f );
	AddAngleParm("CA", "CA", "CA", 110.0f, 164.0f );
	AddAngleParm("CA", "CA", "HA", 110.0f, 109.5f );
	AddAngleParm("CZ", "CZ", "HZ", 180.0f, 109.5f );
	AddAngleParm("F",  "CT", "F",  109.1f, 311.3f );
	AddAngleParm("F",  "CT", "S6", 109.7f, 340.0f );
	AddAngleParm("O",  "S6", "O",  119.7f, 195.3f );
	AddAngleParm("CT", "S6", "O",  108.3f, 174.4f );

	// TIP3P Water
	AddAngleParm("HO", "OH", "HO", 104.52f, 230.0f );


	/**********************************************/
	/*** Dihedral parameters                    ***/
	/*** eq. Dihedral (deg), N, K/1 (KJ/mol)    ***/
	/**********************************************/

	// Liu's Force Field
	AddDihedralParm("NA", "CR", "NA", "CW",   0.0f, 1, 50.110f );
	AddDihedralParm("NA", "CR", "NA", "CT", 180.0f, 1,  8.368f );
	AddDihedralParm("H5", "CR", "NA", "CW", 180.0f, 1,  6.176f );
	AddDihedralParm("H5", "CR", "NA", "CT",   0.0f, 1,  6.176f );
	AddDihedralParm("CW", "CW", "NA", "CR",   0.0f, 1, 50.110f );
	AddDihedralParm("CW", "CW", "NA", "CT", 180.0f, 1,  8.368f );
	AddDihedralParm("H4", "CW", "NA", "CR", 180.0f, 1,  8.368f );
	AddDihedralParm("H4", "CW", "NA", "CT",   0.0f, 1,  6.176f );
	AddDihedralParm("NA", "CW", "CW", "H4", 180.0f, 1,  6.176f );
	AddDihedralParm("NA", "CW", "CW", "NA",   0.0f, 1, 50.110f );
	AddDihedralParm("H4", "CW", "CW", "H4",   0.0f, 1,  6.176f );
	AddDihedralParm("CT", "CT", "CT", "H1", 180.0f, 3,  0.669f );
	AddDihedralParm("CT", "CT", "CT", "CT", 180.0f, 3,  1.046f );
	AddDihedralParm("CT", "CT", "CT", "HC", 180.0f, 3,  0.669f );
	AddDihedralParm("NA", "CT", "CT", "CT", 180.0f, 3,  1.046f );
	AddDihedralParm("NA", "CT", "CT", "HC", 180.0f, 3,  0.669f );
	AddDihedralParm("H1", "CT", "CT", "HC", 180.0f, 3,  0.618f );
	AddDihedralParm("HC", "CT", "CT", "HC", 180.0f, 3,  0.618f );
	AddDihedralParm("H1", "CT", "NA", "CW", 180.0f, 3,  1.011f );
	AddDihedralParm("H1", "CT", "NA", "CR", 180.0f, 3,  0.686f );
	AddDihedralParm("CT", "CT", "NA", "CW",   0.0f, 1,  0.745f );
	AddDihedralParm("CT", "CT", "NA", "CR",   0.0f, 1,  0.987f );

	// Amber (parm99.dat)
	AddDihedralParm("HC", "CT", "C",  "O1", 180.0f, 3,  3.347f );
	AddDihedralParm("N3", "CT", "CT", "HC", 180.0f, 3,  0.618f );
	AddDihedralParm("N3", "CT", "CT", "H1", 180.0f, 3,  0.618f );
	AddDihedralParm("N3", "CT", "CT", "CT", 180.0f, 3,  0.618f );
	AddDihedralParm("CT", "N3", "CT", "CT", 180.0f, 3,  0.618f );
	AddDihedralParm("H1", "CT", "N3", "H",  180.0f, 3,  0.618f );
	AddDihedralParm("CT", "CT", "N3", "H",  180.0f, 3,  0.618f );

	AddDihedralParm("CA", "CA", "CA", "CA",   0.0f, 1,  1.155f );
	AddDihedralParm("HA", "CA", "CA", "HA",   0.0f, 1,  11.55f );
	AddDihedralParm("HA", "CA", "CA", "CA", 180.0f, 1,  115.5f );

	AddDihedralParm("O",  "S6", "CT", "F",  180.0f, 3,  5.441f );

	// Coffeine
	AddDihedralParm("CR", "NA", "CW", "CR",   0.0f, 1, 80.0f );
	AddDihedralParm("CR", "NA", "CW", "C",  180.0f, 1, 80.0f );
	AddDihedralParm("CR", "NA", "CR", "CW",   0.0f, 1, 80.0f );
	AddDihedralParm("CR", "NA", "CR", "N",  180.0f, 1, 80.0f );
	AddDihedralParm("NA", "CW", "CR", "NA",   0.0f, 1, 80.0f );
	AddDihedralParm("NA", "CW", "CR", "N",  180.0f, 1, 80.0f );
	AddDihedralParm("NA", "CW", "C",  "N",  180.0f, 1, 80.0f );
	AddDihedralParm("NA", "CW", "C",  "O",    0.0f, 1, 80.0f );
	AddDihedralParm("NA", "CR", "NA", "CR",   0.0f, 1, 80.0f );
	AddDihedralParm("CW", "CR", "N",  "C",    0.0f, 1, 80.0f );
	AddDihedralParm("CW", "CR", "N",  "CT", 180.0f, 1, 80.0f );
	AddDihedralParm("CW", "C",  "N",  "C",    0.0f, 1, 80.0f );
	AddDihedralParm("CW", "C",  "N",  "CT", 180.0f, 1, 80.0f );
	AddDihedralParm("CR", "CW", "NA", "CT", 180.0f, 1, 80.0f );
	AddDihedralParm("CR", "CW", "C",  "N",    0.0f, 1, 80.0f );
	AddDihedralParm("CR", "CW", "C",  "O",  180.0f, 1, 80.0f );
	AddDihedralParm("CR", "NA", "CR", "H5", 180.0f, 1, 80.0f );
	AddDihedralParm("CR", "N",  "C",  "N",    0.0f, 1, 80.0f );
	AddDihedralParm("CR", "N",  "C",  "O",  180.0f, 1, 80.0f );
	AddDihedralParm("CR", "N",  "CT", "H1", 180.0f, 3,  0.6f );
	AddDihedralParm("NA", "CR", "CW", "C",  180.0f, 1, 80.0f );
	AddDihedralParm("NA", "CR", "N",  "C",  180.0f, 1, 80.0f );
	AddDihedralParm("NA", "CR", "N",  "CT",   0.0f, 1, 80.0f );
	AddDihedralParm("C",  "CW", "NA", "CT",   0.0f, 1, 80.0f );
	AddDihedralParm("C",  "CW", "CR", "N",    0.0f, 1, 80.0f );
	AddDihedralParm("C",  "N",  "C",  "N",    0.0f, 1, 80.0f );
	AddDihedralParm("C",  "N",  "C",  "O",  180.0f, 1, 80.0f );
	AddDihedralParm("C",  "N",  "CT", "H1",   0.0f, 3,  0.6f );
	AddDihedralParm("N",  "C",  "N",  "CT", 180.0f, 1, 80.0f );
	AddDihedralParm("CT", "N",  "C",  "O",    0.0f, 1, 80.0f );

	/**********************************************/
	/*** Improper parameters                    ***/
	/*** eq. Dihedral (deg), N, K/1 (KJ/mol)    ***/
	/**********************************************/

	// Liu's Force Field
	AddImproperParm("NA", "NA", "CR", "H5", 180.0f, 1,  4.601f );
	AddImproperParm("CW", "NA", "CW", "H4", 180.0f, 1,  4.601f );
	AddImproperParm("CR", "CW", "NA", "CT", 180.0f, 1,  8.368f );

	// Amber (parm99.dat)
	AddImproperParm("CT", "O1", "C",  "O1", 180.0f, 1, 43.900f );
	AddImproperParm("CA", "CA", "CA", "HA", 180.0f, 1,  10.0f );

	// Coffeine
	AddImproperParm("CW", "CR", "NA", "CT", 180.0f, 1,  50.0f );
	AddImproperParm("NA", "CR", "CW", "C",  180.0f, 1,  50.0f );
	AddImproperParm("CW", "NA", "CR", "N",  180.0f, 1,  50.0f );
	AddImproperParm("CW", "N",  "C",  "O",  180.0f, 1,  50.0f );
	AddImproperParm("C",  "C",  "N",  "CT", 180.0f, 1,  50.0f );
	AddImproperParm("N",  "N",  "C",  "O",  180.0f, 1,  50.0f );
	AddImproperParm("CR", "C",  "N",  "CT", 180.0f, 1,  50.0f );
}


