'\"
'\" Copyright (c) 2022 Marc Culler
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH nsimage n 9.0 Tk "Tk Built-In Commands"
.so man.macros
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
nsimage \- A Tk image type for macOS based on the NSImage class.
.BE
.SH DESCRIPTION
The nsimage is implemented as a Tk image type.  The \fBimage\fR
command is used to create, delete, and query all images, including
images of type \fBnsimage\fR.  The options that are available are
specific to the nsimage type and are described below.
.PP
The command to create an \fBnsimage\fR:
.TP
\fBimage create nsimage \fR?\fIname\fR? ?\fIoption value ...\fR?
.PP
creates a new nsimage and a command with the same name and returns its
name.
.SH OPTIONS
.PP
Valid \fIoptions\fR are:
.\" OPTION: -source
.TP
\fB\-source\fI string\fR
.PP
The value of the \fB\-source\fR option is a string describing an
NSimage.  There are several ways to interpret this string, and the
interpretation is determined by the value of the \fB\-as\fR option.
This option is required.
.PP
.\" OPTION: -as
.TP
\fB\-as\fI type\fR
.PP
There are four possible values for the \fB\-as\fR option which specify
how the source string should be interpreted.  The allowed values and
their meanings are:
.RS
.IP \fBname\fR
The source should be interpreted as the name of a named NSImage
provided by the system.
This is the default if the \fB\-as\fR option is not specified.
.IP \fBfile\fR
The source should be interpreted as a path to an image
file in one of the formats understood by the NSImage class.
.IP \fBpath\fR
The source should be interpreted as a path to an arbitrary
file. The type of the file will be examined and the resulting image
will be the system icon for files of that type.
.IP \fBfiletype\fR
The source is interpreted as a string identifying a
particular file type.  It may be a filename extension, an Apple Uniform Type
Identifier or a 4-character OSType value as used in the HFS filesystem.
.RE
.\" OPTION: -width
.TP
\fB\-width\fI pixels\fR
.PP
The value of the \fIwidth\fR option is an integer specifying the width
in pixels of the nsimage.  If the width is not specified it will be
computed from the height so as to preserve the aspect ration.  If
neither width nor height are specified then the width and height of
the underlying NSImage will be used.
.\" OPTION: -height
.TP
\fB\-height\fI pixels\fR
.PP
The value of the \fIheight\fR option is an integer specifying the
height in pixels of the nsimage. If the height is not specified it
will be computed from the height so as to preserve the aspect ration.
If neither width nor height are specified then the width and height of
the underlying NSImage will be used.
.\" OPTION: -radius
.TP
\fB\-radius\fI pixels\fR
.PP
The value of the \fIradius\fR option is an integer.  If non-zero the
image will be clipped to a rounded rectangle with the same width and
height as the image, but with circular arcs of the specified radius
cutting off the corners of the rectangle.
.\" OPTION: -ring
.TP
\fB\-ring\fI pixels\fR
.PP
The value of the \fIring\fR option is an integer.  If non-zero then it
specifies the thickness of a focus ring which will be drawn around the
image using the control accent color specified in the System
Preferences.  The image is resized to reduce its width and height by
twice the thickness of the ring.  Note that this may create a small
amount of distortion.  The aspect ration of a non-square image will
change slightly.
.\" OPTION: -alpha
.TP
\fB\-alpha\fI float\fR
.PP
The value of the \fIalpha\fR option should be a floating point number
between 0.0 and 1.0.  This alpha value will be applied to each pixel
of the nsimage, producing a partially transparent image.  The default value
is 1.0, which makes the image opaque.
.\" OPTION: -pressed
.TP
\fB\-pressed\fI boolean\fR
.PP
The \fIpressed\fR option takes a boolean value.  If the value is true
or 1 then the image will be algorithmically modified to become darker
in light mode or lighter in dark mode.  The default is false.  For an
image button, the primary image should use the value false while the
pressed image should be the same image but with the \fIpressed\fR
option set to true.
.\" OPTION: -template
.TP
\fB\-template\fI boolean\fR
.PP
The \fItemplate\fR option takes a boolean value.  If the value is true
or 1 then the image will be marked as being a template image.  This
means that the system will algorithmically convert the image to a
light colored image when in dark mode.  For the algorithm to work
correctly the image must consist only of black pixels with alpha
values.
.SH "SEE ALSO"
image(n), options(n), photo(n)
.SH KEYWORDS
height, image, types of images, width
'\" Local Variables:
'\" mode: nroff
'\" End:
