/*
Copyright (c) 2006-2009, Tom Thielicke IT Solutions

SPDX-License-Identifier: GPL-2.0-only
*/

/****************************************************************
**
** Definition of the CharTableSql class
** File name: chartablesql.h
**
****************************************************************/

#include <QHeaderView>
#include <QModelIndex>
#include <QPushButton>
#include <QSqlQueryModel>
#include <QString>
#include <QVariant>
#include <QWidget>

#ifndef CHARSQLMODEL_H
#define CHARSQLMODEL_H

//! The CharSqlModel class provides a table model to format cells.
/*!
        @author Tom Thielicke, s712715
        @version 0.1.9
        @date 21.06.2006
*/
class CharSqlModel : public QSqlQueryModel {
    Q_OBJECT

public:
    CharSqlModel(QWidget* parent = 0);

    QVariant data(const QModelIndex& index, int role) const;
    QWidget* parentWidget;
};

#endif // CHARSQLMODEL_H

#ifndef CHARTABLESQL_H
#define CHARTABLESQL_H

//! The CharTableSql class provides a table widget with all typed chars.
/*!
        @author Tom Thielicke, s712715
        @version 0.1.0
        @date 21.06.2006
*/
class CharTableSql : public QWidget {
    Q_OBJECT

public:
    CharTableSql(QWidget* parent = 0);

private slots:
    void sortColumn(int columnindex);
    void deleteUserChars();

private:
    CharSqlModel* model;
    QHeaderView* headerview;
    QVariant data(const QModelIndex& item, int role) const;
    void setQueryOrder(QString columnname, bool isdesc);
    int previousColumnIndex;
    QPushButton* buttonReset;
    QString sql;
};

#endif // CHARTABLESQL_H
