/**
 * Copyright (C) 2007-2015 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#include "SplashImage.hpp"

#include "../meta.hpp"
#include "../images/indii.hpp"
#include "../image/ColourSpace.hpp"

#include "wx/dcbuffer.h"
#include "wx/dcgraph.h"

using namespace indii;

SplashImage::SplashImage(wxWindow* parent) :
    wxPanel(parent) {
  indii_scale_images(this->GetContentScaleFactor());
  SetInitialSize(_img_indii_splash_32->GetSize());
}

void SplashImage::OnPaint(wxPaintEvent& evt) {
  wxPaintDC base(this);
  #if wxUSE_GRAPHICS_CONTEXT
  wxGCDC dc(base);
  #else
  wxPaintDC& dc = base;
  #endif
  
  /* splash image */
  dc.DrawBitmap(*_img_indii_splash, 0, 0);
  
  /* title */
  wxCoord w1, h1, w2, h2, w3, h3, descent, externalLeading;
  wxColour fg(*wxWHITE);
  wxColour bg(0, 0, 0, 100);
  
  dc.SetPen(wxNullPen);
  dc.SetBrush(bg);
  dc.SetTextForeground(fg);
  dc.SetTextBackground(bg);

  wxString name(_(PACKAGE_NAME));
  wxString version(wxString::Format(_("version %s"), PACKAGE_VERSION));
  wxString author(_("by indii.org / Lawrence Murray"));
  
  int PADDING = 8;
  int width = _img_indii_splash_32->GetWidth();
  int height = _img_indii_splash_32->GetHeight();
  
  dc.SetFont(wxNORMAL_FONT->Scaled(2.0).Bold());
  dc.GetTextExtent(name, &w1, &h1, &descent, &externalLeading);
  dc.SetFont(*wxSMALL_FONT);
  dc.GetTextExtent(version, &w2, &h2, &descent, &externalLeading);
  dc.GetTextExtent(version, &w3, &h3, &descent, &externalLeading);
  
  dc.DrawRectangle(0, height - h1 - h2 - 3*PADDING, width, h1 + h2 + 4*PADDING);

  dc.SetFont(wxNORMAL_FONT->Scaled(2.0).Bold());
  dc.DrawText(name, PADDING, height - h1 - h2 - 2*PADDING);

  dc.SetFont(*wxSMALL_FONT);
  dc.SetTextForeground(wxColour(180, 180, 180));
  dc.DrawText(author, PADDING, height - h3 - PADDING);
  dc.DrawText(version, width - w2 - PADDING, height - h2 - PADDING);
}

BEGIN_EVENT_TABLE(SplashImage, wxWindow)
EVT_PAINT(SplashImage::OnPaint)
END_EVENT_TABLE()
