# SPDX-License-Identifier: GPL-3.0-only

[suite tfortune]
mansect = 6
manual_title = Games Manual
caption = Subcommands
[supercommand tfortune]
	purpose = SLOGAN()
	[description]
		DESCRIPTION1()

		DESCRIPTION2()

		DESCRIPTION3()
	[/description]
	synopsis = [global-options...] [--] [<subcommand> [subcommand-options...]]
	[option help]
		summary = print help and exit
		short_opt = h
	[option detailed-help]
		summary = print help, including all details, and exit
	[option version]
		summary = print version and exit
		short_opt = V
	[option loglevel]
		summary = control amount of logging
		short_opt = l
		arg_info = required_arg
		arg_type = string
		typestr = severity
		values = {
			LSGLL_DEBUG = "debug",
			LSGLL_INFO = "info",
			LSGLL_NOTICE = "notice",
			LSGLL_WARNING = "warning",
			LSGLL_ERROR = "error",
			LSGLL_CRIT = "crit",
			LSGLL_EMERG = "emerg"
		}
		default_val = warning
		[help]
			Log only messages with severity greater or equal than the given
			value. Possible values:

			debug: Produces really noisy output.
			info: Still noisy, but won't fill up the disk quickly.
			notice: Indicates normal, but significant event.
			warning: Unexpected events that can be handled.
			error: Unhandled error condition.
			crit: System might be unreliable.
			emerg: Last message before exit.
		[/help]
	[option basedir]
		summary = where to look for input files
		short_opt = b
		arg_info = required_arg
		arg_type = string
		typestr = directory
		default_val = "~/.tfortune"
		[help]
			This is used to locate epigrams and named tag expressions.
			If any filename argument does not start with a slash, the
			filename is interpreted as relative to this base directory.

			Epigrams are expected in the "epigrams" subdirectory of the base
			directory while tag expressions are expected to be stored below
			"expressions".

			If the option is not given, and the per-user epigram directory does
			not exist, the system-wide default DATADIR() is tried. There is no
			such fallback for tag expressions, though.
		[/help]

[subcommand compgen]
	purpose = perform bash command line completion
	non-opts-name = arg...
	[description]
		This subcommand is executed from the bash completer for tfortune. The
		completer sets the non-option arguments for the subcommand to the
		words of the current command line. It obtains these words from the
		elements of the special COMP_WORDS array which is maintained by bash.

		The compgen subcommand writes all possible completions to stdout. The
		completer reads in the completions and builds the COMPREPLY array
		containing the matching entries. Bash examines the elements of this
		array and completes the command line if there is a single matching
		completion, or prints out the list of completions in case of ambiguity.

	[/description]
	[option current-word-index]
		short_opt = c
		summary = index of the current word in the command line
		typestr = num
		arg_info = required_arg
		arg_type = uint32
		[help]
			An index into the argument vector of the word containing the current
			cursor position. See the description of the $CWORD special variable
			in the bash manual.
		[/help]

[subcommand completer]
	purpose = print the bash completer to stdout
	[description]
		The output of this command is designed to be re-used as input for bash.
		Specifically, bash completion for tfortune can be activated by adding
		the following to .bashrc: eval "$(tfortune completer)".
	[/description]
	[option alias]
		summary = also add an alias and a completer for it
		short_opt = a
		arg_info = required_arg
		arg_type = string
		typestr = name
		[help]
			Specify this to define a bash alias for tfortune along with the
			completer. Unlike the regular tfortune program, the alias will
			contain the double dash argument which separates the subcommand and
			its options from the options to tfortune itself.
		[/help]

[subcommand ede]
	purpose = edit epigrams
	non-opts-name = basename...
	[description]
		Opens the named epigram file an interactive editor. The executable
		of the editor is determined as follows: First the contents of the
		environment variable TFORTUNE_EDITOR is examined. If this variable
		is empty or unset, EDITOR is tried. If EDITOR is also unset, vi
		is executed.

		The given basename is interpreted as described in the help text of the
		--basedir option above. If --basedir is not given and the "epigrams"
		directory does not exist, it is created.
	[/description]

[subcommand edx]
	purpose = edit tag expressions
	non-opts-name = basename...
	[description]
		Opens the named tag expression file an interactive editor. The editor
		to execute is determined in the same way as for the "ede" subcommand.
		Also, a non-existing "expressions" subdirectory is handled in the same
		way.
	[/description]
[subcommand help]
	purpose = list available subcommands or print command-specific help
	non-opts-name = [command]
	[description]
		Without any arguments, help prints the list of available commands. When
		called with a command name argument, it prints the help text of the
		given command.
	[/description]
	[option long]
		short_opt = l
		summary = show the long help text
	[help]
		If the optional argument is supplied, the long help text contains the
		synopsis, the purpose and the description of the specified command,
		followed by the option list including summary and help text of each
		option. Without --long, the short help is shown instead. This omits
		the description of the command and the option help.

		If no command is supplied but --long is given, the list contains the
		purpose of each command.
	[/help]

[subcommand lse]
	purpose = list epigram files
	[description]
		Print the list of all epigram files.
	[/description]
	[option long]
		short_opt = l
		summary = long listing
		[help]
			This is similar to the long output of the standard ls(1) command.
		[/help]

[subcommand lst]
	purpose = list tags
	[description]
		This lists all tags contained in any of the given input files.
	[/description]
	non-opts-name = <file>...
	[option long]
		short_opt = l
		summary = long listing
		[help]
			Also show how many times this tag appears.
		[/help]
	[option sort-by-count]
		short_opt = c
		summary = sort by occurrence count rather than alphabetically.
	[option reverse]
		short_opt = r
		summary = reverse sort order

[subcommand lsx]
	purpose = list tag expressions
	[description]
		Print the list of all named tag expressions.
	[/description]
	[option long]
		short_opt = l
		summary = long listing
		[help]
			This is similar to the long output of the standard ls(1) command.
		[/help]
[subcommand print]
	purpose = print epigram(s)
	[description]
		Unless --all is given, this picks an epigram by random from the
		given file(s) which is admissible with respect to the given named
		tag expression. If no file is given, all files are taken into account.
	[/description]
	non-opts-name = [file...]
	[option expression]
		short_opt = x
		summary = name of the tag expression
		arg_info = required_arg
		arg_type = string
		typestr = filename
		default_val = /dev/null
		[help]
			Use the tag expression stored in the given file to define the
			admissible epigrams. The special string "-" means to read the tag
			expression from stdin. The default value corresponds to the empty
			tag expression for which all epigrams are admissible.
		[/help]
	[option all]
		short_opt = a
		summary = print all admissible epigrams, not just a random one.
	[option tags]
		short_opt = t
		summary = print also the tags of the selected epigram
[subcommand stats]
	purpose = show statistics
	[description]
		This prints several counts and averages about the epigrams, tags and
		tag expressions.
	[/description]
	[option verbose]
		short_opt = v
		summary = include statistics about hash table utilization

[section Input file format]
	Input files may contain arbitrary many epigrams. The end of each
	epigram must be marked with a "tag" line. The tag line consists of
	four dashes, a space character, and a comma separated list of tags.
	Tags may span multiple words, but no comma is allowed. The following
	is an example input file for tfortune. It contains a single epigram
	with two tags.

	.RS
	.EX
	Anyone who attempts to generate random numbers by deterministic means
	is, of course, living in a state of sin.          -- John von Neumann
	---- math,religion
	.EE
	.RE
[/section]

[section Tag Expressions]
	Tag expressions are based on a context-free grammar in which the
	following keywords are defined:
	.IP \(bu 4
	.B tag("foo")
	evaluates to
	.I true
	if the epigram contains a tag named
	.IR foo ,
	.I false
	otherwise.
	.IP \(bu 4
	.B len
	evaluates to the number of bytes of the epigram.
	.IP \(bu 4
	.B text
	evaluates to contents of the epigram. This is useful for pattern
	matching.
	.P

	The grammar admits the following operators and relations:
	.IP \(bu 4
	.BR && ,
	.BR || ,
	.BR !:
	logical operators for
	.IR and ,
	.IR or ,
	and
	.IR not .
	.IP \(bu 4
	.BR + ,
	.BR - ,
	.BR * ,
	.BR + :
	arithmetic operators for addition, negation or subtraction (unary
	or binary minus), multiplication and division. Arithmetic is always
	performed on 64 bit signed integers.
	.IP \(bu 4
	.BR < ,
	.BR > ,
	.BR <=,
	.BR >=,
	.BR ==,
	.BR != :
	.BR =~ :
	less than, greater than, less or equal than, greater or equal than,
	equal to, not equal to, regular expression match.
	Regular expression patterns are of the form
	.IR /pattern/[flags] .
	That is, the pattern is delimited by slashes, and is followed by
	zero or more characters, each specifying a flag according to the
	following list
	.RS
	.IP \(bu 4
	.BR i :
	Ignore case in match
	.RI ( REG_ICASE )
	.IP \(bu 4
	.BR n :
	Treat newline as an ordinary character
	.RI ( REG_NEWLINE )

	.RE
	.RS
	Note that only extended regular expression patterns are supported. See
	regex(3) for details.
	.RE

	The above operators obey the usual associativity and precedence
	rules. Parentheses can be used to change precedence.

	A
	.I tag expression
	is an expression in this grammar which evaluates to either
	.I true
	or
	.IR false .
	Epigrams for which the expression is
	.I true
	are called
	.IR admissible .

	For example, the above epigram is admissible for the tag expression

	.RS
	.EX
		(tag("math") || tag("physics")) && len < 1000 && text =~ /neumann/i
	.EE
	.RE

	It is not admissible for

	.RS
	.EX
		(tag("math") && tag("physics")) || len > 1000 || text =~ /neumann/
	.EE
	.RE
[/section]

[section Examples]
	.IP \(bu 2
	Print a random epigram:

	.RS 6
	.EX
		tfortune print
	.EE
	.RE
	.IP \(bu 2
	Print a random short (less than 100 bytes) epigram:

	.RS 6
	.EX
		echo 'len < 100' | tfortune -l debug -- print -x -
	.EE
	.RE
	.IP \(bu 2
	List tags, including usage counts, sort by count in descending order:

	.RS 6
	.EX
		tfortune -- lst -lcr
	.EE
	.RE
	.IP \(bu 2
	Activate bash completion and define the
	.I tf
	alias:

	.RS 6
	.EX
	eval "$(tfortune completer -a tf)"
	.EE
	.RE

[/section]

[section copyright]
	Written by AUTHOR()
	.br
	Copyright (C) COPYRIGHT_YEAR() AUTHOR()
	.br
	License: LICENSE()
	.br
	This is free software: you are free to change and redistribute it.
	.br
	There is NO WARRANTY, to the extent permitted by law.
	.P
	Web page:
	.UR PACKAGE_HOMEPAGE()
	.UE
	.br
	Git clone URL:
	.UR CLONE_URL()
	.UE
	.br
	Gitweb:
	.UR GITWEB_URL()
	.UE
	.br
	Author's home page:
	.UR HOME_URL()
	.UE
	.br
	Report bugs to
	.MT EMAIL()
	AUTHOR()
	.ME
[/section]
[section see also]
	.BR fortune (6)
[/section]
