/*
 * winstub.h - MS-Windows compatiblity hacks
 * $Id: winstub.h 172 2005-06-16 20:08:53Z rdenisc $
 */

/***********************************************************************
 *  Copyright (C) 2002-2004 Remi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Public License  *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifndef __RDC_WINSTUB_H
# define __RDC_WINSTUB_H

/* gai functions do not link properly with my version of Mingw */

# include <winsock2.h> /* struct sockaddr & all the predefined constants */
# include <ws2tcpip.h> /* struct sockaddr_in and the like */
# include <io.h> /* prevents close() name mangling */
# include <stdint.h>

#ifndef HAVE_GAI_STRERROR
# undef gai_strerror // broken on my Mingw32
#endif

/* <ws2tcpip.h> breaks RFC2553 by not defining EAI_SYSTEM.
 * Give it a bogus value that should never happen in getaddrinfo(). */
# ifndef EAI_SYSTEM
#  define EAI_SYSTEM WSAEINPROGRESS
# endif

/* Winsock does not define these constants */
# ifndef SHUT_RD
#  define SHUT_RD	SD_RECEIVE
#  define SHUT_WR	SD_SEND
#  define SHUT_RDWR	SD_BOTH
# endif

# ifndef EINPROGRESS
#  define EINPROGRESS	WSAEINPROGRESS
#endif

# define main winstub_main

# ifdef __cplusplus
extern "C"
{
# endif
	void winsock_perror (const char *str);
# define perror winsock_perror

	const char *winsock_strerror (int errnum);
# define strerror winsock_strerror

	int winsock_close (int fd);
# define close winsock_close

	size_t winsock_recvfrom (int fd, void *buf, size_t len, int flags,
				 struct sockaddr *addr, socklen_t *alen);
# define recvfrom winsock_recvfrom

	size_t winsock_sendto (int fd, const void *buf, size_t len, int flags,
				const struct sockaddr *addr, socklen_t alen);
# define sendto winsock_sendto
	
	size_t winsock_read (int fd, void *buf, size_t len);
# define read winsock_read

	size_t winsock_write (int fd, const void *buf, size_t len);
# define write winsock_write

	size_t winsock_recv (int fd, void *buf, size_t len, int flags);
# define recv winsock_recv

	size_t winsock_send (int fd, const void *buf, size_t len, int flags);
# define send winsock_send

	int winsock_socket (int pf, int type, int proto);
# define socket winsock_socket

	int winsock_bind (int fd, struct sockaddr *addr, socklen_t addrlen);
# define bind winsock_bind

	int winsock_listen (int fd, int max);
# define listen winsock_listen

	int winsock_accept (int fd, struct sockaddr *addr, socklen_t *len);
# define accept winsock_accept

	int winsock_connect (int fd, struct sockaddr *addr, socklen_t len);
# define connect winsock_connect

	int winsock_shutdown (int fd, int how);
# define shutdown winsock_shutdown

	int winsock_setsockopt (int fd, int lvl, int opt, const void *data,
				socklen_t len);
# define setsockopt winsock_setsockopt

	int winsock_getsockopt (int fd, int lvl, int opt, void *data,
				socklen_t *len);
# define getsockopt winsock_getsockopt

	struct hostent *winsock_gethostbyaddr (const char *addr, int len,
						int type);
# define gethostbyaddr winsock_gethostbyaddr

	struct hostent *winsock_gethostbyname (const char *name);
# define gethostbyname winsock_gethostbyname

	int winsock_getpeername (int fd, struct sockaddr *addr,
					socklen_t *len);
# define getpeername winsock_getpeername

	int winsock_getsockname (int fd, struct sockaddr *addr,
					socklen_t *len);
# define getsockname winsock_getsockname

	char *winsock_inet_ntoa (struct in_addr in);
# define inet_ntoa winsock_inet_ntoa

	unsigned long winsock_inet_addr (const char *dotip);
# define inet_addr winsock_inet_addr

	struct servent *winsock_getservbyport (int port, const char *proto);
# define getservbyport winsock_getservbyport

	struct servent *winsock_getservbyname (const char *name,
						const char *proto);
# define getservbyname winsock_getservbyname

	uint16_t winsock_ntohs (uint16_t s);
# define ntohs winsock_ntohs

	uint16_t winsock_htons (uint16_t s);
# define htons winsock_htons

	uint32_t winsock_ntohl (uint32_t l);
# define ntohl winsock_ntohl

	uint32_t winsock_htonl (uint32_t l);
# define htonl winsock_htonl

	int winsock_getaddrinfo (const char *node, const char *service,
	                         const struct addrinfo *hints,
	                         struct addrinfo **res);
# define getaddrinfo winsock_getaddrinfo

	void winsock_freeaddrinfo (struct addrinfo *infos);
# define freeaddrinfo winsock_freeaddrinfo

	int winsock_getnameinfo (const struct sockaddr *sa, int salen, char *host,
	                         int hostlen, char *serv, int servlen, int flags);
# define getnameinfo winsock_getnameinfo

/*
 * POSIX functions which do not exists on Windows
 */
	unsigned int sleep (unsigned int s);
	int setuid (uid_t uid);
	int seteuid (uid_t uid);
	uid_t getuid (void);
	uid_t geteuid (void);

	struct passwd
	{
		uid_t pw_uid;
	};
	struct passwd *getpwnam (const char *username);
	struct passwd *getpwuid (uid_t uid);

	void openlog (const char *ident, int option, int facility);
	void syslog (int priority, const char *fmt, ...);
	void closelog (void);

# define LOG_CONS	0x02
# define LOG_NDELAY	0x08
# define LOG_NOWAIT	0x10
# define LOG_ODELAY	0x04
# define LOG_PERROR	0x20
# define LOG_PID	0x01

# define LOG_AUTH	0040
# define LOG_AUTHPRIV	0120
# define LOG_CRON	0110
# define LOG_DAEMON	0030
# define LOG_FTP	0130
# define LOG_LOCAL0	0200
# define LOG_LOCAL1	0210
# define LOG_LOCAL2	0220
# define LOG_LOCAL3	0230
# define LOG_LOCAL4	0240
# define LOG_LOCAL5	0250
# define LOG_LOCAL6	0260
# define LOG_LOCAL7	0270
# define LOG_LPR	0060
# define LOG_MAIL	0020
# define LOG_NEWS	0070
# define LOG_SYSLOG	0050
# define LOG_USER	0010
# define LOG_UUCP	0100

# define LOG_EMERG	0
# define LOG_ALERT	1
# define LOG_CRIT	2
# define LOG_ERR	3
# define LOG_WARNING	4
# define LOG_NOTICE	5
# define LOG_INFO	6
# define LOG_DEBUG	7

# ifdef __cplusplus
}
# endif
#endif /* not __RDC_WINSTUB_H */
