from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


HelpDict = _Mock()

FileOpen = ' Click this button to open a <em>new file</em>.<br><br>\nYou can also select the <b>Open</b> command from the <b>File</b> menu.'

FilePrint = 'Click this button to print the file you are editing.<br><br>\nYou can also select the <b>Print</b> command from the <b>File</b> menu.'

FileSave = 'Click this button to save the file you are editing.<br><br>\nYou will be prompted for a filename.<br><br>\nYou can also select the <b>Save</b> command from the <b>File</b> menu.'

FullScreen = '<b>Maximize</b> current active window.<br>\nThe window will occupy all application window.\n'

NoFullScreen = 'Redisplay all windows using current window geometry.<br>\nWindow geometry could be:<br>\n<b>Cascade</b>, <b>tile</b>, <b>tile horizontally</b> or <b>vertically</b>\n'

SpecOpen = '<img source="spec">\nClick this button to open a <em>new spec shared array</em>.<br><br>\nYou can also select then <b>Open Spec</b> command from the <b>File</b> menu.'



