/*
 * Copyright (c) 2017, Miroslav Stoyanov
 *
 * This file is part of
 * Toolkit for Adaptive Stochastic Modeling And Non-Intrusive ApproximatioN: TASMANIAN
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions
 *    and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse
 *    or promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * UT-BATTELLE, LLC AND THE UNITED STATES GOVERNMENT MAKE NO REPRESENTATIONS AND DISCLAIM ALL WARRANTIES, BOTH EXPRESSED AND IMPLIED.
 * THERE ARE NO EXPRESS OR IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR THAT THE USE OF THE SOFTWARE WILL NOT INFRINGE ANY PATENT,
 * COPYRIGHT, TRADEMARK, OR OTHER PROPRIETARY RIGHTS, OR THAT THE SOFTWARE WILL ACCOMPLISH THE INTENDED RESULTS OR THAT THE SOFTWARE OR ITS USE WILL NOT RESULT IN INJURY OR DAMAGE.
 * THE USER ASSUMES RESPONSIBILITY FOR ALL LIABILITIES, PENALTIES, FINES, CLAIMS, CAUSES OF ACTION, AND COSTS AND EXPENSES, CAUSED BY, RESULTING FROM OR ARISING OUT OF,
 * IN WHOLE OR IN PART THE USE, STORAGE OR DISPOSAL OF THE SOFTWARE.
 */

#ifndef __TASMANIAN_SPARSE_HARDCODED_RULES_CPP
#define __TASMANIAN_SPARSE_HARDCODED_RULES_CPP

#include "tsgHardCodedTabulatedRules.hpp"

namespace TasGrid{

TableGaussPatterson::TableGaussPatterson(){
    weights_offsets.resize(9);
    weights_offsets[0] = 0;
    for(int l=0; l<8; l++){
        weights_offsets[l+1] = weights_offsets[l] + OneDimensionalMeta::getNumPoints(l, rule_gausspatterson);
    }

    loadNodes();
    loadWeights();
}

std::vector<double> TableGaussPatterson::getNodes(int level) const{
    int num_points = OneDimensionalMeta::getNumPoints(level, rule_gausspatterson);
    std::vector<double> x(nodes.begin(), nodes.begin() + num_points);
    return x;
}

double TableGaussPatterson::getWeight(int level, int point) const{
    return weights[weights_offsets[level] + point];
}

void TableGaussPatterson::loadNodes(){
    nodes = {0.000000000000000000000,
    -0.774596669241483377036,
     0.774596669241483377036,
    -0.960491268708020283423,
    -0.434243749346802558002,
     0.434243749346802558002,
     0.960491268708020283423,
    -0.993831963212755022209,
    -0.888459232872256998890,
    -0.621102946737226402941,
    -0.223386686428966881628,
     0.223386686428966881628,
     0.621102946737226402941,
     0.888459232872256998890,
     0.993831963212755022209,
    -0.999098124967667597662,
    -0.981531149553740106867,
    -0.929654857429740056670,
    -0.836725938168868735503,
    -0.702496206491527078610,
    -0.531319743644375623972,
    -0.331135393257976833093,
    -0.112488943133186625746,
     0.112488943133186625746,
     0.331135393257976833093,
     0.531319743644375623972,
     0.702496206491527078610,
     0.836725938168868735503,
     0.929654857429740056670,
     0.981531149553740106867,
     0.999098124967667597662,
    -0.999872888120357611938,
    -0.997206259372221959076,
    -0.988684757547429479939,
    -0.972182874748581796578,
    -0.946342858373402905148,
    -0.910371156957004292498,
    -0.863907938193690477146,
    -0.806940531950217611856,
    -0.739756044352694758677,
    -0.662909660024780595461,
    -0.577195710052045814844,
    -0.483618026945841027562,
    -0.383359324198730346916,
    -0.277749822021824315065,
    -0.168235251552207464982,
    -0.056344313046592789972,
     0.056344313046592789972,
     0.168235251552207464982,
     0.277749822021824315065,
     0.383359324198730346916,
     0.483618026945841027562,
     0.577195710052045814844,
     0.662909660024780595461,
     0.739756044352694758677,
     0.806940531950217611856,
     0.863907938193690477146,
     0.910371156957004292498,
     0.946342858373402905148,
     0.972182874748581796578,
     0.988684757547429479939,
     0.997206259372221959076,
     0.999872888120357611938,
    -0.999982430354891598580,
    -0.999598799671910683252,
    -0.998316635318407392531,
    -0.995724104698407188509,
    -0.991495721178106132399,
    -0.985371499598520371114,
    -0.977141514639705714156,
    -0.966637851558416567092,
    -0.953730006425761136415,
    -0.938320397779592883655,
    -0.920340025470012420730,
    -0.899744899776940036639,
    -0.876513414484705269742,
    -0.850644494768350279758,
    -0.822156254364980407373,
    -0.791084933799848361435,
    -0.757483966380513637926,
    -0.721423085370098915485,
    -0.682987431091079228087,
    -0.642276642509759513774,
    -0.599403930242242892974,
    -0.554495132631932548866,
    -0.507687757533716602155,
    -0.459130011989832332874,
    -0.408979821229888672409,
    -0.357403837831532152376,
    -0.304576441556714043335,
    -0.250678730303483176613,
    -0.195897502711100153915,
    -0.140424233152560174594,
    -0.0844540400837108837102,
    -0.0281846489497456943394,
     0.0281846489497456943394,
     0.0844540400837108837102,
     0.140424233152560174594,
     0.195897502711100153915,
     0.250678730303483176613,
     0.304576441556714043335,
     0.357403837831532152376,
     0.408979821229888672409,
     0.459130011989832332874,
     0.507687757533716602155,
     0.554495132631932548866,
     0.599403930242242892974,
     0.642276642509759513774,
     0.682987431091079228087,
     0.721423085370098915485,
     0.757483966380513637926,
     0.791084933799848361435,
     0.822156254364980407373,
     0.850644494768350279758,
     0.876513414484705269742,
     0.899744899776940036639,
     0.920340025470012420730,
     0.938320397779592883655,
     0.953730006425761136415,
     0.966637851558416567092,
     0.977141514639705714156,
     0.985371499598520371114,
     0.991495721178106132399,
     0.995724104698407188509,
     0.998316635318407392531,
     0.999598799671910683252,
     0.999982430354891598580,
    -0.999997596379748464620,
    -0.999943996207054375764,
    -0.999760490924432047330,
    -0.999380338025023581928,
    -0.998745614468095114704,
    -0.997805354495957274562,
    -0.996514145914890273849,
    -0.994831502800621000519,
    -0.992721344282788615328,
    -0.990151370400770159181,
    -0.987092527954034067190,
    -0.983518657578632728762,
    -0.979406281670862683806,
    -0.974734459752402667761,
    -0.969484659502459231771,
    -0.963640621569812132521,
    -0.957188216109860962736,
    -0.950115297521294876558,
    -0.942411565191083059813,
    -0.934068436157725787999,
    -0.925078932907075652364,
    -0.915437587155765040644,
    -0.905140358813261595189,
    -0.894184568335559022859,
    -0.882568840247341906842,
    -0.870293055548113905851,
    -0.857358310886232156525,
    -0.843766882672708601038,
    -0.829522194637401400178,
    -0.814628787655137413436,
    -0.799092290960841401800,
    -0.782919394118283016385,
    -0.766117819303760090717,
    -0.748696293616936602823,
    -0.730664521242181261329,
    -0.712033155362252034587,
    -0.692813769779114702895,
    -0.673018830230418479199,
    -0.652661665410017496101,
    -0.631756437711194230414,
    -0.610318113715186400156,
    -0.588362434447662541434,
    -0.565905885423654422623,
    -0.542965666498311490492,
    -0.519559661537457021993,
    -0.495706407918761460170,
    -0.471425065871658876934,
    -0.446735387662028473742,
    -0.421657686626163300056,
    -0.396212806057615939183,
    -0.370422087950078230138,
    -0.344307341599438022777,
    -0.317890812068476683182,
    -0.291195148518246681964,
    -0.264243372410926761945,
    -0.237058845589829727213,
    -0.209665238243181194766,
    -0.182086496759252198246,
    -0.154346811481378108692,
    -0.126470584372301966851,
    -0.0984823965981192020903,
    -0.0704069760428551790633,
    -0.0422691647653636032124,
    -0.0140938864107824626142,
     0.0140938864107824626142,
     0.0422691647653636032124,
     0.0704069760428551790633,
     0.0984823965981192020903,
     0.126470584372301966851,
     0.154346811481378108692,
     0.182086496759252198246,
     0.209665238243181194766,
     0.237058845589829727213,
     0.264243372410926761945,
     0.291195148518246681964,
     0.317890812068476683182,
     0.344307341599438022777,
     0.370422087950078230138,
     0.396212806057615939183,
     0.421657686626163300056,
     0.446735387662028473742,
     0.471425065871658876934,
     0.495706407918761460170,
     0.519559661537457021993,
     0.542965666498311490492,
     0.565905885423654422623,
     0.588362434447662541434,
     0.610318113715186400156,
     0.631756437711194230414,
     0.652661665410017496101,
     0.673018830230418479199,
     0.692813769779114702895,
     0.712033155362252034587,
     0.730664521242181261329,
     0.748696293616936602823,
     0.766117819303760090717,
     0.782919394118283016385,
     0.799092290960841401800,
     0.814628787655137413436,
     0.829522194637401400178,
     0.843766882672708601038,
     0.857358310886232156525,
     0.870293055548113905851,
     0.882568840247341906842,
     0.894184568335559022859,
     0.905140358813261595189,
     0.915437587155765040644,
     0.925078932907075652364,
     0.934068436157725787999,
     0.942411565191083059813,
     0.950115297521294876558,
     0.957188216109860962736,
     0.963640621569812132521,
     0.969484659502459231771,
     0.974734459752402667761,
     0.979406281670862683806,
     0.983518657578632728762,
     0.987092527954034067190,
     0.990151370400770159181,
     0.992721344282788615328,
     0.994831502800621000519,
     0.996514145914890273849,
     0.997805354495957274562,
     0.998745614468095114704,
     0.999380338025023581928,
     0.999760490924432047330,
     0.999943996207054375764,
     0.999997596379748464620,
    -0.999999672956734384381,
    -0.999992298136257588028,
    -0.999966730098486276883,
    -0.999913081144678282800,
    -0.999822363679787739196,
    -0.999686286448317731776,
    -0.999497112467187190535,
    -0.999247618943342473599,
    -0.998931050830810562236,
    -0.998541055697167906027,
    -0.998071634524930323302,
    -0.997517116063472399965,
    -0.996872143485260161299,
    -0.996131662079315037786,
    -0.995290903148810302261,
    -0.994345364356723405931,
    -0.993290788851684966211,
    -0.992123145530863117683,
    -0.990838611958294243677,
    -0.989433560520240838716,
    -0.987904547695124280467,
    -0.986248305913007552681,
    -0.984461737328814534596,
    -0.982541908851080604251,
    -0.980486047876721339416,
    -0.978291538324758539526,
    -0.975955916702011753129,
    -0.973476868052506926773,
    -0.970852221732792443256,
    -0.968079947017759947964,
    -0.965158148579915665979,
    -0.962085061904651475741,
    -0.958859048710200221356,
    -0.955478592438183697574,
    -0.951942293872573589498,
    -0.948248866934137357063,
    -0.944397134685866648591,
    -0.940386025573669721370,
    -0.936214569916450806625,
    -0.931881896650953639345,
    -0.927387230329536696843,
    -0.922729888363349241523,
    -0.917909278499077501636,
    -0.912924896514370590080,
    -0.907776324115058903624,
    -0.902463227016165675048,
    -0.896985353188316590376,
    -0.891342531251319871666,
    -0.885534668997285008926,
    -0.879561752026556262568,
    -0.873423842480859310192,
    -0.867121077859315215614,
    -0.860653669904299969802,
    -0.854021903545468625813,
    -0.847226135891580884381,
    -0.840266795261030442350,
    -0.833144380243172624728,
    -0.825859458783650001088,
    -0.818412667287925807395,
    -0.810804709738146594361,
    -0.803036356819268687782,
    -0.795108445051100526780,
    -0.787021875923539422170,
    -0.778777615032822744702,
    -0.770376691217076824278,
    -0.761820195689839149173,
    -0.753109281170558142523,
    -0.744245161011347082309,
    -0.735229108319491547663,
    -0.726062455075389632685,
    -0.716746591245747095767,
    -0.707282963891961103412,
    -0.697673076273711232906,
    -0.687918486947839325756,
    -0.678020808862644517838,
    -0.667981708447749702165,
    -0.657802904699713735422,
    -0.647486168263572388782,
    -0.637033320510492495071,
    -0.626446232611719746542,
    -0.615726824608992638014,
    -0.604877064481584353319,
    -0.593898967210121954393,
    -0.582794593837318850840,
    -0.571566050525742833992,
    -0.560215487612728441818,
    -0.548745098662529448608,
    -0.537157119515795115982,
    -0.525453827336442687395,
    -0.513637539655988578507,
    -0.501710613415391878251,
    -0.489675444004456155436,
    -0.477534464298829155284,
    -0.465290143694634735858,
    -0.452944987140767283784,
    -0.440501534168875795783,
    -0.427962357921062742583,
    -0.415330064175321663764,
    -0.402607290368737092671,
    -0.389796704618470795479,
    -0.376901004740559344802,
    -0.363922917266549655269,
    -0.350865196458001209011,
    -0.337730623318886219621,
    -0.324522004605921855207,
    -0.311242171836871800300,
    -0.297893980296857823437,
    -0.284480308042725577496,
    -0.271004054905512543536,
    -0.257468141491069790481,
    -0.243875508178893021593,
    -0.230229114119222177156,
    -0.216531936228472628081,
    -0.202786968183064697557,
    -0.188997219411721861059,
    -0.175165714086311475707,
    -0.161295490111305257361,
    -0.147389598111939940054,
    -0.133451100421161601344,
    -0.119483070065440005133,
    -0.105488589749541988533,
    -0.0914707508403553909095,
    -0.0774326523498572825675,
    -0.0633773999173222898797,
    -0.0493081047908686267156,
    -0.0352278828084410232603,
    -0.0211398533783310883350,
    -0.00704713845933674648514,
     0.00704713845933674648514,
     0.0211398533783310883350,
     0.0352278828084410232603,
     0.0493081047908686267156,
     0.0633773999173222898797,
     0.0774326523498572825675,
     0.0914707508403553909095,
     0.105488589749541988533,
     0.119483070065440005133,
     0.133451100421161601344,
     0.147389598111939940054,
     0.161295490111305257361,
     0.175165714086311475707,
     0.188997219411721861059,
     0.202786968183064697557,
     0.216531936228472628081,
     0.230229114119222177156,
     0.243875508178893021593,
     0.257468141491069790481,
     0.271004054905512543536,
     0.284480308042725577496,
     0.297893980296857823437,
     0.311242171836871800300,
     0.324522004605921855207,
     0.337730623318886219621,
     0.350865196458001209011,
     0.363922917266549655269,
     0.376901004740559344802,
     0.389796704618470795479,
     0.402607290368737092671,
     0.415330064175321663764,
     0.427962357921062742583,
     0.440501534168875795783,
     0.452944987140767283784,
     0.465290143694634735858,
     0.477534464298829155284,
     0.489675444004456155436,
     0.501710613415391878251,
     0.513637539655988578507,
     0.525453827336442687395,
     0.537157119515795115982,
     0.548745098662529448608,
     0.560215487612728441818,
     0.571566050525742833992,
     0.582794593837318850840,
     0.593898967210121954393,
     0.604877064481584353319,
     0.615726824608992638014,
     0.626446232611719746542,
     0.637033320510492495071,
     0.647486168263572388782,
     0.657802904699713735422,
     0.667981708447749702165,
     0.678020808862644517838,
     0.687918486947839325756,
     0.697673076273711232906,
     0.707282963891961103412,
     0.716746591245747095767,
     0.726062455075389632685,
     0.735229108319491547663,
     0.744245161011347082309,
     0.753109281170558142523,
     0.761820195689839149173,
     0.770376691217076824278,
     0.778777615032822744702,
     0.787021875923539422170,
     0.795108445051100526780,
     0.803036356819268687782,
     0.810804709738146594361,
     0.818412667287925807395,
     0.825859458783650001088,
     0.833144380243172624728,
     0.840266795261030442350,
     0.847226135891580884381,
     0.854021903545468625813,
     0.860653669904299969802,
     0.867121077859315215614,
     0.873423842480859310192,
     0.879561752026556262568,
     0.885534668997285008926,
     0.891342531251319871666,
     0.896985353188316590376,
     0.902463227016165675048,
     0.907776324115058903624,
     0.912924896514370590080,
     0.917909278499077501636,
     0.922729888363349241523,
     0.927387230329536696843,
     0.931881896650953639345,
     0.936214569916450806625,
     0.940386025573669721370,
     0.944397134685866648591,
     0.948248866934137357063,
     0.951942293872573589498,
     0.955478592438183697574,
     0.958859048710200221356,
     0.962085061904651475741,
     0.965158148579915665979,
     0.968079947017759947964,
     0.970852221732792443256,
     0.973476868052506926773,
     0.975955916702011753129,
     0.978291538324758539526,
     0.980486047876721339416,
     0.982541908851080604251,
     0.984461737328814534596,
     0.986248305913007552681,
     0.987904547695124280467,
     0.989433560520240838716,
     0.990838611958294243677,
     0.992123145530863117683,
     0.993290788851684966211,
     0.994345364356723405931,
     0.995290903148810302261,
     0.996131662079315037786,
     0.996872143485260161299,
     0.997517116063472399965,
     0.998071634524930323302,
     0.998541055697167906027,
     0.998931050830810562236,
     0.999247618943342473599,
     0.999497112467187190535,
     0.999686286448317731776,
     0.999822363679787739196,
     0.999913081144678282800,
     0.999966730098486276883,
     0.999992298136257588028,
     0.999999672956734384381};
}
void TableGaussPatterson::loadWeights(){
    weights = {
    // 1 point rule
    2.0,
    // 3 point rule
    0.888888888888888888889,
    0.555555555555555555556,
    0.555555555555555555556,
    // 7 point rule
    0.450916538658474142345,
    0.268488089868333440729,
    0.268488089868333440729,
    0.104656226026467265194,
    0.401397414775962222905,
    0.401397414775962222905,
    0.104656226026467265194,
    // 15 point rule
    0.225510499798206687386,
    0.134415255243784220360,
    0.134415255243784220360,
    0.0516032829970797396969,
    0.200628529376989021034,
    0.200628529376989021034,
    0.0516032829970797396969,
    0.0170017196299402603390,
    0.0929271953151245376859,
    0.171511909136391380787,
    0.219156858401587496404,
    0.219156858401587496404,
    0.171511909136391380787,
    0.0929271953151245376859,
    0.0170017196299402603390,
    // 31 point rule
    0.112755256720768691607,
    0.0672077542959907035404,
    0.0672077542959907035404,
    0.0258075980961766535646,
    0.100314278611795578771,
    0.100314278611795578771,
    0.0258075980961766535646,
    0.00843456573932110624631,
    0.0464628932617579865414,
    0.0857559200499903511542,
    0.109578421055924638237,
    0.109578421055924638237,
    0.0857559200499903511542,
    0.0464628932617579865414,
    0.00843456573932110624631,
    0.00254478079156187441540,
    0.0164460498543878109338,
    0.0359571033071293220968,
    0.0569795094941233574122,
    0.0768796204990035310427,
    0.0936271099812644736167,
    0.105669893580234809744,
    0.111956873020953456880,
    0.111956873020953456880,
    0.105669893580234809744,
    0.0936271099812644736167,
    0.0768796204990035310427,
    0.0569795094941233574122,
    0.0359571033071293220968,
    0.0164460498543878109338,
    0.00254478079156187441540,
    // 63 point rule
    0.0563776283603847173877,
    0.0336038771482077305417,
    0.0336038771482077305417,
    0.0129038001003512656260,
    0.0501571393058995374137,
    0.0501571393058995374137,
    0.0129038001003512656260,
    0.00421763044155885483908,
    0.0232314466399102694433,
    0.0428779600250077344929,
    0.0547892105279628650322,
    0.0547892105279628650322,
    0.0428779600250077344929,
    0.0232314466399102694433,
    0.00421763044155885483908,
    0.00126515655623006801137,
    0.00822300795723592966926,
    0.0179785515681282703329,
    0.0284897547458335486125,
    0.0384398102494555320386,
    0.0468135549906280124026,
    0.0528349467901165198621,
    0.0559784365104763194076,
    0.0559784365104763194076,
    0.0528349467901165198621,
    0.0468135549906280124026,
    0.0384398102494555320386,
    0.0284897547458335486125,
    0.0179785515681282703329,
    0.00822300795723592966926,
    0.00126515655623006801137,
    0.000363221481845530659694,
    0.00257904979468568827243,
    0.00611550682211724633968,
    0.0104982469096213218983,
    0.0154067504665594978021,
    0.0205942339159127111492,
    0.0258696793272147469108,
    0.0310735511116879648799,
    0.0360644327807825726401,
    0.0407155101169443189339,
    0.0449145316536321974143,
    0.0485643304066731987159,
    0.0515832539520484587768,
    0.0539054993352660639269,
    0.0554814043565593639878,
    0.0562776998312543012726,
    0.0562776998312543012726,
    0.0554814043565593639878,
    0.0539054993352660639269,
    0.0515832539520484587768,
    0.0485643304066731987159,
    0.0449145316536321974143,
    0.0407155101169443189339,
    0.0360644327807825726401,
    0.0310735511116879648799,
    0.0258696793272147469108,
    0.0205942339159127111492,
    0.0154067504665594978021,
    0.0104982469096213218983,
    0.00611550682211724633968,
    0.00257904979468568827243,
    0.000363221481845530659694,
    // 127 point rule
    0.0281888141801923586938,
    0.0168019385741038652709,
    0.0168019385741038652709,
    0.00645190005017573692280,
    0.0250785696529497687068,
    0.0250785696529497687068,
    0.00645190005017573692280,
    0.00210881524572663287933,
    0.0116157233199551347270,
    0.0214389800125038672465,
    0.0273946052639814325161,
    0.0273946052639814325161,
    0.0214389800125038672465,
    0.0116157233199551347270,
    0.00210881524572663287933,
    0.000632607319362633544219,
    0.00411150397865469304717,
    0.00898927578406413572328,
    0.0142448773729167743063,
    0.0192199051247277660193,
    0.0234067774953140062013,
    0.0264174733950582599310,
    0.0279892182552381597038,
    0.0279892182552381597038,
    0.0264174733950582599310,
    0.0234067774953140062013,
    0.0192199051247277660193,
    0.0142448773729167743063,
    0.00898927578406413572328,
    0.00411150397865469304717,
    0.000632607319362633544219,
    0.000180739564445388357820,
    0.00128952408261041739210,
    0.00305775341017553113613,
    0.00524912345480885912513,
    0.00770337523327974184817,
    0.0102971169579563555237,
    0.0129348396636073734547,
    0.0155367755558439824399,
    0.0180322163903912863201,
    0.0203577550584721594669,
    0.0224572658268160987071,
    0.0242821652033365993580,
    0.0257916269760242293884,
    0.0269527496676330319634,
    0.0277407021782796819939,
    0.0281388499156271506363,
    0.0281388499156271506363,
    0.0277407021782796819939,
    0.0269527496676330319634,
    0.0257916269760242293884,
    0.0242821652033365993580,
    0.0224572658268160987071,
    0.0203577550584721594669,
    0.0180322163903912863201,
    0.0155367755558439824399,
    0.0129348396636073734547,
    0.0102971169579563555237,
    0.00770337523327974184817,
    0.00524912345480885912513,
    0.00305775341017553113613,
    0.00128952408261041739210,
    0.000180739564445388357820,
    0.0000505360952078625176247,
    0.000377746646326984660274,
    0.000938369848542381500794,
    0.00168114286542146990631,
    0.00256876494379402037313,
    0.00357289278351729964938,
    0.00467105037211432174741,
    0.00584344987583563950756,
    0.00707248999543355546805,
    0.00834283875396815770558,
    0.00964117772970253669530,
    0.0109557333878379016480,
    0.0122758305600827700870,
    0.0135915710097655467896,
    0.0148936416648151820348,
    0.0161732187295777199419,
    0.0174219301594641737472,
    0.0186318482561387901863,
    0.0197954950480974994880,
    0.0209058514458120238522,
    0.0219563663053178249393,
    0.0229409642293877487608,
    0.0238540521060385400804,
    0.0246905247444876769091,
    0.0254457699654647658126,
    0.0261156733767060976805,
    0.0266966229274503599062,
    0.0271855132296247918192,
    0.0275797495664818730349,
    0.0278772514766137016085,
    0.0280764557938172466068,
    0.0281763190330166021307,
    0.0281763190330166021307,
    0.0280764557938172466068,
    0.0278772514766137016085,
    0.0275797495664818730349,
    0.0271855132296247918192,
    0.0266966229274503599062,
    0.0261156733767060976805,
    0.0254457699654647658126,
    0.0246905247444876769091,
    0.0238540521060385400804,
    0.0229409642293877487608,
    0.0219563663053178249393,
    0.0209058514458120238522,
    0.0197954950480974994880,
    0.0186318482561387901863,
    0.0174219301594641737472,
    0.0161732187295777199419,
    0.0148936416648151820348,
    0.0135915710097655467896,
    0.0122758305600827700870,
    0.0109557333878379016480,
    0.00964117772970253669530,
    0.00834283875396815770558,
    0.00707248999543355546805,
    0.00584344987583563950756,
    0.00467105037211432174741,
    0.00357289278351729964938,
    0.00256876494379402037313,
    0.00168114286542146990631,
    0.000938369848542381500794,
    0.000377746646326984660274,
    0.0000505360952078625176247,
    // 255 point rule
    0.14094407090096179347E-1,
    0.84009692870519326354E-2,
    0.84009692870519326354E-2,
    0.32259500250878684614E-2,
    0.12539284826474884353E-1,
    0.12539284826474884353E-1,
    0.32259500250878684614E-2,
    0.10544076228633167722E-2,
    0.58078616599775673635E-2,
    0.10719490006251933623E-1,
    0.13697302631990716258E-1,
    0.13697302631990716258E-1,
    0.10719490006251933623E-1,
    0.58078616599775673635E-2,
    0.10544076228633167722E-2,
    0.31630366082226447689E-3,
    0.20557519893273465236E-2,
    0.44946378920320678616E-2,
    0.71224386864583871532E-2,
    0.96099525623638830097E-2,
    0.11703388747657003101E-1,
    0.13208736697529129966E-1,
    0.13994609127619079852E-1,
    0.13994609127619079852E-1,
    0.13208736697529129966E-1,
    0.11703388747657003101E-1,
    0.96099525623638830097E-2,
    0.71224386864583871532E-2,
    0.44946378920320678616E-2,
    0.20557519893273465236E-2,
    0.31630366082226447689E-3,
    0.90372734658751149261E-4,
    0.64476204130572477933E-3,
    0.15288767050877655684E-2,
    0.26245617274044295626E-2,
    0.38516876166398709241E-2,
    0.51485584789781777618E-2,
    0.64674198318036867274E-2,
    0.77683877779219912200E-2,
    0.90161081951956431600E-2,
    0.10178877529236079733E-1,
    0.11228632913408049354E-1,
    0.12141082601668299679E-1,
    0.12895813488012114694E-1,
    0.13476374833816515982E-1,
    0.13870351089139840997E-1,
    0.14069424957813575318E-1,
    0.14069424957813575318E-1,
    0.13870351089139840997E-1,
    0.13476374833816515982E-1,
    0.12895813488012114694E-1,
    0.12141082601668299679E-1,
    0.11228632913408049354E-1,
    0.10178877529236079733E-1,
    0.90161081951956431600E-2,
    0.77683877779219912200E-2,
    0.64674198318036867274E-2,
    0.51485584789781777618E-2,
    0.38516876166398709241E-2,
    0.26245617274044295626E-2,
    0.15288767050877655684E-2,
    0.64476204130572477933E-3,
    0.90372734658751149261E-4,
    0.25157870384280661489E-4,
    0.18887326450650491366E-3,
    0.46918492424785040975E-3,
    0.84057143271072246365E-3,
    0.12843824718970101768E-2,
    0.17864463917586498247E-2,
    0.23355251860571608737E-2,
    0.29217249379178197538E-2,
    0.35362449977167777340E-2,
    0.41714193769840788528E-2,
    0.48205888648512683476E-2,
    0.54778666939189508240E-2,
    0.61379152800413850435E-2,
    0.67957855048827733948E-2,
    0.74468208324075910174E-2,
    0.80866093647888599710E-2,
    0.87109650797320868736E-2,
    0.93159241280693950932E-2,
    0.98977475240487497440E-2,
    0.10452925722906011926E-1,
    0.10978183152658912470E-1,
    0.11470482114693874380E-1,
    0.11927026053019270040E-1,
    0.12345262372243838455E-1,
    0.12722884982732382906E-1,
    0.13057836688353048840E-1,
    0.13348311463725179953E-1,
    0.13592756614812395910E-1,
    0.13789874783240936517E-1,
    0.13938625738306850804E-1,
    0.14038227896908623303E-1,
    0.14088159516508301065E-1,
    0.14088159516508301065E-1,
    0.14038227896908623303E-1,
    0.13938625738306850804E-1,
    0.13789874783240936517E-1,
    0.13592756614812395910E-1,
    0.13348311463725179953E-1,
    0.13057836688353048840E-1,
    0.12722884982732382906E-1,
    0.12345262372243838455E-1,
    0.11927026053019270040E-1,
    0.11470482114693874380E-1,
    0.10978183152658912470E-1,
    0.10452925722906011926E-1,
    0.98977475240487497440E-2,
    0.93159241280693950932E-2,
    0.87109650797320868736E-2,
    0.80866093647888599710E-2,
    0.74468208324075910174E-2,
    0.67957855048827733948E-2,
    0.61379152800413850435E-2,
    0.54778666939189508240E-2,
    0.48205888648512683476E-2,
    0.41714193769840788528E-2,
    0.35362449977167777340E-2,
    0.29217249379178197538E-2,
    0.23355251860571608737E-2,
    0.17864463917586498247E-2,
    0.12843824718970101768E-2,
    0.84057143271072246365E-3,
    0.46918492424785040975E-3,
    0.18887326450650491366E-3,
    0.25157870384280661489E-4,
    0.69379364324108267170E-5,
    0.53275293669780613125E-4,
    0.13575491094922871973E-3,
    0.24921240048299729402E-3,
    0.38974528447328229322E-3,
    0.55429531493037471492E-3,
    0.74028280424450333046E-3,
    0.94536151685852538246E-3,
    0.11674841174299594077E-2,
    0.14049079956551446427E-2,
    0.16561127281544526052E-2,
    0.19197129710138724125E-2,
    0.21944069253638388388E-2,
    0.24789582266575679307E-2,
    0.27721957645934509940E-2,
    0.30730184347025783234E-2,
    0.33803979910869203823E-2,
    0.36933779170256508183E-2,
    0.40110687240750233989E-2,
    0.43326409680929828545E-2,
    0.46573172997568547773E-2,
    0.49843645647655386012E-2,
    0.53130866051870565663E-2,
    0.56428181013844441585E-2,
    0.59729195655081658049E-2,
    0.63027734490857587172E-2,
    0.66317812429018878941E-2,
    0.69593614093904229394E-2,
    0.72849479805538070639E-2,
    0.76079896657190565832E-2,
    0.79279493342948491103E-2,
    0.82443037630328680306E-2,
    0.85565435613076896192E-2,
    0.88641732094824942641E-2,
    0.91667111635607884067E-2,
    0.94636899938300652943E-2,
    0.97546565363174114611E-2,
    0.10039172044056840798E-1,
    0.10316812330947621682E-1,
    0.10587167904885197931E-1,
    0.10849844089337314099E-1,
    0.11104461134006926537E-1,
    0.11350654315980596602E-1,
    0.11588074033043952568E-1,
    0.11816385890830235763E-1,
    0.12035270785279562630E-1,
    0.12244424981611985899E-1,
    0.12443560190714035263E-1,
    0.12632403643542078765E-1,
    0.12810698163877361967E-1,
    0.12978202239537399286E-1,
    0.13134690091960152836E-1,
    0.13279951743930530650E-1,
    0.13413793085110098513E-1,
    0.13536035934956213614E-1,
    0.13646518102571291428E-1,
    0.13745093443001896632E-1,
    0.13831631909506428676E-1,
    0.13906019601325461264E-1,
    0.13968158806516938516E-1,
    0.14017968039456608810E-1,
    0.14055382072649964277E-1,
    0.14080351962553661325E-1,
    0.14092845069160408355E-1,
    0.14092845069160408355E-1,
    0.14080351962553661325E-1,
    0.14055382072649964277E-1,
    0.14017968039456608810E-1,
    0.13968158806516938516E-1,
    0.13906019601325461264E-1,
    0.13831631909506428676E-1,
    0.13745093443001896632E-1,
    0.13646518102571291428E-1,
    0.13536035934956213614E-1,
    0.13413793085110098513E-1,
    0.13279951743930530650E-1,
    0.13134690091960152836E-1,
    0.12978202239537399286E-1,
    0.12810698163877361967E-1,
    0.12632403643542078765E-1,
    0.12443560190714035263E-1,
    0.12244424981611985899E-1,
    0.12035270785279562630E-1,
    0.11816385890830235763E-1,
    0.11588074033043952568E-1,
    0.11350654315980596602E-1,
    0.11104461134006926537E-1,
    0.10849844089337314099E-1,
    0.10587167904885197931E-1,
    0.10316812330947621682E-1,
    0.10039172044056840798E-1,
    0.97546565363174114611E-2,
    0.94636899938300652943E-2,
    0.91667111635607884067E-2,
    0.88641732094824942641E-2,
    0.85565435613076896192E-2,
    0.82443037630328680306E-2,
    0.79279493342948491103E-2,
    0.76079896657190565832E-2,
    0.72849479805538070639E-2,
    0.69593614093904229394E-2,
    0.66317812429018878941E-2,
    0.63027734490857587172E-2,
    0.59729195655081658049E-2,
    0.56428181013844441585E-2,
    0.53130866051870565663E-2,
    0.49843645647655386012E-2,
    0.46573172997568547773E-2,
    0.43326409680929828545E-2,
    0.40110687240750233989E-2,
    0.36933779170256508183E-2,
    0.33803979910869203823E-2,
    0.30730184347025783234E-2,
    0.27721957645934509940E-2,
    0.24789582266575679307E-2,
    0.21944069253638388388E-2,
    0.19197129710138724125E-2,
    0.16561127281544526052E-2,
    0.14049079956551446427E-2,
    0.11674841174299594077E-2,
    0.94536151685852538246E-3,
    0.74028280424450333046E-3,
    0.55429531493037471492E-3,
    0.38974528447328229322E-3,
    0.24921240048299729402E-3,
    0.13575491094922871973E-3,
    0.53275293669780613125E-4,
    0.69379364324108267170E-5,
    // 511 point rule
    0.704720354504808967346E-2,
    0.420048464352596631772E-2,
    0.420048464352596631772E-2,
    0.161297501254393423070E-2,
    0.626964241323744217671E-2,
    0.626964241323744217671E-2,
    0.161297501254393423070E-2,
    0.527203811431658386125E-3,
    0.290393082998878368175E-2,
    0.535974500312596681161E-2,
    0.684865131599535812903E-2,
    0.684865131599535812903E-2,
    0.535974500312596681161E-2,
    0.290393082998878368175E-2,
    0.527203811431658386125E-3,
    0.158151830411132242924E-3,
    0.102787599466367326179E-2,
    0.224731894601603393082E-2,
    0.356121934322919357659E-2,
    0.480497628118194150483E-2,
    0.585169437382850155033E-2,
    0.660436834876456498276E-2,
    0.699730456380953992594E-2,
    0.699730456380953992594E-2,
    0.660436834876456498276E-2,
    0.585169437382850155033E-2,
    0.480497628118194150483E-2,
    0.356121934322919357659E-2,
    0.224731894601603393082E-2,
    0.102787599466367326179E-2,
    0.158151830411132242924E-3,
    0.451863674126296143105E-4,
    0.322381020652862389664E-3,
    0.764438352543882784191E-3,
    0.131228086370221478128E-2,
    0.192584380831993546204E-2,
    0.257427923948908888092E-2,
    0.323370991590184336368E-2,
    0.388419388896099560998E-2,
    0.450805409759782158001E-2,
    0.508943876461803986674E-2,
    0.561431645670402467678E-2,
    0.607054130083414983949E-2,
    0.644790674400605734710E-2,
    0.673818741690825799086E-2,
    0.693517554456992049848E-2,
    0.703471247890678765907E-2,
    0.703471247890678765907E-2,
    0.693517554456992049848E-2,
    0.673818741690825799086E-2,
    0.644790674400605734710E-2,
    0.607054130083414983949E-2,
    0.561431645670402467678E-2,
    0.508943876461803986674E-2,
    0.450805409759782158001E-2,
    0.388419388896099560998E-2,
    0.323370991590184336368E-2,
    0.257427923948908888092E-2,
    0.192584380831993546204E-2,
    0.131228086370221478128E-2,
    0.764438352543882784191E-3,
    0.322381020652862389664E-3,
    0.451863674126296143105E-4,
    0.125792781889592743525E-4,
    0.944366322532705527066E-4,
    0.234592462123925204879E-3,
    0.420285716355361231823E-3,
    0.642191235948505088403E-3,
    0.893223195879324912340E-3,
    0.116776259302858043685E-2,
    0.146086246895890987689E-2,
    0.176812249885838886701E-2,
    0.208570968849203942640E-2,
    0.241029443242563417382E-2,
    0.273893334695947541201E-2,
    0.306895764002069252174E-2,
    0.339789275244138669739E-2,
    0.372341041620379550870E-2,
    0.404330468239442998549E-2,
    0.435548253986604343679E-2,
    0.465796206403469754658E-2,
    0.494887376202437487201E-2,
    0.522646286145300596306E-2,
    0.548909157632945623482E-2,
    0.573524105734693719020E-2,
    0.596351302650963502011E-2,
    0.617263118612191922727E-2,
    0.636144249136619145314E-2,
    0.652891834417652442012E-2,
    0.667415573186258997654E-2,
    0.679637830740619795480E-2,
    0.689493739162046825872E-2,
    0.696931286915342540213E-2,
    0.701911394845431165171E-2,
    0.704407975825415053266E-2,
    0.704407975825415053266E-2,
    0.701911394845431165171E-2,
    0.696931286915342540213E-2,
    0.689493739162046825872E-2,
    0.679637830740619795480E-2,
    0.667415573186258997654E-2,
    0.652891834417652442012E-2,
    0.636144249136619145314E-2,
    0.617263118612191922727E-2,
    0.596351302650963502011E-2,
    0.573524105734693719020E-2,
    0.548909157632945623482E-2,
    0.522646286145300596306E-2,
    0.494887376202437487201E-2,
    0.465796206403469754658E-2,
    0.435548253986604343679E-2,
    0.404330468239442998549E-2,
    0.372341041620379550870E-2,
    0.339789275244138669739E-2,
    0.306895764002069252174E-2,
    0.273893334695947541201E-2,
    0.241029443242563417382E-2,
    0.208570968849203942640E-2,
    0.176812249885838886701E-2,
    0.146086246895890987689E-2,
    0.116776259302858043685E-2,
    0.893223195879324912340E-3,
    0.642191235948505088403E-3,
    0.420285716355361231823E-3,
    0.234592462123925204879E-3,
    0.944366322532705527066E-4,
    0.125792781889592743525E-4,
    0.345456507169149134898E-5,
    0.266376412339000901358E-4,
    0.678774554733972416227E-4,
    0.124606200241498368482E-3,
    0.194872642236641146532E-3,
    0.277147657465187357459E-3,
    0.370141402122251665232E-3,
    0.472680758429262691232E-3,
    0.583742058714979703847E-3,
    0.702453997827572321358E-3,
    0.828056364077226302608E-3,
    0.959856485506936206261E-3,
    0.109720346268191941940E-2,
    0.123947911332878396534E-2,
    0.138609788229672549700E-2,
    0.153650921735128916170E-2,
    0.169019899554346019117E-2,
    0.184668895851282540913E-2,
    0.200553436203751169944E-2,
    0.216632048404649142727E-2,
    0.232865864987842738864E-2,
    0.249218228238276930060E-2,
    0.265654330259352828314E-2,
    0.282140905069222207923E-2,
    0.298645978275408290247E-2,
    0.315138672454287935858E-2,
    0.331589062145094394706E-2,
    0.347968070469521146972E-2,
    0.364247399027690353194E-2,
    0.380399483285952829161E-2,
    0.396397466714742455513E-2,
    0.412215188151643401528E-2,
    0.427827178065384480959E-2,
    0.443208660474124713206E-2,
    0.458335558178039420335E-2,
    0.473184499691503264714E-2,
    0.487732826815870573054E-2,
    0.501958602202842039909E-2,
    0.515840616547381084096E-2,
    0.529358395244259896547E-2,
    0.542492204466865704951E-2,
    0.555223056700346326850E-2,
    0.567532715799029830087E-2,
    0.579403701652197628421E-2,
    0.590819294541511788161E-2,
    0.601763539263978131522E-2,
    0.612221249080599294931E-2,
    0.622178009535701763157E-2,
    0.631620182177103938227E-2,
    0.640534908193868098342E-2,
    0.648910111976869964292E-2,
    0.656734504598007641819E-2,
    0.663997587196526532519E-2,
    0.670689654255504925648E-2,
    0.676801796747810680683E-2,
    0.682325905128564571420E-2,
    0.687254672150094831613E-2,
    0.691581595475321433825E-2,
    0.695300980066273063177E-2,
    0.698407940325846925786E-2,
    0.700898401972830440494E-2,
    0.702769103632498213858E-2,
    0.704017598127683066242E-2,
    0.704642253458020417748E-2,
    0.704642253458020417748E-2,
    0.704017598127683066242E-2,
    0.702769103632498213858E-2,
    0.700898401972830440494E-2,
    0.698407940325846925786E-2,
    0.695300980066273063177E-2,
    0.691581595475321433825E-2,
    0.687254672150094831613E-2,
    0.682325905128564571420E-2,
    0.676801796747810680683E-2,
    0.670689654255504925648E-2,
    0.663997587196526532519E-2,
    0.656734504598007641819E-2,
    0.648910111976869964292E-2,
    0.640534908193868098342E-2,
    0.631620182177103938227E-2,
    0.622178009535701763157E-2,
    0.612221249080599294931E-2,
    0.601763539263978131522E-2,
    0.590819294541511788161E-2,
    0.579403701652197628421E-2,
    0.567532715799029830087E-2,
    0.555223056700346326850E-2,
    0.542492204466865704951E-2,
    0.529358395244259896547E-2,
    0.515840616547381084096E-2,
    0.501958602202842039909E-2,
    0.487732826815870573054E-2,
    0.473184499691503264714E-2,
    0.458335558178039420335E-2,
    0.443208660474124713206E-2,
    0.427827178065384480959E-2,
    0.412215188151643401528E-2,
    0.396397466714742455513E-2,
    0.380399483285952829161E-2,
    0.364247399027690353194E-2,
    0.347968070469521146972E-2,
    0.331589062145094394706E-2,
    0.315138672454287935858E-2,
    0.298645978275408290247E-2,
    0.282140905069222207923E-2,
    0.265654330259352828314E-2,
    0.249218228238276930060E-2,
    0.232865864987842738864E-2,
    0.216632048404649142727E-2,
    0.200553436203751169944E-2,
    0.184668895851282540913E-2,
    0.169019899554346019117E-2,
    0.153650921735128916170E-2,
    0.138609788229672549700E-2,
    0.123947911332878396534E-2,
    0.109720346268191941940E-2,
    0.959856485506936206261E-3,
    0.828056364077226302608E-3,
    0.702453997827572321358E-3,
    0.583742058714979703847E-3,
    0.472680758429262691232E-3,
    0.370141402122251665232E-3,
    0.277147657465187357459E-3,
    0.194872642236641146532E-3,
    0.124606200241498368482E-3,
    0.678774554733972416227E-4,
    0.266376412339000901358E-4,
    0.345456507169149134898E-5,
    0.945715933950007048827E-6,
    0.736624069102321668857E-5,
    0.190213681905875816679E-4,
    0.353751372055189588628E-4,
    0.560319507856164252140E-4,
    0.806899228014035293851E-4,
    0.109085545645741522051E-3,
    0.140970302204104791413E-3,
    0.176126765545083195474E-3,
    0.214368090034216937149E-3,
    0.255525589595236862014E-3,
    0.299439176850911730874E-3,
    0.345954492129903871350E-3,
    0.394924138246873704434E-3,
    0.446209810101403247488E-3,
    0.499683553312800484519E-3,
    0.555227733977307579715E-3,
    0.612734008012225209294E-3,
    0.672101776960108194646E-3,
    0.733236554224767912055E-3,
    0.796048517297550871506E-3,
    0.860451377808527848128E-3,
    0.926361595613111283368E-3,
    0.993697899638760857945E-3,
    0.106238104885340071375E-2,
    0.113233376051597664917E-2,
    0.120348074001265964881E-2,
    0.127574875977346947345E-2,
    0.134906674928353113127E-2,
    0.142336587141720519900E-2,
    0.149857957106456636214E-2,
    0.157464359003212166189E-2,
    0.165149594771914570655E-2,
    0.172907689054461607168E-2,
    0.180732881501808930079E-2,
    0.188619617015808475394E-2,
    0.196562534503150547732E-2,
    0.204556454679958293446E-2,
    0.212596367401472533045E-2,
    0.220677418916003329194E-2,
    0.228794899365195972378E-2,
    0.236944230779380495146E-2,
    0.245120955750556483923E-2,
    0.253320726907925325750E-2,
    0.261539297272236109225E-2,
    0.269772511525294586667E-2,
    0.278016298199139435045E-2,
    0.286266662764757868253E-2,
    0.294519681581857582284E-2,
    0.302771496658198544480E-2,
    0.311018311158427546158E-2,
    0.319256385597434736790E-2,
    0.327482034651233969564E-2,
    0.335691624518616761342E-2,
    0.343881570768790591876E-2,
    0.352048336613417922682E-2,
    0.360188431545532431869E-2,
    0.368298410292403911967E-2,
    0.376374872034296338241E-2,
    0.384414459846013158917E-2,
    0.392413860322995774660E-2,
    0.400369803358421688562E-2,
    0.408279062042157838350E-2,
    0.416138452656509745764E-2,
    0.423944834747438184434E-2,
    0.431695111253279479928E-2,
    0.439386228676004195260E-2,
    0.447015177282692726900E-2,
    0.454578991327213285488E-2,
    0.462074749284080687482E-2,
    0.469499574088179046532E-2,
    0.476850633375474925263E-2,
    0.484125139721057135214E-2,
    0.491320350871841897367E-2,
    0.498433569972103029914E-2,
    0.505462145780650125058E-2,
    0.512403472879005351831E-2,
    0.519254991870341614863E-2,
    0.526014189569259311205E-2,
    0.532678599182711857974E-2,
    0.539245800482555593606E-2,
    0.545713419970309863995E-2,
    0.552079131034778706457E-2,
    0.558340654103215637610E-2,
    0.564495756786715368885E-2,
    0.570542254020497332312E-2,
    0.576478008199711142954E-2,
    0.582300929311348057702E-2,
    0.588008975062788803205E-2,
    0.593600151007459827614E-2,
    0.599072510668009471472E-2,
    0.604424155657354634589E-2,
    0.609653235797888692923E-2,
    0.614757949239083790214E-2,
    0.619736542573665996342E-2,
    0.624587310952490748541E-2,
    0.629308598198198836688E-2,
    0.633898796917690165912E-2,
    0.638356348613413709795E-2,
    0.642679743793437438922E-2,
    0.646867522080231481688E-2,
    0.650918272318071200827E-2,
    0.654830632678944064054E-2,
    0.658603290766824937794E-2,
    0.662234983720168509457E-2,
    0.665724498312454708217E-2,
    0.669070671050613006584E-2,
    0.672272388271144108036E-2,
    0.675328586233752529078E-2,
    0.678238251212300746082E-2,
    0.681000419582894688374E-2,
    0.683614177908911221841E-2,
    0.686078663022780697951E-2,
    0.688393062104341470995E-2,
    0.690556612755588354803E-2,
    0.692568603071643155621E-2,
    0.694428371707782549438E-2,
    0.696135307942366551493E-2,
    0.697688851735519545845E-2,
    0.699088493783425207545E-2,
    0.700333775568106572820E-2,
    0.701424289402572916425E-2,
    0.702359678471225911031E-2,
    0.703139636865428709508E-2,
    0.703763909614153052319E-2,
    0.704232292709631209597E-2,
    0.704544633127951476780E-2,
    0.704700828844548013730E-2,
    0.704700828844548013730E-2,
    0.704544633127951476780E-2,
    0.704232292709631209597E-2,
    0.703763909614153052319E-2,
    0.703139636865428709508E-2,
    0.702359678471225911031E-2,
    0.701424289402572916425E-2,
    0.700333775568106572820E-2,
    0.699088493783425207545E-2,
    0.697688851735519545845E-2,
    0.696135307942366551493E-2,
    0.694428371707782549438E-2,
    0.692568603071643155621E-2,
    0.690556612755588354803E-2,
    0.688393062104341470995E-2,
    0.686078663022780697951E-2,
    0.683614177908911221841E-2,
    0.681000419582894688374E-2,
    0.678238251212300746082E-2,
    0.675328586233752529078E-2,
    0.672272388271144108036E-2,
    0.669070671050613006584E-2,
    0.665724498312454708217E-2,
    0.662234983720168509457E-2,
    0.658603290766824937794E-2,
    0.654830632678944064054E-2,
    0.650918272318071200827E-2,
    0.646867522080231481688E-2,
    0.642679743793437438922E-2,
    0.638356348613413709795E-2,
    0.633898796917690165912E-2,
    0.629308598198198836688E-2,
    0.624587310952490748541E-2,
    0.619736542573665996342E-2,
    0.614757949239083790214E-2,
    0.609653235797888692923E-2,
    0.604424155657354634589E-2,
    0.599072510668009471472E-2,
    0.593600151007459827614E-2,
    0.588008975062788803205E-2,
    0.582300929311348057702E-2,
    0.576478008199711142954E-2,
    0.570542254020497332312E-2,
    0.564495756786715368885E-2,
    0.558340654103215637610E-2,
    0.552079131034778706457E-2,
    0.545713419970309863995E-2,
    0.539245800482555593606E-2,
    0.532678599182711857974E-2,
    0.526014189569259311205E-2,
    0.519254991870341614863E-2,
    0.512403472879005351831E-2,
    0.505462145780650125058E-2,
    0.498433569972103029914E-2,
    0.491320350871841897367E-2,
    0.484125139721057135214E-2,
    0.476850633375474925263E-2,
    0.469499574088179046532E-2,
    0.462074749284080687482E-2,
    0.454578991327213285488E-2,
    0.447015177282692726900E-2,
    0.439386228676004195260E-2,
    0.431695111253279479928E-2,
    0.423944834747438184434E-2,
    0.416138452656509745764E-2,
    0.408279062042157838350E-2,
    0.400369803358421688562E-2,
    0.392413860322995774660E-2,
    0.384414459846013158917E-2,
    0.376374872034296338241E-2,
    0.368298410292403911967E-2,
    0.360188431545532431869E-2,
    0.352048336613417922682E-2,
    0.343881570768790591876E-2,
    0.335691624518616761342E-2,
    0.327482034651233969564E-2,
    0.319256385597434736790E-2,
    0.311018311158427546158E-2,
    0.302771496658198544480E-2,
    0.294519681581857582284E-2,
    0.286266662764757868253E-2,
    0.278016298199139435045E-2,
    0.269772511525294586667E-2,
    0.261539297272236109225E-2,
    0.253320726907925325750E-2,
    0.245120955750556483923E-2,
    0.236944230779380495146E-2,
    0.228794899365195972378E-2,
    0.220677418916003329194E-2,
    0.212596367401472533045E-2,
    0.204556454679958293446E-2,
    0.196562534503150547732E-2,
    0.188619617015808475394E-2,
    0.180732881501808930079E-2,
    0.172907689054461607168E-2,
    0.165149594771914570655E-2,
    0.157464359003212166189E-2,
    0.149857957106456636214E-2,
    0.142336587141720519900E-2,
    0.134906674928353113127E-2,
    0.127574875977346947345E-2,
    0.120348074001265964881E-2,
    0.113233376051597664917E-2,
    0.106238104885340071375E-2,
    0.993697899638760857945E-3,
    0.926361595613111283368E-3,
    0.860451377808527848128E-3,
    0.796048517297550871506E-3,
    0.733236554224767912055E-3,
    0.672101776960108194646E-3,
    0.612734008012225209294E-3,
    0.555227733977307579715E-3,
    0.499683553312800484519E-3,
    0.446209810101403247488E-3,
    0.394924138246873704434E-3,
    0.345954492129903871350E-3,
    0.299439176850911730874E-3,
    0.255525589595236862014E-3,
    0.214368090034216937149E-3,
    0.176126765545083195474E-3,
    0.140970302204104791413E-3,
    0.109085545645741522051E-3,
    0.806899228014035293851E-4,
    0.560319507856164252140E-4,
    0.353751372055189588628E-4,
    0.190213681905875816679E-4,
    0.736624069102321668857E-5,
    0.945715933950007048827E-6};
}

}

#endif
