C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=XMAILL,SSI=0
                        SUBROUTINE XMAILL
C                       *****************
C
C      ---------------------------------------------------------
     * (NDIELE,NPOINS,NELEMS,NELESS,NELEUS,NELERC,NELERA,
     *  NDMATS,NDMASS,
     *  NBFACE,NODES,NODESS,NODEUS,NODERC,NODERA,
     *  NREFS,NREFAC,NREFAL)
C      ---------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C       EXTRACTION DU MAILLAGE DE PEAU DU MAILLAGE ELEMENTS FINIS      *
C                                                                      *
C                 - faces couples (NODESS)                             *
C                 - faces avec condition de type flux (NODEUS)         *
C                   (flux,couplees,coef ech,resistance de contact)     *
C                 - faces avec resistance de contact (NODERC)          *
C                 - faces avec rayonnement (NODERA)                    *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIELE   !  E ! D  ! Dimension des elements (2=trian, 3=tetra)    !
C !  NPOINS   !  E ! D  ! Nombre de noeuds du maillage solide          !
C !  NELEMS   !  E ! D  ! Nombre d'elements du maillage solide         !
C !  NELESS   !  E ! D  ! Nombre d'elts surfaciques couples            !
C !  NELEUS   !  E ! D  ! Nombre d'elts surfaciques avec flux(general) |
C !  NELERC   !  E ! D  ! Nombre d'elts surfaciques avec resistance    !
C !  NELERA   !  E ! D  ! Nombre d'elts surfaciques avec rayonnement   !
C !  NDMATS   !  E ! D  ! Nombre de noeuds par element volumique       !
C !  NDMASS   !  E ! D  ! Nombre de noeuds par element surfacique      !
C !  NBFACE   !  E ! D  ! Nombre de faces des elts vol solides         !
C !  NODES    ! TE ! D  ! Connectivite maillage volumique solide       !
C !  NODESS   ! TE ! R  ! Connectivite maillage surf couple            !
C !  NODEUS   ! TE ! R  ! Connectivite maillage surf avec flux         !
C !  NODERC   ! TE ! R  ! Connectivite maillage surf avec resistance   !
C !  NODERA   ! TE ! R  ! Connectivite maillage surf avec rayonnement  !
C !  NREFS    ! TE ! D  ! Reference des noeuds du maillage vol. solide |
C !  NREFAC   ! TE ! D  ! Reference faces (aretes en 2D) (volumiques)  |
C !  NREFAL   ! TE ! R  ! Ref faces (aretes en 2D) num local ds NODEUS |
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "xrefer.h"
#include "nlofes.h"
C
C***********************************************************************
C
      INTEGER NDX
      PARAMETER (NDX=10)
C
C.. Variables externes
      INTEGER NDIELE,NELEMS,NDMATS,NPOINS,NELESS,NELEUS,NELERC,NELERA
      INTEGER NDMASS,NBFACE
      INTEGER NODES(NELEMS,NDMATS),NREFS(NPOINS),NODESS(NELESS,NDMASS)
      INTEGER NODEUS(NELEUS,NDMASS),NODERC(NELERC,NDMASS)
      INTEGER NODERA(NELERA,NDMASS)
      INTEGER NREFAC(NELEMS,NBFACE),NREFAL(NELEUS)
C
C.. Variables internes
      INTEGER N,M,I,J    
      INTEGER NLSS,NLUS,NLRC,NLRA
      LOGICAL LFFLU(NDX),LFCOU(NDX),LFRES(NDX),LPDIR(NDX),LFRAY(NDX)
      LOGICAL ERR
      INTEGER NARE(3,3),NFAC(6,4)
C***********************************************************************
C
      DATA NARE/1,2,4,  2,3,5,  3,1,6/
      DATA NFAC/1,3,2,7,6,5,  1,2,4,5,9,8,  1,4,3,8,10,7,  2,3,4,6,10,9/
C
C
C     0- INITIALISATIONS
C     ==================
C
      NLSS = 0
      NLUS = 0
      NLRC = 0
      NLRA = 0
C
      IF (LCFACE) THEN
        DO 10 N=1,NELEUS
          NREFAL(N) = 0
   10   CONTINUE
      ENDIF
C
C
C     1- CAS DES TRIANGLES
C     ====================
      IF (NDIELE.EQ.2) THEN
C
        DO 100 N=1,NELEMS
C 
          IF (LCFACE) THEN
            CALL EVAFAC(N,NDIELE,NELEMS,NREFAC,
     *                  LFFLU,LFCOU,LFRES,LFRAY,NBFACE)
          ELSE
            CALL EVATYP(N,NDIELE,NODES,NELEMS,NDMATS,NREFS,NPOINS,
     *                  LFFLU,LFCOU,LFRES,LFRAY,NBFACE,LPDIR)
          ENDIF
C
          DO 110 M=1,NBFACE
           IF (LFCOU(M)) THEN
              NLSS = NLSS + 1
              NODESS(NLSS,1) = NODES(N,NARE(1,M))
              NODESS(NLSS,2) = NODES(N,NARE(2,M))
              NODESS(NLSS,3) = NODES(N,NARE(3,M))
           ENDIF
           IF (LFFLU(M)) THEN
              NLUS = NLUS + 1
              NODEUS(NLUS,1) = NODES(N,NARE(1,M))
              NODEUS(NLUS,2) = NODES(N,NARE(2,M))
              NODEUS(NLUS,3) = NODES(N,NARE(3,M))
              IF (LCFACE) NREFAL(NLUS) = NREFAC(N,M)
           ENDIF
           IF (LFRES(M)) THEN
              NLRC = NLRC + 1
              NODERC(NLRC,1) = NODES(N,NARE(1,M))
              NODERC(NLRC,2) = NODES(N,NARE(2,M))
              NODERC(NLRC,3) = NODES(N,NARE(3,M))
           ENDIF
           IF (LFRAY(M)) THEN
              NLRA = NLRA + 1
              NODERA(NLRA,1) = NODES(N,NARE(1,M))
              NODERA(NLRA,2) = NODES(N,NARE(2,M))
              NODERA(NLRA,3) = NODES(N,NARE(3,M))
           ENDIF
  110    CONTINUE
C
  100  CONTINUE
C
C     2- CAS DES TETRAEDRES
C     =====================
C
      ELSEIF (NDIELE.EQ.3) THEN
C
        DO 200 N=1,NELEMS
C 
          IF (LCFACE) THEN
            CALL EVAFAC(N,NDIELE,NELEMS,NREFAC,
     *                  LFFLU,LFCOU,LFRES,LFRAY,NBFACE)
          ELSE
            CALL EVATYP(N,NDIELE,NODES,NELEMS,NDMATS,NREFS,NPOINS,
     *                  LFFLU,LFCOU,LFRES,LFRAY,NBFACE,LPDIR)
          ENDIF
C
          DO 210 M=1,NBFACE
           IF (LFCOU(M)) THEN
              NLSS = NLSS + 1
              NODESS(NLSS,1) = NODES(N,NFAC(1,M))
              NODESS(NLSS,2) = NODES(N,NFAC(2,M))
              NODESS(NLSS,3) = NODES(N,NFAC(3,M))
              NODESS(NLSS,4) = NODES(N,NFAC(4,M))
              NODESS(NLSS,5) = NODES(N,NFAC(5,M))
              NODESS(NLSS,6) = NODES(N,NFAC(6,M))
           ENDIF
           IF (LFFLU(M)) THEN
              NLUS = NLUS + 1
              NODEUS(NLUS,1) = NODES(N,NFAC(1,M))
              NODEUS(NLUS,2) = NODES(N,NFAC(2,M))
              NODEUS(NLUS,3) = NODES(N,NFAC(3,M))
              NODEUS(NLUS,4) = NODES(N,NFAC(4,M))
              NODEUS(NLUS,5) = NODES(N,NFAC(5,M))
              NODEUS(NLUS,6) = NODES(N,NFAC(6,M))
              IF (LCFACE) NREFAL(NLUS) = NREFAC(N,M)
           ENDIF
           IF (LFRES(M)) THEN
              NLRC = NLRC + 1
              NODERC(NLRC,1) = NODES(N,NFAC(1,M))
              NODERC(NLRC,2) = NODES(N,NFAC(2,M))
              NODERC(NLRC,3) = NODES(N,NFAC(3,M))
              NODERC(NLRC,4) = NODES(N,NFAC(4,M))
              NODERC(NLRC,5) = NODES(N,NFAC(5,M))
              NODERC(NLRC,6) = NODES(N,NFAC(6,M))
           ENDIF
           IF (LFRAY(M)) THEN
              NLRA = NLRA + 1
              NODERA(NLRA,1) = NODES(N,NFAC(1,M))
              NODERA(NLRA,2) = NODES(N,NFAC(2,M))
              NODERA(NLRA,3) = NODES(N,NFAC(3,M))
              NODERA(NLRA,4) = NODES(N,NFAC(4,M))
              NODERA(NLRA,5) = NODES(N,NFAC(5,M))
              NODERA(NLRA,6) = NODES(N,NFAC(6,M))
           ENDIF
  210    CONTINUE
C
  200  CONTINUE


C     3- ERREUR
C     =========
C
      ELSE
C
        WRITE(NFECRA,3000)
        STOP
C
      ENDIF
C
C     4- CONTROLE DES DEBORDEMENTS DE TABLEAU
C     =======================================
C
      ERR = .FALSE.
C
      IF (NLSS.NE.NELESS) THEN
         WRITE(NFECRA,4000) NELESS,NLSS
         ERR = .TRUE.
      ENDIF
      IF (NLUS.NE.NELEUS) THEN
         WRITE(NFECRA,4010) NELEUS,NLUS
         ERR = .TRUE.
      ENDIF
C
      IF (NLRC.NE.NELERC) THEN
         WRITE(NFECRA,4020) NELERC,NLRC
         ERR = .TRUE.
      ENDIF
C
      IF (NLRA.NE.NELERA) THEN
         WRITE(NFECRA,4030) NELERA,NLRA
         ERR = .TRUE.
      ENDIF
C
      IF (ERR) STOP
C
C     5- IMPRESSION SUR LISTING
C     =========================
C
      IF (NBLBLA.GT.0) THEN
        WRITE(NFECRA,5000)
        WRITE(NFECRA,5010) NELESS,NELEUS,NELERC,NELERA
      ENDIF
C 
C
C     6- VERIFICATION DU MAILLAGE LU
C     ==============================
C
      IF (NBLBLA.EQ.10 .AND. NELESS.GT.0) THEN
C
        WRITE(NFECRA,6000)
        DO 600 I=1,NELESS
          WRITE(NFECRA,6010) I ,(NODESS(I,J),J=1,NDMASS)
 600    CONTINUE
C
      ENDIF  
C
C--------
C FORMATS
C--------
 3000 FORMAT(/,' %% ERREUR XMAILL : DIMENSION DU PROBLEME INCOHERENTE')
 4000 FORMAT(/,' %% ERREUR XMAILL : LA DIMENSION DU TABLEAU DES ',
     &           'ELEMENTS DE BORD COUPLES (NELESS) EST INSUFFISANTE',/,
     &         '                    IL VAUT     : ',I10,/,
     &         '                    IL FAUDRAIT : ',I10)
 4010 FORMAT(/,' %% ERREUR XMAILL : LA DIMENSION DU TABLEAU DES ',
     &         'ELEMENTS DE BORD AVEC FLUX (NELEUS) EST INSUFFISANTE',/,
     &         '                    IL VAUT     : ',I10,/,
     &         '                    IL FAUDRAIT : ',I10)
 4020 FORMAT(/,' %% ERREUR XMAILL : LA DIMENSION DU TABLEAU DES ',
     &  'ELEMENTS DE BORD AVEC RESISTANCE (NELERC) EST INSUFFISANTE',/,
     &         '                    IL VAUT     : ',I10,/,
     &         '                    IL FAUDRAIT : ',I10)
 4030 FORMAT(/,' %% ERREUR XMAILL : LA DIMENSION DU TABLEAU DES ',
     &  'ELEMENTS DE BORD AVEC RAYONNEMENT (NELERA) EST INSUFFISANTE',/,
     &         '                    IL VAUT     : ',I10,/,
     &         '                    IL FAUDRAIT : ',I10)
 5000 FORMAT(//,' *** XMAILL : MAILLAGE ELEMENTS FINIS SURFACIQUE ',
     &     'DU SOLIDE :')
 5010 FORMAT(
     &  8X,'- Nombre d''elements de surface couples         : ',I10,/,
     &  8X,'- Nombre d''elements de surface avec flux       : ',I10,/,
     &  8X,'- Nombre d''elements de surface avec resistance : ',I10,/,
     &  8X,'- Nombre d''elements de surface avec rayonnement: ',I10)

 6000 FORMAT(/,' *** XMAILL : VERIFICATION DU MAILLAGE SOLIDE',
     &         ' DE SURFACE DES NOEUDS COUPLES',/,
     &         '              Table des elements : '/)
 6010 FORMAT(  '              Element ',I10,'  Noeuds : ',6I10)
C
      END
