C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C
                        SUBROUTINE LECID1
C                       *****************
C
C     ----------------------------------------------------------------
     *(NPOINS,NELEMS,NFBIDA,NDIELE)
C     ----------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             1ere LECTURE DU MAILLAGE ELEMENTS FINIS                  *
C             --> STRUCTURE DE DONNEE ISSUE DE IDEAS                   *
C             (Necessaire pour les dimensionnements de tableaux)       *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  A        ! TR ! A  ! TABLEAU DE TRAVAIL REEL                      !
C !  ILONRA   !  E ! D  ! DIMENSION DE A                               !
C !  IA       ! TE ! A  ! TABLEAUX DE TRAVAIL ENTIER                   !
C !  ILONIA   !  E ! D  ! DIMENSION DE IA                              !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : CMPTNO,CMPTEL,CMPTFA,INREFA
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "mobil.h"
#include "xrefer.h"
#include "nlofes.h"
#include "nlofct.h"
#include "optct.h"
C
C***********************************************************************
C 
C.. Variables externes
      INTEGER NPOINS,NELEMS,NDIELE
C
C.. Variables internes
      INTEGER NDSR,ITYE,NUM,ID,N1,N2,ICOU,NBNO
      CHARACTER*80 CH
C
      INTEGER NFBIDA,NUMP,NELEP
C***********************************************************************
C
C     0- INITIALISATIONS
C     ==================
      NFBIDA = 0
      NUMP = 0
C
      REWIND (NFSGCT)

C     1- TABLE DES NOEUDS
C     ===================
C
      CALL SECIDE(NFSGCT,2411)
C
   12 READ(NFSGCT,1200,ERR=19,END=19) NUM,N1,N1,N1
      READ(NFSGCT,1201,ERR=19,END=19) CH
      IF (NUM .EQ. -1) THEN
        GOTO 19
      ELSE
        NPOINS = NPOINS + 1
        NUMP = NUM
        GOTO 12
      ENDIF
C
   19 CONTINUE
      IF (NPOINS .NE. NUMP) THEN
         WRITE(NFECRA,2016) 
         STOP
      ENDIF
C
      CALL SECIDE(NFSGCT,2411)
C
C     2- TABLE DES ELEMENTS
C     =====================
C
      CALL SECIDE(NFSGCT,2412)
C
      NDSR=0
      NELEMS = 0
C
   22 READ(NFSGCT,4200,ERR=28,END=28) NUM,ID,N1,N2,ICOU,NBNO
      IF (NUM .EQ. -1) THEN
        GOTO 28
      ELSE
C
         IF(NDIELE.EQ.3)THEN 
            IF (ID.EQ.118) THEN 
               NELEMS = NELEMS + 1
               NELEP = NUM
            ELSE IF(ID.EQ.92) THEN
               IF (LCFACE) THEN
                  NFBIDA = NFBIDA + 1
               ELSE
                  WRITE(NFECRA,2023)
               ENDIF
            ELSE 
               WRITE(NFECRA,2022)
               STOP
            ENDIF
         ENDIF
C
         IF(NDIELE.EQ.2)THEN 
            IF (ID.EQ.92) THEN 
               NELEMS = NELEMS + 1
               NELEP = NUM
            ELSE IF(ID.EQ.24) THEN
               IF (LCFACE) THEN
                  NFBIDA = NFBIDA + 1
               ELSE
                  WRITE(NFECRA,2023) 
               ENDIF
            ELSE
               WRITE(NFECRA,2022)
               STOP
            ENDIF
         ENDIF
C
         IF (NELEMS .NE. NELEP) THEN
            WRITE(NFECRA,2017) 
            STOP
         ENDIF
C        
         NDSR=MAX(NDSR,ICOU)
         READ(NFSGCT,1201,ERR=28,END=28) CH
         IF (NDIELE.EQ.3) THEN
            IF (ID.EQ.118) THEN
               READ(NFSGCT,1201,ERR=28,END=28) CH
            ENDIF
            ITYE   = ID
            GOTO 22
         ELSE IF (NDIELE.EQ.2) THEN
            IF (ID.EQ.24) THEN
               READ(NFSGCT,1201,ERR=28,END=28) CH
            ENDIF
            ITYE   = ID
            GOTO 22
         ENDIF
      ENDIF
   28 CONTINUE
C      
C     4.1.1- VERIFICATIONS DIVERSES
C     -----------------------------
C
CIR          IF (NDIMEF.EQ.2 .AND. NDIM.NE.2) THEN
CIR             WRITE(NFECRA,2018)
CIR             STOP
CIR          ENDIF
C
          IF (NDSR.GT.NRFMAX) THEN
             WRITE(NFECRA,2020)
             STOP
          ENDIF
C
chp          IF (ITYE.NE.92 .AND. ITYE.NE.118) THEN
chp             WRITE(NFECRA,2023)
chp             STOP
chp          ENDIF
C
CC
C--------
C FORMATS
C--------
C 
 1200 FORMAT(4I10)
 1201 FORMAT(A80)
C
 2016 FORMAT(/,'  %% ERREUR LECID1 : Il est vraisemblable que le ',
     &       'maillage comporte une numerotation non continue ',
     &        'des noeuds')
 2017 FORMAT(/,'  %% ERREUR LECID1 : Il est vraisemblable que le ',
     &       'maillage comporte une numerotation non continue ',
     &        'des elements')
 2018 FORMAT(/,'  %% ERREUR LECID1 : DIMENSION DES MAILLAGES ',
     &       'INCOMPATIBLES')
 2020 FORMAT(/,'  %% ERREUR LECID1 : NUMERO(S) DE REFERENCES > 99')      
 2022 FORMAT(/,'  %% ERREUR LECID1 : UTILISATION D''ELEMENTS ',
     &                              'NON CONFORMES')
 2023 FORMAT(/,'  %% WARNING LECID1 : UTILISATION D''ELEMENTS ',
     &                              'NON CONFORMES POUR LES ',
     &                               'OPTIONS DU CALCUL')
C 
 4200 FORMAT(6I10)
 4201 FORMAT(8I10)
C
      END
