<?php

namespace Symfony\Component\Serializer\Tests\CacheWarmer;

use PHPUnit\Framework\TestCase;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerInterface;
use Symfony\Component\Serializer\CacheWarmer\CompiledClassMetadataCacheWarmer;
use Symfony\Component\Serializer\Mapping\Factory\ClassMetadataFactoryCompiler;
use Symfony\Component\Serializer\Mapping\Factory\ClassMetadataFactoryInterface;

final class CompiledClassMetadataCacheWarmerTest extends TestCase
{
    public function testItImplementsCacheWarmerInterface()
    {
        $classMetadataFactory = $this->createMock(ClassMetadataFactoryInterface::class);
        $filesystem = $this->createMock(Filesystem::class);

        $compiledClassMetadataCacheWarmer = new CompiledClassMetadataCacheWarmer([], $classMetadataFactory, new ClassMetadataFactoryCompiler(), $filesystem);

        $this->assertInstanceOf(CacheWarmerInterface::class, $compiledClassMetadataCacheWarmer);
    }

    public function testItIsAnOptionalCacheWarmer()
    {
        $classMetadataFactory = $this->createMock(ClassMetadataFactoryInterface::class);
        $filesystem = $this->createMock(Filesystem::class);

        $compiledClassMetadataCacheWarmer = new CompiledClassMetadataCacheWarmer([], $classMetadataFactory, new ClassMetadataFactoryCompiler(), $filesystem);

        $this->assertTrue($compiledClassMetadataCacheWarmer->isOptional());
    }

    public function testItDumpCompiledClassMetadatas()
    {
        $classMetadataFactory = $this->createMock(ClassMetadataFactoryInterface::class);

        $code = <<<EOF
<?php

// This file has been auto-generated by the Symfony Serializer Component.

return [
];
EOF;

        $filesystem = $this->createMock(Filesystem::class);
        $filesystem
            ->expects($this->once())
            ->method('dumpFile')
            ->with('/var/cache/prod/serializer.class.metadata.php', $code)
        ;

        $compiledClassMetadataCacheWarmer = new CompiledClassMetadataCacheWarmer([], $classMetadataFactory, new ClassMetadataFactoryCompiler(), $filesystem);

        $compiledClassMetadataCacheWarmer->warmUp('/var/cache/prod');
    }
}
