/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SWITCHDIALOG_H
#define _SC_SWITCHDIALOG_H

// sc
class RevisionWidget;
class ExternProvider;
class ExternButton;
namespace svn
{
  class Revision;
}

// qt
#include <QtGui/QDialog>
class QComboBox;
class QCheckBox;
class QPushButton;


class SwitchDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  SwitchDialog( ExternProvider* p, bool recurse, QWidget *parent = 0 );
  virtual ~SwitchDialog();

  void enableRepositoryUrl( bool enable );
  void enableWorkingCopyPath( bool enable );

  QString getRepositoryUrl();
  void setRepositoryUrl( QString& url );

  QString getWorkingCopyPath();
  void addWorkingCopyPath( const QString& url );

  svn::Revision* getRevision();
  bool isRecursive();

public slots:
  void selectWcPath();
  void checkOk( const QString& text );

private slots:
  void repExtern();

private:
  void handleExtern( QComboBox* e );

private:
  RevisionWidget* _rw;

  QCheckBox*      _recurse;
  QComboBox*      _rep;
  ExternButton*   _repEx;
  QComboBox*      _wc;
  ExternButton*   _wcEx;

  QPushButton*    _ok;

  ExternProvider* _p;
};

#endif // _SC_SWITCHDIALOG_H
