% -----------------------------------------------------------------------------
%  (C) Altran Praxis Limited
% -----------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
% =============================================================================


%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Provides access to all system information. This is information that is
% specific to the particular build or running process.
%###############################################################################


%###############################################################################
% MODULE
%###############################################################################
:- module(data__system, [get_system_start_date_time/2,
                         add_system_start_date_time/2,
                         get_system_toolname/1,
                         add_system_toolname/1,

                         save_data__system/0]).

%###############################################################################
% DEPENDENCIES
%###############################################################################

:- use_module('data__formats.pro',
              [add_state/2]).

:- use_module('ioutilities.pro',
              [write_terms_to_file/2]).

:- use_module('data__data_files.pro',
              [must_get_datafiles_debug/2]).


%###############################################################################
% TYPES
%###############################################################################


%###############################################################################
% DATA
%###############################################################################

:- add_state(get_system_start_date_time,
             get_system_start_date_time('NowDate_Atom', 'NowTime_Atom')).
:- dynamic(get_system_start_date_time/2).

:- add_state(get_system_toolname,
             get_system_toolname('ToolName_Atom')).
:- dynamic(get_system_toolname/1).


%###############################################################################
% PREDICATES
%###############################################################################


%===============================================================================
% Add.
%===============================================================================

add_system_start_date_time(NowDate_Atom, NowTime_Atom):-
    assert(get_system_start_date_time(NowDate_Atom, NowTime_Atom)),
    !.

add_system_toolname(ToolName_Atom):-
    assert(get_system_toolname(ToolName_Atom)),
    !.
%===============================================================================


%===============================================================================
% save_data__system.
%===============================================================================

save_data__system:-
    must_get_datafiles_debug(data__system, DebugFile_Atom),
    write_terms_to_file(DebugFile_Atom,
                        [data__system:get_system_start_date_time/2,
                         data__system:get_system_toolname/1]),
    !.
%===============================================================================


%###############################################################################
% END-OF-FILE
