-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--------------------------------------------------------------------------------
--  Synopsis:                                                                 --
--                                                                            --
--  Package to scan a directory.                                              --
--                                                                            --
--------------------------------------------------------------------------------

with Heap;

--# inherit E_Strings,
--#         FatalErrors,
--#         FileDetails,
--#         FileHeap,
--#         Heap,
--#         OSFiling;

package OSDirectory is

   ------------------------------------------------------------------------
   -- this procedure reads the named directory using the C calls
   -- opendir(), readdir() and closedir()
   -- for each entry, it calls OSFiling.IsDirectory and then enters it in the
   -- linked list
   ------------------------------------------------------------------------
   procedure Scan (ListIndex : in Heap.Atom);
   --# global in     OSFiling.File_Structure;
   --#        in out FatalErrors.State;
   --#        in out FileHeap.State;
   --# derives FatalErrors.State,
   --#         FileHeap.State    from *,
   --#                                ListIndex,
   --#                                OSFiling.File_Structure;

end OSDirectory;
