-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

package body SPARK.Ada.Strings.Not_SPARK is
   --# hide SPARK.Ada.Strings.Not_SPARK;

   ------------------------------------------------
   -- Conversion functions from SPARK.Ada to Ada --
   ------------------------------------------------

   function To_Alignment
     (From : Alignment) return Standard.Ada.Strings.Alignment is
   begin
      case From is
         when Alignment_Left =>
            return Standard.Ada.Strings.Left;
         when Alignment_Right =>
            return Standard.Ada.Strings.Right;
         when Alignment_Center =>
            return Standard.Ada.Strings.Center;
      end case;
   end To_Alignment;

   function To_Truncation
     (From : Truncation) return Standard.Ada.Strings.Truncation is
   begin
      case From is
         when Truncation_Left =>
            return Standard.Ada.Strings.Left;
         when Truncation_Right =>
            return Standard.Ada.Strings.Right;
         when Truncation_Error =>
            return Standard.Ada.Strings.Error;
      end case;
   end To_Truncation;

   function To_Membership
     (From : Membership) return Standard.Ada.Strings.Membership is
   begin
      case From is
         when Membership_Inside =>
            return Standard.Ada.Strings.Inside;
         when Membership_Outside =>
            return Standard.Ada.Strings.Outside;
      end case;
   end To_Membership;

   function To_Direction
     (From : Direction) return Standard.Ada.Strings.Direction is
   begin
      case From is
         when Direction_Forward =>
            return Standard.Ada.Strings.Forward;
         when Direction_Backward =>
            return Standard.Ada.Strings.Backward;
      end case;
   end To_Direction;

   function To_Trim_End
     (From : Trim_End) return Standard.Ada.Strings.Trim_End is
   begin
      case From is
         when Trim_End_Left =>
            return Standard.Ada.Strings.Left;
         when Trim_End_Right =>
            return Standard.Ada.Strings.Right;
         when Trim_End_Both =>
            return Standard.Ada.Strings.Both;
      end case;
   end To_Trim_End;

end SPARK.Ada.Strings.Not_SPARK;
