-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Dictionary;
with Heap;
with SeqAlgebra;

--# inherit Statistics,
--#         Dictionary,
--#         Heap,
--#         SeqAlgebra;

--  This is a set of Dictionary.Symbol objects built on top of Heap
--  and SeqAlgebra.

package Symbol_Set
is
   type T is private;

   procedure Initialise (The_Set : out T);
   --# global in out Statistics.TableUsage;
   --# derives Statistics.TableUsage from * &
   --#         The_Set               from ;

   procedure Add (The_Set : in out T;
                  Sym     : in     Dictionary.Symbol);
   --# global in out Statistics.TableUsage;
   --# derives Statistics.TableUsage,
   --#         The_Set               from *,
   --#                                    Sym,
   --#                                    The_Set;

   procedure Remove (The_Set : in out T;
                     Sym     : in     Dictionary.Symbol);
   --# derives The_Set from *,
   --#                      Sym;

   function Contains (The_Set : in T;
                      Sym     : in Dictionary.Symbol)
                     return Boolean;

private

   type T is record
      The_Heap    : Heap.HeapRecord;
      The_Symbols : SeqAlgebra.Seq;
   end record;

end Symbol_Set;
