-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (ErrorHandler)
procedure GetFileLine is
   Cur_Line           : E_Strings.T;
   Line_No_Before_Get : LexTokenManager.Line_Numbers;
begin
   -- Handling of line containing eight-bit characters
   if SPARK_IO.End_Of_Line (Error_Context_Rec.Source) then
      SPARK_IO.Skip_Line (Error_Context_Rec.Source, 1);
      Error_Context_Rec.Line_No      := Error_Context_Rec.Line_No + 1;
      Error_Context_Rec.Current_Line := E_Strings.Empty_String;
   else
      Line_No_Before_Get := LexTokenManager.Line_Numbers (SPARK_IO.Line (Error_Context_Rec.Source));
      E_Strings.Get_Line (File  => Error_Context_Rec.Source,
                          E_Str => Cur_Line);
      Error_Context_Rec.Current_Line := Cur_Line;
      Error_Context_Rec.Line_No      := Error_Context_Rec.Line_No + 1;
      if E_Strings.Get_Length (E_Str => Error_Context_Rec.Current_Line) = 0 then
         Error_Context_Rec.Current_Line := E_Strings.Copy_String (Str => " -- *** ILLEGAL LINE REPLACED *** --");
      end if;
      if Line_No_Before_Get = LexTokenManager.Line_Numbers (SPARK_IO.Line (Error_Context_Rec.Source)) then
         SPARK_IO.Skip_Line (Error_Context_Rec.Source, 1);
      end if;
   end if;
end GetFileLine;
