2.3 Przełączanie Syntezatorów

# Przełączanie Syntezatorów

Do tej pory bawiliśmy się całkiem nieźle robiąc wiele fajnych bipów. 
Jest jednak bardzo prawdopodobne, że podstawowy dźwięk bip zaczyna 
Cię już powoli nudzić. Czy to jest wszystko co Sonic Pi ma do zaoferowania? 
Na pewno jest dużo więcej możliwości w kodowaniu na żywo niż tylko 
granie bipów? Owszem, są inne możliwości i to jest rozdział, w którym 
poznasz fascynującą paletę dźwięków, jakie Sonic Pi ma do zaoferowania.

## Syntezatory

Sonic Pi posiada szeroki wachlarz instrumentów, które nazywa syntezatorami. 
Zważywszy na to, że sample (próbki) reprezentują nagrane dźwięki, 
syntezatory mają możliwość generowania nowych dźwięków, które są zależne 
od tego jak je kontrolujesz (w tym samouczku dowiesz się o tym później). 
Syntezatory Sonic Pi są bardzo potężne i ekspresyjne. Będziesz miał dużo 
przyjemności podczas poznawania i zabawy nimi. Na początku jednak nauczmy 
się jak wybierać aktualnie grający syntezator.

## Brzęczące piły i prophety

Fajnym dźwiękiem jest *sawdźwięk piły* - spróbujmy:

```
use_synth :saw
play 38
sleep 0.25
play 50
sleep 0.25
play 62
sleep 0.25
```

A teraz spróbujmy innego dźwięku - syntezatora *prophet*: 

```
use_synth :prophet
play 38
sleep 0.25
play 50
sleep 0.25
play 62
sleep 0.25
```

Co powiesz na połączenie dwóch dźwięków. Jeden po drugim: 

```
use_synth :saw
play 38
sleep 0.25
play 50
sleep 0.25
use_synth :prophet
play 57
sleep 0.25

```

A teraz w tym samym czasie: 

```
use_synth :tb303
play 38
sleep 0.25
use_synth :dsaw
play 50
sleep 0.25
use_synth :prophet
play 57
sleep 0.25
```

Zauważ, że polecenie `use_synth` wywiera wpływ tylko na kolejne wywołania 
poleceń `play`. Pomyśl o tym poleceniu jako o *dużym przełączniku* - kolejne 
wywołania polecenia `play` będą odtwarzać dowolny syntezator, który jest 
w danym momencie wskazany. Możesz zmienić aktualny syntezator na inny 
używając przełącznika `use_synth`.

## Odkrywanie Syntezatorów (Synths)

Aby zobaczyć jakie syntezatory Sonic Pi ma dla Ciebie do zabawy zerknij 
na opcję Synth w lewym dolnym rogu (obok Fx). Znajdziesz tam ponad 20 
do wyboru. Oto kilka moich ulubionych:

* `:prophet`
* `:dsaw`
* `:fm`
* `:tb303`
* `:pulse`

Tera pobaw się *zmieniając syntezatory w trakcie odtwarzania twojej 
muzyki*. Próbuj bawić się łącząc ze sobą różne dźwięki aby tworzyć 
nowe brzmienia jak również używająć różnych syntezatorów w różnych 
sekcjach twojego utworu.
