7.3 Paramètres glissants

# Paramètres glissants


Pendant l'exploration des arguments de pilotage des synthés et des FX, 
vous pourriez avoir remarqué qu'il y a un certain nombre de paramètres 
finissant par `_slide`. Vous avez peut-être même essayé de les appeler et 
n'avez constaté aucun effet. C'est parce que ce ne sont pas des 
paramètres normaux, ce sont des paramètres spéciaux qui n'agissent 
que quand vous contrôlez les synthés comme cela est décrit 
dans la section précédente.

Considérez l'exemple suivant :

```
s = play 60, release: 5
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```

Ici, vous pouvez entendre la hauteur du son changer instantanément 
après l'appel à `control`. Toutefois, nous pourrions souhaiter que la 
hauteur glisse entre les changements. Comme nous sommes en train de 
contrôler le paramètre `note:`, pour ajouter un glissement, nous 
devons fixer le paramètre `note_slide` du synthé :

```
s = play 60, release: 5, note_slide: 1
sleep 0.5
control s, note: 65
sleep 0.5
control s, note: 67
sleep 3
control s, note: 72
```

Maintenant, nous entendons la hauteur des notes glisser entre les 
appels à `control`. Ça sonne agréablement, n'est-ce pas ? Vous pouvez 
accélérer le glissement en utilisant une durée plus courte comme 
`note_slide: 0.2` ou le ralentir en utilisant une durée de glissement 
plus longue.

Chaque paramètre qui peut être contrôlé a un paramètre correspondant 
avec `_slide` à votre disposition.

## Le glissement est rémanent

Une fois que vous avez fixé un paramètre `_slide` à un synthé en 
cours de jeu, il sera mémorisé et appliqué à chaque fois que le 
paramètre correspondant sera utilisé. Pour arrêter le glissement, 
vous devez fixer la valeur de `_slide` à 0 avant l'appel suivant à 
`control`.

## Paramètres FX glissants

Il est aussi possible de faire glisser les paramètres FX :

```
with_fx :wobble, phase: 1, phase_slide: 5 do |e|
  use_synth :dsaw
  play 50, release: 5
  control e, phase: 0.025
end
```

Maintenant ayez du plaisir à faire glisser les choses pour obtenir des 
transitions douces et un contrôle fluide...
