5.3 Condicionales

# condicionales

Algo común que seguramente querrás hacer es tocar más que notas al azar
sino también tomar decisiones al azar y, dependiendo de cómo salga,
correr más código u otro código. Por ejemplo, el querer tocar al azar
una batería o platillo. Esto lo podemos hacer con `if` .

## Tirar una moneda

Tiremos una moneda: si sale cara, que suene una batería, si sale cruz,
que sea un platillo. Fácil. Podemos imitar el tiro de una moneda con
la función `one_in` (introducida en la sección de aleatoriedad)
especificando una probabilidad de 1 en 2 `one_in(2)`. Entonces podemos
utilizar el resultado para decidir entre dos piezas de código, el de
batería o el de platillos:


```
loop do

  if one_in(2)
    sample :drum_heavy_kick
  else
    sample :drum_cymbal_closed
  end
  
  sleep 0.5
  
end
```

Debes notar que los `if` están compuestos  de tres partes:

* La pregunta a hacer
* La primera elección de código a correr (si la respuesta es 'si')
* La segunda elección de código a correr (si la respuesta es 'no')

Típico de lenguajes de programación, la noción de 'sí' está representada
por el término `true` y la noción de 'no', por `false`. Así que debemos
encontrar una pregunta que nos dé una respuesta `true` o`false` que es
exactamente lo que hace `one_in` .

¿notas que la primera opción está envuelta entre el `if` y el `else`
y que la segunda opción está envuelta entre el `else` y el `end`?. Igual 
que con los bloques do/end puedes poner múltiples líneas de código en 
cualquiera de esos lugares. Por ejemplo:

```
loop do

  if one_in(2)
    sample :drum_heavy_kick
    sleep 0.5
  else
    sample :drum_cymbal_closed
    sleep 0.25
  end
  
end
```

Esta vez estaremos pausando por un tiempo distinto dependiendo de cuál
elección hagamos.


## Condicional simple "if"

Algunas veces querrás ejecutar sólo una línea de código. Esto es posible
al colocar `if` y después la pregunta al final. Por ejemplo:

```
use_synth :dsaw

loop do
  play 50, amp: 0.3, release: 2
  play 53, amp: 0.3, release: 2 if one_in(2)
  play 57, amp: 0.3, release: 2 if one_in(3)
  play 60, amp: 0.3, release: 2 if one_in(4)
  sleep 1.5
end
```

Eso tocará acordes de diferentes números con una probabilidad diferente
para cada nota .
