#include "snd.h"


/* -------------------------------- PROGRAM ICON -------------------------------- 
 *
 * apparently only a GdkPixbuf can be a program icon in Gtk?
 */

static const char *snd_icon_xpm[] = {
"48 48 5 1",
". c white m white",
"B c black m black",
"a c white m white s basiccolor",
"r c red m black s cursorcolor",
"g c lightblue m black s listenercolor",
"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB............BBBB.........................a",
"aaBBBB..........BB....BB.......................a",
"aaBBBB........BB.......BB......................a",
"aaBBBB......BB..........BB.....................a",
"aaBBBB.....BB............BB....................a",
"aaBBBB....BB.............BB....................a",
"aaBBBB...BB..............BB....................a",
"aaBBBB..BB................BB...................a",
"aaBBBBBB..................BB...................a",
"aaBBBB.....................BB..................a",
"aaBBBB.....................BB.................Ba",
"aaBBBB......................BB...............BBa",
"aaBBBB.......................BB.............BB.a",
"aaBBBB.........................BB..........BB..a",
"aaBBBB..........................BB.......BB....a",
"aaBBBB...........................BB....BB......a",
"aaBBBB.............................BBB.........a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBaa",
"aaBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBaa",
"aaaaaa.........................................a",
"aaaaaa.........................................a",
"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"aggggggggggggggggggggggggggggggggggggggggggggggg",
"aggggggggggggggggggggggggggggggggggggggggggggggg",
"aggggggggggggggggggggggggggggggggggggggggggggggg",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"};

const char **snd_icon_bits(void) {return(snd_icon_xpm);}



#if USE_MOTIF

#include <X11/xpm.h>

static const char *mini_lock_xpm[] = {
"16 14 5 1",
"-      c None s None",
".	c gray50",
"X	c black",
"o	c white",
"O	c yellow",
"------.XXX.-----",
"-----X.ooo.X----",
"----..oXXXo..---",
"----XoX...XoX---",
"----XoX.--XoX.--",
"----XoX.--XoX.--",
"---XXXXXXXXXXX--",
"---XOOOOOOOOOX.-",
"---XO.......OX.-",
"---XOOOOOOOOOX.-",
"---XO.......OX.-",
"---XOOOOOOOOOX.-",
"---XXXXXXXXXXX.-",
"----...........-"};

const char **mini_lock_bits(void) {return(mini_lock_xpm);}


static const char * close_icon_xpm[] = {
"16 14 5 1",
"-      c None s None",
".	c gray50",
"X	c black",
"o	c white",
"O	c yellow",
"----------------",
"----------------",
"----------------",
"--XX.------XX.--",
"---XX.----XX.---",
"----XX.--XX.----",
"-----XX.XX.-----",
"------XXX.------",
"------XXX.------",
"-----XX.XX.-----",
"----XX.--XX.----",
"---XX.----XX.---",
"--XX.------XX.--",
"----------------"};

const char **close_icon_bits(void) {return(close_icon_xpm);}


static const char *blank_xpm[] = {
"18 18 5 1",
"-      c None s None",
".	c gray50",
"X	c black",
"o	c white",
"O	c yellow",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------"};

const char **blank_bits(void) {return(blank_xpm);}


/* bomb for out-of-date in-core data fuse shortens with sparks flying off; */

static const char * mini_bomb0_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...------","------.---.-----","-----.-----.----","----...-----.---","---.....----.---","--.X#o...----.--","-X.#X....X---.--",
"-..oX.....---O-O","-.......O.-O-OO-","-......Xo.--OOO-","-X.....X.X--O---","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb1_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...------","------.---.-----","-----.-----.----","----...-----.---","---.....----.---","--.X#o...----.--","-X.#X....X---Y--",
"-..oX.....---YYY","-.......O.-YYOOY","-......Xo.--OOY-","-X.....X.X--Y---","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb2_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...------","------.---.-----","-----.-----.----","----...-----.---","---.....----.---","--.X#o...----Y--","-X.#X....X---YY-",
"-..oX.....---OYO","-.......O.--O-OO","-......Xo.--Y-Y-","-X.....X.X------","--.......----Y--","---X...X--------","----------------"};

static const char * mini_bomb3_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...------","------.---.-----","-----.-----.----","----...-----.---","---.....----.---","--.X#o...----Y--","-X.#X....X---OO-",
"-..oX.....-YYYYO","-.......O.----O-","-......Xo.----O-","-X.....X.X----Y-","--.......-------","---X...X--------","------------YY--"};

static const char * mini_bomb4_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...------","------.---.-----","-----.-----.--Y-","----...-----.---","---.....----O---","--.X#o...---OO--","-X.#X....X-YOYO-",
"-..oX.....--OYY-","-.......O.------","-......Xo.-Y----","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb5_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...------","------.---.-----","-----.-----.----","----...-----Y---","---.....----OO--","--.X#o...--OOO--","-X.#X....X---YO-",
"-..oX.....---YY-","-.......O.-----Y","-......Xo.-----O","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb6_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...------","------.---.-----","-----.-----OO-O-","----...-----YO--","---.....----O---","--.X#o...-YY-OO-","-X.#X....X--Y---",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......-----OO","---X...X------Y-","----------------"};

static const char * mini_bomb7_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...----OO","------.---O-----","-----.-----OOYY-","----...-----YOO-","---.....-YY-O---","--.X#o...-------","-X.#X....X--YO--",
"-..oX.....---Y--","-.......O.------","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","--------------YY"};

static const char * mini_bomb8_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------..Y------","------.--OO-----","-----.----OOO-Y-","----...---OO--O-","---.....-YY----O","--.X#o...-------","-X.#X....X------",
"-..oX.....--YO--","-.......O.---O--","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb9_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------YOY--O---","------.---YO----","-----.----OYY---","----...---------","---.....----YY--","--.X#o...-------","-X.#X....X------",
"-..oX.....------","-.......O.--YO--","-......Xo.---Y--","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb10_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-----OYYOYOO----","-----YOO--YO----","-----.-----YY---","----...---------","---.....--------","--.X#o...----OO-","-X.#X....X---Y--",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb11_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-----OOYOO--O---","----OOY----O----","---OOOO---------","----...---------","---.....--------","--.X#o...-------","-X.#X....X------",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......---OO--","---X...X--------","----------------"};

static const char * mini_bomb12_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-----OO---------","--YYOOYYY-------","YYOOOOYYYY------","--OOOOO---------","---.....--------","--.X#o...-------","-X.#X....X------",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","------------YY--"};

static const char * mini_bomb13_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"----------------","----OOY---------","--YYYYY-Y-------","--Y-OOO---------","---.YOY.--------","--.X#o...-------","-X.#X....X------",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb14_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"----------------","----------------","----------------","----------------","---.....--------","--.X#o...-------","-X.#X....X------",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","----------------"};

const char **mini_bomb_bits(int n)
{
  switch (n)
    {
    case 0: return(mini_bomb0_xpm); break;
    case 1: return(mini_bomb1_xpm); break;
    case 2: return(mini_bomb2_xpm); break;
    case 3: return(mini_bomb3_xpm); break;
    case 4: return(mini_bomb4_xpm); break;
    case 5: return(mini_bomb5_xpm); break;
    case 6: return(mini_bomb6_xpm); break;
    case 7: return(mini_bomb7_xpm); break;
    case 8: return(mini_bomb8_xpm); break;
    case 9: return(mini_bomb9_xpm); break;
    case 10: return(mini_bomb10_xpm); break;
    case 11: return(mini_bomb11_xpm); break;
    case 12: return(mini_bomb12_xpm); break;
    case 13: return(mini_bomb13_xpm); break;
    case 14: return(mini_bomb14_xpm); break;
    default: return(NULL); break;
    }
}


static const char * mini_glass0_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOOOOOOOOO.c-","-.cOOOOOOOOOOc.-","--cOOOOOOOOOOc--","----cOOOOOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooooooooc---","--cooooooooooc--","-.cooooooooooc.-","-cooooooooooooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass1_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOOOoOOOOO.c-","-.cOOOOOOOOOOc.-","--cOOOOOOOOOOc--","----cOOOOOOc----","-----.coOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---coooOooooc---","--cooooooooooc--","-.cooooooooooc.-","-coooooOooooooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass2_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOOOoooOOO.c-","-.cOOOOOOOOOOc.-","--cOOOOOOOOOOc--","----cOOOOOOc----","-----.cOoc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooooooooc---","--cooooooooooc--","-.cooooOoooooc.-","-cooooOOOoooooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass3_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOOoooOOOO.c-","-.cOOOOooOOOOc.-","--cOOOOOOOOOOc--","----cOOOOOOc----","-----.coOc.-----","-------cc-------",
"-----.cOoc.-----","----cooooooc----","---cooooooooc---","--cooooooooooc--","-.coooOooooooc.-","-coooOOOOoooooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass4_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOOooooOOO.c-","-.cOOOOoooOOOc.-","--cOOOOOoOOOOc--","----cOOoOOOc----","-----.cOOc.-----","-------cc-------",
"-----.coOc.-----","----cooooooc----","---cooooooooc---","--cooooooooooc--","-.coooOOOooooc.-","-coooOOOOoooooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass5_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOOoooooOO.c-","-.cOOOOooooOOc.-","--cOOOOOoOOOOc--","----cOOOOOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooooooooc---","--coooOooooooc--","-.coooOOOOoooc.-","-coooOOOOOooooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass6_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOOoooooOO.c-","-.cOOOOooooOOc.-","--cOOOOoooOOOc--","----cOOOOoOc----","-----.cOOc.-----","-------cc-------",
"-----.cOoc.-----","----coooOooc----","---cooooooooc---","--cooooooooooc--","-.coooOOOOoooc.-","-coooOOOOOOoooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass7_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOooooooOO.c-","-.cOOOoooooOOc.-","--cOOOOoOoOOOc--","----cOOoOOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooooOoooc---","--coooOOoooooc--","-.cooOOOOOoooc.-","-cooOOOOOOOoooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass8_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OoooooooOO.c-","-.cOOooooooOOc.-","--cOOOooooOOOc--","----cOOOOOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooooooooc---","--coooOOOooooc--","-.cooOOOOOoooc.-","-cooOOOOOOOOOoc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass9_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.ooooooooOO.c-","-.cOoooooooOOc.-","--cOOoooooOOOc--","----cOOoOOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooOoooc----","---cooooooooc---","--cooOOOOOOOoc--","-.coOOOOOOOOooc.-","-coOOOOOOOOOOOoc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass10_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.oooooooooo.c-","-.cOoooooooooc.-","--cOOooooooOOc--","----cOOooOOc----","-----.coOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooOOOOooc---","--cooOOOOOOooc--","-.coOOOOOOOOoc.-","-cOOOOOOOOOOOoc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass11_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.oooooooooo.c-","-.cooooooooooc.-","--cOOooooooooc--","----cOOooOOc----","-----.coOc.-----","-------cc-------",
"-----.cooc.-----","----cooOoooc----","---cooOOOOooc---","--coOOOOOOOooc--","-.cOOOOOOOOOoc.-","-cOOOOOOOOOOOoc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass12_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.oooooooooo.c-","-.cooooooooooc.-","--cooooooooooc--","----cOoooOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooOOooc----","---coOOOOOooc---","--cOOOOOOOOOoc--","-.cOOOOOOOOOOc.-","-cOOOOOOOOOOOOc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass13_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.oooooooooo.c-","-.cooooooooooc.-","--cooooooooooc--","----cooooooc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooOOooc----","---cOOOOOOOOc---","--cOOOOOOOOOOc--","-.cOOOOOOOOOOc.-","-cOOOOOOOOOOOOc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass14_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.oooooooooo.c-","-.cooooooooooc.-","--cooooooooooc--","----cooooooc----","-----.cooc.-----","-------cc-------",
"-----.cOOc.-----","----cOOOOOOc----","---cOOOOOOOOc---","--cOOOOOOOOOOc--","-.cOOOOOOOOOOc.-","-cOOOOOOOOOOOOc-","-XXXXXXXXXXXXXX-"};

const char **mini_glass_bits(int n)
{
  switch (n)
    {
    case 0: return(mini_glass0_xpm); break;
    case 1: return(mini_glass1_xpm); break;
    case 2: return(mini_glass2_xpm); break;
    case 3: return(mini_glass3_xpm); break;
    case 4: return(mini_glass4_xpm); break;
    case 5: return(mini_glass5_xpm); break;
    case 6: return(mini_glass6_xpm); break;
    case 7: return(mini_glass7_xpm); break;
    case 8: return(mini_glass8_xpm); break;
    case 9: return(mini_glass9_xpm); break;
    case 10: return(mini_glass10_xpm); break;
    case 11: return(mini_glass11_xpm); break;
    case 12: return(mini_glass12_xpm); break;
    case 13: return(mini_glass13_xpm); break;
    case 14: return(mini_glass14_xpm); break;
    default: return(NULL); break;
    }
}

/* from HView */
/* there are at least 3 stop signs in Snd.  This one for the Motif name-box,
 *    the big one for the toolbar (below), and the gtk built-in stop sign
 *    for the gtk name-box.
 */
static const char *stop_sign_xpm[] = {
"17 17 3 1",
"-      c None s None",
".      c red",
"X      c white",
"----XXXXXXXXX----",
"---X.........X---",
"--X...........X--",
"-X.............X-",
"X...............X",
"X...............X",
"X.XX.XXX.XX..XX.X",
"X.X...X.X..X.X.XX",
"X..X..X.X..X.XX.X",
"X.XX..X..XX..X..X",
"X...............X",
"X...............X",
"X...............X",
"-X.............X-",
"--X...........X--",
"---X.........X---",
"----XXXXXXXXX----"};

const char **stop_sign_bits(void) {return(stop_sign_xpm);}



/* these are taken mainly from emacs */

static const char *zoom_in_xpm[] = {
"24 24 132 2",
"  	c None",
". 	c #343434",
"+ 	c #2D2D2D",
"@ 	c #292929",
"# 	c #262626",
"$ 	c #2E2E2E",
"% 	c #303030",
"& 	c #737373",
"* 	c #A1A1A1",
"= 	c #B4B4B4",
"- 	c #B2B2B2",
"; 	c #9D9D9D",
"> 	c #676767",
", 	c #202020",
"' 	c #1C1C1C",
") 	c #272727",
"! 	c #616161",
"~ 	c #CACACA",
"{ 	c #CFCFCF",
"] 	c #D0D0D0",
"^ 	c #CECECE",
"/ 	c #C9C9C9",
"( 	c #C1C1C1",
"_ 	c #A7A7A7",
": 	c #4C4C4C",
"< 	c #131313",
"[ 	c #222222",
"} 	c #757575",
"| 	c #D3D3D3",
"1 	c #DBDBDB",
"2 	c #E7E7E7",
"3 	c #EFEFEF",
"4 	c #F3F3F3",
"5 	c #F1F1F1",
"6 	c #E5E5E5",
"7 	c #D2D2D2",
"8 	c #BCBCBC",
"9 	c #5E5E5E",
"0 	c #101010",
"a 	c #212121",
"b 	c #5B5B5B",
"c 	c #CCCCCC",
"d 	c #D7D7D7",
"e 	c #F5F5F5",
"f 	c #FAFAFA",
"g 	c #FBFBFB",
"h 	c #F8F8F8",
"i 	c #F0F0F0",
"j 	c #E1E1E1",
"k 	c #C2C2C2",
"l 	c #434343",
"m 	c #0F0F0F",
"n 	c #1F1F1F",
"o 	c #B9B9B9",
"p 	c #D6D6D6",
"q 	c #F9F9F9",
"r 	c #FDFDFD",
"s 	c #454545",
"t 	c #F2F2F2",
"u 	c #ECECEC",
"v 	c #E4E4E4",
"w 	c #ABABAB",
"x 	c #0E0E0E",
"y 	c #1B1B1B",
"z 	c #6D6D6D",
"A 	c #FEFEFE",
"B 	c #FCFCFC",
"C 	c #EEEEEE",
"D 	c #E6E6E6",
"E 	c #575757",
"F 	c #090909",
"G 	c #141414",
"H 	c #A8A8A8",
"I 	c #D8D8D8",
"J 	c #F6F6F6",
"K 	c #F4F4F4",
"L 	c #DCDCDC",
"M 	c #9B9B9B",
"N 	c #060606",
"O 	c #111111",
"P 	c #C5C5C5",
"Q 	c #DFDFDF",
"R 	c #444444",
"S 	c #424242",
"T 	c #EDEDED",
"U 	c #BFBFBF",
"V 	c #C6C6C6",
"W 	c #E3E3E3",
"X 	c #414141",
"Y 	c #EAEAEA",
"Z 	c #E0E0E0",
"` 	c #BABABA",
" .	c #050505",
"..	c #0B0B0B",
"+.	c #A5A5A5",
"@.	c #D1D1D1",
"#.	c #939393",
"$.	c #020202",
"%.	c #0A0A0A",
"&.	c #5F5F5F",
"*.	c #D9D9D9",
"=.	c #EBEBEB",
"-.	c #E9E9E9",
";.	c #D4D4D4",
">.	c #000000",
",.	c #E2E2E2",
"'.	c #3F3F3F",
").	c #DADADA",
"!.	c #CBCBCB",
"~.	c #3B3B3B",
"{.	c #D5D5D5",
"].	c #C8C8C8",
"^.	c #BDBDBD",
"/.	c #515151",
"(.	c #C7C7C7",
"_.	c #CDCDCD",
":.	c #B8B8B8",
"<.	c #030303",
"[.	c #313131",
"}.	c #999999",
"|.	c #BBBBBB",
"1.	c #B6B6B6",
"2.	c #909090",
"3.	c #2B2B2B",
"4.	c #010101",
"5.	c #7A7A7A",
"6.	c #9A9A9A",
"7.	c #777777",
"8.	c #3C3C3C",
"9.	c #686868",
"0.	c #797979",
"a.	c #3A3A3A",
"                                                ",
"              . + @ # # #                       ",
"          $ % & * = - ; > , '                   ",
"        ) ! = ~ { ] ^ / ( _ : <                 ",
"      [ } ~ | 1 2 3 4 5 6 7 8 9 0               ",
"    a b c d 6 e f g f h e i j k l m             ",
"    n o p 2 q g r s s g h t u v w x             ",
"  y z 7 j e f r A s s B q e C D 1 E F           ",
"  G H I C J q B A s s g h K C D L M N           ",
"  O P Q 3 e R R s s s R l S T 6 1 U N           ",
"  x V W u t l R R R R l S X Y Z d `  .          ",
"  ..+.j 2 T 5 K J l l 4 3 u v 1 @.#.$.          ",
"  %.&.*.j D =.C 3 X X T -.v 1 ;.~ : >.          ",
"    %.= I L ,.6 D '.'.W Q ).;.!.* $.            ",
"    N ~.c 7 ;.).1 ).1 I {.] ].^.$ >.            ",
"       ./.k (.!.c _.!.!.].k :.s >.              ",
"        <.[.}.|.^.8 8 8 1.2.3.>.>.>.            ",
"          4.<.X 5.6.6.7.8.>.>.  >.>.>.>.        ",
"              >.>.>.>.>.>.        , , >.>.      ",
"                                  >.9.. >.>.    ",
"                                    >.0.a.>.>.  ",
"                                      >.9.n >.  ",
"                                        >.>.    ",
"                                                "};

static const char *zoom_out_xpm[] = {
"24 24 131 2",
"  	c None",
". 	c #343434",
"+ 	c #2D2D2D",
"@ 	c #292929",
"# 	c #262626",
"$ 	c #2E2E2E",
"% 	c #303030",
"& 	c #737373",
"* 	c #A1A1A1",
"= 	c #B4B4B4",
"- 	c #B2B2B2",
"; 	c #9D9D9D",
"> 	c #676767",
", 	c #202020",
"' 	c #1C1C1C",
") 	c #272727",
"! 	c #616161",
"~ 	c #CACACA",
"{ 	c #CFCFCF",
"] 	c #D0D0D0",
"^ 	c #CECECE",
"/ 	c #C9C9C9",
"( 	c #C1C1C1",
"_ 	c #A7A7A7",
": 	c #4C4C4C",
"< 	c #131313",
"[ 	c #222222",
"} 	c #757575",
"| 	c #D3D3D3",
"1 	c #DBDBDB",
"2 	c #E7E7E7",
"3 	c #EFEFEF",
"4 	c #F3F3F3",
"5 	c #F1F1F1",
"6 	c #E5E5E5",
"7 	c #D2D2D2",
"8 	c #BCBCBC",
"9 	c #5E5E5E",
"0 	c #101010",
"a 	c #212121",
"b 	c #5B5B5B",
"c 	c #CCCCCC",
"d 	c #D7D7D7",
"e 	c #F5F5F5",
"f 	c #FAFAFA",
"g 	c #FBFBFB",
"h 	c #F8F8F8",
"i 	c #F0F0F0",
"j 	c #E1E1E1",
"k 	c #C2C2C2",
"l 	c #434343",
"m 	c #0F0F0F",
"n 	c #1F1F1F",
"o 	c #B9B9B9",
"p 	c #D6D6D6",
"q 	c #F9F9F9",
"r 	c #FDFDFD",
"s 	c #FCFCFC",
"t 	c #F2F2F2",
"u 	c #ECECEC",
"v 	c #E4E4E4",
"w 	c #ABABAB",
"x 	c #0E0E0E",
"y 	c #1B1B1B",
"z 	c #6D6D6D",
"A 	c #FEFEFE",
"B 	c #EEEEEE",
"C 	c #E6E6E6",
"D 	c #575757",
"E 	c #090909",
"F 	c #141414",
"G 	c #A8A8A8",
"H 	c #D8D8D8",
"I 	c #F6F6F6",
"J 	c #F4F4F4",
"K 	c #DCDCDC",
"L 	c #9B9B9B",
"M 	c #060606",
"N 	c #111111",
"O 	c #C5C5C5",
"P 	c #DFDFDF",
"Q 	c #444444",
"R 	c #454545",
"S 	c #424242",
"T 	c #EDEDED",
"U 	c #BFBFBF",
"V 	c #C6C6C6",
"W 	c #E3E3E3",
"X 	c #414141",
"Y 	c #EAEAEA",
"Z 	c #E0E0E0",
"` 	c #BABABA",
" .	c #050505",
"..	c #0B0B0B",
"+.	c #A5A5A5",
"@.	c #D1D1D1",
"#.	c #939393",
"$.	c #020202",
"%.	c #0A0A0A",
"&.	c #5F5F5F",
"*.	c #D9D9D9",
"=.	c #EBEBEB",
"-.	c #E9E9E9",
";.	c #D4D4D4",
">.	c #000000",
",.	c #E2E2E2",
"'.	c #DADADA",
").	c #CBCBCB",
"!.	c #3B3B3B",
"~.	c #D5D5D5",
"{.	c #C8C8C8",
"].	c #BDBDBD",
"^.	c #515151",
"/.	c #C7C7C7",
"(.	c #CDCDCD",
"_.	c #B8B8B8",
":.	c #030303",
"<.	c #313131",
"[.	c #999999",
"}.	c #BBBBBB",
"|.	c #B6B6B6",
"1.	c #909090",
"2.	c #2B2B2B",
"3.	c #010101",
"4.	c #7A7A7A",
"5.	c #9A9A9A",
"6.	c #777777",
"7.	c #3C3C3C",
"8.	c #686868",
"9.	c #797979",
"0.	c #3A3A3A",
"                                                ",
"              . + @ # # #                       ",
"          $ % & * = - ; > , '                   ",
"        ) ! = ~ { ] ^ / ( _ : <                 ",
"      [ } ~ | 1 2 3 4 5 6 7 8 9 0               ",
"    a b c d 6 e f g f h e i j k l m             ",
"    n o p 2 q g r r s g h t u v w x             ",
"  y z 7 j e f r A A r s q e B C 1 D E           ",
"  F G H B I q s A A r g h J B C K L M           ",
"  N O P 3 e Q Q R R R Q l S T 6 1 U M           ",
"  x V W u t l Q Q Q Q l S X Y Z d `  .          ",
"  ..+.j 2 T 5 J I I e 4 3 u v 1 @.#.$.          ",
"  %.&.*.j C =.B 3 3 B T -.v 1 ;.~ : >.          ",
"    %.= H K ,.6 C C 2 W P '.;.).* $.            ",
"    M !.c 7 ;.'.1 '.1 H ~.] {.].$ >.            ",
"       .^.k /.).c (.).).{.k _.R >.              ",
"        :.<.[.}.].8 8 8 |.1.2.>.>.>.            ",
"          3.:.X 4.5.5.6.7.>.>.  >.>.>.>.        ",
"              >.>.>.>.>.>.        , , >.>.      ",
"                                  >.8.. >.>.    ",
"                                    >.9.0.>.>.  ",
"                                      >.8.n >.  ",
"                                        >.>.    ",
"                                                "};

static const char *cut_xpm[] = {
"24 24 40 1",
" 	c None",
".	c #000000",
"+	c #C9C7C2",
"@	c #E6E4E0",
"#	c #EFEEED",
"$	c #494946",
"%	c #73726E",
"&	c #F0EEED",
"*	c #7F7D75",
"=	c #F2F1EF",
"-	c #D2CFC8",
";	c #E7E7E4",
">	c #BAB5AB",
",	c #565653",
"'	c #EDECE9",
")	c #A4A097",
"!	c #817F7E",
"~	c #4E4C48",
"{	c #F6F5F4",
"]	c #474541",
"^	c #EFEEEC",
"/	c #8C8B8A",
"(	c #F3F2F0",
"_	c #77746D",
":	c #323232",
"<	c #EBEBEA",
"[	c #605D58",
"}	c #F5F4F3",
"|	c #CECCC7",
"1	c #363634",
"2	c #6F6E6D",
"3	c #BEBDBB",
"4	c #EAE7E4",
"5	c #B8B5B1",
"6	c #474747",
"7	c #DAD8D4",
"8	c #9B9996",
"9	c #161615",
"0	c #6D6B6A",
"a	c #3A3837",
"                        ",
"                        ",
"      .        .        ",
"      .        .        ",
"     .+.      .@.       ",
"     .#$      %@.       ",
"     .&*.    .=-.       ",
"     .;>,    %').       ",
"      !#*.  .=-~        ",
"      .{>]  ~^>.        ",
"       /(_.:<-[         ",
"       .}|123>.         ",
"        .456>.          ",
"         .78..          ",
"         .90a.          ",
"     .............      ",
"     . ...  ... ...     ",
"    ..  ..   ..  ..     ",
"    .    .   .    .     ",
"    ..  ..   ..  ..     ",
"     ....     .. .      ",
"     ....     ....      ",
"                        ",
"                        "};

static const char *paste_xpm[] = {
"24 24 89 1",
" 	c None",
".	c #000000",
"+	c #B9B9B9",
"@	c #FEFEFE",
"#	c #F9F9F9",
"$	c #757575",
"%	c #F5F5E8",
"&	c #565651",
"*	c #FFFFFF",
"=	c #A0A0A0",
"-	c #939393",
";	c #7C7C7C",
">	c #C5C5BB",
",	c #CFC6A0",
"'	c #D7CEAA",
")	c #ADA689",
"!	c #4B483C",
"~	c #6D6D6D",
"{	c #6C6C6C",
"]	c #A9A9A9",
"^	c #3D3A30",
"/	c #979178",
"(	c #C1B898",
"_	c #8A793D",
":	c #C3BB9A",
"<	c #AFA78A",
"[	c #444236",
"}	c #FAFAFA",
"|	c #EFEFEF",
"1	c #C7C7C7",
"2	c #D8D8D8",
"3	c #D2D2D2",
"4	c #7B7B7B",
"5	c #302E26",
"6	c #89846C",
"7	c #C4BC9A",
"8	c #847235",
"9	c #C5C5C5",
"0	c #A7A7A7",
"a	c #ADADAD",
"b	c #9A9A9A",
"c	c #9B9B9B",
"d	c #868686",
"e	c #424242",
"f	c #847033",
"g	c #C9C09E",
"h	c #464337",
"i	c #35332A",
"j	c #2D2B23",
"k	c #C6BE9D",
"l	c #826F33",
"m	c #7F7964",
"n	c #4C493C",
"o	c #171612",
"p	c #13120F",
"q	c #3E3B31",
"r	c #282210",
"s	c #474438",
"t	c #B3B3B3",
"u	c #D6D6D6",
"v	c #B7AE90",
"w	c #B1AA8C",
"x	c #37352B",
"y	c #151410",
"z	c #8F8F8F",
"A	c #989898",
"B	c #C6C6C6",
"C	c #B9B293",
"D	c #11100D",
"E	c #434035",
"F	c #636363",
"G	c #767676",
"H	c #AAA48B",
"I	c #A5A086",
"J	c #A19A7F",
"K	c #312F26",
"L	c #AFA88C",
"M	c #050403",
"N	c #12110E",
"O	c #A9A489",
"P	c #A39E85",
"Q	c #EBE7D0",
"R	c #D2C9A5",
"S	c #A29053",
"T	c #8E7C3D",
"U	c #88793B",
"V	c #806C2F",
"W	c #78652B",
"X	c #251F0C",
"       ....             ",
" ......+@#$......       ",
".%%%%%&*=-;&>%%%,.      ",
".%''')!*~{]^/(''_.      ",
".%::<[}|123456<78.      ",
".%''!900abcde!)'f.      ",
".%g:6hijjjjj56<kl.      ",
".%'''////////(''l.      ",
".%g::::mnopppp^qr....   ",
".%'''''st***********u.  ",
".%vwwwwx*************.  ",
".%'''''y*0zzA**Bz*zB*.  ",
".%CwwwwD*************.  ",
".%'''''E*~F*GzzB*Bz**.  ",
".%HIJJJK*************.  ",
".%'''''E*0zz*zzzB*Az*.  ",
".%LIJJJM*************.  ",
".%'''''N*~F*GzzB*Bz**.  ",
".%OPJJJK*************.  ",
".Q'''''E*0zz*zzzB*Az*.  ",
".RSTUVWX*************.  ",
" .......u***********u.  ",
"        .............   ",
"                        "};

static const char *preferences_xpm[] = {
"24 24 87 1",
" 	c None",
".	c #000000",
"+	c #BAB5AB",
"@	c #D0CDC6",
"#	c #88857D",
"$	c #C9C6BE",
"%	c #CCC8C1",
"&	c #E5E3E0",
"*	c #FFFFFF",
"=	c #757575",
"-	c #2E2E2E",
";	c #F6F5F5",
">	c #CCCCCC",
",	c #AFAFAF",
"'	c #D3D1CB",
")	c #C1C0BF",
"!	c #F0EFED",
"~	c #797772",
"{	c #DCDCDC",
"]	c #A5A19C",
"^	c #EAE9E5",
"/	c #F3F1F0",
"(	c #EDEDED",
"_	c #A19D96",
":	c #C1BDB4",
"<	c #DBD8D3",
"[	c #D9D6D1",
"}	c #89857E",
"|	c #FCFCFC",
"1	c #EAE9E6",
"2	c #F5F4F3",
"3	c #C6C2BA",
"4	c #F0EFEE",
"5	c #F4F4F3",
"6	c #CBC7C0",
"7	c #ECECEB",
"8	c #676560",
"9	c #54524D",
"0	c #777676",
"a	c #797978",
"b	c #85827E",
"c	c #79756F",
"d	c #7590AE",
"e	c #A4BAD0",
"f	c #90A6BE",
"g	c #9F9F9E",
"h	c #BEBDBC",
"i	c #B8B4AD",
"j	c #87837C",
"k	c #D3DFEA",
"l	c #A2AEBC",
"m	c #9DB6CE",
"n	c #637B95",
"o	c #E2E2E2",
"p	c #EEEEED",
"q	c #849CB6",
"r	c #D7E2ED",
"s	c #8D98A5",
"t	c #9DB8D2",
"u	c #607791",
"v	c #EDEDEC",
"w	c #99ADC3",
"x	c #DFE7F0",
"y	c #8193A9",
"z	c #586D84",
"A	c #5B7189",
"B	c #F1F1F1",
"C	c #EEEDEB",
"D	c #A7A6A5",
"E	c #726F6A",
"F	c #A1B4C8",
"G	c #EEF3F6",
"H	c #60768F",
"I	c #DEDDDC",
"J	c #787776",
"K	c #4E4E4D",
"L	c #91A6BE",
"M	c #F0F4F7",
"N	c #97A5B6",
"O	c #BFBEBD",
"P	c #AAAAA9",
"Q	c #ACACAB",
"R	c #B0C6DB",
"S	c #EDF2F6",
"T	c #818A95",
"U	c #6C85A1",
"V	c #C0D1E2",
"       ..               ",
"      .+@#.             ",
"       .$%+.        ..  ",
"        .&$.       .*=. ",
"    ..  -;$.      .*>,. ",
"   .' ..)!+~.     .{,.  ",
"   .]%%^/+++.    .(..   ",
"    ._:%$<[+}.  .|.     ",
"     .....123}..>.      ",
"          .456.,.       ",
"           .7.,..       ",
"            .,.89.      ",
"        ....,.0abc.     ",
"       .def.. .ghij.    ",
"      .dklmn.  .op6}.   ",
"     .qrsntu.   .v/$}.  ",
"    .wxyztdA.    .BCDE..",
"   .FGyHtdA.      .IJK,.",
"  .LMNHtdA.        .OPQ.",
"  .RSTtdA..         ... ",
"  .UtVLA..              ",
"   .UUn..               ",
"    ...                 ",
"                        "};


static const char * close_xpm[] = {
"24 24 5 1",
"       c None s None",
".	c gray50",
"X	c black",
"o	c white",
"O	c yellow",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
"      XX.      XX.      ",
"       XX.    XX.       ",
"        XX.  XX.        ",
"         XX.XX.         ",
"          XXX.          ",
"          XXX.          ",
"         XX.XX.         ",
"        XX.  XX.        ",
"       XX.    XX.       ",
"      XX.      XX.      ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        "};

    
static const char *redo_xpm[] = {
"24 24 42 1",
" 	c None",
".	c #000000",
"+	c #939A8D",
"@	c #BAD09D",
"#	c #92998C",
"$	c #818F71",
"%	c #ADBDA0",
"&	c #C2D5AA",
"*	c #D1DFBE",
"=	c #BED2A3",
"-	c #99A28F",
";	c #A8BCA6",
">	c #D5E1C6",
",	c #CDDCBC",
"'	c #D2E0BF",
")	c #C5D7AE",
"!	c #919889",
"~	c #8C9A7F",
"{	c #D4E0C5",
"]	c #D3E0C1",
"^	c #BFD3A6",
"/	c #9BAA87",
"(	c #B5C3A9",
"_	c #92AD62",
":	c #7C9B40",
"<	c #59702D",
"[	c #7F8E6B",
"}	c #C8D9B2",
"|	c #85A24D",
"1	c #53692A",
"2	c #A4B690",
"3	c #9BB572",
"4	c #6D8839",
"5	c #95A77E",
"6	c #8BA859",
"7	c #657255",
"8	c #98AF74",
"9	c #AFC394",
"0	c #6D7A5B",
"a	c #9CAF84",
"b	c #748261",
"c	c #879772",
"                        ",
"                        ",
"                        ",
"            .           ",
"            ..          ",
"            .+.         ",
"         ....@#.        ",
"        .$%&*=@-.       ",
"       .;>,')@@@!.      ",
"      .~{]*^@@@@@/.     ",
"      .(>_::::::<.      ",
"     .[}|::::::1.       ",
"     .23:<...:1.        ",
"     .@:4.  .<.         ",
"     .@:..  ..          ",
"     .56.   .           ",
"     .78.               ",
"      .9.               ",
"      .0a.              ",
"       .bc.             ",
"        ...             ",
"                        ",
"                        ",
"                        "};

static const char *undo_xpm[] = {
"24 24 31 1",
" 	c None",
".	c #000000",
"+	c #EFE5BA",
"@	c #EFE7C1",
"#	c #EED680",
"$	c #EFE4B6",
"%	c #D5B75D",
"&	c #B29544",
"*	c #D1B051",
"=	c #C0AF73",
"-	c #C0A048",
";	c #986B07",
">	c #D1940C",
",	c #E0B74C",
"'	c #D9C374",
")	c #8F6406",
"!	c #D59D1C",
"~	c #B1933F",
"{	c #DFB74A",
"]	c #CCB76D",
"^	c #B8820A",
"/	c #D9A72E",
"(	c #D7A62C",
"_	c #C7B26A",
":	c #D4B150",
"<	c #A39256",
"[	c #E2CB79",
"}	c #C9B46B",
"|	c #8D7E4A",
"1	c #AE9C5C",
"2	c #96864F",
"                        ",
"                        ",
"                        ",
"          .             ",
"         ..             ",
"        .+.             ",
"       .@#....          ",
"      .$####%&.         ",
"     .+#######*.        ",
"    .=#########-.       ",
"     .;>>>>>>,#'..      ",
"      .)>>>>>>!#~.      ",
"       .)>...;>{].      ",
"        .;. ..^/#.      ",
"         ..  ..>#.      ",
"          .   .(_.      ",
"              .:<.      ",
"              .[.       ",
"             .}|.       ",
"            .12.        ",
"             ..         ",
"                        ",
"                        ",
"                        "};

static const char *save_xpm[] = {
"24 24 220 2",
"  	c None",
". 	c #000000",
"+ 	c #C3D7F4",
"@ 	c #A9CDE5",
"# 	c #75757A",
"$ 	c #EFC5BB",
"% 	c #F1C8BE",
"& 	c #F0C6BC",
"* 	c #EEBCB2",
"= 	c #EEBEB5",
"- 	c #EEC1B8",
"; 	c #EDBFB6",
"> 	c #E9B7AD",
", 	c #E9B8AF",
"' 	c #E9B9B1",
") 	c #E5BFBA",
"! 	c #737277",
"~ 	c #B3CDE3",
"{ 	c #A1BED6",
"] 	c #BBD6E8",
"^ 	c #8AAAC5",
"/ 	c #605F68",
"( 	c #E08D7E",
"_ 	c #E0826E",
": 	c #E0806E",
"< 	c #DC7A68",
"[ 	c #DC8171",
"} 	c #DA7868",
"| 	c #D48173",
"1 	c #D47D6E",
"2 	c #CE7265",
"3 	c #CF7264",
"4 	c #CE7567",
"5 	c #C4675B",
"6 	c #C36558",
"7 	c #626169",
"8 	c #87A3B7",
"9 	c #567187",
"0 	c #BAD5E9",
"a 	c #88A7C3",
"b 	c #686670",
"c 	c #C8817B",
"d 	c #CB7C74",
"e 	c #CB7A73",
"f 	c #CB7B73",
"g 	c #CC7C72",
"h 	c #CB7D73",
"i 	c #BF6B64",
"j 	c #CC7A70",
"k 	c #C16A62",
"l 	c #CC7C73",
"m 	c #C2655B",
"n 	c #C36459",
"o 	c #BA6C6A",
"p 	c #819EB6",
"q 	c #547086",
"r 	c #B6D3E7",
"s 	c #87ABC1",
"t 	c #737373",
"u 	c #FFFFFF",
"v 	c #83A0B8",
"w 	c #526C80",
"x 	c #B9D3E7",
"y 	c #85A4BF",
"z 	c #4F697C",
"A 	c #B9D3E6",
"B 	c #84A3BF",
"C 	c #CECECE",
"D 	c #CDCDCD",
"E 	c #BFBFBF",
"F 	c #88A4BB",
"G 	c #486276",
"H 	c #B7D2E7",
"I 	c #82A0BB",
"J 	c #636363",
"K 	c #465E70",
"L 	c #B5CAE5",
"M 	c #7FA2B9",
"N 	c #87A3BA",
"O 	c #455C6D",
"P 	c #AECCE5",
"Q 	c #7DA0B6",
"R 	c #C5C5C5",
"S 	c #546069",
"T 	c #B0D1E4",
"U 	c #83A1B6",
"V 	c #735B5B",
"W 	c #515C64",
"X 	c #AACEE3",
"Y 	c #7B9BB2",
"Z 	c #7A8E9A",
"` 	c #7A7A7A",
" .	c #6B6F72",
"..	c #6F6F6F",
"+.	c #696969",
"@.	c #6F777E",
"#.	c #86A2B9",
"$.	c #3A515D",
"%.	c #A9C9E2",
"&.	c #7494AF",
"*.	c #829FB7",
"=.	c #7F9DB6",
"-.	c #7E9CB5",
";.	c #7998B2",
">.	c #85A1B8",
",.	c #8CA7BD",
"'.	c #8AA5BB",
").	c #364A59",
"!.	c #ABC4E2",
"~.	c #7294AD",
"{.	c #6F90AC",
"].	c #7192AE",
"^.	c #414A4E",
"/.	c #424A51",
"(.	c #525B63",
"_.	c #626F79",
":.	c #5F6C76",
"<.	c #5C6971",
"[.	c #5A666F",
"}.	c #58636B",
"|.	c #57636A",
"1.	c #3B5360",
"2.	c #39424B",
"3.	c #7897B3",
"4.	c #A4B9CB",
"5.	c #364853",
"6.	c #AAC9E2",
"7.	c #7091AA",
"8.	c #6F8FA7",
"9.	c #4A5359",
"0.	c #97938C",
"a.	c #DFDDDA",
"b.	c #E3E1DE",
"c.	c #EBEAE8",
"d.	c #EAE9E7",
"e.	c #CFCEC9",
"f.	c #C9C6C0",
"g.	c #9B968E",
"h.	c #566168",
"i.	c #4B657A",
"j.	c #54738C",
"k.	c #AAC6DD",
"l.	c #34464E",
"m.	c #AAC9E1",
"n.	c #6C8EA6",
"o.	c #6C8CA4",
"p.	c #40474D",
"q.	c #DAD8D3",
"r.	c #E7E6E2",
"s.	c #67655E",
"t.	c #524F47",
"u.	c #D9D7D4",
"v.	c #C7C5BF",
"w.	c #C0BCB5",
"x.	c #B8B3AB",
"y.	c #434C54",
"z.	c #4D697F",
"A.	c #4F6F84",
"B.	c #B3CADC",
"C.	c #313E49",
"D.	c #A8C8E1",
"E.	c #6B8DA6",
"F.	c #728FA4",
"G.	c #E2E1DD",
"H.	c #F0EFEC",
"I.	c #CDCAC6",
"J.	c #C2BFB9",
"K.	c #CAC6C0",
"L.	c #DCDAD7",
"M.	c #4B555D",
"N.	c #4E697F",
"O.	c #BACCDC",
"P.	c #A4C4DE",
"Q.	c #698BA3",
"R.	c #708AA1",
"S.	c #383E43",
"T.	c #E0DEDA",
"U.	c #514E46",
"V.	c #4F4C44",
"W.	c #C7C4BE",
"X.	c #CBC8C2",
"Y.	c #E1E0DC",
"Z.	c #E9E8E6",
"`.	c #475158",
" +	c #4E6879",
".+	c #4D6C80",
"++	c #A3C3DB",
"@+	c #383F43",
"#+	c #778999",
"$+	c #6E899E",
"%+	c #65859C",
"&+	c #33383C",
"*+	c #D7D4D0",
"=+	c #D6D4D0",
"-+	c #4E4A43",
";+	c #4D4942",
">+	c #D1CEC9",
",+	c #E6E5E2",
"'+	c #EDECEA",
")+	c #454F55",
"!+	c #486173",
"~+	c #4D6678",
"{+	c #A1C1DA",
"]+	c #373C40",
"^+	c #0C0D0F",
"/+	c #4E5E6A",
"(+	c #5B6E7C",
"_+	c #4F5B62",
":+	c #A4A099",
"<+	c #CCC9C3",
"[+	c #D7D5D1",
"}+	c #E4E2E0",
"|+	c #DDDBD7",
"1+	c #B8B5B0",
"2+	c #3E474D",
"3+	c #4A6176",
"4+	c #4A6070",
"5+	c #9BC3D8",
"6+	c #363C41",
"7+	c #28323E",
"                                                ",
"                                                ",
"    . . . . . . . . . . . . . . . . . . .       ",
"  . + @ # $ % & * = - ; > , > , ' ) ! ~ { .     ",
"  . ] ^ / ( _ : < [ } | 1 2 3 4 5 6 7 8 9 .     ",
"  . 0 a b c d e f g h i j k l m n o b p q .     ",
"  . r s t u u u u u u u u u u u u u t v w .     ",
"  . x y t u u u u u u u u u u u u u t v z .     ",
"  . A B t C D D D D D D D D D D D E t F G .     ",
"  . H I J u u u u u u u u u u u u u t F K .     ",
"  . L M t u u u u u u u u u u u u u t N O .     ",
"  . P Q t C D D D D D D D D D D D R t N S .     ",
"  . T U V u u u u u u u u u u u u u t v W .     ",
"  . X Y Z ` t t t t t  ...t t t t +.@.#.$..     ",
"  . %.&.p v #.*.=.-.*.;.#.>.>.N *.,.v '.)..     ",
"  . !.~.{.].^./.(._.:.<.[.}.|.(.1.2.3.4.5..     ",
"  . 6.7.8.9.0.a.b.c.c.d.a.e.f.g.h.i.j.k.l..     ",
"  . m.n.o.p.q.r.s.t.t.u.v.w.x.e.y.z.A.B.C..     ",
"  . D.E.F.p.G.H.s.t.t.I.J.w.K.L.M.N.A.O.C..     ",
"  . P.Q.R.S.T.c.U.V.V.W.w.X.Y.Z.`. +.+++@+.     ",
"  . #+$+%+&+*+=+-+;+;+w.>+,+'+,+)+!+~+{+]+.     ",
"    ^+/+(+_+:+w.x.<+<+[+}+d.|+1+2+3+4+5+6+.     ",
"      . . . . . . . . . . . . . . . . 7+.       ",
"                                                "};

static const char *saveas_xpm[] = {
"24 24 262 2",
"  	c None",
". 	c #000000",
"+ 	c #FBE73B",
"@ 	c #F2B64D",
"# 	c #FCEB3D",
"$ 	c #F7B544",
"% 	c #5D502C",
"& 	c #C3D7F4",
"* 	c #A9CDE5",
"= 	c #75757A",
"- 	c #EFC5BB",
"; 	c #F1C8BE",
"> 	c #F0C6BC",
", 	c #EEBCB2",
"' 	c #EEBEB5",
") 	c #EEC1B8",
"! 	c #EDBFB6",
"~ 	c #E8B6AC",
"{ 	c #FCE93B",
"] 	c #F7B545",
"^ 	c #6C5F34",
"/ 	c #434345",
"( 	c #92A7B9",
"_ 	c #96B1C7",
": 	c #BBD6E8",
"< 	c #8AAAC5",
"[ 	c #605F68",
"} 	c #E08D7E",
"| 	c #E0826E",
"1 	c #E0806E",
"2 	c #DC7A68",
"3 	c #DC8171",
"4 	c #DA7868",
"5 	c #D38072",
"6 	c #FAE43A",
"7 	c #F4B244",
"8 	c #615030",
"9 	c #783E35",
"0 	c #4D4C52",
"a 	c #7790A2",
"b 	c #526D82",
"c 	c #BAD5E9",
"d 	c #88A7C3",
"e 	c #686670",
"f 	c #C8817B",
"g 	c #CB7C74",
"h 	c #CB7A73",
"i 	c #CB7B73",
"j 	c #CC7C72",
"k 	c #CA7C72",
"l 	c #F9DF39",
"m 	c #F3AF42",
"n 	c #614F2F",
"o 	c #8F4941",
"p 	c #945554",
"q 	c #5B5A62",
"r 	c #7B97AE",
"s 	c #536F84",
"t 	c #B6D3E7",
"u 	c #87ABC1",
"v 	c #737373",
"w 	c #FFFFFF",
"x 	c #FEFEFE",
"y 	c #F9DC38",
"z 	c #EFB44D",
"A 	c #665A32",
"B 	c #BBBBBB",
"C 	c #CDCDCD",
"D 	c #E4E4E4",
"E 	c #6E6E6E",
"F 	c #819EB6",
"G 	c #526C80",
"H 	c #B9D3E7",
"I 	c #85A4BF",
"J 	c #F8D837",
"K 	c #F0A93F",
"L 	c #655930",
"M 	c #BABABA",
"N 	c #CCCCCC",
"O 	c #E5E5E5",
"P 	c #F7F7F7",
"Q 	c #727272",
"R 	c #83A0B8",
"S 	c #4F697C",
"T 	c #B9D3E6",
"U 	c #84A3BF",
"V 	c #CECECE",
"W 	c #F6D236",
"X 	c #EDA43E",
"Y 	c #5C5130",
"Z 	c #949494",
"` 	c #A3A3A3",
" .	c #B7B7B7",
"..	c #C6C6C6",
"+.	c #BDBDBD",
"@.	c #88A4BB",
"#.	c #486276",
"$.	c #B7D2E7",
"%.	c #82A0BB",
"&.	c #636363",
"*.	c #FDFDFD",
"=.	c #D7AE74",
"-.	c #61562F",
";.	c #465E70",
">.	c #B5CAE5",
",.	c #7FA2B9",
"'.	c #4F4115",
").	c #87A3BA",
"!.	c #455C6D",
"~.	c #AECCE5",
"{.	c #7DA0B6",
"].	c #CBCBCB",
"^.	c #9B9B9B",
"/.	c #9C9C9C",
"(.	c #A7A7A7",
"_.	c #B8B8B8",
":.	c #C5C5C5",
"<.	c #546069",
"[.	c #B0D1E4",
"}.	c #83A1B6",
"|.	c #735B5B",
"1.	c #F0F0F0",
"2.	c #D9D9D9",
"3.	c #D3D3D3",
"4.	c #E1E1E1",
"5.	c #EDEDED",
"6.	c #F8F8F8",
"7.	c #515C64",
"8.	c #AACEE3",
"9.	c #7B9BB2",
"0.	c #7A8E9A",
"a.	c #7A7A7A",
"b.	c #707070",
"c.	c #6C6C6C",
"d.	c #6F6F6F",
"e.	c #6A6E71",
"f.	c #696969",
"g.	c #6F777E",
"h.	c #86A2B9",
"i.	c #3A515D",
"j.	c #A9C9E2",
"k.	c #7494AF",
"l.	c #7E9BB4",
"m.	c #7D9AB3",
"n.	c #7998B2",
"o.	c #85A1B8",
"p.	c #829FB7",
"q.	c #8CA7BD",
"r.	c #8AA5BB",
"s.	c #364A59",
"t.	c #ABC4E2",
"u.	c #7294AD",
"v.	c #6F90AC",
"w.	c #7192AE",
"x.	c #414A4E",
"y.	c #424A51",
"z.	c #525B63",
"A.	c #626F79",
"B.	c #5F6C76",
"C.	c #5C6971",
"D.	c #5A666F",
"E.	c #58636B",
"F.	c #57636A",
"G.	c #3B5360",
"H.	c #39424B",
"I.	c #7897B3",
"J.	c #A4B9CB",
"K.	c #364853",
"L.	c #AAC9E2",
"M.	c #7091AA",
"N.	c #6F8FA7",
"O.	c #4A5359",
"P.	c #97938C",
"Q.	c #DFDDDA",
"R.	c #E3E1DE",
"S.	c #EBEAE8",
"T.	c #EAE9E7",
"U.	c #CFCEC9",
"V.	c #C9C6C0",
"W.	c #9B968E",
"X.	c #566168",
"Y.	c #4B657A",
"Z.	c #54738C",
"`.	c #AAC6DD",
" +	c #34464E",
".+	c #AAC9E1",
"++	c #6C8EA6",
"@+	c #6C8CA4",
"#+	c #40474D",
"$+	c #DAD8D3",
"%+	c #E7E6E2",
"&+	c #67655E",
"*+	c #524F47",
"=+	c #D9D7D4",
"-+	c #C7C5BF",
";+	c #C0BCB5",
">+	c #B8B3AB",
",+	c #434C54",
"'+	c #4D697F",
")+	c #4F6F84",
"!+	c #B3CADC",
"~+	c #313E49",
"{+	c #A8C8E1",
"]+	c #6B8DA6",
"^+	c #728FA4",
"/+	c #E2E1DD",
"(+	c #F0EFEC",
"_+	c #CDCAC6",
":+	c #C2BFB9",
"<+	c #CAC6C0",
"[+	c #DCDAD7",
"}+	c #4B555D",
"|+	c #4E697F",
"1+	c #BACCDC",
"2+	c #A4C4DE",
"3+	c #698BA3",
"4+	c #708AA1",
"5+	c #383E43",
"6+	c #E0DEDA",
"7+	c #514E46",
"8+	c #4F4C44",
"9+	c #C7C4BE",
"0+	c #CBC8C2",
"a+	c #E1E0DC",
"b+	c #E9E8E6",
"c+	c #475158",
"d+	c #4E6879",
"e+	c #4D6C80",
"f+	c #A3C3DB",
"g+	c #383F43",
"h+	c #778999",
"i+	c #6E899E",
"j+	c #65859C",
"k+	c #33383C",
"l+	c #D7D4D0",
"m+	c #D6D4D0",
"n+	c #4E4A43",
"o+	c #4D4942",
"p+	c #D1CEC9",
"q+	c #E6E5E2",
"r+	c #EDECEA",
"s+	c #454F55",
"t+	c #486173",
"u+	c #4D6678",
"v+	c #A1C1DA",
"w+	c #373C40",
"x+	c #0C0D0F",
"y+	c #4E5E6A",
"z+	c #5B6E7C",
"A+	c #4F5B62",
"B+	c #A4A099",
"C+	c #CCC9C3",
"D+	c #D7D5D1",
"E+	c #E4E2E0",
"F+	c #DDDBD7",
"G+	c #B8B5B0",
"H+	c #3E474D",
"I+	c #4A6176",
"J+	c #4A6070",
"K+	c #9BC3D8",
"L+	c #363C41",
"M+	c #28323E",
"                                . .             ",
"                              . + @ .           ",
"    . . . . . . . . . . . . . # $ % . . .       ",
"  . & * = - ; > , ' ) ! ~ . { ] ^ . / ( _ .     ",
"  . : < [ } | 1 2 3 4 5 . 6 7 8 . 9 0 a b .     ",
"  . c d e f g h i j k . l m n . o p q r s .     ",
"  . t u v w w w w x . y z A . B C D E F G .     ",
"  . H I v w w w x . J K L . M N O P Q R S .     ",
"  . T U v V C N . W X Y . Z `  ...+.v @.#..     ",
"  . $.%.&.w w *.. =.-.. M N D P *.w v @.;..     ",
"  . >.,.v w x . '.. . M N D P *.w w v ).!..     ",
"  . ~.{.v V ].. . ^./.(._...].C C :.v ).<..     ",
"  . [.}.|.w *.1.2.3.4.5.6.x w w w w v R 7..     ",
"  . 8.9.0.a.Q b.c.c.d.e.E v v v v f.g.h.i..     ",
"  . j.k.F R h.F l.m.F n.h.o.o.).p.q.R r.s..     ",
"  . t.u.v.w.x.y.z.A.B.C.D.E.F.z.G.H.I.J.K..     ",
"  . L.M.N.O.P.Q.R.S.S.T.Q.U.V.W.X.Y.Z.`. +.     ",
"  . .+++@+#+$+%+&+*+*+=+-+;+>+U.,+'+)+!+~+.     ",
"  . {+]+^+#+/+(+&+*+*+_+:+;+<+[+}+|+)+1+~+.     ",
"  . 2+3+4+5+6+S.7+8+8+9+;+0+a+b+c+d+e+f+g+.     ",
"  . h+i+j+k+l+m+n+o+o+;+p+q+r+q+s+t+u+v+w+.     ",
"    x+y+z+A+B+;+>+C+C+D+E+T.F+G+H+I+J+K+L+.     ",
"      . . . . . . . . . . . . . . . . M+.       ",
"                                                "};

static const char *new_xpm[] = {
"24 24 127 2",
"  	c None",
". 	c #000000",
"+ 	c #D3D3D3",
"@ 	c #F6F6F6",
"# 	c #FFFFFF",
"$ 	c #F9F9F9",
"% 	c #DADADA",
"& 	c #585858",
"* 	c #C7C7C7",
"= 	c #D1D1D1",
"- 	c #D6D6D6",
"; 	c #FEFEFE",
"> 	c #FDFDFD",
", 	c #C0C0C0",
"' 	c #E1E1E1",
") 	c #F0F0F0",
"! 	c #9B9B9B",
"~ 	c #FCFCFB",
"{ 	c #FBFBFB",
"] 	c #AFAFAE",
"^ 	c #E9E9E9",
"/ 	c #DFDFDF",
"( 	c #8F8F8F",
"_ 	c #FAFAF9",
": 	c #F9F9F8",
"< 	c #A4A4A3",
"[ 	c #F4F4F4",
"} 	c #CFCFCF",
"| 	c #A2A2A2",
"1 	c #F8F8F7",
"2 	c #F8F7F6",
"3 	c #9E9E9E",
"4 	c #F7F6F5",
"5 	c #F6F6F4",
"6 	c #F4F3F2",
"7 	c #DEDDDC",
"8 	c #D3D2D0",
"9 	c #B7B7B5",
"0 	c #9F9E9D",
"a 	c #706F6F",
"b 	c #65625A",
"c 	c #F5F4F3",
"d 	c #F2F2F0",
"e 	c #E4E4E2",
"f 	c #DAD9D7",
"g 	c #D8D8D6",
"h 	c #CDCCCA",
"i 	c #AFAEAC",
"j 	c #88847B",
"k 	c #F3F3F1",
"l 	c #EFEFED",
"m 	c #EEEDEB",
"n 	c #EDECEA",
"o 	c #E9E8E6",
"p 	c #D5D4D3",
"q 	c #C4C3C2",
"r 	c #8F8A81",
"s 	c #F6F5F4",
"t 	c #F5F5F3",
"u 	c #F1F1EF",
"v 	c #F1F0EE",
"w 	c #ECEBE9",
"x 	c #EAE9E7",
"y 	c #E5E4E2",
"z 	c #E4E3E0",
"A 	c #D2D1CE",
"B 	c #8D887E",
"C 	c #F3F2F1",
"D 	c #F0F0EE",
"E 	c #F0EFED",
"F 	c #EFEEEC",
"G 	c #E8E7E5",
"H 	c #E5E4E1",
"I 	c #E2E1DE",
"J 	c #E1DFDC",
"K 	c #979288",
"L 	c #A49E93",
"M 	c #E8E7E4",
"N 	c #E7E6E3",
"O 	c #E3E2DF",
"P 	c #E2E0DD",
"Q 	c #E1E0DC",
"R 	c #E0DFDB",
"S 	c #A19C90",
"T 	c #EDEDEB",
"U 	c #EBEAE8",
"V 	c #E9E8E5",
"W 	c #E6E4E1",
"X 	c #E3E2DE",
"Y 	c #DFDEDA",
"Z 	c #DEDDD9",
"` 	c #DDDCD8",
" .	c #A19B90",
"..	c #E7E5E2",
"+.	c #E4E3DF",
"@.	c #DCDBD7",
"#.	c #E6E5E2",
"$.	c #E5E4E0",
"%.	c #E2E1DD",
"&.	c #DBD9D5",
"*.	c #D9D7D3",
"=.	c #9F998D",
"-.	c #E4E2DF",
";.	c #DDDBD7",
">.	c #DCDAD6",
",.	c #D8D6D2",
"'.	c #9E988D",
").	c #EDEDED",
"!.	c #E1E0DD",
"~.	c #E0DEDA",
"{.	c #D8D6D1",
"].	c #D7D5D1",
"^.	c #9D978B",
"/.	c #E1DFDB",
"(.	c #DEDCD8",
"_.	c #D7D6D1",
":.	c #D5D3CE",
"<.	c #9B958A",
"[.	c #999891",
"}.	c #A39E92",
"|.	c #A39D92",
"1.	c #A39D91",
"2.	c #A29C90",
"3.	c #A19B8F",
"4.	c #9D978C",
"5.	c #9B968A",
"6.	c #676359",
"                                                ",
"      . . . . . . . . . . . . .                 ",
"    . + @ # # # # # # # # $ % & .               ",
"    . @ # # # # # # # # # # * = - .             ",
"    . # # # # # # # ; # ; > , ' ) ! .           ",
"    . # # # # # ; > ~ > ~ { ] ^ # / ( .         ",
"    . # # # ; > ~ { _ { _ : < ) # [ } | .       ",
"    . # ; > ~ { _ : 1 : 1 2 3 . . . . . . .     ",
"    . # ~ { _ : 1 2 4 2 4 5 6 7 8 9 0 a b .     ",
"    . # _ : 1 2 4 5 c 5 c 6 d e f g h i j .     ",
"    . # 1 2 4 5 c 6 k 6 k d l m n o p q r .     ",
"    . # s t 6 6 k d u d u v m w x y z A B .     ",
"    . # 6 C d D l v E v E F w G H z I J K .     ",
"    . # 6 C d D l v E v E F w G H z I J L .     ",
"    . # D l l F m n n n n w M N O P Q R S .     ",
"    . # T n w w w U V U V V H W X Y Z `  ..     ",
"    . # U o o G M M N M N ..+.X R Z ` @. ..     ",
"    . # N #.#.#.H W $.W $.+.%.R Z @.&.*.=..     ",
"    . $ z O X -.+.%.X %.X Q Q Z ;.>.*.,.'..     ",
"    . ).!.J Q R %.R Q R Q Y ~.;.>.*.{.].^..     ",
"    . = /.~.Y Z R Z ~.Z ~.(.(.>.>.,._.:.<..     ",
"    . [.}.L |.1.|.S 2.S 2.3. .=.=.4.4.5.6..     ",
"      . . . . . . . . . . . . . . . . . .       ",
"                                                "};

static const char *open_xpm[] = {
"24 24 173 2",
"  	c None",
". 	c #000000",
"+ 	c #010100",
"@ 	c #B5B8A5",
"# 	c #E4E7D2",
"$ 	c #878A76",
"% 	c #33342B",
"& 	c #0B0B0B",
"* 	c #E2E5CF",
"= 	c #CFD4AF",
"- 	c #CED3AE",
"; 	c #B2B696",
"> 	c #2D2D25",
", 	c #23241D",
"' 	c #9D9F90",
") 	c #C6CAA6",
"! 	c #C4C9A5",
"~ 	c #C6CBA7",
"{ 	c #C7CCA8",
"] 	c #C9CEA9",
"^ 	c #555847",
"/ 	c #1A1B15",
"( 	c #20201A",
"_ 	c #D4D6C2",
": 	c #BEC2A0",
"< 	c #B3B896",
"[ 	c #B0B595",
"} 	c #B3B797",
"| 	c #B6BB99",
"1 	c #BBC09E",
"2 	c #BCC19F",
"3 	c #81856C",
"4 	c #3E3F32",
"5 	c #010101",
"6 	c #DADDC8",
"7 	c #AFB494",
"8 	c #AAAF8F",
"9 	c #A3A789",
"0 	c #A6AA8B",
"a 	c #A9AD8E",
"b 	c #A7AB8D",
"c 	c #A4A88A",
"d 	c #A1A588",
"e 	c #AAAD96",
"f 	c #B3B5A5",
"g 	c #B8BBAA",
"h 	c #BABCAB",
"i 	c #C1C3B2",
"j 	c #C7CAB7",
"k 	c #CACDBB",
"l 	c #BABDA8",
"m 	c #0C0C09",
"n 	c #DDDFCB",
"o 	c #969B7E",
"p 	c #9DA286",
"q 	c #95987C",
"r 	c #96997E",
"s 	c #9A9D81",
"t 	c #999D80",
"u 	c #9DA184",
"v 	c #A5AA8B",
"w 	c #A4A98A",
"x 	c #A3A889",
"y 	c #A2A588",
"z 	c #A2A587",
"A 	c #9FA386",
"B 	c #9B9E83",
"C 	c #898D74",
"D 	c #D8DBC9",
"E 	c #84866E",
"F 	c #7D8169",
"G 	c #151612",
"H 	c #D7DAC9",
"I 	c #797D67",
"J 	c #3D3F34",
"K 	c #E0E0D9",
"L 	c #EBEDDD",
"M 	c #E8EBD9",
"N 	c #E7EAD8",
"O 	c #E3E6D4",
"P 	c #DEE1D0",
"Q 	c #DADCCC",
"R 	c #DADCD1",
"S 	c #2B2C28",
"T 	c #D7DAC6",
"U 	c #6F735E",
"V 	c #0D0D0D",
"W 	c #F4F4EC",
"X 	c #CACFAB",
"Y 	c #C6CBA8",
"Z 	c #C2C6A4",
"` 	c #ABB091",
" .	c #23251E",
"..	c #494B3D",
"+.	c #DCDCD4",
"@.	c #EAECDD",
"#.	c #CDD2AD",
"$.	c #CCD1AC",
"%.	c #CACFAA",
"&.	c #BABF9D",
"*.	c #B5B999",
"=.	c #81836C",
"-.	c #070806",
";.	c #D5D8C4",
">.	c #161616",
",.	c #F2F2EA",
"'.	c #C9CEAA",
").	c #C8CDA9",
"!.	c #C4C9A6",
"~.	c #C1C5A3",
"{.	c #BCC09F",
"].	c #B6BB9A",
"^.	c #B0B494",
"/.	c #9DA185",
"(.	c #535445",
"_.	c #B6B8A7",
":.	c #747470",
"<.	c #ECECE2",
"[.	c #C3C8A5",
"}.	c #C2C7A4",
"|.	c #C0C5A2",
"1.	c #BFC4A1",
"2.	c #BDC2A0",
"3.	c #B9BD9C",
"4.	c #B9BE9D",
"5.	c #A9AD8F",
"6.	c #A3A78A",
"7.	c #80836D",
"8.	c #020201",
"9.	c #A6A998",
"0.	c #B8BC9B",
"a.	c #AFB394",
"b.	c #ACB091",
"c.	c #A8AC8E",
"d.	c #A6AA8C",
"e.	c #9FA286",
"f.	c #9B9F83",
"g.	c #9A9D82",
"h.	c #8A8D75",
"i.	c #4F5243",
"j.	c #070705",
"k.	c #9E9F91",
"l.	c #E5E6DA",
"m.	c #ADB192",
"n.	c #A5A98C",
"o.	c #9FA387",
"p.	c #999D81",
"q.	c #95987E",
"r.	c #92957B",
"s.	c #8C8F76",
"t.	c #8A8D74",
"u.	c #71735F",
"v.	c #080908",
"w.	c #E3E5D9",
"x.	c #C0C3AF",
"y.	c #94987C",
"z.	c #8F9379",
"A.	c #8B8F75",
"B.	c #8A8E74",
"C.	c #888C73",
"D.	c #858970",
"E.	c #868971",
"F.	c #82866E",
"G.	c #80836C",
"H.	c #7D8069",
"I.	c #797C66",
"J.	c #727560",
"K.	c #717460",
"L.	c #71745F",
"M.	c #6A6D59",
"N.	c #434538",
"O.	c #080907",
"P.	c #050504",
"                                                ",
"                                                ",
"                                                ",
"    . . . . . . .                               ",
"  + @ # # # # # $ %                             ",
"  & * = = = - - ; >                             ",
", ' * ) ! ~ { ] ] ^ /                           ",
"( _ : < [ } | 1 2 3 4 5 . . . . . . .           ",
", 6 7 8 9 0 8 a b c d e f g h i j k l .         ",
"m n o p q r s t r u v w x y 9 z A B C .         ",
". D E F G . . . . . . . . . . . . . . . 5 5     ",
". H I J K L M M M M M M M M M M M N O P Q R S   ",
". T U V W = = = = = = = = = - - - X Y Z 1 `  .  ",
". T ..+.@.#.- - #.- #.#.#.#.#.$.%.Y Z &.*.=.-.  ",
". ;.>.,.X %.X %.'.%.'.{ ).).Y !.~.{.].^./.(.m   ",
". _.:.<.[.}.}.Z |.Z 1.2.|.2.3.4.} [ 5.6.7.8.    ",
". 9.+.0.0.*.} } [ [ a.a.a.b.c.d.e.f.g.h.i.j.    ",
". k.l.m.5.d.n.6.6.d o.e.f.p.q.r.s.t.t.u.v.      ",
". w.x.y.z.A.B.C.C.D.E.F.G.H.I.J.K.L.M.N.O.      ",
"  . . . . . . . . . . . . . . . . . . P.        ",
"                                                ",
"                                                ",
"                                                ",
"                                                "};

static const char *exit_xpm[] = {
"24 24 140 2",
"  	c None",
". 	c #000000",
"+ 	c #D6D6D4",
"@ 	c #BDBDBC",
"# 	c #A8A8A4",
"$ 	c #92928F",
"% 	c #727370",
"& 	c #61615E",
"* 	c #20201F",
"= 	c #F1F1EF",
"- 	c #E6E6E4",
"; 	c #DADAD7",
"> 	c #CFCFCD",
", 	c #C4C4C1",
"' 	c #A8A8A5",
") 	c #767674",
"! 	c #777774",
"~ 	c #1E1E1D",
"{ 	c #B9B9B7",
"] 	c #AEAEAC",
"^ 	c #8F8F8D",
"/ 	c #262626",
"( 	c #414140",
"_ 	c #E9836C",
": 	c #DEDEDC",
"< 	c #C5C5C2",
"[ 	c #636362",
"} 	c #040504",
"| 	c #040604",
"1 	c #050705",
"2 	c #E87B62",
"3 	c #E67056",
"4 	c #D5D5D3",
"5 	c #DBDBD8",
"6 	c #D0D0CE",
"7 	c #080A07",
"8 	c #0A0C09",
"9 	c #0A0D09",
"0 	c #0B0E0A",
"a 	c #F0B0A1",
"b 	c #EB8D77",
"c 	c #DF421E",
"d 	c #E97E66",
"e 	c #CBCBC8",
"f 	c #0C0F0B",
"g 	c #0F130D",
"h 	c #10140E",
"i 	c #11150F",
"j 	c #EFA392",
"k 	c #BFBFBD",
"l 	c #5D5D5C",
"m 	c #10150F",
"n 	c #141912",
"o 	c #161C14",
"p 	c #171D15",
"q 	c #B7B7B4",
"r 	c #0C0C0C",
"s 	c #192017",
"t 	c #1C2319",
"u 	c #1D241A",
"v 	c #CD8484",
"w 	c #990000",
"x 	c #701616",
"y 	c #A6A6A5",
"z 	c #181E16",
"A 	c #1E261B",
"B 	c #212A1E",
"C 	c #222B1F",
"D 	c #4F0000",
"E 	c #AEAEAB",
"F 	c #1D261B",
"G 	c #242E21",
"H 	c #273224",
"I 	c #283325",
"J 	c #580000",
"K 	c #B5B5B3",
"L 	c #293426",
"M 	c #2D3929",
"N 	c #2E3A2A",
"O 	c #7C4343",
"P 	c #6A0000",
"Q 	c #720000",
"R 	c #BDBDBB",
"S 	c #232C20",
"T 	c #2A3526",
"U 	c #303C2B",
"V 	c #33402E",
"W 	c #C5C5C3",
"X 	c #1E261C",
"Y 	c #303D2C",
"Z 	c #374532",
"` 	c #394834",
" .	c #500000",
"..	c #CDCDCB",
"+.	c #1B2319",
"@.	c #253022",
"#.	c #303E2D",
"$.	c #394934",
"%.	c #3D4E38",
"&.	c #9D9D9B",
"*.	c #565655",
"=.	c #2C3828",
"-.	c #40503A",
";.	c #43553E",
">.	c #BABAB7",
",.	c #777776",
"'.	c #323830",
").	c #232C1F",
"!.	c #313E2D",
"~.	c #3B4A36",
"{.	c #43553D",
"].	c #485B42",
"^.	c #4A5E44",
"/.	c #F0F0EE",
"(.	c #E5E5E3",
"_.	c #C6C6C3",
":.	c #ACACAB",
"<.	c #8B8B8A",
"[.	c #32392F",
"}.	c #2C3728",
"|.	c #3F503A",
"1.	c #465840",
"2.	c #4B5E44",
"3.	c #4E6347",
"4.	c #506549",
"5.	c #DADAD8",
"6.	c #7A7D78",
"7.	c #333C30",
"8.	c #475A41",
"9.	c #4F6348",
"0.	c #53694C",
"a.	c #566C4E",
"b.	c #576D4F",
"c.	c #91968F",
"d.	c #3B4736",
"e.	c #42543C",
"f.	c #51674A",
"g.	c #586F50",
"h.	c #5B7353",
"i.	c #5C7454",
"                                                ",
"              . . . . . . . . . . . . . . . .   ",
"              . + @ # $ % & & & * . . . . . .   ",
"              . = - ; > , ' ) ! ~ . . . . . .   ",
"          .   . = - ; > , { ] ^ / . . . . . .   ",
"          . . . = - ; > , { { { ( . . . . . .   ",
"          . _ . : - ; > < { { { [ } | 1 1 1 .   ",
". . . . . . 2 3 . 4 5 6 < { { { [ 7 8 9 0 0 .   ",
". a 2 2 2 2 b c d . e 6 < { { { [ f g h i i .   ",
". j c c c c c c c 3 . k < { l { [ m n o p p .   ",
". j c c c c c c c c 3 . q { l r [ n s t u u .   ",
". v w w w w w w w w w x . y r { [ z A B C C .   ",
". v w w w w w w w w D . E { { { [ F G H I I .   ",
". v w w w w w w w J . K < { { { [ C L M N N .   ",
". O P P P P Q w J . R 6 < { { { [ S T U V V .   ",
". . . . . . Q J . W 5 6 < { { { [ X H Y Z ` .   ",
"          .  .. ..- 5 6 < { { { [ +.@.#.$.%..   ",
"          . . . = - 5 6 < { ] &.*.B =.Z -.;..   ",
"          .   . = - 5 6 >.&.,.'.).!.~.{.].^..   ",
"              . /.(._.:.<.[.}.Z |.1.2.3.4.4..   ",
"              . 5.k 6.7.Z -.8.9.0.a.a.b.b.b..   ",
"              . c.d.e.^.f.g.h.i.i.i.i.i.i.i..   ",
"              . . . . . . . . . . . . . . . .   ",
"                                                "};

static const char *separator_xpm[] = {
"3 24 4 1",
" 	c None",
".	c #DBD3CB",
"+	c #FCFBFA",
"g      c #777777",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+"};

static const char *up_node2_xpm[] = {
"24 24 18 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #DADAD6",
"#	c #BCBCB8",
"$	c #778E6F",
"%	c #506B46",
"&	c #0F1308",
"*	c #6B9060",
"=	c #445B2C",
"-	c #A9C7A6",
";	c #BDD3B8",
">	c #77A16E",
",	c #C2D7BE",
"'	c #C1D6BD",
")	c #B0CAAD",
"!	c #A4C3A2",
"~	c #8CA782",
"  ..................    ",
"  .+++++++++++++++@#.   ",
"  .+++++++++++++++#+#.  ",
"  .+++++++++++++++#$%&. ",
"  .+++++++++++++++@$%&. ",
"  .+++++++++++++++++@#. ",
"  .++++++++++++@@@@@@#. ",
"  .+++++++++++++@@@@@#. ",
"  .++++++++++++@@@@@@#. ",
"  .+++++@@##$####@#@@#. ",
"  .+++@+@@#..$$####@@#. ",
"  .++++@@#.*=.%####@##. ",
"  .+++@@#.*-*=.$$###@#. ",
"  .+++@#.*-;**=.%###@#. ",
"  .++@#.*--;***=.$$###. ",
"  .++#.*---;****=.$###. ",
"  .+#.>,,;-;*****=.#@#. ",
"  .+%....')'***.....@#. ",
"  .++++@.'-;***.$#####. ",
"  .++++@.'-;***.###@##. ",
"  .+++++.'-;***.#@++##. ",
"  .......'-;***........ ",
"        .,,@!~>.        ",
"        ........        "};

static const char *stop_xpm[] = {
"24 24 3 1",
" 	c None",
".	c #cc0033",
"X	c #FFFFFFFFFFFF",
"                        ",
"                        ",
"       ..........       ",
"      ............      ",
"     ..............     ",
"    ................    ",
"   ..................   ",
"  ..XX..XXX..XX..XXX..  ",
"  .X..X..X..X..X.X..X.  ",
"  .X.....X..X..X.X..X.  ",
"  .X.....X..X..X.X..X.  ",
"  ..X....X..X..X.X..X.  ",
"  ...X...X..X..X.XXX..  ",
"  ....X..X..X..X.X....  ",
"  ....X..X..X..X.X....  ",
"  .X..X..X..X..X.X....  ",
"  ..XX...X...XX..X....  ",
"   ..................   ",
"    ................    ",
"     ..............     ",
"      ............      ",
"       ..........       ",
"                        ",
"                        "};

static const char *home_xpm[] = {
"24 24 101 2",
"  	c None",
". 	c #000000",
"+ 	c #212121",
"@ 	c #2C2C2C",
"# 	c #C1665A",
"$ 	c #924B37",
"% 	c #2A2A2A",
"& 	c #333333",
"* 	c #343434",
"= 	c #242424",
"- 	c #944D3A",
"; 	c #A05443",
"> 	c #181818",
", 	c #474747",
"' 	c #555555",
") 	c #8D8D8D",
"! 	c #383838",
"~ 	c #191919",
"{ 	c #974F3C",
"] 	c #222222",
"^ 	c #313131",
"/ 	c #A1A1A1",
"( 	c #676767",
"_ 	c #ACACAC",
": 	c #BCBCBC",
"< 	c #585858",
"[ 	c #141414",
"} 	c #1C1C1C",
"| 	c #464646",
"1 	c #666666",
"2 	c #BABABA",
"3 	c #7E7E7E",
"4 	c #D2D2D2",
"5 	c #FFFFFF",
"6 	c #4F4F4F",
"7 	c #262626",
"8 	c #232323",
"9 	c #505050",
"0 	c #B2B2B2",
"a 	c #909090",
"b 	c #9A9A9A",
"c 	c #838383",
"d 	c #171717",
"e 	c #202020",
"f 	c #717171",
"g 	c #A6A6A6",
"h 	c #616161",
"i 	c #1D1D1D",
"j 	c #1F1F1F",
"k 	c #C4C4C4",
"l 	c #CACACA",
"m 	c #AEAEAE",
"n 	c #D1D1D1",
"o 	c #7C7C7C",
"p 	c #BFBFBF",
"q 	c #6C6C6C",
"r 	c #EEEEEE",
"s 	c #949494",
"t 	c #C7C7C7",
"u 	c #EBEBEB",
"v 	c #7D7D7D",
"w 	c #6E6E6E",
"x 	c #A9A9A9",
"y 	c #E99E8F",
"z 	c #DD806D",
"A 	c #9B5343",
"B 	c #CECECE",
"C 	c #626262",
"D 	c #858585",
"E 	c #ECA292",
"F 	c #D0533A",
"G 	c #934F3E",
"H 	c #6D6D6D",
"I 	c #ECA291",
"J 	c #CF543C",
"K 	c #371D16",
"L 	c #5D5D5D",
"M 	c #868686",
"N 	c #787878",
"O 	c #ECA696",
"P 	c #C95C49",
"Q 	c #E17C66",
"R 	c #924E3D",
"S 	c #888888",
"T 	c #A0A0A0",
"U 	c #3D1208",
"V 	c #D15137",
"W 	c #919191",
"X 	c #879981",
"Y 	c #82947C",
"Z 	c #8A9B85",
"` 	c #6E8467",
" .	c #5D7555",
"..	c #4C6042",
"+.	c #3F4F37",
"@.	c #303D2A",
"#.	c #7F8F7A",
"$.	c #64785E",
"%.	c #44563E",
"&.	c #657460",
"*.	c #40503A",
"                                                ",
"                      . .                       ",
"          . . . .   . + @ .                     ",
"          . # $ . . % & * = .                   ",
"          . - ; . > , ' ) ! ~ .                 ",
"          . { . ] ^ / ( _ : < [ .               ",
"          . . } | 1 2 3 4 : 5 6 7 .             ",
"          . 8 9 0 a 4 b 5 : 5 : c d .           ",
"        . e f g 4 b 5 : 5 : 5 : 5 h i .         ",
"      . j k k l 5 m 5 2 5 2 5 : 5 n o } .       ",
"    . 8 m p p p p p p p p . . . . . a q = .     ",
"  . . . . r 5 5 5 5 5 5 5 . s t u . v . . . .   ",
"        . 4 5 . . . . . 5 . : 5 5 . w .         ",
"        . x 5 . y z A . 5 . B 5 5 . C .         ",
"        . D 5 . E F G . 5 . . . . . H .         ",
"        . . 5 . I J K . k s L L M N . .         ",
"        . . r . O P G . 5 5 5 5 5 2 .           ",
"          . 2 . Q # R . : : : : : S .           ",
"          . T U V # A . 5 5 5 5 5 W .           ",
"  . . . . . . . . . . . . . . . . . . . .   .   ",
"        } X Y Z X `  ...+.@.. Y #.$.%.&.*..     ",
"    . .   . . . . . . . . .   . . . . . .       ",
"                . . .                           ",
"                                                "};

static const char *left_arrow_xpm[] = {
"24 24 43 1",
" 	c None",
".	c #000000",
"+	c #B9D0B9",
"@	c #CDDECB",
"#	c #B6C7B6",
"$	c #B1C9B0",
"%	c #B3C4B3",
"&	c #B4CBB2",
"*	c #B5CEB5",
"=	c #B7CCB5",
"-	c #B9CEB7",
";	c #BAD1BA",
">	c #BBCFBA",
",	c #BBD0B9",
"'	c #B2C9B0",
")	c #7EAB78",
"!	c #AAC7A8",
"~	c #B3CAB1",
"{	c #B0C9B0",
"]	c #B0C9AE",
"^	c #AEC7AC",
"/	c #AAC5A8",
"(	c #A9C4A7",
"_	c #698267",
":	c #2D2D2D",
"<	c #CFDFCC",
"[	c #ADC8AB",
"}	c #B0C7AE",
"|	c #ADC6AB",
"1	c #678C63",
"2	c #9BAD9A",
"3	c #85AE81",
"4	c #87AF84",
"5	c #87B083",
"6	c #88AF84",
"7	c #88B085",
"8	c #86AF82",
"9	c #547150",
"0	c #3C5235",
"a	c #5B7950",
"b	c #4A6342",
"c	c #3B5035",
"d	c #415639",
"                        ",
"                        ",
"                        ",
"            .           ",
"           ..           ",
"          .+.           ",
"         .@#.           ",
"        .@$%........    ",
"       .@&*=-;->,').    ",
"      .@!~{]^///^(_.    ",
"     :<[}||[!^^}^[1.    ",
"    .23444445645789.    ",
"     .0aaaaaaaaaaab.    ",
"      .0aaaaaaaaaab.    ",
"       .0aabccccccd.    ",
"        .0ab........    ",
"         .0b.           ",
"          .b.           ",
"           ..           ",
"            .           ",
"                        ",
"                        ",
"                        ",
"                        "};

static const char *right_arrow_xpm[] = {
"24 24 41 1",
" 	c None",
".	c #000000",
"+	c #8CA782",
"@	c #B1CDAE",
"#	c #77A16E",
"$	c #B4CEB1",
"%	c #ACC8A9",
"&	c #709867",
"*	c #C1D6BD",
"=	c #BDD3B8",
"-	c #BFD4BB",
";	c #C2D7BE",
">	c #B0CAAD",
",	c #B2CBB0",
"'	c #AAC7A8",
")	c #0F1308",
"!	c #AEC5A8",
"~	c #AEC8AD",
"{	c #ABC7A8",
"]	c #AAC6A7",
"^	c #A8C6A5",
"/	c #ADC8AD",
"(	c #A8C7A8",
"_	c #A5C4A3",
":	c #7F9F76",
"<	c #A6BFA0",
"[	c #ABC7AA",
"}	c #A7C5A4",
"|	c #A9C7A6",
"1	c #AFC8AD",
"2	c #A4C3A2",
"3	c #6B9060",
"4	c #778E6F",
"5	c #698D60",
"6	c #6B9063",
"7	c #445B2C",
"8	c #6B8661",
"9	c #5B7950",
"0	c #6C8562",
"a	c #65815C",
"b	c #506B46",
"                        ",
"                        ",
"                        ",
"           .            ",
"           ..           ",
"           .+.          ",
"           .@#.         ",
"    ........$%&.        ",
"    .*=-;;;;>,'&)       ",
"    .!~{{{]^'/(_:.      ",
"    .<[^}^|{%'{123.     ",
"    .45666666666657.    ",
"    .8999999999997.     ",
"    .099999999997.      ",
"    .abbbbbb9997.       ",
"    ........b97.        ",
"           .b7.         ",
"           .7.          ",
"           ..           ",
"           .            ",
"                        ",
"                        ",
"                        ",
"                        "};

static const char *back_arrow_xpm[] = {
"24 24 43 1",
" 	c None",
".	c #000000",
"+	c #B9D0B9",
"@	c #CDDECB",
"#	c #B6C7B6",
"$	c #B1C9B0",
"%	c #B3C4B3",
"&	c #B4CBB2",
"*	c #B5CEB5",
"=	c #B7CCB5",
"-	c #B9CEB7",
";	c #BAD1BA",
">	c #BBCFBA",
",	c #BBD0B9",
"'	c #B2C9B0",
")	c #7EAB78",
"!	c #AAC7A8",
"~	c #B3CAB1",
"{	c #B0C9B0",
"]	c #B0C9AE",
"^	c #AEC7AC",
"/	c #AAC5A8",
"(	c #A9C4A7",
"_	c #698267",
":	c #2D2D2D",
"<	c #CFDFCC",
"[	c #ADC8AB",
"}	c #B0C7AE",
"|	c #ADC6AB",
"1	c #678C63",
"2	c #9BAD9A",
"3	c #85AE81",
"4	c #87AF84",
"5	c #87B083",
"6	c #88AF84",
"7	c #88B085",
"8	c #86AF82",
"9	c #547150",
"0	c #3C5235",
"a	c #5B7950",
"b	c #4A6342",
"c	c #3B5035",
"d	c #415639",
"                        ",
"                        ",
"  ...                   ",
"  ...       .           ",
"  ...      ..           ",
"  ...     .+.           ",
"  ...    .@#.           ",
"  ...   .@$%........    ",
"  ...  .@&*=-;->,').    ",
"  ... .@!~{]^///^(_.    ",
"  ...:<[}||[!^^}^[1.    ",
"  ...23444445645789.    ",
"  ....0aaaaaaaaaaab.    ",
"  ... .0aaaaaaaaaab.    ",
"  ...  .0aabccccccd.    ",
"  ...   .0ab........    ",
"  ...    .0b.           ",
"  ...     .b.           ",
"  ...      ..           ",
"  ...       .           ",
"  ...                   ",
"                        ",
"                        ",
"                        "};

static const char *fwd_arrow_xpm[] = {
"24 24 41 1",
" 	c None",
".	c #000000",
"+	c #8CA782",
"@	c #B1CDAE",
"#	c #77A16E",
"$	c #B4CEB1",
"%	c #ACC8A9",
"&	c #709867",
"*	c #C1D6BD",
"=	c #BDD3B8",
"-	c #BFD4BB",
";	c #C2D7BE",
">	c #B0CAAD",
",	c #B2CBB0",
"'	c #AAC7A8",
")	c #0F1308",
"!	c #AEC5A8",
"~	c #AEC8AD",
"{	c #ABC7A8",
"]	c #AAC6A7",
"^	c #A8C6A5",
"/	c #ADC8AD",
"(	c #A8C7A8",
"_	c #A5C4A3",
":	c #7F9F76",
"<	c #A6BFA0",
"[	c #ABC7AA",
"}	c #A7C5A4",
"|	c #A9C7A6",
"1	c #AFC8AD",
"2	c #A4C3A2",
"3	c #6B9060",
"4	c #778E6F",
"5	c #698D60",
"6	c #6B9063",
"7	c #445B2C",
"8	c #6B8661",
"9	c #5B7950",
"0	c #6C8562",
"a	c #65815C",
"b	c #506B46",
"                        ",
"                        ",
"                   ...  ",
"           .       ...  ",
"           ..      ...  ",
"           .+.     ...  ",
"           .@#.    ...  ",
"    ........$%&.   ...  ",
"    .*=-;;;;>,'&)  ...  ",
"    .!~{{{]^'/(_:. ...  ",
"    .<[^}^|{%'{123....  ",
"    .45666666666657...  ",
"    .8999999999997....  ",
"    .099999999997. ...  ",
"    .abbbbbb9997.  ...  ",
"    ........b97.   ...  ",
"           .b7.    ...  ",
"           .7.     ...  ",
"           ..      ...  ",
"           .       ...  ",
"                   ...  ",
"                        ",
"                        ",
"                        "};


/* ---------------- */

static const char *cursor_play_xpm[] = {
"24 24 2 1",
" 	c None",
".	c #000000",
"                        ",
"                        ",
"                        ",
"   .        .           ",
"   ..       ..          ",
"   ...      ...         ",
"   ....     ....        ",
"   .....    .....       ",
"   ......   ......      ",
"   .......  .......     ",
"   ........ ........    ",
"   ..................   ",
"   ..................   ",
"   ........ ........    ",
"   .......  .......     ",
"   ......   ......      ",
"   .....    .....       ",
"   ....     ....        ",
"   ...      ...         ",
"   ..       ..          ",
"   .        .           ",
"                        ",
"                        ",
"                        "};


static const char *play_xpm[] = {
"    24    24        2            1",
"  c None",
"# c #000000",
"                        ",
"                        ",
"                        ",
"        #               ",
"        ##              ",
"        ###             ",
"        ####            ",
"        #####           ",
"        ######          ",
"        #######         ",
"        ########        ",
"        #########       ",
"        #########       ",
"        ########        ",
"        #######         ",
"        ######          ",
"        #####           ",
"        ####            ",
"        ###             ",
"        ##              ",
"        #               ",
"                        ",
"                        ",
"                        "
};

static const char *stop_play_xpm[] = {
"    24    24        2            1",
"  c None",
"# c #000000",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        "
};


static Pixmap toolbar_pixmaps[NUM_TOOLBAR_PIXMAPS];

void make_toolbar_icons(Widget w)
{ 
  Pixmap shape1, shape2;
  XpmAttributes attributes; 
  XpmColorSymbol symbols[1];
  int i, scr;
  Display *dp;
  Drawable wn;
  
  for (i = 0; i < NUM_TOOLBAR_PIXMAPS; i++)
    toolbar_pixmaps[i] = None;

  dp = XtDisplay(w);
  wn = XtWindow(w);
  scr = DefaultScreen(dp);
  XtVaGetValues(w, XmNdepth, &attributes.depth, XmNcolormap, &attributes.colormap, NULL);
  attributes.visual = DefaultVisual(dp, scr);
  symbols[0].name = (char *)"basiccolor";
  symbols[0].value = NULL;
  symbols[0].pixel = ss->basic_color;
  attributes.colorsymbols = symbols;
  attributes.numsymbols = 1;
  attributes.valuemask = XpmColorSymbols | XpmDepth | XpmColormap | XpmVisual;

  XpmCreatePixmapFromData(dp, wn, (char **)back_arrow_xpm,  &toolbar_pixmaps[SND_XPM_BACK_ARROW],    &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)fwd_arrow_xpm,   &toolbar_pixmaps[SND_XPM_FORWARD_ARROW], &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)zoom_in_xpm,     &toolbar_pixmaps[SND_XPM_ZOOM_IN],       &shape1,  &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)zoom_out_xpm,    &toolbar_pixmaps[SND_XPM_ZOOM_OUT],      &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)cut_xpm,         &toolbar_pixmaps[SND_XPM_CUT],           &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)paste_xpm,       &toolbar_pixmaps[SND_XPM_PASTE],         &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)preferences_xpm, &toolbar_pixmaps[SND_XPM_PREFERENCES],   &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)close_xpm,       &toolbar_pixmaps[SND_XPM_CLOSE],         &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)redo_xpm,        &toolbar_pixmaps[SND_XPM_REDO],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)undo_xpm,        &toolbar_pixmaps[SND_XPM_UNDO],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)save_xpm,        &toolbar_pixmaps[SND_XPM_SAVE],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)saveas_xpm,      &toolbar_pixmaps[SND_XPM_SAVE_AS],       &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)new_xpm,         &toolbar_pixmaps[SND_XPM_NEW],           &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)open_xpm,        &toolbar_pixmaps[SND_XPM_OPEN],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)right_arrow_xpm, &toolbar_pixmaps[SND_XPM_NEXT],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)left_arrow_xpm,  &toolbar_pixmaps[SND_XPM_BACK],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)exit_xpm,        &toolbar_pixmaps[SND_XPM_EXIT],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)separator_xpm,   &toolbar_pixmaps[SND_XPM_SEPARATOR],     &shape2, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)up_node2_xpm,    &toolbar_pixmaps[SND_XPM_UP],            &shape1, &attributes); 
  XpmCreatePixmapFromData(dp, wn, (char **)stop_xpm,        &toolbar_pixmaps[SND_XPM_STOP],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)home_xpm,        &toolbar_pixmaps[SND_XPM_REVERT],        &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)play_xpm,        &toolbar_pixmaps[SND_XPM_PLAY],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)cursor_play_xpm, &toolbar_pixmaps[SND_XPM_CURSOR_PLAY],   &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)stop_play_xpm,   &toolbar_pixmaps[SND_XPM_STOP_PLAY],     &shape1, &attributes);
}


Pixmap toolbar_icon(int which)
{
  switch (which)
    {
    case SND_XPM_BACK_ARROW:    return(toolbar_pixmaps[SND_XPM_BACK_ARROW]);
    case SND_XPM_FORWARD_ARROW: return(toolbar_pixmaps[SND_XPM_FORWARD_ARROW]);
    case SND_XPM_ZOOM_IN:       return(toolbar_pixmaps[SND_XPM_ZOOM_IN]);
    case SND_XPM_ZOOM_OUT:      return(toolbar_pixmaps[SND_XPM_ZOOM_OUT]);
    case SND_XPM_CUT:           return(toolbar_pixmaps[SND_XPM_CUT]);
    case SND_XPM_PASTE:         return(toolbar_pixmaps[SND_XPM_PASTE]);
    case SND_XPM_PREFERENCES:   return(toolbar_pixmaps[SND_XPM_PREFERENCES]);
    case SND_XPM_CLOSE:         return(toolbar_pixmaps[SND_XPM_CLOSE]);
    case SND_XPM_REDO:          return(toolbar_pixmaps[SND_XPM_REDO]);
    case SND_XPM_UNDO:          return(toolbar_pixmaps[SND_XPM_UNDO]);
    case SND_XPM_SAVE:          return(toolbar_pixmaps[SND_XPM_SAVE]);
    case SND_XPM_SAVE_AS:       return(toolbar_pixmaps[SND_XPM_SAVE_AS]);
    case SND_XPM_NEW:           return(toolbar_pixmaps[SND_XPM_NEW]);
    case SND_XPM_OPEN:          return(toolbar_pixmaps[SND_XPM_OPEN]);
    case SND_XPM_NEXT:          return(toolbar_pixmaps[SND_XPM_NEXT]);
    case SND_XPM_BACK:          return(toolbar_pixmaps[SND_XPM_BACK]);
    case SND_XPM_EXIT:          return(toolbar_pixmaps[SND_XPM_EXIT]);
    case SND_XPM_SEPARATOR:     return(toolbar_pixmaps[SND_XPM_SEPARATOR]);
    case SND_XPM_UP:            return(toolbar_pixmaps[SND_XPM_UP]);
    case SND_XPM_STOP:          return(toolbar_pixmaps[SND_XPM_STOP]);
    case SND_XPM_REVERT:        return(toolbar_pixmaps[SND_XPM_REVERT]);
    case SND_XPM_PLAY:          return(toolbar_pixmaps[SND_XPM_PLAY]);
    case SND_XPM_CURSOR_PLAY:   return(toolbar_pixmaps[SND_XPM_CURSOR_PLAY]);
    case SND_XPM_STOP_PLAY:     return(toolbar_pixmaps[SND_XPM_STOP_PLAY]);
    }
  return(None);
}

#define NUM_BOMBS 15

void make_icons_transparent(const char *color)
{
  static char *bg1 = NULL;
  static char *bg4 = NULL;
  int i;
  const char **tmp;
  if (bg1) free(bg1);
  bg1 = mus_format("-      c %s s %s", color, color); /* the background color isn't known at compile time */
  mini_lock_xpm[1] = bg1;
  close_icon_xpm[1] = bg1;
  stop_sign_xpm[1] = bg1;
  blank_xpm[1] = bg1;
  for (i = 0; i < NUM_BOMBS; i++)
    {
      tmp = mini_bomb_bits(i);
      tmp[1] = bg1;
    }
  for (i = 0; i < NUM_HOURGLASSES; i++)
    {
      tmp = mini_glass_bits(i);
      tmp[1] = bg1;
    }
  if (bg4) free(bg4);
  bg4 = mus_format("  c %s", color);
  back_arrow_xpm[1] = bg4;
  fwd_arrow_xpm[1] = bg4;
  zoom_in_xpm[1] = bg4;
  zoom_out_xpm[1] = bg4;
  cut_xpm[1] = bg4;
  paste_xpm[1] = bg4;
  preferences_xpm[1] = bg4;
  close_xpm[1] = bg4;
  redo_xpm[1] = bg4;
  undo_xpm[1] = bg4;
  save_xpm[1] = bg4;
  saveas_xpm[1] = bg4;
  new_xpm[1] = bg4;
  open_xpm[1] = bg4;
  right_arrow_xpm[1] = bg4;
  left_arrow_xpm[1] = bg4;
  exit_xpm[1] = bg4;
  separator_xpm[1] = bg4;
  up_node2_xpm[1] = bg4;
  stop_xpm[1] = bg4;
  home_xpm[1] = bg4;
  play_xpm[1] = bg4;
  cursor_play_xpm[1] = bg4;
  stop_play_xpm[1] = bg4;
}

#endif


#if USE_GTK

/* /usr/share/icons/gnome/16x16/status/changes-prevent.png */
static unsigned char lock_data[845] = {
  0211, 0120, 0116, 0107, 0015, 0012, 0032, 0012, 0000, 0000, 0000, 0015, 0111, 0110, 0104, 0122,
  0000, 0000, 0000, 0020, 0000, 0000, 0000, 0020, 0010, 0006, 0000, 0000, 0000, 0037, 0363, 0377,
  0141, 0000, 0000, 0000, 0004, 0163, 0102, 0111, 0124, 0010, 0010, 0010, 0010, 0174, 0010, 0144,
  0210, 0000, 0000, 0000, 0011, 0160, 0110, 0131, 0163, 0000, 0000, 0015, 0327, 0000, 0000, 0015,
  0327, 0001, 0102, 0050, 0233, 0170, 0000, 0000, 0000, 0031, 0164, 0105, 0130, 0164, 0123, 0157,
  0146, 0164, 0167, 0141, 0162, 0145, 0000, 0167, 0167, 0167, 0056, 0151, 0156, 0153, 0163, 0143,
  0141, 0160, 0145, 0056, 0157, 0162, 0147, 0233, 0356, 0074, 0032, 0000, 0000, 0000, 0023, 0164,
  0105, 0130, 0164, 0124, 0151, 0164, 0154, 0145, 0000, 0117, 0160, 0164, 0151, 0143, 0141, 0154,
  0040, 0104, 0162, 0151, 0166, 0145, 0076, 0147, 0272, 0014, 0000, 0000, 0000, 0026, 0164, 0105,
  0130, 0164, 0101, 0165, 0164, 0150, 0157, 0162, 0000, 0114, 0141, 0160, 0157, 0040, 0103, 0141,
  0154, 0155, 0141, 0156, 0144, 0162, 0145, 0151, 0267, 0216, 0123, 0046, 0000, 0000, 0000, 0043,
  0164, 0105, 0130, 0164, 0123, 0157, 0165, 0162, 0143, 0145, 0000, 0150, 0164, 0164, 0160, 0072,
  0057, 0057, 0164, 0141, 0156, 0147, 0157, 0056, 0146, 0162, 0145, 0145, 0144, 0145, 0163, 0153,
  0164, 0157, 0160, 0056, 0157, 0162, 0147, 0175, 0262, 0214, 0247, 0000, 0000, 0002, 0132, 0111,
  0104, 0101, 0124, 0070, 0215, 0225, 0123, 0317, 0113, 0124, 0121, 0030, 0075, 0367, 0307, 0233,
  0171, 0372, 0306, 0231, 0046, 0053, 0312, 0037, 0040, 0005, 0115, 0116, 0105, 0144, 0201, 0324,
  0037, 0120, 0020, 0101, 0104, 0033, 0167, 0105, 0320, 0274, 0300, 0105, 0320, 0246, 0331, 0230,
  0030, 0021, 0043, 0046, 0102, 0213, 0104, 0322, 0126, 0055, 0132, 0271, 0227, 0152, 0025, 0256,
  0102, 0112, 0115, 0041, 0261, 0115, 0042, 0051, 0223, 0062, 0063, 0157, 0346, 0275, 0231, 0171,
  0357, 0336, 0257, 0315, 0250, 0243, 0102, 0330, 0201, 0263, 0373, 0316, 0341, 0273, 0337, 0071,
  0227, 0021, 0021, 0366, 0200, 0015, 0015, 0145, 0356, 0112, 0103, 0074, 0016, 0264, 0072, 0011,
  0015, 0041, 0004, 0377, 0345, 0007, 0152, 0042, 0036, 0153, 0036, 0111, 0245, 0122, 0376, 0256,
  0341, 0275, 0006, 0303, 0043, 0103, 0237, 0314, 0106, 0263, 0373, 0154, 0262, 0323, 0212, 0106,
  0243, 0140, 0034, 0050, 0024, 0034, 0054, 0377, 0130, 0052, 0345, 0362, 0316, 0317, 0142, 0301,
  0273, 0324, 0337, 0337, 0037, 0154, 0315, 0313, 0172, 0161, 0146, 0370, 0105, 0052, 0032, 0211,
  0164, 0137, 0271, 0332, 0155, 0315, 0317, 0055, 0170, 0233, 0033, 0233, 0112, 0153, 0315, 0342,
  0207, 0343, 0164, 0241, 0353, 0142, 0144, 0366, 0333, 0354, 0051, 0200, 0322, 0000, 0236, 0157,
  0151, 0170, 0275, 0101, 0110, 0030, 0017, 0222, 0311, 0244, 0365, 0175, 0156, 0261, 0224, 0135,
  0317, 0116, 0372, 0025, 0257, 0113, 0007, 0225, 0363, 0331, 0077, 0331, 0361, 0231, 0057, 0063,
  0245, 0304, 0231, 0204, 0045, 0270, 0354, 0251, 0327, 0154, 0033, 0330, 0066, 0063, 0224, 0322,
  0211, 0246, 0150, 0024, 0371, 0174, 0236, 0134, 0177, 0155, 0320, 0135, 0354, 0133, 0051, 0055,
  0364, 0375, 0016, 0066, 0346, 0063, 0216, 0343, 0204, 0042, 0226, 0005, 0202, 0356, 0260, 0155,
  0146, 0354, 0062, 0030, 0110, 0261, 0173, 0255, 0234, 0273, 0104, 0101, 0223, 0224, 0022, 0201,
  0137, 0215, 0140, 0145, 0354, 0053, 0157, 0014, 0027, 0105, 0143, 0270, 0250, 0162, 0223, 0253,
  0132, 0005, 0206, 0326, 0004, 0220, 0266, 0132, 0030, 0367, 0236, 0075, 0144, 0217, 0166, 0156,
  0300, 0060, 0232, 0036, 0034, 0227, 0257, 0306, 0327, 0241, 0124, 0000, 0115, 0200, 0235, 0176,
  0043, 0314, 0160, 0030, 0206, 0041, 0121, 0056, 0373, 0170, 0373, 0176, 0031, 0225, 0152, 0031,
  0134, 0110, 0074, 0311, 0114, 0210, 0301, 0364, 0375, 0227, 0266, 0315, 0136, 0163, 0000, 0040,
  0100, 0206, 0314, 0004, 0072, 0332, 0343, 0370, 0060, 0365, 0021, 0307, 0216, 0206, 0041, 0215,
  0103, 0340, 0062, 0006, 0056, 0143, 0020, 0106, 0014, 0155, 0307, 0243, 0230, 0376, 0074, 0215,
  0366, 0226, 0006, 0230, 0326, 0071, 0110, 0021, 0142, 0055, 0125, 0210, 0355, 0024, 0064, 0105,
  0160, 0347, 0366, 0065, 0200, 0231, 0000, 0371, 0120, 0312, 0007, 0100, 0040, 0322, 0010, 0163,
  0215, 0133, 0067, 0133, 0241, 0211, 0300, 0030, 0301, 0055, 0255, 0042, 0010, 0374, 0335, 0061,
  0372, 0336, 0034, 0230, 0077, 0005, 0243, 0341, 0062, 0312, 0356, 0052, 0112, 0205, 0045, 0270,
  0136, 0016, 0236, 0353, 0154, 0323, 0365, 0012, 0320, 0312, 0305, 0351, 0316, 0033, 0373, 0123,
  0040, 0000, 0014, 0254, 0126, 0057, 0016, 0060, 0206, 0203, 0140, 0247, 0007, 0244, 0016, 0044,
  0370, 0207, 0101, 0025, 0373, 0176, 0305, 0377, 0030, 0020, 0005, 0000, 0152, 0133, 0120, 0000,
  0020, 0253, 0075, 0145, 0207, 0254, 0306, 0172, 0154, 0365, 0040, 0160, 0066, 0027, 0144, 0363,
  0211, 0353, 0200, 0074, 0002, 0156, 0306, 0021, 0246, 0066, 0040, 0124, 0200, 0010, 0345, 0140,
  0230, 0016, 0114, 0313, 0103, 0103, 0305, 0005, 0351, 0012, 0212, 0205, 0015, 0150, 0150, 0132,
  0013, 0101, 0061, 0042, 0302, 0100, 0212, 0365, 0050, 0340, 0035, 0010, 0342, 0040, 0153, 0063,
  0006, 0045, 0004, 0172, 0237, 0216, 0322, 0330, 0137, 0070, 0154, 0010, 0037, 0320, 0076, 0105,
  0075, 0000, 0000, 0000, 0000, 0111, 0105, 0116, 0104, 0256, 0102, 0140, 0202};


/* /usr/share/icons/gnome/16x16/actions/stop.png */

static unsigned char stop_data[664] = {
  0211, 0120, 0116, 0107, 0015, 0012, 0032, 0012, 0000, 0000, 0000, 0015, 0111, 0110, 0104, 0122,
  0000, 0000, 0000, 0020, 0000, 0000, 0000, 0020, 0010, 0006, 0000, 0000, 0000, 0037, 0363, 0377,
  0141, 0000, 0000, 0000, 0004, 0163, 0102, 0111, 0124, 0010, 0010, 0010, 0010, 0174, 0010, 0144,
  0210, 0000, 0000, 0000, 0011, 0160, 0110, 0131, 0163, 0000, 0000, 0015, 0327, 0000, 0000, 0015,
  0327, 0001, 0102, 0050, 0233, 0170, 0000, 0000, 0000, 0031, 0164, 0105, 0130, 0164, 0123, 0157,
  0146, 0164, 0167, 0141, 0162, 0145, 0000, 0167, 0167, 0167, 0056, 0151, 0156, 0153, 0163, 0143,
  0141, 0160, 0145, 0056, 0157, 0162, 0147, 0233, 0356, 0074, 0032, 0000, 0000, 0000, 0023, 0164,
  0105, 0130, 0164, 0124, 0151, 0164, 0154, 0145, 0000, 0117, 0160, 0164, 0151, 0143, 0141, 0154,
  0040, 0104, 0162, 0151, 0166, 0145, 0076, 0147, 0272, 0014, 0000, 0000, 0001, 0366, 0111, 0104,
  0101, 0124, 0070, 0215, 0255, 0323, 0075, 0113, 0133, 0121, 0030, 0007, 0360, 0377, 0163, 0316,
  0211, 0046, 0067, 0157, 0213, 0203, 0120, 0244, 0275, 0122, 0024, 0132, 0154, 0213, 0012, 0035,
  0274, 0245, 0111, 0276, 0205, 0004, 0164, 0250, 0366, 0053, 0070, 0165, 0312, 0224, 0017, 0241,
  0240, 0040, 0116, 0165, 0353, 0032, 0245, 0352, 0046, 0016, 0015, 0035, 0264, 0045, 0267, 0064,
  0264, 0103, 0307, 0244, 0001, 0223, 0363, 0362, 0164, 0310, 0275, 0061, 0057, 0155, 0207, 0322,
  0077, 0234, 0345, 0302, 0363, 0273, 0347, 0171, 0316, 0071, 0304, 0314, 0210, 0123, 0255, 0126,
  0226, 0204, 0232, 0272, 0160, 0316, 0146, 0061, 0026, 0051, 0105, 0313, 0152, 0035, 0354, 0354,
  0274, 0251, 0017, 0177, 0247, 0030, 0250, 0126, 0053, 0113, 0052, 0061, 0175, 0126, 0054, 0224,
  0162, 0276, 0357, 0323, 0070, 0020, 0206, 0041, 0237, 0234, 0326, 0132, 0106, 0167, 0137, 0014,
  0043, 0304, 0314, 0043, 0305, 0351, 0353, 0033, 0272, 0332, 0330, 0204, 0063, 0346, 0356, 0057,
  0112, 0141, 0365, 0350, 0020, 0077, 0347, 0347, 0047, 0020, 0231, 0112, 0311, 0273, 0342, 0117,
  0237, 0251, 0276, 0375, 0032, 0317, 0147, 0147, 0361, 0150, 0146, 0006, 0367, 0263, 0131, 0314,
  0245, 0323, 0310, 0013, 0201, 0217, 0157, 0217, 0061, 0027, 0004, 0164, 0157, 0145, 0145, 0372,
  0153, 0263, 0131, 0076, 0173, 0137, 0173, 0027, 0004, 0057, 0177, 0010, 0231, 0110, 0234, 0027,
  0013, 0245, 0134, 0246, 0321, 0240, 0372, 0326, 0066, 0236, 0345, 0363, 0310, 0050, 0005, 0347,
  0034, 0230, 0031, 0314, 0214, 0264, 0224, 0170, 0110, 0204, 0017, 0257, 0266, 0220, 0276, 0276,
  0241, 0142, 0241, 0224, 0023, 0152, 0352, 0002, 0000, 0204, 0265, 0056, 0347, 0373, 0076, 0135,
  0256, 0227, 0361, 0330, 0363, 0340, 0111, 0011, 0255, 0065, 0214, 0326, 0160, 0326, 0366, 0041,
  0347, 0340, 0011, 0201, 0007, 0306, 0340, 0152, 0143, 0023, 0276, 0357, 0123, 0074, 0150, 0025,
  0367, 0311, 0306, 0040, 0105, 0004, 0243, 0065, 0010, 0000, 0063, 0303, 0071, 0007, 0153, 0055,
  0254, 0265, 0160, 0326, 0042, 0011, 0214, 0314, 0146, 0004, 0000, 0000, 0243, 0065, 0004, 0021,
  0100, 0064, 0330, 0276, 0213, 0200, 0030, 0031, 0317, 0004, 0100, 0021, 0200, 0030, 0160, 0256,
  0217, 0030, 0003, 0373, 0067, 0100, 0050, 0205, 0166, 0267, 0213, 0224, 0224, 0375, 0026, 0242,
  0066, 0070, 0006, 0254, 0305, 0155, 0164, 0244, 0303, 0021, 0102, 0310, 0166, 0030, 0206, 0274,
  0174, 0260, 0217, 0057, 0021, 0242, 0265, 0206, 0351, 0365, 0372, 0113, 0353, 0101, 0361, 0067,
  0317, 0303, 0352, 0321, 0041, 0302, 0060, 0144, 0051, 0105, 0013, 0000, 0204, 0063, 0275, 0265,
  0223, 0323, 0132, 0253, 0263, 0270, 0300, 0117, 0366, 0166, 0321, 0114, 0046, 0321, 0211, 0266,
  0033, 0037, 0345, 0055, 0200, 0357, 0236, 0207, 0247, 0173, 0273, 0203, 0313, 0144, 0265, 0016,
  0176, 0173, 0023, 0063, 0215, 0006, 0135, 0256, 0227, 0301, 0103, 0323, 0026, 0112, 0141, 0371,
  0140, 0037, 0235, 0305, 0205, 0211, 0233, 0370, 0177, 0336, 0102, 0234, 0152, 0265, 0262, 0044,
  0023, 0211, 0163, 0153, 0135, 0156, 0034, 0020, 0102, 0266, 0235, 0351, 0255, 0375, 0361, 0065,
  0376, 0153, 0176, 0001, 0260, 0151, 0115, 0356, 0212, 0245, 0300, 0236, 0000, 0000, 0000, 0000,
  0111, 0105, 0116, 0104, 0256, 0102, 0140, 0202};


/* /usr/share/icons/gnome/16x16/status/audio-volume-medium.png */ 

static unsigned char speaker_data[709] = {
  0211, 0120, 0116, 0107, 0015, 0012, 0032, 0012, 0000, 0000, 0000, 0015, 0111, 0110, 0104, 0122,
  0000, 0000, 0000, 0020, 0000, 0000, 0000, 0020, 0010, 0006, 0000, 0000, 0000, 0037, 0363, 0377,
  0141, 0000, 0000, 0000, 0004, 0163, 0102, 0111, 0124, 0010, 0010, 0010, 0010, 0174, 0010, 0144,
  0210, 0000, 0000, 0000, 0011, 0160, 0110, 0131, 0163, 0000, 0000, 0015, 0327, 0000, 0000, 0015,
  0327, 0001, 0102, 0050, 0233, 0170, 0000, 0000, 0000, 0031, 0164, 0105, 0130, 0164, 0123, 0157,
  0146, 0164, 0167, 0141, 0162, 0145, 0000, 0167, 0167, 0167, 0056, 0151, 0156, 0153, 0163, 0143,
  0141, 0160, 0145, 0056, 0157, 0162, 0147, 0233, 0356, 0074, 0032, 0000, 0000, 0002, 0102, 0111,
  0104, 0101, 0124, 0070, 0215, 0245, 0223, 0121, 0110, 0123, 0121, 0034, 0306, 0277, 0273, 0173,
  0266, 0353, 0346, 0326, 0234, 0256, 0034, 0065, 0163, 0054, 0103, 0222, 0234, 0071, 0067, 0326,
  0130, 0057, 0076, 0011, 0215, 0105, 0010, 0021, 0004, 0126, 0220, 0017, 0265, 0300, 0325, 0154,
  0303, 0352, 0251, 0007, 0261, 0007, 0173, 0212, 0036, 0043, 0044, 0010, 0021, 0174, 0021, 0045,
  0207, 0214, 0211, 0046, 0124, 0232, 0212, 0271, 0302, 0207, 0044, 0020, 0264, 0061, 0357, 0066,
  0247, 0273, 0167, 0153, 0133, 0247, 0007, 0141, 0154, 0266, 0010, 0362, 0300, 0377, 0345, 0073,
  0037, 0077, 0176, 0374, 0071, 0207, 0241, 0224, 0342, 0060, 0107, 0122, 0056, 0274, 0357, 0277,
  0343, 0360, 0075, 0352, 0231, 0374, 0057, 0300, 0075, 0237, 0333, 0044, 0223, 0162, 0157, 0163,
  0331, 0134, 0107, 0161, 0156, 0164, 0366, 0327, 0377, 0023, 0340, 0365, 0272, 0215, 0122, 0102,
  0246, 0335, 0267, 0075, 0252, 0342, 0274, 0361, 0322, 0063, 0055, 0005, 0073, 0157, 0160, 0015,
  0330, 0377, 0012, 0360, 0373, 0357, 0352, 0130, 0216, 0314, 0335, 0350, 0272, 0245, 0326, 0037,
  0257, 0103, 0145, 0245, 0262, 0120, 0132, 0033, 0353, 0335, 0146, 0030, 0111, 0067, 0107, 0144,
  0243, 0015, 0235, 0203, 0307, 0212, 0001, 0304, 0367, 0320, 0063, 0233, 0317, 0347, 0317, 0023,
  0102, 0162, 0227, 0135, 0235, 0122, 0103, 0275, 0121, 0302, 0262, 0004, 0255, 0055, 0155, 0000,
  0000, 0303, 0305, 0247, 0275, 0171, 0066, 0077, 0274, 0061, 0376, 0170, 0314, 0336, 0375, 0362,
  0212, 0204, 0260, 0127, 0001, 0074, 0057, 0030, 0244, 0063, 0331, 0013, 0136, 0117, 0037, 0021,
  0323, 0331, 0012, 0163, 0253, 0225, 0345, 0371, 0030, 0050, 0245, 0130, 0136, 0131, 0332, 0057,
  0060, 0214, 0234, 0344, 0045, 0203, 0000, 0240, 0321, 0250, 0106, 0152, 0252, 0325, 0256, 0022,
  0203, 0346, 0246, 0026, 0350, 0117, 0350, 0321, 0334, 0324, 0202, 0150, 0064, 0202, 0371, 0305,
  0217, 0070, 0252, 0255, 0101, 0064, 0032, 0005, 0000, 0150, 0153, 0125, 0103, 0232, 0052, 0355,
  0002, 0000, 0050, 0225, 0352, 0071, 0271, 0102, 0366, 0272, 0144, 0007, 0123, 0301, 0040, 0302,
  0341, 0060, 0246, 0202, 0101, 0174, 0135, 0373, 0202, 0365, 0157, 0353, 0110, 0011, 0002, 0104,
  0061, 0015, 0000, 0320, 0310, 0253, 0241, 0077, 0251, 0223, 0000, 0200, 0102, 0041, 0325, 0250,
  0224, 0212, 0130, 0211, 0301, 0346, 0126, 0004, 0201, 0100, 0000, 0233, 0133, 0021, 0034, 0121,
  0126, 0201, 0347, 0171, 0044, 0223, 0111, 0010, 0102, 0006, 0000, 0260, 0275, 0227, 0354, 0142,
  0066, 0330, 0020, 0000, 0144, 0062, 0077, 0353, 0050, 0150, 0244, 0004, 0040, 0212, 0231, 0205,
  0241, 0067, 0303, 0226, 0012, 0071, 0227, 0231, 0171, 0067, 0313, 0312, 0010, 0107, 0142, 0074,
  0137, 0060, 0340, 0371, 0030, 0223, 0210, 0307, 0037, 0000, 0100, 0042, 0276, 0333, 0043, 0345,
  0310, 0150, 0011, 0140, 0361, 0303, 0173, 0053, 0000, 0264, 0073, 0235, 0272, 0320, 0364, 0314,
  0322, 0231, 0306, 0323, 0265, 0051, 0041, 0305, 0010, 0342, 0276, 0301, 0367, 0361, 0276, 0176,
  0000, 0260, 0134, 0177, 0141, 0043, 0122, 0316, 0042, 0377, 0105, 0256, 0225, 0175, 0007, 0241,
  0211, 0211, 0037, 0251, 0235, 0135, 0307, 0247, 0345, 0317, 0211, 0225, 0325, 0125, 0052, 0010,
  0351, 0102, 0351, 0154, 0373, 0023, 0145, 0054, 0266, 0067, 0222, 0340, 0167, 0274, 0241, 0127,
  0067, 0323, 0305, 0000, 0120, 0112, 0113, 0306, 0154, 0263, 0231, 0054, 0166, 0173, 0322, 0324,
  0146, 0245, 0305, 0371, 0251, 0216, 0201, 0206, 0203, 0135, 0112, 0351, 0237, 0000, 0112, 0051,
  0316, 0131, 0054, 0016, 0263, 0315, 0076, 0131, 0356, 0356, 0340, 0060, 0207, 0375, 0316, 0277,
  0001, 0307, 0174, 0034, 0051, 0156, 0365, 0066, 0020, 0000, 0000, 0000, 0000, 0111, 0105, 0116,
  0104, 0256, 0102, 0140, 0202};


/* /usr/share/icons/oxygen/16x16/status/dialog-warning.png */

static unsigned char bomb_data[596] = {
  0211, 0120, 0116, 0107, 0015, 0012, 0032, 0012, 0000, 0000, 0000, 0015, 0111, 0110, 0104, 0122,
  0000, 0000, 0000, 0020, 0000, 0000, 0000, 0020, 0010, 0006, 0000, 0000, 0000, 0037, 0363, 0377,
  0141, 0000, 0000, 0000, 0004, 0163, 0102, 0111, 0124, 0010, 0010, 0010, 0010, 0174, 0010, 0144,
  0210, 0000, 0000, 0000, 0011, 0160, 0110, 0131, 0163, 0000, 0000, 0001, 0273, 0000, 0000, 0001,
  0273, 0001, 0072, 0354, 0343, 0342, 0000, 0000, 0000, 0031, 0164, 0105, 0130, 0164, 0123, 0157,
  0146, 0164, 0167, 0141, 0162, 0145, 0000, 0167, 0167, 0167, 0056, 0151, 0156, 0153, 0163, 0143,
  0141, 0160, 0145, 0056, 0157, 0162, 0147, 0233, 0356, 0074, 0032, 0000, 0000, 0001, 0321, 0111,
  0104, 0101, 0124, 0170, 0332, 0245, 0222, 0275, 0153, 0123, 0121, 0030, 0207, 0237, 0367, 0334,
  0357, 0336, 0336, 0174, 0124, 0323, 0350, 0140, 0205, 0024, 0127, 0035, 0072, 0166, 0120, 0212,
  0372, 0007, 0050, 0342, 0242, 0213, 0272, 0110, 0121, 0227, 0342, 0042, 0024, 0034, 0265, 0010,
  0132, 0024, 0104, 0161, 0322, 0105, 0161, 0020, 0203, 0330, 0072, 0364, 0057, 0350, 0052, 0124,
  0021, 0007, 0151, 0051, 0105, 0152, 0022, 0233, 0064, 0311, 0375, 0310, 0021, 0162, 0301, 0273,
  0330, 0264, 0322, 0007, 0176, 0160, 0016, 0234, 0363, 0360, 0173, 0017, 0107, 0264, 0326, 0354,
  0007, 0305, 0000, 0242, 0252, 0175, 0065, 0171, 0357, 0134, 0140, 0020, 0132, 0353, 0177, 0046,
  0136, 0264, 0056, 0106, 0213, 0247, 0172, 0321, 0322, 0071, 0335, 0135, 0260, 0056, 0355, 0164,
  0116, 0355, 0050, 0016, 0335, 0207, 0346, 0330, 0264, 0030, 0245, 0363, 0310, 0266, 0375, 0340,
  0277, 0106, 0350, 0175, 0062, 0246, 0305, 0077, 0163, 0010, 0303, 0100, 0014, 0120, 0301, 0311,
  0321, 0350, 0243, 0175, 0153, 0317, 0202, 0044, 0366, 0357, 0032, 0007, 0047, 0131, 0176, 0162,
  0237, 0345, 0247, 0217, 0120, 0205, 0343, 0350, 0330, 0234, 0335, 0223, 0040, 0136, 0260, 0356,
  0310, 0360, 0344, 0001, 0330, 0242, 0261, 0362, 0225, 0306, 0227, 0157, 0210, 0324, 0120, 0376,
  0211, 0221, 0360, 0203, 0065, 0273, 0273, 0040, 0011, 0156, 0033, 0305, 0012, 0260, 0206, 0243,
  0244, 0037, 0324, 0052, 0106, 0056, 0240, 0027, 0173, 0063, 0003, 0005, 0235, 0252, 0272, 0147,
  0004, 0225, 0234, 0030, 0353, 0140, 0156, 0342, 0005, 0171, 0374, 0221, 0121, 0160, 0132, 0210,
  0327, 0104, 0025, 0307, 0202, 0366, 0073, 0065, 0007, 0031, 0331, 0107, 0172, 0046, 0126, 0253,
  0350, 0066, 0206, 0216, 0046, 0236, 0130, 0021, 0030, 0360, 0375, 0125, 0011, 0235, 0204, 0214,
  0137, 0153, 0200, 0200, 0116, 0034, 0232, 0237, 0165, 0073, 0030, 0017, 0363, 0114, 0350, 0010,
  0300, 0204, 0224, 0346, 0220, 0074, 0066, 0013, 0256, 0047, 0371, 0072, 0230, 0364, 0123, 0271,
  0361, 0063, 0355, 0050, 0364, 0221, 0136, 0027, 0253, 0134, 0360, 0232, 0053, 0321, 0374, 0360,
  0004, 0327, 0263, 0006, 0057, 0305, 0157, 0164, 0162, 0265, 0334, 0124, 0333, 0022, 0067, 0112,
  0005, 0026, 0254, 0317, 0027, 0000, 0070, 0074, 0123, 0207, 0036, 0020, 0203, 0356, 0172, 0374,
  0256, 0112, 0324, 0361, 0266, 0213, 0345, 0313, 0272, 0245, 0000, 0032, 0165, 0136, 0330, 0025,
  0057, 0275, 0154, 0003, 0116, 0032, 0023, 0301, 0024, 0001, 0223, 0254, 0205, 0152, 0143, 0037,
  0013, 0054, 0267, 0306, 0363, 0277, 0043, 0164, 0327, 0230, 0012, 0316, 0006, 0151, 0335, 0170,
  0003, 0064, 0220, 0100, 0351, 0146, 0055, 0135, 0157, 0245, 0173, 0142, 0200, 0062, 0316, 0221,
  0074, 0315, 0245, 0315, 0323, 0331, 0033, 0030, 0352, 0355, 0257, 0067, 0077, 0256, 0204, 0253,
  0241, 0146, 0127, 0066, 0020, 0267, 0246, 0225, 0037, 0277, 0316, 0336, 0140, 0037, 0374, 0001,
  0075, 0255, 0302, 0111, 0346, 0040, 0215, 0173, 0000, 0000, 0000, 0000, 0111, 0105, 0116, 0104,
  0256, 0102, 0140, 0202};

#if 0
static unsigned char bomb_data_24[2010] = {
  0211, 0120, 0116, 0107, 0015, 0012, 0032, 0012, 0000, 0000, 0000, 0015, 0111, 0110, 0104, 0122,
  0000, 0000, 0000, 0030, 0000, 0000, 0000, 0030, 0010, 0006, 0000, 0000, 0000, 0340, 0167, 0075,
  0370, 0000, 0000, 0000, 0006, 0142, 0113, 0107, 0104, 0000, 0376, 0000, 0376, 0000, 0376, 0353,
  0030, 0324, 0202, 0000, 0000, 0000, 0011, 0160, 0110, 0131, 0163, 0000, 0000, 0015, 0326, 0000,
  0000, 0015, 0326, 0001, 0220, 0157, 0171, 0234, 0000, 0000, 0000, 0011, 0166, 0160, 0101, 0147,
  0000, 0000, 0000, 0030, 0000, 0000, 0000, 0030, 0000, 0170, 0114, 0245, 0246, 0000, 0000, 0003,
  0300, 0111, 0104, 0101, 0124, 0110, 0307, 0265, 0225, 0115, 0150, 0134, 0125, 0030, 0206, 0237,
  0163, 0316, 0235, 0073, 0223, 0073, 0223, 0111, 0234, 0144, 0222, 0114, 0046, 0115, 0310, 0044,
  0326, 0332, 0304, 0104, 0353, 0137, 0301, 0126, 0254, 0165, 0241, 0124, 0020, 0225, 0210, 0240,
  0304, 0240, 0050, 0126, 0011, 0052, 0102, 0177, 0124, 0064, 0320, 0215, 0202, 0042, 0245, 0324,
  0212, 0340, 0312, 0215, 0210, 0113, 0105, 0167, 0041, 0065, 0125, 0101, 0233, 0022, 0321, 0032,
  0264, 0155, 0114, 0332, 0116, 0232, 0304, 0114, 0376, 0347, 0357, 0336, 0173, 0216, 0213, 0321,
  0272, 0150, 0143, 0223, 0246, 0276, 0360, 0155, 0316, 0371, 0316, 0373, 0234, 0157, 0361, 0361,
  0302, 0377, 0054, 0261, 0332, 0306, 0305, 0327, 0354, 0267, 0254, 0326, 0235, 0373, 0105, 0054,
  0045, 0374, 0343, 0037, 0017, 0073, 0052, 0277, 0125, 0364, 0241, 0257, 0311, 0057, 0262, 0173,
  0150, 0310, 0176, 0270, 0075, 0357, 0215, 0016, 0030, 0357, 0217, 0101, 0223, 0373, 0254, 0247,
  0260, 0264, 0227, 0047, 0127, 0363, 0126, 0256, 0246, 0311, 0267, 0043, 0357, 0132, 0167, 0074,
  0153, 0233, 0314, 0050, 0172, 0154, 0220, 0300, 0315, 0217, 0333, 0204, 0052, 0336, 0067, 0175,
  0330, 0353, 0006, 0054, 0354, 0341, 0006, 0253, 0345, 0236, 0207, 0125, 0174, 0223, 0320, 0323,
  0043, 0230, 0205, 0064, 0040, 0260, 0266, 0164, 0127, 0054, 0144, 0171, 0141, 0335, 0000, 0023,
  0212, 0036, 0016, 0334, 0332, 0035, 0320, 0027, 0176, 0102, 0140, 0020, 0001, 0007, 0075, 0376,
  0035, 0126, 0373, 0043, 0001, 0053, 0022, 0077, 0060, 0325, 0107, 0344, 0252, 0001, 0363, 0373,
  0270, 0335, 0112, 0335, 0273, 0215, 0160, 0134, 0350, 0364, 0020, 0262, 0152, 0003, 0252, 0261,
  0003, 0063, 0067, 0016, 0113, 0223, 0310, 0055, 0117, 0205, 0354, 0054, 0373, 0256, 0032, 0340,
  0212, 0350, 0021, 0273, 0375, 0041, 0133, 0217, 0035, 0003, 0343, 0041, 0343, 0315, 0210, 0362,
  0132, 0104, 0044, 0206, 0177, 0246, 0237, 0100, 0152, 0273, 0245, 0303, 0211, 0127, 0027, 0173,
  0211, 0257, 0031, 0060, 0371, 0012, 0367, 0251, 0226, 0273, 0333, 0261, 0202, 0102, 0247, 0117,
  0240, 0152, 0132, 0110, 0117, 0057, 0060, 0236, 0276, 0200, 0111, 0154, 0306, 0054, 0116, 0140,
  0376, 0374, 0015, 0273, 0363, 0261, 0300, 0262, 0342, 0300, 0232, 0000, 0006, 0204, 0253, 0312,
  0217, 0224, 0155, 0334, 0021, 0324, 0243, 0003, 0010, 0051, 0220, 0325, 0115, 0034, 0376, 0364,
  0033, 0366, 0037, 0374, 0002, 0337, 0166, 0020, 0225, 0011, 0374, 0321, 0243, 0330, 0311, 0016,
  0245, 0243, 0015, 0075, 0351, 0027, 0151, 0132, 0065, 0140, 0274, 0227, 0107, 0355, 0346, 0255,
  0015, 0322, 0270, 0350, 0311, 0223, 0310, 0344, 0046, 0060, 0105, 0052, 0034, 0211, 0205, 0117,
  0110, 0272, 0130, 0015, 0155, 0230, 0334, 0014, 0146, 0342, 0004, 0221, 0366, 0373, 0255, 0274,
  0340, 0275, 0125, 0001, 0114, 0027, 0312, 0227, 0341, 0203, 0221, 0324, 0155, 0041, 0075, 0172,
  0024, 0031, 0014, 0042, 0143, 0365, 0030, 0057, 0107, 0165, 0104, 0022, 0055, 0023, 0030, 0057,
  0017, 0266, 0215, 0214, 0067, 0241, 0307, 0276, 0045, 0024, 0333, 0240, 0144, 0064, 0271, 0353,
  0324, 0363, 0264, 0137, 0021, 0060, 0122, 0311, 0323, 0201, 0144, 0147, 0114, 0345, 0147, 0321,
  0063, 0247, 0120, 0015, 0067, 0202, 0237, 0003, 0057, 0107, 0074, 0252, 0210, 0072, 0200, 0237,
  0005, 0157, 0031, 0225, 0110, 0141, 0346, 0307, 0361, 0177, 0377, 0232, 0150, 0343, 0346, 0240,
  0147, 0070, 0364, 0237, 0200, 0321, 0036, 0102, 0332, 0262, 0337, 0216, 0065, 0156, 0014, 0351,
  0261, 0143, 0310, 0160, 0024, 0121, 0131, 0005, 0136, 0016, 0274, 0045, 0232, 0253, 0064, 0101,
  0177, 0036, 0226, 0322, 0260, 0174, 0036, 0241, 0263, 0250, 0372, 0024, 0372, 0334, 0017, 0070,
  0321, 0353, 0204, 0050, 0253, 0272, 0363, 0347, 0147, 0270, 0153, 0105, 0300, 0054, 0274, 0344,
  0324, 0266, 0224, 0311, 0345, 0363, 0230, 0271, 0061, 0124, 0175, 0013, 0046, 0077, 0003, 0271,
  0111, 0130, 0236, 0244, 0055, 0141, 0330, 0275, 0253, 0261, 0064, 0221, 0357, 0202, 0056, 0042,
  0233, 0072, 0020, 0226, 0205, 0116, 0017, 0021, 0157, 0155, 0013, 0271, 0206, 0017, 0056, 0013,
  0370, 0361, 0071, 0052, 0214, 0120, 0157, 0124, 0045, 0022, 0145, 0346, 0354, 0367, 0210, 0110,
  0024, 0021, 0166, 0300, 0315, 0142, 0274, 0074, 0106, 0027, 0171, 0140, 0357, 0127, 0354, 0170,
  0371, 0113, 0062, 0163, 0113, 0030, 0135, 0304, 0150, 0027, 0041, 0101, 0065, 0167, 0142, 0062,
  0247, 0161, 0202, 0122, 0250, 0160, 0374, 0372, 0343, 0335, 0074, 0170, 0011, 0300, 0313, 0362,
  0172, 0171, 0115, 0062, 0020, 0130, 0236, 0300, 0024, 0027, 0261, 0122, 0067, 0201, 0166, 0057,
  0226, 0361, 0135, 0026, 0263, 0245, 0362, 0375, 0142, 0351, 0334, 0057, 0335, 0251, 0144, 0053,
  0042, 0350, 0240, 0047, 0117, 0122, 0337, 0324, 0130, 0346, 0032, 0016, 0231, 0276, 0222, 0267,
  0005, 0320, 0337, 0105, 0235, 0207, 0352, 0255, 0253, 0213, 0005, 0165, 0346, 0127, 0144, 0145,
  0015, 0302, 0011, 0227, 0114, 0204, 0004, 0041, 0021, 0010, 0372, 0337, 0331, 0106, 0321, 0323,
  0070, 0101, 0001, 0176, 0261, 0264, 0061, 0106, 0203, 0321, 0310, 0144, 0053, 0376, 0351, 0141,
  0302, 0221, 0070, 0301, 0362, 0130, 0315, 0340, 0110, 0346, 0011, 0340, 0023, 0013, 0300, 0207,
  0335, 0065, 0261, 0162, 0151, 0025, 0146, 0060, 0136, 0001, 0075, 0073, 0105, 0141, 0340, 0363,
  0313, 0156, 0246, 0002, 0012, 0254, 0054, 0263, 0220, 0046, 0131, 0023, 0166, 0176, 0231, 0311,
  0274, 0171, 0021, 0260, 0120, 0040, 0222, 0020, 0312, 0106, 0052, 0104, 0105, 0003, 0030, 0303,
  0125, 0113, 0052, 0334, 0371, 0002, 0256, 0056, 0145, 0205, 0005, 0060, 0064, 0305, 0200, 0045,
  0147, 0272, 0306, 0317, 0146, 0352, 0244, 0224, 0172, 0015, 0111, 0172, 0351, 0004, 0332, 0107,
  0033, 0123, 0030, 0236, 0346, 0043, 0370, 0327, 0251, 0072, 0000, 0055, 0267, 0324, 0022, 0227,
  0152, 0035, 0356, 0177, 0153, 0044, 0303, 0374, 0134, 0236, 0163, 0300, 0231, 0177, 0314, 0002,
  0100, 0045, 0134, 0071, 0002, 0127, 0051, 0037, 0230, 0007, 0162, 0327, 0310, 0157, 0145, 0375,
  0005, 0324, 0210, 0175, 0376, 0216, 0127, 0307, 0103, 0000, 0000, 0000, 0045, 0164, 0105, 0130,
  0164, 0144, 0141, 0164, 0145, 0072, 0143, 0162, 0145, 0141, 0164, 0145, 0000, 0062, 0060, 0060,
  0071, 0055, 0061, 0061, 0055, 0062, 0063, 0124, 0061, 0065, 0072, 0065, 0067, 0072, 0061, 0071,
  0053, 0060, 0061, 0072, 0060, 0060, 0362, 0065, 0257, 0206, 0000, 0000, 0000, 0045, 0164, 0105,
  0130, 0164, 0144, 0141, 0164, 0145, 0072, 0155, 0157, 0144, 0151, 0146, 0171, 0000, 0062, 0060,
  0060, 0071, 0055, 0061, 0061, 0055, 0062, 0063, 0124, 0061, 0065, 0072, 0065, 0067, 0072, 0061,
  0071, 0053, 0060, 0061, 0072, 0060, 0060, 0203, 0150, 0027, 0072, 0000, 0000, 0000, 0031, 0164,
  0105, 0130, 0164, 0123, 0157, 0146, 0164, 0167, 0141, 0162, 0145, 0000, 0167, 0167, 0167, 0056,
  0151, 0156, 0153, 0163, 0143, 0141, 0160, 0145, 0056, 0157, 0162, 0147, 0233, 0356, 0074, 0032,
  0000, 0000, 0000, 0000, 0111, 0105, 0116, 0104, 0256, 0102, 0140, 0202};
#endif


/* /usr/share/icons/gnome/16x16/actions/go-next.png */

static unsigned char right_arrow_data[641] = {
  0211, 0120, 0116, 0107, 0015, 0012, 0032, 0012, 0000, 0000, 0000, 0015, 0111, 0110, 0104, 0122,
  0000, 0000, 0000, 0020, 0000, 0000, 0000, 0020, 0010, 0006, 0000, 0000, 0000, 0037, 0363, 0377,
  0141, 0000, 0000, 0000, 0004, 0163, 0102, 0111, 0124, 0010, 0010, 0010, 0010, 0174, 0010, 0144,
  0210, 0000, 0000, 0000, 0011, 0160, 0110, 0131, 0163, 0000, 0000, 0015, 0327, 0000, 0000, 0015,
  0327, 0001, 0102, 0050, 0233, 0170, 0000, 0000, 0000, 0031, 0164, 0105, 0130, 0164, 0123, 0157,
  0146, 0164, 0167, 0141, 0162, 0145, 0000, 0167, 0167, 0167, 0056, 0151, 0156, 0153, 0163, 0143,
  0141, 0160, 0145, 0056, 0157, 0162, 0147, 0233, 0356, 0074, 0032, 0000, 0000, 0000, 0023, 0164,
  0105, 0130, 0164, 0124, 0151, 0164, 0154, 0145, 0000, 0117, 0160, 0164, 0151, 0143, 0141, 0154,
  0040, 0104, 0162, 0151, 0166, 0145, 0076, 0147, 0272, 0014, 0000, 0000, 0001, 0337, 0111, 0104,
  0101, 0124, 0070, 0215, 0225, 0223, 0115, 0117, 0023, 0121, 0024, 0206, 0337, 0371, 0052, 0244,
  0123, 0326, 0044, 0044, 0376, 0013, 0067, 0166, 0341, 0326, 0030, 0115, 0014, 0311, 0135, 0130,
  0100, 0124, 0242, 0321, 0040, 0215, 0330, 0301, 0231, 0164, 0054, 0024, 0010, 0026, 0246, 0261,
  0222, 0206, 0220, 0360, 0141, 0232, 0252, 0213, 0156, 0272, 0102, 0211, 0155, 0360, 0167, 0230,
  0052, 0020, 0304, 0064, 0272, 0223, 0224, 0151, 0321, 0351, 0235, 0341, 0270, 0122, 0011, 0231,
  0051, 0172, 0222, 0273, 0170, 0223, 0347, 0175, 0026, 0047, 0347, 0012, 0104, 0004, 0277, 0261,
  0254, 0247, 0121, 0210, 0102, 0036, 0204, 0043, 0020, 0062, 0206, 0141, 0126, 0375, 0070, 0321,
  0267, 0015, 0200, 0104, 0141, 0341, 0312, 0345, 0253, 0347, 0357, 0336, 0271, 0167, 0121, 0355,
  0211, 0274, 0315, 0146, 0347, 0331, 0177, 0011, 0004, 0102, 0157, 0250, 0053, 0204, 0110, 0244,
  0007, 0267, 0157, 0216, 0310, 0341, 0210, 0132, 0362, 0223, 0004, 0012, 0040, 0042, 0121, 0251,
  0126, 0334, 0257, 0337, 0352, 0120, 0224, 0120, 0240, 0044, 0120, 0140, 0114, 0230, 0233, 0077,
  0217, 0176, 0304, 0066, 0336, 0154, 0164, 0226, 0020, 0121, 0307, 0147, 0131, 0031, 0226, 0137,
  0132, 0344, 0173, 0237, 0167, 0311, 0161, 0034, 0152, 0066, 0155, 0132, 0132, 0316, 0163, 0313,
  0312, 0060, 0042, 0202, 0100, 0104, 0130, 0314, 0347, 0146, 0074, 0317, 0323, 0044, 0111, 0312,
  0075, 0172, 0250, 0245, 0117, 0347, 0271, 0371, 0031, 0246, 0206, 0325, 0122, 0377, 0265, 0176,
  0271, 0257, 0357, 0034, 0070, 0157, 0343, 0105, 0141, 0315, 0155, 0331, 0255, 0101, 0021, 0000,
  0074, 0317, 0323, 0046, 0022, 0272, 0352, 0171, 0236, 0346, 0227, 0123, 0311, 0164, 0371, 0260,
  0321, 0130, 0256, 0124, 0337, 0001, 0000, 0024, 0045, 0204, 0350, 0205, 0250, 0314, 0335, 0366,
  0053, 0021, 0000, 0044, 0111, 0312, 0075, 0173, 0236, 0155, 0111, 0222, 0224, 0363, 0313, 0346,
  0244, 0301, 0272, 0272, 0273, 0037, 0014, 0015, 0336, 0002, 0000, 0324, 0353, 0137, 0260, 0365,
  0176, 0313, 0155, 0273, 0174, 0370, 0314, 0035, 0350, 0272, 0306, 0146, 0347, 0246, 0271, 0155,
  0037, 0222, 0343, 0070, 0264, 0263, 0373, 0211, 0246, 0147, 0247, 0270, 0256, 0153, 0214, 0210,
  0072, 0057, 0161, 0134, 0213, 0263, 0251, 0164, 0352, 0157, 0171, 0347, 0043, 0245, 0046, 0115,
  0076, 0256, 0305, 0331, 0157, 0046, 0260, 0074, 0066, 0166, 0377, 0122, 0362, 0211, 0361, 0247,
  0274, 0275, 0135, 0043, 0043, 0371, 0230, 0217, 0306, 0107, 0331, 0111, 0116, 0016, 0272, 0203,
  0266, 0353, 0232, 0003, 0327, 0007, 0144, 0105, 0121, 0260, 0277, 0277, 0207, 0325, 0265, 0125,
  0267, 0151, 0333, 0261, 0225, 0225, 0365, 0362, 0111, 0056, 0120, 0300, 0071, 0017, 0177, 0077,
  0070, 0100, 0255, 0366, 0001, 0205, 0142, 0321, 0265, 0233, 0215, 0130, 0141, 0375, 0145, 0371,
  0064, 0047, 0004, 0375, 0306, 0033, 0043, 0261, 0250, 0160, 0054, 0054, 0000, 0102, 0057, 0341,
  0070, 0361, 0272, 0130, 0332, 0364, 0343, 0002, 0005, 0377, 0072, 0277, 0000, 0342, 0107, 0151,
  0320, 0260, 0266, 0113, 0201, 0000, 0000, 0000, 0000, 0111, 0105, 0116, 0104, 0256, 0102, 0140,
  0202};


/* /usr/share/icons/gnome/16x16/actions/go-previous.png */

static unsigned char left_arrow_data[677] = {
  0211, 0120, 0116, 0107, 0015, 0012, 0032, 0012, 0000, 0000, 0000, 0015, 0111, 0110, 0104, 0122,
  0000, 0000, 0000, 0020, 0000, 0000, 0000, 0020, 0010, 0006, 0000, 0000, 0000, 0037, 0363, 0377,
  0141, 0000, 0000, 0000, 0004, 0163, 0102, 0111, 0124, 0010, 0010, 0010, 0010, 0174, 0010, 0144,
  0210, 0000, 0000, 0000, 0011, 0160, 0110, 0131, 0163, 0000, 0000, 0015, 0327, 0000, 0000, 0015,
  0327, 0001, 0102, 0050, 0233, 0170, 0000, 0000, 0000, 0031, 0164, 0105, 0130, 0164, 0123, 0157,
  0146, 0164, 0167, 0141, 0162, 0145, 0000, 0167, 0167, 0167, 0056, 0151, 0156, 0153, 0163, 0143,
  0141, 0160, 0145, 0056, 0157, 0162, 0147, 0233, 0356, 0074, 0032, 0000, 0000, 0000, 0023, 0164,
  0105, 0130, 0164, 0124, 0151, 0164, 0154, 0145, 0000, 0117, 0160, 0164, 0151, 0143, 0141, 0154,
  0040, 0104, 0162, 0151, 0166, 0145, 0076, 0147, 0272, 0014, 0000, 0000, 0002, 0003, 0111, 0104,
  0101, 0124, 0070, 0215, 0143, 0374, 0377, 0377, 0077, 0003, 0056, 0320, 0331, 0323, 0346, 0315,
  0360, 0217, 0241, 0357, 0077, 0043, 0303, 0113, 0306, 0177, 0377, 0053, 0312, 0313, 0253, 0217,
  0241, 0253, 0141, 0302, 0245, 0271, 0253, 0253, 0075, 0204, 0233, 0213, 0147, 0103, 0132, 0132,
  0206, 0232, 0217, 0247, 0217, 0055, 0003, 0023, 0343, 0104, 0154, 0352, 0130, 0160, 0151, 0346,
  0342, 0341, 0136, 0236, 0030, 0237, 0304, 0302, 0312, 0312, 0306, 0300, 0302, 0302, 0314, 0300,
  0360, 0237, 0341, 0033, 0066, 0265, 0030, 0056, 0100, 0327, 0374, 0354, 0371, 0023, 0206, 0135,
  0173, 0166, 0377, 0141, 0370, 0317, 0320, 0106, 0320, 0000, 0154, 0232, 0067, 0155, 0336, 0364,
  0347, 0307, 0267, 0357, 0221, 0345, 0345, 0125, 0073, 0261, 0372, 0365, 0377, 0377, 0377, 0014,
  0377, 0377, 0377, 0147, 0350, 0354, 0154, 0013, 0231, 0074, 0165, 0342, 0357, 0057, 0137, 0076,
  0377, 0377, 0371, 0363, 0347, 0377, 0373, 0017, 0356, 0376, 0237, 0070, 0271, 0377, 0167, 0147,
  0147, 0133, 0010, 0114, 0015, 0066, 0314, 0302, 0300, 0300, 0300, 0320, 0326, 0326, 0034, 0306,
  0315, 0313, 0275, 0024, 0156, 0363, 0263, 0307, 0014, 0353, 0067, 0256, 0377, 0363, 0365, 0333,
  0327, 0310, 0232, 0312, 0372, 0065, 0375, 0023, 0173, 0033, 0377, 0376, 0375, 0133, 0314, 0314,
  0314, 0334, 0133, 0230, 0137, 0134, 0217, 0314, 0147, 0252, 0151, 0255, 0221, 0375, 0375, 0347,
  0327, 0042, 0053, 0113, 0053, 0026, 0126, 0126, 0066, 0006, 0006, 0006, 0006, 0206, 0035, 0073,
  0267, 0063, 0174, 0372, 0370, 0161, 0152, 0115, 0145, 0375, 0032, 0006, 0006, 0006, 0206, 0277,
  0177, 0377, 0026, 0227, 0024, 0225, 0161, 0377, 0375, 0373, 0267, 0030, 0235, 0317, 0174, 0150,
  0357, 0241, 0117, 0273, 0367, 0356, 0272, 0365, 0370, 0361, 0343, 0100, 0071, 0131, 0071, 0046,
  0076, 0076, 0176, 0006, 0155, 0155, 0135, 0206, 0163, 0347, 0317, 0232, 0154, 0333, 0261, 0365,
  0272, 0263, 0223, 0353, 0265, 0223, 0247, 0116, 0260, 0037, 0075, 0166, 0304, 0204, 0231, 0231,
  0271, 0327, 0322, 0302, 0352, 0000, 0062, 0037, 0356, 0227, 0262, 0262, 0342, 0220, 0206, 0246,
  0272, 0337, 0167, 0356, 0336, 0372, 0377, 0363, 0347, 0317, 0377, 0237, 0077, 0177, 0372, 0337,
  0324, 0322, 0360, 0273, 0254, 0254, 0030, 0157, 0030, 0240, 0160, 0012, 0212, 0163, 0103, 0152,
  0152, 0253, 0176, 0337, 0271, 0163, 0023, 0156, 0110, 0135, 0175, 0315, 0357, 0202, 0342, 0134,
  0234, 0206, 0140, 0010, 0144, 0345, 0146, 0205, 0224, 0127, 0226, 0376, 0276, 0175, 0373, 0006,
  0334, 0220, 0312, 0352, 0362, 0337, 0231, 0271, 0231, 0336, 0330, 0014, 0300, 0110, 0110, 0123,
  0047, 0115, 0135, 0363, 0341, 0335, 0373, 0310, 0031, 0063, 0147, 0376, 0171, 0370, 0360, 0076,
  0003, 0053, 0053, 0053, 0103, 0154, 0164, 0054, 0313, 0337, 0077, 0277, 0373, 0210, 0112, 0211,
  0014, 0014, 0014, 0014, 0063, 0146, 0314, 0136, 0363, 0356, 0303, 0333, 0310, 0051, 0323, 0246,
  0376, 0271, 0172, 0365, 0062, 0303, 0353, 0067, 0157, 0030, 0176, 0377, 0372, 0375, 0022, 0233,
  0132, 0106, 0174, 0271, 0061, 0056, 0056, 0332, 0375, 0077, 0023, 0103, 0025, 0043, 0003, 0003,
  0327, 0177, 0246, 0177, 0371, 0213, 0347, 0055, 0307, 0310, 0215, 0170, 0015, 0040, 0006, 0000,
  0000, 0004, 0240, 0165, 0354, 0235, 0304, 0333, 0013, 0000, 0000, 0000, 0000, 0111, 0105, 0116,
  0104, 0256, 0102, 0140, 0202};


/* /usr/share/gtk-doc/html/libgnomeui/stock_menu_blank.png */

static unsigned char blank_data[253] = {
  0211, 0120, 0116, 0107, 0015, 0012, 0032, 0012, 0000, 0000, 0000, 0015, 0111, 0110, 0104, 0122,
  0000, 0000, 0000, 0020, 0000, 0000, 0000, 0020, 0010, 0002, 0000, 0000, 0000, 0220, 0221, 0150,
  0066, 0000, 0000, 0000, 0006, 0164, 0122, 0116, 0123, 0000, 0000, 0000, 0000, 0000, 0000, 0156,
  0246, 0007, 0221, 0000, 0000, 0000, 0006, 0142, 0113, 0107, 0104, 0000, 0275, 0000, 0275, 0000,
  0275, 0151, 0102, 0325, 0250, 0000, 0000, 0000, 0020, 0111, 0104, 0101, 0124, 0170, 0332, 0143,
  0140, 0030, 0005, 0243, 0140, 0024, 0300, 0000, 0000, 0003, 0020, 0000, 0001, 0327, 0055, 0204,
  0143, 0000, 0000, 0000, 0105, 0172, 0124, 0130, 0164, 0123, 0157, 0146, 0164, 0167, 0141, 0162,
  0145, 0000, 0000, 0170, 0332, 0163, 0320, 0120, 0326, 0364, 0314, 0115, 0114, 0117, 0365, 0115,
  0114, 0317, 0114, 0316, 0126, 0060, 0321, 0063, 0320, 0063, 0121, 0260, 0264, 0320, 0067, 0060,
  0321, 0067, 0060, 0124, 0110, 0056, 0312, 0054, 0056, 0251, 0164, 0050, 0256, 0314, 0055, 0110,
  0054, 0311, 0114, 0316, 0327, 0313, 0057, 0112, 0007, 0000, 0174, 0152, 0017, 0371, 0170, 0366,
  0024, 0302, 0000, 0000, 0000, 0063, 0172, 0124, 0130, 0164, 0123, 0151, 0147, 0156, 0141, 0164,
  0165, 0162, 0145, 0000, 0000, 0170, 0332, 0063, 0110, 0063, 0066, 0061, 0116, 0062, 0260, 0064,
  0066, 0064, 0064, 0062, 0113, 0064, 0062, 0110, 0063, 0064, 0066, 0116, 0061, 0063, 0117, 0066,
  0112, 0062, 0060, 0264, 0110, 0064, 0116, 0002, 0000, 0200, 0262, 0010, 0020, 0207, 0362, 0015,
  0215, 0000, 0000, 0000, 0000, 0111, 0105, 0116, 0104, 0256, 0102, 0140, 0202};


typedef struct {unsigned char *png; int loc;} png_info;

static cairo_status_t png_read(void *closure, unsigned char *data, unsigned int size)
{
  /* put the next size bytes in data from whatever we're reading */
  png_info *p = (png_info *)closure;
  memcpy((void *)data, (void *)(p->png + p->loc), size);
  p->loc += size;
  return(CAIRO_STATUS_SUCCESS);
}

static cairo_surface_t *png_to_surface(unsigned char *png_data)
{
  png_info *p;
  p = (png_info *)malloc(sizeof(png_info));
  p->png = png_data;
  p->loc = 0;
  return(cairo_image_surface_create_from_png_stream((cairo_read_func_t)png_read, (void *)p));
}


static cairo_surface_t *lock_icon = NULL, *stop_icon = NULL, *bomb_icon = NULL, *right_arrow_icon = NULL;
static cairo_surface_t *left_arrow_icon = NULL, *blank_icon = NULL, *speaker_icon = NULL;

cairo_surface_t *snd_icon(int which)
{
  switch (which)
    {
    case SND_PNG_LOCK: 
      if (!lock_icon)
	lock_icon = png_to_surface(lock_data);
      return(lock_icon);
      break;

    case SND_PNG_STOP:
      if (!stop_icon)
	stop_icon = png_to_surface(stop_data);
      return(stop_icon);
      break;

    case SND_PNG_BLANK:
      if (!blank_icon)
	blank_icon = png_to_surface(blank_data);
      return(blank_icon);
      break;

    case SND_PNG_RIGHT_ARROW:
      if (!right_arrow_icon)
	right_arrow_icon = png_to_surface(right_arrow_data);
      return(right_arrow_icon);
      break;

    case SND_PNG_LEFT_ARROW:
      if (!left_arrow_icon)
	left_arrow_icon = png_to_surface(left_arrow_data);
      return(left_arrow_icon);
      break;

    case SND_PNG_BOMB:
      if (!bomb_icon)
	bomb_icon = png_to_surface(bomb_data);
      return(bomb_icon);
      break;

    case SND_PNG_SPEAKER:
      if (!speaker_icon)
	speaker_icon = png_to_surface(speaker_data);
      return(speaker_icon);
      break;
    }
  
  return(NULL);
}

#endif
