/* Public domain. */

#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>
#include "tai.h"

int timeval_from_tai (struct timeval *tv, struct tai const *t)
{
  time_t x = tai_sec(t) - TAI_MAGIC ;
  if (x < 0) return (errno = EINVAL, 0) ;
  tv->tv_sec = x ;
  tv->tv_usec = 0 ;
  return 1 ;
}
