//<-- CLI SHELL MODE -->
// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2012 - DIGITEO - Allan CORNET
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
//
// <-- Non-regression test for bug 10574 -->
//
// <-- GitLab URL -->
//https://gitlab.com/scilab/scilab/-/issues/10574
//
// <-- Short Description -->
// Runge-Kutta-Method failed for vector [x, 1] with x > 9

dt = 0.25;
a = 1;
b = a/dt;
t = 0:dt:a;
t0 = t(1);
St = size(t);
Dim = 18;
x = ones(Dim, 1);
X = eye(Dim,Dim);

function xdot = Test(t, x)
  xdot = X * x;
endfunction

x = ode('rk', x, t0, t, Test);
assert_checkequal(size(x), [18 5]);

REF_X = [    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818];

assert_checkalmostequal(x, REF_X, 0, 1e-7);


Dim = 9;
x = ones(Dim, 1);
X = eye(Dim, Dim);
x = ode('rk', x, t0, t, Test);
assert_checkequal(size(x), [9 5]);


REF_X = [    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818; ..
    1.    1.2840254    1.6487213    2.117    2.7182818];

assert_checkalmostequal(x, REF_X, 0, 1e-7);
