/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file XMLParser.h
    \author Romain BONDUE
    \date 03/08/2006 */
#ifndef __XMLPARSER_H__
#define __XMLPARSER_H__

#include <string>

extern "C"{
#include <glib.h>
}

#include "Exceptions.h"



namespace nsUserData
{
    extern const char* const XMLHeader;
    const char Markup1B = '<';  // B for Begin.
    const char Markup1E = '>';  // E for End;
    extern const char* const Markup2B;
    extern const char* const Markup2E;


    class CXMLParser
    {
      public :
        virtual ~CXMLParser () throw();
            /* If the file doesn't exist, it's not considered as an error.
               Nothing is done. */
        void Extract (const std::string&) throw (nsErrors::CException);


      protected :
        virtual void StartElement (const char*, const char**, const char**)
                                throw (std::bad_alloc, nsErrors::CException);
        virtual void EndElement (const char*) throw (nsErrors::CException);
        virtual void Text (const char*, const std::string&)
                                                throw (nsErrors::CException);
        virtual void Error () throw();


      private :
        static void _StartElement (::GMarkupParseContext*, const char*,
                                   const char**, const char**,
                                   CXMLParser*, ::GError**) throw();
        static void _EndElement (::GMarkupParseContext*, const char*,
                                 CXMLParser*, ::GError**) throw();
        static void _Text (::GMarkupParseContext*, const char*, ::gsize,
                           CXMLParser*, ::GError**) throw();
        /*static void Ignored (::GMarkupParseContext*, const char*, unsigned,
                               CXMLParser*, ::GError**) throw();*/
        static void _Error (::GMarkupParseContext*, ::GError*,
                            CXMLParser*) throw();

    }; // CXMLParser

} // namespace nsUserData

#include "private/XMLParser.hxx"

#endif // __XMLPARSER_H__
