% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result.R
\name{dbFetch,MySQLResult,numeric-method}
\alias{dbFetch,MySQLResult,numeric-method}
\alias{fetch,MySQLResult,numeric-method}
\alias{dbFetch,MySQLResult,missing-method}
\alias{fetch,MySQLResult,missing-method}
\alias{dbSendQuery,MySQLConnection,character-method}
\alias{dbClearResult,MySQLResult-method}
\alias{dbGetInfo,MySQLResult-method}
\alias{dbGetStatement,MySQLResult-method}
\alias{dbListFields,MySQLResult,missing-method}
\title{Execute a SQL statement on a database connection.}
\usage{
\S4method{dbFetch}{MySQLResult,numeric}(res, n = -1, ...)

\S4method{fetch}{MySQLResult,numeric}(res, n = -1, ...)

\S4method{dbFetch}{MySQLResult,missing}(res, n = -1, ...)

\S4method{fetch}{MySQLResult,missing}(res, n = -1, ...)

\S4method{dbSendQuery}{MySQLConnection,character}(conn, statement)

\S4method{dbClearResult}{MySQLResult}(res, ...)

\S4method{dbGetInfo}{MySQLResult}(dbObj, what = "", ...)

\S4method{dbGetStatement}{MySQLResult}(res, ...)

\S4method{dbListFields}{MySQLResult,missing}(conn, name, ...)
}
\arguments{
\item{res, dbObj}{A  \code{\linkS4class{MySQLResult}} object.}

\item{n}{maximum number of records to retrieve per fetch. Use \code{-1} to
retrieve all pending records; use \code{0} for to fetch the default
number of rows as defined in \code{\link{MySQL}}}

\item{...}{Unused. Needed for compatibility with generic.}

\item{conn}{an \code{\linkS4class{MySQLConnection}} object.}

\item{statement}{a character vector of length one specifying the SQL
statement that should be executed.  Only a single SQL statment should be
provided.}

\item{what}{optional}

\item{name}{Table name.}
}
\description{
To retrieve results a chunk at a time, use \code{dbSendQuery},
\code{dbFetch}, then \code{dbClearResult}. Alternatively, if you want all the
results (and they'll fit in memory) use \code{dbGetQuery} which sends,
fetches and clears for you.
}
\details{
\code{fetch()} will be deprecated in the near future; please use
\code{dbFetch()} instead.
}
\examples{
if (mysqlHasDefault()) {
con <- dbConnect(RMySQL::MySQL(), dbname = "test")
dbWriteTable(con, "arrests", datasets::USArrests, overwrite = TRUE)

# Run query to get results as dataframe
dbGetQuery(con, "SELECT * FROM arrests limit 3")

# Send query to pull requests in batches
res <- dbSendQuery(con, "SELECT * FROM arrests")
data <- dbFetch(res, n = 2)
data
dbHasCompleted(res)

dbListResults(con)
dbClearResult(res)
dbRemoveTable(con, "arrests")
dbDisconnect(con)
}
}
